/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.GlobalDefaults;
import java.awt.Color;

public class ColorUtilities {
    private static GlobalDefaults defaults = new GlobalDefaults();

    public static Color brighter(Color c) {
        return ColorUtilities.brighter(c, ColorUtilities.defaults.defaultColorAdjust);
    }

    public static Color brighter(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newBrightness = brightness + brightness * (float)percentage;
        newBrightness = (float)Math.min(1.0, (double)newBrightness);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static Color darker(Color c) {
        return ColorUtilities.darker(c, ColorUtilities.defaults.defaultColorAdjust);
    }

    public static Color darker(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newBrightness = brightness - brightness * (float)percentage;
        newBrightness = (float)Math.max(0.0, (double)newBrightness);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static Color softer(Color c) {
        return ColorUtilities.softer(c, ColorUtilities.defaults.defaultColorAdjust);
    }

    public static Color softer(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newSat = saturation - saturation * (float)percentage;
        newSat = (float)Math.max(0.0, (double)newSat);
        return Color.getHSBColor(hue, newSat, brightness);
    }

    public static Color sharper(Color c) {
        return ColorUtilities.sharper(c, ColorUtilities.defaults.defaultColorAdjust);
    }

    public static Color sharper(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newSat = saturation + saturation * (float)percentage;
        newSat = (float)Math.min(1.0, (double)newSat);
        return Color.getHSBColor(hue, newSat, brightness);
    }

    public static Color setSB(Color c, double satVal, double brightVal) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        if ((double)saturation > 0.01) {
            return Color.getHSBColor(hue, (float)satVal, (float)brightVal);
        }
        return Color.getHSBColor(hue, saturation, (float)brightVal);
    }
}

