/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.Search;
import com.sas.graphics.util.Sort;
import java.awt.Color;
import java.util.List;
import java.util.Vector;

public class ColorRamp
implements ColorInterface,
CompareInterface {
    private static Color[] defaultColors = new Color[]{new Color(1.0f, 0.0f, 1.0f), new Color(0.78f, 0.39f, 0.39f), new Color(0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f), new Color(1.0f, 0.39f, 0.0f), new Color(1.0f, 0.0f, 0.0f)};
    protected boolean isChar;
    protected boolean ignoreCase;
    protected boolean binning;
    protected long flags;
    protected double minBreak;
    protected double maxBreak;
    protected Color missingColor;
    protected Color underflowColor;
    protected Color overflowColor;
    protected Vector breakPoints;
    protected Vector exceptionPoints;
    protected DynamicIntArray sortIndicies;
    protected DynamicIntArray exceptionSortIndicies;

    public ColorRamp(Object colors, Object breaks, long flagsIn) {
        this.binning = false;
        this.setup(flagsIn);
        this.setColors(colors, breaks);
    }

    public ColorRamp(Object colors, Object min, Object max, long flagsIn) {
        this.setup(flagsIn);
        this.setColors(colors, min, max);
    }

    public ColorRamp(Object colors, double min, double max, long flagsIn) {
        this.setup(flagsIn);
        this.setColors(colors, min, max);
    }

    public ColorRamp() {
        this(null, null, 0L);
    }

    protected void setup(long flagsIn) {
        this.isChar = false;
        this.ignoreCase = false;
        this.flags = flagsIn;
        this.missingColor = Color.black;
        this.underflowColor = Color.white;
        this.overflowColor = Color.cyan;
        this.minBreak = 0.0;
        this.maxBreak = 1.0;
        this.breakPoints = new Vector();
        if (this.breakPoints == null) {
            throw new OutOfMemoryError();
        }
        this.sortIndicies = new DynamicIntArray(20);
        if (this.sortIndicies == null) {
            throw new OutOfMemoryError();
        }
        this.exceptionPoints = new Vector();
        if (this.exceptionPoints == null) {
            throw new OutOfMemoryError();
        }
        this.exceptionSortIndicies = new DynamicIntArray(20);
        if (this.exceptionSortIndicies == null) {
            throw new OutOfMemoryError();
        }
    }

    public double getNumericElement(Object entry) {
        return (Double)((ColorBreak)entry).value;
    }

    public String getStringElement(Object entry) {
        return (String)((ColorBreak)entry).value;
    }

    protected int intValue(Vector v, int idx) {
        return (Integer)v.elementAt(idx);
    }

    protected void clearAllBreakPoints(Vector points, DynamicIntArray indicies) {
        points.removeAllElements();
        indicies.removeAll();
    }

    protected boolean addBreak(int idx, Object value, Object color, Vector breaks, DynamicIntArray indicies) {
        if (value == null || color == null || breaks == null || indicies == null) {
            return false;
        }
        Color c = (Color)color;
        if (!(value instanceof String) && !(value instanceof Number)) {
            return false;
        }
        if (breaks.size() > 0) {
            if (this.isChar && value instanceof Number) {
                return false;
            }
            if (!this.isChar && value instanceof String) {
                return false;
            }
        } else {
            this.isChar = value instanceof String;
        }
        switch (idx) {
            case -1: {
                breaks.addElement(new ColorBreak(value, color));
                break;
            }
            case -2: {
                breaks.setElementAt(new ColorBreak(value, c), 0);
                break;
            }
            case -3: {
                idx = Search.binarylookup((Object)value, (Vector)breaks, (int[])indicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) {
                    breaks.setElementAt(new ColorBreak(value, c), idx);
                    return true;
                }
                idx = -idx - 1;
                breaks.insertElementAt(new ColorBreak(value, c), idx);
                break;
            }
            default: {
                if (idx < 0 || idx >= breaks.size()) {
                    return false;
                }
                breaks.setElementAt(new ColorBreak(value, c), idx);
            }
        }
        indicies.add(breaks.size() - 1);
        if (this.isChar) {
            Sort.heapsort(String.class, (List)breaks, (int[])indicies.getElements(), (int)-1, (CompareInterface)this);
        } else {
            Sort.heapsort(Double.class, (List)breaks, (int[])indicies.getElements(), (int)-1, (CompareInterface)this);
        }
        if (!this.isChar) {
            if (indicies.getNumberElements() == 1) {
                ColorBreak cb = (ColorBreak)breaks.elementAt(indicies.get(0));
                if (cb != null) {
                    this.minBreak = this.maxBreak = ((Number)cb.value).doubleValue();
                }
            } else if (indicies.getNumberElements() > 1) {
                ColorBreak cb = (ColorBreak)breaks.elementAt(indicies.get(0));
                if (cb != null) {
                    this.minBreak = ((Number)cb.value).doubleValue();
                }
                if ((cb = (ColorBreak)breaks.elementAt(indicies.get(indicies.getNumberElements() - 1))) != null) {
                    this.maxBreak = ((Number)cb.value).doubleValue();
                }
            }
        }
        return true;
    }

    protected boolean delBreak(int idx, Vector breaks, DynamicIntArray indicies) {
        if (idx < 0 || idx >= breaks.size()) {
            return false;
        }
        int delIdx = indicies.get(idx);
        breaks.removeElementAt(idx);
        indicies.removeAt(idx);
        for (int i = 0; i < indicies.getNumberElements(); ++i) {
            int curIdx = indicies.get(i);
            if (curIdx < delIdx) continue;
            indicies.setAt(curIdx - 1, i);
        }
        return true;
    }

    protected double clampColor(int cc) {
        double c = (double)cc / 255.0;
        if (c < 0.0) {
            c = 0.0;
        } else if (c > 1.0) {
            c = 1.0;
        }
        return c;
    }

    protected Color interpolate(ColorBreak cb1, ColorBreak cb2, double v, boolean discrete) {
        if (cb1 == null || cb2 == null) {
            return null;
        }
        double v1 = ((Number)cb1.value).doubleValue();
        double v2 = ((Number)cb2.value).doubleValue();
        double fraction = (v - v1) / (v2 - v1);
        if (discrete) {
            if (fraction < 0.5) {
                return cb1.color;
            }
            return cb2.color;
        }
        double r1 = this.clampColor(cb1.color.getRed());
        double g1 = this.clampColor(cb1.color.getGreen());
        double b1 = this.clampColor(cb1.color.getBlue());
        double r2 = this.clampColor(cb2.color.getRed());
        double g2 = this.clampColor(cb2.color.getGreen());
        double b2 = this.clampColor(cb2.color.getBlue());
        float r = (float)((r2 - r1) * fraction + r1);
        float g = (float)((g2 - g1) * fraction + g1);
        float b = (float)((b2 - b1) * fraction + b1);
        return new Color(r, g, b);
    }

    protected int setColors(Object colors, Object breaks, Vector breaksTarget, DynamicIntArray sortTarget, boolean exceptions) {
        int nBreaks;
        int n;
        int i;
        int nDone = 0;
        int clrType = 0;
        int brkType = 0;
        double[] defaultBreaks = null;
        if (exceptions && (breaks == null || colors == null)) {
            return 0;
        }
        if (colors == null) {
            colors = defaultColors;
        }
        clrType = Extract.getSourceType((Object)colors);
        int nColors = Extract.getNumberItems((Object)colors, (int)clrType);
        if (breaks == null) {
            defaultBreaks = new double[nColors];
            breaks = defaultBreaks;
            if (defaultBreaks != null) {
                for (i = 0; i < nColors; ++i) {
                    defaultBreaks[i] = (double)i / (double)(nColors - 1);
                }
            }
        }
        if ((n = Math.min(nColors, nBreaks = Extract.getNumberItems((Object)breaks, (int)(brkType = Extract.getSourceType((Object)breaks))))) <= 0) {
            return nDone;
        }
        this.clearAllBreakPoints(breaksTarget, sortTarget);
        if (!exceptions) {
            this.isChar = false;
            this.minBreak = 0.0;
            this.maxBreak = 1.0;
        }
        for (i = 0; i < n; ++i) {
            if (!this.addBreak(-1, Extract.getObject((Object)breaks, (int)i, (int)brkType), Extract.getColor((Object)colors, (int)i, (int)clrType), breaksTarget, sortTarget)) continue;
            ++nDone;
        }
        if (nBreaks - 1 == nColors) {
            this.addBreak(-1, Extract.getObject((Object)breaks, (int)(nBreaks - 1), (int)brkType), Extract.getColor((Object)colors, (int)(nColors - 1), (int)clrType), breaksTarget, sortTarget);
            this.binning = true;
        }
        return nDone;
    }

    @Override
    public long getMasks() {
        return this.flags;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return this.flags;
    }

    @Override
    public Object[] getBreaks() {
        ColorBreak cb = null;
        Object[] out = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return null;
        }
        int n = this.breakPoints.size();
        out = new Object[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (ColorBreak)this.breakPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.value;
        }
        return out;
    }

    @Override
    public Object[] getExceptions() {
        ColorBreak cb = null;
        Object[] out = null;
        if (this.exceptionPoints == null || this.exceptionPoints.size() <= 0) {
            return null;
        }
        int n = this.exceptionPoints.size();
        out = new Object[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (ColorBreak)this.exceptionPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.value;
        }
        return out;
    }

    @Override
    public Color[] getColors() {
        ColorBreak cb = null;
        Color[] out = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return null;
        }
        int n = this.breakPoints.size();
        out = new Color[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (ColorBreak)this.breakPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.color;
        }
        return out;
    }

    @Override
    public Color[] getExceptionColors() {
        ColorBreak cb = null;
        Color[] out = null;
        if (this.exceptionPoints == null || this.exceptionPoints.size() <= 0) {
            return null;
        }
        int n = this.exceptionPoints.size();
        out = new Color[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (ColorBreak)this.exceptionPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.color;
        }
        return out;
    }

    @Override
    public int setColors(Object colors, Object breaks) {
        return this.setColors(colors, breaks, this.breakPoints, this.sortIndicies, false);
    }

    @Override
    public int setExceptionColors(Object colors, Object breaks) {
        return this.setColors(colors, breaks, this.exceptionPoints, this.exceptionSortIndicies, true);
    }

    @Override
    public int setColors(Object colors, Object min, Object max) {
        if (min == null || max == null || !(min instanceof Number) || !(max instanceof Number)) {
            return 0;
        }
        return this.setColors(colors, ((Number)min).doubleValue(), ((Number)max).doubleValue());
    }

    @Override
    public int setColors(Object colors, double min, double max) {
        double[] darray = null;
        if (Double.isInfinite(min) || Double.isInfinite(max) || Double.isNaN(min) || Double.isNaN(max)) {
            return 0;
        }
        int n = colors == null ? defaultColors.length : Extract.getNumberItems((Object)colors, (int)Extract.getSourceType((Object)colors));
        if (n <= 0) {
            return 0;
        }
        darray = new double[n];
        if (darray == null) {
            return 0;
        }
        darray[0] = min;
        darray[n - 1] = max;
        for (int i = 1; i < n - 1; ++i) {
            darray[i] = (double)i / (double)(n - 1) * (max - min) + min;
        }
        return this.setColors(colors, darray);
    }

    @Override
    public int setColors(Object colors) {
        ColorBreak cb = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return -1;
        }
        cb = (ColorBreak)this.breakPoints.elementAt(0);
        if (cb == null) {
            return -1;
        }
        Object min = cb.value;
        cb = (ColorBreak)this.breakPoints.elementAt(this.breakPoints.size() - 1);
        if (cb == null) {
            return -1;
        }
        Object max = cb.value;
        return this.setColors(colors, min, max);
    }

    @Override
    public boolean setRange(Object min, Object max) {
        Color[] clrs = this.getColors();
        if (clrs == null) {
            return false;
        }
        return this.setColors((Object)clrs, min, max) == clrs.length;
    }

    @Override
    public boolean setRange(double min, double max) {
        Color[] clrs = this.getColors();
        if (clrs == null) {
            return false;
        }
        return this.setColors((Object)clrs, min, max) == clrs.length;
    }

    @Override
    public Color query(int index, boolean wrap, int[] rgb) {
        ColorBreak cb;
        boolean sortedGet = (this.flags & 1L) != 0L;
        int idx = index;
        if (index < 0) {
            return null;
        }
        if (wrap) {
            idx %= this.breakPoints.size();
        }
        if (idx >= this.breakPoints.size()) {
            return null;
        }
        if (sortedGet) {
            idx = this.sortIndicies.get(idx);
        }
        if ((cb = (ColorBreak)this.breakPoints.elementAt(idx)) == null) {
            return null;
        }
        if (rgb != null && rgb.length >= 3 && cb.color != null) {
            rgb[0] = cb.color.getRed();
            rgb[1] = cb.color.getGreen();
            rgb[2] = cb.color.getBlue();
        }
        return cb.color;
    }

    @Override
    public Color query(Object breakValue, boolean discrete, int[] rgb) {
        boolean fillRGB = false;
        Number dObj = null;
        Color c = null;
        ColorBreak cb1 = null;
        ColorBreak cb2 = null;
        if (breakValue == null) {
            return null;
        }
        if (rgb != null && rgb.length >= 3) {
            fillRGB = true;
        } else {
            if (this.isChar && breakValue instanceof Number) {
                return null;
            }
            if (!this.isChar && breakValue instanceof String) {
                return null;
            }
            if (breakValue instanceof String) {
                int idx = Search.binarylookup((Object)breakValue, (Vector)this.exceptionPoints, (int[])this.exceptionSortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) {
                    cb1 = (ColorBreak)this.exceptionPoints.elementAt(idx);
                    if (cb1 == null) {
                        return null;
                    }
                    if (fillRGB) {
                        rgb[0] = cb1.color.getRed();
                        rgb[1] = cb1.color.getGreen();
                        rgb[2] = cb1.color.getBlue();
                    }
                    return cb1.color;
                }
                idx = Search.binarylookup((Object)breakValue, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx < 0) {
                    return null;
                }
                cb1 = (ColorBreak)this.breakPoints.elementAt(idx);
                if (cb1 == null) {
                    return null;
                }
                if (fillRGB) {
                    rgb[0] = cb1.color.getRed();
                    rgb[1] = cb1.color.getGreen();
                    rgb[2] = cb1.color.getBlue();
                }
                return cb1.color;
            }
            if (breakValue instanceof Number) {
                dObj = (Number)breakValue;
            } else {
                return null;
            }
        }
        if (dObj instanceof Double && ((Double)dObj).isNaN()) {
            if (fillRGB) {
                rgb[0] = this.missingColor.getRed();
                rgb[1] = this.missingColor.getGreen();
                rgb[2] = this.missingColor.getBlue();
            }
            return this.missingColor;
        }
        if (dObj instanceof Double && ((Double)dObj).isInfinite()) {
            c = dObj.doubleValue() == Double.NEGATIVE_INFINITY ? this.underflowColor : this.overflowColor;
            if (fillRGB) {
                rgb[0] = c.getRed();
                rgb[1] = c.getGreen();
                rgb[2] = c.getBlue();
            }
            return c;
        }
        int idx = Search.binarylookup((Object)dObj, (Vector)this.exceptionPoints, (int[])this.exceptionSortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
        if (idx >= 0) {
            cb1 = (ColorBreak)this.exceptionPoints.elementAt(idx);
            if (cb1 == null) {
                return null;
            }
            if (fillRGB) {
                rgb[0] = cb1.color.getRed();
                rgb[1] = cb1.color.getGreen();
                rgb[2] = cb1.color.getBlue();
            }
            return cb1.color;
        }
        idx = Search.binarylookup((Object)dObj, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
        if (idx < 0) {
            if ((idx = -idx - 1) <= 0) {
                return this.underflowColor;
            }
            if (idx >= this.breakPoints.size()) {
                return this.overflowColor;
            }
            cb1 = (ColorBreak)this.breakPoints.elementAt(idx - 1);
            cb2 = (ColorBreak)this.breakPoints.elementAt(idx);
            c = this.binning ? cb1.color : this.interpolate(cb1, cb2, dObj.doubleValue(), discrete);
            if (fillRGB && c != null) {
                rgb[0] = c.getRed();
                rgb[1] = c.getGreen();
                rgb[2] = c.getBlue();
            }
            return c;
        }
        cb1 = (ColorBreak)this.breakPoints.elementAt(idx);
        if (cb1 == null) {
            return null;
        }
        if (fillRGB) {
            rgb[0] = cb1.color.getRed();
            rgb[1] = cb1.color.getGreen();
            rgb[2] = cb1.color.getBlue();
        }
        return cb1.color;
    }

    @Override
    public Color queryDouble(double breakValue, boolean discrete, int[] rgb) {
        return this.query(new Double(breakValue), discrete, rgb);
    }

    @Override
    public Color queryDouble(double response, double low, double high, boolean discrete, int[] rgb) {
        if (Double.isNaN(response) || Double.isNaN(low) || Double.isNaN(high) || high <= low) {
            return this.queryDouble(Double.NaN, discrete, rgb);
        }
        double value = response;
        if (low != this.minBreak || high != this.maxBreak) {
            value = (this.maxBreak - this.minBreak) * ((response - low) / (high - low)) + this.minBreak;
        }
        return this.queryDouble(value, discrete, rgb);
    }

    @Override
    public Color query(Object response, Object low, Object high, boolean discrete, int[] rgb) {
        if (!(response != null && low != null && high != null && response instanceof Double && low instanceof Double && high instanceof Double)) {
            return null;
        }
        return this.queryDouble((((Number)response).doubleValue() - ((Number)low).doubleValue()) / (((Number)high).doubleValue() - ((Number)low).doubleValue()), discrete, rgb);
    }

    @Override
    public int getNumberColors() {
        if (this.breakPoints == null) {
            return 0;
        }
        return this.breakPoints.size();
    }

    @Override
    public int getNumberExceptionColors() {
        if (this.exceptionPoints == null) {
            return 0;
        }
        return this.exceptionPoints.size();
    }

    @Override
    public Color getUnderflowColor() {
        return this.underflowColor;
    }

    @Override
    public boolean setUnderflowColor(Color underColor) {
        if (underColor == null) {
            return false;
        }
        this.underflowColor = underColor;
        return true;
    }

    @Override
    public Color getOverflowColor() {
        return this.overflowColor;
    }

    @Override
    public boolean setOverflowColor(Color overColor) {
        if (overColor == null) {
            return false;
        }
        this.overflowColor = overColor;
        return true;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColor;
    }

    @Override
    public boolean setMissingColor(Color missColor) {
        if (missColor == null) {
            return false;
        }
        this.missingColor = missColor;
        return true;
    }

    @Override
    public boolean setBreakPoint(int idx, Object value, Object c) {
        return this.addBreak(idx, value, c, this.breakPoints, this.sortIndicies);
    }

    @Override
    public boolean setExceptionBreakPoint(int idx, Object value, Object c) {
        return this.addBreak(idx, value, c, this.exceptionPoints, this.exceptionSortIndicies);
    }

    @Override
    public boolean removeBreakPoint(int idx, Object value, boolean nearest) {
        switch (idx) {
            case -3: {
                idx = Search.binarylookup((Object)value, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) break;
                if (nearest && !this.isChar) {
                    if ((idx = -idx - 1) == 0) break;
                    if (idx == this.breakPoints.size()) {
                        --idx;
                        break;
                    }
                    ColorBreak cb1 = (ColorBreak)this.breakPoints.elementAt(idx - 1);
                    ColorBreak cb2 = (ColorBreak)this.breakPoints.elementAt(idx);
                    if (cb1 == null || cb2 == null) {
                        return false;
                    }
                    double v1 = ((Number)cb1.value).doubleValue();
                    double v2 = ((Number)cb2.value).doubleValue();
                    double v = ((Number)value).doubleValue();
                    double fraction = (v - v1) / (v2 - v1);
                    if (!(fraction < 0.5)) break;
                    --idx;
                    break;
                }
                return false;
            }
        }
        return this.delBreak(idx, this.breakPoints, this.sortIndicies);
    }

    @Override
    public boolean removeExceptionBreakPoint(int idx, Object value, boolean nearest) {
        switch (idx) {
            case -3: {
                idx = Search.binarylookup((Object)value, (Vector)this.exceptionPoints, (int[])this.exceptionSortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) break;
                if (nearest && !this.isChar) {
                    if ((idx = -idx - 1) == 0) break;
                    if (idx == this.exceptionPoints.size()) {
                        --idx;
                        break;
                    }
                    ColorBreak cb1 = (ColorBreak)this.exceptionPoints.elementAt(idx - 1);
                    ColorBreak cb2 = (ColorBreak)this.exceptionPoints.elementAt(idx);
                    if (cb1 == null || cb2 == null) {
                        return false;
                    }
                    double v1 = ((Number)cb1.value).doubleValue();
                    double v2 = ((Number)cb2.value).doubleValue();
                    double v = ((Number)value).doubleValue();
                    double fraction = (v - v1) / (v2 - v1);
                    if (!(fraction < 0.5)) break;
                    --idx;
                    break;
                }
                return false;
            }
        }
        return this.delBreak(idx, this.exceptionPoints, this.exceptionSortIndicies);
    }

    @Override
    public Color decodeRGBColor(double r, double g, double b) {
        if (r < 0.0) {
            r = 0.0;
        } else if (r > 1.0) {
            r = 1.0;
        }
        if (g < 0.0) {
            g = 0.0;
        } else if (g > 1.0) {
            g = 1.0;
        }
        if (b < 0.0) {
            b = 0.0;
        } else if (b > 1.0) {
            b = 1.0;
        }
        return new Color((float)r, (float)g, (float)b);
    }

    @Override
    public Color decodeLongColor(long color) {
        return new Color(color >> 16 & 0xFFL, color >> 8 & 0xFFL, (float)(color & 0xFFL));
    }

    @Override
    public long encodeLongColor(Color c) {
        if (c == null) {
            return -1L;
        }
        long out = c.getRed() << 16 + c.getGreen() << 8 + c.getBlue();
        return out;
    }

    class ColorBreak {
        public Object value;
        public Color color;

        public ColorBreak(Object valueIn, Object colorIn) {
            this.value = valueIn;
            if (colorIn instanceof Color) {
                this.color = (Color)colorIn;
            } else if (colorIn instanceof String) {
                this.color = ColorParse.getColorFromString((String)((String)colorIn));
            }
        }
    }
}

