/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleUtils;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class ColorMapper
implements PropertyChangeListener {
    private Color minColor;
    private Color neutralColor;
    private Color maxColor;
    private double minValue = 0.0;
    private double neutralValue = 0.5;
    private double maxValue = 1.0;
    private Color missingColor;
    private Color underflowColor;
    private Color overlflowColor;
    private String id;
    private boolean zeroCenter;
    private String styleReference;
    private RangeMerger rangeMerger;
    private Vector listeners = null;
    private EventListenerList propertyListeners = null;
    private static Hashtable instances = new Hashtable();

    public static ColorMapper getInstance(String id) {
        if (id == null) {
            return null;
        }
        if (instances.containsKey(id)) {
            return (ColorMapper)instances.get(id);
        }
        ColorMapper mapper = new ColorMapper(id);
        if (StyleUtils.isRampContextName((String)id)) {
            mapper.applyStyle((Style)SILKGlobal.getInstance().getPropertyValue(29), id);
        }
        instances.put(id, mapper);
        return mapper;
    }

    private ColorMapper(String id) {
        this.applyStyle((Style)SILKGlobal.getInstance().getPropertyValue(29), "ThreeColorRamp");
        this.setId(id);
        this.setValues(0.0, 0.5, 1.0);
        this.zeroCenter = true;
    }

    public static String[] getDefinedColorMappers() {
        String[] rc = new String[instances.size()];
        Enumeration e = instances.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            rc[i++] = e.nextElement().toString();
        }
        return rc;
    }

    public void register(CellItemInterface range) {
        if (this.rangeMerger == null) {
            this.rangeMerger = new RangeMerger(4);
            this.rangeMerger.addPropertyChangeListener(this);
            this.listeners = new Vector();
        }
        if (this.listeners.contains(range)) {
            return;
        }
        this.listeners.addElement(range);
        this.rangeMerger.addRangeItem(range);
    }

    public void unRegister(CellItemInterface range) {
        if (this.listeners != null) {
            this.listeners.removeElement(range);
        }
        if (this.rangeMerger != null) {
            this.rangeMerger.removeRangeItem(range);
        }
    }

    public void applyStyle(Style style, String styleReference) {
        if (style == null || styleReference == null) {
            return;
        }
        this.styleReference = styleReference;
        RampStyleElement rampSE = style.getRampStyleElement(styleReference);
        this.minColor = rampSE.getStartColor();
        this.neutralColor = rampSE.getColorAttribute("fillGradientNeutralColor", null);
        if (this.neutralColor == null) {
            this.neutralValue = Double.NaN;
        }
        this.maxColor = rampSE.getEndColor();
        this.missingColor = style.getFillStyleElement("Missing").getFillColor();
        this.underflowColor = this.overlflowColor = Color.RED;
    }

    public String getStyleReference() {
        return this.styleReference;
    }

    private void setValues(double min, double neutral, double max) {
        if (Double.isNaN(min)) {
            min = neutral;
        }
        if (Double.isNaN(max)) {
            max = neutral;
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return;
        }
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        if (this.neutralColor != null) {
            if (Double.isNaN(neutral)) {
                neutral = min + (max - min) / 2.0;
            }
            if (this.zeroCenter && min < 0.0 && max > 0.0) {
                neutral = 0.0;
            }
        } else {
            neutral = Double.NaN;
        }
        this.minValue = min;
        this.maxValue = max;
        this.neutralValue = neutral;
        if (this.minValue == this.maxValue) {
            this.neutralValue = this.minValue;
            this.minValue -= 1.0;
            this.maxValue += 1.0;
        }
        this.rebuildListeners();
    }

    private void rebuildListeners() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object obj = this.listeners.elementAt(i);
                if (!(obj instanceof UpdateInterface)) continue;
                ((UpdateInterface)obj).buildAndDraw(Boolean.TRUE, null, null);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Color getColor(double d) {
        Color maxc;
        Color minc;
        double max;
        double min;
        if (Double.isNaN(d)) {
            return this.missingColor;
        }
        if (d < this.minValue) {
            return this.underflowColor;
        }
        if (d > this.maxValue) {
            return this.overlflowColor;
        }
        if (this.neutralColor == null || Double.isNaN(this.neutralValue)) {
            min = this.minValue;
            max = this.maxValue;
            minc = this.minColor;
            maxc = this.maxColor;
        } else if (d < this.neutralValue) {
            min = this.minValue;
            max = this.neutralValue;
            minc = this.minColor;
            maxc = this.neutralColor == null ? this.maxColor : this.neutralColor;
        } else {
            min = this.neutralValue;
            max = this.maxValue;
            minc = this.neutralColor == null ? this.minColor : this.neutralColor;
            maxc = this.maxColor;
        }
        if (d == min) {
            return minc;
        }
        if (d == max) {
            return maxc;
        }
        double factor = 1.0 / ((max - min) / (d - min));
        int r1 = minc.getRed();
        int g1 = minc.getGreen();
        int b1 = minc.getBlue();
        int t1 = minc.getAlpha();
        int r2 = maxc.getRed();
        int g2 = maxc.getGreen();
        int b2 = maxc.getBlue();
        int t2 = maxc.getAlpha();
        int r = (int)(((double)r2 - (double)r1) * factor + (double)r1);
        int g = (int)(((double)g2 - (double)g1) * factor + (double)g1);
        int b = (int)(((double)b2 - (double)b1) * factor + (double)b1);
        int t = (int)(((double)t2 - (double)t1) * factor + (double)t1);
        Color rc = new Color(r, g, b, t);
        return rc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.rangeMerger) {
            DataRange range = (DataRange)evt.getNewValue();
            if (range == null) {
                this.setValues(0.0, 0.5, 1.0);
            }
            if (range instanceof ContinuousRange) {
                ContinuousRange cr = (ContinuousRange)range;
                this.setValues(cr.getMin(), Double.NaN, cr.getMax());
            }
            this.firePropertyChange(evt);
        }
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public void setMinColor(Color c) {
        if (c == null || c.equals(this.minColor)) {
            return;
        }
        this.minColor = c;
        this.rebuildListeners();
    }

    public Color getNeutralColor() {
        return this.neutralColor;
    }

    public void setNeutralColor(Color c) {
        if (c == null || c.equals(this.neutralColor)) {
            return;
        }
        boolean wasNull = this.neutralColor == null;
        this.neutralColor = c;
        if (wasNull) {
            this.setValues(this.maxValue, this.neutralValue, this.maxValue);
        } else {
            this.rebuildListeners();
        }
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public void setMaxColor(Color c) {
        if (c == null || c.equals(this.maxColor)) {
            return;
        }
        this.maxColor = c;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getNeutralValue() {
        return this.neutralValue;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color c) {
        if (c == null || c.equals(this.missingColor)) {
            return;
        }
        this.missingColor = c;
        this.rebuildListeners();
    }

    public Color getOverlflowColor() {
        return this.overlflowColor;
    }

    public void setOverlflowColor(Color c) {
        if (c == null || c.equals(this.overlflowColor)) {
            return;
        }
        this.overlflowColor = c;
        this.rebuildListeners();
    }

    public Color getUnderflowColor() {
        return this.underflowColor;
    }

    public void setUnderflowColor(Color c) {
        if (c == null || c.equals(this.underflowColor)) {
            return;
        }
        this.underflowColor = c;
        this.rebuildListeners();
    }

    public boolean isZeroCenter() {
        return this.zeroCenter;
    }

    public void setZeroCenter(boolean zeroCenter) {
        this.zeroCenter = zeroCenter;
        this.setValues(this.minValue, Double.NaN, this.maxValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new EventListenerList();
        }
        this.propertyListeners.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(PropertyChangeListener.class, listener);
        }
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyListeners == null) {
            return;
        }
        EventListener[] arr = this.propertyListeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((PropertyChangeListener)arr[i]).propertyChange(evt);
        }
    }

    static {
        ColorMapper.getInstance("TwoColorRamp");
        ColorMapper.getInstance("TwoColorAltRamp");
        ColorMapper.getInstance("ThreeColorRamp");
        ColorMapper.getInstance("ThreeColorAltRamp");
    }
}

