/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.FormatCheck;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.RangeMenu;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceLine;
import com.sas.graphics.silk.util.ReferenceLineObject;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.silk.util.TransformObject;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ContinuousTickSpacer;
import com.sas.graphics.util.DateTimeTickSpacer;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.SplitDateTime;
import com.sas.graphics.util.ZxAxis;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;

public class Axes
implements AxisInterface,
PropertyInterface,
GeometryInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
PropertyChangeListener,
TextListenerInterface {
    public static final int TICKSIZE = 6;
    public static final int MINOR_TICKSIZE = 3;
    protected static final int MIN_FONTSIZE = 8;
    protected static final int MAX_FONTSIZE = 12;
    protected static final int MIN_LABEL_FONTSIZE = 9;
    protected static final int MAX_LABEL_FONTSIZE = 16;
    protected static final int MIN_DISPLAY_FONTSIZE = 4;
    protected static final int DEFAULT_MAXTICKS = 6;
    public static final double EXTRA_SPACE = 0.02;
    protected int GAP;
    protected AxisDefaults axisDefaults;
    protected boolean visible = true;
    protected TransformInterface transformObject;
    protected double[] startPoint;
    protected double[] endPoint;
    protected boolean isXAxis;
    protected int maxTicks;
    protected Object[] tickMarkValues;
    protected double minValue;
    protected double maxValue;
    protected String axisLabel;
    protected double gridLineLength;
    protected Vector redrawListener;
    protected boolean fireEvent;
    protected LineAttrib axisLineStyle;
    protected LineAttrib majorTickLineStyle;
    protected LineAttrib minorTickLineStyle;
    protected LineAttrib gridLineStyle;
    protected TextAttrib labelStyle;
    protected TextAttrib valueLabelStyle;
    protected Vector reflines;
    protected Vector refRanges;
    protected PropertyList pendingProperties;
    protected boolean autoCalculated;
    protected boolean redraw;
    protected Vector displayList;
    protected double opacity = 1.0;
    protected DataFilterReadInterface filter;
    protected String axisRole;
    protected Object axisVariable;
    protected boolean rebuildRequired = true;
    protected Object axisFormat;
    protected Object columnFormat;
    protected SASFormat format;
    protected ContinuousTickSpacer tickSpacer;
    protected boolean tickInCenter;
    protected SASFormat defaultFormat;
    protected boolean reduceFont;
    protected int collisionResolutionMethod_default_discrete;
    protected int collisionResolutionMethod_default_ordinal;
    protected boolean fixedEndPoints;
    protected Dimension chartAreaDimension;
    protected boolean fontTooSmall;
    protected boolean labelTooSmall;
    protected boolean hidingValueLabelsIsRequired;
    protected boolean resolutionPolicyForValueLabelsIsRequired;
    protected double axisLength;
    protected int valueLabelFontSizeInUse;
    protected int startExtra;
    protected int endExtra;
    protected boolean redrawRequired;
    protected int startOffset;
    protected int endOffset;
    protected Rectangle bBox;
    protected boolean dataIsBinned;
    protected int labelOffset;
    protected boolean defaultLabelPosition;
    protected double baseValue;
    protected int labelLength;
    protected boolean isValues;
    boolean categorized;
    boolean discrete;
    boolean primary;
    boolean groupAxis;
    int numberOfGroups;
    int numberOfCategories;
    int numberOfResponses;
    int maxAxisLabelLength;
    protected boolean refLineLabelVisible = true;
    protected ReferenceLineInterface currentRefLine;
    protected RangeModel rangeModel;
    protected RangeSlider rangeSlider;
    protected boolean missing;
    protected double missingValue;
    protected boolean rangeMinSet = false;
    protected boolean rangeMaxSet = false;
    protected boolean resetFormat = true;
    protected Color backgroundColor = Color.gray;
    protected Color wallColor = Color.lightGray;
    private boolean isFirstTime = true;
    protected boolean ordinal = false;
    protected double ordinalAdjust = 0.0;
    protected int thumbSize = 12;
    protected boolean userSetThumbSize = false;
    protected boolean suppressRangeSlider = true;
    protected ReferenceRange focusedRange = null;
    protected boolean lowValueTip = false;
    protected boolean highValueTip = false;
    protected AxesMouseListener aml = null;
    protected String rangeSliderToolTipStr = " ";
    protected int rangeSliderToolTipX;
    protected int rangeSliderToolTipY;
    protected TipInterface chartTip = null;
    protected double widthFactor = 0.5;
    protected DateTimeTickSpacer timeTickSpacer;
    protected SplitDateTime splitDT;
    protected int timeInterval;
    protected int timeSplittingPolicy;
    protected boolean splittingTime;
    protected String[] longTermLabels;
    protected String[] shortTermLabels;
    protected boolean dateTime;
    protected boolean fixedFormat = false;
    protected double minimumTimeSpan = Double.NaN;
    protected boolean fisheyeView = false;
    protected boolean xReverse = false;
    protected boolean yReverse = false;
    protected boolean externalAxis = false;
    protected String[] valueLabels = null;
    protected Color chartBackgroundColor = null;
    protected Color chartWallColor = null;
    protected Color chartWallColorBright = null;
    protected Color chartWallColorDark = null;
    protected Color chartBackgroundColorBright = null;
    protected String schemeName;
    private Object userSetLow = null;
    private Object userSetHigh = null;
    private boolean useUserSetMinMax = false;
    private boolean gGood = false;
    private boolean layoutRangeModel = true;
    private boolean reverseEnabled = true;
    private boolean logTransformEnabled = true;
    private double threshold = 0.3;
    private boolean honorThresh = false;
    protected int[] supportedProperties = new int[]{247, 255, 246, 267};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(this.supportedProperties);
    protected TransformObject defaultTransformObject;
    private PropertyChangeSupport _propertyListeners = new PropertyChangeSupport(this);
    protected double logBase = 10.0;
    protected int axisType = 1;
    protected ZxAxis.LogarithmTicks logObject = null;
    private double fullDataMin = Double.NaN;
    private double fullDataMax = Double.NaN;
    private ResourceBundle resourceBundle = null;
    protected int margin = -1;
    protected String[] supportedTransforms = new String[]{"Linear", "Log"};
    protected double userMin = Double.NaN;
    protected double userMax = Double.NaN;
    protected Object[] tickValueList = null;
    protected String[] tickDisplayList = null;
    protected Object[] internalTickValueList = null;
    protected String[] internalTickDisplayList = null;
    protected boolean distinctRangeSliderBackground = false;
    private Object tickMarkValuesLock = new Object();
    private double valueLabelRotationAngle = 1.0471975511965976;
    private int componentHeight = 0;
    private boolean stupidChartUsedStupidSetAxisLengthMethod = false;
    private static final int GGOOD_MAX_NUMBER_TICKS = 100;
    private ArrayList replace = null;
    private ArrayList tooltips = null;
    private static final String LOW_INCLUSIVE_VALUE_TRUE = ">=";
    private static final String LOW_INCLUSIVE_VALUE_FALSE = ">";
    private static final String HIGH_INCLUSIVE_VALUE_TRUE = "<=";
    private static final String HIGH_INCLUSIVE_VALUE_FALSE = "<";
    private boolean fixedTicks = false;

    public Axes(Object dataObject) {
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.defaultTransformObject = new TransformObject();
        this.setTransformObject(this.defaultTransformObject);
        this.filter = null;
        this.tickMarkValues = null;
        this.startPoint = new double[3];
        this.endPoint = new double[3];
        this.displayList = new Vector();
        this.redrawListener = new Vector();
        this.defaultFormat = null;
        this.maxTicks = 6;
        this.redraw = false;
        this.reduceFont = false;
        this.collisionResolutionMethod_default_discrete = 1;
        this.collisionResolutionMethod_default_ordinal = 8;
        this.fireEvent = true;
        this.fixedEndPoints = false;
        this.axisDefaults = new AxisDefaults();
        this.labelStyle = new TextAttrib(null, FontManager.getFont((String)this.axisDefaults.labelFontName, (int)this.axisDefaults.labelFontType, (int)16));
        this.labelStyle.addTextListener(this);
        this.labelStyle.setFormatSupported(false);
        this.labelStyle.setEffectsSupported(false);
        this.labelStyle.setJustifySupported(false);
        this.valueLabelStyle = new TextAttrib(null, FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)12));
        this.valueLabelStyle.addTextListener(this);
        this.valueLabelStyle.setFormatSupported(false);
        this.valueLabelStyle.setEffectsSupported(false);
        this.valueLabelStyle.setJustifySupported(false);
        this.GAP = this.axisDefaults.tickValueMargin;
        this.axisLineStyle = new LineAttrib(true, Color.black, 1);
        this.gridLineStyle = new LineAttrib(!SILKGlobal.isFlagSet(4), Color.lightGray, 1);
        this.majorTickLineStyle = new LineAttrib(true, Color.black, 1);
        this.minorTickLineStyle = new LineAttrib(false, Color.black, 1);
        this.chartBackgroundColorBright = ColorUtilities.brighter(this.backgroundColor, 0.2);
        this.chartWallColorBright = ColorUtilities.brighter(this.wallColor);
        this.chartWallColorDark = ColorUtilities.darker(this.wallColor);
        this.reflines = new Vector();
        this.refRanges = new Vector();
        this.pendingProperties = new PropertyList();
        this.autoCalculated = true;
        this.rebuildRequired = true;
        this.redrawRequired = true;
        this.endOffset = 0;
        this.startOffset = 0;
        this.defaultLabelPosition = true;
        this.setDataSource(dataObject);
        this.bBox = new Rectangle();
        this.dataIsBinned = false;
        this.categorized = false;
        this.discrete = false;
        this.primary = true;
        this.groupAxis = false;
        this.numberOfGroups = 0;
        this.numberOfCategories = 1;
        this.numberOfResponses = 0;
        this.tickInCenter = false;
        this.isValues = true;
        this.missing = false;
        this.timeInterval = 0;
        this.timeSplittingPolicy = SILKGlobal.isFlagSet(4) ? 1 : 2;
        this.splittingTime = false;
        this.dateTime = false;
        this.replace = new ArrayList(4);
        this.tooltips = new ArrayList(3);
        String lowThumbTooltipText = "{0} {1}";
        String highThumbTooltipText = "{0} {1}";
        String defStrutTooltipText = "{0} {1} to {2} {3}";
        String strutTooltipText = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"Axis.RangeSlider.StrutTooltipText.fmt.txt", (String)defStrutTooltipText);
        this.setReferenceValueTooltipText(-1, lowThumbTooltipText, new Object[]{"lowInclusive", "lowValue"});
        this.setReferenceValueTooltipText(0, strutTooltipText, new Object[]{"lowInclusive", "lowValue", "highInclusive", "highValue"});
        this.setReferenceValueTooltipText(1, highThumbTooltipText, new Object[]{"highInclusive", "highValue"});
        this.threshold = this.axisDefaults.threshold;
    }

    public Axes() {
        this(null);
    }

    public void resetRange() {
        this.maxValue = Double.NaN;
        this.minValue = Double.NaN;
        this.tickMarkValues = null;
    }

    private int getAxisIndex() {
        return this.isXAxis ? 0 : 1;
    }

    @Override
    public ReferenceLineInterface addReferenceLine(Object value, String label) {
        ReferenceLineInterface rline = null;
        if (value instanceof ReferenceLineInterface) {
            rline = (ReferenceLineInterface)value;
            rline.setLabel(label);
        } else if (value instanceof Number) {
            rline = new ReferenceLine(value, label);
            rline.getLine().setColor(this.axisLineStyle.getColor());
            rline.getLabel().setColor(this.labelStyle.getColor());
        }
        this.currentRefLine = rline;
        if (rline != null) {
            this.reflines.addElement(rline);
        }
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireRedrawEvent(e);
        return rline;
    }

    public boolean autoCalculateAxis(Object low, Object high, int maxMajorTicks, int minorTicks) {
        if (low == null || !(low instanceof Number) || Double.isInfinite(((Number)low).doubleValue()) || Double.isNaN(((Number)low).doubleValue())) {
            return false;
        }
        if (high == null || !(high instanceof Number) || Double.isInfinite(((Number)high).doubleValue()) || Double.isNaN(((Number)high).doubleValue())) {
            return false;
        }
        this.minValue = ((Number)low).doubleValue();
        this.maxValue = ((Number)high).doubleValue();
        this.createTickMarkValues(this.minValue, this.maxValue);
        this.autoCalculated = true;
        return true;
    }

    @Override
    public double[] getEndPoint(boolean high, boolean screen) {
        double y;
        double x;
        double[] temp;
        double[] out = new double[2];
        if (out == null) {
            return null;
        }
        if (Double.isNaN(this.minValue) || Double.isNaN(this.maxValue)) {
            return null;
        }
        out[0] = this.startPoint[this.getAxisIndex()];
        out[1] = this.endPoint[this.getAxisIndex()];
        if (!screen) {
            return out;
        }
        if (this.transformObject == null || (temp = new double[3]) == null) {
            return null;
        }
        if (this.isXAxis) {
            x = high ? this.maxValue : this.minValue;
            y = this.startPoint[1];
        } else {
            y = high ? this.maxValue : this.minValue;
            x = this.startPoint[0];
        }
        this.transformObject.project(x, y, 0.0, temp);
        out[0] = temp[0];
        out[1] = temp[1];
        return out;
    }

    @Override
    public LineStyleInterface getGridLines() {
        return this.gridLineStyle;
    }

    @Override
    public TextStyleInterface getLabel() {
        return this.labelStyle;
    }

    @Override
    public String getLabelString() {
        String lab;
        String string = lab = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (lab == null) {
            return null;
        }
        return lab.toString();
    }

    @Override
    public LineStyleInterface getLine() {
        return this.axisLineStyle;
    }

    @Override
    public LineStyleInterface getMajorTicks() {
        return this.majorTickLineStyle;
    }

    @Override
    public LineStyleInterface getMinorTicks() {
        return this.minorTickLineStyle;
    }

    @Override
    public int getNumberMajorTicks() {
        return this.tickMarkValues != null ? this.tickMarkValues.length : 0;
    }

    @Override
    public int getNumberMinorTicks() {
        return 0;
    }

    @Override
    public int getNumberReferenceLines() {
        return this.reflines.size();
    }

    @Override
    public ReferenceLineInterface getReferenceLine(int index) {
        if (index < 0 || index >= this.reflines.size()) {
            return null;
        }
        return (ReferenceLineInterface)this.reflines.elementAt(index);
    }

    @Override
    public ReferenceLineInterface getReferenceLineByValue(Object value, boolean nearest) {
        ReferenceLineInterface rline = null;
        for (int i = 0; i < this.reflines.size(); ++i) {
            ReferenceLineInterface rl = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (!rl.getValue().equals(value)) continue;
            rline = rl;
            break;
        }
        return rline;
    }

    @Override
    public Object[] getTickMarkValues(boolean formatted) {
        if (this.tickMarkValues == null || this.tickMarkValues.length == 0) {
            return null;
        }
        Object[] tmv = this.tickMarkValues;
        int size = tmv.length;
        if (size == 0) {
            return null;
        }
        Object[] out = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object tm = tmv[i];
            out[i] = formatted ? this.getTickMarkLabel(tm) : tm;
        }
        return out;
    }

    @Override
    public TextStyleInterface getValues() {
        return this.valueLabelStyle;
    }

    @Override
    public boolean isAxisAutoCalculated() {
        return this.autoCalculated;
    }

    @Override
    public boolean removeAllReferenceLines() {
        if (this.reflines.size() == 0) {
            return false;
        }
        this.reflines.removeAllElements();
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public boolean removeReferenceLine(Object id, boolean nearest) {
        int index = -1;
        if (id instanceof ReferenceLineInterface) {
            index = this.reflines.indexOf(id);
        } else if (id instanceof Integer) {
            index = (Integer)id;
        } else if (id instanceof Number) {
            for (int i = 0; i < this.reflines.size(); ++i) {
                ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
                if (!rline.getValue().equals(id)) continue;
                index = i;
                break;
            }
        } else {
            return false;
        }
        if (index < 0 || index >= this.reflines.size()) {
            return false;
        }
        this.reflines.removeElementAt(index);
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public boolean setAxis(Object low, Object high, int nMajor, int nMinor, Object[] values, Boolean autoCalculate, Boolean equallySpacedDiscrete) {
        this.categorized = false;
        this.dataIsBinned = false;
        this.discrete = false;
        this.defaultFormat = null;
        this.valueLabels = null;
        this.userSetLow = low;
        this.userSetHigh = high;
        this.honorThresh = false;
        boolean bl = this.autoCalculated = autoCalculate != null ? autoCalculate : this.autoCalculated;
        if (values != null) {
            if (values.length < 1) {
                return false;
            }
            if (values[0] instanceof Number && equallySpacedDiscrete instanceof Boolean) {
                if (!equallySpacedDiscrete.booleanValue()) {
                    return this.setSpacedTickMarkValues(values, low, high);
                }
                return this.setEquallySpacedTickMarkValues(low, high, values);
            }
            return this.setTickMarkValues(values);
        }
        if (this.isXAxis && !this.isDiscrete()) {
            switch (this.getCollisionResolution()) {
                case 4: 
                case 5: {
                    this.collisionResolutionMethod_default_discrete = 1;
                    this.collisionResolutionMethod_default_ordinal = 8;
                }
            }
        }
        boolean setData = false;
        if (low != null && low instanceof Number && !Double.isInfinite(((Number)low).doubleValue()) && !Double.isNaN(((Number)low).doubleValue())) {
            this.minValue = ((Number)low).doubleValue();
            setData = true;
        }
        if (high != null && high instanceof Number && !Double.isInfinite(((Number)high).doubleValue()) && !Double.isNaN(((Number)high).doubleValue())) {
            this.maxValue = ((Number)high).doubleValue();
            setData = true;
        }
        boolean rc = true;
        if (!this.autoCalculated) {
            this.outputFixedTickMarks(this.minValue, this.maxValue, nMajor);
        } else {
            if (nMajor > 0 && values == null) {
                return this.setNumberTickMarks(nMajor, setData);
            }
            rc = this.autoCalculateAxis(low, high, 6, 0);
        }
        if (this.rangeModel != null) {
            this.ordinal = false;
            if (this.rangeSlider != null) {
                this.rangeSlider.setExclusive(!this.ordinal);
            }
            if (!this.rangeMinSet) {
                this.rangeModel.setMinimum(new Double(this.minValue));
            }
            if (!this.rangeMaxSet) {
                this.rangeModel.setMaximum(new Double(this.maxValue));
            }
            this.rangeModel.setVisibleMinimum(new Double(this.minValue));
            this.rangeModel.setVisibleMaximum(new Double(this.maxValue));
        }
        if (this.rebuildRequired && rc) {
            this.build(null);
            RedrawEvent e = new RedrawEvent(this);
            this.fireRedrawEvent(e);
        }
        return rc;
    }

    @Override
    public boolean setGridLines(Object lines) {
        if (this.gridLineStyle == null || lines == null) {
            return false;
        }
        if (lines instanceof Boolean) {
            this.gridLineStyle.setVisible((Boolean)lines);
        } else if (lines instanceof Color) {
            this.gridLineStyle.setColor(lines);
        } else if (lines instanceof Number) {
            this.gridLineStyle.setWidth(((Number)lines).intValue());
        } else if (lines instanceof LineStyleInterface) {
            this.gridLineStyle = new LineAttrib((LineStyleInterface)lines);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        return true;
    }

    @Override
    public boolean setLabel(Object labelIn) {
        if (this.labelStyle == null) {
            return false;
        }
        RedrawEvent e = new RedrawEvent(this);
        if (labelIn == null || labelIn instanceof String) {
            this.labelStyle.setText(labelIn);
            this.maxAxisLabelLength = labelIn == null ? 0 : ((String)labelIn).length();
        } else if (labelIn instanceof Boolean) {
            this.labelStyle.setVisible((Boolean)labelIn);
            e.type = 3;
        } else if (labelIn instanceof Color) {
            this.labelStyle.setColor(labelIn);
        } else if (labelIn instanceof Font) {
            this.labelStyle.setFont(labelIn);
            e.type = 3;
        } else if (labelIn instanceof SASFormat) {
            this.labelStyle.setFormat(labelIn);
            e.type = 3;
        } else if (labelIn instanceof TextStyleInterface) {
            if (this.labelStyle != labelIn) {
                this.labelStyle = new TextAttrib((TextStyleInterface)labelIn);
            }
            e.type = 3;
        } else {
            return false;
        }
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public boolean setLine(Object line) {
        if (this.axisLineStyle == null || line == null) {
            return false;
        }
        if (line instanceof Boolean) {
            this.axisLineStyle.setVisible((Boolean)line);
        } else if (line instanceof Color) {
            this.axisLineStyle.setColor(line);
        } else if (line instanceof Number) {
            this.axisLineStyle.setWidth(((Number)line).intValue());
        } else if (line instanceof LineStyleInterface) {
            this.axisLineStyle = new LineAttrib((LineStyleInterface)line);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        return true;
    }

    @Override
    public boolean setMajorTicks(Object ticks) {
        RedrawEvent e = new RedrawEvent(this);
        if (this.majorTickLineStyle == null || ticks == null) {
            return false;
        }
        if (ticks instanceof Boolean) {
            this.majorTickLineStyle.setVisible((Boolean)ticks);
            e.type = 3;
        } else if (ticks instanceof Color) {
            this.majorTickLineStyle.setColor(ticks);
        } else if (ticks instanceof Number) {
            this.majorTickLineStyle.setWidth(((Number)ticks).intValue());
        } else if (ticks instanceof LineStyleInterface) {
            this.majorTickLineStyle = new LineAttrib((LineStyleInterface)ticks);
            e.type = 3;
        }
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public boolean setMinorTicks(Object ticks) {
        if (this.minorTickLineStyle == null || ticks == null) {
            return false;
        }
        if (ticks instanceof Boolean) {
            this.minorTickLineStyle.setVisible((Boolean)ticks);
            if (this.dateTime && this.timeTickSpacer != null) {
                this.createTickMarkValues(this.timeTickSpacer.getDataMin(), this.timeTickSpacer.getDataMax());
            } else if (this.axisType == 2) {
                this.createTickMarkValues(this.minValue, this.maxValue);
            }
        } else if (ticks instanceof Color) {
            this.minorTickLineStyle.setColor(ticks);
        } else if (ticks instanceof Number) {
            this.minorTickLineStyle.setWidth(((Number)ticks).intValue());
        } else if (ticks instanceof LineStyleInterface) {
            this.minorTickLineStyle = new LineAttrib((LineStyleInterface)ticks);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        return true;
    }

    @Override
    public void setMultiRole(boolean multi) {
    }

    @Override
    public boolean setValues(Object valuesIn) {
        if (this.valueLabelStyle == null || valuesIn == null) {
            return false;
        }
        RedrawEvent e = new RedrawEvent(this);
        if (valuesIn instanceof Boolean) {
            this.valueLabelStyle.setVisible((Boolean)valuesIn);
            e.type = 3;
        } else if (valuesIn instanceof Color) {
            this.valueLabelStyle.setColor(valuesIn);
        } else if (valuesIn instanceof Font) {
            this.valueLabelStyle.setFont(valuesIn);
            e.type = 3;
        } else if (valuesIn instanceof SASFormat) {
            this.valueLabelStyle.setFormat(valuesIn);
            this.columnFormat = valuesIn;
            this.axisFormat = valuesIn;
            if (this.axisVariable == null) {
                this.resetFormat = false;
            }
            e.type = 3;
        } else if (valuesIn instanceof TextStyleInterface) {
            this.valueLabelStyle = new TextAttrib((TextStyleInterface)valuesIn);
            e.type = 3;
        } else if (valuesIn instanceof String[]) {
            this.valueLabels = (String[])valuesIn;
        } else {
            return false;
        }
        this.fireRedrawEvent(e);
        return true;
    }

    public void setCurrentValueAsDefault(int id) {
        this.userSetProperties.clear(id);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pendingProperties.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        this.fireEvent = false;
        boolean fire = false;
        boolean marginChanged = false;
        boolean boundingBoxChanged = false;
        block53: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 200: 
                case 201: 
                case 202: {
                    this.setLine(value);
                    continue block53;
                }
                case 203: 
                case 206: 
                case 212: {
                    marginChanged = true;
                }
                case 205: {
                    this.setLabel(value);
                    continue block53;
                }
                case 204: {
                    if (value instanceof String) {
                        this.setLabel(value);
                    }
                    this.isValues = false;
                    continue block53;
                }
                case 207: {
                    continue block53;
                }
                case 208: {
                    continue block53;
                }
                case 209: {
                    continue block53;
                }
                case 210: {
                    continue block53;
                }
                case 211: {
                    continue block53;
                }
                case 213: 
                case 216: 
                case 222: {
                    marginChanged = true;
                }
                case 215: {
                    this.setValues(value);
                    continue block53;
                }
                case 214: {
                    this.isValues = true;
                    continue block53;
                }
                case 217: {
                    continue block53;
                }
                case 218: {
                    continue block53;
                }
                case 219: {
                    continue block53;
                }
                case 220: {
                    continue block53;
                }
                case 221: {
                    continue block53;
                }
                case 223: {
                    marginChanged = true;
                }
                case 224: 
                case 225: {
                    this.setMajorTicks(value);
                    continue block53;
                }
                case 226: 
                case 227: 
                case 228: {
                    this.setMinorTicks(value);
                    continue block53;
                }
                case 229: 
                case 230: 
                case 231: {
                    this.setGridLines(value);
                    continue block53;
                }
                case 232: {
                    continue block53;
                }
                case 233: {
                    continue block53;
                }
                case 234: {
                    if (value instanceof Integer) {
                        boundingBoxChanged = true;
                        this.setNumberTickMarks((Integer)value, false);
                    }
                    if (!(value instanceof Integer)) continue block53;
                    boundingBoxChanged = true;
                    this.setNumberTickMarks((Integer)value, false);
                    continue block53;
                }
                case 235: {
                    continue block53;
                }
                case 236: {
                    if (value instanceof Object[]) {
                        boundingBoxChanged = true;
                        this.setTickMarkValues((Object[])value);
                    }
                    if (!(value instanceof Object[])) continue block53;
                    boundingBoxChanged = true;
                    this.setTickMarkValues((Object[])value);
                    continue block53;
                }
                case 237: {
                    if (!(value instanceof Boolean)) continue block53;
                    marginChanged = true;
                    this.visible = (Boolean)value;
                    continue block53;
                }
                case 258: {
                    if (!(value instanceof Number)) continue block53;
                    this.setUserMin(((Number)value).doubleValue());
                    continue block53;
                }
                case 259: {
                    if (!(value instanceof Number)) continue block53;
                    this.setUserMax(((Number)value).doubleValue());
                    continue block53;
                }
                case 9002: {
                    marginChanged = true;
                    if (this.isValues) {
                        this.setValues(value);
                        continue block53;
                    }
                    this.setLabel(value);
                    continue block53;
                }
                case 9001: {
                    marginChanged = true;
                    if (this.isValues) {
                        this.setValues(value);
                        continue block53;
                    }
                    this.setLabel(value);
                    continue block53;
                }
                case 239: {
                    this.setAxis(((Object[])value)[1], ((Object[])value)[2], ((Number)((Object[])value)[3]).intValue(), ((Number)((Object[])value)[4]).intValue(), null, (Boolean)((Object[])value)[0], null);
                    continue block53;
                }
                case 243: {
                    if (!(value instanceof ReferenceLineObject)) continue block53;
                    ReferenceLineObject refLineObject = (ReferenceLineObject)value;
                    if (!(refLineObject.action instanceof Integer)) continue block53;
                    switch ((Integer)refLineObject.action) {
                        case 0: {
                            String str = refLineObject.label instanceof String ? (String)refLineObject.label : (refLineObject.label instanceof Number ? refLineObject.label.toString() : null);
                            this.addReferenceLine(refLineObject.value, str);
                            break;
                        }
                        case 4: {
                            if (!(refLineObject.value instanceof Boolean)) break;
                            this.setRefLineLabelVisible((Boolean)refLineObject.value);
                            if (this.currentRefLine == null) break;
                            this.currentRefLine.getLabel().setVisible((Boolean)refLineObject.value);
                            break;
                        }
                        case 5: {
                            if (!(refLineObject.value instanceof Number)) break;
                            this.currentRefLine = this.getReferenceLineByValue(refLineObject.value, false);
                            break;
                        }
                        case 2: {
                            this.removeReferenceLine(refLineObject.value, false);
                            break;
                        }
                        case 3: {
                            this.removeAllReferenceLines();
                            break;
                        }
                        case 6: {
                            if (this.currentRefLine == null || !(refLineObject.value instanceof Color)) break;
                            this.currentRefLine.getLine().setColor(refLineObject.value);
                            break;
                        }
                        case 7: {
                            if (this.currentRefLine == null || !(refLineObject.value instanceof Number)) break;
                            this.currentRefLine.getLine().setWidth(((Number)refLineObject.value).intValue());
                        }
                    }
                    continue block53;
                }
                case 246: {
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Boolean)) {
                        return false;
                    }
                    if (this.isXAxis) {
                        this.xReverse = (Boolean)value;
                        this.defaultTransformObject.setReverse(0, this.xReverse);
                    } else {
                        this.yReverse = (Boolean)value;
                        this.defaultTransformObject.setReverse(1, this.yReverse);
                    }
                    this.userSetProperties.set(246);
                    this._propertyListeners.firePropertyChange("AXIS_REVERSE", null, value);
                    continue block53;
                }
                case 244: {
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Boolean)) {
                        return false;
                    }
                    this.xReverse = (Boolean)value;
                    this.userSetProperties.set(246);
                    this.defaultTransformObject.setReverse(0, this.xReverse);
                    this._propertyListeners.firePropertyChange("AXIS_REVERSE", null, value);
                    continue block53;
                }
                case 245: {
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Boolean)) {
                        return false;
                    }
                    this.yReverse = (Boolean)value;
                    this.userSetProperties.set(246);
                    this.defaultTransformObject.setReverse(1, this.yReverse);
                    this._propertyListeners.firePropertyChange("AXIS_REVERSE", null, value);
                    continue block53;
                }
                case 247: {
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Number)) {
                        return false;
                    }
                    this.setThreshold(((Number)value).doubleValue());
                    continue block53;
                }
                case 254: {
                    if (value == null) continue block53;
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Number)) continue block53;
                    this.setTransformType(((Number)value).intValue(), new Double(this.logBase));
                    continue block53;
                }
                case 255: {
                    if (value == null) continue block53;
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Number)) continue block53;
                    this.setTransformType(this.axisType, value);
                    continue block53;
                }
                case 256: {
                    this.setRangeModel(value);
                    continue block53;
                }
                case 267: {
                    if (!(value instanceof Number)) continue block53;
                    this.setCollisionResolution(((Number)value).intValue());
                    marginChanged = true;
                    this.userSetProperties.set(267);
                    continue block53;
                }
                case 271: {
                    if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue block53;
                    this.layoutValueLabels(null);
                }
            }
        }
        this.fireEvent = true;
        RedrawEvent e = new RedrawEvent(this);
        if (boundingBoxChanged) {
            e.type = 2;
        } else if (marginChanged) {
            e.type = 3;
        }
        this.fireRedrawEvent(e);
        this.fireEvent = fire;
        this.pendingProperties.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pendingProperties.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pendingProperties.getPending(source);
    }

    public Object getPropertyValue(int idx) {
        Object value = null;
        if (this.pendingProperties.isPending(idx)) {
            return this.pendingProperties.getValueById(idx);
        }
        switch (idx) {
            case 266: {
                value = new Boolean(this.dateTime);
                break;
            }
            case 200: {
                value = new Boolean(this.axisLineStyle.isVisible());
                break;
            }
            case 201: {
                value = this.getColor();
                break;
            }
            case 202: {
                value = new Integer(this.axisLineStyle.getWidth());
                break;
            }
            case 203: {
                value = new Boolean(this.labelStyle.isVisible());
                break;
            }
            case 204: {
                value = this.getLabelString();
                break;
            }
            case 205: {
                value = this.getLabelColor();
                break;
            }
            case 206: {
                value = this.getLabelFont();
                break;
            }
            case 207: {
                value = null;
                break;
            }
            case 208: {
                value = null;
                break;
            }
            case 209: {
                value = null;
                break;
            }
            case 210: {
                value = null;
                break;
            }
            case 211: {
                value = null;
                break;
            }
            case 212: {
                value = null;
                break;
            }
            case 213: {
                value = new Boolean(this.valueLabelStyle.isVisible());
                break;
            }
            case 214: {
                value = null;
                break;
            }
            case 215: {
                value = this.getValueColor();
                break;
            }
            case 216: {
                value = this.getValueFont();
                break;
            }
            case 217: {
                value = null;
                break;
            }
            case 218: {
                value = null;
                break;
            }
            case 219: {
                value = null;
                break;
            }
            case 220: {
                value = null;
                break;
            }
            case 221: {
                value = null;
                break;
            }
            case 222: {
                value = null;
                break;
            }
            case 223: {
                value = new Boolean(this.majorTickLineStyle.isVisible());
                break;
            }
            case 224: {
                value = this.getTickMarkColor();
                break;
            }
            case 225: {
                value = new Integer(this.majorTickLineStyle.getWidth());
                break;
            }
            case 226: {
                value = new Boolean(this.minorTickLineStyle.isVisible());
                break;
            }
            case 227: {
                value = this.getTickMarkColor();
                break;
            }
            case 228: {
                value = new Integer(this.minorTickLineStyle.getWidth());
                break;
            }
            case 229: {
                value = new Boolean(this.gridLineStyle.isVisible());
                break;
            }
            case 230: {
                value = this.getGridLineColor();
                break;
            }
            case 231: {
                value = new Integer(this.gridLineStyle.getWidth());
                break;
            }
            case 232: {
                double[] d = this.getEndPoint(false, false);
                if (d == null || d.length <= 0) break;
                if (this.isXAxis && this.xReverse || !this.isXAxis && this.yReverse) {
                    value = new Double(d[1]);
                    break;
                }
                value = new Double(d[0]);
                break;
            }
            case 233: {
                double[] d1 = this.getEndPoint(false, false);
                if (d1 == null || d1.length <= 1) break;
                if (this.isXAxis && this.xReverse || !this.isXAxis && this.yReverse) {
                    value = new Double(d1[0]);
                    break;
                }
                value = new Double(d1[1]);
                break;
            }
            case 234: {
                value = new Integer(this.getNumberMajorTicks());
                break;
            }
            case 235: {
                value = new Integer(this.getNumberMinorTicks());
                break;
            }
            case 236: {
                value = this.getTickMarkValues(true);
                break;
            }
            case 237: {
                value = new Boolean(this.visible);
                break;
            }
            case 241: {
                value = new Boolean(this.isDiscrete());
                break;
            }
            case 258: {
                value = new Double(this.userMin);
                break;
            }
            case 259: {
                value = new Double(this.userMax);
                break;
            }
            case 9014: {
                value = new Boolean(true);
                break;
            }
            case 9001: {
                if (this.isValues) {
                    value = this.getValueColor();
                    break;
                }
                value = this.getLabelColor();
                break;
            }
            case 9002: {
                if (this.isValues) {
                    value = this.getValueFont();
                    break;
                }
                value = this.getLabelFont();
                break;
            }
            case 244: {
                value = new Boolean(this.xReverse);
                break;
            }
            case 245: {
                value = new Boolean(this.yReverse);
                break;
            }
            case 246: {
                if (this.isXAxis) {
                    value = new Boolean(this.xReverse);
                    break;
                }
                value = new Boolean(this.yReverse);
                break;
            }
            case 247: {
                value = new Double(this.threshold);
                break;
            }
            case 249: {
                value = this.labelStyle;
                break;
            }
            case 250: {
                value = this.valueLabelStyle;
                break;
            }
            case 252: {
                value = this.supportedTransforms;
                break;
            }
            case 253: {
                if (this.isLogTransformPermitted()) {
                    value = new String[]{"Linear", "Log"};
                    break;
                }
                value = new String[]{"Linear"};
                break;
            }
            case 254: {
                value = new Integer(this.getTransformType());
                break;
            }
            case 255: {
                value = new Double(this.logBase);
                break;
            }
            case 256: {
                value = this.getRangeModel(true);
                break;
            }
            case 257: {
                value = Boolean.TRUE;
                break;
            }
            case 267: {
                value = this.getCollisionResolution();
                break;
            }
            case 268: {
                value = this.isXAxis ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 241: 
            case 243: 
            case 247: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 266: 
            case 267: 
            case 268: 
            case 271: 
            case 9001: 
            case 9002: 
            case 9014: {
                return true;
            }
            case 244: 
            case 245: 
            case 246: {
                return this.reverseEnabled;
            }
            case 226: {
                return !this.isDiscrete();
            }
            case 239: {
                return !this.isDiscrete();
            }
        }
        return false;
    }

    public boolean setPropertyValue(int idx, Object value) {
        if (idx == 238) {
            return false;
        }
        return this.pendingProperties.store(idx, value);
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = this.userSetProperties.get(id);
        if (id == 237 && !this.visible) {
            rc = true;
        }
        return rc;
    }

    @Override
    public double[] getBoundingBox() {
        return null;
    }

    @Override
    public Object getTransformObject() {
        return this.transformObject;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.bBox.x = (int)xmin;
        this.bBox.y = (int)ymin;
        this.bBox.width = (int)(xmax - xmin);
        this.bBox.height = (int)(ymax - ymin);
        this.axisLength = this.isXAxis ? (double)this.bBox.width : (double)this.bBox.height;
        return false;
    }

    public RangeSlider getRangeSlider() {
        return this.rangeSlider;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        this.bBox.x = xmin;
        this.bBox.y = ymin;
        this.bBox.width = width;
        this.bBox.height = height;
        if (this.bBox.width <= 0 && this.bBox.height <= 0) {
            return false;
        }
        this.setupTransformObject();
        if (this.dateTime && this.minorTickLineStyle.isVisible() && this.timeTickSpacer != null && this.axisLength <= 1.0) {
            this.rebuildRequired = true;
        }
        double[] tmp = new double[3];
        double tempMin = 0.0;
        double tempMax = 0.0;
        boolean axisLengthChanged = false;
        if (this.isXAxis) {
            if (this.axisLength != (double)this.bBox.width && this.axisLength == 0.0) {
                axisLengthChanged = true;
            }
            this.axisLength = this.bBox.width;
            this.gridLineLength = height;
            if (this.bBox.width != this.startOffset + this.endOffset) {
                this.transformObject.unProject(xmin + this.startOffset, ymin + height, 0.0, tmp);
                if (tmp != null) {
                    this.startPoint[0] = tempMin = tmp[0];
                    this.startPoint[1] = tmp[1];
                }
                this.transformObject.unProject(xmin + width - this.endOffset, ymin + height, 0.0, tmp);
                if (tmp != null) {
                    this.endPoint[0] = tempMax = tmp[0];
                    this.endPoint[1] = tmp[1];
                }
            }
            if (this.rangeSlider != null) {
                this.rangeSlider.setInverted(this.transformObject.isReverse(0));
                if (this.layoutRangeModel) {
                    this.rangeSlider.setOrientation(0);
                    this.rangeSlider.setComponentOrientation(ComponentOrientation.UNKNOWN);
                    int left = this.rangeSlider.getInsets().left + this.rangeSlider.getFocusInsets().left;
                    int right = this.rangeSlider.getInsets().right + this.rangeSlider.getFocusInsets().right;
                    this.rangeSlider.setBounds(this.bBox.x - this.rangeSlider.getTrackBuffer() - left, this.bBox.y - this.rangeSlider.getThumbSize().height, this.bBox.width + 1 + this.rangeSlider.getTrackBuffer() * 2 + left + right, this.rangeSlider.getThumbSize().height);
                    this.rangeSlider.setCalculation(this.rangeSlider.getTrackBuffer(), tempMin * this.rangeModel.getMultiplier(), (double)width / ((tempMax - tempMin) * this.rangeModel.getMultiplier()));
                }
            }
            if (this.rangeModel != null) {
                if (this.transformObject.isReverse(0)) {
                    this.rangeModel.setVisibleMinimum(new Double(tempMax));
                    this.rangeModel.setVisibleMaximum(new Double(tempMin));
                } else {
                    this.rangeModel.setVisibleMinimum(new Double(tempMin));
                    this.rangeModel.setVisibleMaximum(new Double(tempMax));
                }
            }
        } else {
            if (this.rangeSlider != null) {
                this.rangeSlider.setInverted(this.transformObject.isReverse(1));
                if (this.layoutRangeModel) {
                    int left = this.rangeSlider.getInsets().left + this.rangeSlider.getFocusInsets().left;
                    int right = this.rangeSlider.getInsets().right + this.rangeSlider.getFocusInsets().right;
                    this.rangeSlider.setBounds(this.bBox.x + this.bBox.width, this.bBox.y - this.rangeSlider.getTrackBuffer() - right + this.endOffset, this.rangeSlider.getThumbSize().width, this.bBox.height + 1 + this.rangeSlider.getTrackBuffer() * 2 + left + right);
                }
            }
            if (this.axisLength != (double)this.bBox.height && this.axisLength == 0.0) {
                axisLengthChanged = true;
            }
            this.axisLength = this.bBox.height;
            this.gridLineLength = width;
            if (this.bBox.height != this.startOffset + this.endOffset) {
                this.transformObject.unProject(xmin, ymin + this.endOffset, 0.0, tmp);
                if (tmp != null) {
                    this.endPoint[0] = this.transformObject == this.defaultTransformObject ? (double)(xmin + width) : tmp[0];
                    this.endPoint[1] = tmp[1];
                }
                this.transformObject.unProject(xmin, ymin + height - this.startOffset, 0.0, tmp);
                if (tmp != null) {
                    this.startPoint[0] = tmp[0];
                    this.startPoint[1] = tmp[1];
                }
            }
            if (this.rangeModel != null) {
                if (this.transformObject.isReverse(1)) {
                    this.rangeModel.setVisibleMinimum(new Double(this.endPoint[1]));
                    this.rangeModel.setVisibleMaximum(new Double(this.startPoint[1]));
                } else {
                    this.rangeModel.setVisibleMinimum(new Double(this.startPoint[1]));
                    this.rangeModel.setVisibleMaximum(new Double(this.endPoint[1]));
                }
            }
        }
        if (this.dateTime && this.minorTickLineStyle.isVisible() && this.timeTickSpacer != null && this.rebuildRequired) {
            this.build(null);
        }
        if (axisLengthChanged) {
            this.layoutValueLabels(null);
        }
        return true;
    }

    @Override
    public Rectangle getScreenArea() {
        return this.bBox;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transformObject = (TransformInterface)transIn;
        return true;
    }

    private void setupTransformObject() {
        if (this.defaultTransformObject == null) {
            return;
        }
        double xStart = Math.min(this.startPoint[0], this.endPoint[0]);
        double yStart = Math.min(this.startPoint[1], this.endPoint[1]);
        double xEnd = Math.max(this.startPoint[0], this.endPoint[0]);
        double yEnd = Math.max(this.startPoint[1], this.endPoint[1]);
        if (this.useUserSetMinMax && this.userSetLow != null && this.userSetLow instanceof Number && this.userSetHigh != null && this.userSetHigh instanceof Number) {
            double d1 = ((Number)this.userSetLow).doubleValue();
            double d2 = ((Number)this.userSetHigh).doubleValue();
            if (this.isXAxis) {
                xStart = Math.min(d1, d2);
                xEnd = Math.max(d1, d2);
            } else {
                yStart = Math.min(d1, d2);
                yEnd = Math.max(d1, d2);
            }
        }
        if (this.isXAxis || xEnd - xStart > 0.0) {
            this.defaultTransformObject.setXRange(xStart, xEnd);
        }
        if (!this.isXAxis || yEnd - yStart > 0.0) {
            this.defaultTransformObject.setYRange(yStart, yEnd);
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (this.isXAxis) {
            x = this.bBox.x + this.startOffset;
            width = this.bBox.width - this.startOffset - this.endOffset;
            y = this.bBox.y;
            height = this.bBox.height;
        } else {
            x = this.bBox.x;
            width = this.bBox.width;
            y = this.bBox.y + this.endOffset;
            height = this.bBox.height - this.startOffset - this.endOffset;
        }
        this.defaultTransformObject.setScreenBounds(x, y, width, height);
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        boolean logAxis;
        if (p == null || !(p instanceof Graphics2D) || this.transformObject == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite comp = g.getComposite();
        RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.addRenderingHints(rHints);
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        this.setupTransformObject();
        boolean bl = logAxis = this.axisType == 2;
        if (this.isXAxis) {
            if (this.timeSplittingPolicy == 0 && this.dateTime) {
                this.splittingTime = false;
                if (this.getCollisionResolution() == 1 || this.getCollisionResolution() == 3) {
                    if (this.splitDT == null) {
                        this.splitDT = new SplitDateTime();
                    }
                    this.splitDT.splitDateTimeFormat((SASFormat)this.axisFormat);
                    if (this.splitDT.isSplittable()) {
                        this.splittingTime = true;
                        this.buildSplitedTimeAxis();
                    }
                }
            }
            if (this.splittingTime) {
                this.drawSplittedTimeAxis(g, callHighlightDraw);
            } else {
                this.drawXAxis(g, callHighlightDraw);
            }
        } else {
            this.drawYAxis(g, callHighlightDraw);
        }
        if ((logAxis || this.dateTime) && this.minorTickLineStyle.isVisible() && this.isAxisAutoCalculated() && !this.fontTooSmall && !this.hidingValueLabelsIsRequired) {
            double[] minor = null;
            if (this.dateTime) {
                minor = this.timeTickSpacer.getMinorTickValues();
            } else if (this.logObject != null) {
                minor = this.logObject.minorTickValues;
            }
            if (minor != null) {
                this.drawMinorTicks((Graphics2D)p, minor);
            }
        }
        g.setComposite(comp);
        rHints.clear();
        rHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.addRenderingHints(rHints);
        this.redraw = false;
        this.redrawRequired = false;
    }

    @Override
    public void drawHighlight(Object p) {
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
        return true;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireRedrawEvent(e);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        return false;
    }

    public Object getDataSource() {
        return this.filter;
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return -1;
    }

    @Override
    public Object getRole(Object variableId) {
        return this.axisRole;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        return this.axisVariable;
    }

    @Override
    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean isDiscrete() {
        return this.categorized || this.discrete;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        return false;
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        this.filter = FilterFactory.getDataSourceFilter((Object)source);
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    @Override
    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        this.isXAxis = false;
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase("XAXIS"))) {
            this.isXAxis = true;
        }
        this.axisVariable = variableId;
        if (this.resetFormat) {
            this.axisFormat = this.filter != null ? this.filter.getFormat(variableId, SASFormat.class) : null;
        }
        this.resetFormat = true;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        if (!this.isFirstTime) {
            this.setRangeModel(null);
        }
        this.isFirstTime = false;
        this.rebuildRequired = true;
        this.tickMarkValues = null;
        return true;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    @Override
    public Object getSortOrder(Object variableId) {
        return null;
    }

    @Override
    public boolean setSortOrder(Object variableId, Object order) {
        return false;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (role == null) {
            return null;
        }
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void fireRedrawEvent(RedrawEvent e) {
        if (!this.fireEvent) {
            return;
        }
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.elementAt(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    this.fireEvent = false;
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                    listener.redraw(e);
                    this.fireEvent = false;
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.addElement(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.removeElement(listener);
        }
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        Vector vector = this.displayList;
        synchronized (vector) {
            this.displayList.removeAllElements();
            if (this.tickMarkValues == null) {
                return false;
            }
            Object object = this.tickMarkValuesLock;
            synchronized (object) {
                if (this.timeSplittingPolicy == 1 && this.dateTime) {
                    this.splittingTime = false;
                    if (this.splitDT == null) {
                        this.splitDT = new SplitDateTime();
                    }
                    this.splitDT.splitDateTimeFormat((SASFormat)this.axisFormat);
                    if (this.splitDT.isSplittable()) {
                        this.splittingTime = true;
                        return this.buildSplitedTimeAxis();
                    }
                }
                if (this.dateTime && this.minorTickLineStyle.isVisible() && this.timeTickSpacer != null) {
                    this.createTickMarkValues(this.timeTickSpacer.getDataMin(), this.timeTickSpacer.getDataMax());
                }
                int size = this.tickMarkValues.length;
                if (this.dataIsBinned || this.categorized) {
                    if (this.groupAxis) {
                        int nCat = this.numberOfCategories;
                        for (int i = 0; i < size; ++i) {
                            double p1 = i * (nCat + 1);
                            double p2 = p1 + (double)nCat;
                            Object nm = this.tickMarkValues[i];
                            AxisElement e = new AxisElement();
                            e.value = (p1 + p2) * 0.5;
                            e.unfmtValue = nm;
                            e.description = e.label = this.getTickMarkLabel(nm);
                            this.displayList.addElement(e);
                        }
                    } else {
                        int nGrp = this.numberOfGroups;
                        int g = 0;
                        do {
                            for (int i = 0; i < size; ++i) {
                                Object nm = this.tickMarkValues[i];
                                AxisElement e = new AxisElement();
                                if (this.tickInCenter) {
                                    if (this.numberOfResponses > 1) {
                                        double p1 = i * (this.numberOfResponses + 1);
                                        double p2 = p1 + (double)this.numberOfResponses;
                                        e.value = (p1 + p2) * 0.5;
                                    } else {
                                        e.value = (double)i + 0.5;
                                    }
                                } else {
                                    e.value = i;
                                }
                                e.value += (double)g * ((double)size + 1.0);
                                e.unfmtValue = nm;
                                e.description = e.label = this.getTickMarkLabel(nm);
                                this.displayList.addElement(e);
                            }
                        } while (++g < nGrp);
                    }
                } else {
                    AxisElement e;
                    if (this.missing) {
                        e = new AxisElement();
                        e.value = this.missingValue;
                        e.description = e.label = ".";
                        this.displayList.addElement(e);
                    }
                    for (int i = 0; i < size; ++i) {
                        Object tm = this.tickMarkValues[i];
                        if (!(tm instanceof Double)) continue;
                        e = new AxisElement();
                        e.value = (Double)tm;
                        e.unfmtValue = tm;
                        e.label = this.valueLabels != null ? this.valueLabels[i] : (this.internalTickValueList != null && this.internalTickDisplayList != null ? (i < this.internalTickDisplayList.length ? this.internalTickDisplayList[i] : "") : this.getTickMarkLabel(tm));
                        e.description = e.label;
                        this.displayList.addElement(e);
                    }
                }
            }
        }
        this.rebuildRequired = false;
        this.redraw = true;
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    public void setReverse(int axis, boolean flag) {
        if (!this.reverseEnabled) {
            return;
        }
        switch (axis) {
            case 0: {
                this.xReverse = flag;
                break;
            }
            case 1: {
                this.yReverse = flag;
            }
        }
        this.userSetProperties.set(246);
        this.defaultTransformObject.setReverse(axis, flag);
        this._propertyListeners.firePropertyChange("AXIS_REVERSE", null, new Boolean(flag));
    }

    public boolean isReverse(int axis) {
        return this.defaultTransformObject.isReverse(axis);
    }

    protected Font getLabelFont() {
        return this.labelStyle.getFont();
    }

    protected Font getValueFont() {
        return this.valueLabelStyle.getFont();
    }

    protected Color getColor() {
        return this.axisLineStyle.getColor();
    }

    protected Color getLabelColor() {
        return this.labelStyle.getColor();
    }

    protected Color getValueColor() {
        return this.valueLabelStyle.getColor();
    }

    protected Color getTickMarkColor() {
        return this.majorTickLineStyle.getColor();
    }

    protected Color getGridLineColor() {
        return this.gridLineStyle.getColor();
    }

    protected String getUserLabel() {
        return this.labelStyle.getTextString();
    }

    public double getRotationAngle() {
        return this.valueLabelRotationAngle;
    }

    public boolean setRotationAngle(double newAngle) {
        this.valueLabelRotationAngle = newAngle % (Math.PI * 2);
        return true;
    }

    private void drawXAxis(Graphics2D g, boolean callHighlightDraw) {
        String label;
        FontRenderContext frc = g.getFontRenderContext();
        Font valueFont = this.getCurrentValueLabelFont();
        Color tmColor = this.getTickMarkColor();
        Color tmvColor = this.getValueColor();
        int resolutionMethod = this.getCollisionResolution();
        Stroke oldStroke = g.getStroke();
        int width = this.majorTickLineStyle.getWidth();
        if (SILKUtilities.isScaledUp()) {
            width = (int)((double)width * SILKUtilities.getDPIScaleFactor());
        }
        g.setStroke(new BasicStroke(width, 0, 2));
        int skips = 0;
        if (resolutionMethod == 8) {
            skips = this.getTickmarkValueSkips(frc);
        }
        double[] scr = new double[3];
        double overall_max_y = this.primary ? 0.0 : (double)(this.bBox.y + this.bBox.height);
        int size = this.displayList.size();
        boolean firstRow = true;
        for (int i = 0; i < size; ++i) {
            double ty;
            double tx;
            TextLayout textString;
            Color col;
            AxisElement e;
            double max_y;
            block44: {
                double textHeight;
                Rectangle2D bounds;
                block43: {
                    Font tmvFont;
                    max_y = 0.0;
                    e = (AxisElement)this.displayList.elementAt(i);
                    if (SILKUtilities.isFakeString(e.label)) break;
                    boolean major = false;
                    double delta = 1.0E-6;
                    if (e.value >= this.startPoint[0] - delta && e.value <= this.endPoint[0] + delta || e.value <= this.startPoint[0] + delta && e.value >= this.endPoint[0] - delta) {
                        int ticksize;
                        if (i % (skips + 1) == 0) {
                            major = true;
                            ticksize = 6;
                        } else {
                            major = false;
                            ticksize = this.minorTickLineStyle.isVisible() ? 6 : 3;
                        }
                        if (SILKUtilities.isScaledUp()) {
                            ticksize = (int)((double)ticksize * SILKUtilities.getDPIScaleFactor());
                        }
                        this.transformObject.project(e.value, this.primary ? this.startPoint[1] : this.endPoint[1], 0.0, scr);
                        double d = max_y = this.primary ? scr[1] : (double)(this.bBox.y + this.bBox.height);
                        if (this.majorTickLineStyle.isVisible() && !this.fontTooSmall && !this.hidingValueLabelsIsRequired) {
                            Color color = col = e.tickColor == null ? tmColor : e.tickColor;
                            if (SILKUtilities.useGraphEngraving()) {
                                e.tick = this.primary ? new Line2D.Double(scr[0] + 1.0, scr[1], scr[0] + 1.0, scr[1] + (double)ticksize) : new Line2D.Double(scr[0] + 1.0, this.bBox.y + this.bBox.height, scr[0] + 1.0, this.bBox.y + this.bBox.height - ticksize);
                                g.setColor(this.chartBackgroundColorBright);
                                g.draw(e.tick);
                            }
                            e.tick = this.primary ? new Line2D.Double(scr[0], scr[1], scr[0], scr[1] + (double)ticksize) : new Line2D.Double(scr[0], this.bBox.y + this.bBox.height, scr[0], this.bBox.y + this.bBox.height - ticksize);
                            g.setColor(col);
                            g.draw(e.tick);
                            max_y = this.primary ? (max_y += (double)Math.max(ticksize, 6)) : (max_y -= (double)Math.max(ticksize, 6));
                            if (this.axisType != 2 && !this.dateTime && !this.isDiscrete() && this.minorTickLineStyle.isVisible() && size > 1 && i < size - 1) {
                                AxisElement e2 = (AxisElement)this.displayList.elementAt(i + 1);
                                double[] s1 = new double[3];
                                this.transformObject.project(e2.value, this.primary ? this.startPoint[1] : this.endPoint[1], 0.0, s1);
                                boolean drawMinorTick = true;
                                double minorTickX = s1[0] + (scr[0] - s1[0]) / 2.0;
                                if (minorTickX < (double)this.bBox.x || minorTickX > (double)(this.bBox.x + this.bBox.width)) {
                                    drawMinorTick = false;
                                }
                                if (drawMinorTick) {
                                    if (SILKUtilities.useGraphEngraving()) {
                                        e2.tick = this.primary ? new Line2D.Double(minorTickX + 1.0, scr[1], minorTickX + 1.0, scr[1] + 3.0) : new Line2D.Double(s1[0] + (scr[0] - s1[0]) / 2.0 + 1.0, this.bBox.y + this.bBox.height, s1[0] + (scr[0] - s1[0]) / 2.0 + 1.0, this.bBox.y + this.bBox.height - 3);
                                        g.setColor(this.chartBackgroundColorBright);
                                        g.draw(e2.tick);
                                    }
                                    e2.tick = this.primary ? new Line2D.Double(minorTickX, scr[1], minorTickX, scr[1] + 3.0) : new Line2D.Double(s1[0] + (scr[0] - s1[0]) / 2.0, this.bBox.y + this.bBox.height, s1[0] + (scr[0] - s1[0]) / 2.0, this.bBox.y + this.bBox.height - 3);
                                    g.setColor(col);
                                    g.draw(e2.tick);
                                }
                            }
                        }
                    }
                    if (!(e.value >= this.startPoint[0] - delta && e.value <= this.endPoint[0] + delta) && (!(e.value <= this.startPoint[0] + delta) || !(e.value >= this.endPoint[0] - delta))) continue;
                    if (!this.valueLabelStyle.isVisible() || this.fontTooSmall || this.hidingValueLabelsIsRequired) {
                        overall_max_y = max_y;
                        continue;
                    }
                    if (e.label == null || e.label.trim().equals("") || !major) continue;
                    max_y = this.primary ? (max_y += (double)this.GAP) : (max_y -= (double)this.GAP);
                    String tklab = e.label;
                    if ((resolutionMethod == 6 || resolutionMethod == 7) && tklab.length() >= 9) {
                        tklab = e.label.substring(0, 2);
                        tklab = tklab.concat("...");
                        tklab = tklab.concat(e.label.substring(e.label.length() - 2, e.label.length()));
                    }
                    Font font = tmvFont = this.reduceFont ? FontManager.getFont((String)valueFont.getName(), (int)valueFont.getStyle(), (int)this.valueLabelFontSizeInUse) : valueFont;
                    if (this.resolutionPolicyForValueLabelsIsRequired && (resolutionMethod == 4 || resolutionMethod == 5)) {
                        Font f;
                        AffineTransform fontAT = new AffineTransform();
                        fontAT.rotate(this.valueLabelRotationAngle);
                        tmvFont = f = tmvFont.deriveFont(fontAT);
                    }
                    textString = new TextLayout(tklab, tmvFont, frc);
                    bounds = textString.getBounds();
                    textHeight = textString.getAscent() + textString.getDescent();
                    if (this.fisheyeView) {
                        AxisElement e_next = i < size - 1 ? (AxisElement)this.displayList.elementAt(i + 1) : (AxisElement)this.displayList.elementAt(i - 1);
                        double[] scr_next = this.transformObject.project(e_next.value, this.startPoint[1], 0.0, null);
                        if (Math.abs(scr_next[0] - scr[0]) - 4.0 < bounds.getWidth()) continue;
                    }
                    tx = scr[0];
                    ty = max_y;
                    if (!this.resolutionPolicyForValueLabelsIsRequired) break block43;
                    switch (resolutionMethod) {
                        case 4: 
                        case 5: {
                            tx -= (double)(tmvFont.getSize() / 2);
                            ty += (double)(tmvFont.getSize() / 2);
                            max_y += bounds.getHeight();
                            break;
                        }
                        case 1: 
                        case 3: {
                            tx -= bounds.getWidth() * 0.5;
                            if (this.primary) {
                                ty += (double)textString.getAscent();
                                max_y += textHeight;
                            } else {
                                max_y -= textHeight;
                            }
                            if (!firstRow && this.isDiscrete()) {
                                if (this.primary) {
                                    ty += textHeight;
                                    max_y += textHeight;
                                    break;
                                }
                                ty -= textHeight;
                                max_y -= textHeight;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block44;
                }
                tx -= bounds.getWidth() * 0.5;
                if (this.primary) {
                    ty += (double)textString.getAscent();
                    max_y += textHeight;
                } else {
                    max_y -= textHeight;
                }
            }
            firstRow = !firstRow;
            Color color = col = e.labelColor == null ? tmvColor : e.labelColor;
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                textString.draw(g, (float)tx + 1.0f, (float)ty + 1.0f);
            }
            g.setColor(col);
            textString.draw(g, (float)tx, (float)ty);
            if (!(this.primary && max_y > overall_max_y) && (this.primary || !(max_y < overall_max_y))) continue;
            overall_max_y = max_y;
        }
        g.setStroke(oldStroke);
        if (this.primary) {
            this.drawGridLines(g);
        }
        if (this.axisLineStyle.isVisible()) {
            g.setColor(this.getColor());
            oldStroke = g.getStroke();
            width = this.axisLineStyle.getWidth();
            g.setStroke(new BasicStroke(width, 0, 2));
            Line2D.Double line = null;
            if (this.primary) {
                double[] scr1 = this.transformObject.project(this.startPoint[0], this.startPoint[1], this.startPoint[2], null);
                line = new Line2D.Double(this.bBox.x, scr1[1], this.bBox.x + this.bBox.width, scr1[1]);
            } else {
                line = new Line2D.Double(this.bBox.x, this.bBox.y + this.bBox.height, this.bBox.x + this.bBox.width, this.bBox.y + this.bBox.height);
            }
            g.draw(line);
            g.setStroke(oldStroke);
        }
        String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (label == null || label.trim().equals("") || !this.labelStyle.isVisible() || this.labelTooSmall) {
            return;
        }
        if (!this.defaultLabelPosition && this.maxAxisLabelLength < label.length()) {
            label = label.substring(0, this.maxAxisLabelLength);
            label = label.concat("...");
        }
        Font labFont = this.labelStyle.getFont();
        labFont = labFont.deriveFont((float)SILKUtilities.adjustFontSize(labFont.getSize()));
        Color labColor = this.getLabelColor();
        TextLayout textString = new TextLayout(label, labFont, frc);
        Rectangle2D bounds = textString.getBounds();
        if (bounds.getWidth() > this.axisLength) {
            int len = label.length();
            for (int i = len - 4; i >= 0; --i) {
                String lab = label.substring(0, i);
                textString = new TextLayout(lab = lab.concat("..."), labFont, frc);
                bounds = textString.getBounds();
                if (bounds.getWidth() < this.axisLength) break;
            }
        }
        double tx = 0.0;
        double ty = 0.0;
        double x = this.defaultLabelPosition ? (this.startPoint[0] + this.endPoint[0]) * 0.5 : this.endPoint[0];
        this.transformObject.project(x, this.startPoint[1], 0.0, scr);
        if (this.defaultLabelPosition) {
            tx = (double)this.bBox.x + (double)this.bBox.width * 0.5 - bounds.getWidth() * 0.5;
            if (this.primary) {
                ty = this.margin < 0 ? Math.max(overall_max_y, scr[1]) + (double)this.GAP + (double)textString.getAscent() : (double)((float)this.margin - textString.getDescent());
            } else {
                double d = ty = this.margin < 0 ? overall_max_y - (double)this.GAP : (double)this.margin + bounds.getHeight();
            }
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                textString.draw(g, (float)(tx + 1.0), (float)(ty + 1.0));
            }
            g.setColor(labColor);
            textString.draw(g, (float)tx, (float)ty);
        } else {
            tx = scr[0] + (double)this.GAP + (double)this.labelOffset;
            ty = scr[1] + (double)this.GAP + (double)textString.getAscent();
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                textString.draw(g, (float)(tx + 1.0), (float)(ty + 1.0));
            }
            g.setColor(labColor);
            textString.draw(g, (float)tx, (float)ty);
        }
        if (this.primary) {
            this.drawReferenceLines(g);
        }
    }

    private void drawYAxis(Graphics2D g, boolean callHighlightDraw) {
        int majorTickSizeDrawn;
        FontRenderContext frc = g.getFontRenderContext();
        Font gFont = g.getFont();
        Font valueFont = this.getCurrentValueLabelFont();
        Font tmvFont = this.reduceFont ? FontManager.getFont((String)valueFont.getName(), (int)valueFont.getStyle(), (int)valueFont.getSize()) : valueFont;
        g.setFont(tmvFont);
        Color tmColor = this.getTickMarkColor();
        Color tmvColor = this.getValueColor();
        Font tmvFont_sav = tmvFont;
        int resolutionMethod = this.getCollisionResolution();
        Stroke oldStroke = g.getStroke();
        int width = this.majorTickLineStyle.getWidth();
        if (SILKUtilities.isScaledUp()) {
            width = (int)((double)width * SILKUtilities.getDPIScaleFactor());
        }
        g.setStroke(new BasicStroke(width, 0, 2));
        int skips = 0;
        if (resolutionMethod == 8) {
            skips = this.getTickmarkValueSkips(frc);
        }
        double[] screenCoords = new double[3];
        double max_wt = 0.0;
        int size = this.displayList.size();
        int n = majorTickSizeDrawn = this.hidingValueLabelsIsRequired ? 0 : 6;
        if (SILKUtilities.isScaledUp()) {
            majorTickSizeDrawn = (int)((double)majorTickSizeDrawn * SILKUtilities.getDPIScaleFactor());
        }
        for (int i = size - 1; i >= 0; --i) {
            double tx;
            Color col;
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            if (SILKUtilities.isFakeString(e.label)) break;
            boolean major = false;
            double min = Math.min(this.startPoint[1], this.endPoint[1]) - 1.0E-6;
            double max = Math.max(this.startPoint[1], this.endPoint[1]) + 1.0E-6;
            if (e.value >= min && e.value <= max) {
                int ticksize;
                if (i % (skips + 1) == 0) {
                    major = true;
                    ticksize = majorTickSizeDrawn;
                } else {
                    major = false;
                    ticksize = 3;
                }
                this.transformObject.project(this.primary ? this.endPoint[0] : this.startPoint[0], e.value, 0.0, screenCoords);
                if (this.majorTickLineStyle.isVisible() && !this.fontTooSmall && !this.hidingValueLabelsIsRequired) {
                    Color color = col = e.tickColor == null ? tmColor : e.tickColor;
                    if (SILKUtilities.useGraphEngraving()) {
                        e.tick = this.primary ? new Line2D.Double(screenCoords[0], screenCoords[1] + 1.0, screenCoords[0] - (double)ticksize, screenCoords[1] + 1.0) : new Line2D.Double(this.bBox.x, screenCoords[1] + 1.0, this.bBox.x + ticksize, screenCoords[1] + 1.0);
                        g.setColor(this.chartBackgroundColorBright);
                        g.draw(e.tick);
                    }
                    e.tick = this.primary ? new Line2D.Double(screenCoords[0], screenCoords[1], screenCoords[0] - (double)ticksize, screenCoords[1]) : new Line2D.Double(this.bBox.x, screenCoords[1], this.bBox.x + ticksize, screenCoords[1]);
                    g.setColor(col);
                    g.draw(e.tick);
                    if (this.axisType != 2 && !this.dateTime && !this.isDiscrete() && this.minorTickLineStyle.isVisible() && size > 1 && i < size - 1) {
                        AxisElement e2 = (AxisElement)this.displayList.elementAt(i + 1);
                        double[] s1 = new double[3];
                        this.transformObject.project(this.primary ? this.endPoint[0] : this.startPoint[0], e2.value, 0.0, s1);
                        double minorTickY = screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0;
                        boolean drawMinorTick = true;
                        if (minorTickY < (double)this.bBox.y || minorTickY > (double)(this.bBox.y + this.bBox.height)) {
                            drawMinorTick = false;
                        }
                        if (drawMinorTick) {
                            if (SILKUtilities.useGraphEngraving()) {
                                e2.tick = this.primary ? new Line2D.Double(s1[0], minorTickY + 1.0, s1[0] - 3.0, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0 + 1.0) : new Line2D.Double(this.bBox.x, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0 + 1.0, this.bBox.x + 3, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0 + 1.0);
                                g.setColor(this.chartBackgroundColorBright);
                                g.draw(e2.tick);
                            }
                            e2.tick = this.primary ? new Line2D.Double(s1[0], minorTickY, s1[0] - 3.0, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0) : new Line2D.Double(this.bBox.x, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0, this.bBox.x + 3, screenCoords[1] - (screenCoords[1] - s1[1]) / 2.0);
                            g.setColor(col);
                            g.draw(e2.tick);
                        }
                    }
                }
            }
            if (!(e.value >= min) || !(e.value <= max) || !this.valueLabelStyle.isVisible() || this.fontTooSmall || this.hidingValueLabelsIsRequired || e.label == null || e.label.trim().equals("") || !major) continue;
            if (this.fisheyeView) {
                AxisElement e_next = i < size - 1 ? (AxisElement)this.displayList.elementAt(i + 1) : (AxisElement)this.displayList.elementAt(i - 1);
                double[] scr_next = this.transformObject.project(this.startPoint[0], e_next.value, 0.0, null);
                int newFontSize = (int)((Math.abs(scr_next[1] - screenCoords[1]) - 4.0) * this.axisDefaults.fontSizeAdjust);
                if (newFontSize < this.axisDefaults.adjustedValueSuppressionSize) continue;
                tmvFont = newFontSize < tmvFont_sav.getSize() ? FontManager.getFont((String)tmvFont_sav.getName(), (int)tmvFont_sav.getStyle(), (int)newFontSize) : tmvFont_sav;
                g.setFont(tmvFont);
            }
            String tklab = e.label;
            if ((resolutionMethod == 6 || resolutionMethod == 7) && tklab.length() >= 9) {
                tklab = e.label.substring(0, 2);
                tklab = tklab.concat("...");
                tklab = tklab.concat(e.label.substring(e.label.length() - 2, e.label.length()));
            }
            TextLayout textString = new TextLayout(tklab, tmvFont, frc);
            Rectangle2D bounds = textString.getBounds();
            double d = tx = this.primary ? screenCoords[0] - (double)this.GAP - (double)textString.getVisibleAdvance() : (double)(this.bBox.x + this.GAP);
            if (this.majorTickLineStyle.isVisible()) {
                tx = this.primary ? (tx -= (double)majorTickSizeDrawn) : (tx += (double)majorTickSizeDrawn);
            }
            double ty = screenCoords[1] + (double)(textString.getAscent() - textString.getDescent()) * 0.5;
            Color color = col = e.labelColor == null ? tmvColor : e.labelColor;
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                g.drawString(tklab, (float)tx + 1.0f, (float)ty + 1.0f);
            }
            g.setColor(col);
            g.drawString(tklab, (float)tx, (float)ty);
            max_wt = Math.max(max_wt, bounds.getWidth());
        }
        if (this.primary) {
            this.drawGridLines(g);
        }
        if (this.axisLineStyle.isVisible()) {
            g.setColor(this.getColor());
            oldStroke = g.getStroke();
            width = this.axisLineStyle.getWidth();
            g.setStroke(new BasicStroke(width, 0, 2));
            Line2D.Double line = null;
            if (this.primary) {
                double[] scr1 = this.transformObject.project(this.startPoint[0], this.startPoint[1], this.startPoint[2], null);
                double[] scr2 = this.transformObject.project(this.endPoint[0], this.endPoint[1], this.endPoint[2], null);
                if (Double.isNaN(scr1[0]) || Double.isNaN(scr1[1]) || Double.isNaN(scr2[0]) || Double.isNaN(scr2[1])) {
                    return;
                }
                line = new Line2D.Double(scr2[0], this.bBox.y, scr2[0], this.bBox.y + this.bBox.height);
            } else {
                line = new Line2D.Double(this.bBox.x, this.bBox.y, this.bBox.x, this.bBox.y + this.bBox.height);
            }
            g.draw(line);
        }
        g.setStroke(oldStroke);
        if (!this.labelTooSmall) {
            double tx;
            String label;
            String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
            if (label == null || label.trim().equals("") || !this.labelStyle.isVisible()) {
                return;
            }
            this.transformObject.project(this.startPoint[0], this.endPoint[1], 0.0, screenCoords);
            Font labFont = this.labelStyle.getFont();
            labFont = labFont.deriveFont((float)SILKUtilities.adjustFontSize(labFont.getSize()));
            g.setFont(labFont);
            Color labColor = this.getLabelColor();
            TextLayout textString = new TextLayout(label, labFont, frc);
            Rectangle2D bounds = textString.getBounds();
            if (bounds.getWidth() > this.axisLength) {
                int len = label.length();
                for (int i = len - 4; i >= 0; --i) {
                    label = label.substring(0, i);
                    textString = new TextLayout(label = label.concat("..."), labFont, frc);
                    bounds = textString.getBounds();
                    if (bounds.getWidth() < this.axisLength) break;
                }
            }
            double descent = textString.getDescent();
            AffineTransform fontAT = new AffineTransform();
            if (this.primary) {
                fontAT.rotate(-1.5707963267948966);
            } else {
                fontAT.rotate(1.5707963267948966);
            }
            textString = new TextLayout(label, labFont, frc);
            tx = this.primary ? (this.margin < 0 ? (tx = screenCoords[0] - max_wt - (double)this.GAP - descent - (this.majorTickLineStyle.isVisible() && !this.fontTooSmall ? (double)(majorTickSizeDrawn + this.GAP) : 0.0)) : (double)this.margin + bounds.getHeight()) : (this.margin < 0 ? (double)this.bBox.x + max_wt + (double)this.GAP + descent + (this.majorTickLineStyle.isVisible() ? (double)(Math.max(majorTickSizeDrawn, 6) + this.GAP) : 0.0) : (double)this.margin - bounds.getHeight());
            double ty = (double)this.bBox.y + (double)this.bBox.height * 0.5 + bounds.getWidth() * 0.5;
            if (!this.primary) {
                ty -= bounds.getWidth();
            }
            if (this.groupAxis) {
                ty = screenCoords[1] - (double)this.endOffset + this.axisLength * 0.5 + bounds.getWidth() * 0.5;
            }
            AffineTransform fontAT1 = g.getTransform();
            if (this.primary) {
                g.rotate(-1.5707963267948966, (float)tx, (float)ty);
            } else {
                g.rotate(1.5707963267948966, (float)tx, (float)ty);
            }
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                if (this.primary) {
                    g.drawString(label, (float)(tx - 1.0), (float)(ty + 1.0));
                } else {
                    g.drawString(label, (float)(tx - 1.0), (float)(ty - 1.0));
                }
            }
            g.setColor(labColor);
            g.drawString(label, (float)tx, (float)ty);
            if (fontAT1 != null) {
                g.setTransform(fontAT1);
            }
        }
        g.setFont(gFont);
        if (this.primary) {
            this.drawReferenceLines(g);
        }
    }

    public void drawGridLines(Object obj) {
        if (obj == null || !(obj instanceof Graphics2D) || this.transformObject == null || !this.visible || !this.areGridLinesOn() || this.externalAxis) {
            return;
        }
        Graphics2D g = (Graphics2D)obj;
        double[] scr = new double[3];
        int size = this.displayList.size();
        Stroke oldStroke = g.getStroke();
        int width = this.gridLineStyle.getWidth();
        g.setStroke(new BasicStroke(width, 0, 2));
        g.setColor(this.getGridLineColor());
        for (int i = 0; i < size; ++i) {
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            g.setColor(this.getGridLineColor());
            if (this.isXAxis) {
                if (!this.tickInCenter) {
                    if (!(e.value >= this.startPoint[0] && e.value <= this.endPoint[0]) && (!(e.value <= this.startPoint[0]) || !(e.value >= this.endPoint[0]))) continue;
                    this.transformObject.project(e.value, this.startPoint[1], 0.0, scr);
                    if (SILKUtilities.useGraphEngraving()) {
                        g.setColor(this.chartWallColorBright);
                        g.drawLine((int)scr[0] + 1, this.bBox.y, (int)scr[0] + 1, (int)((double)this.bBox.y + this.gridLineLength));
                        g.setColor(this.chartWallColorDark);
                        g.drawLine((int)scr[0], this.bBox.y, (int)scr[0], (int)((double)this.bBox.y + this.gridLineLength));
                        continue;
                    }
                    g.setColor(this.getGridLineColor());
                    g.drawLine((int)scr[0], this.bBox.y, (int)scr[0], (int)((double)this.bBox.y + this.gridLineLength));
                    continue;
                }
                if (!(e.value + this.widthFactor >= this.startPoint[0] && e.value + this.widthFactor <= this.endPoint[0]) && (!(e.value + this.widthFactor <= this.startPoint[0]) || !(e.value + this.widthFactor >= this.endPoint[0]))) continue;
                this.transformObject.project(e.value + this.widthFactor, this.startPoint[1], 0.0, scr);
                if (SILKUtilities.useGraphEngraving()) {
                    g.setColor(this.chartWallColorBright);
                    g.drawLine((int)scr[0] + 1, (int)scr[1], (int)scr[0] + 1, (int)(scr[1] - this.gridLineLength));
                    g.setColor(this.chartWallColorDark);
                    g.drawLine((int)scr[0], (int)scr[1], (int)scr[0], (int)(scr[1] - this.gridLineLength));
                    continue;
                }
                g.setColor(this.getGridLineColor());
                g.drawLine((int)scr[0], (int)scr[1], (int)scr[0], (int)(scr[1] - this.gridLineLength));
                continue;
            }
            if (!this.tickInCenter) {
                if (!(e.value >= this.startPoint[1] && e.value <= this.endPoint[1]) && (!(e.value <= this.startPoint[1]) || !(e.value >= this.endPoint[1])) || this.startOffset == 0 && e.value == this.startPoint[1]) continue;
                this.transformObject.project(this.startPoint[0], e.value, 0.0, scr);
                if (SILKUtilities.useGraphEngraving()) {
                    g.setColor(this.chartWallColorBright);
                    g.drawLine(this.bBox.x, (int)scr[1] + 1, (int)((double)this.bBox.x + this.gridLineLength), (int)scr[1] + 1);
                    g.setColor(this.chartWallColorDark);
                    g.drawLine(this.bBox.x, (int)scr[1], (int)((double)this.bBox.x + this.gridLineLength), (int)scr[1]);
                    continue;
                }
                g.setColor(this.getGridLineColor());
                g.drawLine(this.bBox.x, (int)scr[1], (int)((double)this.bBox.x + this.gridLineLength), (int)scr[1]);
                continue;
            }
            if (!(e.value + this.widthFactor >= this.startPoint[1] && e.value + this.widthFactor <= this.endPoint[1]) && (!(e.value + this.widthFactor <= this.startPoint[1]) || !(e.value + this.widthFactor >= this.endPoint[1]))) continue;
            this.transformObject.project(this.startPoint[0], e.value + this.widthFactor, 0.0, scr);
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartWallColorBright);
                g.drawLine((int)scr[0], (int)scr[1] + 1, (int)(scr[0] + this.gridLineLength), (int)scr[1] + 1);
                g.setColor(this.chartWallColorDark);
                g.drawLine((int)scr[0], (int)scr[1], (int)(scr[0] + this.gridLineLength), (int)scr[1]);
                continue;
            }
            g.setColor(this.getGridLineColor());
            g.drawLine((int)scr[0], (int)scr[1], (int)(scr[0] + this.gridLineLength), (int)scr[1]);
        }
        g.setStroke(oldStroke);
    }

    private String getTickMarkLabel(Object value) {
        String label = null;
        if (value instanceof String && value.equals(".")) {
            return value.toString();
        }
        if (this.defaultFormat != null) {
            try {
                label = this.defaultFormat.format(value);
            }
            catch (IllegalArgumentException iae) {
                label = value.toString();
            }
        } else {
            String string = label = this.filter != null ? this.filter.getFormattedValue(this.axisVariable, value, null) : value.toString();
        }
        if (label != null) {
            label = label.trim();
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputTickmarks() {
        this.honorThresh = false;
        int num = 0;
        double[] tmvs = null;
        if (this.axisType == 2 && this.logObject != null) {
            num = this.logObject.tickValues.length;
            tmvs = this.logObject.tickValues;
            this.gGood = false;
        } else {
            Object ts = this.axisFormat == null || !(this.axisFormat instanceof SASDateTimeFormat) || this.timeTickSpacer == null || this.axisFormat instanceof SASDateTimeFormat && !ZxAxis.isValidDateTime((double[])new double[]{this.timeTickSpacer.getDataMin(), this.timeTickSpacer.getDataMax()}, (SASFormat)((SASFormat)this.axisFormat)) ? this.tickSpacer : this.timeTickSpacer;
            num = ts.getTickValues().length;
            tmvs = ts.getTickValues();
            this.gGood = true;
        }
        if (num > 1 && tmvs[0] == tmvs[num - 1]) {
            num = 1;
        }
        int start = 0;
        int end = num - 1;
        if (this.useUserSetMinMax && this.userMax >= this.userMin) {
            for (int i = 0; i < num - 1; ++i) {
                if (tmvs[i] < this.userMin) {
                    start = i + 1;
                }
                if (!(tmvs[i + 1] > this.userMax)) continue;
                end = i;
            }
        }
        num = end - start + 1;
        Object object = this.tickMarkValuesLock;
        synchronized (object) {
            this.tickMarkValues = new Object[num];
            if (this.tickMarkValues == null) {
                return;
            }
            int cnt = 0;
            for (int i = start; i <= end; ++i) {
                this.tickMarkValues[cnt] = new Double(tmvs[i]);
                ++cnt;
            }
            if (num == 1 || num > 1 && ((Double)this.tickMarkValues[0]).doubleValue() == ((Double)this.tickMarkValues[num - 1]).doubleValue()) {
                if (this.isXAxis) {
                    this.minValue = this.startPoint[0] = tmvs[0] - 1.0;
                    this.maxValue = this.endPoint[0] = tmvs[0] + 1.0;
                } else {
                    this.minValue = this.startPoint[1] = tmvs[0] - 1.0;
                    this.maxValue = this.endPoint[1] = tmvs[0] + 1.0;
                }
                this.setDefaultFormat(this.maxValue - this.minValue);
            } else {
                if (this.axisType == 2) {
                    double d = this.logObject.min;
                    this.startPoint[this.getAxisIndex()] = d;
                    this.minValue = d;
                    double d2 = this.logObject.max;
                    this.endPoint[this.getAxisIndex()] = d2;
                    this.maxValue = d2;
                } else if (num <= 3) {
                    double d = tmvs[0];
                    this.startPoint[this.getAxisIndex()] = d;
                    this.minValue = d;
                    double d3 = tmvs[num - 1];
                    this.endPoint[this.getAxisIndex()] = d3;
                    this.maxValue = d3;
                } else {
                    if (this.useUserSetMinMax && this.userMax >= this.userMin) {
                        this.startPoint[this.getAxisIndex()] = this.minValue;
                        this.endPoint[this.getAxisIndex()] = this.maxValue;
                    } else {
                        this.applyThreshold();
                    }
                    this.honorThresh = true;
                }
                this.setDefaultFormat(tmvs[1] - tmvs[0]);
            }
        }
        this.rebuildRequired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputFixedTickMarks(double min, double max, int num) {
        Object object = this.tickMarkValuesLock;
        synchronized (object) {
            int n = 0;
            if (num < 0) {
                if (this.tickMarkValues != null) {
                    n = this.tickMarkValues.length;
                } else {
                    this.tickMarkValues = new Object[6];
                    n = 6;
                }
            } else {
                n = num;
                this.tickMarkValues = new Object[num];
            }
            if (min == max) {
                this.tickMarkValues = new Object[1];
                n = 1;
            }
            if (this.tickMarkValues == null) {
                return;
            }
            this.gGood = true;
            if (n > 1) {
                double interval = (max - min) / (double)(n - 1);
                this.tickMarkValues[0] = new Double(min);
                this.tickMarkValues[n - 1] = new Double(max);
                for (int i = 1; i < n - 1; ++i) {
                    this.tickMarkValues[i] = new Double(min + (double)i * interval);
                }
                this.setDefaultFormat(interval);
            } else if (n == 1) {
                this.tickMarkValues[0] = new Double(min);
                this.setDefaultFormat(0.0);
            }
            this.startPoint[this.getAxisIndex()] = min;
            this.endPoint[this.getAxisIndex()] = max;
            if (this.startPoint[this.getAxisIndex()] == this.endPoint[this.getAxisIndex()]) {
                int n2 = this.getAxisIndex();
                this.startPoint[n2] = this.startPoint[n2] - 1.0;
                int n3 = this.getAxisIndex();
                this.endPoint[n3] = this.endPoint[n3] + 1.0;
            }
        }
        this.rebuildRequired = true;
    }

    public void setChartAreaDimension(Dimension dimension) {
        this.setChartAreaDimension(dimension, false);
    }

    public void setChartAreaDimension(Dimension dimension, boolean same) {
        this.chartAreaDimension = dimension;
        this.setDefaultFontSize(dimension.height, same);
        boolean bl = this.suppressRangeSlider = dimension.height >= 100;
        if (this.rangeSlider != null) {
            this.rangeSlider.setVisible(this.suppressRangeSlider);
        }
        this.setDefaultRangeSliderThumbSize(dimension.height);
        if (this.timeSplittingPolicy == 0 && this.splittingTime) {
            this.rebuildRequired = true;
        }
        if (this.dateTime && this.minorTickLineStyle.isVisible() && this.timeTickSpacer != null) {
            this.createTickMarkValues(this.timeTickSpacer.getDataMin(), this.timeTickSpacer.getDataMax());
            this.rebuildRequired = true;
        }
        this.stupidChartUsedStupidSetAxisLengthMethod = true;
    }

    public void setDefaultFontSize(int height) {
        this.setDefaultFontSize(height, false);
    }

    public void setDefaultFontSize(int height, boolean same) {
        Font f;
        int size = 0;
        this.labelTooSmall = false;
        this.componentHeight = height;
        if (!this.labelStyle.hasUserSetValue(9002)) {
            if (UIUtilities.useStyleFontSizes()) {
                size = this.labelStyle.getFont().getSize();
            } else if (same) {
                size = (int)(0.5 * Math.sqrt(height));
                if (size < this.axisDefaults.adjustedValueSuppressionSize) {
                    this.labelTooSmall = true;
                }
                size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
            } else {
                size = (int)(0.5 * Math.sqrt(height) * this.axisDefaults.labelFraction / this.axisDefaults.valueFraction);
                if (size < this.axisDefaults.adjustedLabelSuppressionSize) {
                    this.labelTooSmall = true;
                }
                size = Math.max(this.axisDefaults.minAdjustedLabelFontSize, Math.min(this.axisDefaults.maxAdjustedLabelFontSize, size));
            }
            Font labelFont = this.labelStyle.getFont();
            f = FontManager.getFont((String)labelFont.getName(), (int)labelFont.getStyle(), (int)size);
            this.labelStyle.setFont(f);
            this.labelStyle.setCurrentValueAsDefault(9002);
        }
        this.fontTooSmall = false;
        if (!this.valueLabelStyle.hasUserSetValue(9002)) {
            if (UIUtilities.useStyleFontSizes()) {
                size = this.valueLabelStyle.getFont().getSize();
            } else {
                size = (int)(0.5 * Math.sqrt(height));
                if (size < this.axisDefaults.adjustedValueSuppressionSize) {
                    this.fontTooSmall = true;
                }
                size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
            }
            Font valueFont = this.valueLabelStyle.getFont();
            f = FontManager.getFont((String)valueFont.getName(), (int)valueFont.getStyle(), (int)size);
            this.valueLabelStyle.setFont(f);
            this.valueLabelStyle.setCurrentValueAsDefault(9002);
        }
    }

    public boolean isLabelFontTooSmall() {
        return this.labelTooSmall;
    }

    public boolean isValueFontTooSmall() {
        return this.fontTooSmall;
    }

    public int getTickMarkValueWidth(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        if (this.fontTooSmall) {
            return 0;
        }
        if (!this.valueLabelStyle.isVisible()) {
            return this.majorTickLineStyle.isVisible() ? 6 : 0;
        }
        if (this.rebuildRequired && !this.build(null)) {
            return 0;
        }
        if (this.displayList.size() == 0) {
            return 0;
        }
        int resolutionMethod = this.getCollisionResolution();
        double width = 0.0;
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        Font font = this.getCurrentValueLabelFont();
        int size = this.displayList.size();
        for (int i = 0; i < size; ++i) {
            TextLayout textString;
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            if (e.label == null || e.label.trim().equals("")) continue;
            String tklab = e.label;
            if ((resolutionMethod == 6 || resolutionMethod == 7) && tklab.length() >= 9) {
                tklab = e.label.substring(0, 2);
                tklab = tklab.concat("...");
                tklab = tklab.concat(e.label.substring(e.label.length() - 2, e.label.length()));
            }
            if (!((double)(textString = new TextLayout(tklab, font, frc)).getVisibleAdvance() > width)) continue;
            width = textString.getVisibleAdvance();
        }
        width += (double)this.GAP;
        if (this.majorTickLineStyle.isVisible()) {
            width += 6.0;
        }
        return (int)(width + 0.5);
    }

    public int getLeftWidth(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        double width = 0.0;
        if (this.isXAxis) {
            return (int)(0.5 * (double)this.getValueWidth(g));
        }
        if (this.primary) {
            width = this.getTickValueLabelWidth(g);
        }
        return (int)width;
    }

    public int getRightWidth(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        double width = 0.0;
        if (this.isXAxis) {
            return (int)(0.5 * (double)this.getValueWidth(g));
        }
        width = !this.primary ? (double)this.getTickValueLabelWidth(g) : (double)this.getReferenceLineLabelWidth(g);
        return (int)width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTickValueLabelWidth(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        int numInside = 0;
        double width = 0.0;
        if (!this.fontTooSmall && this.displayList != null) {
            if (this.valueLabelStyle.isVisible()) {
                Font font = this.getCurrentValueLabelFont();
                FontRenderContext frc = null;
                frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
                Vector vector = this.displayList;
                synchronized (vector) {
                    int size = this.displayList.size();
                    for (int i = 0; i < size; ++i) {
                        String tklab;
                        TextLayout textString;
                        AxisElement e = (AxisElement)this.displayList.elementAt(i);
                        if (e.label == null || e.label.trim().equals("")) continue;
                        if (!this.isXAxis && (e.value >= this.startPoint[1] && e.value <= this.endPoint[1] || e.value <= this.startPoint[1] && e.value >= this.endPoint[1])) {
                            ++numInside;
                        }
                        if (!((double)(textString = new TextLayout(tklab = e.label, font, frc)).getVisibleAdvance() > width)) continue;
                        width = textString.getVisibleAdvance();
                    }
                }
            }
            if (this.majorTickLineStyle.isVisible()) {
                int ts = 6;
                if (SILKUtilities.isScaledUp()) {
                    ts = (int)((double)ts * SILKUtilities.getDPIScaleFactor());
                }
                width += width != 0.0 ? (double)(this.GAP + ts) : (double)ts;
            }
        }
        if (this.hidingValueLabelsIsRequired) {
            width = 0.0;
        }
        width += (double)this.GAP;
        if (this.labelStyle.isVisible() && !this.labelTooSmall) {
            int gap;
            double ht = this.getLabelHeight(g);
            int n = gap = SILKGlobal.isFlagSet(4) ? 10 : this.GAP;
            if (ht != 0.0) {
                width += ht + (double)gap;
            }
        }
        return (int)(width + 0.5);
    }

    public int getValueWidth(Graphics2D g) {
        if (!this.isVisible() || !this.valueLabelStyle.isVisible() || this.fontTooSmall || this.displayList.size() == 0) {
            return 0;
        }
        int axisLen = this.isXAxis ? this.bBox.width : this.bBox.height;
        int numberOfValuesToDraw = this.displayList.size();
        if (numberOfValuesToDraw > axisLen / 5) {
            return 0;
        }
        Font font = FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse);
        int width = 0;
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        TextLayout textLayout = null;
        for (int i = 0; i < numberOfValuesToDraw; ++i) {
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            if (SILKUtilities.isFakeString(e.label)) break;
            if (e.label == null || e.label.trim().equals("")) continue;
            textLayout = new TextLayout(e.label, font, frc);
            width = Math.max((int)((double)textLayout.getVisibleAdvance() + 0.5), width);
        }
        return width;
    }

    public int getTickMarkValueWidth(Graphics2D g, int index, boolean fontSize) {
        if (!this.isVisible() || !this.valueLabelStyle.isVisible() || this.fontTooSmall) {
            return 0;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        if (this.displayList.size() == 0) {
            return 0;
        }
        Font font = !fontSize ? this.valueLabelStyle.getFont() : FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse);
        int idx = index < 0 ? this.displayList.size() - 1 : index;
        AxisElement e = (AxisElement)this.displayList.elementAt(idx);
        if (e.label == null || e.label.trim().equals("")) {
            return 0;
        }
        String tklab = e.label;
        int resolutionMethod = this.getCollisionResolution();
        if ((resolutionMethod == 6 || resolutionMethod == 7) && tklab.length() >= 9) {
            tklab = e.label.substring(0, 2);
            tklab = tklab.concat("...");
            tklab = tklab.concat(e.label.substring(e.label.length() - 2, e.label.length()));
        }
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        TextLayout textString = new TextLayout(tklab, font, frc);
        return (int)((double)textString.getVisibleAdvance() + 0.5);
    }

    public int getValueWidth(Graphics2D g, int index) {
        return this.getTickMarkValueWidth(g, index, false);
    }

    public int getTopHeight(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        int height = 0;
        if (this.isXAxis) {
            if (!this.primary) {
                height = this.getTickMarkValueHeight(g);
                if (this.labelStyle.isVisible()) {
                    double ht = this.getLabelHeight(g);
                    height = this.defaultLabelPosition ? (int)((double)height + (height != 0 ? ht + (double)this.GAP : ht)) : Math.max(height, (int)ht);
                }
            } else {
                height = this.getReferenceLineLabelHeight(g);
            }
        }
        return height;
    }

    public int getBottomHeight(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        int height = 0;
        if (this.primary) {
            height = this.getTickMarkValueHeight(g);
            if (this.labelStyle.isVisible() && !this.labelTooSmall) {
                double ht = this.getLabelHeight(g);
                height = this.defaultLabelPosition ? (int)((double)height + (ht + (double)(2 * this.GAP))) : Math.max(height, (int)ht);
                if (SILKGlobal.isFlagSet(4)) {
                    height += this.GAP;
                }
            }
        }
        return height;
    }

    private int getTickMarkValueHeight_default(FontRenderContext frc) {
        double height = 0.0;
        int size = this.displayList.size();
        Font font = this.valueLabelStyle.getFont();
        font = font.deriveFont((float)this.valueLabelFontSizeInUse);
        double textHeight = 0.0;
        if (!this.hidingValueLabelsIsRequired) {
            for (int i = 0; i < size; ++i) {
                TextLayout textString;
                AxisElement e = (AxisElement)this.displayList.elementAt(i);
                if (e.label == null || e.label.trim().equals("") || !((textHeight = (double)((textString = new TextLayout(e.label, font, frc)).getAscent() + textString.getDescent())) > height)) continue;
                height = textHeight;
            }
        }
        return (int)(height + 0.5);
    }

    private int getTickMarkValueHeight_stagger(FontRenderContext frc) {
        int size_no_stagger = this.getTickMarkValueHeight_default(frc);
        if (this.isDiscrete() && this.resolutionPolicyForValueLabelsIsRequired || this.splittingTime) {
            return size_no_stagger * 2;
        }
        return size_no_stagger;
    }

    private int getTickMarkValueHeight_rotate(FontRenderContext frc) {
        Font font = this.getCurrentValueLabelFont();
        double height = 0.0;
        int size = this.displayList.size();
        for (int i = 0; i < size; ++i) {
            TextLayout textLayout;
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            if (e.label == null || e.label.trim().equals("") || SILKUtilities.isFakeString(e.label) || !(height < (double)(textLayout = new TextLayout(e.label, font, frc)).getVisibleAdvance())) continue;
            height = textLayout.getVisibleAdvance();
        }
        if (this.resolutionPolicyForValueLabelsIsRequired && (this.getCollisionResolution() == 4 || this.getCollisionResolution() == 5)) {
            height += (double)(font.getSize() / 2);
        }
        return (int)(height + 1.5);
    }

    public int getTickMarkValueHeight(Graphics2D g) {
        if (!this.isVisible() || this.fontTooSmall) {
            return 0;
        }
        if (!this.valueLabelStyle.isVisible()) {
            return this.majorTickLineStyle.isVisible() ? 6 : this.GAP;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        if (this.stupidChartUsedStupidSetAxisLengthMethod) {
            this.layoutValueLabels(g);
        }
        if (this.displayList.size() == 0 || this.hidingValueLabelsIsRequired) {
            return 0;
        }
        int height = 0;
        if (this.resolutionPolicyForValueLabelsIsRequired) {
            switch (this.getCollisionResolution()) {
                case 0: 
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    height = this.getTickMarkValueHeight_default(frc);
                    if (!this.splittingTime) break;
                    height += height;
                    break;
                }
                case 1: 
                case 3: {
                    height = this.getTickMarkValueHeight_stagger(frc);
                    break;
                }
                case 4: 
                case 5: {
                    height = this.getTickMarkValueHeight_rotate(frc);
                }
            }
        } else {
            height = this.getTickMarkValueHeight_default(frc);
            if (this.splittingTime) {
                height += height;
            }
        }
        if (this.hidingValueLabelsIsRequired) {
            return 0;
        }
        height += this.GAP;
        if (this.majorTickLineStyle.isVisible()) {
            height += 6;
        }
        return height;
    }

    public int getValueHeight(Graphics2D g, int index) {
        double height = 0.0;
        height = this.getTickMarkValueHeight(g, index);
        return (int)height;
    }

    public int getTickMarkValueHeight(Graphics2D g, int index) {
        if (!this.isVisible() || !this.valueLabelStyle.isVisible() || this.fontTooSmall) {
            return 0;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        if (this.displayList.size() == 0) {
            return 0;
        }
        Font font = this.valueLabelStyle.getFont();
        if (SILKUtilities.isScaledUp()) {
            font = new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * SILKUtilities.getDPIScaleFactor()));
        }
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        int idx = index < 0 ? this.displayList.size() - 1 : index;
        AxisElement e = (AxisElement)this.displayList.elementAt(idx);
        if (e.label == null || e.label.trim().equals("")) {
            return 0;
        }
        int resolutionMethod = this.getCollisionResolution();
        if (this.resolutionPolicyForValueLabelsIsRequired && (resolutionMethod == 4 || resolutionMethod == 5)) {
            AffineTransform fontAT = new AffineTransform();
            fontAT.rotate(this.getRotationAngle());
            font = font.deriveFont(fontAT);
        }
        TextLayout textString = new TextLayout(e.label, font, frc);
        double textHeight = textString.getAscent() + textString.getDescent();
        return (int)(textHeight + 0.5);
    }

    private int computeValueLabelFontSizeInUse() {
        this.valueLabelFontSizeInUse = SILKUtilities.adjustFontSize(this.valueLabelStyle.getFont().getSize());
        return this.valueLabelFontSizeInUse;
    }

    private Font getCurrentValueLabelFont() {
        if (this.valueLabelFontSizeInUse <= 0) {
            this.computeValueLabelFontSizeInUse();
        }
        Font f = this.valueLabelStyle.getFont();
        return f.deriveFont((float)this.valueLabelFontSizeInUse);
    }

    public void layoutValueLabels(Object o) {
        FontRenderContext frc = null;
        if (o instanceof Graphics2D) {
            frc = ((Graphics2D)o).getFontRenderContext();
        } else if (o instanceof FontRenderContext) {
            frc = (FontRenderContext)o;
        }
        if (frc == null) {
            frc = new FontRenderContext(null, true, true);
        }
        this.computeValueLabelFontSizeInUse();
        this.hidingValueLabelsIsRequired = false;
        this.resolutionPolicyForValueLabelsIsRequired = false;
        if (this.isXAxis) {
            if (!this.hasXAxisCollision(false, frc)) {
                return;
            }
            if (!this.hasXAxisCollision(true, frc)) {
                int axisHeight;
                this.resolutionPolicyForValueLabelsIsRequired = true;
                if ((this.getCollisionResolution() == 4 || this.getCollisionResolution() == 5) && (double)(axisHeight = this.getBottomHeight(null)) > (double)this.componentHeight * this.axisDefaults.suppressionFactor) {
                    this.labelTooSmall = true;
                    this.fontTooSmall = true;
                }
                return;
            }
        } else if (!this.hasYAxisCollision(frc)) {
            return;
        }
        this.hidingValueLabelsIsRequired = true;
    }

    private boolean hasXAxisCollision(boolean useResolutionPolicy, FontRenderContext frc) {
        int resolutionPolicy = this.getCollisionResolution();
        if (resolutionPolicy == 8) {
            return false;
        }
        AxisElement e = null;
        Font font = FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse);
        double[] screenCoordinates = new double[3];
        Rectangle2D.Double previousLabelBounds1 = null;
        Rectangle2D.Double previousLabelBounds2 = null;
        Rectangle2D.Double thisLabelBounds = null;
        boolean foundCollision = false;
        boolean firstRow = true;
        TextLayout valueLabelText = null;
        float spaceRequiredByValueLabel = 0.0f;
        float spaceBetweenValueLabels = new TextLayout("Z", font, frc).getVisibleAdvance();
        int numberOfAxisElements = this.displayList.size();
        if (useResolutionPolicy && (resolutionPolicy == 4 || resolutionPolicy == 5)) {
            for (int i = 0; i < numberOfAxisElements; ++i) {
                e = (AxisElement)this.displayList.elementAt(i);
                if (SILKUtilities.isFakeString(e.label) || e.label == null || e.label.trim().equals("")) continue;
                screenCoordinates[0] = this.isDiscrete() && Math.abs(this.endPoint[0] - this.startPoint[0]) >= (double)(numberOfAxisElements - 1) ? e.value / (double)numberOfAxisElements * (this.axisLength - (double)this.startOffset - (double)this.endOffset) - (double)this.startOffset : (e.value + this.startPoint[0]) / (this.endPoint[0] - this.startPoint[0]) * (this.axisLength - (double)this.startOffset - (double)this.endOffset) - (double)this.startOffset;
                valueLabelText = new TextLayout(e.label, font, frc);
                spaceRequiredByValueLabel = this.valueLabelFontSizeInUse;
                thisLabelBounds = new Rectangle2D.Double(screenCoordinates[0] - (double)((spaceRequiredByValueLabel + spaceBetweenValueLabels) / 2.0f), screenCoordinates[1], spaceRequiredByValueLabel + spaceBetweenValueLabels, valueLabelText.getBounds().getHeight());
                if (previousLabelBounds1 == null) {
                    previousLabelBounds1 = thisLabelBounds;
                    continue;
                }
                foundCollision = thisLabelBounds.intersects(previousLabelBounds1);
                break;
            }
        } else {
            for (int i = 0; i < numberOfAxisElements; ++i) {
                e = (AxisElement)this.displayList.elementAt(i);
                if (SILKUtilities.isFakeString(e.label) || e.label == null || e.label.trim().equals("")) continue;
                screenCoordinates[0] = this.isDiscrete() && Math.abs(this.endPoint[0] - this.startPoint[0]) >= (double)(numberOfAxisElements - 1) ? e.value / (double)numberOfAxisElements * (this.axisLength - (double)this.startOffset - (double)this.endOffset) - (double)this.startOffset : (e.value + this.startPoint[0]) / (this.endPoint[0] - this.startPoint[0]) * (this.axisLength - (double)this.startOffset - (double)this.endOffset) - (double)this.startOffset;
                valueLabelText = new TextLayout(e.label, font, frc);
                spaceRequiredByValueLabel = valueLabelText.getVisibleAdvance();
                thisLabelBounds = new Rectangle2D.Double(screenCoordinates[0] - (double)((spaceRequiredByValueLabel + spaceBetweenValueLabels) / 2.0f), screenCoordinates[1], spaceRequiredByValueLabel + spaceBetweenValueLabels, valueLabelText.getBounds().getHeight());
                if (firstRow) {
                    if (previousLabelBounds1 == null) {
                        previousLabelBounds1 = thisLabelBounds;
                    } else {
                        if (thisLabelBounds.intersects(previousLabelBounds1)) {
                            foundCollision = true;
                            break;
                        }
                        previousLabelBounds1 = thisLabelBounds;
                    }
                } else if (previousLabelBounds2 == null) {
                    previousLabelBounds2 = thisLabelBounds;
                } else {
                    if (thisLabelBounds.intersects(previousLabelBounds2)) {
                        foundCollision = true;
                        break;
                    }
                    previousLabelBounds2 = thisLabelBounds;
                }
                if (!useResolutionPolicy || resolutionPolicy != 1 && resolutionPolicy != 3) continue;
                firstRow = !firstRow;
            }
        }
        return foundCollision;
    }

    private boolean hasYAxisCollision(FontRenderContext frc) {
        switch (this.getCollisionResolution()) {
            case 8: {
                return false;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                Font font = FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse);
                double[] screenCoordinates = new double[3];
                Rectangle2D.Double previousLabelBounds = null;
                Rectangle2D.Double thisLabelBounds = null;
                TextLayout valueLabelText = null;
                boolean foundCollision = false;
                int numberOfAxisElements = this.displayList.size();
                for (int i = 0; i < numberOfAxisElements; ++i) {
                    AxisElement e = (AxisElement)this.displayList.elementAt(i);
                    if (SILKUtilities.isFakeString(e.label)) break;
                    if (e.label == null || e.label.trim().equals("")) continue;
                    screenCoordinates[1] = (this.startPoint[1] + e.value) / (this.endPoint[1] - this.startPoint[1]) * (this.axisLength - (double)this.startOffset - (double)this.endOffset) - (double)this.startOffset;
                    valueLabelText = new TextLayout(e.label, font, frc);
                    thisLabelBounds = new Rectangle2D.Double(screenCoordinates[0], screenCoordinates[1], valueLabelText.getBounds().getWidth(), 3 + this.valueLabelFontSizeInUse);
                    if (previousLabelBounds == null) {
                        previousLabelBounds = thisLabelBounds;
                        continue;
                    }
                    if (thisLabelBounds.intersects(previousLabelBounds)) {
                        foundCollision = true;
                        break;
                    }
                    previousLabelBounds = thisLabelBounds;
                }
                return foundCollision;
            }
        }
        return false;
    }

    public int getLabelHeight(Graphics2D g) {
        String label;
        if (!this.isVisible() || !this.labelStyle.isVisible()) {
            return 0;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (label == null || label.trim().equals("")) {
            return 0;
        }
        Font font = this.labelStyle.getFont();
        font = font.deriveFont((float)SILKUtilities.adjustFontSize(font.getSize()));
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        TextLayout textString = new TextLayout(label, font, frc);
        return (int)((double)(textString.getAscent() + textString.getDescent()) + 0.5);
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public void setAxisLength(double len) {
        this.axisLength = len;
        this.stupidChartUsedStupidSetAxisLengthMethod = true;
    }

    public void setGridLineLength(double len) {
        this.gridLineLength = len;
        this.stupidChartUsedStupidSetAxisLengthMethod = true;
    }

    public void adjustTickMarkValues() {
        long obs1 = 0L;
        if (this.filter == null) {
            return;
        }
        long obs2 = this.filter.getNumberObservations(-1);
        this.adjustTickMarkValues(obs1, obs2);
    }

    public void adjustTickMarkValues(long obs1, long obs2) {
        if (this.fixedEndPoints) {
            return;
        }
        Font font = this.valueLabelStyle.getFont();
        LineMetrics lm = font.getLineMetrics("W", new FontRenderContext(null, false, false));
        int ticks = (int)(this.axisLength / (double)lm.getHeight());
        if ((ticks = Math.min(6, Math.max(ticks, 2))) != this.maxTicks) {
            this.maxTicks = ticks;
            this.createTickMarkValues(obs1, obs2);
        }
    }

    public double[] getMinMaxTickMarkValues() {
        if (this.tickMarkValues == null) {
            return null;
        }
        double[] val = new double[2];
        if (this.dateTime && this.autoCalculated) {
            val[0] = this.timeTickSpacer.getTickMin();
            val[1] = this.timeTickSpacer.getTickMax();
        } else {
            val[0] = !(this.tickMarkValues[0] instanceof Double) ? 0.0 : this.minValue;
            val[1] = !(this.tickMarkValues[this.tickMarkValues.length - 1] instanceof Double) ? (double)(this.tickMarkValues.length - 1) : this.maxValue;
        }
        return val;
    }

    public void setFireEvent(boolean fire) {
        this.fireEvent = fire;
    }

    public String getToolTipText(int mouseX, int mouseY) {
        int index;
        if (!this.visible) {
            return null;
        }
        String desc = null;
        desc = this.getRefToolTip(mouseX, mouseY);
        if (desc == null && (index = this.getIndexOfDisplayList(mouseX, mouseY)) >= 0) {
            AxisElement e = (AxisElement)this.displayList.elementAt(index);
            desc = e.description;
        }
        return desc;
    }

    private int getIndexOfDisplayList(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(mouseX - 1, mouseY - 1, 3.0, 3.0);
        int size = this.displayList.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            if (e.tick == null || !e.tick.intersects(rect)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getTickmarkValueSkips(FontRenderContext thisFRC) {
        this.computeValueLabelFontSizeInUse();
        int displayListSize = this.displayList.size();
        int skipSize = 1;
        AxisElement e = null;
        boolean foundCollision = false;
        double[] tempScreenCoordinates = new double[3];
        Font thisFont = FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse);
        Rectangle2D.Double thisLabelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Rectangle2D.Double prevLabelBounds = null;
        TextLayout thisLabelText = null;
        if (this.isXAxis) {
            while (true) {
                foundCollision = false;
                prevLabelBounds = null;
                for (int i = 0; i < displayListSize; i += skipSize) {
                    e = (AxisElement)this.displayList.elementAt(i);
                    if (SILKUtilities.isFakeString(e.label)) break;
                    if (e.label == null || e.label.trim().equals("")) continue;
                    thisLabelText = new TextLayout(e.label, thisFont, thisFRC);
                    this.transformObject.project(e.value, this.startPoint[1], 0.0, tempScreenCoordinates);
                    ((Rectangle2D)thisLabelBounds).setRect(tempScreenCoordinates[0] - 0.5 * (double)thisLabelText.getVisibleAdvance(), tempScreenCoordinates[1], thisLabelText.getVisibleAdvance() + (float)this.GAP, this.valueLabelFontSizeInUse);
                    if (prevLabelBounds == null) {
                        prevLabelBounds = new Rectangle2D.Double();
                        ((Rectangle2D)prevLabelBounds).setRect(thisLabelBounds);
                        continue;
                    }
                    if (thisLabelBounds.intersects(prevLabelBounds)) {
                        foundCollision = true;
                        break;
                    }
                    ((Rectangle2D)prevLabelBounds).setRect(thisLabelBounds);
                }
                if (foundCollision && skipSize != displayListSize) {
                    ++skipSize;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                foundCollision = false;
                prevLabelBounds = null;
                for (int i = 0; i < displayListSize; i += skipSize) {
                    e = (AxisElement)this.displayList.elementAt(i);
                    if (SILKUtilities.isFakeString(e.label)) break;
                    if (e.label == null || e.label.trim().equals("")) continue;
                    thisLabelText = new TextLayout(e.label, thisFont, thisFRC);
                    this.transformObject.project(this.startPoint[0], e.value, 0.0, tempScreenCoordinates);
                    ((Rectangle2D)thisLabelBounds).setRect(tempScreenCoordinates[0], tempScreenCoordinates[1] - 0.5 * (double)this.valueLabelFontSizeInUse, thisLabelText.getVisibleAdvance(), this.valueLabelFontSizeInUse + this.GAP);
                    if (prevLabelBounds == null) {
                        prevLabelBounds = new Rectangle2D.Double();
                        ((Rectangle2D)prevLabelBounds).setRect(thisLabelBounds);
                        continue;
                    }
                    if (thisLabelBounds.intersects(prevLabelBounds)) {
                        foundCollision = true;
                        break;
                    }
                    ((Rectangle2D)prevLabelBounds).setRect(thisLabelBounds);
                }
                if (!foundCollision || skipSize == displayListSize) break;
                ++skipSize;
            }
        }
        return skipSize - 1;
    }

    public void applyStyle(Style style) {
        if (style == null) {
            return;
        }
        this.axisLineStyle.setColor(style.getLineStyleElement("AxisLines").getLineColor());
        this.axisLineStyle.setCurrentValueAsDefault(9502);
        this.labelStyle.setColor(style.getTextStyleElement("LabelText").getTextColor());
        this.labelStyle.setCurrentValueAsDefault(9001);
        this.labelStyle.setFont(style.getTextStyleElement("LabelText").getFont());
        this.labelStyle.setCurrentValueAsDefault(9002);
        this.valueLabelStyle.setColor(style.getTextStyleElement("ValueText").getTextColor());
        this.valueLabelStyle.setCurrentValueAsDefault(9001);
        this.valueLabelStyle.setFont(style.getTextStyleElement("ValueText").getFont());
        this.valueLabelStyle.setCurrentValueAsDefault(9002);
        this.majorTickLineStyle.setColor(style.getLineStyleElement("AxisLines").getLineColor());
        this.majorTickLineStyle.setCurrentValueAsDefault(9502);
        this.gridLineStyle.setColor(style.getLineStyleElement("GridLines").getLineColor());
        this.gridLineStyle.setCurrentValueAsDefault(9502);
        this.setBackgroundColor(style.getFillStyleElement("Backfill").getFillColor());
        this.setWallColor(style.getFillStyleElement("WallFill").getFillColor());
        this.updateReferenceLineColors(style);
        this.updateRangeSliderColors();
    }

    public void updateReferenceLineColors(Style style) {
        LineStyleElement lse = style.getLineStyleElement("Reference");
        if (this.reflines != null) {
            for (int i = 0; i < this.reflines.size(); ++i) {
                ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
                if (rline == null) continue;
                rline.getLine().setColor(lse.getLineColor());
                rline.getLabel().setColor(this.valueLabelStyle.getColor());
            }
        }
    }

    public void updateReferenceLineColors() {
        if (this.reflines != null) {
            for (int i = 0; i < this.reflines.size(); ++i) {
                ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
                if (rline == null) continue;
                rline.getLine().setColor(this.axisLineStyle.getColor());
                rline.getLabel().setColor(this.valueLabelStyle.getColor());
            }
        }
    }

    public int getReferenceLineLabelWidth(Graphics2D g) {
        if (!this.refLineLabelVisible) {
            return 0;
        }
        FontRenderContext frc = g == null ? new FontRenderContext(null, false, false) : g.getFontRenderContext();
        double width = 0.0;
        for (int i = 0; i < this.reflines.size(); ++i) {
            Font refFont;
            double v;
            ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (rline == null || !rline.getLabel().isVisible() || rline.getSameLabelSide() || rline.getValue() == null || !(rline.getValue() instanceof Number) || (v = ((Number)rline.getValue()).doubleValue()) < this.minValue || v > this.maxValue) continue;
            String lab = rline.getLabelString();
            TextLayout textString = new TextLayout(lab, (refFont = rline.getLabel().getFont()) != null ? refFont : this.valueLabelStyle.getFont(), frc);
            double w = textString.getBounds().getWidth();
            if (!(width < w)) continue;
            width = w;
        }
        if (width > 0.0) {
            width += (double)this.GAP;
        }
        return (int)width;
    }

    public int getReferenceLineLabelHeight(Graphics2D g) {
        if (!this.refLineLabelVisible) {
            return 0;
        }
        FontRenderContext frc = g == null ? new FontRenderContext(null, false, false) : g.getFontRenderContext();
        double height = 0.0;
        for (int i = 0; i < this.reflines.size(); ++i) {
            Font refFont;
            TextLayout textString;
            double h;
            String lab;
            double v;
            ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (rline == null || !rline.getLabel().isVisible() || rline.getSameLabelSide() || rline.getValue() == null || !(rline.getValue() instanceof Number) || (v = ((Number)rline.getValue()).doubleValue()) < this.minValue || v > this.maxValue || (lab = rline.getLabelString()) == null || lab.trim().equals("") || !rline.getLabel().isVisible() || !this.refLineLabelVisible || !(height < (h = (textString = new TextLayout(lab, (refFont = rline.getLabel().getFont()) != null ? refFont : this.valueLabelStyle.getFont(), frc)).getBounds().getHeight()))) continue;
            height = h;
        }
        if (height > 0.0) {
            height += (double)this.GAP;
        }
        return (int)height;
    }

    public void drawReferenceLines(Graphics g1) {
        if (this.reflines.size() == 0 || this.isExternalAxis()) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        FontRenderContext frc = g.getFontRenderContext();
        double[] scr1 = new double[3];
        double[] scr2 = new double[3];
        Stroke oldStroke = g.getStroke();
        for (int i = 0; i < this.reflines.size(); ++i) {
            double v;
            ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (rline == null || rline.getValue() == null || !(rline.getValue() instanceof Number) || (v = ((Number)rline.getValue()).doubleValue()) < this.minValue || v > this.maxValue) continue;
            v = this.valueTransform(v);
            if (!(this.isXAxis && v >= this.startPoint[0] && v <= this.endPoint[0] || this.isXAxis && v <= this.startPoint[0] && v >= this.endPoint[0] || !this.isXAxis && v >= this.startPoint[1] && v <= this.endPoint[1]) && (this.isXAxis || !(v <= this.startPoint[1]) || !(v >= this.endPoint[1]))) continue;
            if (this.isXAxis) {
                this.transformObject.project(v, this.startPoint[1], 0.0, scr1);
                scr2[0] = scr1[0];
                scr1[1] = this.bBox.y;
                scr2[1] = scr1[1] + this.gridLineLength;
            } else {
                this.transformObject.project(this.startPoint[0], v, 0.0, scr1);
                scr1[0] = this.bBox.x;
                scr2[0] = scr1[0] + this.gridLineLength;
                scr2[1] = scr1[1];
            }
            if (rline.getLine().isVisible()) {
                g.setColor(rline.getLine().getColor());
                int width = rline.getLine().getWidth();
                g.setStroke(new BasicStroke(width, 0, 2));
                g.drawLine((int)scr1[0], (int)scr1[1], (int)scr2[0], (int)scr2[1]);
                ((ReferenceLine)rline).setLine2D(new Line2D.Double(scr1[0], scr1[1], scr2[0], scr2[1]));
            }
            double tx = 0.0;
            double ty = 0.0;
            String lab = rline.getLabelString();
            if (lab == null || lab.trim().equals("") || !rline.getLabel().isVisible() || !this.refLineLabelVisible) continue;
            Font refFont = rline.getLabel().getFont();
            TextLayout textString = new TextLayout(lab, refFont != null ? refFont : this.valueLabelStyle.getFont(), frc);
            if (this.isXAxis) {
                if (rline.getSameLabelSide()) {
                    tx = scr1[0] - 0.5 * textString.getBounds().getWidth();
                    ty = scr1[1] + (double)this.GAP + (double)textString.getAscent();
                } else {
                    tx = scr2[0] - 0.5 * textString.getBounds().getWidth();
                    ty = scr1[1] - (double)this.GAP - (double)textString.getDescent();
                }
            } else if (rline.getSameLabelSide()) {
                tx = scr1[0] - (double)this.GAP - textString.getBounds().getWidth();
                ty = scr1[1] + (double)(textString.getAscent() - textString.getDescent()) * 0.5;
            } else {
                tx = scr2[0] + (double)this.GAP;
                ty = scr2[1] + (double)(textString.getAscent() - textString.getDescent()) * 0.5;
            }
            g.setColor(rline.getLabel().getColor());
            textString.draw(g, (float)tx, (float)ty);
        }
        g.setStroke(oldStroke);
    }

    protected boolean setNumberTickMarks(int n, boolean setMinMax) {
        if (this.tickSpacer == null) {
            this.tickSpacer = new ContinuousTickSpacer();
        }
        if (n <= 0) {
            this.tickSpacer.getPreference().setAutoInterval(true);
        } else {
            this.tickSpacer.setTickCount(n);
            this.tickSpacer.getPreference().setAutoInterval(false);
        }
        this.createTickMarkValues(this.minValue, this.maxValue);
        double[] ends = this.getMinMaxTickMarkValues();
        RedrawEvent e = new RedrawEvent(this);
        double[] bbox = new double[]{0.0, ends[0], 0.0, 0.0, ends[1], 0.0};
        e.newBoundingBox = bbox;
        e.type = 2;
        this.fireRedrawEvent(e);
        return true;
    }

    protected boolean setTickMarkValues(Object[] values) {
        int size = values.length;
        if (size == 0) {
            return false;
        }
        if (values[0] instanceof Object[] && ((Object[])values[0])[0] instanceof Number && ((Object[])values[0])[1] instanceof String) {
            this.tickMarkValues = new Object[size];
            this.valueLabels = new String[size];
            for (int i = 0; i < size; ++i) {
                Object nm = values[i];
                double d = ((Number)((Object[])nm)[0]).doubleValue();
                this.tickMarkValues[i] = new Double(d);
                Object obj = ((Object[])nm)[1];
                this.valueLabels[i] = this.getTickMarkLabel(obj);
            }
            this.minValue = 0.0;
            this.maxValue = size;
        } else {
            this.dataIsBinned = values[0] instanceof double[];
            this.categorized = true;
            this.tickMarkValues = !this.dataIsBinned ? new Object[size] : new Object[size + 1];
            boolean missing = false;
            for (int i = 0; i < size; ++i) {
                Object nm = values[i];
                if (!this.dataIsBinned) {
                    this.tickMarkValues[i] = nm;
                    continue;
                }
                if (nm instanceof String) {
                    this.tickMarkValues[i + 1] = nm;
                    missing = true;
                    continue;
                }
                double d = ((double[])nm)[1];
                this.tickMarkValues[i + 1] = new Double(d);
                if (i != 0) continue;
                d = ((double[])nm)[0];
                this.tickMarkValues[i] = new Double(d);
            }
            if (!this.dataIsBinned) {
                this.minValue = 0.0;
                this.maxValue = size == 1 ? 0.0 : (double)(size - 1);
            } else {
                if (missing) {
                    --size;
                }
                this.minValue = 0.0;
                this.maxValue = size;
                this.gGood = true;
                this.setDefaultFormat((Double)this.tickMarkValues[1] - (Double)this.tickMarkValues[0]);
            }
        }
        this.startPoint[this.getAxisIndex()] = this.minValue;
        this.endPoint[this.getAxisIndex()] = this.maxValue;
        if (this.isXAxis && this.tickInCenter && this.numberOfResponses > 1) {
            this.endPoint[this.getAxisIndex()] = this.maxValue * (double)(this.numberOfResponses + 1);
        }
        if (this.startPoint[this.getAxisIndex()] == this.endPoint[this.getAxisIndex()]) {
            this.startPoint[this.getAxisIndex()] = -1.0;
            this.endPoint[this.getAxisIndex()] = 1.0;
        }
        if (this.rangeModel != null) {
            this.setRangeModel(null);
        }
        this.rebuildRequired = true;
        this.build(null);
        return true;
    }

    protected boolean setEquallySpacedTickMarkValues(Object low, Object high, Object[] values) {
        int size = values.length;
        if (size == 0) {
            return false;
        }
        if (low == null || !(low instanceof Number) || high == null || !(high instanceof Number)) {
            return false;
        }
        if (!(values[0] instanceof Number)) {
            return false;
        }
        this.tickMarkValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.tickMarkValues[i] = values[i];
        }
        this.minValue = (Double)low;
        this.maxValue = (Double)high;
        this.startPoint[this.getAxisIndex()] = this.minValue;
        this.endPoint[this.getAxisIndex()] = this.maxValue;
        if (this.startPoint[this.getAxisIndex()] == this.endPoint[this.getAxisIndex()]) {
            this.startPoint[this.getAxisIndex()] = -1.0;
            this.endPoint[this.getAxisIndex()] = 1.0;
        }
        if (this.rangeModel != null) {
            if (this.layoutRangeModel) {
                this.ordinal = true;
                if (this.rangeSlider != null) {
                    this.rangeSlider.setExclusive(!this.ordinal);
                }
                this.rangeModel.setMinimum((Double)this.tickMarkValues[0]);
                this.rangeModel.setMaximum((Double)this.tickMarkValues[this.tickMarkValues.length - 2]);
                this.ordinalAdjust = (((Number)this.tickMarkValues[1]).doubleValue() - ((Number)this.tickMarkValues[0]).doubleValue()) / 2.0;
                this.rangeModel.setPrecision(new Double(((Number)this.tickMarkValues[1]).doubleValue() - ((Number)this.tickMarkValues[0]).doubleValue()));
            }
            this.rangeModel.setVisibleMinimum((Double)this.tickMarkValues[0]);
            this.rangeModel.setVisibleMaximum((Double)this.tickMarkValues[this.tickMarkValues.length - 2]);
        }
        this.rebuildRequired = true;
        this.build(null);
        return true;
    }

    protected boolean setSpacedTickMarkValues(Object[] values, Object low, Object high) {
        int size = values.length;
        if (size == 0) {
            return false;
        }
        if (values[0] instanceof Object[] && ((Object[])values[0])[0] instanceof Number && ((Object[])values[0])[1] instanceof String) {
            this.tickMarkValues = new Object[size];
            this.valueLabels = new String[size];
            for (int i = 0; i < size; ++i) {
                Object nm = values[i];
                double d = ((double[])nm)[0];
                this.tickMarkValues[i] = new Double(d);
                this.valueLabels[i] = this.getTickMarkLabel(((Object[])nm)[1]);
            }
            this.discrete = true;
        } else {
            Vector sortedValues = this.sortValueList(values);
            size = sortedValues.size();
            this.tickMarkValues = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.tickMarkValues[i] = sortedValues.elementAt(i);
            }
            this.gGood = true;
            if (size > 1) {
                this.minValue = ((Number)sortedValues.elementAt(0)).doubleValue();
                this.maxValue = ((Number)sortedValues.elementAt(size - 1)).doubleValue();
                this.setDefaultFormat(((Number)sortedValues.elementAt(1)).doubleValue() - ((Number)sortedValues.elementAt(0)).doubleValue());
            } else {
                this.minValue = this.maxValue = ((Number)sortedValues.elementAt(0)).doubleValue();
                this.setDefaultFormat(this.minValue);
            }
            if (low != null && low instanceof Number && !Double.isInfinite(((Number)low).doubleValue()) && !Double.isNaN(((Number)low).doubleValue())) {
                this.minValue = Math.min(this.minValue, ((Number)low).doubleValue());
            }
            if (high != null && high instanceof Number && !Double.isInfinite(((Number)high).doubleValue()) && !Double.isNaN(((Number)high).doubleValue())) {
                this.maxValue = Math.max(this.maxValue, ((Number)high).doubleValue());
            }
            this.discrete = false;
            this.categorized = false;
        }
        this.startPoint[this.getAxisIndex()] = this.minValue;
        this.endPoint[this.getAxisIndex()] = this.maxValue;
        if (this.startPoint[this.getAxisIndex()] == this.endPoint[this.getAxisIndex()]) {
            this.startPoint[this.getAxisIndex()] = this.startPoint[this.getAxisIndex()] - 1.0;
            this.endPoint[this.getAxisIndex()] = this.endPoint[this.getAxisIndex()] + 1.0;
        }
        if (this.rangeModel != null && this.layoutRangeModel) {
            this.ordinal = true;
            if (this.rangeSlider != null) {
                this.rangeSlider.setExclusive(!this.ordinal);
            }
            this.rangeModel.setMinimum((Double)this.tickMarkValues[0]);
            this.rangeModel.setMaximum((Double)this.tickMarkValues[this.tickMarkValues.length - 1]);
            this.rangeModel.setPrecision(new Double(((Number)this.tickMarkValues[1]).doubleValue() - ((Number)this.tickMarkValues[0]).doubleValue()));
        }
        this.rebuildRequired = true;
        this.build(null);
        return true;
    }

    protected void createTickMarkValues() {
    }

    protected void createTickMarkValues(double min, double max) {
        double d1 = Math.min(min, max);
        double d2 = Math.max(min, max);
        min = d1;
        max = d2;
        boolean doLogAxis = false;
        if (this.axisType == 2 && !this.isDiscrete()) {
            doLogAxis = true;
            if (min <= 0.0 || max == min) {
                System.out.println(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"Axis.LogTransformError.txt", (String)"Cannot set log transform for variable with values less than or equal to 0"));
                doLogAxis = false;
                this.setTransformType(1, null);
            }
        }
        if (doLogAxis) {
            this.logObject = ZxAxis.zlogaxis((double)min, (double)max, (double)this.logBase, (int)this.maxTicks, (double)(1.0 - this.threshold), (double)(1.0 - this.threshold), (boolean)this.minorTickLineStyle.isVisible(), (boolean)false);
            this.outputTickmarks();
        } else if (this.axisFormat == null || !(this.axisFormat instanceof SASDateTimeFormat) || this.axisFormat instanceof SASDateTimeFormat && !ZxAxis.isValidDateTime((double[])new double[]{min, max}, (SASFormat)((SASFormat)this.axisFormat))) {
            this.dateTime = false;
            if (this.tickSpacer == null) {
                this.tickSpacer = new ContinuousTickSpacer();
            }
            double tickSpacerMin = min;
            double tickSpacerMax = max;
            this.tickSpacer.getTickSpacingInfo().setInteger(false);
            if (this.axisFormat != null && this.axisFormat instanceof SASFormat) {
                if (((SASFormat)this.axisFormat).getDecimalWidth() == 0) {
                    this.tickSpacer.getTickSpacingInfo().setInteger(true);
                    tickSpacerMin = Math.floor(min);
                    tickSpacerMax = Math.ceil(max);
                } else {
                    this.tickSpacer.getTickSpacingInfo().setInteger(false);
                }
                if (min < -2.147483648E9 || max > 2.147483647E9) {
                    this.tickSpacer.getTickSpacingInfo().setInteger(false);
                }
            }
            this.tickSpacer.setDataMin(tickSpacerMin);
            this.tickSpacer.setDataMax(tickSpacerMax);
            int numTicks = SILKGlobal.isFlagSet(4) ? this.maxTicks + 1 : this.maxTicks;
            this.tickSpacer.getTickSpacingInfo().setMaxTicks(numTicks);
            this.tickSpacer.doTickSpacing();
            this.outputTickmarks();
        } else {
            this.dateTime = true;
            if (this.timeTickSpacer == null) {
                this.timeTickSpacer = new DateTimeTickSpacer();
            }
            this.timeTickSpacer.setDataMin(min);
            this.timeTickSpacer.setDataMax(max);
            this.timeTickSpacer.getTickSpacingInfo().setFormat((SASFormat)(this.columnFormat == null ? this.axisFormat : this.columnFormat));
            if (!this.minorTickLineStyle.isVisible()) {
                this.timeTickSpacer.getTickSpacingInfo().setMaxMinorTicks(0);
            } else {
                if (this.axisLength <= 0.0) {
                    this.axisLength = this.isXAxis ? (double)this.bBox.width : (double)this.bBox.height;
                }
                this.timeTickSpacer.getTickSpacingInfo().setAxisLength((int)this.axisLength);
                this.timeTickSpacer.getTickSpacingInfo().setMinorTickGap(6);
                this.timeTickSpacer.getTickSpacingInfo().setMaxMinorTicks(31);
            }
            if (this.timeInterval == 0) {
                this.timeTickSpacer.getPreference().setAutoInterval(true);
                int ticks = 12;
                if (!Double.isNaN(this.minimumTimeSpan)) {
                    int reqTicks = (int)Math.ceil((max - min) / this.minimumTimeSpan) + 2;
                    ticks = Math.min(ticks, reqTicks);
                }
                this.timeTickSpacer.getTickSpacingInfo().setMaxTicks(ticks);
            } else {
                this.timeTickSpacer.getPreference().setAutoInterval(false);
                this.timeTickSpacer.getTickSpacingInfo().setInterval(this.timeInterval);
            }
            this.timeTickSpacer.doTickSpacing();
            if (!this.isFixedFormat()) {
                this.axisFormat = this.timeTickSpacer.getFormat(true);
            }
            this.outputTickmarks();
            if (this.startPoint[this.getAxisIndex()] == this.endPoint[this.getAxisIndex()]) {
                int n = this.getAxisIndex();
                this.startPoint[n] = this.startPoint[n] - 1.0;
                int n2 = this.getAxisIndex();
                this.endPoint[n2] = this.endPoint[n2] + 1.0;
            }
            this.rebuildRequired = true;
        }
    }

    public boolean setAxisEndPoints(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.startPoint[0] = x1;
        this.startPoint[1] = y1;
        this.startPoint[2] = z1;
        this.endPoint[0] = x2;
        this.endPoint[1] = y2;
        this.endPoint[2] = z2;
        return true;
    }

    protected double valueTransform(double v) {
        return v;
    }

    protected boolean areGridLinesOn() {
        return this.gridLineStyle.isVisible();
    }

    public void setOffset(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getDimension() {
        return this.isXAxis ? 1 : 2;
    }

    public void setDimension(int dimension) {
        this.isXAxis = dimension == 1;
    }

    public void setFormat(SASFormat fmt) {
        this.setFormat(fmt, false);
    }

    public void setFormat(SASFormat fmt, boolean applyToValues) {
        this.axisFormat = fmt;
        if (applyToValues) {
            this.valueLabelStyle.setFormat(fmt);
            if (this.axisVariable == null) {
                this.resetFormat = false;
            }
            RedrawEvent e = new RedrawEvent(this);
            e.type = 3;
            this.fireRedrawEvent(e);
        }
    }

    public void setBinning(boolean bin) {
        this.dataIsBinned = bin;
    }

    public void setTickInCenter(boolean flag, double widthFactor) {
        this.tickInCenter = flag;
        this.widthFactor = widthFactor;
    }

    public int getLabelWidth(Graphics2D g) {
        String label;
        if (!this.isVisible()) {
            return 0;
        }
        if (!this.labelStyle.isVisible() || this.labelTooSmall) {
            return 0;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (label == null || label.trim().equals("")) {
            return 0;
        }
        Font font = this.labelStyle.getFont();
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        TextLayout textString = new TextLayout(label, font, frc);
        return (int)((double)textString.getVisibleAdvance() + 0.5);
    }

    public int getLabelWidth(Graphics2D g, int n) {
        String label;
        this.labelLength = n;
        if (!this.isVisible()) {
            return 0;
        }
        if (!this.labelStyle.isVisible() || this.labelTooSmall) {
            return 0;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (label == null || label.trim().equals("")) {
            return 0;
        }
        if (this.labelLength < label.length()) {
            label = label.substring(0, this.labelLength);
            this.maxAxisLabelLength = this.labelLength;
            label = label.concat("...");
        } else {
            this.maxAxisLabelLength = label.length();
        }
        Font font = this.labelStyle.getFont();
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        TextLayout textString = new TextLayout(label, font, frc);
        return (int)((double)textString.getVisibleAdvance() + 0.5);
    }

    public void setLabelOffset(int off) {
        this.labelOffset = off;
    }

    public void setDirection(boolean hori) {
        this.isXAxis = hori;
    }

    public void setDefaultLabelPosition(boolean pos) {
        this.defaultLabelPosition = pos;
    }

    public int getCollisionResolution() {
        if (!this.isXAxis) {
            return 8;
        }
        if (!this.isDiscrete() || this.dataIsBinned) {
            return this.collisionResolutionMethod_default_ordinal;
        }
        return this.collisionResolutionMethod_default_discrete;
    }

    public void setCollisionResolution(int method) {
        if (!this.isXAxis) {
            this.collisionResolutionMethod_default_discrete = 8;
            this.collisionResolutionMethod_default_ordinal = 8;
        } else {
            switch (method) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    this.collisionResolutionMethod_default_discrete = method;
                    this.collisionResolutionMethod_default_ordinal = method;
                }
            }
        }
    }

    public void setBaseValue(double v) {
        this.baseValue = v;
    }

    public boolean isDefaultLabelPosition() {
        return this.defaultLabelPosition;
    }

    public void setNumberOfGroups(int num) {
        this.numberOfGroups = num;
    }

    public void setGroupAxis(boolean flag) {
        this.groupAxis = flag;
    }

    public void setNumberOfCategories(int num) {
        this.numberOfCategories = num;
    }

    public void setNumberOfResponses(int num) {
        this.numberOfResponses = num;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    protected Vector sortValueList(Object[] values) {
        int size = values.length;
        Vector sortedValues = new Vector();
        for (int i = 0; i < size; ++i) {
            this.binarySearch(sortedValues, values[i]);
        }
        return sortedValues;
    }

    protected void binarySearch(Vector values, Object obj) {
        if (obj instanceof String) {
            return;
        }
        double v = ((Number)obj).doubleValue();
        if (Double.isNaN(v)) {
            return;
        }
        int size = values.size();
        if (size == 0) {
            values.addElement(obj);
        } else {
            double mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (v < (mid_v = ((Number)values.elementAt(i = (left + right) / 2)).doubleValue())) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (v != mid_v && left <= right);
            if (v != mid_v) {
                int index = Math.max(left, right);
                values.insertElementAt(obj, index);
            }
        }
    }

    private int getFormattedWidth(double d) {
        SASFormat e8 = SASFormat.getInstance((String)"E8");
        String str = e8.format((Object)new Double(d));
        int index = str.indexOf(69);
        int length = Integer.valueOf(str.substring(index + 2));
        if (str.charAt(index + 1) == '-') {
            length += 2;
        }
        return length;
    }

    private void setDefaultFormat(double interval) {
        int sigdes;
        this.defaultFormat = this.axisFormat != null && this.axisFormat instanceof SASFormat ? (SASFormat)this.axisFormat : null;
        double minVal = 0.0;
        double maxVal = 0.0;
        if (this.tickMarkValues == null || this.tickMarkValues.length == 0 || !(this.tickMarkValues[0] instanceof Number)) {
            return;
        }
        minVal = ((Number)this.tickMarkValues[0]).doubleValue();
        maxVal = ((Number)this.tickMarkValues[this.tickMarkValues.length - 1]).doubleValue();
        if (interval == 0.0) {
            interval = maxVal - minVal;
        }
        double nTicks = Double.MAX_VALUE;
        if (interval > 0.0) {
            nTicks = 1.0 + (maxVal - minVal) / interval;
        }
        if (this.gGood && nTicks < 100.0) {
            int maxwIn = -1;
            int maxdecIn = -1;
            int okdecIn = -1;
            if (interval < 1.0 && interval > 0.0) {
                double inv = 1.0 / interval;
                int sigdec = (int)Math.floor(Math.log(inv) / Math.log(10.0) + 1.0);
                int sign = minVal < 0.0 ? 1 : 0;
                int intWidth = (int)Math.floor(Math.log(Math.abs(maxVal)) / Math.log(10.0) + 1.0);
                if (intWidth == 0) {
                    intWidth = 1;
                }
                maxwIn = sign + intWidth + sigdec + 1;
                maxdecIn = sigdec;
                okdecIn = sigdec;
                if (maxwIn < 8) {
                    okdecIn = -1;
                    maxdecIn = -1;
                    maxwIn = -1;
                } else if (maxwIn > 32) {
                    maxwIn = 32;
                    maxdecIn = sigdec = maxwIn - sign - intWidth - 1;
                    okdecIn = sigdec;
                }
            }
            Object[] gGoodFormat = null;
            if (this.fixedTicks && this.tickMarkValues != null) {
                double[] tValues = new double[this.tickMarkValues.length];
                for (int i = 0; i < this.tickMarkValues.length; ++i) {
                    tValues[i] = ((Number)this.tickMarkValues[i]).doubleValue();
                }
                gGoodFormat = NumericFormat.getGGoodFormat((SASFormat)this.defaultFormat, (double[])tValues, (int)maxwIn, (int)maxdecIn, (int)okdecIn, (boolean)false);
            } else {
                gGoodFormat = NumericFormat.getGGoodFormat((SASFormat)this.defaultFormat, (double)minVal, (double)maxVal, (double)interval, (int)maxwIn, (int)maxdecIn, (int)okdecIn, (boolean)false);
            }
            if (gGoodFormat != null && gGoodFormat.length == 2 && gGoodFormat[0] instanceof SASFormat) {
                this.defaultFormat = (SASFormat)gGoodFormat[0];
            }
        } else if (this.defaultFormat == null) {
            int n = (int)(Math.log(1.0 / interval) / Math.log(10.0));
            n = n < 0 ? 0 : n + 1;
            this.defaultFormat = FormatCheck.getFormat(this.tickMarkValues, -1, n, -1, false);
        }
        if (this.axisType == 2 && this.logBase == 10.0 && (sigdes = Math.max(this.getFormattedWidth(minVal), this.getFormattedWidth(maxVal))) > this.defaultFormat.getWidth()) {
            this.defaultFormat = SASFormat.getInstance((String)"E8");
        }
    }

    private String getRefToolTip(int mouseX, int mouseY) {
        if (this.reflines.size() == 0) {
            return null;
        }
        String text = null;
        Rectangle2D.Double rect = new Rectangle2D.Double(mouseX - 1, mouseY - 1, 3.0, 3.0);
        for (int i = 0; i < this.reflines.size(); ++i) {
            Line2D refLine;
            ReferenceLineInterface rline = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (rline == null || rline.getValue() == null || !(rline.getValue() instanceof Number) || !rline.getLine().isVisible() || (refLine = ((ReferenceLine)rline).getLine2D()) == null || !refLine.intersects(rect)) continue;
            text = rline.getLabelString();
            break;
        }
        return text;
    }

    public Vector getRefLinesVector() {
        return this.reflines;
    }

    public void setRefLinesVector(Vector refLinesVector) {
        this.reflines = refLinesVector;
    }

    public void setRefLineLabelVisible(boolean visibility) {
        this.refLineLabelVisible = visibility;
    }

    public void setCurrentReferenceLine(Object value, boolean nearest) {
        this.currentRefLine = null;
        for (int i = 0; i < this.reflines.size(); ++i) {
            ReferenceLineInterface rl = (ReferenceLineInterface)this.reflines.elementAt(i);
            if (!rl.getValue().equals(value)) continue;
            this.currentRefLine = rl;
            break;
        }
    }

    public void drawReferenceRanges(Graphics2D g) {
        if (this.rangeModel == null || this.rangeModel.ranges() < 1) {
            return;
        }
        int refRangeSize = this.rangeModel.ranges();
        double[] scr1 = new double[3];
        double[] scr2 = new double[3];
        boolean isLine = false;
        for (int i = 0; i < refRangeSize; ++i) {
            int xPos;
            int xPos2;
            TextLayout textString;
            double v1;
            ReferenceRange refRange = this.rangeModel.getRangeAt(i);
            if (refRange == null || refRange.getValueRange() == null || !(refRange.getValueRange() instanceof Number[])) continue;
            Object obj = refRange.getValueRange();
            double v = ((Number[])obj)[0].doubleValue();
            isLine = v > (v1 = ((Number[])obj)[1].doubleValue());
            String lowValueText = this.getTickMarkLabel(new Double(v));
            String highValueText = this.getTickMarkLabel(new Double(v1));
            if (v < this.minValue && v1 < this.minValue || v > this.maxValue && v1 > this.maxValue) continue;
            if (this.ordinal) {
                v -= this.ordinalAdjust;
                v1 += this.ordinalAdjust;
            }
            v = this.isXAxis ? (this.transformObject.isReverse(0) ? Math.max(Math.min(v, this.startPoint[0]), this.endPoint[0]) : Math.min(Math.max(v, this.startPoint[0]), this.endPoint[0])) : Math.min(Math.max(v, this.startPoint[1]), this.endPoint[1]);
            double start = v;
            if (this.isXAxis) {
                this.transformObject.project(start, this.startPoint[1], 0.0, scr1);
                scr2[0] = scr1[0];
                scr2[1] = scr1[1] - this.gridLineLength;
            } else {
                this.transformObject.project(this.startPoint[0], v, 0.0, scr1);
                scr2[0] = scr1[0] + this.gridLineLength;
                scr2[1] = scr1[1];
            }
            double[] scr3 = new double[3];
            v1 = this.isXAxis ? (this.transformObject.isReverse(0) ? Math.min(this.startPoint[0], Math.max(v1, this.endPoint[0])) : Math.max(this.startPoint[0], Math.min(v1, this.endPoint[0]))) : Math.max(this.startPoint[1], Math.min(v1, this.endPoint[1]));
            if (this.isXAxis) {
                this.transformObject.project(v1, this.startPoint[1], 0.0, scr3);
            } else {
                this.transformObject.project(this.startPoint[0], v1, 0.0, scr3);
            }
            if (!isLine) {
                g.setColor(refRange.getFillColor());
                if (this.isXAxis) {
                    if (this.transformObject.isReverse(0)) {
                        g.fillRect(this.getInt(scr3[0]), this.getInt(scr2[1]), this.getInt(scr1[0] - scr3[0]), this.getInt(scr1[1] - scr2[1]));
                    } else {
                        g.fillRect(this.getInt(scr1[0]), this.getInt(scr2[1]), this.getInt(scr3[0] - scr1[0]), this.getInt(scr1[1] - scr2[1]));
                    }
                } else {
                    g.fillRect(this.getInt(scr1[0]), this.getInt(scr1[1] - (scr1[1] - scr3[1])), this.getInt(scr2[0] - scr1[0]), this.getInt(scr1[1] - scr3[1]));
                }
                if (refRange.getHighInclusive()) {
                    g.setColor(refRange.getHighLine().getColor());
                    if (this.isXAxis) {
                        g.drawLine(this.getInt(scr3[0]), this.getInt(scr1[1]), this.getInt(scr3[0]), this.getInt(scr2[1]));
                    } else {
                        g.drawLine(this.getInt(scr1[0]), this.getInt(scr3[1]), this.getInt(scr2[0]), this.getInt(scr3[1]));
                    }
                }
                if (this.focusedRange == refRange && this.highValueTip && !this.lowValueTip) {
                    textString = new TextLayout(highValueText, this.valueLabelStyle.getFont(), g.getFontRenderContext());
                    if (this.isXAxis) {
                        xPos2 = this.getInt(scr3[0]);
                        if (xPos2 > this.bBox.width / 2 + this.bBox.x) {
                            xPos2 = (int)((float)xPos2 - (textString.getVisibleAdvance() + 10.0f));
                        }
                        this.drawRangeValueString(g, xPos2, this.getInt(scr2[1]), this.rangeModel.isAdjusting() ? highValueText : " ");
                    } else {
                        this.drawRangeValueString(g, (float)(this.bBox.x + this.bBox.width - this.thumbSize) - textString.getVisibleAdvance(), scr3[1], this.rangeModel.isAdjusting() ? highValueText : " ");
                    }
                }
            }
            if (refRange.getLowInclusive()) {
                g.setColor(refRange.getLowLine().getColor());
                g.drawLine(this.getInt(scr1[0]), this.getInt(scr1[1]), this.getInt(scr2[0]), this.getInt(scr2[1]));
            }
            if (this.focusedRange == refRange && this.lowValueTip && !this.highValueTip) {
                textString = new TextLayout(lowValueText, this.valueLabelStyle.getFont(), g.getFontRenderContext());
                if (this.isXAxis) {
                    xPos2 = this.getInt(scr1[0]);
                    if (xPos2 > this.bBox.width / 2 + this.bBox.x) {
                        xPos2 = (int)((float)xPos2 - (textString.getVisibleAdvance() + 10.0f));
                    }
                    this.drawRangeValueString(g, xPos2, scr2[1], this.rangeModel.isAdjusting() ? lowValueText : " ");
                } else {
                    this.drawRangeValueString(g, (float)(this.bBox.x + this.bBox.width - this.thumbSize) - textString.getVisibleAdvance(), scr1[1] + (double)textString.getAscent(), this.rangeModel.isAdjusting() ? lowValueText : " ");
                }
            }
            if (this.focusedRange != refRange || !this.lowValueTip || !this.highValueTip) continue;
            String str = lowValueText + "," + highValueText;
            if (isLine) {
                str = lowValueText;
                TextLayout textString2 = new TextLayout(str, this.valueLabelStyle.getFont(), g.getFontRenderContext());
                xPos = this.getInt(scr1[0] - (double)(textString2.getVisibleAdvance() / 2.0f));
                this.drawRangeValueString(g, xPos, scr2[1], this.rangeModel.isAdjusting() ? str : " ");
                continue;
            }
            TextLayout textString3 = new TextLayout(str, this.valueLabelStyle.getFont(), g.getFontRenderContext());
            if (this.isXAxis) {
                xPos = (this.getInt(scr1[0]) + this.getInt(scr3[0])) / 2;
                if (xPos > this.bBox.width / 2 + this.bBox.x) {
                    xPos = (int)((float)xPos - (textString3.getVisibleAdvance() + 10.0f));
                }
                this.drawRangeValueString(g, xPos, scr2[1], this.rangeModel.isAdjusting() ? str : " ");
                continue;
            }
            this.drawRangeValueString(g, (float)(this.bBox.x + this.bBox.width - this.thumbSize) - textString3.getVisibleAdvance(), scr1[1] + (double)textString3.getAscent(), this.rangeModel.isAdjusting() ? str : " ");
        }
        int adjustedX = 0;
        int adjustedY = 0;
        TextLayout textString = new TextLayout(this.rangeSliderToolTipStr, this.valueLabelStyle.getFont(), g.getFontRenderContext());
        if (this.isXAxis) {
            adjustedX = this.rangeSliderToolTipX > this.bBox.width / 2 ? (adjustedX -= (int)textString.getVisibleAdvance()) : (adjustedX += this.bBox.x);
            adjustedY = this.bBox.y;
        } else {
            adjustedX = this.bBox.x + this.bBox.width - (int)textString.getVisibleAdvance() - this.thumbSize;
            adjustedY = this.bBox.y;
        }
        this.drawRangeValueString(g, this.rangeSliderToolTipX + adjustedX, this.rangeSliderToolTipY + adjustedY, this.rangeSliderToolTipStr);
        this.highValueTip = false;
        this.lowValueTip = false;
    }

    public String getRangeSliderTooltipText() {
        return this.rangeSliderToolTipStr;
    }

    private void drawRangeValueString(Graphics2D g, double x, double y, String text) {
        Color textColor;
        Color borderColor;
        Color backgroundColor;
        Font tipFont;
        if (g == null) {
            return;
        }
        Font gFont = g.getFont();
        if (this.chartTip != null) {
            tipFont = this.chartTip.getFontObject();
            if (tipFont == null) {
                // empty if block
            }
            tipFont = this.valueLabelStyle.getFont();
            backgroundColor = this.chartTip.getChartTipBackground().getSolidBackground();
            borderColor = this.chartTip.getChartTipBorderColor();
            textColor = this.chartTip.getChartTipTextColor();
        } else {
            tipFont = this.valueLabelStyle.getFont();
            backgroundColor = g.getBackground();
            borderColor = g.getColor();
            textColor = this.getValueColor();
        }
        if (tipFont != null) {
            g.setFont(tipFont);
        } else {
            tipFont = g.getFont();
        }
        if (tipFont == null) {
            return;
        }
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout textString = new TextLayout(text, tipFont, frc);
        double textHeight = textString.getAscent() + textString.getDescent();
        if ((int)textString.getVisibleAdvance() > 0) {
            g.setColor(backgroundColor);
            g.fillRect((int)x - 4, (int)y, (int)textString.getVisibleAdvance() + 6, (int)textHeight);
            g.setColor(borderColor);
            g.drawRect((int)x - 4, (int)y, (int)textString.getVisibleAdvance() + 6, (int)textHeight);
            g.setColor(textColor);
            g.drawString(text, (float)x, (float)y + textString.getAscent());
        }
        g.setFont(gFont);
    }

    @Override
    public boolean setRangeModel(Object obj) {
        if (obj == null && this.rangeModel != null) {
            this.rangeModel.removePropertyChangeListener(this);
            if (this.rangeSlider != null) {
                this.rangeSlider.removeMouseListener((MouseListener)this.aml);
                this.removeRangeSliderFromListeners();
                this.rangeSlider.removeAll();
                this.rangeSlider.setVisible(false);
                this.rangeSlider = null;
            }
            this.rangeModel = (RangeModel)obj;
            return true;
        }
        if (!(obj instanceof RangeModel)) {
            return false;
        }
        this.rangeModel = (RangeModel)obj;
        this.rangeModel.addPropertyChangeListener(this);
        if (this.rangeSlider == null) {
            this.rangeSlider = new RangeSlider();
        }
        this.rangeMinSet = false;
        this.rangeMaxSet = false;
        this.rangeSliderSetup();
        return true;
    }

    @Override
    public Object getRangeModel(boolean createFlag) {
        if (createFlag && this.rangeModel == null) {
            this.rangeModel = new RangeModel();
            if (this.rangeModel != null) {
                this.rangeMinSet = false;
                this.rangeMaxSet = false;
                this.rangeModel.addPropertyChangeListener(this);
                this.rangeSlider = new RangeSlider();
                this.rangeSliderSetup();
            }
        }
        return this.rangeModel;
    }

    private void addRangeSliderToListeners() {
        RedrawEvent re = new RedrawEvent(this);
        re.type = 7;
        for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.elementAt(i);
            if (listener == null || !(listener instanceof JComponent)) continue;
            ((JComponent)((Object)listener)).add((Component)this.rangeSlider);
            listener.redraw(re);
        }
    }

    private void removeRangeSliderFromListeners() {
        for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.elementAt(i);
            if (listener == null || !(listener instanceof JComponent)) continue;
            ((JComponent)((Object)listener)).remove((Component)this.rangeSlider);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RangeModel rm = (RangeModel)evt.getSource();
        String propName = evt.getPropertyName();
        if (propName.equalsIgnoreCase("minimum")) {
            this.rangeMinSet = true;
        }
        if (propName.equalsIgnoreCase("maximum")) {
            this.rangeMaxSet = true;
        }
        if (propName.equalsIgnoreCase("precision") && this.rangeSlider != null) {
            int mp = rm.getMappedPrecision();
            this.rangeSlider.setMinorTickSpacing(mp);
            this.rangeSlider.setSnapToTicks(mp != -1);
        }
        this.focusedRange = null;
        if (propName.equalsIgnoreCase("lowValue")) {
            this.lowValueTip = true;
            Object obj = evt.getNewValue();
            this.focusedRange = (ReferenceRange)((Object[])obj)[0];
        }
        if (propName.equalsIgnoreCase("highValue")) {
            this.highValueTip = true;
            Object obj = evt.getNewValue();
            this.focusedRange = (ReferenceRange)((Object[])obj)[0];
        }
        this.fireEvent = true;
        RedrawEvent e = new RedrawEvent(rm);
        e.type = 4;
        this.fireRedrawEvent(e);
    }

    private void setDefaultRangeSliderThumbSize(int height) {
        if (!this.userSetThumbSize) {
            int size = (int)((double)height * this.axisDefaults.rangeSliderSizeFraction);
            this.thumbSize = size = Math.max(this.axisDefaults.minRangeSliderSize, Math.min(this.axisDefaults.maxRangeSliderSize, size));
            if (this.rangeSlider != null) {
                this.rangeSlider.setThumbSize(this.thumbSize);
            }
        }
    }

    public int getRangeSliderThumbSize() {
        int size = 0;
        if (this.rangeSlider != null && this.rangeSlider.isVisible()) {
            size = this.isXAxis ? this.rangeSlider.getThumbSize().height : this.rangeSlider.getThumbSize().width;
        }
        return size;
    }

    public void setRangeSliderThumbSize(int size) {
        this.thumbSize = size;
        this.userSetThumbSize = true;
        if (this.rangeSlider != null) {
            this.rangeSlider.setThumbSize(this.thumbSize);
            this.fireEvent = true;
            RedrawEvent e = new RedrawEvent(this);
            e.type = 2;
            this.fireRedrawEvent(e);
        }
    }

    public void setShowMissing(boolean missingFlag, double value) {
        this.missing = missingFlag;
        this.missingValue = value;
        this.rebuildRequired = true;
    }

    private void updateRangeSliderColors() {
        if (this.rangeSlider == null) {
            return;
        }
        if (this.distinctRangeSliderBackground) {
            this.rangeSlider.setOpaque(true);
            float[] hsb = new float[3];
            hsb = Color.RGBtoHSB(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), hsb);
            if ((double)hsb[2] > 0.6666) {
                this.rangeSlider.setColorScheme(ColorUtilities.darker(this.backgroundColor, 0.1));
            } else {
                this.rangeSlider.setColorScheme(ColorUtilities.brighter(this.backgroundColor, 0.1));
            }
        } else {
            this.rangeSlider.setOpaque(false);
            this.rangeSlider.setColorScheme(this.backgroundColor);
        }
    }

    private void rangeSliderSetup() {
        if (this.rangeSlider != null) {
            if (!this.isXAxis) {
                this.rangeSlider.setOrientation(1);
                this.rangeSlider.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.rangeSlider.setOrientation(0);
            }
            this.rangeSlider.setPaintLabels(false);
            this.rangeSlider.setPaintTicks(false);
            this.rangeSlider.setThumbSize(this.thumbSize);
            this.rangeSlider.setPaintTrack(false);
            this.rangeSlider.setALAF(true);
            this.updateRangeSliderColors();
            this.rangeSlider.setModel((BoundedRangeModel)this.rangeModel.getModel());
            this.rangeSlider.setPopupMenu((JPopupMenu)new RangeMenu(this.rangeSlider));
            this.rangeSlider.setCursorFeedback(true);
            this.rangeSlider.setVisible(this.suppressRangeSlider);
            this.aml = new AxesMouseListener();
            this.rangeSlider.addMouseListener((MouseListener)this.aml);
            this.rangeSlider.addMouseMotionListener((MouseMotionListener)this.aml);
            this.rangeSlider.setClickCreate(true);
            double[] endPt = this.getEndPoint(false, false);
            if (endPt != null) {
                if (!Double.isNaN(endPt[0]) && !Double.isNaN(endPt[1])) {
                    this.rangeModel.setMinimum(new Double(Math.min(endPt[0], endPt[1])));
                    this.rangeModel.setMaximum(new Double(Math.max(endPt[1], endPt[0])));
                    this.rangeModel.setVisibleMinimum(new Double(Math.min(endPt[0], endPt[1])));
                    this.rangeModel.setVisibleMaximum(new Double(Math.max(endPt[1], endPt[0])));
                }
            } else if (!Double.isNaN(this.fullDataMin) && !Double.isNaN(this.fullDataMax)) {
                this.rangeModel.setMinimum(new Double(Math.min(this.fullDataMin, this.fullDataMax)));
                this.rangeModel.setMaximum(new Double(Math.max(this.fullDataMax, this.fullDataMin)));
                this.rangeModel.setVisibleMinimum(new Double(Math.min(this.fullDataMin, this.fullDataMax)));
                this.rangeModel.setVisibleMaximum(new Double(Math.max(this.fullDataMax, this.fullDataMin)));
            }
            this.addRangeSliderToListeners();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color clr) {
        if (clr == null) {
            return;
        }
        this.backgroundColor = clr;
        this.chartBackgroundColorBright = ColorUtilities.brighter(this.backgroundColor, 0.2);
        if (this.rangeSlider != null) {
            this.rangeSlider.setColorScheme(this.backgroundColor);
        }
    }

    public void setWallColor(Color clr) {
        if (clr == null) {
            return;
        }
        this.wallColor = clr;
        this.chartWallColorBright = ColorUtilities.brighter(this.wallColor);
        this.chartWallColorDark = ColorUtilities.darker(this.wallColor);
    }

    public void setChartTip(TipInterface tip) {
        this.chartTip = tip;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int intvl) {
        this.timeInterval = intvl;
    }

    @Override
    public int getTimeSplittingPolicy() {
        return this.timeSplittingPolicy;
    }

    @Override
    public void setTimeSplittingPolicy(int policy) {
        switch (policy) {
            default: {
                return;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.timeSplittingPolicy = policy;
        this.splittingTime = false;
        this.rebuildRequired = true;
    }

    @Override
    public boolean isFixedFormat() {
        return this.fixedFormat;
    }

    @Override
    public void setFixedFormat(boolean fix) {
        this.fixedFormat = fix;
    }

    public void setMinimumTimeSpan(double span) {
        this.minimumTimeSpan = span;
    }

    private boolean buildSplitedTimeAxis() {
        this.displayList.removeAllElements();
        int len = this.tickMarkValues.length;
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((Number)this.tickMarkValues[i]).doubleValue();
        }
        this.longTermLabels = this.splitDT.getLongTermLabels(values);
        this.shortTermLabels = this.splitDT.getShortTermLabels(values);
        for (int i = 0; i < len; ++i) {
            AxisElement e = new AxisElement();
            e.value = values[i];
            e.unfmtValue = this.tickMarkValues[i];
            e.description = e.label = this.shortTermLabels[i];
            this.displayList.addElement(e);
        }
        this.rebuildRequired = false;
        this.redraw = true;
        return true;
    }

    private void drawSplittedTimeAxis(Graphics2D g, boolean callHighlightDraw) {
        String label;
        TextLayout textString;
        FontRenderContext frc = g.getFontRenderContext();
        Font valueFont = this.valueLabelStyle.getFont();
        valueFont = valueFont.deriveFont((float)SILKUtilities.adjustFontSize(valueFont.getSize()));
        Font tmvFont = this.reduceFont ? FontManager.getFont((String)this.valueLabelStyle.getFont().getName(), (int)this.valueLabelStyle.getFont().getStyle(), (int)this.valueLabelFontSizeInUse) : valueFont;
        Color tmColor = this.getTickMarkColor();
        Color tmvColor = this.getValueColor();
        Stroke oldStroke = g.getStroke();
        int width = this.majorTickLineStyle.getWidth();
        g.setStroke(new BasicStroke(width, 0, 2));
        int skips = 0;
        if (this.getCollisionResolution() == 8) {
            skips = this.getTickmarkValueSkips(frc);
        }
        double[] scr = new double[3];
        double overall_max_y = 0.0;
        int size = this.displayList.size();
        String longTerm = null;
        double longTermXrt = 0.0;
        for (int i = 0; i < size; ++i) {
            Color col;
            double max_y = 0.0;
            AxisElement e = (AxisElement)this.displayList.elementAt(i);
            boolean major = false;
            if (e.value >= this.startPoint[0] && e.value <= this.endPoint[0]) {
                int ticksize;
                if (i % (skips + 1) == 0) {
                    major = true;
                    ticksize = 6;
                } else {
                    major = false;
                    ticksize = 3;
                }
                this.transformObject.project(e.value, this.startPoint[1], 0.0, scr);
                e.tick = new Line2D.Double(scr[0], scr[1], scr[0], scr[1] + (double)ticksize);
                max_y = scr[1];
                if (this.majorTickLineStyle.isVisible() && !this.fontTooSmall && !this.hidingValueLabelsIsRequired) {
                    col = e.tickColor == null ? tmColor : e.tickColor;
                    g.setColor(col);
                    g.draw(e.tick);
                    max_y += 6.0;
                }
                if (this.areGridLinesOn()) {
                    g.setColor(this.getGridLineColor());
                    g.drawLine((int)scr[0], (int)scr[1], (int)scr[0], (int)(scr[1] - this.gridLineLength));
                }
            }
            if (e.value < this.startPoint[0] || e.value > this.endPoint[0] || e.label == null || e.label.trim().equals("") || !major) continue;
            if (!this.valueLabelStyle.isVisible() || this.fontTooSmall || this.hidingValueLabelsIsRequired) {
                overall_max_y = max_y;
                continue;
            }
            max_y += (double)this.GAP;
            String tklab = e.label;
            if ((this.getCollisionResolution() == 6 || this.getCollisionResolution() == 7) && tklab.length() >= 9) {
                tklab = e.label.substring(0, 2);
                tklab = tklab.concat("...");
                tklab = tklab.concat(e.label.substring(e.label.length() - 2, e.label.length()));
            }
            textString = new TextLayout(tklab, tmvFont, frc);
            Rectangle2D bounds = textString.getBounds();
            double textHeight = textString.getAscent() + textString.getDescent();
            double tx = scr[0] - bounds.getWidth() * 0.5;
            double ty = max_y + (double)textString.getAscent();
            max_y += textHeight;
            if (SILKUtilities.useGraphEngraving()) {
                g.setColor(this.chartBackgroundColorBright);
                textString.draw(g, (float)tx + 1.0f, (float)ty + 1.0f);
            }
            col = e.labelColor == null ? tmvColor : e.labelColor;
            g.setColor(col);
            textString.draw(g, (float)tx, (float)ty);
            if (!this.longTermLabels[i].equals(longTerm)) {
                longTerm = this.longTermLabels[i];
                textString = new TextLayout(longTerm, tmvFont, frc);
                ty = max_y + (double)textString.getAscent();
                if (tx + textString.getBounds().getWidth() < (double)(this.bBox.x + this.bBox.width) && tx > longTermXrt) {
                    textString.draw(g, (float)tx, (float)ty);
                    max_y += (double)(textString.getAscent() + textString.getDescent());
                    longTermXrt = tx + textString.getBounds().getWidth();
                }
            } else if (i == size - 1) {
                tx += textString.getBounds().getWidth();
                longTerm = this.longTermLabels[i];
                textString = new TextLayout(longTerm, tmvFont, frc);
                ty = max_y + (double)textString.getAscent();
                if (tx < (double)(this.bBox.x + this.bBox.width) && (tx -= textString.getBounds().getWidth() - 1.0) > longTermXrt) {
                    textString.draw(g, (float)tx, (float)ty);
                    max_y += (double)(textString.getAscent() + textString.getDescent());
                    longTermXrt = tx;
                }
            }
            if (!(max_y > overall_max_y)) continue;
            overall_max_y = max_y;
        }
        g.setStroke(oldStroke);
        if (this.axisLineStyle.isVisible()) {
            g.setColor(this.getColor());
            oldStroke = g.getStroke();
            width = this.axisLineStyle.getWidth();
            g.setStroke(new BasicStroke(width, 0, 2));
            double[] scr1 = this.transformObject.project(this.startPoint[0], this.startPoint[1], this.startPoint[2], null);
            Line2D.Double line = new Line2D.Double(this.bBox.x, scr1[1], this.bBox.x + this.bBox.width, scr1[1]);
            g.draw(line);
            g.setStroke(oldStroke);
        }
        String string = label = this.getUserLabel() == null ? this.axisLabel : this.getUserLabel();
        if (label == null || label.trim().equals("") || !this.labelStyle.isVisible() || this.labelTooSmall) {
            return;
        }
        if (!this.defaultLabelPosition && this.maxAxisLabelLength < label.length()) {
            label = label.substring(0, this.maxAxisLabelLength);
            label = label.concat("...");
        }
        Font labFont = this.labelStyle.getFont();
        labFont = labFont.deriveFont((float)SILKUtilities.adjustFontSize(labFont.getSize()));
        Color labColor = this.getLabelColor();
        textString = new TextLayout(label, labFont, frc);
        Rectangle2D bounds = textString.getBounds();
        if (bounds.getWidth() > this.axisLength) {
            int len = label.length();
            for (int i = len - 4; i >= 0; --i) {
                String lab = label.substring(0, i);
                textString = new TextLayout(lab = lab.concat("..."), labFont, frc);
                bounds = textString.getBounds();
                if (bounds.getWidth() < this.axisLength) break;
            }
        }
        double x = (this.startPoint[0] + this.endPoint[0]) * 0.5;
        this.transformObject.project(x, this.startPoint[1], 0.0, scr);
        double tx = scr[0] - bounds.getWidth() * 0.5;
        double ty = Math.max(overall_max_y, scr[1]) + (double)this.GAP + (double)textString.getAscent();
        if (SILKUtilities.useGraphEngraving()) {
            g.setColor(this.chartBackgroundColorBright);
            textString.draw(g, (float)(tx + 1.0), (float)(ty + 1.0));
        }
        g.setColor(labColor);
        textString.draw(g, (float)tx, (float)ty);
        this.drawReferenceLines(g);
    }

    private void drawMinorTicks(Graphics2D g, double[] values) {
        Color tmColor = this.getTickMarkColor();
        Stroke oldStroke = g.getStroke();
        int width = this.minorTickLineStyle.getWidth();
        g.setStroke(new BasicStroke(width, 0, 2));
        double[] scr = new double[3];
        int size = values.length;
        int ticksize = 3;
        g.setColor(tmColor);
        for (int i = 0; i < size; ++i) {
            if (!(values[i] >= this.startPoint[this.getAxisIndex()] && values[i] <= this.endPoint[this.getAxisIndex()]) && (!(values[i] <= this.startPoint[this.getAxisIndex()]) || !(values[i] >= this.endPoint[this.getAxisIndex()]))) continue;
            if (this.isXAxis) {
                this.transformObject.project(values[i], this.startPoint[1], 0.0, scr);
                if (this.primary) {
                    g.draw(new Line2D.Double(scr[0], scr[1], scr[0], scr[1] + (double)ticksize));
                    continue;
                }
                g.draw(new Line2D.Double(scr[0], scr[1], scr[0], scr[1] - (double)ticksize));
                continue;
            }
            this.transformObject.project(this.startPoint[0], values[i], 0.0, scr);
            if (this.primary) {
                g.draw(new Line2D.Double(scr[0] - 1.0, scr[1], scr[0] - (double)ticksize - 1.0, scr[1]));
                continue;
            }
            g.draw(new Line2D.Double(scr[0], scr[1], scr[0] + (double)ticksize, scr[1]));
        }
        g.setStroke(oldStroke);
    }

    private int getInt(double val) {
        return (int)Math.round(val);
    }

    public boolean isFisheyeView() {
        return this.fisheyeView;
    }

    public void setFisheyeView(boolean fisheye) {
        this.fisheyeView = fisheye;
    }

    public void setReferenceValueReplacementText(String propertyName, String replacementText, Object value) {
        for (int i = 0; i < this.replace.size(); ++i) {
            ReplacementElement r = (ReplacementElement)this.replace.get(i);
            if (!r.getPropertyName().equalsIgnoreCase(propertyName) || !r.getValue().equals(value)) continue;
            this.replace.remove(i);
            --i;
        }
        this.replace.add(new ReplacementElement(propertyName, replacementText, value));
    }

    public void setReferenceValueTooltipText(int part, String text, Object args) {
        for (int i = 0; i < this.tooltips.size(); ++i) {
            TooltipText t = (TooltipText)this.tooltips.get(i);
            if (t.getPart() != part) continue;
            this.tooltips.remove(i);
            --i;
        }
        this.tooltips.add(new TooltipText(part, text, args));
    }

    public String getReferenceValueTooltipText(int rangeIndex, int part) {
        ReferenceRange range = this.rangeModel.getRangeAt(rangeIndex);
        String tooltip = null;
        String text = null;
        Object[] args = null;
        if (range != null) {
            if (this.rangeSlider.getExtent(rangeIndex) >= 0) {
                for (int i = 0; i < this.tooltips.size(); ++i) {
                    TooltipText t = (TooltipText)this.tooltips.get(i);
                    if (t.getPart() != part) continue;
                    text = t.getText();
                    Object o = t.getArgs();
                    int type = Extract.getSourceType((Object)o);
                    int num = Extract.getNumberItems((Object)o, (int)type);
                    args = new Object[num];
                    for (int j = 0; j < num; ++j) {
                        String txt;
                        double d;
                        String propName = Extract.getObject((Object)o, (int)j, (int)type).toString();
                        if (propName.equalsIgnoreCase("lowValue")) {
                            Object lv = range.getLowValue();
                            d = 0.0;
                            if (lv instanceof Double) {
                                d = (Double)lv;
                            }
                            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                                args[j] = lv;
                                continue;
                            }
                            args[j] = this.getTickMarkLabel(lv);
                            continue;
                        }
                        if (propName.equalsIgnoreCase("lowInclusive")) {
                            txt = this.getReplacementText("lowInclusive", new Boolean(range.getLowInclusive()));
                            if (txt == null) {
                                txt = range.getLowInclusive() ? LOW_INCLUSIVE_VALUE_TRUE : LOW_INCLUSIVE_VALUE_FALSE;
                            }
                            args[j] = txt;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("highValue")) {
                            Object hv = range.getHighValue();
                            d = 0.0;
                            if (hv instanceof Double) {
                                d = (Double)hv;
                            }
                            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                                args[j] = hv;
                                continue;
                            }
                            args[j] = this.getTickMarkLabel(hv);
                            continue;
                        }
                        if (!propName.equalsIgnoreCase("highInclusive")) continue;
                        txt = this.getReplacementText("highInclusive", new Boolean(range.getHighInclusive()));
                        if (txt == null) {
                            txt = range.getHighInclusive() ? HIGH_INCLUSIVE_VALUE_TRUE : HIGH_INCLUSIVE_VALUE_FALSE;
                        }
                        args[j] = txt;
                    }
                }
                if (text != null && args != null) {
                    tooltip = MessageFormat.format(text, args);
                }
            } else {
                String lv = this.getTickMarkLabel(range.getLowValue());
                tooltip = lv.toString();
            }
        }
        return tooltip;
    }

    private String getReplacementText(String propertyName, Object value) {
        String text = null;
        for (int i = 0; i < this.replace.size(); ++i) {
            ReplacementElement r = (ReplacementElement)this.replace.get(i);
            if (!propertyName.equalsIgnoreCase(r.getPropertyName()) || !value.equals(r.getValue())) continue;
            text = r.getReplacementText();
            break;
        }
        return text;
    }

    public boolean isExternalAxis() {
        return this.externalAxis;
    }

    public void setExternalAxis(boolean externalAxis) {
        this.externalAxis = externalAxis;
    }

    public boolean isUserSetValueFont() {
        return this.valueLabelStyle.hasUserSetValue(9002);
    }

    public boolean isUserSetLabelFont() {
        return this.labelStyle.hasUserSetValue(9002);
    }

    public boolean isRangeMaxSet() {
        return this.rangeMaxSet;
    }

    public void setRangeMaxSet(boolean rangeMaxSet) {
        this.rangeMaxSet = rangeMaxSet;
    }

    public boolean isRangeMinSet() {
        return this.rangeMinSet;
    }

    public void setRangeMinSet(boolean rangeMinSet) {
        this.rangeMinSet = rangeMinSet;
    }

    boolean isUseUserSetMinMax() {
        return this.useUserSetMinMax;
    }

    void setUseUserSetMinMax(boolean useUserSetMinMax) {
        this.useUserSetMinMax = useUserSetMinMax;
    }

    private void applyThreshold() {
        if (this.tickMarkValues != null && this.tickMarkValues[0] instanceof Number && this.tickMarkValues.length > 3) {
            if (this.dateTime) {
                double d = Math.min(this.timeTickSpacer.getTickMin(), this.timeTickSpacer.getDataMin());
                this.startPoint[this.getAxisIndex()] = d;
                this.minValue = d;
                double d2 = Math.max(this.timeTickSpacer.getTickMax(), this.timeTickSpacer.getDataMax());
                this.endPoint[this.getAxisIndex()] = d2;
                this.maxValue = d2;
            } else {
                double tmv0 = ((Number)this.tickMarkValues[0]).doubleValue();
                if (this.hasUserSetMin() && this.axisType != 2) {
                    tmv0 = this.userMin;
                }
                double tmv1 = ((Number)this.tickMarkValues[1]).doubleValue();
                int num = this.tickMarkValues.length;
                double tmv2 = ((Number)this.tickMarkValues[num - 2]).doubleValue();
                double tmv3 = ((Number)this.tickMarkValues[num - 1]).doubleValue();
                if (this.hasUserSetMax() && this.axisType != 2) {
                    tmv3 = this.userMax;
                }
                if (this.minValue < tmv0 + (tmv1 - tmv0) * this.threshold) {
                    double d = tmv0;
                    this.startPoint[this.getAxisIndex()] = d;
                    this.minValue = d;
                } else {
                    this.startPoint[this.getAxisIndex()] = this.minValue;
                }
                if (this.maxValue > tmv3 - (tmv3 - tmv2) * this.threshold) {
                    double d = tmv3;
                    this.endPoint[this.getAxisIndex()] = d;
                    this.maxValue = d;
                } else {
                    this.endPoint[this.getAxisIndex()] = this.maxValue;
                }
            }
        }
    }

    @Override
    public void setThreshold(double thresholdVal) {
        if (thresholdVal >= 0.0 && thresholdVal <= 1.0) {
            this.userSetProperties.set(247);
            this.threshold = thresholdVal;
            if (this.honorThresh) {
                this.applyThreshold();
                RedrawEvent e = new RedrawEvent(this);
                double[] bbox = new double[]{this.startPoint[0], this.startPoint[1], this.endPoint[0], 0.0, this.endPoint[1], 0.0};
                e.newBoundingBox = bbox;
                e.type = 2;
                this.fireRedrawEvent(e);
            }
        }
    }

    @Override
    public void setTransformType(int type, Object transInfo) {
        if (this.isDiscrete()) {
            return;
        }
        int oldAxisType = this.axisType;
        double oldLogBase = this.logBase;
        switch (type) {
            case 1: {
                this.axisType = type;
                if (this.isXAxis) {
                    this.defaultTransformObject.setTransformType(0, this.axisType, null);
                    break;
                }
                this.defaultTransformObject.setTransformType(1, this.axisType, null);
                break;
            }
            case 2: {
                if (!this.isLogTransformPermitted()) {
                    System.out.println(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"Axis.LogTransformError.txt", (String)"Cannot set log transform for variable with values less than or equal to 0"));
                    return;
                }
                this.axisType = type;
                if (transInfo instanceof Number) {
                    this.logBase = ((Number)transInfo).doubleValue();
                }
                if (this.isXAxis) {
                    this.defaultTransformObject.setTransformType(0, this.axisType, new Double(this.logBase));
                    break;
                }
                this.defaultTransformObject.setTransformType(1, this.axisType, new Double(this.logBase));
            }
        }
        Number oldValue = null;
        Number newValue = null;
        String propertyName = null;
        boolean typeChanged = false;
        if (this.axisType != oldAxisType) {
            propertyName = "AXIS_TRANSFORM_TYPE";
            oldValue = new Integer(oldAxisType);
            newValue = new Integer(this.axisType);
            typeChanged = true;
        } else if (oldLogBase != this.logBase && this.axisType == 2) {
            propertyName = "AXIS_LOG_BASE";
            oldValue = new Double(oldLogBase);
            newValue = new Double(this.logBase);
            typeChanged = true;
        }
        if (typeChanged) {
            this._propertyListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public int getTransformType() {
        return this.axisType;
    }

    @Override
    public Object getTransformInfo(int transformType) {
        switch (transformType) {
            default: {
                return null;
            }
            case 2: 
        }
        return new Double(this.logBase);
    }

    private boolean isLogTransformPermitted() {
        return this.logTransformEnabled && !Double.isNaN(this.fullDataMin) && !Double.isNaN(this.fullDataMax) && !(this.fullDataMin <= 0.0) && this.fullDataMax != this.fullDataMin;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._propertyListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._propertyListeners.removePropertyChangeListener(l);
    }

    public boolean isHideValues() {
        return this.hidingValueLabelsIsRequired;
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireEvent = true;
        this.fireRedrawEvent(e);
    }

    public boolean isLayoutRangeModel() {
        return this.layoutRangeModel;
    }

    public void setLayoutRangeModel(boolean layoutRangeModel) {
        this.layoutRangeModel = layoutRangeModel;
    }

    public boolean isTextEngraved() {
        return SILKUtilities.useGraphEngraving();
    }

    public void setTextEngraved(boolean textEngraved) {
    }

    public void setFullDataRange(double min, double max) {
        this.fullDataMin = min;
        this.fullDataMax = max;
        if (this.rangeModel != null) {
            double[] endPt = this.getEndPoint(false, false);
            if (endPt != null) {
                this.rangeModel.setMinimum(new Double(endPt[0]));
                this.rangeModel.setMaximum(new Double(endPt[1]));
            } else {
                this.rangeModel.setMinimum(new Double(this.fullDataMin));
                this.rangeModel.setMaximum(new Double(this.fullDataMax));
            }
        }
        this.rebuildRequired = true;
    }

    public double getFullDataMin() {
        return this.fullDataMin;
    }

    public double getFullDataMax() {
        return this.fullDataMax;
    }

    public void setMargin(int val) {
        this.margin = val;
    }

    public double getUserMax() {
        return this.userMax;
    }

    public void setUserMax(double userMax) {
        this.userMax = userMax;
        this.useUserSetMinMax = this.hasUserSetMin() && this.hasUserSetMax();
        this.fireEvent = true;
        RedrawEvent e = new RedrawEvent(this);
        e.type = 6;
        this.fireRedrawEvent(e);
    }

    public double getUserMin() {
        return this.userMin;
    }

    public void setUserMin(double userMin) {
        this.userMin = userMin;
        this.useUserSetMinMax = this.hasUserSetMin() && this.hasUserSetMax();
        this.fireEvent = true;
        RedrawEvent e = new RedrawEvent(this);
        e.type = 6;
        this.fireRedrawEvent(e);
    }

    public boolean hasUserSetMin() {
        return !Double.isNaN(this.userMin);
    }

    public boolean hasUserSetMax() {
        return !Double.isNaN(this.userMax);
    }

    public void setUserMinMax(double min, double max) {
        this.userMin = min;
        this.userMax = max;
        this.useUserSetMinMax = this.hasUserSetMin() && this.hasUserSetMax();
        this.fireEvent = true;
        RedrawEvent e = new RedrawEvent(this);
        e.type = 6;
        this.fireRedrawEvent(e);
    }

    public void setReverseEnabled(boolean enabled) {
        this.reverseEnabled = enabled;
    }

    public boolean isReverseEnabled() {
        return this.reverseEnabled;
    }

    public boolean isDateTime() {
        return this.dateTime;
    }

    public void setDateTime(boolean b) {
        this.dateTime = b;
    }

    public void setFixedTicks(Object[] fixedTicks) {
        this.fixedTicks = fixedTicks != null;
    }

    public boolean isLogTransformEnabled() {
        return this.logTransformEnabled;
    }

    public void setLogTransformEnabled(boolean logTransformEnabled) {
        this.logTransformEnabled = logTransformEnabled;
    }

    public void clearTickValueList() {
        this.setTickValueList(null);
        this.setInternalTickValueList(null);
        this.setTickDisplayList(null);
        this.setInternalTickDisplayList(null);
    }

    public Object[] getTickValueList() {
        return this.tickValueList;
    }

    public void setTickValueList(Object[] tickValueList) {
        this.tickValueList = tickValueList;
        this.setInternalTickValueList(tickValueList);
    }

    public String[] getTickDisplayList() {
        return this.tickDisplayList;
    }

    public void setTickDisplayList(String[] tickDisplayList) {
        this.tickDisplayList = tickDisplayList;
        this.setInternalTickDisplayList(tickDisplayList);
    }

    public Object[] getInternalTickValueList() {
        return this.internalTickValueList;
    }

    public void setInternalTickValueList(Object[] internalTickValueList) {
        this.internalTickValueList = internalTickValueList;
    }

    public String[] getInternalTickDisplayList() {
        return this.internalTickDisplayList;
    }

    public void setInternalTickDisplayList(String[] internalTickDisplayList) {
        this.internalTickDisplayList = internalTickDisplayList;
    }

    public boolean isRangeSliderBackgroundComputed() {
        return this.distinctRangeSliderBackground;
    }

    public void computeDistinctRangeSliderBackground(boolean flag) {
        this.distinctRangeSliderBackground = flag;
        this.updateRangeSliderColors();
    }

    class AxesMouseListener
    extends MouseInputAdapter {
        AxesMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Axes.this.highValueTip = false;
            Axes.this.lowValueTip = false;
            Axes.this.rangeSliderToolTipStr = "        ";
            Axes.this.fireEvent = true;
            RedrawEvent re = new RedrawEvent(this);
            re.type = 4;
            Axes.this.fireRedrawEvent(re);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int rangeIndex = Axes.this.rangeSlider.getRangeIndex();
            Axes.this.rangeSliderToolTipStr = " ";
            if (rangeIndex > -1) {
                Axes.this.rangeSliderToolTipStr = Axes.this.getReferenceValueTooltipText(rangeIndex, Axes.this.rangeSlider.getRangePart());
                Axes.this.rangeSliderToolTipX = e.getX();
                Axes.this.rangeSliderToolTipY = e.getY();
            }
            Axes.this.fireEvent = true;
            RedrawEvent re = new RedrawEvent(this);
            re.type = 4;
            Axes.this.fireRedrawEvent(re);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int rangeIndex = Axes.this.rangeSlider.getRangeIndex();
            Axes.this.rangeSliderToolTipStr = " ";
            if (rangeIndex > -1) {
                Axes.this.rangeSliderToolTipStr = Axes.this.getReferenceValueTooltipText(rangeIndex, Axes.this.rangeSlider.getRangePart());
                Axes.this.rangeSliderToolTipX = e.getX();
                Axes.this.rangeSliderToolTipY = e.getY();
            }
            Axes.this.fireEvent = true;
            RedrawEvent re = new RedrawEvent(this);
            re.type = 4;
            Axes.this.fireRedrawEvent(re);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Axes.this.rangeSliderToolTipStr = " ";
            Axes.this.fireEvent = true;
            RedrawEvent re = new RedrawEvent(this);
            re.type = 4;
            Axes.this.fireRedrawEvent(re);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Axes.this.rangeSliderToolTipStr = " ";
            Axes.this.fireEvent = true;
            RedrawEvent re = new RedrawEvent(this);
            re.type = 4;
            Axes.this.fireRedrawEvent(re);
        }
    }

    public class AxisElement {
        public double value;
        public Line2D tick = null;
        public Color tickColor = null;
        public Object unfmtValue;
        public String label;
        public Color labelColor = null;
        public String description = null;
    }

    private class ReplacementElement {
        private String propertyName = null;
        private String replacementText = null;
        private Object value = null;

        ReplacementElement(String propName, String text, Object val) {
            this.propertyName = propName;
            this.replacementText = text;
            this.value = val;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        String getReplacementText() {
            return this.replacementText;
        }

        Object getValue() {
            return this.value;
        }
    }

    private class TooltipText {
        private int part;
        private String text = null;
        private Object arguments = null;

        TooltipText(int part, String txt, Object args) {
            this.part = part;
            this.text = txt;
            this.arguments = args;
        }

        int getPart() {
            return this.part;
        }

        String getText() {
            return this.text;
        }

        Object getArgs() {
            return this.arguments;
        }
    }
}

