/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.info.RoleAssigner;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Image;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class SILKWizardEntry
extends WizardEntry {
    BaseElement baseElement = null;
    protected boolean baseElementQueried = false;
    SILKChartInfo info = null;

    public void init(Element entryDescription, Object data, ResourceBundle resource) {
        super.init(entryDescription, data, resource);
        this.info = SILKChartInfo.getInstance(this.chartElement.getAttribute("info"));
    }

    public boolean canLoad() {
        return this.info != null;
    }

    protected void loadGraph() {
        if (this.info == null) {
            return;
        }
        this.graph = this.info.newCommponentInstance();
        this.graphQueried = false;
        this.info.assignDataSource(this.graph, this.source);
        this.info.doXMLInit(this.graph);
    }

    public void doRoleAssignments(Object chart) {
        if (this.info == null || !(chart instanceof RoleInterface)) {
            return;
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)this.source);
        RoleAssigner assigner = new RoleAssigner(dfri, this.info);
        assigner.doRoleAssignments((RoleInterface)chart);
        FilterFactory.detachFilter((DataFilterReadInterface)dfri);
        dfri.removeSource();
    }

    public void reset() {
        super.reset();
        this.baseElement = null;
        this.baseElementQueried = false;
    }

    public BaseElement getBaseElement() {
        if (this.baseElement == null) {
            this.baseElement = this.info.newElementInstance();
        }
        this.baseElementQueried = true;
        return this.baseElement;
    }

    public void setupGraph(Object chart) {
        this.info.assignDataSource(chart, this.source);
        this.info.doXMLInit(chart);
        this.doRoleAssignments(chart);
    }

    public boolean areRequiredRolesAssigned() {
        if (this.info == null) {
            return false;
        }
        return this.info.areRequiredRolesAssigned(this.graph);
    }

    public SILKChartInfo getChartInfo() {
        return this.info;
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public Icon getIcon() {
        return this.info.getIcon();
    }

    public Image getImage() {
        return this.info.getImage();
    }

    public void dispose() {
        super.dispose();
        if (!this.graphQueried && this.graph != null && this.graph instanceof BaseComponentInterface) {
            ((BaseComponentInterface)((Object)this.graph)).dispose();
        }
        this.graph = null;
        if (!this.baseElementQueried && this.baseElement != null) {
            this.baseElement.dispose();
        }
        this.baseElement = null;
    }

    JComponent _internalGetGraph() {
        if (this.graph == null) {
            this.loadGraph();
        }
        if (this.graph instanceof JComponent) {
            return (JComponent)this.graph;
        }
        return null;
    }
}

