/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.BackgroundDialog;
import com.sas.graphics.silk.util.GradientPreviewButton;
import com.sas.graphics.silk.util.ImagePreviewButton;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class TipDialog
extends JDialog
implements ActionListener,
GraphBackgroundInterface {
    private static final long serialVersionUID = 4057858856632528165L;
    PropertyInterface graph = null;
    Text tipText = null;
    TextDialog textDialog = null;
    GraphBackgroundInterface background = null;
    BackgroundDialog bDialog = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JSlider jSlider1 = new JSlider();
    private JButton jButton1 = new JButton();
    private JButton jButton2 = new JButton();
    private JButton jButton3 = new JButton();
    private JButton jButton5 = new JButton();
    private JButton jButton7 = new JButton();
    private JButton jButton6 = new JButton();

    public TipDialog(Frame parent, PropertyInterface p) {
        super(parent);
        this.setModal(true);
        this.setResizable(false);
        this.tipText = new Text();
        this.tipText.setEffectsSupported(false);
        this.tipText.setJustifySupported(false);
        this.tipText.setFormatSupported(false);
        this.initGUI();
        this.graph = p;
        this.textDialog = new TextDialog(parent, null);
        this.setSize(275, 180);
        this.initFromSource();
        if (p == null) {
            return;
        }
        Object o = p.getPropertyValue(7);
        if (o instanceof GraphBackgroundInterface) {
            this.background = (GraphBackgroundInterface)o;
            this.bDialog = new BackgroundDialog(parent);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TipDialog.this.cancel();
            }
        });
        this.jButton1.addActionListener(this);
        this.jButton2.addActionListener(this);
        this.jButton3.addActionListener(this);
        this.jButton5.addActionListener(this);
        this.jButton6.addActionListener(this);
        this.jButton7.addActionListener(this);
    }

    private void initFromSource() {
        if (this.graph == null) {
            return;
        }
        Object o = null;
        o = this.graph.getPropertyValue(3);
        if (o != null && o instanceof Font) {
            this.tipText.setFont(o);
        }
        if (o == null) {
            this.tipText.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)12));
        }
        Color c = null;
        o = this.graph.getPropertyValue(4);
        if (o != null && o instanceof Color) {
            c = (Color)o;
        }
        if (c != null) {
            this.tipText.setColor(c);
        }
        c = null;
        o = this.graph.getPropertyValue(5);
        if (o != null && o instanceof Color) {
            c = (Color)o;
        }
        if (c != null) {
            this.jPanel2.setBackground(c);
        }
        c = null;
        o = this.graph.getPropertyValue(6);
        if (o != null && o instanceof Color) {
            c = (Color)o;
        }
        if (c != null) {
            this.jPanel4.setBackground(c);
        }
        Number n = null;
        o = this.graph.getPropertyValue(8);
        if (o != null && o instanceof Number) {
            n = (Number)o;
        }
        if (n != null) {
            this.jSlider1.setValue((int)(100.0 * n.doubleValue()));
        }
    }

    private void initGUI() {
        this.jButton7.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Apply.txt", (String)"Apply"));
        this.jButton7.setBounds(new Rectangle(184, 115, 80, 25));
        this.jButton7.setFont(TabbedPropertiesDialog.dialogFont);
        this.jButton6.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.OK.txt", (String)"OK"));
        this.jButton6.setBounds(new Rectangle(14, 115, 80, 25));
        this.jButton6.setFont(TabbedPropertiesDialog.dialogFont);
        this.jButton3.setBounds(new Rectangle(231, 45, 21, 17));
        this.jButton2.setBounds(new Rectangle(231, 67, 21, 17));
        this.jButton2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Elipsis.txt", (String)"..."));
        this.jButton3.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Elipsis.txt", (String)"..."));
        this.jPanel4.setBounds(new Rectangle(124, 67, 106, 17));
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jLabel5.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Border.txt", (String)"Border"));
        this.jLabel5.setBounds(new Rectangle(26, 42, 75, 20));
        this.jLabel5.setForeground(new Color(51, 0, 51));
        this.jLabel5.setFont(TabbedPropertiesDialog.dialogFont);
        this.jLabel4.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Color.txt", (String)"Color"));
        this.jLabel4.setBounds(new Rectangle(17, 56, 53, 20));
        this.jLabel4.setForeground(new Color(51, 0, 51));
        this.jLabel4.setFont(TabbedPropertiesDialog.dialogFont);
        this.jLabel2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Opacity.txt", (String)"Opacity"));
        this.jLabel2.setBounds(new Rectangle(26, 90, 75, 20));
        this.jLabel2.setForeground(new Color(51, 0, 51));
        this.jLabel2.setFont(TabbedPropertiesDialog.dialogFont);
        this.pack();
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Chart_Tip_Options.txt", (String)"Chart Tip Options"));
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.jLabel2);
        this.getContentPane().add(this.jLabel5);
        this.getContentPane().add(this.jPanel2);
        this.getContentPane().add(this.jPanel4);
        this.getContentPane().add(this.jSlider1);
        this.getContentPane().add(this.jButton2);
        this.getContentPane().add(this.jButton3);
        this.getContentPane().add(this.jButton5);
        this.getContentPane().add(this.jButton6);
        this.getContentPane().add(this.jButton7);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Text.txt", (String)"Text"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(26, 10, 75, 25);
        this.getContentPane().add(label);
        this.jLabel1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Background.txt", (String)"Background"));
        this.jLabel1.setBounds(new Rectangle(26, 67, 75, 17));
        this.jLabel1.setForeground(new Color(51, 0, 51));
        this.jLabel1.setFont(TabbedPropertiesDialog.dialogFont);
        this.jPanel2.setBounds(new Rectangle(124, 45, 106, 17));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jSlider1.setBounds(new Rectangle(124, 90, 129, 17));
        this.jButton1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Font.txt", (String)"Font..."));
        this.jButton1.setBounds(new Rectangle(124, 13, 127, 22));
        this.getContentPane().add(this.jButton1);
        this.jButton1.setFont(TabbedPropertiesDialog.dialogFont);
        this.jButton5.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Cancel.txt", (String)"Cancel"));
        this.jButton5.setBounds(new Rectangle(100, 115, 80, 25));
        this.jButton5.setFont(TabbedPropertiesDialog.dialogFont);
        this.pack();
    }

    private void cancel() {
        this.graph.cancelPropertyChanges();
        this.initFromSource();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jButton1) {
            this.textDialog.showDialog(this.tipText, ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Tip_Text_Options.txt", (String)""));
            this.graph.setPropertyValue(4, (Object)this.tipText.getColor());
            this.graph.setPropertyValue(3, (Object)this.tipText.getFont());
        } else if (source == this.jButton2) {
            if (this.background != null) {
                this.bDialog.show(this.jPanel4, this);
            } else {
                Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Pick_a_Color.txt", (String)"Pick a Color"), this.jPanel4.getBackground());
                if (c != null) {
                    this.jPanel4.setBackground(c);
                    this.graph.setPropertyValue(6, (Object)this.jPanel4.getBackground());
                }
            }
        } else if (source == this.jButton3) {
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"TipDialog.Pick_a_Color.txt", (String)"Pick a Color"), this.jPanel2.getBackground());
            if (c != null) {
                this.jPanel2.setBackground(c);
                this.graph.setPropertyValue(5, (Object)this.jPanel2.getBackground());
            }
        } else if (source == this.jButton5) {
            this.cancel();
            this.setVisible(false);
        } else if (source == this.jButton6) {
            this.graph.setPropertyValue(8, (Object)new Double((double)this.jSlider1.getValue() / 100.0));
            this.graph.applyPropertyChanges();
            this.setVisible(false);
        } else if (source == this.jButton7) {
            this.graph.setPropertyValue(8, (Object)new Double((double)this.jSlider1.getValue() / 100.0));
            this.graph.applyPropertyChanges();
        }
    }

    @Override
    public Object[] getGraphBackground() {
        return this.background.getGraphBackground();
    }

    @Override
    public boolean supportsGradientBackground() {
        return this.background.supportsGradientBackground();
    }

    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        this.background.setGradientBackground(startColor, endColor, orientation);
        GradientPreviewButton g = new GradientPreviewButton();
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.add("Center", g);
        g.setGradientBackground(new GradientPaint(0.0f, 0.0f, (Color)startColor, 1.0f, 1.0f, (Color)endColor));
        return true;
    }

    @Override
    public boolean supportsImageBackground() {
        return this.background.supportsImageBackground();
    }

    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        this.background.setImageBackground(img, fitStyle, x, y, blend);
        ImagePreviewButton b = new ImagePreviewButton();
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.add("Center", b);
        b.setImage(img);
        return true;
    }

    @Override
    public Color getSolidBackground() {
        return this.background.getSolidBackground();
    }

    @Override
    public boolean setSolidBackground(Object c) {
        this.background.setSolidBackground(c);
        this.jPanel4.removeAll();
        if (c instanceof Color) {
            this.jPanel4.setBackground((Color)c);
        }
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        this.background.redrawGraphBackground(c);
    }
}

