/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedPropertiesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4049732329026990689L;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    JButton ok = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"TabbedPropertiesDialog.OK.txt", (String)"OK"));
    JButton apply = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"TabbedPropertiesDialog.Apply.txt", (String)"Apply"));
    JButton cancel = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"TabbedPropertiesDialog.Cancel.txt", (String)"Cancel"));
    public static final Font dialogFont = TabbedPropertiesDialog.loadDialogFont();
    JTabbedPane tabPanel = null;
    Vector tabs = new Vector();
    Component chart;
    boolean fComponentsAdjusted = false;

    public TabbedPropertiesDialog(Frame parent, Component chart, String title) {
        super(parent);
        this.setModal(true);
        this.chart = chart;
        this.tabPanel = new JTabbedPane(1, 1);
        this.tabPanel.setFont(dialogFont);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.setSize(280, 500);
        this.setTitle(title);
        this.setResizable(false);
        c.add("Center", this.tabPanel);
        this.ok.setFont(dialogFont);
        this.apply.setFont(dialogFont);
        this.cancel.setFont(dialogFont);
        JPanel p = new JPanel(new FlowLayout(2));
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(1, 3));
        this.ok.setPreferredSize(this.cancel.getPreferredSize());
        this.apply.setPreferredSize(this.cancel.getPreferredSize());
        pan.add(this.ok);
        pan.add(this.cancel);
        pan.add(this.apply);
        p.add(pan);
        c.add("South", p);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        UIUtilities.center(this);
    }

    public boolean setActiveTab(int which) {
        try {
            this.tabPanel.setSelectedIndex(which);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (this.tabPanel != null && this.tabPanel.getSelectedComponent() != null) {
            this.tabPanel.getSelectedComponent().setVisible(b);
        }
        super.setVisible(b);
    }

    void TabbedPropertiesDialog_WindowClosing(WindowEvent event) {
        this.fireCancel();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.ok) {
            this.fireApply();
            this.setVisible(false);
        } else if (source == this.apply) {
            this.fireApply();
        } else if (source == this.cancel) {
            this.fireCancel();
            this.setVisible(false);
        }
    }

    public TabPanelInterface getActivePanel() {
        return (TabPanelInterface)((Object)this.tabPanel.getSelectedComponent());
    }

    public void addTab(String title, TabPanelInterface panel) {
        if (panel == null) {
            return;
        }
        if (panel instanceof JComponent) {
            this.tabPanel.addTab(title, (JComponent)((Object)panel));
        }
        this.tabs.addElement(panel);
    }

    public void insertTab(String title, TabPanelInterface panel, int index) {
        if (panel == null) {
            return;
        }
        if (panel instanceof JComponent) {
            this.tabPanel.insertTab(title, null, (JComponent)((Object)panel), title, index);
        }
        this.tabs.insertElementAt(panel, index);
    }

    public void removeTab(String tabTitle) {
        int target = -1;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            if (!tabTitle.equals(this.tabPanel.getTitleAt(i))) continue;
            target = i;
        }
        if (target > 0) {
            this.tabPanel.removeTabAt(target);
        }
    }

    private void fireApply() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            ((TabPanelInterface)this.tabs.elementAt(i)).applyChanges();
        }
        if (this.chart != null) {
            this.chart.repaint();
        }
    }

    private void fireCancel() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            ((TabPanelInterface)this.tabs.elementAt(i)).cancelChanges();
        }
    }

    public TabPanelInterface getTabAt(int i) {
        return (TabPanelInterface)((Object)this.tabPanel.getComponentAt(i));
    }

    public TabPanelInterface[] getTabs() {
        TabPanelInterface[] rc = new TabPanelInterface[this.tabPanel.getTabCount()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (TabPanelInterface)((Object)this.tabPanel.getComponentAt(i));
        }
        return rc;
    }

    public TabPanelInterface getTab(Class tabClass) {
        TabPanelInterface rc = null;
        TabPanelInterface[] tabs = this.getTabs();
        for (int i = 0; i < tabs.length; ++i) {
            if (!tabClass.isInstance(tabs[i])) continue;
            rc = tabs[i];
        }
        return rc;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPanel;
    }

    private static Font loadDialogFont() {
        Font rc = null;
        String defaultFontName = "Dialog";
        int defaultFontStyle = 0;
        int defaultFontSize = 11;
        String fontName = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"TabbedPropertiesDialog.DialogFont.FontName.fnt", (String)defaultFontName);
        int fontStyle = defaultFontStyle;
        String style = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"TabbedPropertiesDialog.DialogFont.FontName.fnt", (String)"plain");
        if (style.equalsIgnoreCase("bold")) {
            fontStyle = 1;
        } else if (style.equalsIgnoreCase("italic")) {
            fontStyle = 2;
        } else if (style.equalsIgnoreCase("bolditalic")) {
            fontStyle = 3;
        }
        int fontSize = ResourceLoader.getResourceInteger((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"TabbedPropertiesDialog.DialogFont.FontSize.fnt", (int)defaultFontSize);
        rc = FontManager.getFont((String)fontName, (int)fontStyle, (int)fontSize);
        return rc;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TabbedPropertiesDialog.this) {
                TabbedPropertiesDialog.this.TabbedPropertiesDialog_WindowClosing(event);
            }
        }
    }
}

