/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.ui.SortEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class SortPanel
extends JPanel
implements RoleListenerInterface {
    private static final long serialVersionUID = -1698082540920053250L;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel = null;
    private RoleInterface chart = null;
    private Vector allEntries = new Vector();

    public SortPanel(RoleInterface chart) {
        this.chart = chart;
        chart.addRoleListener(this);
        this.initialize();
    }

    private void initialize() {
        int i;
        int i2;
        this.getJPanel().removeAll();
        this.removeAll();
        this.allEntries.removeAllElements();
        this.setLayout(new BorderLayout());
        this.setSize(610, 364);
        this.add((Component)this.getJScrollPane(), "Center");
        Object[][] roles = this.chart.getSupportedSortableRoles();
        Vector<Component> panels = new Vector<Component>();
        if (roles == null) {
            return;
        }
        for (i2 = 0; i2 < roles.length; ++i2) {
            SortEntry[] entries = new SortEntry[roles[i2].length];
            boolean dependent = entries.length > 1;
            ButtonGroup bg = null;
            if (dependent) {
                bg = new ButtonGroup();
            }
            for (int j = 0; j < roles[i2].length; ++j) {
                entries[j] = new SortEntry(roles[i2][j], this.chart.getSupportedSortDirections(roles[i2][j]), dependent);
                entries[j].init(this.chart, !dependent);
                if (dependent) {
                    entries[j].ignoreEvents = true;
                    entries[j].radioButton.setSelected(this.chart.getSortOrder(roles[i2][j]) != null);
                    bg.add(entries[j].radioButton);
                    entries[j].ignoreEvents = false;
                }
                this.allEntries.addElement(entries[j]);
            }
            JPanel panel = new JPanel();
            if (i2 > 0) {
                JSeparator s = new JSeparator();
                s.setPreferredSize(new Dimension(500, 12));
                s.setMaximumSize(new Dimension(500, 12));
                panels.addElement(Box.createRigidArea(new Dimension(25, 8)));
                panels.addElement(s);
            }
            panel.setLayout(new BoxLayout(panel, 1));
            for (int j = 0; j < entries.length; ++j) {
                panel.add(entries[j]);
            }
            panels.addElement(panel);
        }
        for (i2 = 0; i2 < panels.size(); ++i2) {
            this.jPanel.add((JComponent)panels.elementAt(i2));
        }
        Dimension d = new Dimension();
        for (i = 0; i < this.allEntries.size(); ++i) {
            SortEntry entry = (SortEntry)this.allEntries.elementAt(i);
            entry.init(this.chart, false);
            Dimension d1 = entry.label.getPreferredSize();
            if (d.width < d1.width) {
                d.width = d1.width;
            }
            if (d.height >= d1.height) continue;
            d.height = d1.height;
        }
        for (i = 0; i < this.allEntries.size(); ++i) {
            ((SortEntry)this.allEntries.elementAt((int)i)).label.setPreferredSize(d);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.initialize();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJPanel());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.jPanel.setLayout(new BoxLayout(this.jPanel, 1));
        }
        return this.jPanel;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        if (e.type != 5) {
            this.initialize();
        }
        this.revalidate();
        this.repaint();
    }
}

