/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ScatterDialogDefaults;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScatterAdvancedPanel
extends JPanel
implements ActionListener,
ChangeListener,
FocusListener,
TabPanelInterface {
    private static final long serialVersionUID = -3987366407725703005L;
    protected boolean internalUpdate;
    protected boolean listenersAdded;
    protected JPanel CoalescePanel;
    protected JCheckBox CoalesceCheckBox;
    protected JLabel CoalesceStatLabel;
    protected JComboBox CoalesceStatCombo;
    protected JSlider CoalesceSlider;
    protected JLabel CoalesceSliderLabel;
    protected TitledBorder CoalesceBorder;
    protected TitledBorder SelectionBorder;
    protected JPanel SelectionPanel;
    protected JCheckBox AlwaysShowCheckBox;
    protected JCheckBox RestrictBrushCheckBox;
    protected JCheckBox PreserveDuplicates;
    protected ButtonGroup SelectionBtnGrp;
    protected JRadioButton SmartRadioBtn;
    protected JRadioButton GrowRadioBtn;
    protected JRadioButton ColorRadioBtn;
    protected JPanel SelectionRadioPanel;
    protected TitledBorder SelectionRadioBorder;
    protected JPanel RegressionPanel;
    protected JCheckBox RegressionCheckBox;
    protected JLabel RegressionColorLbl;
    protected JPanel RegressionColorPanel;
    protected JButton RegressionColorBtn;
    protected JLabel RegressionWidthLbl;
    protected JComboBox RegressionWidthCombo;
    protected TitledBorder RegressionBorder;
    protected JPanel BaseLinePanel;
    protected JCheckBox BaseLineCheckBox;
    protected TitledBorder BaseLineBorder;
    protected TitledBorder BaseLineRadioBorder;
    protected JPanel BaseLineRadioPanel;
    protected JRadioButton ChartBaseRadioBtn;
    protected JRadioButton CustomBaseRadioBtn;
    protected ButtonGroup BaseLineBtnGrp;
    protected JTextField BaseLineSlope;
    protected JTextField BaseLineIntercept;
    protected JColorChooser colorChooser;
    protected String slopeTextOnEnter;
    protected String interceptTextOnEnter;
    protected Vector propListeners;
    protected ScatterDialogDefaults defaults;
    protected ResourceBundle rb;

    public ScatterAdvancedPanel(PropertyInterface chart) {
        Insets ins = this.getInsets();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.slopeTextOnEnter = null;
        this.interceptTextOnEnter = null;
        this.listenersAdded = false;
        this.defaults = new ScatterDialogDefaults();
        this.colorChooser = null;
        this.propListeners = new Vector();
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)chart);
        this.internalUpdate = false;
        this.setLayout(null);
        this.setSize(ins.left + ins.right + 280, ins.top + ins.bottom + 270);
        this.createControls();
    }

    protected void createControls() {
        this.setFont(TabbedPropertiesDialog.dialogFont);
        this.CoalesceBorder = new TitledBorder(new EtchedBorder());
        this.CoalesceBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.BaseLineBorder = new TitledBorder(new EtchedBorder());
        this.BaseLineBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.BaseLineRadioBorder = new TitledBorder(new EtchedBorder());
        this.BaseLineRadioBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.SelectionBorder = new TitledBorder(new EtchedBorder());
        this.SelectionBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.SelectionRadioBorder = new TitledBorder(new EtchedBorder());
        this.SelectionRadioBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionBorder = new TitledBorder(new EtchedBorder());
        this.RegressionBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.CoalescePanel = new JPanel();
        this.CoalesceCheckBox = new JCheckBox();
        this.CoalesceCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.CoalesceStatLabel = new JLabel();
        this.CoalesceStatLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.CoalesceStatCombo = new JComboBox();
        this.CoalesceStatCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.CoalesceSliderLabel = new JLabel();
        this.CoalesceSliderLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.CoalesceSlider = new JSlider();
        this.CoalescePanel.setVisible(this.defaults.allowCoalesceOptions && !this.defaults.allowBaseLineOptions);
        this.BaseLinePanel = new JPanel();
        this.BaseLineRadioPanel = new JPanel();
        this.BaseLineCheckBox = new JCheckBox();
        this.BaseLineCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.ChartBaseRadioBtn = new JRadioButton();
        this.ChartBaseRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.CustomBaseRadioBtn = new JRadioButton();
        this.CustomBaseRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.BaseLineBtnGrp = new ButtonGroup();
        this.BaseLineRadioBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Selection_Indicator_Border_Title.txt", (String)"Selection Indicator"));
        this.BaseLineRadioBorder.setTitleColor(Color.black);
        this.BaseLineSlope = new JTextField();
        this.BaseLineIntercept = new JTextField();
        this.BaseLinePanel.setVisible(this.defaults.allowBaseLineOptions);
        this.SelectionPanel = new JPanel();
        this.AlwaysShowCheckBox = new JCheckBox();
        this.AlwaysShowCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.RestrictBrushCheckBox = new JCheckBox();
        this.RestrictBrushCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.PreserveDuplicates = new JCheckBox();
        this.PreserveDuplicates.setFont(TabbedPropertiesDialog.dialogFont);
        this.SelectionRadioPanel = new JPanel();
        this.SmartRadioBtn = new JRadioButton();
        this.SmartRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.ColorRadioBtn = new JRadioButton();
        this.ColorRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.GrowRadioBtn = new JRadioButton();
        this.GrowRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.SelectionBtnGrp = new ButtonGroup();
        this.SelectionRadioBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Selection_Indicator_Border_Title.txt", (String)"Selection Indicator"));
        this.SelectionRadioBorder.setTitleColor(Color.black);
        this.RegressionPanel = new JPanel();
        this.RegressionCheckBox = new JCheckBox();
        this.RegressionCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionColorPanel = new JPanel();
        this.RegressionColorLbl = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Color_Label.txt", (String)"Color:"));
        this.RegressionColorLbl.setFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionColorBtn = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Color_Button.txt", (String)"..."));
        this.RegressionColorBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionWidthLbl = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_Label.txt", (String)"Width:"));
        this.RegressionWidthLbl.setFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionWidthCombo = new JComboBox();
        this.RegressionWidthCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.RegressionPanel.setVisible(this.defaults.allowRegressionOptions);
        this.setVisible(false);
        this.CoalescePanel.setLayout(null);
        this.add(this.CoalescePanel);
        this.CoalescePanel.setBounds(4, 298, 270, 140);
        this.CoalesceCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Coalesce_Markers_Checkbox.txt", (String)"Coalesce Markers"));
        this.CoalesceCheckBox.setActionCommand("Coalesce Markers");
        this.CoalescePanel.add(this.CoalesceCheckBox);
        this.CoalesceCheckBox.setBounds(24, 20, 220, 24);
        this.CoalesceStatLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Coalesce_Statistic_Label.txt", (String)"Statistic:"));
        this.CoalescePanel.add(this.CoalesceStatLabel);
        this.CoalesceStatLabel.setForeground(Color.black);
        this.CoalesceStatLabel.setBounds(24, 48, 60, 24);
        this.CoalescePanel.add(this.CoalesceStatCombo);
        this.CoalesceStatCombo.setBackground(Color.white);
        this.CoalesceStatCombo.setBounds(84, 48, 120, 24);
        this.CoalesceSliderLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Coalesce_Distance_Label.txt", (String)"Coalesce Distance:"));
        this.CoalescePanel.add(this.CoalesceSliderLabel);
        this.CoalesceSliderLabel.setForeground(Color.black);
        this.CoalesceSliderLabel.setBounds(24, 80, 220, 24);
        this.CoalesceSlider.setExtent(5);
        this.CoalescePanel.add(this.CoalesceSlider);
        this.CoalesceSlider.setBounds(24, 110, 200, 24);
        this.CoalesceBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Coalesce_Border_Title.txt", (String)"Coalesce"));
        this.CoalesceBorder.setTitleColor(Color.black);
        this.CoalescePanel.setBorder(this.CoalesceBorder);
        this.CoalesceStatCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Selection_Statistic_Frequency.txt", (String)"Frequency"));
        this.CoalesceStatCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Selection_Statistic_Sum.txt", (String)"Sum"));
        this.CoalesceStatCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Selection_Statistic_Mean.txt", (String)"Mean"));
        this.SelectionPanel.setLayout(null);
        this.add(this.SelectionPanel);
        this.SelectionPanel.setBounds(4, 6, 270, 172);
        this.SelectionBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Marker_Selection_Border_Title.txt", (String)"Markers"));
        this.SelectionBorder.setTitleColor(Color.black);
        this.SelectionPanel.setBorder(this.SelectionBorder);
        this.AlwaysShowCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Always_Show_Selected_Markers_Checkbox.txt", (String)"Always Show Selected Markers"));
        this.AlwaysShowCheckBox.setActionCommand("Always Show");
        this.SelectionPanel.add(this.AlwaysShowCheckBox);
        this.AlwaysShowCheckBox.setBounds(24, 34, 210, 24);
        this.RestrictBrushCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Restrict_Brush_To_Chart_Area_Checkbox.txt", (String)"Restrict Brush To Chart Area"));
        this.RestrictBrushCheckBox.setActionCommand("Restrict Brush");
        this.SelectionPanel.add(this.RestrictBrushCheckBox);
        this.RestrictBrushCheckBox.setBounds(24, 16, 220, 24);
        this.PreserveDuplicates.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.PreserveDuplicates.txt", (String)"Always Preserve Duplicate Ordering"));
        this.PreserveDuplicates.setActionCommand("Preserve Duplicates");
        this.SelectionPanel.add(this.PreserveDuplicates);
        this.PreserveDuplicates.setBounds(24, 142, 220, 24);
        this.SelectionRadioPanel.setLayout(null);
        this.SelectionPanel.add(this.SelectionRadioPanel);
        this.SelectionRadioPanel.setBounds(24, 56, 188, 88);
        this.SelectionRadioPanel.setBorder(this.SelectionRadioBorder);
        this.SmartRadioBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Smart_Selection_Radio_Button.txt", (String)"Smart"));
        this.SmartRadioBtn.setActionCommand("Smart Selection");
        this.SelectionRadioPanel.add(this.SmartRadioBtn);
        this.SmartRadioBtn.setBounds(8, 16, 160, 24);
        this.ColorRadioBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Use_Selection_Color_Radio_Button.txt", (String)"Use Selection Color"));
        this.ColorRadioBtn.setActionCommand("Use Selection Color");
        this.SelectionRadioPanel.add(this.ColorRadioBtn);
        this.ColorRadioBtn.setBounds(8, 36, 160, 24);
        this.GrowRadioBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Grow_Marker_Size_Radio_Button.txt", (String)"Grow Marker Size"));
        this.GrowRadioBtn.setActionCommand("Grow Marker Size");
        this.SelectionRadioPanel.add(this.GrowRadioBtn);
        this.GrowRadioBtn.setBounds(8, 56, 160, 24);
        this.SelectionBtnGrp.add(this.SmartRadioBtn);
        this.SelectionBtnGrp.add(this.ColorRadioBtn);
        this.SelectionBtnGrp.add(this.GrowRadioBtn);
        this.RegressionPanel.setLayout(null);
        this.add(this.RegressionPanel);
        this.RegressionPanel.setBounds(4, 178, 270, 120);
        this.RegressionCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Show_Line.txt", (String)"Show Line"));
        this.RegressionCheckBox.setActionCommand("Show Line");
        this.RegressionPanel.add(this.RegressionCheckBox);
        this.RegressionCheckBox.setBounds(24, 20, 140, 24);
        this.RegressionPanel.add(this.RegressionColorLbl);
        this.RegressionColorLbl.setBounds(24, 48, 60, 24);
        this.RegressionColorLbl.setForeground(Color.black);
        this.RegressionPanel.add(this.RegressionColorPanel);
        this.RegressionColorPanel.setBounds(88, 48, 120, 24);
        this.RegressionColorPanel.setBackground(Color.blue);
        this.RegressionPanel.add(this.RegressionColorBtn);
        this.RegressionColorBtn.setBounds(212, 48, 24, 24);
        this.RegressionPanel.add(this.RegressionWidthLbl);
        this.RegressionWidthLbl.setForeground(Color.black);
        this.RegressionWidthLbl.setBounds(24, 76, 60, 24);
        this.RegressionPanel.add(this.RegressionWidthCombo);
        this.RegressionWidthCombo.setBounds(88, 76, 100, 24);
        this.RegressionWidthCombo.setBackground(Color.white);
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_1_pt.txt", (String)"1 pt"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_2_pts.txt", (String)"2 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_3_pts.txt", (String)"3 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_4_pts.txt", (String)"4 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_5_pts.txt", (String)"5 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_6_pts.txt", (String)"6 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_7_pts.txt", (String)"7 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_8_pts.txt", (String)"8 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_9_pts.txt", (String)"9 pts"));
        this.RegressionWidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Width_10_pts.txt", (String)"10 pts"));
        this.RegressionBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Regression_Border_Title.txt", (String)"Regression"));
        this.RegressionBorder.setTitleColor(Color.black);
        this.RegressionPanel.setBorder(this.RegressionBorder);
        this.BaseLinePanel.setLayout(null);
        this.add(this.BaseLinePanel);
        this.BaseLinePanel.setBounds(4, 298, 270, 140);
        this.BaseLineCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.BaseLine_Checkbox.txt", (String)"Show Base Line"));
        this.BaseLineCheckBox.setActionCommand("Show Base Line");
        this.BaseLinePanel.add(this.BaseLineCheckBox);
        this.BaseLineCheckBox.setBounds(24, 20, 220, 24);
        this.BaseLineRadioPanel.setLayout(null);
        this.BaseLinePanel.add(this.BaseLineRadioPanel);
        this.BaseLineRadioPanel.setBounds(24, 46, 188, 88);
        this.BaseLineRadioPanel.setBorder(this.BaseLineRadioBorder);
        this.BaseLineRadioPanel.add(this.ChartBaseRadioBtn);
        this.ChartBaseRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.ChartBaseRadioBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.ChartBaseRadioButton_Text.txt", (String)"Chart Base"));
        this.ChartBaseRadioBtn.setBounds(8, 16, 160, 24);
        this.BaseLineRadioPanel.add(this.CustomBaseRadioBtn);
        this.CustomBaseRadioBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.CustomBaseRadioBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.CustomBaseRadioButton_Text.txt", (String)"Custom Base"));
        this.CustomBaseRadioBtn.setBounds(8, 36, 160, 24);
        this.BaseLineBtnGrp.add(this.ChartBaseRadioBtn);
        this.BaseLineBtnGrp.add(this.CustomBaseRadioBtn);
        this.BaseLineRadioPanel.add(this.BaseLineSlope);
        this.BaseLineSlope.setFont(TabbedPropertiesDialog.dialogFont);
        this.BaseLineSlope.setBounds(8, 60, 80, 20);
        this.BaseLineRadioPanel.add(this.BaseLineIntercept);
        this.BaseLineIntercept.setFont(TabbedPropertiesDialog.dialogFont);
        this.BaseLineIntercept.setBounds(92, 60, 80, 20);
        this.BaseLineRadioBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.BaseLineRadioBorder_Title.txt", (String)"Base Line Location"));
        this.BaseLineRadioBorder.setTitleColor(Color.black);
        this.BaseLineRadioPanel.setBorder(this.BaseLineRadioBorder);
        this.BaseLineBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.BaseLine_Border_Title.txt", (String)"Base Line"));
        this.BaseLineBorder.setTitleColor(Color.black);
        this.BaseLinePanel.setBorder(this.BaseLineBorder);
    }

    protected Color showColorChooserDialog(Color initialColor) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterAdvancedPanel.Color_Chooser_Dialog_Title.txt", (String)"Choose a color"), initialColor);
    }

    protected double getTextFieldNumber(JTextField text, double defaultValue) {
        double d;
        String s;
        if (text == null || (s = text.getText()) == null) {
            return defaultValue;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            d = defaultValue;
        }
        return d;
    }

    protected Object getObjectProperty(Vector props, int id, Object defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(Vector props, int id, Color defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected double getNumericProperty(Vector props, int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected int getIntegerProperty(Vector props, int id, int defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).intValue();
    }

    protected void setCustomBaseLine() {
        Object obj = null;
        double[] da = new double[2];
        if (da == null) {
            return;
        }
        da[0] = this.getTextFieldNumber(this.BaseLineSlope, Double.NaN);
        da[1] = this.getTextFieldNumber(this.BaseLineIntercept, Double.NaN);
        obj = Double.isNaN(da[0]) ? (Object)new Double(da[1]) : da;
        PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2065, (Object)obj);
        this.slopeTextOnEnter = null;
        this.interceptTextOnEnter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCoalesceSettings() {
        boolean coalesceOn = false;
        boolean haveSizeVar = false;
        int e = -1;
        ScatterAdvancedPanel scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = true;
        }
        coalesceOn = this.getBooleanProperty(this.propListeners, 2038, false);
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2006);
        haveSizeVar = o != null && o instanceof String;
        this.CoalesceStatLabel.setEnabled(coalesceOn && haveSizeVar);
        this.CoalesceStatCombo.setEnabled(coalesceOn && haveSizeVar);
        this.CoalesceSliderLabel.setEnabled(coalesceOn);
        this.CoalesceSlider.setEnabled(coalesceOn);
        e = (int)this.getNumericProperty(this.propListeners, 2041, -1.0);
        switch (e) {
            default: {
                this.CoalesceStatCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.CoalesceStatCombo.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.CoalesceStatCombo.setSelectedIndex(2);
            }
        }
        double d = this.getNumericProperty(this.propListeners, 2039, 1.0);
        double range = this.getNumericProperty(this.propListeners, 2042, 1.0);
        if (!Double.isNaN(d) && !Double.isNaN(range)) {
            int sliderMin = this.CoalesceSlider.getMinimum();
            int sliderMax = this.CoalesceSlider.getMaximum();
            int sliderValue = (int)((double)(sliderMax - sliderMin) * (d / (0.5 * range)) + (double)sliderMin);
            sliderValue = sliderValue < sliderMin ? sliderMin : sliderValue;
            sliderValue = sliderValue > sliderMax ? sliderMax : sliderValue;
            this.CoalesceSlider.setValue(sliderValue);
        }
        scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectionSettings() {
        boolean alwaysOn = false;
        boolean restrict = false;
        int e = -1;
        Object o = null;
        ScatterAdvancedPanel scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = true;
        }
        alwaysOn = this.getBooleanProperty(this.propListeners, 2051, false);
        restrict = this.getBooleanProperty(this.propListeners, 31, false);
        int sort = this.getIntegerProperty(this.propListeners, 2061, 0);
        this.AlwaysShowCheckBox.setSelected(alwaysOn);
        this.RestrictBrushCheckBox.setSelected(restrict);
        this.PreserveDuplicates.setSelected(sort == 1);
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2053);
        if (o != null && o instanceof Number) {
            e = ((Number)o).intValue();
        }
        switch (e) {
            default: {
                this.SmartRadioBtn.setSelected(true);
                break;
            }
            case 1: {
                this.ColorRadioBtn.setSelected(true);
                break;
            }
            case 2: {
                this.GrowRadioBtn.setSelected(true);
            }
        }
        scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBaseLineSettings() {
        boolean customBaseLine = false;
        boolean baseLineOn = false;
        double slope = Double.NaN;
        double intercept = Double.NaN;
        ScatterAdvancedPanel scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = true;
        }
        baseLineOn = this.getBooleanProperty(this.propListeners, 2067, this.BaseLineCheckBox.isSelected());
        this.BaseLineCheckBox.setSelected(baseLineOn);
        Object o = this.getObjectProperty(this.propListeners, 2065, null);
        int type = Extract.getSourceType((Object)o);
        int n = Extract.getNumberItems((Object)o, (int)type);
        customBaseLine = o != null;
        this.ChartBaseRadioBtn.setSelected(o == null);
        this.CustomBaseRadioBtn.setSelected(o != null);
        this.BaseLineSlope.setEnabled(o != null);
        this.BaseLineIntercept.setEnabled(o != null);
        if (customBaseLine) {
            if (n > 1) {
                slope = Extract.getNumeric((Object)o, (int)0, (int)type);
                intercept = Extract.getNumeric((Object)o, (int)1, (int)type);
            } else {
                intercept = Extract.getNumeric((Object)o, (int)0, (int)type);
            }
        }
        if (!Double.isNaN(slope)) {
            this.BaseLineSlope.setText(Double.toString(slope));
        }
        if (!Double.isNaN(intercept)) {
            this.BaseLineIntercept.setText(Double.toString(intercept));
        }
        scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRegressionSettings() {
        boolean regressionOn = false;
        boolean allNumeric = false;
        ScatterAdvancedPanel scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = true;
        }
        regressionOn = this.getBooleanProperty(this.propListeners, 2046, false);
        allNumeric = !this.getBooleanProperty(this.propListeners, 2049, true) && !this.getBooleanProperty(this.propListeners, 2050, true);
        Color c = this.getColorProperty(this.propListeners, 2047, Color.blue);
        this.RegressionCheckBox.setSelected(regressionOn);
        this.RegressionCheckBox.setEnabled(allNumeric);
        this.RegressionColorLbl.setEnabled(regressionOn && allNumeric);
        this.RegressionColorPanel.setEnabled(regressionOn && allNumeric);
        this.RegressionColorBtn.setEnabled(regressionOn && allNumeric);
        this.RegressionColorPanel.setBackground(c);
        this.RegressionWidthLbl.setEnabled(regressionOn && allNumeric);
        this.RegressionWidthCombo.setEnabled(regressionOn && allNumeric);
        scatterAdvancedPanel = this;
        synchronized (scatterAdvancedPanel) {
            this.internalUpdate = false;
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.updateCoalesceSettings();
            this.updateSelectionSettings();
            this.updateRegressionSettings();
            this.updateBaseLineSettings();
            if (!this.listenersAdded) {
                this.CoalesceCheckBox.addActionListener(this);
                this.CoalesceStatCombo.addActionListener(this);
                this.CoalesceSlider.addChangeListener(this);
                this.AlwaysShowCheckBox.addActionListener(this);
                this.RestrictBrushCheckBox.addActionListener(this);
                this.PreserveDuplicates.addActionListener(this);
                this.SmartRadioBtn.addActionListener(this);
                this.ColorRadioBtn.addActionListener(this);
                this.GrowRadioBtn.addActionListener(this);
                this.RegressionCheckBox.addActionListener(this);
                this.RegressionColorBtn.addActionListener(this);
                this.RegressionWidthCombo.addActionListener(this);
                this.ChartBaseRadioBtn.addActionListener(this);
                this.CustomBaseRadioBtn.addActionListener(this);
                this.BaseLineSlope.addFocusListener(this);
                this.BaseLineIntercept.addFocusListener(this);
                this.BaseLineCheckBox.addActionListener(this);
                this.listenersAdded = true;
            }
        } else if (this.listenersAdded) {
            this.CoalesceCheckBox.removeActionListener(this);
            this.CoalesceStatCombo.removeActionListener(this);
            this.CoalesceSlider.removeChangeListener(this);
            this.AlwaysShowCheckBox.removeActionListener(this);
            this.RestrictBrushCheckBox.removeActionListener(this);
            this.PreserveDuplicates.removeActionListener(this);
            this.SmartRadioBtn.removeActionListener(this);
            this.ColorRadioBtn.removeActionListener(this);
            this.GrowRadioBtn.removeActionListener(this);
            this.RegressionCheckBox.removeActionListener(this);
            this.RegressionColorBtn.removeActionListener(this);
            this.RegressionWidthCombo.removeActionListener(this);
            this.ChartBaseRadioBtn.removeActionListener(this);
            this.CustomBaseRadioBtn.removeActionListener(this);
            this.BaseLineSlope.removeFocusListener(this);
            this.BaseLineIntercept.removeFocusListener(this);
            this.BaseLineCheckBox.removeActionListener(this);
            this.listenersAdded = false;
        }
        super.setVisible(show);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        int enm = -1;
        Object source = e.getSource();
        Color c = null;
        JButton btn = null;
        JComboBox box = null;
        JCheckBox check = null;
        JRadioButton radio = null;
        if (this.internalUpdate) {
            return;
        }
        if (source == null) {
            return;
        }
        if (source instanceof JButton) {
            btn = (JButton)source;
            if (btn != this.RegressionColorBtn || (c = this.showColorChooserDialog(this.getColorProperty(this.propListeners, 2047, this.RegressionColorPanel.getBackground()))) == null) return;
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2047, (Object)c);
            this.RegressionColorPanel.setBackground(c);
            return;
        } else if (source instanceof JComboBox) {
            box = (JComboBox)source;
            Object obj = box.getSelectedItem();
            if (obj == null) {
                return;
            }
            if (box.equals(this.CoalesceStatCombo)) {
                switch (box.getSelectedIndex()) {
                    default: {
                        enm = 1;
                        break;
                    }
                    case 1: {
                        enm = 2;
                        break;
                    }
                    case 2: {
                        enm = 3;
                    }
                }
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2041, (Object)new Integer(enm));
                this.updateCoalesceSettings();
                return;
            } else {
                if (box != this.RegressionWidthCombo) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2048, (Object)new Integer(box.getSelectedIndex() + 1));
            }
            return;
        } else if (source instanceof JCheckBox) {
            check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.CoalesceCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2038, (Object)new Boolean(status));
                this.updateCoalesceSettings();
                return;
            } else if (check.equals(this.AlwaysShowCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2051, (Object)new Boolean(status));
                this.updateSelectionSettings();
                return;
            } else if (check.equals(this.RestrictBrushCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)31, (Object)new Boolean(status));
                this.updateSelectionSettings();
                return;
            } else if (check.equals(this.PreserveDuplicates)) {
                Integer obj = status ? new Integer(1) : new Integer(0);
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2061, (Object)obj);
                this.updateSelectionSettings();
                return;
            } else if (check.equals(this.RegressionCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2046, (Object)new Boolean(status));
                this.updateRegressionSettings();
                return;
            } else {
                if (!check.equals(this.BaseLineCheckBox)) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2066, (Object)new Boolean(status));
                this.updateBaseLineSettings();
            }
            return;
        } else {
            if (!(source instanceof JRadioButton)) return;
            radio = (JRadioButton)source;
            boolean status = radio.isSelected();
            if (radio == this.SmartRadioBtn && status) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2053, (Object)new Integer(0));
                this.updateSelectionSettings();
                return;
            } else if (radio == this.ColorRadioBtn && status) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2053, (Object)new Integer(1));
                this.updateSelectionSettings();
                return;
            } else if (radio == this.GrowRadioBtn && status) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2053, (Object)new Integer(2));
                this.updateSelectionSettings();
                return;
            } else if (radio == this.ChartBaseRadioBtn && status) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2065, null);
                this.updateBaseLineSettings();
                return;
            } else {
                if (radio != this.CustomBaseRadioBtn || !status) return;
                this.setCustomBaseLine();
                this.updateBaseLineSettings();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate) {
            return;
        }
        if (source == this.CoalesceSlider) {
            int min = this.CoalesceSlider.getMinimum();
            int max = this.CoalesceSlider.getMaximum();
            int v = this.CoalesceSlider.getValue();
            double range = this.getNumericProperty(this.propListeners, 2042, 1.0);
            Double d = new Double(0.5 * ((double)(v - min) / (double)(max - min)) * range);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2039, (Object)d);
        }
    }

    @Override
    public boolean applyChanges() {
        if (this.slopeTextOnEnter != null || this.interceptTextOnEnter != null) {
            this.setCustomBaseLine();
        }
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.BaseLineSlope) {
            this.slopeTextOnEnter = this.BaseLineSlope.getText();
        } else if (source == this.BaseLineIntercept) {
            this.interceptTextOnEnter = this.BaseLineIntercept.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        String s;
        Object source = e.getSource();
        if (source == this.BaseLineSlope && this.slopeTextOnEnter != null && (s = this.BaseLineSlope.getText()) != null) {
            if (s.equals(this.slopeTextOnEnter)) {
                this.slopeTextOnEnter = null;
            }
        } else if (source == this.BaseLineIntercept && this.interceptTextOnEnter != null && (s = this.BaseLineIntercept.getText()) != null && s.equals(this.interceptTextOnEnter)) {
            this.interceptTextOnEnter = null;
        }
    }
}

