/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.ui.MyJButton;
import com.sas.graphics.silk.ui.MyJToggleButton;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JToolBar;

public class SILKToolbar
extends JToolBar
implements ActionListener,
GraphToolbarInterface {
    private static final long serialVersionUID = 7054125513006455680L;
    Dialog dialog = null;
    MyJToggleButton brush = null;
    MyJToggleButton viewport = null;
    MyJToggleButton zoom = null;
    MyJToggleButton pan = null;
    MyJToggleButton select = null;
    MyJButton reset = null;
    Vector listeners = new Vector();
    public static final int TOOLBAR_BUTTON_SELECT = 0;
    public static final int TOOLBAR_BUTTON_BRUSH = 1;
    public static final int TOOLBAR_BUTTON_VIEWPORT = 2;
    public static final int TOOLBAR_BUTTON_ZOOM = 3;
    public static final int TOOLBAR_BUTTON_PAN = 4;
    public static final int TOOLBAR_BUTTON_RESET = 5;
    private boolean useSelect = true;
    private boolean useBrush = true;
    private boolean useViewport = true;
    private boolean useZoom = true;
    private boolean usePan = true;
    private boolean useReset = true;
    private Vector userComponents = new Vector();
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    Frame parent = null;
    String title = null;
    String resourceLoc = "icons/";

    public SILKToolbar(Frame parent) {
        this.parent = parent;
        this.title = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Graph_Toolbar.txt", (String)"Graph Toolbar");
        this.setRollover(true);
        this.setFloatable(false);
        this.select = new MyJToggleButton(this.loadImageIcon("tpselect.gif"));
        this.select.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Select.txt", (String)"Select"));
        this.select.addActionListener(this);
        this.select.setPreferredSize(new Dimension(26, 26));
        this.brush = new MyJToggleButton(this.loadImageIcon("movenode.gif"));
        this.brush.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Brush.txt", (String)"Brush"));
        this.brush.addActionListener(this);
        this.brush.setPreferredSize(new Dimension(26, 26));
        this.viewport = new MyJToggleButton(this.loadImageIcon("drawrect.gif"));
        this.viewport.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Viewport.txt", (String)"Viewport"));
        this.viewport.addActionListener(this);
        this.viewport.setPreferredSize(new Dimension(26, 26));
        this.zoom = new MyJToggleButton(this.loadImageIcon("tpfocus.gif"));
        this.zoom.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Zoom.txt", (String)"Zoom"));
        this.zoom.addActionListener(this);
        this.zoom.setPreferredSize(new Dimension(26, 26));
        this.pan = new MyJToggleButton(this.loadImageIcon("tpmove.gif"));
        this.pan.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Pan.txt", (String)"Pan"));
        this.pan.addActionListener(this);
        this.pan.setPreferredSize(new Dimension(26, 26));
        this.reset = new MyJButton(this.loadImageIcon("resetcub.gif"));
        this.reset.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKToolbar.Reset.txt", (String)"Reset"));
        this.reset.addActionListener(this);
        this.reset.setPreferredSize(new Dimension(26, 26));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.select);
        bg.add(this.brush);
        bg.add(this.viewport);
        bg.add(this.zoom);
        bg.add(this.pan);
        this.setupButtons();
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void setupButtons() {
        this.removeAll();
        this.add(this.select);
        this.add(this.brush);
        this.add(this.viewport);
        this.add(this.zoom);
        this.add(this.pan);
        this.select.setEnabled(this.useSelect);
        this.brush.setEnabled(this.useBrush);
        this.viewport.setEnabled(this.useViewport);
        this.zoom.setEnabled(this.useZoom);
        this.pan.setEnabled(this.usePan);
        this.addSeparator();
        this.add(this.reset);
        this.reset.setEnabled(this.useReset);
        this.addSeparator();
        for (int i = 0; i < this.userComponents.size(); ++i) {
            this.add((JComponent)this.userComponents.elementAt(i));
        }
        this.dialog = new JDialog(this.parent);
        this.dialog.setTitle(this.title);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.title);
        this.dialog.setSize((int)((double)this.getPreferredSize().width * 1.35), (int)((double)this.getPreferredSize().height * 2.35));
        ((JDialog)this.dialog).getContentPane().setLayout(new BorderLayout());
        ((JDialog)this.dialog).getContentPane().add("Center", this);
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog d) {
        if (d != null) {
            this.dialog = d;
        }
    }

    public void setTitle(String t) {
        this.title = t;
        this.dialog.setTitle(this.title);
    }

    public boolean setButtonEnabled(int button, boolean enable) {
        boolean rc = true;
        switch (button) {
            case 1: {
                this.useBrush = enable;
                break;
            }
            case 4: {
                this.usePan = enable;
                break;
            }
            case 5: {
                this.useReset = enable;
                break;
            }
            case 0: {
                this.useSelect = enable;
                break;
            }
            case 2: {
                this.useViewport = enable;
                break;
            }
            case 3: {
                this.useZoom = enable;
                break;
            }
            default: {
                rc = false;
            }
        }
        if (rc) {
            this.setupButtons();
        }
        return rc;
    }

    public boolean addUserTool(JComponent component) {
        if (component == null || this.userComponents.contains(component)) {
            return false;
        }
        this.userComponents.addElement(component);
        this.setupButtons();
        return true;
    }

    public boolean removeUserTool(JComponent component) {
        if (component != null || !this.userComponents.contains(component)) {
            return false;
        }
        this.userComponents.remove(component);
        this.setupButtons();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int action = -1;
        Object source = e.getSource();
        action = source == this.brush ? 1 : (source == this.viewport ? 2 : (source == this.zoom ? 3 : (source == this.pan ? 4 : (source == this.select ? 6 : (source == this.reset ? 5 : 0)))));
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphInterface)this.listeners.elementAt(i)).setActionMode(action);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.dialog.setVisible(b);
        if (!b) {
            this.dialog.dispose();
        }
    }

    public ImageIcon loadImageIcon(String name) {
        Image image = this.loadImage(name);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public Image loadImage(String name) {
        try {
            String resourceName = this.resourceLoc + name;
            Image image = ResourceLoader.getImage((Component)this, (String)resourceName);
            if (image != null) {
                return image;
            }
            return null;
        }
        catch (AWTError ae) {
            System.out.println("AWT Error: " + ae.toString());
            return null;
        }
    }

    @Override
    public void addListener(GraphInterface l) {
        if (this.listeners.isEmpty()) {
            switch (l.getActionMode()) {
                case 0: 
                case 1: {
                    this.brush.setSelected(true);
                    break;
                }
                case 2: {
                    this.viewport.setSelected(true);
                    break;
                }
                case 3: {
                    this.zoom.setSelected(true);
                    break;
                }
                case 4: {
                    this.pan.setSelected(true);
                    break;
                }
                case 5: {
                    this.brush.setSelected(true);
                    break;
                }
                case 6: {
                    this.select.setSelected(true);
                }
            }
        }
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    @Override
    public void removeListener(GraphInterface l) {
        this.listeners.remove(l);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }
}

