/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class RoleSelector
extends JPanel
implements ItemListener,
ActionListener,
MouseListener,
RoleListenerInterface {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JComboBox jComboBox = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel5 = null;
    private JPanel jPanel6 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JPanel jPanel7 = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private JList jList = null;
    private JList jList1 = null;
    private ResourceBundle rb = null;
    private RoleInterface chart = null;
    private JComponent component = null;
    private Object dataId = null;

    public RoleSelector() {
        this.initialize();
    }

    public RoleSelector(RoleInterface chart, JComponent component) {
        this.initialize();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.chart = chart;
        chart.addRoleListener(this);
        this.component = component;
        if (chart != null) {
            Object[] list;
            Object[] dataIds = chart.getDataIds();
            if (dataIds != null) {
                for (int id = 0; id < dataIds.length; ++id) {
                    if (chart.getDataSource(dataIds[id]) == null) continue;
                    this.dataId = dataIds[id];
                    break;
                }
            }
            if ((list = chart.getSupportedRoles(this.dataId, true)) != null) {
                for (int i = 0; i < list.length; ++i) {
                    this.getJComboBox().addItem(list[i]);
                }
                this.getJComboBox().addItemListener(this);
                this.updateVarLists();
                this.getJButton().addActionListener(this);
                this.getJButton1().addActionListener(this);
                this.getJList().addMouseListener(this);
                this.getJList1().addMouseListener(this);
            }
        }
    }

    private boolean requiresContinuousVar(Object role) {
        Object[] list = this.chart.getSupportedRoles(this.dataId, false);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!role.equals(list[i])) continue;
            return true;
        }
        return false;
    }

    private void updateVarLists() {
        int i;
        this.getJList().removeAll();
        this.getJList1().removeAll();
        Object src = this.dataId == null ? this.chart.getDataSource() : this.chart.getDataSource(this.dataId);
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)src);
        if (dfri == null) {
            return;
        }
        Vector<Object> vars = new Vector<Object>();
        if (this.requiresContinuousVar(this.getJComboBox().getSelectedItem())) {
            for (i = 0; i < dfri.getNumberVariables(); ++i) {
                if (!dfri.isNumericVariable(i)) continue;
                vars.addElement(dfri.getVariableId(i));
            }
        } else {
            for (i = 0; i < dfri.getNumberVariables(); ++i) {
                vars.addElement(dfri.getVariableId(i));
            }
        }
        FilterFactory.detachFilter((DataFilterReadInterface)dfri);
        Vector v = new Vector();
        Enumeration e = Extract.elements((Object)this.chart.getAllVariables(this.getJComboBox().getSelectedItem()));
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            v.addElement(o);
            vars.remove(o);
        }
        this.getJList1().setListData(v);
        this.getJList().setListData(vars);
        int max = this.chart.getMaxAllowed(this.getJComboBox().getSelectedItem());
        if (v.size() == max) {
            this.getJButton().setEnabled(false);
        } else {
            this.getJButton().setEnabled(true);
        }
        if (v.isEmpty()) {
            this.getJButton1().setEnabled(false);
        } else {
            this.getJButton1().setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateVarLists();
    }

    public void setDataId(Object id) {
        this.dataId = id;
        Object[] list = this.chart.getSupportedRoles(this.dataId, true);
        if (list != null) {
            this.getJComboBox().removeItemListener(this);
            this.getJComboBox().removeAllItems();
            int i = 0;
            while (i < list.length) {
                this.getJComboBox().addItem(list[i++]);
            }
            this.getJComboBox().addItemListener(this);
        }
        this.updateVarLists();
    }

    private void initialize() {
        this.setSize(543, 355);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJPanel(), "North");
        this.add((Component)this.getJPanel1(), "Center");
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setFont(UIUtilities.getSILKDialogFont());
            this.jLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.Roles.txt", (String)"Roles:"));
            this.jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jPanel.add((Component)this.jLabel, "West");
            this.jPanel.add((Component)this.getJComboBox(), "Center");
        }
        return this.jPanel;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setFont(UIUtilities.getSILKDialogFont());
            this.jComboBox.setBackground(Color.white);
        }
        return this.jComboBox;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BoxLayout(this.getJPanel1(), 0));
            this.jPanel1.add((Component)this.getJPanel2(), null);
            this.jPanel1.add((Component)this.getJPanel3(), null);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setFont(UIUtilities.getSILKDialogFont());
            this.jLabel2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.AvailableVars.txt", (String)"Available Variables"));
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.add((Component)this.jLabel2, "North");
            this.jPanel2.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new BorderLayout());
            this.jPanel3.add((Component)this.getJPanel4(), "West");
            this.jPanel3.add((Component)this.getJPanel7(), "Center");
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.getJPanel5(), new GridBagConstraints());
        }
        return this.jPanel4;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new FlowLayout());
            this.jPanel5.add((Component)this.getJPanel6(), null);
        }
        return this.jPanel5;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new BoxLayout(this.getJPanel6(), 1));
            this.jPanel6.add((Component)this.getJButton(), null);
            this.jPanel6.add((Component)this.getJButton1(), null);
        }
        return this.jPanel6;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.AssignVar.txt", (String)">"));
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.UnassignVar.txt", (String)"<"));
        }
        return this.jButton1;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setFont(UIUtilities.getSILKDialogFont());
            this.jLabel1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.AssignedVars.txt", (String)"Assigned Variables"));
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new BorderLayout());
            this.jPanel7.add((Component)this.jLabel1, "North");
            this.jPanel7.add((Component)this.getJScrollPane1(), "Center");
        }
        return this.jPanel7;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJList1());
        }
        return this.jScrollPane1;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setFont(UIUtilities.getSILKDialogFont());
        }
        return this.jList;
    }

    private JList getJList1() {
        if (this.jList1 == null) {
            this.jList1 = new JList();
            this.jList1.setFont(UIUtilities.getSILKDialogFont());
        }
        return this.jList1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.getJButton() && this.getJList().getSelectedValue() != null) {
            Object[] vars = this.getJList().getSelectedValues();
            boolean rc = true;
            for (int i = 0; i < vars.length; ++i) {
                rc &= this.chart.addRole(vars[i], this.getJComboBox().getSelectedItem());
            }
            if (!rc) {
                JOptionPane.showMessageDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.addRole_Failed.txt", (String)"Role assignment failed"), "", 0);
            }
        } else if (source == this.getJButton1() && this.getJList1().getSelectedValue() != null) {
            Object[] vars = this.getJList1().getSelectedValues();
            boolean rc = true;
            for (int i = 0; i < vars.length; ++i) {
                rc &= this.chart.removeRole(vars[i], this.getJComboBox().getSelectedItem());
            }
            if (!rc) {
                JOptionPane.showMessageDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.addRole_Failed.txt", (String)"Role assignment failed"), "", 0);
            }
        }
        if (this.component != null) {
            this.component.repaint();
        }
        this.updateVarLists();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.getJList() && e.getClickCount() == 2) {
            boolean rc;
            int index = this.getJList().locationToIndex(e.getPoint());
            ListModel dlm = this.getJList().getModel();
            Object item = dlm.getElementAt(index);
            if (this.getJButton().isEnabled() && !(rc = this.chart.addRole(item, this.getJComboBox().getSelectedItem()))) {
                JOptionPane.showMessageDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.addRole_Failed.txt", (String)"Role assignment failed"), "", 0);
            }
            if (this.component != null) {
                this.component.repaint();
            }
            this.updateVarLists();
        } else if (e.getSource() == this.getJList1() && e.getClickCount() == 2) {
            boolean rc;
            int index = this.getJList1().locationToIndex(e.getPoint());
            ListModel dlm = this.getJList1().getModel();
            Object item = dlm.getElementAt(index);
            if (this.getJButton1().isEnabled() && !(rc = this.chart.removeRole(item, this.getJComboBox().getSelectedItem()))) {
                JOptionPane.showMessageDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelector.addRole_Failed.txt", (String)"Role assignment failed"), "", 0);
            }
            if (this.component != null) {
                this.component.repaint();
            }
            this.updateVarLists();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void roleChanged(RoleEvent e) {
        Object selectedItem = this.getJComboBox().getSelectedItem();
        Object[] list = this.chart.getSupportedRoles(this.dataId, true);
        this.getJComboBox().removeItemListener(this);
        this.getJComboBox().removeAllItems();
        for (int i = 0; i < list.length; ++i) {
            this.getJComboBox().addItem(list[i]);
        }
        this.getJComboBox().setSelectedItem(selectedItem);
        this.getJComboBox().addItemListener(this);
        this.updateVarLists();
    }
}

