/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.AddRangeDialog;
import com.sas.graphics.silk.ui.RangeEditDialog;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RangeModelDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 6161835394437736428L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton addButton = null;
    private JButton deleteButton = null;
    private JButton okButton = null;
    private JButton editButton = null;
    private JPanel rangeModelPanel = null;
    private JLabel rangeLabel = null;
    private JList valueList = null;
    private DefaultListModel valueListModel = null;
    private JList rangeList = null;
    private DefaultListModel rangeListModel = null;
    private MessageFormat rangeMessage = null;
    private RangeModel rangeModel = null;
    private SASFormat valueFormat = null;
    private boolean enableRangeEdit = true;
    private AddRangeDialog addDialog = null;
    private RangeEditDialog editDialog = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public RangeModelDialog(Frame parent) {
        super(parent);
        this.initialize();
    }

    public RangeModelDialog(Dialog parent) {
        super(parent);
        this.initialize();
    }

    public void setRangeModel(RangeModel rm) {
        this.rangeModel = rm;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setValueFormat(SASFormat fmt) {
        this.valueFormat = fmt;
    }

    public SASFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setEnableRangeEdit(boolean b) {
        this.enableRangeEdit = b;
    }

    public boolean getEnableRangeEdit() {
        return this.enableRangeEdit;
    }

    private void initialize() {
        this.setModal(true);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.ReferenceValues.txt", (String)"Reference Values"));
        this.rangeMessage = new MessageFormat(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.RangeMessage.fmt", (String)"{0} to {1}"));
        this.valueListModel = new DefaultListModel();
        this.rangeListModel = new DefaultListModel();
        this.addDialog = new AddRangeDialog(this);
        UIUtilities.center(this.addDialog);
        this.editDialog = new RangeEditDialog(this);
        UIUtilities.center(this.editDialog);
        this.setBounds(new Rectangle(0, 0, 400, 300));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout(10, 10));
            this.jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getRangeModelPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout(5, 5));
            JPanel gridPanel = new JPanel(new GridLayout(0, 4, 5, 5));
            gridPanel.add(this.getOkButton());
            gridPanel.add(this.getAddButton());
            gridPanel.add(this.getEditButton());
            gridPanel.add(this.getDeleteButton());
            this.buttonPanel.add((Component)gridPanel, "East");
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.addButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.Add.txt", (String)"Add"));
            this.addButton.addActionListener(this);
        }
        return this.addButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.editButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.Edit.txt", (String)"Edit"));
            this.editButton.addActionListener(this);
        }
        return this.editButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.deleteButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.Delete.txt", (String)"Delete"));
            this.deleteButton.addActionListener(this);
        }
        return this.deleteButton;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.okButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.OK.txt", (String)"OK"));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JPanel getRangeModelPanel() {
        if (this.rangeModelPanel == null) {
            this.rangeModelPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            JPanel valuePanel = new JPanel(new BorderLayout(5, 5));
            valuePanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
            JLabel valueLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.Values.txt", (String)"Values:"));
            valueLabel.setFont(TabbedPropertiesDialog.dialogFont);
            valuePanel.add((Component)valueLabel, "North");
            valuePanel.add((Component)new JScrollPane(this.getValueList()), "Center");
            JPanel rangePanel = new JPanel(new BorderLayout(5, 5));
            rangePanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
            this.rangeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeModelDialog.Ranges.txt", (String)"Ranges:"));
            this.rangeLabel.setFont(TabbedPropertiesDialog.dialogFont);
            rangePanel.add((Component)this.rangeLabel, "North");
            rangePanel.add((Component)new JScrollPane(this.getRangeList()), "Center");
            this.rangeModelPanel.add(valuePanel);
            this.rangeModelPanel.add(rangePanel);
        }
        return this.rangeModelPanel;
    }

    private JList getValueList() {
        if (this.valueList == null) {
            this.valueList = new JList();
            this.valueList.setModel(this.valueListModel);
            this.valueList.setCellRenderer(new MyCellRenderer());
            this.valueList.addMouseListener(new MyMouseListener());
            this.valueList.addListSelectionListener(this);
        }
        return this.valueList;
    }

    private JList getRangeList() {
        if (this.rangeList == null) {
            this.rangeList = new JList();
            this.rangeList.setModel(this.rangeListModel);
            this.rangeList.setCellRenderer(new MyCellRenderer());
            this.rangeList.addMouseListener(new MyMouseListener());
            this.rangeList.addListSelectionListener(this);
        }
        return this.rangeList;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initGUI();
            if (this.rangeModel != null) {
                this.rangeModel.addPropertyChangeListener(this);
            }
        } else if (this.rangeModel != null) {
            this.rangeModel.removePropertyChangeListener(this);
        }
        super.setVisible(b);
    }

    private void initGUI() {
        this.valueListModel.removeAllElements();
        this.rangeListModel.removeAllElements();
        if (this.rangeModel != null) {
            int numRanges = this.rangeModel.ranges();
            for (int i = 0; i < numRanges; ++i) {
                ReferenceRange rr = this.rangeModel.getRangeAt(i);
                Object lowValue = rr.getLowValue();
                Object highValue = rr.getHighValue();
                if (!(lowValue instanceof Number) || !(highValue instanceof Number)) continue;
                if (((Number)lowValue).doubleValue() > ((Number)highValue).doubleValue()) {
                    this.valueListModel.addElement(rr);
                    continue;
                }
                this.rangeListModel.addElement(rr);
            }
        }
        this.rangeList.setEnabled(this.enableRangeEdit);
        if (this.enableRangeEdit) {
            this.rangeList.setBackground(Color.WHITE);
            this.rangeLabel.setEnabled(true);
        } else {
            this.rangeList.setBackground(Color.LIGHT_GRAY);
            this.rangeLabel.setEnabled(false);
        }
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addDialog.setRangeModel(this.rangeModel);
            this.addDialog.setEnableRangeEdit(this.enableRangeEdit);
            this.addDialog.setVisible(true);
        } else if (e.getSource() == this.deleteButton) {
            this.deleteSelections(this.valueList, this.valueListModel);
            this.deleteSelections(this.rangeList, this.rangeListModel);
        } else if (e.getSource() == this.okButton) {
            this.setVisible(false);
        } else if (e.getSource() == this.editButton) {
            this.editSelection();
        }
    }

    private void deleteSelections(JList list, DefaultListModel model) {
        if (this.rangeModel == null) {
            return;
        }
        Object[] selected = list.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            this.rangeModel.remove((ReferenceRange)selected[i]);
            model.removeElement(selected[i]);
        }
    }

    private void editSelection() {
        ReferenceRange editRange = null;
        editRange = (ReferenceRange)this.valueList.getSelectedValue();
        if (editRange != null) {
            this.editDialog.setEnableRangeEdit(false);
        } else {
            editRange = (ReferenceRange)this.rangeList.getSelectedValue();
            if (editRange != null) {
                this.editDialog.setEnableRangeEdit(true);
            } else {
                return;
            }
        }
        this.editDialog.setRange(editRange);
        this.editDialog.setValueFormat(this.valueFormat);
        this.editDialog.setVisible(true);
        this.valueList.repaint();
        this.rangeList.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object o;
        if (evt.getSource() != this.rangeModel) {
            return;
        }
        String propName = evt.getPropertyName();
        if (propName.equalsIgnoreCase("addRange") && (o = evt.getNewValue()) instanceof Object[] && ((Object[])o).length > 0) {
            ReferenceRange rr = (ReferenceRange)((Object[])o)[0];
            Object lowValue = rr.getLowValue();
            Object highValue = rr.getHighValue();
            if (lowValue instanceof Number && highValue instanceof Number) {
                if (((Number)lowValue).doubleValue() > ((Number)highValue).doubleValue()) {
                    this.valueListModel.addElement(rr);
                } else {
                    this.rangeListModel.addElement(rr);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object[] selValues = this.valueList.getSelectedValues();
        Object[] selRanges = this.rangeList.getSelectedValues();
        boolean enableDelete = false;
        boolean enableEdit = false;
        if (selValues != null && selValues.length > 0) {
            enableDelete = true;
            if (selValues.length == 1) {
                enableEdit = true;
            }
        } else if (selRanges != null && selRanges.length > 0) {
            enableDelete = true;
            if (selRanges.length == 1) {
                enableEdit = true;
            }
        }
        this.deleteButton.setEnabled(enableDelete);
        this.editButton.setEnabled(enableEdit);
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 2589355849002592073L;

        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ReferenceRange) {
                Object lowValue = ((ReferenceRange)value).getLowValue();
                Object highValue = ((ReferenceRange)value).getHighValue();
                if (lowValue instanceof Number && highValue instanceof Number) {
                    if (((Number)lowValue).doubleValue() > ((Number)highValue).doubleValue()) {
                        String val = RangeModelDialog.this.valueFormat != null ? RangeModelDialog.this.valueFormat.format(lowValue) : lowValue.toString();
                        this.setText(val);
                    } else {
                        String highVal;
                        String lowVal;
                        if (RangeModelDialog.this.valueFormat != null) {
                            lowVal = RangeModelDialog.this.valueFormat.format(lowValue);
                            highVal = RangeModelDialog.this.valueFormat.format(highValue);
                        } else {
                            lowVal = lowValue.toString();
                            highVal = highValue.toString();
                        }
                        this.setText(RangeModelDialog.this.rangeMessage.format(new Object[]{lowVal, highVal}));
                    }
                }
            } else {
                this.setText(value.toString());
            }
            this.setOpaque(true);
            this.setFont(TabbedPropertiesDialog.dialogFont);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            if (!this.isEnabled()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
            return this;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == RangeModelDialog.this.valueList) {
                RangeModelDialog.this.rangeList.clearSelection();
            } else if (e.getSource() == RangeModelDialog.this.rangeList) {
                RangeModelDialog.this.valueList.clearSelection();
            }
        }
    }
}

