/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RangeEditDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6399884706824956430L;
    private ReferenceRange range = null;
    private SASFormat valueFormat = null;
    private boolean enableRangeEdit = true;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel editPanel = null;
    private JLabel valueLabel = null;
    private JLabel toLabel = null;
    private JTextField lowValueField = null;
    private JTextField highValueField = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public RangeEditDialog(Frame parent) {
        super(parent);
        this.initialize();
    }

    public RangeEditDialog(Dialog parent) {
        super(parent);
        this.initialize();
    }

    public void setRange(ReferenceRange r) {
        this.range = r;
    }

    public ReferenceRange getRange() {
        return this.range;
    }

    public void setEnableRangeEdit(boolean b) {
        this.enableRangeEdit = b;
    }

    public boolean getEnableRangeEdit() {
        return this.enableRangeEdit;
    }

    public void setValueFormat(SASFormat fmt) {
        this.valueFormat = fmt;
    }

    public SASFormat getValueFormat() {
        return this.valueFormat;
    }

    private void initialize() {
        this.setModal(true);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.EditReferenceValue.txt", (String)"Edit Reference Value"));
        this.setBounds(new Rectangle(0, 0, 200, 170));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout(5, 5));
            this.jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getEditPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel(new BorderLayout(5, 5));
            this.editPanel.add((Component)this.getLeftPanel(), "West");
            this.editPanel.add((Component)this.getRightPanel(), "Center");
        }
        return this.editPanel;
    }

    private JPanel getLeftPanel() {
        JPanel leftPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        leftPanel.add(this.getValueLabel());
        return leftPanel;
    }

    private JLabel getValueLabel() {
        if (this.valueLabel == null) {
            this.valueLabel = new JLabel();
            this.valueLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.valueLabel.setHorizontalAlignment(2);
            this.valueLabel.setVerticalAlignment(0);
        }
        return this.valueLabel;
    }

    private JPanel getRightPanel() {
        JPanel rightPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        rightPanel.add(this.getLowValueField());
        rightPanel.add(this.getToLabel());
        rightPanel.add(this.getHighValueField());
        return rightPanel;
    }

    private JLabel getToLabel() {
        if (this.toLabel == null) {
            this.toLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.To.txt", (String)"to"));
            this.toLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.toLabel.setHorizontalAlignment(2);
            this.toLabel.setVerticalAlignment(0);
        }
        return this.toLabel;
    }

    private JTextField getLowValueField() {
        if (this.lowValueField == null) {
            this.lowValueField = new JTextField();
            this.lowValueField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.lowValueField;
    }

    private JTextField getHighValueField() {
        if (this.highValueField == null) {
            this.highValueField = new JTextField();
            this.highValueField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.highValueField;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout(5, 5));
            JPanel gridPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            gridPanel.add(this.getOkButton());
            gridPanel.add(this.getCancelButton());
            this.buttonPanel.add((Component)gridPanel, "East");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.okButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.OK.txt", (String)"OK"));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.Cancel.txt", (String)"Cancel"));
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initGUI();
        }
        super.setVisible(b);
    }

    private void initGUI() {
        if (this.range != null) {
            String highVal;
            String lowVal;
            Object lowValue = this.range.getLowValue();
            Object highValue = this.range.getHighValue();
            if (this.valueFormat != null) {
                lowVal = this.valueFormat.format(lowValue);
                highVal = this.valueFormat.format(highValue);
            } else {
                lowVal = lowValue.toString();
                highVal = highValue.toString();
            }
            this.lowValueField.setText(lowVal);
            this.highValueField.setText(highVal);
        }
        if (this.enableRangeEdit) {
            this.toLabel.setVisible(true);
            this.highValueField.setVisible(true);
            this.valueLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.RangeLabel.txt", (String)"Range:"));
        } else {
            this.toLabel.setVisible(false);
            this.highValueField.setVisible(false);
            this.valueLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.ValueLabel.txt", (String)"Value:"));
        }
    }

    private boolean editReferenceRange() {
        if (this.range == null) {
            return true;
        }
        Double low = this.parseTextField(this.lowValueField);
        Double high = this.parseTextField(this.highValueField);
        if (this.enableRangeEdit) {
            if (low != null && high != null && low < high) {
                this.range.setLowValue(low);
                this.range.setHighValue(high);
                return true;
            }
            return false;
        }
        if (low != null) {
            this.range.setHighValue(new Double(low - 1.0));
            this.range.setLowValue(low);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.editReferenceRange()) {
                this.setVisible(false);
            } else {
                this.showErrorDialog();
                this.lowValueField.setText("");
                this.highValueField.setText("");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    private void showErrorDialog() {
        String errorTitle = ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.ErrorTitle.txt", (String)"Error");
        String errorMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"RangeEditDialog.ErrorMessage.txt", (String)"Invalid Input");
        JOptionPane.showMessageDialog(this, errorMsg, errorTitle, 0);
    }

    private Double parseTextField(JTextField textField) {
        String s = textField.getText();
        if (s == null) {
            return null;
        }
        Number n = null;
        Double d = null;
        NumberFormat format = NumberFormat.getNumberInstance();
        try {
            n = format.parse(s);
            d = new Double(n.doubleValue());
        }
        catch (ParseException e) {
            d = null;
        }
        return d;
    }
}

