/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TextDialog;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class PreviewPanel
extends JPanel {
    private static final long serialVersionUID = -1408170080578031660L;
    TextDialog textDialog;

    public PreviewPanel(TextDialog dialog) {
        this.textDialog = dialog;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Font font = this.textDialog.fontPanel.getFont();
        g.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D d = font.getStringBounds(font.getName(), frc);
        if (this.textDialog.effectsPanel.shadowsOn.isSelected()) {
            Color color = this.textDialog.effectsPanel.shadowColor.getBackground();
            double a = (double)this.textDialog.effectsPanel.shadowSlider.getValue() / 100.0;
            int alpha = (int)(a * 255.0);
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            g2.drawString(font.getName(), this.getWidth() / 2 - (int)(d.getWidth() / 2.0) + 2, this.getHeight() / 2 + (int)(d.getHeight() / 4.0) + 2);
        }
        int transparency = (int)(255.0 * ((double)this.textDialog.effectsPanel.transSlider.getValue() / 100.0));
        Color clr = this.textDialog.colorPanel.getColor();
        g.setColor(new Color(clr.getRed(), clr.getGreen(), clr.getBlue(), transparency));
        g2.drawString(font.getName(), this.getWidth() / 2 - (int)(d.getWidth() / 2.0), this.getHeight() / 2 + (int)(d.getHeight() / 4.0));
        if (this.textDialog.effectsPanel.underline.isSelected()) {
            g2.drawLine(this.getWidth() / 2 - (int)(d.getWidth() / 2.0), this.getHeight() / 2 + (int)(d.getHeight() / 4.0), this.getWidth() / 2 + (int)(d.getWidth() / 2.0), this.getHeight() / 2 + (int)(d.getHeight() / 4.0));
        }
        if (this.textDialog.effectsPanel.strikethru.isSelected()) {
            g2.drawLine(this.getWidth() / 2 - (int)(d.getWidth() / 2.0), this.getHeight() / 2, this.getWidth() / 2 + (int)(d.getWidth() / 2.0), this.getHeight() / 2);
        }
        g2.setColor(Color.black);
        g2.drawLine(0, this.getHeight() / 2 + (int)(d.getHeight() / 4.0), this.getWidth() / 2 - (int)d.getWidth(), this.getHeight() / 2 + (int)(d.getHeight() / 4.0));
        g2.drawLine(this.getWidth() / 2 + (int)d.getWidth(), this.getHeight() / 2 + (int)(d.getHeight() / 4.0), this.getWidth(), this.getHeight() / 2 + (int)(d.getHeight() / 4.0));
    }
}

