/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PiePanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = -7637744872062751567L;
    Vector listeners = new Vector();
    TextDialog textDialog = null;
    JComboBox nameCombo = null;
    JComboBox dataCombo = null;
    JComboBox percentCombo = null;
    JComboBox labelSchemeCombo = null;
    JButton fontButton = null;
    JCheckBox outlineCheck = null;
    JCheckBox otherCheck = null;
    JSpinner otherPercentSpin = null;
    JSpinner otherMaxSlicesSpin = null;
    JComboBox thicknessCombo = null;
    JCheckBox groupLabelsCheck = null;
    JRadioButton bPercent = null;
    JRadioButton bMaxSlices = null;
    JLabel percentage = null;
    JLabel maxSlices = null;
    JTextField otherLabelText = null;
    JLabel otherLabel = null;
    JLabel labelScheme = null;
    protected JColorChooser colorChooser;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    String NONE = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.None.txt", (String)"None");
    String INSIDE = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Inside.txt", (String)"Inside");
    String OUTSIDE = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Outside.txt", (String)"Outside");
    String ARROW = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Arrow.txt", (String)"Arrow");
    String DEFAULT = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Label_Scheme_Default.txt", (String)"Default");
    String RADIAL = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Label_Scheme_Radial.txt", (String)"Radial");
    String MARGIN = ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Label_Scheme_Margin.txt", (String)"Margin");

    public PiePanel(PropertyInterface pie) {
        this.addPropertyListener(pie);
        JComponent component = null;
        if (pie instanceof JComponent) {
            component = (JComponent)pie;
        }
        this.textDialog = new TextDialog((Frame)null, component);
        this.initGUI();
        this.nameCombo.addActionListener(this);
        this.dataCombo.addActionListener(this);
        this.percentCombo.addActionListener(this);
        this.labelSchemeCombo.addActionListener(this);
        this.fontButton.addActionListener(this);
        this.outlineCheck.addActionListener(this);
        this.otherCheck.addActionListener(this);
        this.bPercent.addActionListener(this);
        this.bMaxSlices.addActionListener(this);
        this.otherPercentSpin.addChangeListener(this);
        this.otherMaxSlicesSpin.addChangeListener(this);
        this.otherLabelText.addActionListener(this);
        this.thicknessCombo.addActionListener(this);
        this.groupLabelsCheck.addActionListener(this);
        this.initFromSource();
    }

    private JPanel getSpacer(int w, int h) {
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(w, h));
        return spacer;
    }

    private void initGUI() {
        this.setLayout(new GridLayout(15, 1));
        JPanel panel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Segment_labels.txt", (String)"Segment labels"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add(label);
        JSeparator sep = new JSeparator();
        sep.setPreferredSize(new Dimension(150, 2));
        panel.add(sep);
        this.add(panel);
        JLabel name = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Name.txt", (String)"Name"));
        name.setFont(TabbedPropertiesDialog.dialogFont);
        JLabel data = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Data.txt", (String)"Data"));
        data.setFont(TabbedPropertiesDialog.dialogFont);
        JLabel percent = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Percent.txt", (String)"Percent"));
        percent.setFont(TabbedPropertiesDialog.dialogFont);
        name.setPreferredSize(percent.getPreferredSize());
        data.setPreferredSize(percent.getPreferredSize());
        this.labelScheme = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.LabelScheme.txt", (String)"Label Scheme"));
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        panel.add(name);
        this.nameCombo = new JComboBox();
        this.nameCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.nameCombo.setBackground(Color.white);
        this.nameCombo.addItem(this.NONE);
        this.nameCombo.addItem(this.INSIDE);
        if (!this.isGroupedPie()) {
            this.nameCombo.addItem(this.OUTSIDE);
            this.nameCombo.addItem(this.ARROW);
        }
        Dimension comboDim = new Dimension((int)((double)this.nameCombo.getPreferredSize().width * 1.75), 18);
        this.nameCombo.setPreferredSize(comboDim);
        panel.add(this.nameCombo);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        panel.add(data);
        this.dataCombo = new JComboBox();
        this.dataCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.dataCombo.setBackground(Color.white);
        this.dataCombo.addItem(this.NONE);
        this.dataCombo.addItem(this.INSIDE);
        if (!this.isGroupedPie()) {
            this.dataCombo.addItem(this.OUTSIDE);
            this.dataCombo.addItem(this.ARROW);
        }
        this.dataCombo.setPreferredSize(comboDim);
        panel.add(this.dataCombo);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        panel.add(percent);
        this.percentCombo = new JComboBox();
        this.percentCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.percentCombo.setBackground(Color.white);
        this.percentCombo.addItem(this.NONE);
        this.percentCombo.addItem(this.INSIDE);
        if (!this.isGroupedPie()) {
            this.percentCombo.addItem(this.OUTSIDE);
            this.percentCombo.addItem(this.ARROW);
        }
        this.percentCombo.setPreferredSize(comboDim);
        panel.add(this.percentCombo);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 25));
        JPanel temp = new JPanel();
        temp.setPreferredSize(percent.getPreferredSize());
        panel.add(temp);
        this.fontButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Text_options.txt", (String)"Text options"));
        this.fontButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.fontButton.setPreferredSize(comboDim);
        panel.add(this.fontButton);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 25));
        panel.add(this.labelScheme);
        this.labelSchemeCombo = new JComboBox();
        this.labelSchemeCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelSchemeCombo.setBackground(Color.white);
        this.labelSchemeCombo.addItem(this.DEFAULT);
        this.labelSchemeCombo.addItem(this.RADIAL);
        this.labelSchemeCombo.addItem(this.MARGIN);
        this.labelSchemeCombo.setPreferredSize(comboDim);
        panel.add(this.labelSchemeCombo);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(5, 10));
        this.outlineCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Outline.txt", (String)"Outline"));
        this.outlineCheck.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add(this.outlineCheck);
        sep = new JSeparator();
        sep.setPreferredSize(new Dimension(175, 2));
        panel.add(sep);
        this.add(panel);
        JLabel thick = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Thickness.txt", (String)"Thickness"));
        thick.setFont(TabbedPropertiesDialog.dialogFont);
        JLabel color = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Color.txt", (String)"Color"));
        color.setFont(TabbedPropertiesDialog.dialogFont);
        thick.setPreferredSize(percent.getPreferredSize());
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 15));
        panel.add(thick);
        this.thicknessCombo = new JComboBox();
        this.thicknessCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.thicknessCombo.setBackground(Color.white);
        for (int i = 1; i <= 10; ++i) {
            this.thicknessCombo.addItem(i + ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.pt.txt", (String)"pt."));
        }
        this.thicknessCombo.setPreferredSize(comboDim);
        panel.add(this.thicknessCombo);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(5, 10));
        this.otherCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Other_Enabled.txt", (String)"Other Enabled"));
        this.otherCheck.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add(this.otherCheck);
        sep = new JSeparator();
        sep.setPreferredSize(new Dimension(140, 2));
        panel.add(sep);
        this.add(panel);
        ButtonGroup otherButtonGroup = new ButtonGroup();
        this.bPercent = new JRadioButton();
        this.bMaxSlices = new JRadioButton();
        otherButtonGroup.add(this.bPercent);
        otherButtonGroup.add(this.bMaxSlices);
        this.percentage = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Percentage.txt", (String)"Percentage"));
        this.percentage.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxSlices = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.MaxSlices.txt", (String)"Maximum Slices"));
        this.maxSlices.setFont(TabbedPropertiesDialog.dialogFont);
        this.percentage.setPreferredSize(percent.getPreferredSize());
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        panel.add(this.bPercent);
        panel.add(this.percentage);
        this.otherPercentSpin = new JSpinner();
        SpinnerNumberModel opsm = new SpinnerNumberModel(0.04, 0.0, 1.0, 0.01);
        this.otherPercentSpin.setFont(TabbedPropertiesDialog.dialogFont);
        this.otherPercentSpin.setModel(opsm);
        this.otherPercentSpin.setEditor(new JSpinner.NumberEditor(this.otherPercentSpin, "###.##%"));
        panel.add(this.otherPercentSpin);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        panel.add(this.bMaxSlices);
        panel.add(this.maxSlices);
        this.otherMaxSlicesSpin = new JSpinner();
        SpinnerNumberModel omsm = new SpinnerNumberModel(10, 0, 200, 1);
        this.otherMaxSlicesSpin.setFont(TabbedPropertiesDialog.dialogFont);
        this.otherMaxSlicesSpin.setModel(omsm);
        panel.add(this.otherMaxSlicesSpin);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(25, 5));
        this.otherLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Label.txt", (String)"Label"));
        panel.add(this.otherLabel);
        panel.add(this.getSpacer(25, 5));
        this.otherLabelText = new JTextField(15);
        this.otherLabelText.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add(this.otherLabelText);
        this.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.getSpacer(5, 10));
        this.groupLabelsCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Show_Group_Labels.txt", (String)"Show Group Labels"));
        this.groupLabelsCheck.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add(this.groupLabelsCheck);
        this.add(panel);
    }

    @Override
    public boolean applyChanges() {
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8013, (Object)this.otherLabelText.getText());
        return false;
    }

    @Override
    public boolean cancelChanges() {
        PropertyUtils.cancelChanges((Vector)this.listeners);
        this.initFromSource();
        if (this.isGroupedPie()) {
            this.nameCombo.setSelectedItem("None");
            this.dataCombo.setSelectedItem("None");
            this.percentCombo.setSelectedItem("None");
        } else {
            this.nameCombo.setSelectedItem("Outside");
            this.dataCombo.setSelectedItem("Arrow");
            this.percentCombo.setSelectedItem("None");
        }
        return false;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null) {
            return false;
        }
        if (this.listeners.contains(prop)) {
            return true;
        }
        this.listeners.addElement(prop);
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.otherPercentSpin) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8016, (Object)((Double)this.otherPercentSpin.getValue()));
        } else if (source == this.otherMaxSlicesSpin) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8017, (Object)((Integer)this.otherMaxSlicesSpin.getValue()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.nameCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8001, (Object)this.getPos(this.nameCombo.getSelectedItem().toString()));
            this.setLabelSchemeCombo();
        } else if (source == this.dataCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8002, (Object)this.getPos(this.dataCombo.getSelectedItem().toString()));
            this.setLabelSchemeCombo();
        } else if (source == this.percentCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8003, (Object)this.getPos(this.percentCombo.getSelectedItem().toString()));
            this.setLabelSchemeCombo();
        } else if (source == this.labelSchemeCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8011, (Object)new Integer(this.getLabelScheme(this.labelSchemeCombo.getSelectedItem().toString())));
        } else if (source == this.fontButton) {
            Object object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8004);
            if (object != null && object instanceof PropertyInterface) {
                this.textDialog.showDialog((PropertyInterface)object, ResourceLoader.getResourceString((Object)this.rb, (String)"PiePanel.Pie_Label_Text_Options.txt", (String)"Pie Label Text Options"));
            }
        } else if (source == this.outlineCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8005, (Object)new Boolean(this.outlineCheck.isSelected()));
            this.thicknessCombo.setEnabled(this.outlineCheck.isSelected());
        } else if (source == this.thicknessCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8006, (Object)new Integer(this.thicknessCombo.getSelectedIndex() + 1));
        } else if (source == this.otherCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8018, (Object)new Boolean(this.otherCheck.isSelected()));
            this.enableOtherBlock();
        } else if (source == this.bPercent) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(0));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8016, (Object)((Double)this.otherPercentSpin.getValue()));
            this.otherPercentSpin.setEnabled(true);
            this.otherMaxSlicesSpin.setEnabled(false);
        } else if (source == this.bMaxSlices) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(1));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8017, (Object)((Integer)this.otherMaxSlicesSpin.getValue()));
            this.otherPercentSpin.setEnabled(false);
            this.otherMaxSlicesSpin.setEnabled(true);
        } else if (source == this.otherLabelText) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8013, (Object)this.otherLabelText.getText());
        } else if (source == this.groupLabelsCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8010, (Object)new Boolean(this.groupLabelsCheck.isSelected()));
        }
    }

    protected Color showColorChooserDialog(String title, Color initialColor) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, title, initialColor);
    }

    private void enableOtherBlock() {
        this.bPercent.setEnabled(this.otherCheck.isSelected());
        this.bMaxSlices.setEnabled(this.otherCheck.isSelected());
        this.percentage.setEnabled(this.otherCheck.isSelected());
        this.maxSlices.setEnabled(this.otherCheck.isSelected());
        this.otherLabel.setEnabled(this.otherCheck.isSelected());
        this.otherLabelText.setEnabled(this.otherCheck.isSelected());
        if ((Integer)PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8015) == 0) {
            this.bPercent.setSelected(true);
        } else {
            this.bMaxSlices.setSelected(true);
        }
        this.otherPercentSpin.setEnabled(false);
        this.otherMaxSlicesSpin.setEnabled(false);
        if (this.otherCheck.isSelected() && this.bPercent.isSelected()) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(0));
            this.bPercent.setEnabled(true);
            this.percentage.setEnabled(true);
            this.otherPercentSpin.setEnabled(true);
        }
        if (this.otherCheck.isSelected() && this.bMaxSlices.isSelected()) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(1));
            this.maxSlices.setEnabled(true);
            this.bMaxSlices.setEnabled(true);
            this.otherMaxSlicesSpin.setEnabled(true);
        }
    }

    private String getPos(String pos) {
        if (pos.equalsIgnoreCase(this.NONE)) {
            return "None";
        }
        if (pos.equalsIgnoreCase(this.INSIDE)) {
            return "Inside";
        }
        if (pos.equalsIgnoreCase(this.OUTSIDE)) {
            return "Outside";
        }
        if (pos.equalsIgnoreCase(this.ARROW)) {
            return "Arrow";
        }
        return null;
    }

    private int getLabelScheme(String scheme) {
        if (scheme.equalsIgnoreCase(this.DEFAULT)) {
            return 0;
        }
        if (scheme.equalsIgnoreCase(this.RADIAL)) {
            return 1;
        }
        if (scheme.equalsIgnoreCase(this.MARGIN)) {
            return 2;
        }
        return -1;
    }

    private void updatePositionComboBox(JComboBox combo) {
        if (!this.isGroupedPie()) {
            if (combo.getItemCount() == 2) {
                combo.addItem(this.OUTSIDE);
                combo.addItem(this.ARROW);
            }
        } else {
            if (this.OUTSIDE.equals(combo.getSelectedItem()) || this.ARROW.equals(combo.getSelectedItem())) {
                combo.setSelectedItem(this.NONE);
            }
            combo.removeItem(this.OUTSIDE);
            combo.removeItem(this.ARROW);
        }
    }

    private void initFromSource() {
        this.nameCombo.removeActionListener(this);
        this.dataCombo.removeActionListener(this);
        this.percentCombo.removeActionListener(this);
        this.updatePositionComboBox(this.nameCombo);
        this.updatePositionComboBox(this.dataCombo);
        this.updatePositionComboBox(this.percentCombo);
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8001);
        if (o != null && o instanceof String) {
            this.nameCombo.setSelectedItem((String)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8002)) != null && o instanceof String) {
            this.dataCombo.setSelectedItem((String)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8003)) != null && o instanceof String) {
            this.percentCombo.setSelectedItem((String)o);
        }
        this.setLabelSchemeCombo();
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8011);
        if (o != null && o instanceof Number) {
            this.labelSchemeCombo.setSelectedIndex(((Number)o).intValue());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8005)) != null && o instanceof Boolean) {
            this.outlineCheck.setSelected((Boolean)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8006)) != null && o instanceof Number) {
            this.thicknessCombo.setSelectedIndex(((Number)o).intValue() - 1);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8018)) != null && o instanceof Boolean) {
            boolean ov = (Boolean)o;
            this.otherCheck.setSelected(ov);
            this.enableOtherBlock();
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8015)) != null && o instanceof Integer) {
            int type = (Integer)o;
            if (type == 0) {
                this.bPercent.setSelected(true);
            } else {
                this.bMaxSlices.setSelected(true);
            }
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8016)) != null && o instanceof Double) {
            this.otherPercentSpin.setValue(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8017)) != null && o instanceof Integer) {
            this.otherMaxSlicesSpin.setValue(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8013)) != null && o instanceof String) {
            this.otherLabelText.setText((String)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8010)) == null) {
            this.groupLabelsCheck.setEnabled(false);
        } else if (this.isGroupedPie()) {
            this.groupLabelsCheck.setEnabled(true);
            if (o instanceof Boolean) {
                this.groupLabelsCheck.setSelected((Boolean)o);
            }
        } else {
            this.groupLabelsCheck.setEnabled(false);
        }
        this.nameCombo.addActionListener(this);
        this.dataCombo.addActionListener(this);
        this.percentCombo.addActionListener(this);
    }

    private boolean isGroupedPie() {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8012);
        if (o != null & o instanceof Boolean && ((Boolean)o).booleanValue() && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.initFromSource();
        }
        super.setVisible(aFlag);
    }

    private void setLabelSchemeCombo() {
        if (this.nameCombo.getSelectedItem().equals(this.OUTSIDE) || this.dataCombo.getSelectedItem().equals(this.OUTSIDE) || this.percentCombo.getSelectedItem().equals(this.OUTSIDE)) {
            this.labelSchemeCombo.setEnabled(true);
            this.labelScheme.setEnabled(true);
        } else {
            this.labelSchemeCombo.setEnabled(false);
            this.labelScheme.setEnabled(false);
        }
    }
}

