/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.GridBag;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PieOptionsPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ItemListener,
ChangeListener {
    private JLabel pieChartOptionsLabel;
    private JLabel pieOutlineThicknessLabel;
    private JComboBox pieOutlineThicknessValues;
    private JLabel pieLabelOptionsLabel;
    private JCheckBox showGroupLabelsOption;
    private JLabel showLabel;
    private JCheckBox showCategoryName;
    private JCheckBox showValue;
    private JCheckBox showPct;
    private JLabel labelPositionLabel;
    private JComboBox labelPositionOptions;
    private JLabel labelSeparatorLabel;
    private JComboBox labelSeparatorOptions;
    private String[] labelSepOptions;
    private JCheckBox otherSliceOption;
    private JRadioButton percentageBased;
    private JSpinner percentageValueForOtherSlice;
    private JRadioButton maxSlicesBased;
    private JSpinner maxSlicesValueForOtherSlices;
    private JLabel otherLabel;
    private JTextField otherSliceText;
    private JButton labelFontOptions;
    private TextDialog labelFontDialog;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private Vector listeners = new Vector();

    public PieOptionsPanel(PropertyInterface pi) {
        this.labelSepOptions = new String[]{rb.getString("PieOptionsPanel.labelSeparator.comma.txt"), rb.getString("PieOptionsPanel.labelSeparator.colon.txt"), rb.getString("PieOptionsPanel.labelSeparator.semicolon.txt")};
        this.addPropertyListener(pi);
        this.initGUI(pi);
        this.addListeners();
        this.initFromSource();
    }

    private void addListeners() {
        this.pieOutlineThicknessValues.addActionListener(this);
        this.showGroupLabelsOption.addActionListener(this);
        this.showCategoryName.addItemListener(this);
        this.showValue.addItemListener(this);
        this.showPct.addItemListener(this);
        this.labelPositionOptions.addActionListener(this);
        this.labelSeparatorOptions.addActionListener(this);
        this.otherSliceOption.addActionListener(this);
        this.percentageBased.addActionListener(this);
        this.maxSlicesBased.addActionListener(this);
        this.percentageValueForOtherSlice.addChangeListener(this);
        this.maxSlicesValueForOtherSlices.addChangeListener(this);
        this.otherSliceText.addActionListener(this);
        this.labelFontOptions.addActionListener(this);
    }

    private void removeListeners() {
        this.pieOutlineThicknessValues.removeActionListener(this);
        this.showGroupLabelsOption.removeActionListener(this);
        this.showCategoryName.removeItemListener(this);
        this.showValue.removeItemListener(this);
        this.showPct.removeItemListener(this);
        this.labelPositionOptions.removeActionListener(this);
        this.labelSeparatorOptions.removeActionListener(this);
        this.otherSliceOption.removeActionListener(this);
        this.percentageBased.removeActionListener(this);
        this.maxSlicesBased.removeActionListener(this);
        this.percentageValueForOtherSlice.removeChangeListener(this);
        this.maxSlicesValueForOtherSlices.removeChangeListener(this);
        this.otherSliceText.removeActionListener(this);
        this.labelFontOptions.removeActionListener(this);
    }

    private void initGUI(PropertyInterface pie) {
        this.pieChartOptionsLabel = new JLabel(rb.getString("PieOptionsPanel.chartOptions.label.txt"));
        this.pieChartOptionsLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.pieOutlineThicknessLabel = new JLabel(rb.getString("PieOptionsPanel.outline.thickness.label.txt"));
        this.pieOutlineThicknessLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.pieOutlineThicknessValues = new JComboBox();
        this.pieOutlineThicknessValues.setFont(TabbedPropertiesDialog.dialogFont);
        this.pieOutlineThicknessValues.setBackground(Color.white);
        this.pieOutlineThicknessValues.addItem(rb.getString("PieOptionsPanel.outline.thickness.option.none.txt"));
        for (int i = 1; i <= 10; ++i) {
            this.pieOutlineThicknessValues.addItem(i + ResourceLoader.getResourceString((Object)rb, (String)"PieOptionsPanel.outline.thickness.pt.txt", (String)"pt."));
        }
        this.pieLabelOptionsLabel = new JLabel(rb.getString("PieOptionsPanel.labelOptions.label.txt"));
        this.pieLabelOptionsLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.showGroupLabelsOption = new JCheckBox(rb.getString("PieOptionsPanel.showGroupLabels.option.txt"));
        this.showGroupLabelsOption.setFont(TabbedPropertiesDialog.dialogFont);
        this.showLabel = new JLabel(rb.getString("PieOptionsPanel.showLabel.label.txt"));
        this.showLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.showCategoryName = new JCheckBox(rb.getString("PieOptionsPanel.categoryName.label.txt"));
        this.showCategoryName.setFont(TabbedPropertiesDialog.dialogFont);
        this.showCategoryName.setSelected(true);
        this.showValue = new JCheckBox(rb.getString("PieOptionsPanel.value.label.txt"));
        this.showValue.setFont(TabbedPropertiesDialog.dialogFont);
        this.showPct = new JCheckBox(rb.getString("PieOptionsPanel.percent.label.txt"));
        this.showPct.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelPositionLabel = new JLabel(rb.getString("PieOptionsPanel.labelPosition.label.txt"));
        this.labelPositionLabel.setFont(TabbedPropertiesDialog.dialogFont);
        LabelPositionOption[] labelPosOptions = new LabelPositionOption[]{LabelPositionOption.inside, LabelPositionOption.outside, LabelPositionOption.margin, LabelPositionOption.bestfit};
        this.labelPositionOptions = new JComboBox<LabelPositionOption>(labelPosOptions);
        this.labelPositionOptions.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelPositionOptions.setBackground(Color.white);
        this.labelSeparatorLabel = new JLabel(rb.getString("PieOptionsPanel.labelSeparator.label.txt"));
        this.labelSeparatorLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelSeparatorOptions = new JComboBox<String>(this.labelSepOptions);
        this.labelSeparatorOptions.setSelectedIndex(0);
        this.labelSeparatorOptions.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelSeparatorOptions.setBackground(Color.white);
        this.otherSliceOption = new JCheckBox(rb.getString("PieOptionsPanel.otherSlice.txt"));
        this.otherSliceOption.setFont(TabbedPropertiesDialog.dialogFont);
        ButtonGroup buttongrp = new ButtonGroup();
        this.percentageBased = new JRadioButton(rb.getString("PieOptionsPanel.otherSlice.option.percent.txt"));
        this.percentageBased.setFont(TabbedPropertiesDialog.dialogFont);
        buttongrp.add(this.percentageBased);
        this.percentageValueForOtherSlice = new JSpinner();
        SpinnerNumberModel percentModel = new SpinnerNumberModel(0.04, 0.0, 1.0, 0.01);
        this.percentageValueForOtherSlice.setFont(TabbedPropertiesDialog.dialogFont);
        this.percentageValueForOtherSlice.setModel(percentModel);
        this.percentageValueForOtherSlice.setEditor(new JSpinner.NumberEditor(this.percentageValueForOtherSlice, "###.##%"));
        this.maxSlicesBased = new JRadioButton(rb.getString("PieOptionsPanel.otherSlice.option.maxSlices.txt"));
        this.maxSlicesBased.setFont(TabbedPropertiesDialog.dialogFont);
        buttongrp.add(this.maxSlicesBased);
        this.maxSlicesValueForOtherSlices = new JSpinner();
        this.maxSlicesValueForOtherSlices.setFont(TabbedPropertiesDialog.dialogFont);
        SpinnerNumberModel maxModel = new SpinnerNumberModel(10, 0, 200, 1);
        this.maxSlicesValueForOtherSlices.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxSlicesValueForOtherSlices.setModel(maxModel);
        this.otherLabel = new JLabel(rb.getString("PieOptionsPanel.otherSlice.label.txt"));
        this.otherLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.otherSliceText = new JTextField();
        this.labelFontOptions = new JButton(rb.getString("PieOptionsPanel.labelFontOptions.label.txt"));
        this.labelFontOptions.setFont(TabbedPropertiesDialog.dialogFont);
        JComponent component = null;
        if (pie instanceof JComponent) {
            component = (JComponent)pie;
        }
        this.labelFontDialog = new TextDialog((Frame)null, component);
        this.setLayout(new GridBagLayout());
        JPanel row0 = new JPanel();
        GridBag.addTo(row0, this.pieChartOptionsLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0));
        GridBag.addTo(row0, new JSeparator(), 1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0));
        GridBag.addTo(this, row0, 0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10));
        GridBag.addTo(this, this.pieOutlineThicknessLabel, 0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0));
        GridBag.addTo(this, this.pieOutlineThicknessValues, 2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 25));
        JPanel row2 = new JPanel();
        GridBag.addTo(row2, this.pieLabelOptionsLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0));
        GridBag.addTo(row2, new JSeparator(), 1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0));
        GridBag.addTo(this, row2, 0, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10));
        GridBag.addTo(this, this.showGroupLabelsOption, 0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0));
        GridBag.addTo(this, this.showLabel, 0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 0, 0));
        Box showLabelOptions = Box.createVerticalBox();
        showLabelOptions.add(this.showCategoryName);
        showLabelOptions.add(this.showValue);
        showLabelOptions.add(this.showPct);
        GridBag.addTo(this, showLabelOptions, 1, 4, 2, 1, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 0));
        GridBag.addTo(this, this.labelPositionLabel, 0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 0));
        GridBag.addTo(this, this.labelPositionOptions, 2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(20, 0, 0, 25));
        GridBag.addTo(this, this.labelSeparatorLabel, 0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0));
        GridBag.addTo(this, this.labelSeparatorOptions, 2, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 25));
        JPanel row7 = new JPanel();
        GridBag.addTo(row7, this.otherSliceOption, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0));
        GridBag.addTo(row7, new JSeparator(), 1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0));
        GridBag.addTo(this, row7, 0, 7, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10));
        GridBag.addTo(this, this.percentageBased, 0, 8, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 0));
        GridBag.addTo(this, this.percentageValueForOtherSlice, 2, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 25));
        GridBag.addTo(this, this.maxSlicesBased, 0, 9, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 0));
        GridBag.addTo(this, this.maxSlicesValueForOtherSlices, 2, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 25));
        GridBag.addTo(this, this.otherLabel, 0, 10, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 5, 0));
        GridBag.addTo(this, this.otherSliceText, 2, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 25));
        GridBag.addTo(this, new JLabel(), 0, 11, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0));
        GridBag.addTo(this, this.labelFontOptions, 2, 11, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 60, 10, 25));
    }

    @Override
    public boolean applyChanges() {
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8013, (Object)this.otherSliceText.getText());
        PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return true;
    }

    @Override
    public boolean cancelChanges() {
        PropertyUtils.cancelChanges((Vector)this.listeners);
        this.initFromSource();
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initFromSource();
        }
        super.setVisible(b);
    }

    private void initFromSource() {
        this.removeListeners();
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8019);
        if (o != null && o instanceof String) {
            String lPos = (String)o;
            if (lPos.equalsIgnoreCase("INSIDE")) {
                this.labelPositionOptions.setSelectedItem(LabelPositionOption.inside);
            } else if (lPos.equalsIgnoreCase("OUTSIDE")) {
                this.labelPositionOptions.setSelectedItem(LabelPositionOption.outside);
            } else if (lPos.equalsIgnoreCase("MARGIN")) {
                this.labelPositionOptions.setSelectedItem(LabelPositionOption.margin);
            } else if (lPos.equalsIgnoreCase("BESTFIT")) {
                this.labelPositionOptions.setSelectedItem(LabelPositionOption.bestfit);
            }
            this.labelPositionOptions.setEnabled(!this.isGroupedPie());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8021)) != null && o instanceof String) {
            String labelSep = (String)o;
            this.labelSeparatorOptions.setSelectedItem(labelSep);
            this.labelSeparatorOptions.setEnabled(!this.isGroupedPie());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8020)) != null && o instanceof Number) {
            int mask = (Integer)o;
            this.showCategoryName.setSelected(false);
            this.showValue.setSelected(false);
            this.showPct.setSelected(false);
            this.showCategoryName.setSelected((mask & 1) == 1);
            this.showValue.setSelected((mask & 2) == 2);
            this.showPct.setSelected((mask & 4) == 4);
            if (this.isGroupedPie()) {
                if (this.showCategoryName.isSelected()) {
                    this.showCategoryName.setSelected(false);
                }
                if (this.showPct.isSelected()) {
                    this.showCategoryName.setSelected(false);
                }
            }
            this.showCategoryName.setEnabled(!this.isGroupedPie());
            this.showPct.setEnabled(!this.isGroupedPie());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8005)) != null && o instanceof Boolean) {
            Boolean isVisible = (Boolean)o;
            if (isVisible.booleanValue()) {
                o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8006);
                if (o != null && o instanceof Number) {
                    this.pieOutlineThicknessValues.setSelectedIndex(((Number)o).intValue());
                }
            } else {
                this.pieOutlineThicknessValues.setSelectedIndex(0);
            }
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8018)) != null && o instanceof Boolean) {
            boolean ov = (Boolean)o;
            this.otherSliceOption.setSelected(ov);
            this.enableOtherSliceOptions(ov);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8015)) != null && o instanceof Integer) {
            int type = (Integer)o;
            if (type == 0) {
                this.percentageBased.setSelected(true);
            } else {
                this.maxSlicesBased.setSelected(true);
            }
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8016)) != null && o instanceof Double) {
            this.percentageValueForOtherSlice.setValue(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8017)) != null && o instanceof Integer) {
            this.maxSlicesValueForOtherSlices.setValue(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8013)) != null && o instanceof String) {
            this.otherSliceText.setText((String)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8010)) == null) {
            this.showGroupLabelsOption.setEnabled(false);
        } else if (this.isGroupedPie()) {
            this.showGroupLabelsOption.setEnabled(true);
            if (o instanceof Boolean) {
                this.showGroupLabelsOption.setSelected((Boolean)o);
            }
        } else {
            this.showGroupLabelsOption.setEnabled(false);
        }
        this.addListeners();
    }

    private boolean isGroupedPie() {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8012);
        if (o != null & o instanceof Boolean && ((Boolean)o).booleanValue() && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.labelPositionOptions) {
            String labelOpt = ((LabelPositionOption)this.labelPositionOptions.getSelectedItem()).getValue();
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8019, (Object)labelOpt);
        } else if (source == this.labelSeparatorOptions) {
            String labelSep = this.labelSeparatorOptions.getSelectedItem().toString();
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8021, (Object)labelSep);
        } else if (source == this.pieOutlineThicknessValues) {
            int selectedIndex = this.pieOutlineThicknessValues.getSelectedIndex();
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8005, (Object)new Boolean(selectedIndex != 0));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8006, (Object)new Integer(selectedIndex));
        } else if (source == this.labelFontOptions) {
            Object object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8004);
            if (object != null && object instanceof PropertyInterface) {
                this.labelFontDialog.showDialog((PropertyInterface)object, ResourceLoader.getResourceString((Object)rb, (String)"PieOptionsPanel.labelFontDialog.title.txt", (String)"Pie Label Text Options"));
            }
        } else if (source == this.otherSliceOption) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8018, (Object)new Boolean(this.otherSliceOption.isSelected()));
            this.enableOtherSliceOptions(this.otherSliceOption.isSelected());
        } else if (source == this.percentageBased) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(0));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8016, (Object)((Double)this.percentageValueForOtherSlice.getValue()));
            this.percentageValueForOtherSlice.setEnabled(true);
            this.maxSlicesValueForOtherSlices.setEnabled(false);
        } else if (source == this.maxSlicesBased) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8015, (Object)new Integer(1));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8017, (Object)((Integer)this.maxSlicesValueForOtherSlices.getValue()));
            this.percentageValueForOtherSlice.setEnabled(false);
            this.maxSlicesValueForOtherSlices.setEnabled(true);
        } else if (source == this.otherSliceText) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8013, (Object)this.otherSliceText.getText());
        } else if (source == this.showGroupLabelsOption) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8010, (Object)new Boolean(this.showGroupLabelsOption.isSelected()));
        }
    }

    private void enableOtherSliceOptions(boolean enable) {
        this.otherSliceText.setEnabled(enable);
        this.percentageBased.setEnabled(enable);
        this.maxSlicesBased.setEnabled(enable);
        this.percentageValueForOtherSlice.setEnabled(this.percentageBased.isSelected());
        this.maxSlicesValueForOtherSlices.setEnabled(this.maxSlicesBased.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBox) {
            int mask = ((Number)PropertyUtils.getPropertyValue((Vector)this.listeners, (int)8020)).intValue();
            JCheckBox check = (JCheckBox)source;
            if (check == this.showCategoryName) {
                mask = this.showCategoryName.isSelected() ? (mask |= 1) : (mask &= 0xFFFFFFFE);
            } else if (check == this.showValue) {
                mask = this.showValue.isSelected() ? (mask |= 2) : (mask &= 0xFFFFFFFD);
            } else if (check == this.showPct) {
                mask = this.showPct.isSelected() ? (mask |= 4) : (mask &= 0xFFFFFFFB);
            }
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8020, (Object)new Integer(mask));
        } else if (source instanceof JComboBox) {
            JComboBox sepOptions = (JComboBox)source;
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8021, (Object)sepOptions.getSelectedItem());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.percentageValueForOtherSlice) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8016, (Object)((Double)this.percentageValueForOtherSlice.getValue()));
        } else if (source == this.maxSlicesValueForOtherSlices) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)8017, (Object)((Integer)this.maxSlicesValueForOtherSlices.getValue()));
        }
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null) {
            return false;
        }
        if (this.listeners.contains(prop)) {
            return true;
        }
        this.listeners.addElement(prop);
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    static class LabelPositionOption {
        private String value;
        private String displayName;
        public static LabelPositionOption inside = new LabelPositionOption("INSIDE", "PieOptionsPanel.labellingScheme.option.inside.txt");
        public static LabelPositionOption outside = new LabelPositionOption("OUTSIDE", "PieOptionsPanel.labellingScheme.option.outside.txt");
        public static LabelPositionOption margin = new LabelPositionOption("MARGIN", "PieOptionsPanel.labellingScheme.option.margin.txt");
        public static LabelPositionOption bestfit = new LabelPositionOption("BESTFIT", "PieOptionsPanel.labellingScheme.option.bestfit.txt");

        public LabelPositionOption(String value, String displayNameKey) {
            this.value = value;
            this.displayName = rb.getString(displayNameKey);
        }

        public String toString() {
            return this.displayName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

