/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class NeedlePanel
extends JPanel
implements TabPanelInterface,
DocumentListener {
    private static final long serialVersionUID = 5958929476605062408L;
    private JTextField BaseLineTextField = null;
    Vector listeners = new Vector();
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JPanel BaseLinePanel = null;
    private JLabel BaseLineLabel = null;
    private JCheckBox BaseLineVisibleCheckBox = null;
    private JLabel BaseLinePatternLabel = null;
    private JLabel BaseLineWidthLabel = null;
    private JLabel BaseLineColorLabel = null;
    private JComboBox BaseLinePatternComboBox = null;
    private JComboBox BaseLineWidthComboBox = null;
    private JPanel BaseLineColorPanel = null;
    private JButton BaseLineColorButton = null;
    private PatternCellRenderer patternCellRenderer = new PatternCellRenderer();
    private boolean blockEvents = false;
    private JColorChooser colorChooser = null;
    private JLabel NeedleWidthLabel = null;
    private JComboBox NeedleWidthComboBox = null;
    private JPanel NeedleOptionsPanel = null;

    public NeedlePanel() {
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getBaseLinePanel(), null);
        this.setLayout(null);
        this.setSize(277, 410);
        this.add((Component)this.getNeedleOptionsPanel(), null);
    }

    private boolean getBooleanValue(Object o, boolean defaultValue) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    private int getInt(Object o, int defaultValue) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return defaultValue;
    }

    private void updateUIState() {
        this.blockEvents = true;
        this.BaseLineVisibleCheckBox.setSelected(this.getBooleanValue(PropertyUtils.getPropertyValue((Vector)this.listeners, (int)9501), false));
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)18902);
        if (o != null) {
            this.BaseLineTextField.setText(o.toString());
        }
        this.BaseLinePatternComboBox.setSelectedIndex(this.getInt(PropertyUtils.getPropertyValue((Vector)this.listeners, (int)9504), 1));
        this.BaseLineWidthComboBox.setSelectedIndex(this.getInt(PropertyUtils.getPropertyValue((Vector)this.listeners, (int)9503), 3) - 1);
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)9502);
        if (o instanceof Color) {
            this.BaseLineColorPanel.setBackground((Color)o);
        }
        this.setBaseLineWidgetsEnabled(this.BaseLineVisibleCheckBox.isSelected());
        this.NeedleWidthComboBox.setSelectedIndex(this.getInt(PropertyUtils.getPropertyValue((Vector)this.listeners, (int)18901), 0) - 1);
        this.blockEvents = false;
    }

    private void setBaseLineWidgetsEnabled(boolean enabled) {
        this.BaseLinePatternComboBox.setEnabled(enabled);
        this.BaseLineWidthComboBox.setEnabled(enabled);
        this.BaseLineColorPanel.setEnabled(enabled);
        this.BaseLineColorButton.setEnabled(enabled);
    }

    private Color showColorChooserDialog(Color initialColor, String title) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, title, initialColor);
    }

    @Override
    public boolean applyChanges() {
        boolean rc = PropertyUtils.applyChanges((Vector)this.listeners);
        this.updateUIState();
        return rc;
    }

    @Override
    public boolean cancelChanges() {
        boolean rc = PropertyUtils.cancelChanges((Vector)this.listeners);
        this.updateUIState();
        return rc;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null) {
            return false;
        }
        this.listeners.addElement(prop);
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.blockEvents) {
            return;
        }
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)18902, (Object)this.BaseLineTextField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.blockEvents) {
            return;
        }
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)18902, (Object)this.BaseLineTextField.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.blockEvents) {
            return;
        }
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)18902, (Object)this.BaseLineTextField.getText());
    }

    private JTextField getBaseLineTextField() {
        if (this.BaseLineTextField == null) {
            this.BaseLineTextField = new JTextField();
            this.BaseLineTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLineTextField.getDocument().addDocumentListener(this);
            this.BaseLineTextField.setHorizontalAlignment(4);
            this.BaseLineTextField.setBounds(180, 52, 68, 24);
        }
        return this.BaseLineTextField;
    }

    private JPanel getBaseLinePanel() {
        if (this.BaseLinePanel == null) {
            this.BaseLineColorLabel = new JLabel();
            this.BaseLineColorLabel.setBounds(20, 148, 92, 24);
            this.BaseLineColorLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.Color.txt", (String)"Color:"));
            this.BaseLineColorLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLineWidthLabel = new JLabel();
            this.BaseLineWidthLabel.setBounds(20, 120, 92, 24);
            this.BaseLineWidthLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.Width.txt", (String)"Width:"));
            this.BaseLineWidthLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLinePatternLabel = new JLabel();
            this.BaseLinePatternLabel.setBounds(20, 92, 92, 24);
            this.BaseLinePatternLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.Pattern.txt", (String)"Pattern:"));
            this.BaseLinePatternLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLineLabel = new JLabel();
            this.BaseLineLabel.setBounds(20, 52, 152, 24);
            this.BaseLineLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.BaseLineValue.txt", (String)"Base Line Value:"));
            this.BaseLineLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLinePanel = new JPanel();
            this.BaseLinePanel.setLayout(null);
            this.BaseLinePanel.setBounds(6, 88, 266, 184);
            TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.BaseLineOptions.txt", (String)"Base Line Options"), 0, 0, TabbedPropertiesDialog.dialogFont, Color.black);
            this.BaseLinePanel.setBorder(titleBorder);
            this.BaseLinePanel.add((Component)this.getBaseLineTextField(), null);
            this.BaseLinePanel.add((Component)this.BaseLineLabel, null);
            this.BaseLinePanel.add((Component)this.getBaseLineVisibleCheckBox(), null);
            this.BaseLinePanel.add((Component)this.BaseLinePatternLabel, null);
            this.BaseLinePanel.add((Component)this.getBaseLineWidthComboBox(), null);
            this.BaseLinePanel.add((Component)this.getBaseLineColorPanel(), null);
            this.BaseLinePanel.add((Component)this.getBaseLineColorButton(), null);
            this.BaseLinePanel.add((Component)this.BaseLineWidthLabel, null);
            this.BaseLinePanel.add((Component)this.BaseLineColorLabel, null);
            this.BaseLinePanel.add((Component)this.getBaseLinePatternComboBox(), null);
        }
        return this.BaseLinePanel;
    }

    private JCheckBox getBaseLineVisibleCheckBox() {
        if (this.BaseLineVisibleCheckBox == null) {
            this.BaseLineVisibleCheckBox = new JCheckBox();
            this.BaseLineVisibleCheckBox.setBounds(8, 24, 160, 24);
            this.BaseLineVisibleCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.ShowBaseLine.txt", (String)"Show Base Line"));
            this.BaseLineVisibleCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLineVisibleCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (NeedlePanel.this.blockEvents) {
                        return;
                    }
                    Boolean b = NeedlePanel.this.BaseLineVisibleCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                    PropertyUtils.setPropertyValue((Vector)NeedlePanel.this.listeners, (int)9501, (Object)b);
                    NeedlePanel.this.setBaseLineWidgetsEnabled(NeedlePanel.this.BaseLineVisibleCheckBox.isSelected());
                }
            });
        }
        return this.BaseLineVisibleCheckBox;
    }

    private JComboBox getBaseLinePatternComboBox() {
        if (this.BaseLinePatternComboBox == null) {
            this.BaseLinePatternComboBox = new JComboBox();
            for (int i = 0; i < 14; ++i) {
                this.BaseLinePatternComboBox.addItem(new Integer(i));
            }
            this.BaseLinePatternComboBox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value instanceof Number) {
                        NeedlePanel.this.patternCellRenderer.setStyle(((Number)value).intValue());
                    }
                    return NeedlePanel.this.patternCellRenderer.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
                }
            });
            this.BaseLinePatternComboBox.setBounds(120, 92, 128, 24);
            this.BaseLinePatternComboBox.setBackground(Color.white);
            this.BaseLinePatternComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NeedlePanel.this.blockEvents) {
                        return;
                    }
                    PropertyUtils.setPropertyValue((Vector)NeedlePanel.this.listeners, (int)9504, (Object)NeedlePanel.this.BaseLinePatternComboBox.getSelectedItem());
                }
            });
        }
        return this.BaseLinePatternComboBox;
    }

    private JComboBox getBaseLineWidthComboBox() {
        if (this.BaseLineWidthComboBox == null) {
            this.BaseLineWidthComboBox = new JComboBox();
            this.BaseLineWidthComboBox.setBounds(120, 120, 128, 24);
            this.BaseLineWidthComboBox.setBackground(Color.white);
            this.BaseLineWidthComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            for (int i = 1; i <= 10; ++i) {
                this.BaseLineWidthComboBox.addItem(i + " " + ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.pt.txt", (String)"pt."));
            }
            this.BaseLineWidthComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NeedlePanel.this.blockEvents) {
                        return;
                    }
                    PropertyUtils.setPropertyValue((Vector)NeedlePanel.this.listeners, (int)9503, (Object)new Integer(NeedlePanel.this.BaseLineWidthComboBox.getSelectedIndex() + 1));
                }
            });
        }
        return this.BaseLineWidthComboBox;
    }

    private JPanel getBaseLineColorPanel() {
        if (this.BaseLineColorPanel == null) {
            this.BaseLineColorPanel = new JPanel();
            this.BaseLineColorPanel.setBounds(120, 148, 100, 24);
            this.BaseLineColorPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.BaseLineColorPanel;
    }

    private JButton getBaseLineColorButton() {
        if (this.BaseLineColorButton == null) {
            this.BaseLineColorButton = new JButton();
            this.BaseLineColorButton.setBounds(224, 148, 24, 24);
            this.BaseLineColorButton.setText("...");
            this.BaseLineColorButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.BaseLineColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NeedlePanel.this.blockEvents) {
                        return;
                    }
                    Color c = NeedlePanel.this.showColorChooserDialog(NeedlePanel.this.BaseLineColorPanel.getBackground(), ResourceLoader.getResourceString((Object)NeedlePanel.this.rb, (String)"NeedlePanel.BaseLineColorChooser.txt", (String)"Base Line Color Chooser"));
                    if (c == null) {
                        return;
                    }
                    NeedlePanel.this.BaseLineColorPanel.setBackground(c);
                    PropertyUtils.setPropertyValue((Vector)NeedlePanel.this.listeners, (int)9502, (Object)c);
                }
            });
        }
        return this.BaseLineColorButton;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.updateUIState();
        }
        super.setVisible(aFlag);
    }

    private JComboBox getNeedleWidthComboBox() {
        if (this.NeedleWidthComboBox == null) {
            this.NeedleWidthComboBox = new JComboBox();
            this.NeedleWidthComboBox.setBounds(new Rectangle(120, 26, 128, 24));
            this.NeedleWidthComboBox.setBackground(Color.white);
            this.NeedleWidthComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.NeedleWidthComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleWidth_Size_1.txt", (String)"1 pt."));
            this.NeedleWidthComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleWidth_Size_2.txt", (String)"2 pt."));
            this.NeedleWidthComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleWidth_Size_3.txt", (String)"3 pt."));
            this.NeedleWidthComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleWidth_Size_4.txt", (String)"4 pt."));
            this.NeedleWidthComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleWidth_Size_5.txt", (String)"5 pt."));
            this.NeedleWidthComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getSource() instanceof JComboBox) {
                        JComboBox jcb = (JComboBox)e.getSource();
                        PropertyUtils.setPropertyValue((Vector)NeedlePanel.this.listeners, (int)18901, (Object)new Integer(jcb.getSelectedIndex() + 1));
                    }
                }
            });
        }
        return this.NeedleWidthComboBox;
    }

    private JPanel getNeedleOptionsPanel() {
        if (this.NeedleOptionsPanel == null) {
            this.NeedleOptionsPanel = new JPanel();
            this.NeedleOptionsPanel.setLayout(null);
            this.NeedleOptionsPanel.setBounds(new Rectangle(6, 12, 266, 64));
            String title = ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.NeedleOptions.txt", (String)"Needle Options");
            TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), title, 0, 0, null, null);
            titleBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.NeedleOptionsPanel.setBorder(titleBorder);
            this.NeedleWidthLabel = new JLabel();
            this.NeedleWidthLabel.setBounds(new Rectangle(8, 26, 100, 24));
            this.NeedleWidthLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"NeedlePanel.Width.txt", (String)"Width:"));
            this.NeedleWidthLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.NeedleOptionsPanel.add(this.NeedleWidthLabel);
            this.NeedleOptionsPanel.add(this.getNeedleWidthComboBox());
        }
        return this.NeedleOptionsPanel;
    }

    class PatternCellRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = -5600605163126105888L;
        int style = 0;

        PatternCellRenderer() {
        }

        public void setStyle(int style) {
            this.style = style;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g.setColor(this.getForeground());
            if (this.style > 1) {
                g2.setStroke(SASLinePatterns.getStroke((int)this.style, (int)2));
            } else {
                g2.setStroke(new BasicStroke(2.0f, 1, 1));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int y = this.getBounds().height / 2 - 1;
            g2.drawLine(2, y, this.getBounds().width - 4, y);
        }
    }
}

