/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LogTransformPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -1517566322093736079L;
    private JLabel LogBaseLabel = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JComboBox LogBaseComboBox = null;
    private Vector propertyListeners = null;

    public LogTransformPanel() {
        this.initialize();
    }

    private void initialize() {
        this.LogBaseLabel = new JLabel();
        this.LogBaseLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.LogBaseLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisTransformDialog.LogTransformBase.txt", (String)"Log Base:"));
        this.LogBaseLabel.setPreferredSize(new Dimension(80, 24));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
        this.add((Component)this.LogBaseLabel, null);
        this.add((Component)this.getLogBaseComboBox(), null);
    }

    private JComboBox getLogBaseComboBox() {
        if (this.LogBaseComboBox == null) {
            this.LogBaseComboBox = new JComboBox();
            this.LogBaseComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.LogBaseComboBox.setBackground(Color.white);
            this.LogBaseComboBox.setPreferredSize(new Dimension(100, 24));
            this.LogBaseComboBox.addItem("2");
            this.LogBaseComboBox.addItem(Double.toString(Math.E));
            this.LogBaseComboBox.addItem("10");
            this.LogBaseComboBox.addItemListener(this);
        }
        return this.LogBaseComboBox;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int si = this.LogBaseComboBox.getSelectedIndex();
        double base = 10.0;
        switch (si) {
            default: {
                base = 10.0;
                break;
            }
            case 0: {
                base = 2.0;
                break;
            }
            case 1: {
                base = Math.E;
            }
        }
        PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)255, (Object)new Double(base));
    }

    void initUI() {
        Object logBase = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)255);
        if (logBase == null) {
            return;
        }
        this.LogBaseComboBox.removeItemListener(this);
        double base = 10.0;
        if (logBase instanceof Number) {
            base = ((Number)logBase).doubleValue();
        }
        if (base == 2.0) {
            this.LogBaseComboBox.setSelectedIndex(0);
        } else if (base == Math.E) {
            this.LogBaseComboBox.setSelectedIndex(1);
        } else {
            this.LogBaseComboBox.setSelectedIndex(2);
        }
        this.LogBaseComboBox.addItemListener(this);
    }

    void setPropertyListeners(Vector propertyListeners) {
        this.propertyListeners = propertyListeners;
    }
}

