/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.HistogramPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramElementPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
TabPanelInterface,
HistogramPropertyInterface {
    private static final long serialVersionUID = 1L;
    protected static int BORDER = 8;
    protected static int GAP = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected ResourceBundle rb = null;
    protected JCheckBox outlineCheckBox;
    protected JCheckBox missingBinCheckBox;
    protected JCheckBox byStatCheckBox;
    protected JCheckBox intervalAxisXCheckBox;
    protected JComboBox xBinCombo;
    protected JComboBox yBinCombo;
    protected JSlider widthSlider;
    protected String widthSliderPattern;
    protected Object[] sliderArgs;
    protected JLabel byStatLabel;
    protected JLabel byChartLabel;
    protected JLabel outlineLabel;
    protected JLabel widthLabel;
    protected Color GRAYOUT;
    protected boolean byScheme;
    protected JCheckBox discreteXCheckBox;
    protected JCheckBox discreteYCheckBox;
    protected JCheckBox gradientOnCheckBox;
    protected String xBins;
    protected String yBins;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected Vector propListeners = new Vector();

    public HistogramElementPanel() {
        this((PropertyInterface)null);
    }

    public HistogramElementPanel(PropertyInterface hist) {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.widthSliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Width_Slider_Text.fmt", (String)"Width: {0}");
        this.sliderArgs = new Object[1];
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)hist);
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
            if (this.colorMapperChooserPanel != null) {
                this.colorMapperChooserPanel.initFromSource();
            }
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
            if (!(c instanceof JComboBox)) continue;
            c.setBackground(Color.white);
        }
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(2 * BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel colorPanel = this.makeColorPanel();
        JPanel binPanel = this.makeBinPanel();
        int maxWt = COLOR_PANE_WIDTH;
        this.xBinCombo.setMaximumSize(new Dimension(maxWt, this.xBinCombo.getPreferredSize().height));
        this.yBinCombo.setMaximumSize(new Dimension(maxWt, this.yBinCombo.getPreferredSize().height));
        this.widthSlider.setPreferredSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.widthSlider.setMaximumSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(binPanel);
        JPanel intervalAxisXPanel = new JPanel();
        intervalAxisXPanel.setLayout(new BoxLayout(intervalAxisXPanel, 0));
        intervalAxisXPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.intervalAxisXCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.IntervalAxisX.txt", (String)"Horizontal Interval Axis"));
        intervalAxisXPanel.add(this.intervalAxisXCheckBox);
        intervalAxisXPanel.add(Box.createHorizontalGlue());
        this.add(intervalAxisXPanel);
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.propListeners);
        this.colorMapperChooserPanel.setPreferredSize(new Dimension(300, this.colorMapperChooserPanel.getPreferredSize().height));
        this.colorMapperChooserPanel.setMaximumSize(new Dimension(300, this.colorMapperChooserPanel.getPreferredSize().height));
        this.add(this.colorMapperChooserPanel);
    }

    protected JPanel makeColorPanel() {
        JPanel colorPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorPanel.txt", (String)"Color"));
        colorPanel.setBorder(border);
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        JPanel statPanel = new JPanel();
        statPanel.setLayout(new BoxLayout(statPanel, 0));
        statPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.byStatCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorByStat.txt", (String)"Color By Stat"));
        statPanel.add(this.byStatCheckBox);
        statPanel.add(Box.createHorizontalGlue());
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.outlineCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Outline.txt", (String)"Outline"));
        outlinePanel.add(this.outlineCheckBox);
        outlinePanel.add(Box.createHorizontalGlue());
        JPanel gradientOnPanel = new JPanel();
        gradientOnPanel.setLayout(new BoxLayout(gradientOnPanel, 0));
        gradientOnPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.gradientOnCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Gradient.txt", (String)"Gradient"));
        gradientOnPanel.add(this.gradientOnCheckBox);
        gradientOnPanel.add(Box.createHorizontalGlue());
        colorPanel.add(statPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        colorPanel.add(outlinePanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        colorPanel.add(gradientOnPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        return colorPanel;
    }

    protected JPanel makeBinPanel() {
        JPanel binPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinPanel.txt", (String)"Bins"));
        binPanel.setBorder(border);
        binPanel.setLayout(new BoxLayout(binPanel, 1));
        JPanel missingBinPanel = new JPanel();
        missingBinPanel.setLayout(new BoxLayout(missingBinPanel, 1));
        this.missingBinCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.MissingBin.txt", (String)"Show Missing Bin"));
        missingBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        missingBinPanel.add(this.missingBinCheckBox);
        missingBinPanel.add(Box.createHorizontalGlue());
        JPanel xBinPanel = new JPanel();
        xBinPanel.setLayout(new BoxLayout(xBinPanel, 0));
        this.xBinCombo = new JComboBox();
        this.xBinCombo.setEditable(true);
        this.makeBinCombo(this.xBinCombo);
        this.xBinCombo.setPreferredSize(new Dimension(75, 25));
        this.discreteXCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.DiscreteX.txt", (String)"Horizontal Discrete"));
        xBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        xBinPanel.add(this.discreteXCheckBox);
        xBinPanel.add(Box.createHorizontalGlue());
        xBinPanel.add(this.xBinCombo);
        xBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel yBinPanel = new JPanel();
        yBinPanel.setLayout(new BoxLayout(yBinPanel, 0));
        this.yBinCombo = new JComboBox();
        this.yBinCombo.setEditable(true);
        this.makeBinCombo(this.yBinCombo);
        this.yBinCombo.setPreferredSize(new Dimension(75, 25));
        this.discreteYCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.DiscreteY.txt", (String)"Vertical Discrete"));
        yBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        yBinPanel.add(this.discreteYCheckBox);
        yBinPanel.add(Box.createHorizontalGlue());
        yBinPanel.add(this.yBinCombo);
        yBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel widthPanel = new JPanel();
        widthPanel.setLayout(new BoxLayout(widthPanel, 0));
        this.widthLabel = new JLabel();
        this.widthSlider = new JSlider();
        this.widthSlider.setMinimum(1);
        this.widthSlider.setMaximum(101);
        this.widthSlider.setExtent(1);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        widthPanel.add(this.widthLabel);
        widthPanel.add(Box.createHorizontalGlue());
        widthPanel.add(this.widthSlider);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        binPanel.add(missingBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(xBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(yBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        binPanel.add(widthPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        return binPanel;
    }

    private void makeBinCombo(JComboBox comb) {
        for (int i = 5; i <= 30; i += 5) {
            comb.addItem(Integer.toString(i));
        }
        comb.setPreferredSize(new Dimension(25, 25));
    }

    public void setInitialValues() {
        this.byScheme = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)809);
        if (this.byScheme) {
            this.byStatCheckBox.setEnabled(false);
        } else {
            this.byStatCheckBox.setEnabled(true);
            boolean byStat = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)820);
            if (byStat) {
                this.byStatCheckBox.setSelected(true);
            } else {
                this.byStatCheckBox.setSelected(false);
            }
        }
        boolean on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)803);
        if (on) {
            this.outlineCheckBox.setSelected(true);
        } else {
            this.outlineCheckBox.setSelected(false);
        }
        this.xBinCombo.setSelectedItem(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)805));
        this.xBins = this.xBinCombo.getSelectedItem().toString();
        this.discreteXCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)812));
        this.intervalAxisXCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)821));
        this.discreteYCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)813));
        if (((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)816)).booleanValue()) {
            this.discreteXCheckBox.setEnabled(true);
            if (this.discreteXCheckBox.isSelected()) {
                this.intervalAxisXCheckBox.setEnabled(true);
            } else {
                this.intervalAxisXCheckBox.setEnabled(false);
            }
        } else {
            this.discreteXCheckBox.setEnabled(false);
            this.intervalAxisXCheckBox.setEnabled(false);
        }
        if (!this.discreteXCheckBox.isEnabled() || ((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810)).booleanValue()) {
            this.xBinCombo.setEnabled(false);
            this.xBinCombo.setSelectedItem("");
        } else {
            this.xBinCombo.setEnabled(true);
            this.xBinCombo.setSelectedItem(this.xBins);
        }
        if (this.byScheme) {
            if (((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)817)).booleanValue()) {
                this.discreteYCheckBox.setEnabled(true);
            } else {
                this.discreteYCheckBox.setEnabled(false);
            }
            this.yBinCombo.setEnabled(true);
            this.yBinCombo.setSelectedItem(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)806));
            this.yBins = this.yBinCombo.getSelectedItem().toString();
            if (!this.discreteYCheckBox.isEnabled() || ((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)811)).booleanValue()) {
                this.yBinCombo.setEnabled(false);
                this.yBinCombo.setSelectedItem("");
            } else {
                this.yBinCombo.setEnabled(true);
                this.yBinCombo.setSelectedItem(this.yBins);
            }
            this.intervalAxisXCheckBox.setEnabled(false);
        } else {
            this.yBinCombo.setSelectedItem("");
            this.yBinCombo.setEnabled(false);
            this.discreteYCheckBox.setEnabled(false);
        }
        if (this.byScheme) {
            this.gradientOnCheckBox.setEnabled(false);
        } else {
            on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)819);
            this.gradientOnCheckBox.setEnabled(true);
            this.gradientOnCheckBox.setSelected(on);
        }
        double widthVal = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)804)).doubleValue();
        this.widthSlider.setValue((int)(widthVal * 100.0));
        this.sliderArgs[0] = new Double(widthVal);
        this.widthLabel.setText(MessageFormat.format(this.widthSliderPattern, this.sliderArgs));
        this.missingBinCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)807));
    }

    private void addListeners() {
        this.xBinCombo.addActionListener(this);
        this.yBinCombo.addActionListener(this);
        this.byStatCheckBox.addItemListener(this);
        this.outlineCheckBox.addItemListener(this);
        this.missingBinCheckBox.addItemListener(this);
        this.discreteXCheckBox.addItemListener(this);
        this.discreteYCheckBox.addItemListener(this);
        this.widthSlider.addChangeListener(this);
        this.gradientOnCheckBox.addItemListener(this);
        this.intervalAxisXCheckBox.addItemListener(this);
    }

    private void removeListeners() {
        this.xBinCombo.removeActionListener(this);
        this.yBinCombo.removeActionListener(this);
        this.byStatCheckBox.removeItemListener(this);
        this.outlineCheckBox.removeItemListener(this);
        this.missingBinCheckBox.removeItemListener(this);
        this.discreteXCheckBox.removeItemListener(this);
        this.discreteYCheckBox.removeItemListener(this);
        this.widthSlider.removeChangeListener(this);
        this.gradientOnCheckBox.removeItemListener(this);
        this.intervalAxisXCheckBox.removeItemListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block11: {
            Object source = evt.getSource();
            if (source == this.xBinCombo && !this.discreteXCheckBox.isSelected()) {
                try {
                    Object obj = this.xBinCombo.getSelectedItem();
                    int bin = 0;
                    if (obj != null) {
                        bin = Integer.parseInt(this.xBinCombo.getSelectedItem().toString());
                    }
                    if (bin > 0) {
                        PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)805, (Object)new Integer(bin));
                        break block11;
                    }
                    this.xBinCombo.setSelectedItem(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)805));
                }
                catch (NumberFormatException obj) {}
            } else if (source == this.yBinCombo && !this.discreteYCheckBox.isSelected() && ((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)809)).booleanValue()) {
                try {
                    int bin = Integer.parseInt(this.yBinCombo.getSelectedItem().toString());
                    if (bin > 0) {
                        PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)806, (Object)new Integer(bin));
                    } else {
                        this.yBinCombo.setSelectedItem(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)806));
                    }
                }
                catch (NumberFormatException e) {
                    this.yBinCombo.setSelectedItem(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)806));
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.intervalAxisXCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)821, (Object)new Boolean(on));
        }
        if (source == this.byStatCheckBox) {
            if (on) {
                if (!this.byScheme) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)820, (Object)new Boolean(true));
                }
            } else {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)820, (Object)new Boolean(false));
            }
            if (this.colorMapperChooserPanel != null) {
                this.colorMapperChooserPanel.initFromSource();
            }
        }
        if (source == this.outlineCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)803, (Object)new Boolean(on));
        }
        if (source == this.missingBinCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)807, (Object)new Boolean(on));
        }
        if (source == this.discreteXCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)812, (Object)new Boolean(on));
            if (on) {
                this.xBins = this.xBinCombo.getSelectedItem().toString();
                this.xBinCombo.setEnabled(false);
                this.xBinCombo.setSelectedItem("");
                if (this.byScheme) {
                    this.intervalAxisXCheckBox.setEnabled(false);
                } else {
                    this.intervalAxisXCheckBox.setEnabled(true);
                }
            } else {
                this.xBinCombo.setEnabled(true);
                this.xBinCombo.setSelectedItem(this.xBins);
                this.intervalAxisXCheckBox.setEnabled(false);
            }
        }
        if (source == this.discreteYCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)813, (Object)new Boolean(on));
            if (on) {
                this.yBins = this.yBinCombo.getSelectedItem().toString();
                this.yBinCombo.setEnabled(false);
                this.yBinCombo.setSelectedItem("");
            } else {
                this.yBinCombo.setEnabled(true);
                this.yBinCombo.setSelectedItem(this.yBins);
            }
        }
        if (source == this.gradientOnCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)819, (Object)new Boolean(on));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.widthSlider) {
            int wt = this.widthSlider.getValue();
            this.sliderArgs[0] = new Double((double)wt / 100.0);
            this.widthLabel.setText(MessageFormat.format(this.widthSliderPattern, this.sliderArgs));
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)804, (Object)new Double((double)wt / 100.0));
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }
}

