/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.AxisPanel2;
import com.sas.graphics.silk.ui.LegendPanel2;
import com.sas.graphics.silk.ui.NoPropertiesLabel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GraphPropertiesDialog
extends JDialog {
    private static final long serialVersionUID = 6593529945450285617L;
    public static final String ROOT_NODE_GRAPH = "Graph";
    public static final String ROOT_NODE_CHART = "Chart";
    public static final String ROOT_NODE_AXIS = "Axis";
    public static final String ROOT_NODE_TITLE = "Title";
    public static final String ROOT_NODE_LEGEND = "Legend";
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private PropertiesTreeNode root = new PropertiesTreeNode("");
    private JScrollPane jScrollPane1 = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JButton jButton2 = null;
    private NoPropertiesLabel noPropertiesLabel = new NoPropertiesLabel();
    protected Vector listeners = new Vector();

    public GraphPropertiesDialog(Frame parentFrame, String title) {
        super(parentFrame, title, true);
        this.initialize();
        UIUtilities.center(this, parentFrame);
    }

    public GraphPropertiesDialog(Dialog parentDialog, String title) {
        super(parentDialog, title, true);
        this.initialize();
        UIUtilities.center(this, parentDialog);
    }

    public void updateAxesPanels(PropertyInterface chart, Object listener) {
        if (chart == null) {
            return;
        }
        Object obj = chart.getPropertyValue(44);
        Object obj1 = chart.getPropertyValue(45);
        if (Extract.getNumberItems((Object)obj, (int)Extract.getSourceType((Object)obj)) == 0) {
            this.removeRootNode(ROOT_NODE_AXIS);
            return;
        }
        PropertiesTreeNode rootNode = this.getRootNode(ROOT_NODE_AXIS, true);
        rootNode.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPropertiesDialog.Axes.txt", (String)"Axes"));
        int equated = 0;
        Object eq = chart.getPropertyValue(61);
        if (eq instanceof Number) {
            equated = ((Number)eq).intValue();
        }
        AxisPanel2 panel = null;
        if (!(rootNode.getPanel() instanceof AxisPanel2)) {
            panel = new AxisPanel2();
            panel.setEquated(equated != 0);
            rootNode.setPanel(panel);
        } else {
            panel = (AxisPanel2)rootNode.getPanel();
            panel.removeAllPropertyListeners();
        }
        if (listener instanceof PropertyInterface) {
            panel.addPropertyListener((PropertyInterface)listener);
        }
        Enumeration e = Extract.elements((Object)obj);
        Enumeration displayNames = Extract.elements((Object)obj1);
        Hashtable<Object, TreeNode> existing = new Hashtable<Object, TreeNode>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            existing.put(((PropertiesTreeNode)rootNode.getChildAt(i)).getName(), rootNode.getChildAt(i));
        }
        rootNode.removeAllChildren();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object displayName = displayNames.nextElement();
            chart.setPropertyValue(238, name);
            Object l = chart.getPropertyValue(238);
            PropertiesTreeNode child = (PropertiesTreeNode)existing.get(name);
            if (child == null) {
                child = rootNode.createChild(name);
                child.setDisplayName(displayName.toString());
                AxisPanel2 ap = new AxisPanel2();
                if (chart instanceof JComponent) {
                    ap.setComponent((JComponent)chart);
                }
                if (listener == null && l instanceof PropertyInterface) {
                    ap.addPropertyListener((PropertyInterface)l);
                    panel.addPropertyListener((PropertyInterface)l);
                }
                if (listener instanceof PropertyInterface) {
                    ap.addPropertyListener((PropertyInterface)listener);
                }
                child.setPanel(ap);
                continue;
            }
            if (listener == null && l instanceof PropertyInterface) {
                panel.addPropertyListener((PropertyInterface)l);
            }
            rootNode.add(child);
        }
    }

    public void updateLegendPanels(PropertyInterface chart, Object listener) {
        LegendPanel2 p;
        if (chart == null) {
            return;
        }
        Object obj = chart.getPropertyValue(24);
        Object obj1 = chart.getPropertyValue(25);
        if (Extract.getNumberItems((Object)obj, (int)Extract.getSourceType((Object)obj)) == 0) {
            this.removeRootNode(ROOT_NODE_LEGEND);
            this.refreshTree();
            return;
        }
        PropertiesTreeNode node = this.getRootNode(ROOT_NODE_LEGEND, true);
        node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPropertiesDialog.Legend.txt", (String)ROOT_NODE_LEGEND));
        if (!(node.getPanel() instanceof LegendPanel2)) {
            p = new LegendPanel2();
            if (chart instanceof JComponent) {
                p.setComponent((JComponent)chart);
            }
            node.setPanel(p);
        } else {
            p = (LegendPanel2)node.getPanel();
            p.removeAllPropertyListeners();
        }
        if (listener instanceof PropertyInterface) {
            p.addPropertyListener((PropertyInterface)listener);
        }
        Enumeration e = Extract.elements((Object)obj);
        Enumeration displayNames = Extract.elements((Object)obj1);
        Hashtable<Object, TreeNode> existing = new Hashtable<Object, TreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            existing.put(((PropertiesTreeNode)node.getChildAt(i)).getName(), node.getChildAt(i));
        }
        node.removeAllChildren();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object displayName = displayNames.nextElement();
            chart.setPropertyValue(23, name);
            Object l = chart.getPropertyValue(59);
            PropertiesTreeNode child = (PropertiesTreeNode)existing.get(name);
            if (child == null) {
                child = node.createChild(name);
                child.setDisplayName(displayName.toString());
                LegendPanel2 lp = new LegendPanel2();
                if (chart instanceof JComponent) {
                    lp.setComponent((JComponent)chart);
                }
                if (listener == null && l instanceof PropertyInterface) {
                    lp.addPropertyListener((PropertyInterface)l);
                    p.addPropertyListener((PropertyInterface)l);
                }
                if (listener instanceof PropertyInterface) {
                    lp.addPropertyListener((PropertyInterface)listener);
                }
                child.setPanel(lp);
                continue;
            }
            if (listener == null && l instanceof PropertyInterface) {
                p.addPropertyListener((PropertyInterface)l);
            }
            node.add(child);
        }
    }

    private void initialize() {
        this.setSize(536, 535);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphPropertiesDialog.this.fireTabPanelEvents(GraphPropertiesDialog.this.root, true);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jContentPane.add((Component)this.getJPanel(), "West");
            this.jContentPane.add((Component)this.getJPanel4(), "Center");
            this.jContentPane.add((Component)this.getJPanel7(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.add((Component)this.getJPanel6(), "Center");
        }
        return this.jPanel4;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new BorderLayout());
            this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jPanel6.add((Component)this.getJScrollPane1(), "Center");
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(flowLayout);
            this.jPanel7.add((Component)this.getJButton(), null);
            this.jPanel7.add((Component)this.getJButton2(), null);
            this.jPanel7.add((Component)this.getJButton1(), null);
        }
        return this.jPanel7;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setFont(UIUtilities.getSILKDialogFont());
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphPropertiesDialog.this.fireTabPanelEvents(GraphPropertiesDialog.this.root, false);
                    GraphPropertiesDialog.this.setVisible(false);
                }
            });
            this.jButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPropertiesDialog.OK.txt", (String)"OK"));
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPropertiesDialog.Cancel.txt", (String)"Cancel"));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphPropertiesDialog.this.fireTabPanelEvents(GraphPropertiesDialog.this.root, true);
                    GraphPropertiesDialog.this.setVisible(false);
                }
            });
            this.jButton1.setFont(UIUtilities.getSILKDialogFont());
        }
        return this.jButton1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree(new DefaultTreeModel(this.root));
            this.jTree.putClientProperty("JTree.lineStyle", "None");
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
            renderer.setLeafIcon(null);
            renderer.setClosedIcon(null);
            renderer.setOpenIcon(null);
            this.jTree.setRootVisible(false);
            this.jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                    throw new ExpandVetoException(event);
                }

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath selection = e.getPath();
                    if (selection.getLastPathComponent() instanceof PropertiesTreeNode) {
                        PropertiesTreeNode node = (PropertiesTreeNode)selection.getLastPathComponent();
                        if (node.getName().equals(GraphPropertiesDialog.ROOT_NODE_AXIS)) {
                            PropertyUtils.setPropertyValue((Vector)GraphPropertiesDialog.this.listeners, (int)238, (Object)"ALL");
                        } else if (node.getParent() != null && ((PropertiesTreeNode)node.getParent()).getName().equals(GraphPropertiesDialog.ROOT_NODE_AXIS)) {
                            PropertyUtils.setPropertyValue((Vector)GraphPropertiesDialog.this.listeners, (int)238, (Object)node.getName());
                        } else {
                            PropertiesTreeNode parent = (PropertiesTreeNode)node.getParent();
                            if (parent != null && GraphPropertiesDialog.ROOT_NODE_LEGEND.equals(parent.getName())) {
                                PropertyUtils.setPropertyValue((Vector)GraphPropertiesDialog.this.listeners, (int)23, (Object)node.getName());
                            }
                        }
                        if (node.getPanel() != null) {
                            GraphPropertiesDialog.this.getJScrollPane1().setViewportView(node.getPanel());
                        } else {
                            GraphPropertiesDialog.this.getJScrollPane1().setViewportView(GraphPropertiesDialog.this.noPropertiesLabel);
                        }
                        if (node.getPanel() != null) {
                            node.getPanel().setVisible(true);
                        }
                        GraphPropertiesDialog.this.setTitle(ResourceLoader.getResourceString((Object)GraphPropertiesDialog.this.rb, (String)"GraphPropertiesDialog.Properties.txt", (String)"Properties") + " - " + node.getDisplayName());
                    }
                }
            });
            this.jTree.setPreferredSize(new Dimension(150, 200));
        }
        return this.jTree;
    }

    public void setSelectedNode(Object name) {
        PropertiesTreeNode node = this.getRootNode(name, false);
        if (node == null) {
            return;
        }
        this.jTree.setSelectionPath(new TreePath(node.getPath()));
    }

    public PropertiesTreeNode addRootNode(Object name, Component panel) {
        PropertiesTreeNode node = this.getRootNode(name, true);
        node.setPanel(panel);
        return node;
    }

    public void refreshTree() {
        PropertiesTreeNode node;
        TreePath path;
        TreePath selection = this.jTree.getSelectionPath();
        DefaultTreeModel dtm = (DefaultTreeModel)this.jTree.getModel();
        dtm.reload();
        ((DefaultTreeModel)this.getJTree().getModel()).nodeStructureChanged(this.root);
        this.expandAll(this.getJTree(), new TreePath(this.root), true);
        if (selection != null) {
            boolean setSelectPath = false;
            if (dtm.isLeaf(selection.getLastPathComponent()) && !this.jTree.isCollapsed(selection.getParentPath())) {
                setSelectPath = true;
            } else if (!dtm.isLeaf(selection.getLastPathComponent()) && !this.jTree.isCollapsed(selection)) {
                setSelectPath = true;
            }
            if (setSelectPath) {
                this.jTree.setSelectionPath(selection);
            }
        }
        if ((path = this.jTree.getSelectionPath()) == null) {
            if (this.getRootNode(ROOT_NODE_CHART, false) != null) {
                this.jTree.setSelectionPath(new TreePath(this.getRootNode(ROOT_NODE_CHART, false).getPath()));
            } else {
                this.jTree.setSelectionPath(new TreePath(new Object[]{this.root, this.root.getChildAt(0)}));
            }
        } else if (path.getLastPathComponent() instanceof PropertiesTreeNode && (node = (PropertiesTreeNode)path.getLastPathComponent()).getPanel() != null) {
            node.getPanel().setVisible(true);
        }
    }

    public PropertiesTreeNode getRootNode(Object name, boolean create) {
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            PropertiesTreeNode node = (PropertiesTreeNode)e.nextElement();
            if (!node.getName().equals(name)) continue;
            return node;
        }
        if (!create) {
            return null;
        }
        PropertiesTreeNode rc = new PropertiesTreeNode(name);
        this.root.add(rc);
        ((DefaultTreeModel)this.getJTree().getModel()).nodeStructureChanged(this.root);
        return rc;
    }

    public void removeRootNode(Object name) {
        PropertiesTreeNode node = this.getRootNode(name, false);
        if (node != null) {
            this.root.remove(node);
        }
    }

    public PropertiesTreeNode getSelectedNode() {
        TreePath path = this.getJTree().getSelectionPath();
        if (path.getLastPathComponent() instanceof PropertiesTreeNode) {
            return (PropertiesTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jScrollPane1;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshTree();
        }
        super.setVisible(b);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setFont(UIUtilities.getSILKDialogFont());
            this.jButton2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPropertiesDialog.Apply.txt", (String)"Apply"));
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphPropertiesDialog.this.fireTabPanelEvents(GraphPropertiesDialog.this.root, false);
                }
            });
        }
        return this.jButton2;
    }

    private void fireTabPanelEvents(PropertiesTreeNode node, boolean cancel) {
        if (node == null) {
            return;
        }
        TreePath selection = this.jTree.getSelectionPath();
        if (node.getPanel() instanceof TabPanelInterface) {
            if (cancel) {
                ((TabPanelInterface)((Object)node.getPanel())).cancelChanges();
            } else {
                ((TabPanelInterface)((Object)node.getPanel())).applyChanges();
            }
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode n = e.nextElement();
            if (!(n instanceof PropertiesTreeNode)) continue;
            this.fireTabPanelEvents((PropertiesTreeNode)n, cancel);
        }
        if (selection != null) {
            this.jTree.setSelectionPath(selection);
        }
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(prop);
        return true;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    public class PropertiesTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -5683138470556427327L;
        private Object name;
        private String displayName = null;
        private Component panel = null;

        private PropertiesTreeNode(Object name) {
            this.name = name;
        }

        public PropertiesTreeNode createChild(Object name) {
            PropertiesTreeNode node = new PropertiesTreeNode(name);
            this.add(node);
            ((DefaultTreeModel)GraphPropertiesDialog.this.getJTree().getModel()).nodeStructureChanged(GraphPropertiesDialog.this.root);
            GraphPropertiesDialog.this.expandAll(GraphPropertiesDialog.this.getJTree(), new TreePath(GraphPropertiesDialog.this.root), true);
            return node;
        }

        public void addChild(PropertiesTreeNode node) {
            this.add(node);
            ((DefaultTreeModel)GraphPropertiesDialog.this.getJTree().getModel()).nodeStructureChanged(GraphPropertiesDialog.this.root);
            GraphPropertiesDialog.this.expandAll(GraphPropertiesDialog.this.getJTree(), new TreePath(GraphPropertiesDialog.this.root), true);
        }

        public PropertiesTreeNode getChild(Object name) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                PropertiesTreeNode node = (PropertiesTreeNode)this.getChildAt(i);
                if (!node.getName().equals(name)) continue;
                return node;
            }
            return null;
        }

        public void removeChild(Object name) {
            PropertiesTreeNode node = this.getChild(name);
            if (node != null) {
                this.remove(node);
            }
        }

        public Object getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                return this.getName().toString();
            }
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String toString() {
            return this.getDisplayName();
        }

        public Component getPanel() {
            return this.panel;
        }

        public void setPanel(Component panel) {
            this.panel = panel;
        }
    }
}

