/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.CenteredHorizontalSeparator;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.ToolPallet;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.StylePreviewPanel;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel
implements TabPanelInterface,
ActionListener {
    private static final long serialVersionUID = -6551967265867222420L;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    Vector listeners = new Vector();
    private StylePreviewPanel stylePreviewPanel = null;
    private JPanel jPanel = null;
    private JCheckBox jCheckBox = null;
    private JPanel jPanel1 = null;
    private JPanel palletPanel = null;
    private JPanel palletTitlePanel = null;
    private JPanel palletContentPanel = null;
    private JLabel palletTitleLabel = null;
    private CenteredHorizontalSeparator palletSeparator = null;
    private JCheckBox palletCheckBox = null;
    private JComboBox palletComboBox = null;
    private int[] palletPositions;

    public GraphPanel() {
        this(null, null);
    }

    public GraphPanel(PropertyInterface graph, PropertyInterface tip) {
        this.addPropertyListener(graph);
        this.initialize();
        this.initFromSource();
        this.jCheckBox.addActionListener(this);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.initFromSource();
        }
    }

    private void initFromSource() {
        Object b = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)2);
        if (b == null || !(b instanceof Boolean)) {
            this.getJCheckBox().setSelected(true);
        } else {
            this.getJCheckBox().setSelected((Boolean)b);
        }
        this.getStylePreviewPanel().reload();
        Object obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)69);
        if (obj != null && obj instanceof Boolean) {
            this.getPalletCheckBox().setSelected((Boolean)obj);
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)68)) != null && obj instanceof String) {
            this.getPalletComboBox().setSelectedItem((String)obj);
        }
        this.getPalletComboBox().setEnabled(this.getPalletCheckBox().isSelected());
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(486, 391);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getJPanel1(), "Center");
        this.add((Component)this.getJPanel(), "South");
    }

    private StylePreviewPanel getStylePreviewPanel() {
        if (this.stylePreviewPanel == null) {
            this.stylePreviewPanel = new StylePreviewPanel((StyleCollection)SILKGlobal.getInstance().getPropertyValue(48), false);
            this.stylePreviewPanel.setPreferredSize(new Dimension(250, 100));
            this.stylePreviewPanel.getStyleSelectorCombo().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SILKGlobal.getInstance().setPropertyValue(29, GraphPanel.this.stylePreviewPanel.getStyleSelectorCombo().getSelectedItem());
                }
            });
        }
        return this.stylePreviewPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.jPanel.add((Component)this.getJCheckBox(), "North");
        }
        return this.jPanel;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPanel.Show_chart_tips.txt", (String)"Show chart tips"));
            this.jCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.jCheckBox;
    }

    @Override
    public boolean applyChanges() {
        SILKGlobal.getInstance().applyPropertyChanges(this);
        if (this.listeners == null || this.listeners.isEmpty()) {
            return false;
        }
        boolean rc = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            rc |= ((PropertyInterface)this.listeners.elementAt(i)).applyPropertyChanges();
        }
        this.initFromSource();
        return rc;
    }

    @Override
    public boolean cancelChanges() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).cancelPropertyChanges();
        }
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        Object scrollBarsVisible;
        if (prop == null || this.listeners != null && this.listeners.contains(prop)) {
            return false;
        }
        this.listeners.addElement(prop);
        if (this.listeners.size() == 1 && (scrollBarsVisible = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)71)) != null && scrollBarsVisible instanceof Boolean && ((Boolean)scrollBarsVisible).booleanValue()) {
            this.getJPanel().add((Component)this.getPalletPanel(), "South");
        }
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.listeners == null) {
            return;
        }
        Object source = ae.getSource();
        if (source == this.jCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)2, (Object)new Boolean(this.jCheckBox.isSelected()));
        } else if (source == this.getPalletCheckBox()) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)69, (Object)new Boolean(this.getPalletCheckBox().isSelected()));
            this.getPalletComboBox().setEnabled(this.getPalletCheckBox().isSelected());
        } else if (source == this.getPalletComboBox()) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)68, (Object)new Integer(this.palletPositions[this.getPalletComboBox().getSelectedIndex()]));
        }
    }

    public void addChart(PropertyInterface chart) {
        if (chart != null && !this.listeners.contains(chart)) {
            this.listeners.addElement(chart);
        }
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            String title = ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPanel.Style.txt", (String)"Style");
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0, UIUtilities.getSILKDialogFont(), null));
            this.jPanel1.add((Component)this.getStylePreviewPanel(), "Center");
        }
        return this.jPanel1;
    }

    private JPanel getPalletPanel() {
        if (this.palletPanel == null) {
            this.palletPanel = new JPanel();
            this.palletPanel.setLayout(new BorderLayout());
            this.palletPanel.add((Component)this.getPalletTitlePanel(), "North");
            this.palletPanel.add((Component)this.getPalletContentPanel(), "Center");
        }
        return this.palletPanel;
    }

    private JPanel getPalletTitlePanel() {
        if (this.palletTitlePanel == null) {
            this.palletTitleLabel = new JLabel();
            this.palletTitleLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPanel.ToolPallet.txt", (String)"Tool Pallet"));
            this.palletTitleLabel.setFont(UIUtilities.getSILKDialogFont());
            this.palletTitlePanel = new JPanel();
            this.palletTitlePanel.setLayout(new BorderLayout());
            this.palletTitlePanel.add((Component)this.palletTitleLabel, "West");
            this.palletTitlePanel.add((Component)this.getPalletSeparator(), "Center");
        }
        return this.palletTitlePanel;
    }

    private JPanel getPalletContentPanel() {
        if (this.palletContentPanel == null) {
            this.palletContentPanel = new JPanel();
            this.palletContentPanel.setLayout(new BorderLayout());
            this.palletContentPanel.add((Component)this.getPalletCheckBox(), "North");
            this.palletContentPanel.add((Component)this.getPalletComboBox(), "Center");
        }
        return this.palletContentPanel;
    }

    private CenteredHorizontalSeparator getPalletSeparator() {
        if (this.palletSeparator == null) {
            this.palletSeparator = new CenteredHorizontalSeparator();
        }
        return this.palletSeparator;
    }

    private JCheckBox getPalletCheckBox() {
        if (this.palletCheckBox == null) {
            this.palletCheckBox = new JCheckBox();
            this.palletCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphPanel.PalletVisible.txt", (String)"Pallet Visible"));
            this.palletCheckBox.setFont(UIUtilities.getSILKDialogFont());
            this.palletCheckBox.addActionListener(this);
        }
        return this.palletCheckBox;
    }

    private JComboBox getPalletComboBox() {
        if (this.palletComboBox == null) {
            this.palletComboBox = new JComboBox();
            this.palletComboBox.setBackground(Color.white);
            this.palletComboBox.setFont(UIUtilities.getSILKDialogFont());
            this.palletPositions = new int[8];
            this.palletPositions[0] = -1000088;
            this.palletComboBox.addItem(ToolPallet.getStringPosition(-1000088));
            this.palletPositions[1] = -1000089;
            this.palletComboBox.addItem(ToolPallet.getStringPosition(-1000089));
            this.palletPositions[2] = -1000090;
            this.palletComboBox.addItem(ToolPallet.getStringPosition(-1000090));
            this.palletComboBox.addActionListener(this);
        }
        return this.palletComboBox;
    }
}

