/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FontPanel
extends JPanel
implements ListSelectionListener,
KeyListener {
    private static final long serialVersionUID = 2117586111397005161L;
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static String[] fonts = ge.getAvailableFontFamilyNames();
    JTextField fontField = new JTextField();
    JTextField styleField = new JTextField();
    JTextField sizeField = new JTextField();
    JList fontList = new JList<String>(fonts);
    JList styleList = new JList();
    JList sizeList = new JList();
    TextDialog textDialog = null;
    PropertyInterface source = null;
    ResourceBundle rb = null;

    public FontPanel(TextDialog dialog, ResourceBundle res) {
        this.textDialog = dialog;
        this.rb = res;
        this.setLayout(null);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Font.txt", (String)"Font"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 10, 90, 20);
        this.add(label);
        this.fontField.setFont(TabbedPropertiesDialog.dialogFont);
        this.fontField.setBounds(10, 30, 210, 20);
        this.fontField.setEditable(false);
        this.add(this.fontField);
        JScrollPane scroll = new JScrollPane(this.fontList);
        this.fontList.setFont(TabbedPropertiesDialog.dialogFont);
        this.fontList.addListSelectionListener(this);
        scroll.setBounds(10, 50, 210, 165);
        this.add(scroll);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Font_style.txt", (String)"Font style"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(230, 10, 110, 20);
        this.add(label);
        this.styleField.setFont(TabbedPropertiesDialog.dialogFont);
        this.styleField.setBounds(230, 30, 110, 20);
        this.styleField.setEditable(false);
        this.add(this.styleField);
        String[] styles = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Plain.txt", (String)"Plain"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Italic.txt", (String)"Italic"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold.txt", (String)"Bold"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold_Italic.txt", (String)"Bold Italic")};
        this.styleList.setListData(styles);
        scroll = new JScrollPane(this.styleList);
        this.styleList.setFont(TabbedPropertiesDialog.dialogFont);
        this.styleList.addListSelectionListener(this);
        scroll.setBounds(230, 50, 110, 165);
        this.add(scroll);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Size.txt", (String)"Size"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(350, 10, 65, 20);
        this.add(label);
        this.sizeField.setFont(TabbedPropertiesDialog.dialogFont);
        this.sizeField.addKeyListener(this);
        this.sizeField.setBounds(350, 30, 90, 20);
        this.add(this.sizeField);
        String[] sizes = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.6.txt", (String)"6"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.8.txt", (String)"8"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.9.txt", (String)"9"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.10.txt", (String)"10"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.11.txt", (String)"11"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.12.txt", (String)"12"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.14.txt", (String)"14"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.16.txt", (String)"16"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.18.txt", (String)"18"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.24.txt", (String)"24"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.32.txt", (String)"32"), ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.64.txt", (String)"64")};
        this.sizeList.setListData(sizes);
        scroll = new JScrollPane(this.sizeList);
        this.sizeList.setFont(TabbedPropertiesDialog.dialogFont);
        this.sizeList.addListSelectionListener(this);
        scroll.setBounds(350, 50, 90, 165);
        this.add(scroll);
    }

    @Override
    public Font getFont() {
        if (this.fontField == null) {
            return null;
        }
        String name = this.fontField.getText();
        int style = this.getFontStyle();
        int size = -1;
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception exception) {
            size = 12;
        }
        return FontManager.getFont((String)name, (int)style, (int)size);
    }

    private int getFontStyle() {
        String string = this.styleField.getText();
        int rc = 0;
        if (string.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold.txt", (String)"Bold"))) {
            rc = 1;
        } else if (string.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Italic.txt", (String)"Italic"))) {
            rc = 2;
        } else if (string.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold_Italic.txt", (String)"Bold Italic"))) {
            rc = 3;
        }
        return rc;
    }

    public void init(PropertyInterface source) {
        this.source = source;
        this.fontList.removeListSelectionListener(this);
        this.styleList.removeListSelectionListener(this);
        this.sizeList.removeListSelectionListener(this);
        Object object = null;
        if (source != null) {
            object = source.getPropertyValue(9002);
        }
        if (object == null) {
            object = FontManager.getFont((String)"SansSerif", (int)0, (int)12);
        }
        if (object != null && object instanceof Font) {
            Font font = (Font)object;
            this.fontList.setSelectedValue(font.getFamily(), true);
            this.fontField.setText(font.getFamily());
            int style = font.getStyle();
            if (style == 0) {
                this.styleList.setSelectedValue(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Plain.txt", (String)"Plain"), true);
            } else if (style == 1) {
                this.styleList.setSelectedValue(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold.txt", (String)"Bold"), true);
            } else if (style == 2) {
                this.styleList.setSelectedValue(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Italic.txt", (String)"Italic"), true);
            } else if (style == 3) {
                this.styleList.setSelectedValue(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Bold_Italic.txt", (String)"Bold Italic"), true);
            }
            this.styleField.setText(this.styleList.getSelectedValue().toString());
            this.sizeList.getSelectionModel().clearSelection();
            this.sizeList.setSelectedValue(font.getSize() + "", true);
            this.sizeField.setText(font.getSize() + "");
        }
        this.fontList.addListSelectionListener(this);
        this.styleList.addListSelectionListener(this);
        this.sizeList.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fontField.setText(this.fontList.getSelectedValue().toString());
        this.styleField.setText(this.styleList.getSelectedValue().toString());
        if (e.getSource() == this.sizeList && this.sizeList.getSelectedValue() != null) {
            this.sizeField.setText(this.sizeList.getSelectedValue().toString());
        }
        Font font = this.getFont();
        this.source.setPropertyValue(9002, (Object)new PropertyEvent(9002, (Object)this.textDialog, (Object)font));
        this.textDialog.textChanged();
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        Font font = this.getFont();
        this.source.setPropertyValue(9002, (Object)new PropertyEvent(9002, (Object)this.textDialog, (Object)font));
        this.sizeList.getSelectionModel().clearSelection();
        this.sizeList.repaint();
        this.textDialog.textChanged();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

