/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.RoleSelectionTable;
import com.sas.graphics.silk.ui.RoleSelector;
import com.sas.graphics.silk.ui.SortPanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.ui.WherePanel;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataOptionsDialog
extends JDialog
implements TreeCellRenderer {
    private static final long serialVersionUID = 4389559406128411280L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel treePanel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel roleSelectionPanel = null;
    private JPanel wherePanel = null;
    private JPanel sortPanel = null;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private JButton jButton = null;
    private DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
    private DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
    private Hashtable roleSelectionTables = new Hashtable();
    private Hashtable wherePanels = new Hashtable();
    private Hashtable sortPanes = new Hashtable();
    private Hashtable roleSelectors = new Hashtable();
    private JPanel jPanel = null;
    private JCheckBox jCheckBox = null;
    private JSplitPane jSplitPane = null;
    private boolean firstTime = true;
    private JPanel roleSelectorPanel = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private Hashtable disableReassignmentRoles = new Hashtable();
    private final String defaultDataID = "__DEFAULT_DATA_ID__";
    private Hashtable actions = new Hashtable();

    public DataOptionsDialog(Frame parent) {
        super(parent);
        this.initialize();
    }

    public DataOptionsDialog(Dialog parent) {
        super(parent);
        this.initialize();
    }

    public DataOptionsDialog(RoleInterface chart, JComponent component, Frame frame) {
        this(frame);
        this.addChart(chart);
    }

    @Override
    public void setVisible(boolean b) {
        TreeNode node;
        if (b && this.firstTime) {
            if (this.treeRoot.getChildCount() == 1 && (node = (DefaultMutableTreeNode)this.treeRoot.getChildAt(0)) != null && ((DefaultMutableTreeNode)node).getChildCount() == 0) {
                this.getJSplitPane().setLastDividerLocation(150);
                this.getJSplitPane().setDividerLocation(0);
            }
            this.firstTime = false;
        }
        if (this.jTree.getSelectionCount() == 0) {
            node = this.treeRoot;
            while (node.getChildCount() > 0) {
                node = node.getChildAt(0);
            }
            this.jTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node).getPath()));
        }
        if (this.getCurrentRoleSelectionTable() != null) {
            this.getCurrentRoleSelectionTable().stopEditing();
        }
        super.setVisible(b);
    }

    private void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void addChart(RoleInterface chart) {
        Object[] dataids = chart.getDataIds();
        if (dataids == null) {
            this.treeRoot.add(new DefaultMutableTreeNode(chart));
            if (this.treeRoot.getChildCount() == 1) {
                this.jTree.setSelectionRow(0);
            }
        } else {
            DefaultMutableTreeNode chartNode = new DefaultMutableTreeNode(chart);
            for (int i = 0; i < dataids.length; ++i) {
                if (chart.getDataSource(dataids[i]) == null) continue;
                chartNode.add(new DefaultMutableTreeNode(dataids[i]));
            }
            this.treeRoot.add(chartNode);
            if (chartNode.getChildCount() >= 1) {
                this.jTree.setSelectionRow(1);
            }
        }
        this.jTree.setModel(new DefaultTreeModel(this.treeRoot));
        this.expandAll(this.jTree, true);
    }

    public void removeChart(RoleInterface chart) {
        for (int i = 0; i < this.treeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeRoot.getChildAt(i);
            if (!node.getUserObject().equals(chart)) continue;
            this.treeRoot.remove(node);
            ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(this.treeRoot);
            this.removeRoleReassignment(chart);
            return;
        }
    }

    public void removeAllCharts() {
        for (int i = this.treeRoot.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeRoot.getChildAt(i);
            this.treeRoot.remove(node);
        }
        ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(this.treeRoot);
    }

    private RoleSelectionTable getCurrentRoleSelectionTable() {
        TreePath path = this.jTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        RoleInterface ri = null;
        Object dataId = null;
        if (!(obj instanceof RoleInterface)) {
            dataId = obj;
        }
        while (!(obj instanceof RoleInterface) && node != null) {
            if ((node = (DefaultMutableTreeNode)node.getParent()) == null) continue;
            obj = node.getUserObject();
        }
        if (obj instanceof RoleInterface) {
            ri = (RoleInterface)obj;
        }
        if (dataId == null && ri != null && ri.getDataIds() != null) {
            dataId = ri.getDataIds()[0];
        }
        RoleSelectionTable rst = null;
        if (obj instanceof RoleInterface) {
            Object o = this.roleSelectionTables.get(obj);
            if (o instanceof RoleSelectionTable) {
                rst = (RoleSelectionTable)o;
            } else if (o instanceof Hashtable && dataId != null) {
                Hashtable ht = (Hashtable)o;
                rst = (RoleSelectionTable)ht.get(dataId);
            }
        }
        return rst;
    }

    private SortPanel getCurrentSortPanel() {
        TreePath path = this.jTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        RoleInterface ri = null;
        Object dataId = null;
        if (!(obj instanceof RoleInterface)) {
            dataId = obj;
        }
        while (!(obj instanceof RoleInterface) && node != null) {
            if ((node = (DefaultMutableTreeNode)node.getParent()) == null) continue;
            obj = node.getUserObject();
        }
        if (obj instanceof RoleInterface) {
            ri = (RoleInterface)obj;
        }
        if (dataId == null && ri != null && ri.getDataIds() != null) {
            dataId = ri.getDataIds()[0];
        }
        SortPanel rst = null;
        if (obj instanceof RoleInterface) {
            Object o = this.sortPanes.get(obj);
            if (o instanceof SortPanel) {
                rst = (SortPanel)o;
            } else if (o instanceof Hashtable && dataId != null) {
                Hashtable ht = (Hashtable)o;
                rst = (SortPanel)ht.get(dataId);
            }
        }
        return rst;
    }

    private void populateTabbedPane() {
        TreePath path = this.jTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        RoleInterface ri = null;
        Object obj = node.getUserObject();
        Object dataId = null;
        if (obj instanceof RoleInterface) {
            ri = (RoleInterface)obj;
        } else {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null && parent.getUserObject() instanceof RoleInterface) {
                ri = (RoleInterface)parent.getUserObject();
            }
            dataId = obj;
        }
        if (ri != null) {
            SortPanel sp = (SortPanel)this.sortPanes.get(ri);
            if (sp == null) {
                sp = new SortPanel(ri);
                this.sortPanes.put(ri, sp);
            }
            this.sortPanel.removeAll();
            this.sortPanel.add("Center", sp);
            this.getJTabbedPane().setEnabledAt(this.getJTabbedPane().indexOfComponent(this.sortPanel), ri.getSupportedSortableRoles() != null);
            Object[] dataIds = ri.getDataIds();
            if (dataIds != null && ri.getDataSource(dataIds[0]) == null) {
                for (int dataIdIdx = 0; dataIdIdx < dataIds.length; ++dataIdIdx) {
                    if (dataIds[dataIdIdx] == null || ri.getDataSource(dataIds[dataIdIdx]) == null) continue;
                    dataId = dataIds[dataIdIdx];
                    break;
                }
            }
            Object wp1 = this.wherePanels.get(ri);
            WherePanel wp = null;
            if (wp1 instanceof WherePanel) {
                wp = (WherePanel)wp1;
            } else if (wp1 instanceof Hashtable && dataId != null) {
                wp = (WherePanel)((Hashtable)wp1).get(dataId);
            }
            if (wp == null) {
                wp = new WherePanel();
                if (dataIds != null) {
                    if (dataId == null) {
                        dataId = ri.getDataIds()[0];
                    }
                    Hashtable<Object, WherePanel> h = null;
                    Object o = this.wherePanels.get(ri);
                    if (o != null && o instanceof Hashtable) {
                        h = (Hashtable<Object, WherePanel>)o;
                    }
                    if (h == null) {
                        h = new Hashtable<Object, WherePanel>();
                        this.wherePanels.put(ri, h);
                    }
                    if (ri instanceof BaseComponentInterface) {
                        wp.setData(((BaseComponentInterface)((Object)ri)).getFilter(dataId));
                    } else {
                        wp.setData(ri.getDataSource(dataId));
                    }
                    h.put(dataId, wp);
                } else {
                    wp.setData(ri);
                    this.wherePanels.put(ri, wp);
                }
                wp.init();
            }
            this.wherePanel.removeAll();
            this.wherePanel.add("Center", wp);
            Object rst1 = this.roleSelectionTables.get(ri);
            RoleSelectionTable rst = null;
            if (rst1 instanceof RoleSelectionTable) {
                rst = (RoleSelectionTable)rst1;
            } else if (rst1 instanceof Hashtable && dataId != null) {
                rst = (RoleSelectionTable)((Hashtable)rst1).get(dataId);
            }
            if (rst == null) {
                rst = new RoleSelectionTable(ri, null);
                rst.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        RoleSelectionTable rst = DataOptionsDialog.this.getCurrentRoleSelectionTable();
                        if (rst != null) {
                            DataOptionsDialog.this.updateMultipleCheckbox(rst.chart, rst);
                            DataOptionsDialog.this.getJTabbedPane().setEnabledAt(DataOptionsDialog.this.getJTabbedPane().indexOfComponent(DataOptionsDialog.this.sortPanel), rst.chart.getSupportedSortableRoles() != null);
                        }
                    }
                });
                if (dataIds != null) {
                    if (dataId == null) {
                        dataId = ri.getDataIds()[0];
                    }
                    Hashtable<Object, RoleSelectionTable> h = null;
                    Object o = this.roleSelectionTables.get(ri);
                    if (o != null && o instanceof Hashtable) {
                        h = (Hashtable<Object, RoleSelectionTable>)o;
                    }
                    if (h == null) {
                        h = new Hashtable<Object, RoleSelectionTable>();
                        this.roleSelectionTables.put(ri, h);
                    }
                    rst.setDataId(dataId);
                    h.put(dataId, rst);
                } else {
                    this.roleSelectionTables.put(ri, rst);
                }
                Vector v = this.getDisabledReassignmentRoles(ri, dataId);
                if (v != null) {
                    for (int i = 0; i < v.size(); ++i) {
                        rst.disableRoleReassignment(v.elementAt(i));
                    }
                }
                rst.initControlPanel(this.getActions(ri, dataId));
            }
            rst.setAllowMultipleRoleAssignment(false);
            this.roleSelectionPanel.removeAll();
            this.roleSelectionPanel.add("South", this.getJPanel());
            this.roleSelectionPanel.add("Center", rst);
            this.updateMultipleCheckbox(ri, rst);
            Object rs1 = this.roleSelectors.get(ri);
            RoleSelector rs = null;
            if (rs1 instanceof RoleSelector) {
                rs = (RoleSelector)rs1;
            } else if (rs1 instanceof Hashtable && dataId != null) {
                rs = (RoleSelector)((Hashtable)rs1).get(dataId);
            }
            if (rs == null) {
                rs = new RoleSelector(ri, null);
                if (dataIds != null) {
                    if (dataId == null) {
                        dataId = ri.getDataIds()[0];
                    }
                    Hashtable<Object, RoleSelector> h = null;
                    Object o = this.roleSelectors.get(ri);
                    if (o != null && o instanceof Hashtable) {
                        h = (Hashtable<Object, RoleSelector>)o;
                    }
                    if (h == null) {
                        h = new Hashtable<Object, RoleSelector>();
                        this.roleSelectors.put(ri, h);
                    }
                    rs.setDataId(dataId);
                    h.put(dataId, rs);
                } else {
                    this.roleSelectors.put(ri, rs);
                }
            }
            this.roleSelectorPanel.removeAll();
            this.roleSelectorPanel.add("Center", rs);
        }
    }

    private void updateMultipleCheckbox(RoleInterface ri, RoleSelectionTable rst) {
        if (!ri.supportsMultipleAssignments(null)) {
            this.getJCheckBox().setSelected(false);
            this.getJCheckBox().setEnabled(false);
        } else {
            this.getJCheckBox().setEnabled(true);
            Object[] roles = ri.getSupportedRoles(null, true);
            if (roles != null) {
                for (int i = 0; i < roles.length; ++i) {
                    Object vars = ri.getAllVariables(roles[i]);
                    int num = Extract.getNumberItems((Object)vars, (int)Extract.getSourceType((Object)vars));
                    if (num <= 1) continue;
                    this.getJCheckBox().setSelected(true);
                    rst.setAllowMultipleRoleAssignment(true);
                }
            }
        }
        if (ri.requiresMultipleRoleAssignments()) {
            this.getJCheckBox().setEnabled(false);
            this.getJCheckBox().setSelected(true);
        } else if (ri.supportsMultipleAssignments(null)) {
            this.getJCheckBox().setEnabled(true);
        }
    }

    private void initialize() {
        this.setSize(775, 402);
        String title = ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Data_Options_Dialog.txt", (String)"Data Options Dialog");
        this.setTitle(title);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        UIUtilities.center(this, this.getOwner());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getJButton(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new JPanel();
            this.treePanel.setLayout(new BorderLayout());
            this.treePanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.treePanel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setFont(TabbedPropertiesDialog.dialogFont);
            this.jTabbedPane.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Variables.txt", (String)"Variables"), null, this.getRoleSelectionPanel(), null);
            this.jTabbedPane.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Where.txt", (String)"Where"), null, this.getWherePanel(), null);
            this.jTabbedPane.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Sorting.txt", (String)"Sorting"), null, this.getSortPanel(), null);
            this.jTabbedPane.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Roles.txt", (String)"Roles"), null, this.getRoleSelectorPanel(), null);
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (DataOptionsDialog.this.jTabbedPane.getSelectedIndex() == 2) {
                        DataOptionsDialog.this.getCurrentSortPanel().setVisible(true);
                    }
                }
            });
        }
        return this.jTabbedPane;
    }

    private JPanel getRoleSelectionPanel() {
        if (this.roleSelectionPanel == null) {
            this.roleSelectionPanel = new JPanel();
            this.roleSelectionPanel.setLayout(new BorderLayout());
            this.roleSelectionPanel.add((Component)this.getJPanel(), "South");
        }
        return this.roleSelectionPanel;
    }

    private JPanel getWherePanel() {
        if (this.wherePanel == null) {
            this.wherePanel = new JPanel();
            this.wherePanel.setLayout(new BorderLayout());
        }
        return this.wherePanel;
    }

    private JPanel getSortPanel() {
        if (this.sortPanel == null) {
            this.sortPanel = new JPanel();
            this.sortPanel.setLayout(new BorderLayout());
        }
        return this.sortPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(150, 300));
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree(this.treeRoot);
            this.jTree.setCellRenderer(this);
            this.jTree.getSelectionModel().setSelectionMode(1);
            this.jTree.setShowsRootHandles(true);
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DataOptionsDialog.this.populateTabbedPane();
                    if (DataOptionsDialog.this.getCurrentRoleSelectionTable() != null) {
                        DataOptionsDialog.this.getCurrentRoleSelectionTable().stopEditing();
                    }
                    DataOptionsDialog.this.invalidate();
                    DataOptionsDialog.this.validate();
                    DataOptionsDialog.this.repaint();
                }
            });
            this.jTree.setRootVisible(false);
        }
        return this.jTree;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.jButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.OK.txt", (String)"OK"));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataOptionsDialog.this.setVisible(false);
                }
            });
        }
        return this.jButton;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)this.treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object chart = node.getUserObject();
        if (chart instanceof BaseComponentInterface) {
            BaseComponentInterface bci = (BaseComponentInterface)chart;
            if (bci.getId() != null) {
                label.setText(bci.getId().toString());
            } else {
                label.setText(bci.getClass().getName().substring(bci.getClass().getName().lastIndexOf(46)));
            }
        }
        return label;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout1);
            this.jPanel.add((Component)this.getJCheckBox(), null);
        }
        return this.jPanel;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.jCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"DataOptionsDialog.Allow_multiple_role_assignments.txt", (String)"Allow multiple role assignments"));
            this.jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataOptionsDialog.this.getCurrentRoleSelectionTable().setAllowMultipleRoleAssignment(DataOptionsDialog.this.jCheckBox.isSelected());
                }
            });
        }
        return this.jCheckBox;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(150);
            this.jSplitPane.setLeftComponent(this.getTreePanel());
            this.jSplitPane.setRightComponent(this.getJTabbedPane());
        }
        return this.jSplitPane;
    }

    private JPanel getRoleSelectorPanel() {
        if (this.roleSelectorPanel == null) {
            this.roleSelectorPanel = new JPanel();
            this.roleSelectorPanel.setLayout(new BorderLayout());
        }
        return this.roleSelectorPanel;
    }

    public void disableRoleReassignment(RoleInterface ri, Object dataId, Object role) {
        Object o = this.disableReassignmentRoles.get(ri);
        Hashtable h = null;
        if (o instanceof Hashtable) {
            h = (Hashtable)o;
        } else {
            h = new Hashtable();
            this.disableReassignmentRoles.put(ri, h);
        }
        Object id = dataId == null ? "__DEFAULT_DATA_ID__" : dataId;
        o = h.get(id);
        Vector<Object> v = null;
        if (o instanceof Vector) {
            v = (Vector<Object>)o;
        } else {
            v = new Vector<Object>();
            h.put(id, v);
        }
        if (!v.contains(role)) {
            v.add(role);
        }
    }

    private Vector getDisabledReassignmentRoles(RoleInterface ri, Object dataId) {
        Object id;
        Object o2;
        if (ri == null) {
            return null;
        }
        Object o = this.disableReassignmentRoles.get(ri);
        if (o instanceof Hashtable && (o2 = ((Hashtable)o).get(id = dataId == null ? "__DEFAULT_DATA_ID__" : dataId)) instanceof Vector) {
            return (Vector)o2;
        }
        return null;
    }

    private void removeRoleReassignment(RoleInterface ri) {
        this.disableReassignmentRoles.remove(ri);
    }

    public void addAction(RoleInterface ri, Object dataId, AbstractAction action) {
        if (action == null) {
            return;
        }
        Object o = this.actions.get(ri);
        Hashtable h = null;
        if (o instanceof Hashtable) {
            h = (Hashtable)o;
        } else {
            h = new Hashtable();
            this.actions.put(ri, h);
        }
        Object id = dataId == null ? "__DEFAULT_DATA_ID__" : dataId;
        o = h.get(id);
        Vector<AbstractAction> v = null;
        if (o instanceof Vector) {
            v = (Vector<AbstractAction>)o;
        } else {
            v = new Vector<AbstractAction>();
            h.put(id, v);
        }
        if (!v.contains(action)) {
            v.add(action);
        }
    }

    private Vector getActions(RoleInterface ri, Object dataId) {
        Object id;
        Object o2;
        if (ri == null) {
            return null;
        }
        Object o = this.actions.get(ri);
        if (o instanceof Hashtable && (o2 = ((Hashtable)o).get(id = dataId == null ? "__DEFAULT_DATA_ID__" : dataId)) instanceof Vector) {
            return (Vector)o2;
        }
        return null;
    }
}

