/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterStatisticsInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.util.DefaultStatistics;
import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DataFilterStatisticsPanel
extends JComponent
implements TableModel,
ListSelectionListener {
    private static final long serialVersionUID = 8299097688541036406L;
    DataFilterReadInterface filter = null;
    DataFilterStatisticsInterface stats = null;
    JList varList = new JList();
    JTable table = new JTable();

    public DataFilterStatisticsPanel(DataFilterReadInterface dataSource) {
        this.filter = dataSource;
        this.stats = new DefaultStatistics((Object)this.filter);
        this.initGUI();
        if (this.filter == null) {
            return;
        }
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < this.filter.getNumberVariables(); ++i) {
            v.addElement(this.filter.getVariableId(i));
        }
        this.varList.setListData(v);
        this.varList.setSelectedIndex(0);
        this.varList.setFont(TabbedPropertiesDialog.dialogFont);
        this.varList.addListSelectionListener(this);
        this.table.setModel(this);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.varList);
        this.add("Center", pane);
        this.add("East", new JScrollPane(this.table));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public int getRowCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.stats.getStatisticName(rowIndex);
        }
        if (columnIndex == 1) {
            Object value = this.stats.getStatistic((Object)new Integer(rowIndex), this.varList.getSelectedValue());
            if (value == null) {
                return "";
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.varList) {
            this.table.tableChanged(new TableModelEvent(this));
        }
    }
}

