/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.ColorInterface;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;

public class ColorRampPanel
extends JPanel {
    private static final long serialVersionUID = 4750805188170288370L;
    private ColorInterface ramp = null;
    private BufferedImage rampImage = null;

    public ColorRampPanel(ColorInterface ramp) {
        this.ramp = ramp;
        this.setBackground(Color.white);
    }

    public ColorInterface getRamp() {
        return this.ramp;
    }

    public void setRamp(ColorInterface ci) {
        this.ramp = ci;
    }

    public void updateImage() {
        this.drawImage();
    }

    private void drawImage() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0 || this.ramp == null) {
            return;
        }
        this.rampImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = this.rampImage.createGraphics();
        Object[] breaks = this.ramp.getBreaks();
        if (breaks == null) {
            return;
        }
        Vector<Object> temp = new Vector<Object>();
        for (int i = 0; i < breaks.length; ++i) {
            if (!(breaks[i] instanceof Number)) continue;
            temp.addElement(breaks[i]);
        }
        double[] myBreaks = new double[temp.size()];
        for (int i = 0; i < myBreaks.length; ++i) {
            myBreaks[i] = ((Number)temp.elementAt(i)).doubleValue();
        }
        Color[] myColors = this.ramp.getColors();
        if (myColors == null || myColors.length != myBreaks.length) {
            return;
        }
        int currX = 0;
        double range = myBreaks[myBreaks.length - 1] - myBreaks[0];
        for (int i = 0; i < myColors.length - 1; ++i) {
            double precent = (myBreaks[i + 1] - myBreaks[0]) / range;
            int nextX = (int)((double)this.getWidth() * precent);
            GradientPaint gp = new GradientPaint(currX, 0.0f, myColors[i], nextX, 0.0f, myColors[i + 1]);
            g.setPaint(gp);
            g.fillRect(currX, 0, nextX, this.getHeight());
            currX = nextX;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.rampImage == null) {
            this.drawImage();
        }
        if (this.rampImage != null) {
            g.drawImage(this.rampImage, 0, 0, null);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.drawImage();
        this.repaint();
    }
}

