/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.ui.ColorRampPanel;
import com.sas.graphics.silk.ui.RampView;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColorRampEditor
extends JPanel {
    private static final long serialVersionUID = 1940999110925948394L;
    private RampView rampView = null;
    static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public ColorRampEditor(ColorInterface rampIn) {
        this.rampView = new RampView(rampIn);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setLayout(null);
        if (this.rampView != null) {
            this.rampView.setBounds(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            this.add(this.rampView);
        }
    }

    public static void showDialog(Frame parent, String title, ColorInterface rampIn) {
        ColorRampEditor editor = new ColorRampEditor(rampIn);
        final JDialog dialog = new JDialog(parent, title, true);
        dialog.setSize(300, 365);
        dialog.setResizable(false);
        Container c = dialog.getContentPane();
        c.setLayout(new BorderLayout());
        c.add("Center", editor);
        JButton ok = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.OK.txt", (String)"OK"));
        ok.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(ok);
        c.add("South", panel);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setVisible(false);
            }
        });
        UIUtilities.center(dialog);
        dialog.setVisible(true);
    }

    public static ColorRampPanel getColorRampPreview(ColorInterface ramp) {
        return new ColorRampPanel(ramp);
    }
}

