/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.WhereClausePanel;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class CenterWherePanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -2259974643014479349L;
    Vector clauses;
    Vector connectors;
    DataFilterReadInterface data = null;
    ResourceBundle rb;

    public CenterWherePanel(ResourceBundle rb) {
        this.rb = rb;
        this.clauses = new Vector();
        this.connectors = new Vector();
        this.addComponentListener(this);
    }

    public void setApplied() {
        int i;
        for (i = 0; i < this.clauses.size(); ++i) {
            ((WhereClausePanel)this.clauses.elementAt(i)).setApplied();
        }
        for (i = 0; i < this.connectors.size(); ++i) {
            ((JComboBox)this.connectors.elementAt(i)).setEnabled(false);
        }
    }

    public void removeAllClauses() {
        this.clauses = new Vector();
        this.addClause();
        this.connectors = new Vector();
        this.layoutClauses();
    }

    public void setCustom(String str) {
        this.clauses = new Vector();
        this.connectors = new Vector();
        this.clauses.addElement(new WhereClausePanel(str));
        this.layoutClauses();
    }

    public void remove(int[] arr) {
        Vector newClauses = new Vector();
        Vector newConnectors = new Vector();
        int counter = 0;
        for (int i = 0; i < this.clauses.size(); ++i) {
            if (arr.length <= counter || arr[counter] != i) {
                newClauses.addElement(this.clauses.elementAt(i));
                if (i == 0 || newClauses.size() <= 1) continue;
                newConnectors.addElement(this.connectors.elementAt(i - 1));
                continue;
            }
            ++counter;
        }
        this.clauses = newClauses;
        this.connectors = newConnectors;
        if (this.clauses.size() == 0) {
            this.addClause();
        }
        this.layoutClauses();
    }

    private JComboBox getConnector() {
        JComboBox<String> rc = new JComboBox<String>();
        rc.setFont(TabbedPropertiesDialog.dialogFont);
        rc.setBackground(Color.white);
        rc.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.AND.txt", (String)"AND"));
        rc.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.OR.txt", (String)"OR"));
        return rc;
    }

    public void setData(DataFilterReadInterface data) {
        this.data = data;
    }

    public void addClause() {
        this.clauses.addElement(new WhereClausePanel(this.data));
        if (this.clauses.size() > 1) {
            this.connectors.addElement(this.getConnector());
        }
        this.layoutClauses();
    }

    @Override
    public void addNotify() {
        this.layoutClauses();
        super.addNotify();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(580, (this.hasCustom() ? 125 : 0) + 10 + 75 * this.clauses.size());
    }

    private boolean hasCustom() {
        for (int i = 0; i < this.clauses.size(); ++i) {
            if (!((WhereClausePanel)this.clauses.elementAt(i)).isCustom()) continue;
            return true;
        }
        return false;
    }

    private void layoutClauses() {
        this.removeAll();
        this.setLayout(null);
        boolean custom = false;
        for (int i = 0; i < this.clauses.size(); ++i) {
            WhereClausePanel panel = (WhereClausePanel)this.clauses.elementAt(i);
            if (panel.isCustom()) {
                custom = true;
                panel.setBounds(60, 10 + i * 75, this.getWidth() - 70, 200);
            } else {
                panel.setBounds(60, 10 + (custom ? 125 : 0) + i * 75, this.getWidth() - 70, 75);
            }
            this.add(panel);
            if (i <= 0) continue;
            JComboBox box = (JComboBox)this.connectors.elementAt(i - 1);
            box.setBounds(5, (custom ? 125 : 0) + 35 + i * 75, 55, 25);
            this.add(box);
        }
    }

    public String[] getAllClauses(boolean formatted) {
        String[] rc = new String[this.clauses.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = ((WhereClausePanel)this.clauses.elementAt(i)).getClause(true);
        }
        return rc;
    }

    public String getWhereClause() {
        String rc = "";
        if (this.clauses.size() == 0) {
            return rc;
        }
        String cl = ((WhereClausePanel)this.clauses.elementAt(0)).getClause(false);
        if (cl != null) {
            rc = rc + "(" + cl + ")";
        }
        for (int i = 0; i < this.connectors.size(); ++i) {
            JComboBox box = (JComboBox)this.connectors.elementAt(i);
            WhereClausePanel panel = (WhereClausePanel)this.clauses.elementAt(i + 1);
            cl = panel.getClause(false);
            if (rc.length() > 0 && cl != null) {
                rc = rc + " " + (box.getSelectedItem().toString().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.AND.txt", (String)"AND")) ? "&" : "|") + " (" + panel.getClause(false) + ")";
                continue;
            }
            if (cl == null) continue;
            rc = rc + cl;
        }
        return rc;
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
        this.layoutClauses();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        this.layoutClauses();
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }
}

