/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.CenteredHorizontalSeparator;
import com.sas.graphics.silk.ui.DefaultTabPanel;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BubblePanel
extends DefaultTabPanel
implements ActionListener,
ChangeListener {
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private Vector propertyListeners = new Vector();
    private boolean ignoreEvents = false;
    private JPanel mainControlPanel = null;
    private JPanel bubbleSizePanel = null;
    private JPanel bubbleSizeHeaderPanel = null;
    private JPanel bubbleSizeControlsPanel = null;
    private JPanel bubbleDisplayPanel = null;
    private JPanel bubbleDisplayHeaderPanel = null;
    private JCheckBox relativeScaleCheckBox = null;
    private JLabel minSizeLabel = null;
    private JSpinner minSizeSpinner = null;
    private JLabel maxSizeLabel = null;
    private JSpinner maxSizeSpinner = null;
    private JCheckBox fillCheckBox = null;
    private JCheckBox outlineCheckBox = null;
    private SpinnerNumberModel minSizeSpinnerModel = null;
    private SpinnerNumberModel maxSizeSpinnerModel = null;

    public BubblePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(316, 430);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getControlsPanel(), "North");
    }

    private JPanel getControlsPanel() {
        if (this.mainControlPanel == null) {
            this.mainControlPanel = new JPanel();
            GridLayout gl = new GridLayout(2, 1);
            gl.setVgap(12);
            this.mainControlPanel.setLayout(gl);
            this.mainControlPanel.add(this.getBubbleSizePanel());
            this.mainControlPanel.add(this.getBubbleDisplayPanel());
        }
        return this.mainControlPanel;
    }

    private JPanel getBubbleSizePanel() {
        if (this.bubbleSizePanel == null) {
            this.bubbleSizePanel = new JPanel();
            BorderLayout bl = new BorderLayout();
            bl.setVgap(4);
            this.bubbleSizePanel.setLayout(bl);
            this.bubbleSizePanel.add((Component)this.getBubbleSizeHeaderPanel(), "North");
            this.bubbleSizePanel.add((Component)this.getBubbleSizeControlsPanel(), "Center");
        }
        return this.bubbleSizePanel;
    }

    private JPanel getBubbleSizeHeaderPanel() {
        if (this.bubbleSizeHeaderPanel == null) {
            this.bubbleSizeHeaderPanel = new JPanel();
            this.bubbleSizeHeaderPanel.setLayout(new BorderLayout());
            JLabel headerLabel = new JLabel();
            headerLabel.setFont(UIUtilities.getSILKDialogFont());
            headerLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleSize.txt", (String)"Bubble Size"));
            this.bubbleSizeHeaderPanel.add((Component)headerLabel, "West");
            this.bubbleSizeHeaderPanel.add((Component)new CenteredHorizontalSeparator(), "Center");
        }
        return this.bubbleSizeHeaderPanel;
    }

    private JPanel getBubbleSizeControlsPanel() {
        if (this.bubbleSizeControlsPanel == null) {
            this.bubbleSizeControlsPanel = new JPanel();
            GridLayout gl = new GridLayout(3, 1);
            gl.setVgap(4);
            this.bubbleSizeControlsPanel.setLayout(gl);
            this.relativeScaleCheckBox = new JCheckBox();
            this.relativeScaleCheckBox.setFont(UIUtilities.getSILKDialogFont());
            this.relativeScaleCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.RelativeScale.txt", (String)"Relative Scale"));
            this.relativeScaleCheckBox.addActionListener(this);
            this.bubbleSizeControlsPanel.add(this.relativeScaleCheckBox);
            JPanel minSizePanel = new JPanel(new BorderLayout());
            this.minSizeLabel = new JLabel();
            this.minSizeLabel.setFont(UIUtilities.getSILKDialogFont());
            this.minSizeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleMinimumSize.txt", (String)"Minimum Size:"));
            minSizePanel.add((Component)this.minSizeLabel, "West");
            this.minSizeSpinnerModel = new SpinnerNumberModel((Number)1.0, Double.valueOf(1.0), Double.valueOf(200.0), (Number)1);
            this.minSizeSpinner = new JSpinner(this.minSizeSpinnerModel);
            this.minSizeSpinnerModel.addChangeListener(this);
            minSizePanel.add((Component)this.minSizeSpinner, "East");
            this.bubbleSizeControlsPanel.add(minSizePanel);
            JPanel maxSizePanel = new JPanel(new BorderLayout());
            this.maxSizeLabel = new JLabel();
            this.maxSizeLabel.setFont(UIUtilities.getSILKDialogFont());
            this.maxSizeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleMaximumSize.txt", (String)"Maximum Size:"));
            maxSizePanel.add((Component)this.maxSizeLabel, "West");
            this.maxSizeSpinnerModel = new SpinnerNumberModel((Number)1.0, Double.valueOf(1.0), Double.valueOf(200.0), (Number)1);
            this.maxSizeSpinner = new JSpinner(this.maxSizeSpinnerModel);
            this.maxSizeSpinnerModel.addChangeListener(this);
            maxSizePanel.add((Component)this.maxSizeSpinner, "East");
            this.bubbleSizeControlsPanel.add(maxSizePanel);
        }
        return this.bubbleSizeControlsPanel;
    }

    private JPanel getBubbleDisplayPanel() {
        if (this.bubbleDisplayPanel == null) {
            this.bubbleDisplayPanel = new JPanel();
            GridLayout gl = new GridLayout(3, 1);
            gl.setVgap(4);
            this.bubbleDisplayPanel.setLayout(gl);
            this.bubbleDisplayPanel.add(this.getBubbleDisplayHeaderPanel());
            this.fillCheckBox = new JCheckBox();
            this.fillCheckBox.setFont(UIUtilities.getSILKDialogFont());
            this.fillCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleFill.txt", (String)"Fill"));
            this.fillCheckBox.addActionListener(this);
            this.bubbleDisplayPanel.add(this.fillCheckBox);
            this.outlineCheckBox = new JCheckBox();
            this.outlineCheckBox.setFont(UIUtilities.getSILKDialogFont());
            this.outlineCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleOutline.txt", (String)"Outline"));
            this.outlineCheckBox.addActionListener(this);
            this.bubbleDisplayPanel.add(this.outlineCheckBox);
        }
        return this.bubbleDisplayPanel;
    }

    private JPanel getBubbleDisplayHeaderPanel() {
        if (this.bubbleDisplayHeaderPanel == null) {
            this.bubbleDisplayHeaderPanel = new JPanel();
            this.bubbleDisplayHeaderPanel.setLayout(new BorderLayout());
            JLabel headerLabel = new JLabel();
            headerLabel.setFont(UIUtilities.getSILKDialogFont());
            headerLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BubblePanel.BubbleDisplay.txt", (String)"Bubble Display"));
            this.bubbleDisplayHeaderPanel.add((Component)headerLabel, "West");
            this.bubbleDisplayHeaderPanel.add((Component)new CenteredHorizontalSeparator(), "Center");
        }
        return this.bubbleDisplayHeaderPanel;
    }

    @Override
    protected void initFromSource() {
        this.ignoreEvents = true;
        Object obj = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)22001);
        if (obj instanceof Number) {
            this.minSizeSpinner.setValue(((Number)obj).intValue());
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)22002)) instanceof Number) {
            this.maxSizeSpinner.setValue(((Number)obj).intValue());
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)22005)) instanceof Boolean) {
            this.relativeScaleCheckBox.setSelected((Boolean)obj);
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)22004)) instanceof Boolean) {
            this.outlineCheckBox.setSelected((Boolean)obj);
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)22003)) instanceof Boolean) {
            this.fillCheckBox.setSelected((Boolean)obj);
        }
        this.ignoreEvents = false;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (this.propertyListeners.contains(prop)) {
            return false;
        }
        this.propertyListeners.add(prop);
        return true;
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propertyListeners);
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propertyListeners);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return this.propertyListeners.removeElement(prop);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        if (this.relativeScaleCheckBox == e.getSource()) {
            PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)22005, (Object)this.relativeScaleCheckBox.isSelected());
            this.minSizeLabel.setEnabled(this.relativeScaleCheckBox.isSelected());
            this.minSizeSpinner.setEnabled(this.relativeScaleCheckBox.isSelected());
            this.maxSizeLabel.setEnabled(this.relativeScaleCheckBox.isSelected());
            this.maxSizeSpinner.setEnabled(this.relativeScaleCheckBox.isSelected());
        } else if (this.fillCheckBox == e.getSource()) {
            PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)22003, (Object)this.fillCheckBox.isSelected());
            if (!this.fillCheckBox.isSelected()) {
                this.outlineCheckBox.setSelected(true);
            }
            this.outlineCheckBox.setEnabled(this.fillCheckBox.isSelected());
        } else if (this.outlineCheckBox == e.getSource()) {
            PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)22004, (Object)this.outlineCheckBox.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        if (this.minSizeSpinnerModel == evt.getSource()) {
            if (this.validateNumber(this.minSizeSpinner.getValue())) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)22001, (Object)this.minSizeSpinner.getValue());
            }
        } else if (this.maxSizeSpinnerModel == evt.getSource() && this.validateNumber(this.maxSizeSpinner.getValue())) {
            PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)22002, (Object)this.maxSizeSpinner.getValue());
        }
    }

    private boolean validateNumber(Object value) {
        if (value instanceof Number) {
            return true;
        }
        if (value != null) {
            try {
                double d = Double.parseDouble(value.toString());
                if (!Double.isNaN(d)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public void dispose() {
        if (this.propertyListeners != null) {
            this.propertyListeners.clear();
        }
        this.propertyListeners = null;
    }
}

