/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.BoxPlotPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxPlotBoxPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
TabPanelInterface,
BoxPlotPropertyInterface {
    private static final long serialVersionUID = 759732897779828191L;
    protected static int BORDER = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected JPanel fillPanel;
    protected JPanel outlinePanel;
    protected JPanel linePanel;
    protected JPanel whiskerPanel;
    protected JPanel stylePanel;
    protected JCheckBox fill;
    protected JCheckBox notched;
    protected JCheckBox extreme;
    protected JCheckBox connect;
    protected ColorPanel lineColor;
    protected ColorPanel fillColor;
    protected ColorPanel outlineColor;
    protected ColorPanel whiskerColor;
    protected JButton fillColorB;
    protected JButton outlineColorB;
    protected JButton lineColorB;
    protected JButton whiskerColorB;
    protected JComboBox capShape;
    protected JComboBox connectBy;
    protected JComboBox colorBy;
    protected JSlider boxSize;
    protected JSlider outlineWidth;
    protected JSlider lineWidth;
    protected JSlider whiskerWidth;
    protected JLabel outlineWidthLabel;
    protected JLabel lineWidthLabel;
    protected JLabel whiskerWidthLabel;
    private int comboBoxHeight;
    private int comboBoxWidth;
    private int colorPanelHeight;
    protected Color GRAYOUT;
    protected boolean byScheme;
    private Vector propListeners;

    public BoxPlotBoxPanel() {
        this((PropertyInterface)null);
    }

    public BoxPlotBoxPanel(PropertyInterface chart) {
        this.setSize(265, 410);
        this.propListeners = new Vector();
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)chart);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            if (c instanceof JComboBox) {
                c.setBackground(Color.white);
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    protected void setEnablePanel(JPanel panel, boolean all, boolean enable) {
        Serializable c;
        Border b = panel.getBorder();
        if (all && b != null && b instanceof TitledBorder) {
            c = enable ? Color.black : this.GRAYOUT;
            ((TitledBorder)b).setTitleColor((Color)c);
        }
        int count = panel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            c = panel.getComponent(i);
            if (c instanceof JPanel && !(c instanceof ColorPanel)) {
                this.setEnablePanel((JPanel)c, all, enable);
                continue;
            }
            if (!all && c instanceof JCheckBox) continue;
            ((Component)c).setEnabled(enable);
        }
        panel.repaint();
    }

    private JPanel makeOutlinePanel() {
        this.outlinePanel = new JPanel();
        this.outlinePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.OutlinePanel.txt", (String)"Outline")));
        this.outlinePanel.setLayout(new BoxLayout(this.outlinePanel, 1));
        JPanel colorP = new JPanel();
        colorP.setLayout(new BoxLayout(colorP, 0));
        this.outlineColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Etc.txt", (String)"..."));
        this.outlineColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.outlineColor = new ColorPanel(Color.black, this.colorPanelHeight);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        colorP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Color.txt", (String)"Color:")));
        colorP.add(Box.createHorizontalGlue());
        colorP.add(this.outlineColorB);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel sizeP = new JPanel();
        sizeP.setLayout(new BoxLayout(sizeP, 0));
        this.outlineWidth = new JSlider();
        this.outlineWidth.setMinimum(1);
        this.outlineWidth.setMaximum(10);
        this.outlineWidthLabel = new JLabel();
        sizeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sizeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Thickness.txt", (String)"Thickness:")));
        sizeP.add(this.outlineWidthLabel);
        sizeP.add(Box.createRigidArea(new Dimension(4 * BORDER, 0)));
        sizeP.add(this.outlineWidth);
        this.outlinePanel.add(colorP);
        this.outlinePanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.outlinePanel.add(sizeP);
        return this.outlinePanel;
    }

    private JPanel makeLinePanel() {
        this.linePanel = new JPanel();
        this.linePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.LinePanel.txt", (String)"Line")));
        this.linePanel.setLayout(new BoxLayout(this.linePanel, 1));
        JPanel connectP = new JPanel();
        connectP.setLayout(new BoxLayout(connectP, 0));
        this.connect = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectBy.txt", (String)"Connected By:"));
        this.connectBy = new JComboBox();
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectMinimum.txt", (String)"Minimum"));
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectFirstQuartile.txt", (String)"First Quartile"));
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectMedain.txt", (String)"Median"));
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectThirdQuartile.txt", (String)"Third Quartile"));
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectMaximum.txt", (String)"Maximum"));
        this.connectBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ConnectMean.txt", (String)"Mean"));
        this.connectBy.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        Dimension D = this.connectBy.getPreferredSize();
        int maxWidth = this.getWidth() - BORDER * 5 - D.width;
        Dimension D2 = new Dimension(Math.min(maxWidth, this.connect.getPreferredSize().width), this.comboBoxHeight);
        this.connect.setPreferredSize(D2);
        connectP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        connectP.add(this.connect);
        connectP.add(Box.createHorizontalGlue());
        connectP.add(this.connectBy);
        connectP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel colorP2 = new JPanel();
        colorP2.setLayout(new BoxLayout(colorP2, 0));
        this.lineColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Etc.txt", (String)"..."));
        this.lineColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.lineColor = new ColorPanel(Color.black, this.colorPanelHeight);
        colorP2.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        colorP2.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Color.txt", (String)"Color:")));
        colorP2.add(Box.createHorizontalGlue());
        colorP2.add(this.lineColor);
        colorP2.add(this.lineColorB);
        colorP2.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel sizeP2 = new JPanel();
        sizeP2.setLayout(new BoxLayout(sizeP2, 0));
        this.lineWidth = new JSlider();
        this.lineWidth.setMinimum(1);
        this.lineWidth.setMaximum(10);
        this.lineWidthLabel = new JLabel();
        sizeP2.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sizeP2.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Thickness.txt", (String)"Thickness:")));
        sizeP2.add(this.lineWidthLabel);
        sizeP2.add(Box.createRigidArea(new Dimension(4 * BORDER, 0)));
        sizeP2.add(this.lineWidth);
        this.linePanel.add(connectP);
        this.linePanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.linePanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        return this.linePanel;
    }

    private JPanel makeWhiskerPanel() {
        this.whiskerPanel = new JPanel();
        this.whiskerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.WhiskerPanel.txt", (String)"Whisker")));
        this.whiskerPanel.setLayout(new BoxLayout(this.whiskerPanel, 1));
        JPanel extremePanel = new JPanel();
        extremePanel.setLayout(new BoxLayout(extremePanel, 0));
        this.extreme = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Extreme.txt", (String)"Extreme"));
        extremePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        extremePanel.add(this.extreme);
        extremePanel.add(Box.createHorizontalGlue());
        JPanel colorP = new JPanel();
        colorP.setLayout(new BoxLayout(colorP, 0));
        this.whiskerColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Etc.txt", (String)"..."));
        this.whiskerColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.whiskerColor = new ColorPanel(Color.black, this.colorPanelHeight);
        JPanel sizeP = new JPanel();
        sizeP.setLayout(new BoxLayout(sizeP, 0));
        this.whiskerWidth = new JSlider();
        this.whiskerWidth.setMinimum(1);
        this.whiskerWidth.setMaximum(10);
        this.whiskerWidthLabel = new JLabel();
        JPanel capP = new JPanel();
        capP.setLayout(new BoxLayout(capP, 0));
        this.capShape = new JComboBox();
        this.capShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.CapNone.txt", (String)"None"));
        this.capShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.CapSerif.txt", (String)"Serif"));
        this.capShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.CapLine.txt", (String)"Line"));
        this.capShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.CapBracket.txt", (String)"Bracket"));
        this.capShape.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        capP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        capP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.CapShape.txt", (String)"Cap Shape:")));
        capP.add(Box.createHorizontalGlue());
        capP.add(this.capShape);
        capP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.whiskerPanel.add(extremePanel);
        this.whiskerPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.whiskerPanel.add(colorP);
        this.whiskerPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.whiskerPanel.add(sizeP);
        this.whiskerPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.whiskerPanel.add(capP);
        return this.whiskerPanel;
    }

    private JPanel makeStylePanel() {
        this.stylePanel = new JPanel();
        this.stylePanel = new JPanel();
        this.stylePanel.setLayout(new BoxLayout(this.stylePanel, 0));
        return this.stylePanel;
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(BORDER * 4, BORDER, BORDER * 4, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel notchPanel = new JPanel();
        notchPanel.setLayout(new BoxLayout(notchPanel, 0));
        this.notched = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Notched.txt", (String)"Notched"));
        this.boxSize = new JSlider();
        this.boxSize.setMinimum(1);
        this.boxSize.setMaximum(100);
        notchPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        notchPanel.add(this.notched);
        notchPanel.add(Box.createRigidArea(new Dimension(6 * BORDER, 0)));
        notchPanel.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Size.txt", (String)"Size:")));
        notchPanel.add(this.boxSize);
        JPanel colorByPanel = new JPanel();
        colorByPanel.setLayout(new BoxLayout(colorByPanel, 0));
        this.colorBy = new JComboBox();
        this.colorBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorByChart.txt", (String)"None"));
        this.colorBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorByCategory.txt", (String)"Category"));
        this.colorBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorByGroup.txt", (String)"Group"));
        this.comboBoxHeight = this.colorBy.getPreferredSize().height;
        this.comboBoxWidth = this.colorPanelHeight + COLOR_PANE_WIDTH;
        this.colorBy.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        colorByPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.fillPanel = new JPanel();
        this.fillPanel.setLayout(new BoxLayout(this.fillPanel, 0));
        this.fill = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Fill.txt", (String)"Fill:"));
        this.fillColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.Etc.txt", (String)"..."));
        this.colorPanelHeight = this.fillColorB.getPreferredSize().height;
        this.fillColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.fillColor = new ColorPanel(Color.white, this.colorPanelHeight);
        this.outlinePanel = this.makeOutlinePanel();
        this.linePanel = this.makeLinePanel();
        this.whiskerPanel = this.makeWhiskerPanel();
        this.stylePanel = this.makeStylePanel();
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.stylePanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(notchPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(colorByPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.fillPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.linePanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.whiskerPanel);
    }

    public void setInitialValues() {
        boolean group = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)826);
        int items = this.colorBy.getItemCount();
        if (group && items < 3) {
            this.colorBy.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorByGroup.txt", (String)"Group"));
        } else if (!group && items > 2) {
            this.colorBy.removeItemAt(2);
        }
        boolean on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)802);
        this.notched.setSelected(on);
        on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)803);
        this.fill.setSelected(on);
        this.setEnablePanel(this.outlinePanel, false, on);
        int by = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)824)).intValue();
        this.colorBy.setSelectedIndex(by);
        this.setEnablePanel(this.fillPanel, false, by == 0);
        int ivalue = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)821)).intValue();
        if (ivalue == 0) {
            on = false;
            this.connectBy.setSelectedIndex(2);
        } else {
            on = true;
            this.connectBy.setSelectedIndex(ivalue - 1);
        }
        this.connect.setSelected(on);
        this.setEnablePanel(this.linePanel, false, on);
        this.lineColor.setColor((Color)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)822));
        this.outlineColor.setColor((Color)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)806));
        this.fillColor.setColor((Color)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)804));
        this.whiskerColor.setColor((Color)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)819));
        on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)801);
        this.extreme.setSelected(on);
        ivalue = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)808)).intValue();
        this.capShape.setSelectedIndex(ivalue);
        this.boxSize.setValue((int)((Double)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)805) * 100.0));
        this.outlineWidth.setValue(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)807)).intValue());
        this.lineWidth.setValue(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)823)).intValue());
        this.whiskerWidth.setValue(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)820)).intValue());
        this.outlineWidthLabel.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)807)).toString());
        this.lineWidthLabel.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)823)).toString());
        this.whiskerWidthLabel.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)820)).toString());
    }

    private void addListeners() {
        this.notched.addItemListener(this);
        this.fill.addItemListener(this);
        this.extreme.addItemListener(this);
        this.connect.addItemListener(this);
        this.fillColorB.addActionListener(this);
        this.outlineColorB.addActionListener(this);
        this.lineColorB.addActionListener(this);
        this.whiskerColorB.addActionListener(this);
        this.colorBy.addActionListener(this);
        this.connectBy.addActionListener(this);
        this.capShape.addActionListener(this);
        this.boxSize.addChangeListener(this);
        this.outlineWidth.addChangeListener(this);
        this.lineWidth.addChangeListener(this);
        this.whiskerWidth.addChangeListener(this);
    }

    private void removeListeners() {
        this.notched.removeItemListener(this);
        this.fill.removeItemListener(this);
        this.extreme.removeItemListener(this);
        this.connect.removeItemListener(this);
        this.fillColorB.removeActionListener(this);
        this.outlineColorB.removeActionListener(this);
        this.lineColorB.removeActionListener(this);
        this.whiskerColorB.removeActionListener(this);
        this.colorBy.removeActionListener(this);
        this.connectBy.removeActionListener(this);
        this.capShape.removeActionListener(this);
        this.boxSize.removeChangeListener(this);
        this.outlineWidth.removeChangeListener(this);
        this.lineWidth.removeChangeListener(this);
        this.whiskerWidth.removeChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.fillColorB) {
            Color initColor = this.fillColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.fillColor.setColor(newColor);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)804, (Object)newColor);
        } else if (source == this.outlineColorB) {
            Color initColor = this.outlineColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.outlineColor.setColor(newColor);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)806, (Object)newColor);
        } else if (source == this.lineColorB) {
            Color initColor = this.lineColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.lineColor.setColor(newColor);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)822, (Object)newColor);
        } else if (source == this.whiskerColorB) {
            Color initColor = this.whiskerColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotBoxPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.whiskerColor.setColor(newColor);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)819, (Object)newColor);
        } else if (source == this.colorBy) {
            int by = this.colorBy.getSelectedIndex();
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)824, (Object)new Integer(by));
            this.setEnablePanel(this.fillPanel, false, by == 0);
        } else if (source == this.connectBy) {
            int by = this.connectBy.getSelectedIndex() + 1;
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)821, (Object)new Integer(by));
        } else if (source == this.capShape) {
            int shape = this.capShape.getSelectedIndex();
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)808, (Object)new Integer(shape));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.connect) {
            this.setEnablePanel(this.linePanel, false, on);
            if (!on) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)821, (Object)new Integer(0));
            } else {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)821, (Object)new Integer(this.connectBy.getSelectedIndex() + 1));
            }
        } else if (source == this.extreme) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)801, (Object)new Boolean(on));
        } else if (source == this.fill) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)803, (Object)new Boolean(on));
            this.setEnablePanel(this.outlinePanel, false, on);
        } else if (source == this.notched) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)802, (Object)new Boolean(on));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JSlider)) {
            return;
        }
        int wt = ((JSlider)source).getValue();
        if (source == this.boxSize) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)805, (Object)new Double((double)wt / 100.0));
        } else if (source == this.outlineWidth) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)807, (Object)new Integer(wt));
            this.outlineWidthLabel.setText(String.valueOf(wt));
        } else if (source == this.lineWidth) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)823, (Object)new Integer(wt));
            this.lineWidthLabel.setText(String.valueOf(wt));
        } else if (source == this.whiskerWidth) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)820, (Object)new Integer(wt));
            this.whiskerWidthLabel.setText(String.valueOf(wt));
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = -6939401353694505596L;
        Color color;
        int height;
        boolean enabled = true;

        ColorPanel(Color c, int h) {
            this.height = h;
            this.color = c;
            this.setBackground(Color.white);
            Border inBorder = BorderFactory.createLineBorder(new Color(128, 128, 128), BORDER);
            Border outBorder = BorderFactory.createEtchedBorder();
            this.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        }

        Color getColor() {
            return this.color;
        }

        void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.enabled) {
                g.setColor(this.color);
            } else {
                g.setColor(BoxPlotBoxPanel.this.GRAYOUT);
            }
            g.fillRect(0, 0, COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public void setEnabled(boolean on) {
            this.enabled = on;
        }
    }
}

