/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.AreaBarComponent;
import com.sas.graphics.silk.interfaces.BarPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class BarPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
DocumentListener,
TabPanelInterface,
BarPropertyInterface {
    private static final long serialVersionUID = -8815599117100713945L;
    protected static int BORDER = 8;
    protected static int GAP = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected ResourceBundle rb = null;
    protected ResourceBundle rbBar = null;
    protected PropertyInterface bar;
    protected JCheckBox byChartCheckBox;
    protected JCheckBox outlineCheckBox;
    protected ColorPanel outlineColorPanel;
    protected JButton outlineColorButton;
    protected JSlider widthSlider;
    protected Color GRAYOUT;
    protected boolean byScheme;
    protected JTextField fromField;
    protected JTextField toField;
    protected boolean updateTextFields = false;
    protected int from;
    protected int to;
    protected JComboBox axisRoleComboBox;
    protected JCheckBox gradientOnCheckBox;
    protected JCheckBox showLabelCheckBox;
    protected JCheckBox showInnerLabelsCheckBox;
    protected JComboBox colorByComboBox;
    protected static final Roles roles = Roles.getInstance(null);
    String AXIS_CATEGORY = roles.getRoleNLSName("ROLE_CATEGORY");
    String AXIS_WIDTH = roles.getRoleNLSName("ROLE_WIDTH");
    SILKNumber categoryRole = roles.getRoleObject("ROLE_CATEGORY");
    String responseSign = "Response Sign";

    public BarPanel(PropertyInterface bar) {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.rbBar = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.responseSign = ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseSign.txt", (String)"Response Sign");
        this.bar = bar;
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(2 * BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel colorPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ColorPanel.txt", (String)"Color"));
        colorPanel.setBorder(border);
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BoxLayout(barPanel, 0));
        this.byChartCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ColorBy.txt", (String)"Color by:"));
        this.colorByComboBox = new JComboBox();
        this.colorByComboBox.addItem(this.categoryRole);
        if (!(this.bar instanceof AreaBarComponent)) {
            this.colorByComboBox.addItem(this.responseSign);
        }
        this.byChartCheckBox.setPreferredSize(new Dimension(200, 0));
        barPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        barPanel.add(this.byChartCheckBox);
        barPanel.add(Box.createHorizontalGlue());
        barPanel.add(this.colorByComboBox);
        barPanel.add(Box.createRigidArea(new Dimension(BORDER, 25)));
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        this.outlineCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Outline.txt", (String)"Outline"));
        this.outlineColorButton = new JButton("...");
        this.outlineColorPanel = new ColorPanel(Color.white, this.outlineColorButton.getPreferredSize().height);
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        outlinePanel.add(this.outlineCheckBox);
        outlinePanel.add(Box.createHorizontalGlue());
        outlinePanel.add(this.outlineColorPanel);
        outlinePanel.add(this.outlineColorButton);
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel gradientOnPanel = new JPanel();
        gradientOnPanel.setLayout(new BoxLayout(gradientOnPanel, 0));
        gradientOnPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.gradientOnCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Gradient.txt", (String)"Gradient"));
        gradientOnPanel.add(this.gradientOnCheckBox);
        gradientOnPanel.add(Box.createHorizontalGlue());
        colorPanel.add(barPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        colorPanel.add(outlinePanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        colorPanel.add(gradientOnPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        JPanel widthPanel = new JPanel();
        widthPanel.setLayout(new BoxLayout(widthPanel, 0));
        JLabel widthLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.BarWidth.txt", (String)"Width"));
        this.widthSlider = new JSlider();
        this.widthSlider.setMinimum(1);
        this.widthSlider.setMaximum(101);
        this.widthSlider.setExtent(1);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        widthPanel.add(widthLabel);
        widthPanel.add(Box.createHorizontalGlue());
        widthPanel.add(this.widthSlider);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 25)));
        JPanel nBarsPanel = new JPanel();
        nBarsPanel.setLayout(new BoxLayout(nBarsPanel, 1));
        nBarsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.DisplayBarIndex.txt", (String)"Display Bar Index")));
        JPanel fromPanel = new JPanel();
        fromPanel.setLayout(new BoxLayout(fromPanel, 0));
        JLabel fromLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.From.txt", (String)"From :"));
        this.fromField = new JTextField(10);
        this.fromField.setEditable(true);
        fromPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        fromPanel.add(fromLabel);
        fromPanel.add(Box.createHorizontalGlue());
        fromPanel.add(this.fromField);
        fromPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel toPanel = new JPanel();
        toPanel.setLayout(new BoxLayout(toPanel, 0));
        JLabel toLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.To.txt", (String)"To :"));
        this.toField = new JTextField(10);
        this.toField.setEditable(true);
        toPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        toPanel.add(toLabel);
        toPanel.add(Box.createHorizontalGlue());
        toPanel.add(this.toField);
        toPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        nBarsPanel.add(fromPanel);
        nBarsPanel.add(Box.createRigidArea(new Dimension(0, (int)((double)BORDER * 0.5))));
        nBarsPanel.add(toPanel);
        nBarsPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        int buttHt = this.outlineColorButton.getPreferredSize().height;
        this.widthSlider.setPreferredSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.widthSlider.getPreferredSize().height));
        this.widthSlider.setMaximumSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.widthSlider.getPreferredSize().height));
        this.fromField.setMaximumSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.fromField.getPreferredSize().height));
        this.toField.setMaximumSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.toField.getPreferredSize().height));
        this.colorByComboBox.setPreferredSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.colorByComboBox.getPreferredSize().height));
        this.colorByComboBox.setMaximumSize(new Dimension(COLOR_PANE_WIDTH + buttHt, this.colorByComboBox.getPreferredSize().height));
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(widthPanel);
        JPanel showLabelPanel = new JPanel(new FlowLayout(0));
        this.showLabelCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowLabels.txt", (String)"Show labels"));
        showLabelPanel.add(this.showLabelCheckBox);
        if (!(this.bar instanceof AreaBarComponent || this.bar instanceof GraphInterface && !this.bar.isPropertySupported(34))) {
            this.add(Box.createRigidArea(new Dimension(0, GAP)));
            this.add(nBarsPanel);
            this.add(showLabelPanel);
        }
        if (this.bar instanceof AreaBarComponent) {
            this.add(Box.createRigidArea(new Dimension(0, GAP / 2)));
            JPanel axisRolePanel = new JPanel(new FlowLayout(0));
            JLabel axisRoleLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.AxisRole.txt", (String)"Axis Role"));
            axisRolePanel.add(axisRoleLabel);
            this.axisRoleComboBox = new JComboBox();
            this.axisRoleComboBox.addItem(this.AXIS_CATEGORY);
            this.axisRoleComboBox.addItem(this.AXIS_WIDTH);
            axisRolePanel.add(this.axisRoleComboBox);
            this.add(Box.createRigidArea(new Dimension(0, GAP)));
            JPanel areaBarLabelsPanel = new JPanel(new FlowLayout(0));
            this.showInnerLabelsCheckBox = new JCheckBox();
            areaBarLabelsPanel.add(this.showInnerLabelsCheckBox);
            JLabel areaBarLabels = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowInnerLabels.txt", (String)"Show Inner Lables"));
            areaBarLabelsPanel.add(areaBarLabels);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)axisRolePanel, "North");
            mainPanel.add((Component)areaBarLabelsPanel, "Center");
            this.add(mainPanel);
        }
    }

    public void setInitialValues() {
        this.byScheme = (Boolean)this.bar.getPropertyValue(806);
        Object colorBy = this.bar.getPropertyValue(815);
        if (colorBy != null) {
            this.byChartCheckBox.setSelected(true);
        } else {
            this.byChartCheckBox.setSelected(false);
        }
        if (this.byScheme) {
            this.byChartCheckBox.setEnabled(false);
            this.colorByComboBox.setEnabled(false);
        } else {
            this.byChartCheckBox.setEnabled(true);
            this.colorByComboBox.setEnabled(true);
        }
        if (this.byChartCheckBox.isEnabled() && this.byChartCheckBox.isSelected()) {
            this.colorByComboBox.setEnabled(true);
        } else {
            this.colorByComboBox.setEnabled(false);
        }
        boolean on = (Boolean)this.bar.getPropertyValue(803);
        if (on) {
            this.outlineCheckBox.setSelected(true);
            this.outlineColorPanel.setColor((Color)this.bar.getPropertyValue(802));
            this.outlineColorButton.setEnabled(true);
        } else {
            this.outlineCheckBox.setSelected(false);
            this.outlineColorPanel.setColor(this.GRAYOUT);
            this.outlineColorButton.setEnabled(false);
        }
        boolean gradientDisable = (Boolean)this.bar.getPropertyValue(813);
        if (gradientDisable) {
            this.gradientOnCheckBox.setEnabled(false);
        } else {
            this.gradientOnCheckBox.setEnabled(true);
            on = (Boolean)this.bar.getPropertyValue(812);
            this.gradientOnCheckBox.setSelected(on);
        }
        on = (Boolean)this.bar.getPropertyValue(816);
        this.showLabelCheckBox.setSelected(on);
        if (this.bar instanceof AreaBarComponent) {
            Object obj = this.bar.getPropertyValue(811);
            if (obj != null) {
                int num = 0;
                if (this.bar.getPropertyValue(811) == RoleInterface.ROLE_WIDTH) {
                    num = 1;
                }
                this.axisRoleComboBox.setSelectedIndex(num);
                this.axisRoleComboBox.setEnabled(true);
            } else {
                this.axisRoleComboBox.setSelectedIndex(0);
                this.axisRoleComboBox.setEnabled(false);
            }
            on = (Boolean)this.bar.getPropertyValue(819);
            this.showInnerLabelsCheckBox.setSelected(on);
        }
        this.widthSlider.setValue((int)(((Number)this.bar.getPropertyValue(804)).doubleValue() * 100.0));
        int maxBars = (Integer)this.bar.getPropertyValue(810);
        int[] barRange = (int[])this.bar.getPropertyValue(809);
        this.from = barRange[0];
        this.to = barRange[1];
        this.fromField.setText(String.valueOf(this.from));
        this.toField.setText(String.valueOf(Math.min(this.to, maxBars)));
    }

    private void addListeners() {
        this.outlineColorButton.addActionListener(this);
        this.byChartCheckBox.addItemListener(this);
        this.colorByComboBox.addItemListener(this);
        this.outlineCheckBox.addItemListener(this);
        if (this.bar instanceof AreaBarComponent) {
            this.showInnerLabelsCheckBox.addItemListener(this);
        }
        this.gradientOnCheckBox.addItemListener(this);
        this.showLabelCheckBox.addItemListener(this);
        this.widthSlider.addChangeListener(this);
        this.fromField.getDocument().addDocumentListener(this);
        this.toField.getDocument().addDocumentListener(this);
        if (this.bar instanceof AreaBarComponent) {
            this.axisRoleComboBox.addActionListener(this);
        }
    }

    private void removeListeners() {
        this.outlineColorButton.removeActionListener(this);
        this.byChartCheckBox.removeItemListener(this);
        this.colorByComboBox.removeItemListener(this);
        this.outlineCheckBox.removeItemListener(this);
        this.gradientOnCheckBox.removeItemListener(this);
        this.showLabelCheckBox.removeItemListener(this);
        this.widthSlider.removeChangeListener(this);
        this.fromField.getDocument().removeDocumentListener(this);
        this.toField.getDocument().removeDocumentListener(this);
        if (this.bar instanceof AreaBarComponent) {
            this.axisRoleComboBox.removeItemListener(this);
            this.showInnerLabelsCheckBox.removeItemListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.outlineColorButton) {
            Color initColor = this.outlineColorPanel.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.outlineColorPanel.setColor(newColor);
            this.bar.setPropertyValue(802, (Object)newColor);
        } else if (source == this.axisRoleComboBox) {
            Number axisRole = this.getAxisIndex(this.axisRoleComboBox.getSelectedItem().toString());
            this.bar.setPropertyValue(811, (Object)axisRole);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.byChartCheckBox) {
            this.colorByComboBox.setEnabled(on);
            if (on) {
                this.bar.setPropertyValue(815, this.colorByComboBox.getSelectedItem());
            } else if (!this.byScheme) {
                this.bar.setPropertyValue(815, null);
            }
        }
        if (source == this.colorByComboBox) {
            this.bar.setPropertyValue(815, this.colorByComboBox.getSelectedItem());
        }
        if (source == this.outlineCheckBox) {
            this.outlineColorButton.setEnabled(on);
            this.bar.setPropertyValue(803, (Object)new Boolean(on));
            if (on) {
                this.outlineColorPanel.setColor((Color)this.bar.getPropertyValue(802));
            } else {
                this.outlineColorPanel.setColor(this.GRAYOUT);
            }
        }
        if (source == this.gradientOnCheckBox) {
            this.bar.setPropertyValue(812, (Object)new Boolean(on));
        }
        if (source == this.showLabelCheckBox) {
            this.bar.setPropertyValue(816, (Object)new Boolean(on));
        }
        if (source == this.showInnerLabelsCheckBox) {
            this.bar.setPropertyValue(819, (Object)new Boolean(on));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.widthSlider) {
            int wt = this.widthSlider.getValue();
            this.bar.setPropertyValue(804, (Object)new Double((double)wt / 100.0));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        this.updateTextFieldValue(doc);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        this.updateTextFieldValue(doc);
    }

    private void updateTextFieldValue(Document doc) {
        this.updateTextFields = true;
        int n = -1;
        String s = null;
        if (doc.getLength() > 0) {
            try {
                s = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (s != null) {
                try {
                    n = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n > 0) {
                if (doc == this.fromField.getDocument()) {
                    this.from = n;
                } else {
                    this.to = n;
                }
            }
        } else if (doc == this.fromField.getDocument()) {
            this.from = 1;
        } else {
            this.to = (Integer)this.bar.getPropertyValue(810);
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        this.bar.cancelPropertyChanges();
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public boolean applyChanges() {
        if (this.updateTextFields) {
            if (this.from > this.to) {
                int[] barRange = (int[])this.bar.getPropertyValue(809);
                this.from = barRange[0] + 1;
                this.to = barRange[1] + 1;
            }
            int maxBars = (Integer)this.bar.getPropertyValue(810);
            this.from = Math.max(1, this.from);
            this.to = Math.min(maxBars, this.to);
            this.bar.setPropertyValue(809, (Object)new int[]{this.from, this.to});
            this.fromField.setText(String.valueOf(this.from));
            this.toField.setText(String.valueOf(this.to));
            this.updateTextFields = false;
        }
        this.bar.applyPropertyChanges();
        return true;
    }

    private Number getAxisIndex(String axisRole) {
        if (axisRole.equalsIgnoreCase(this.AXIS_CATEGORY)) {
            return RoleInterface.ROLE_CATEGORY;
        }
        if (axisRole.equalsIgnoreCase(this.AXIS_WIDTH)) {
            return RoleInterface.ROLE_WIDTH;
        }
        return new Integer(-1);
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = -9014008179285639812L;
        Color color;
        int height;

        ColorPanel(Color c, int h) {
            this.height = h;
            this.color = c;
            this.setBackground(Color.white);
        }

        Color getColor() {
            return this.color;
        }

        void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.color);
            g.fillRect(0, 0, 2 * this.height, this.height);
        }
    }
}

