/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.BarPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class BarElementPanel
extends JPanel
implements ItemListener,
ChangeListener,
DocumentListener,
TabPanelInterface,
BarPropertyInterface {
    private static final long serialVersionUID = 1L;
    protected static int BORDER = 8;
    protected static int GAP = 4;
    protected ResourceBundle rb = null;
    protected ResourceBundle rbBar = null;
    protected JCheckBox colorByCheckBox;
    protected JCheckBox outlineCheckBox;
    protected JSlider widthSlider;
    protected JSlider clusterWidthSlider;
    protected JLabel widthLabel;
    protected JLabel ClusterWidthLabel;
    protected String widthSliderPattern;
    protected String clusterWidthSliderPattern;
    protected Object[] sliderArgs;
    protected Object[] clusterSliderArgs;
    protected boolean byScheme;
    protected JTextField fromField;
    protected JTextField toField;
    protected boolean updateTextFields = false;
    protected int from;
    protected int to;
    protected JCheckBox gradientOnCheckBox;
    protected JCheckBox showLabelCheckBox;
    protected JCheckBox showOtherBar;
    protected JRadioButton maxBarThresholdRadio;
    protected JRadioButton percentThresholdRadio;
    protected JRadioButton responseThresholdRadio;
    protected JSpinner percentSpin;
    protected JTextField responseTextField;
    protected JTextField maxBarTextField;
    protected int maxBar;
    protected int respThreshold;
    protected JComboBox colorByComboBox;
    protected JComboBox responseStatComboBox;
    protected JLabel responseStatLabel;
    protected JComboBox groupDisplayTypeComboBox;
    protected JLabel groupDisplayTypeLabel;
    protected static final Roles roles = Roles.getInstance(null);
    protected Vector propListeners;
    SILKNumber categoryRole = roles.getRoleObject("ROLE_CATEGORY");
    String responseSign = "Response Sign";
    String auto = "Auto";
    String off = "Off";
    String stacked = "Stacked";
    String clustered = "Clustered";
    private boolean ignoreEvents = false;
    private PropertyInterface bar;
    private JPanel responseStatPanel;

    public BarElementPanel() {
        this((PropertyInterface)null);
    }

    public BarElementPanel(PropertyInterface bar) {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.rbBar = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.responseSign = ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseSign.txt", (String)"Response Sign");
        this.auto = ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseStat.Auto.txt", (String)"Auto");
        this.off = ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseStat.Off.txt", (String)"Off");
        this.widthSliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Width_Slider_Text.fmt", (String)"Width: {0}");
        this.clusterWidthSliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Cluster_Width_Slider_Text.fmt", (String)"Cluster Width: {0}");
        this.sliderArgs = new Object[1];
        this.clusterSliderArgs = new Object[1];
        this.bar = bar;
        this.propListeners = new Vector();
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)bar);
        this.setSize(265, 410);
        if (this.propListeners.size() > 0) {
            this.layoutPanel();
            this.updatePanelUI(this);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    protected void layoutPanel() {
        if (this.propListeners == null || this.propListeners.size() == 0) {
            return;
        }
        this.setBorder(BorderFactory.createEmptyBorder(2 * BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel colorPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ColorPanel.txt", (String)"Color"));
        colorPanel.setBorder(border);
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BoxLayout(barPanel, 0));
        this.colorByCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ColorBy.txt", (String)"Color by:"));
        this.colorByComboBox = new JComboBox();
        this.colorByComboBox.addItem(this.categoryRole);
        this.colorByComboBox.addItem(this.responseSign);
        this.colorByCheckBox.setPreferredSize(new Dimension(200, 0));
        barPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        barPanel.add(this.colorByCheckBox);
        barPanel.add(Box.createHorizontalGlue());
        barPanel.add(this.colorByComboBox);
        barPanel.add(Box.createRigidArea(new Dimension(BORDER, 25)));
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.outlineCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Outline.txt", (String)"Outline"));
        outlinePanel.add(this.outlineCheckBox);
        outlinePanel.add(Box.createHorizontalGlue());
        JPanel gradientOnPanel = new JPanel();
        gradientOnPanel.setLayout(new BoxLayout(gradientOnPanel, 0));
        gradientOnPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.gradientOnCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Gradient.txt", (String)"Gradient"));
        gradientOnPanel.add(this.gradientOnCheckBox);
        gradientOnPanel.add(Box.createHorizontalGlue());
        colorPanel.add(barPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        colorPanel.add(outlinePanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        colorPanel.add(gradientOnPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        JPanel widthPanel = new JPanel();
        widthPanel.setLayout(new BoxLayout(widthPanel, 0));
        this.widthLabel = new JLabel();
        this.widthSlider = new JSlider();
        this.widthSlider.setMinimum(1);
        this.widthSlider.setMaximum(101);
        this.widthSlider.setExtent(1);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        widthPanel.add(this.widthLabel);
        widthPanel.add(Box.createHorizontalGlue());
        widthPanel.add(this.widthSlider);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel clusterWidthPanel = new JPanel();
        clusterWidthPanel.setLayout(new BoxLayout(clusterWidthPanel, 0));
        this.ClusterWidthLabel = new JLabel();
        this.clusterWidthSlider = new JSlider();
        this.clusterWidthSlider.setMinimum(1);
        this.clusterWidthSlider.setMaximum(101);
        this.clusterWidthSlider.setExtent(1);
        clusterWidthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        clusterWidthPanel.add(this.ClusterWidthLabel);
        clusterWidthPanel.add(Box.createHorizontalGlue());
        clusterWidthPanel.add(this.clusterWidthSlider);
        clusterWidthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel nBarsPanel = new JPanel();
        nBarsPanel.setLayout(new BoxLayout(nBarsPanel, 1));
        nBarsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.DisplayBarIndex.txt", (String)"Display Bar Index")));
        JPanel fromPanel = new JPanel();
        fromPanel.setLayout(new BoxLayout(fromPanel, 0));
        JLabel fromLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.From.txt", (String)"From :"));
        this.fromField = new JTextField(10);
        this.fromField.setEditable(true);
        fromPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        fromPanel.add(fromLabel);
        fromPanel.add(Box.createHorizontalGlue());
        fromPanel.add(this.fromField);
        fromPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel toPanel = new JPanel();
        toPanel.setLayout(new BoxLayout(toPanel, 0));
        JLabel toLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.To.txt", (String)"To :"));
        this.toField = new JTextField(10);
        this.toField.setEditable(true);
        toPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        toPanel.add(toLabel);
        toPanel.add(Box.createHorizontalGlue());
        toPanel.add(this.toField);
        toPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        nBarsPanel.add(fromPanel);
        nBarsPanel.add(Box.createRigidArea(new Dimension(0, (int)((double)BORDER * 0.5))));
        nBarsPanel.add(toPanel);
        nBarsPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        JPanel showBarPanel = new JPanel(new BorderLayout());
        this.showOtherBar = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowOtherBar.txt", (String)"Show Other Bar:"));
        showBarPanel.add((Component)this.showOtherBar, "West");
        JPanel otherBarPanel = new JPanel();
        otherBarPanel.setLayout(new BoxLayout(otherBarPanel, 1));
        JPanel maxBarPanel = new JPanel();
        maxBarPanel.setLayout(new BoxLayout(maxBarPanel, 0));
        this.maxBarThresholdRadio = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.MaxBar.txt", (String)"Maximum Bars :"));
        this.maxBar = (Integer)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810);
        this.maxBarTextField = new JTextField();
        this.maxBarTextField.setText(String.valueOf(this.maxBar));
        maxBarPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        maxBarPanel.add(this.maxBarThresholdRadio);
        maxBarPanel.add(Box.createHorizontalGlue());
        maxBarPanel.add(this.maxBarTextField);
        maxBarPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel percentThresholdPanel = new JPanel();
        percentThresholdPanel.setLayout(new BoxLayout(percentThresholdPanel, 0));
        this.percentThresholdRadio = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.PercentThreshold.txt", (String)"Percent Threshold :"));
        this.percentSpin = new JSpinner();
        SpinnerNumberModel opsm = new SpinnerNumberModel(0.04, 0.0, 1.0, 0.01);
        this.percentSpin.setFont(TabbedPropertiesDialog.dialogFont);
        this.percentSpin.setModel(opsm);
        this.percentSpin.setEditor(new JSpinner.NumberEditor(this.percentSpin, "###.##%"));
        percentThresholdPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        percentThresholdPanel.add(this.percentThresholdRadio);
        percentThresholdPanel.add(Box.createHorizontalGlue());
        percentThresholdPanel.add(this.percentSpin);
        percentThresholdPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel responseThresholdPanel = new JPanel();
        responseThresholdPanel.setLayout(new BoxLayout(responseThresholdPanel, 0));
        this.responseThresholdRadio = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ResponseThreshold", (String)"Response Threshold :"));
        this.responseThresholdRadio.setEnabled(false);
        this.responseTextField = new JTextField();
        this.responseTextField.setText(String.valueOf(this.respThreshold));
        responseThresholdPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        responseThresholdPanel.add(this.responseThresholdRadio);
        responseThresholdPanel.add(Box.createHorizontalGlue());
        responseThresholdPanel.add(this.responseTextField);
        responseThresholdPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.maxBarThresholdRadio);
        bg.add(this.percentThresholdRadio);
        bg.add(this.responseThresholdRadio);
        otherBarPanel.add(percentThresholdPanel);
        otherBarPanel.add(Box.createRigidArea(new Dimension(0, (int)((double)BORDER * 0.5))));
        otherBarPanel.add(maxBarPanel);
        otherBarPanel.add(Box.createRigidArea(new Dimension(0, (int)((double)BORDER * 0.5))));
        otherBarPanel.add(responseThresholdPanel);
        otherBarPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        int maxWt = 110;
        this.fromField.setMaximumSize(new Dimension(maxWt, this.fromField.getPreferredSize().height));
        this.toField.setMaximumSize(new Dimension(maxWt, this.toField.getPreferredSize().height));
        this.maxBarTextField.setMaximumSize(new Dimension(maxWt, this.maxBarTextField.getPreferredSize().height));
        this.responseTextField.setMaximumSize(new Dimension(maxWt, this.responseTextField.getPreferredSize().height));
        this.percentSpin.setMaximumSize(new Dimension(maxWt, this.percentSpin.getPreferredSize().height));
        this.maxBarTextField.setPreferredSize(new Dimension(maxWt, this.maxBarTextField.getPreferredSize().height));
        this.responseTextField.setPreferredSize(new Dimension(maxWt, this.responseTextField.getPreferredSize().height));
        this.percentSpin.setPreferredSize(new Dimension(maxWt, this.percentSpin.getPreferredSize().height));
        this.widthSlider.setPreferredSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.widthSlider.setMaximumSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.clusterWidthSlider.setPreferredSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.clusterWidthSlider.setMaximumSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.colorByComboBox.setPreferredSize(new Dimension(maxWt, this.colorByComboBox.getPreferredSize().height));
        this.colorByComboBox.setMaximumSize(new Dimension(maxWt, this.colorByComboBox.getPreferredSize().height));
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(widthPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(clusterWidthPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        JPanel showLabelPanel = new JPanel(new FlowLayout(0));
        this.showLabelCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowLabels.txt", (String)"Show labels"));
        showLabelPanel.add(this.showLabelCheckBox);
        this.responseStatLabel = new JLabel();
        this.responseStatLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowResponseStat.txt", (String)"Show Response Statistics"));
        this.responseStatLabel.setFont(UIUtilities.getSILKDialogFont());
        this.groupDisplayTypeLabel = new JLabel();
        this.groupDisplayTypeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.GroupDisplayType.txt", (String)"Group Display Type"));
        this.groupDisplayTypeLabel.setFont(UIUtilities.getSILKDialogFont());
        this.responseStatComboBox = new JComboBox();
        this.responseStatComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowResponseStatDropDown.Auto.txt", (String)"Auto"));
        this.responseStatComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.ShowResponseStatDropDown.Off.txt", (String)"Off"));
        this.responseStatComboBox.setPreferredSize(new Dimension(maxWt, this.responseStatComboBox.getPreferredSize().height));
        this.responseStatComboBox.setMaximumSize(new Dimension(maxWt, this.responseStatComboBox.getPreferredSize().height));
        this.groupDisplayTypeComboBox = new JComboBox();
        this.groupDisplayTypeComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.GroupDisplayTypeDropDown.Stacked.txt", (String)"Stacked"));
        this.groupDisplayTypeComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.GroupDisplayTypeDropDown.Clustered.txt", (String)"Clustered"));
        this.groupDisplayTypeComboBox.setPreferredSize(new Dimension(maxWt, this.groupDisplayTypeComboBox.getPreferredSize().height));
        this.groupDisplayTypeComboBox.setMaximumSize(new Dimension(maxWt, this.groupDisplayTypeComboBox.getPreferredSize().height));
        JPanel responseStatPanel = new JPanel();
        responseStatPanel.setLayout(new BoxLayout(responseStatPanel, 0));
        responseStatPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        responseStatPanel.add(this.responseStatLabel);
        responseStatPanel.add(Box.createHorizontalGlue());
        responseStatPanel.add(this.responseStatComboBox);
        responseStatPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        Object showRespStats = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)818);
        Object isMRBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)821);
        if (showRespStats != null && ((Boolean)isMRBar).booleanValue()) {
            this.responseStatLabel.setEnabled(false);
            this.responseStatComboBox.setEnabled(false);
        }
        JPanel groupTypePanel = new JPanel();
        groupTypePanel.setLayout(new BoxLayout(groupTypePanel, 0));
        groupTypePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        groupTypePanel.add(this.groupDisplayTypeLabel);
        groupTypePanel.add(Box.createHorizontalGlue());
        groupTypePanel.add(this.groupDisplayTypeComboBox);
        groupTypePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        Object isGroupedBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)822);
        if (isGroupedBar != null && ((Boolean)isGroupedBar).booleanValue()) {
            this.groupDisplayTypeLabel.setEnabled(false);
            this.groupDisplayTypeComboBox.setEnabled(false);
        }
        PropertyInterface bar = null;
        if (this.propListeners.size() > 0) {
            bar = (PropertyInterface)this.propListeners.elementAt(0);
        }
        if (!(bar instanceof GraphInterface) || bar.isPropertySupported(34)) {
            this.add(Box.createRigidArea(new Dimension(0, GAP)));
            this.add(nBarsPanel);
            this.add(showLabelPanel);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)groupTypePanel, "North");
        panel.add(Box.createRigidArea(new Dimension(0, 4 * GAP)));
        if (showRespStats != null) {
            panel.add((Component)responseStatPanel, "Center");
        }
        panel.add((Component)new JPanel(), "South");
        Object showOtherBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)830);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)panel, "North");
        if (showOtherBar != null) {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)showBarPanel, "North");
            p.add((Component)otherBarPanel, "Center");
            mainPanel.add((Component)p, "Center");
        }
        this.add(mainPanel);
    }

    public void setInitialValues() {
        this.ignoreEvents = true;
        this.byScheme = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)806);
        Object colorBy = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)815);
        if (colorBy != null) {
            this.colorByCheckBox.setSelected(true);
            this.colorByComboBox.setSelectedItem(colorBy);
        } else {
            this.colorByCheckBox.setSelected(false);
        }
        if (this.byScheme) {
            this.colorByCheckBox.setEnabled(false);
            this.colorByComboBox.setEnabled(false);
        } else {
            this.colorByCheckBox.setEnabled(true);
            this.colorByComboBox.setEnabled(true);
        }
        if (this.colorByCheckBox.isEnabled() && this.colorByCheckBox.isSelected()) {
            this.colorByComboBox.setEnabled(true);
        } else {
            this.colorByComboBox.setEnabled(false);
        }
        boolean on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)803);
        if (on) {
            this.outlineCheckBox.setSelected(true);
        } else {
            this.outlineCheckBox.setSelected(false);
        }
        boolean gradientDisable = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)813);
        if (gradientDisable) {
            this.gradientOnCheckBox.setEnabled(false);
        } else {
            this.gradientOnCheckBox.setEnabled(true);
            on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)812);
            this.gradientOnCheckBox.setSelected(on);
        }
        on = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)816);
        this.showLabelCheckBox.setSelected(on);
        double widthVal = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)804)).doubleValue();
        this.widthSlider.setValue((int)(widthVal * 100.0));
        this.sliderArgs[0] = new Double(widthVal);
        this.widthLabel.setText(MessageFormat.format(this.widthSliderPattern, this.sliderArgs));
        Object isGrouped = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)822);
        Object isClustered = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)820);
        if (isGrouped != null) {
            boolean b1 = (Boolean)isGrouped;
            boolean b2 = isClustered != null && ((Number)isClustered).intValue() == 1;
            double clusterWidthVal = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)823)).doubleValue();
            this.clusterWidthSlider.setValue((int)(clusterWidthVal * 100.0));
            this.clusterSliderArgs[0] = new Double(clusterWidthVal);
            this.ClusterWidthLabel.setText(MessageFormat.format(this.clusterWidthSliderPattern, this.clusterSliderArgs));
            this.clusterWidthSlider.setEnabled(b1 && b2);
            this.ClusterWidthLabel.setEnabled(b1 && b2);
        }
        int maxBars = (Integer)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810);
        int[] barRange = (int[])PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)809);
        this.from = barRange[0];
        this.to = barRange[1];
        this.fromField.setText(String.valueOf(this.from));
        this.toField.setText(String.valueOf(Math.min(this.to, maxBars)));
        Object showRespStats = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)818);
        Object isMRBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)821);
        boolean b = (Boolean)isMRBar;
        if (showRespStats != null) {
            this.responseStatComboBox.setSelectedIndex((Integer)showRespStats);
            this.responseStatLabel.setEnabled(!b);
            this.responseStatComboBox.setEnabled(!b);
        }
        this.ignoreEvents = false;
        Object grpTypeValue = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)820);
        this.groupDisplayTypeComboBox.setSelectedIndex((Integer)grpTypeValue);
        Object isGroupedBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)822);
        b = (Boolean)isGroupedBar;
        this.groupDisplayTypeComboBox.setEnabled(b);
        this.groupDisplayTypeLabel.setEnabled(b);
        Object otherBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)830);
        Object disableOtherBar = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)835);
        boolean b1 = (Boolean)isMRBar;
        boolean b2 = (Boolean)isGroupedBar;
        if (disableOtherBar != null) {
            boolean b3 = (Boolean)disableOtherBar;
            this.showOtherBar.setEnabled(!b1 && !b2 && !b3);
        } else {
            this.showOtherBar.setEnabled(!b1 && !b2);
        }
        if (otherBar != null) {
            this.showOtherBar.setSelected((Boolean)otherBar);
            Object bars = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)832);
            if (bars != null && bars instanceof Number && (Integer)bars > 0) {
                this.maxBar = (Integer)bars;
                if (!this.maxBarTextField.getText().equalsIgnoreCase(String.valueOf(this.maxBar))) {
                    this.maxBarTextField.setText(String.valueOf(this.maxBar));
                }
            }
            this.enableOtherBlock();
        }
    }

    private void addListeners() {
        this.colorByCheckBox.addItemListener(this);
        this.colorByComboBox.addItemListener(this);
        this.outlineCheckBox.addItemListener(this);
        this.gradientOnCheckBox.addItemListener(this);
        this.showLabelCheckBox.addItemListener(this);
        this.showOtherBar.addItemListener(this);
        this.maxBarThresholdRadio.addItemListener(this);
        this.percentThresholdRadio.addItemListener(this);
        this.responseThresholdRadio.addItemListener(this);
        this.maxBarTextField.getDocument().addDocumentListener(this);
        this.percentSpin.addChangeListener(this);
        this.responseTextField.getDocument().addDocumentListener(this);
        this.widthSlider.addChangeListener(this);
        this.clusterWidthSlider.addChangeListener(this);
        this.fromField.getDocument().addDocumentListener(this);
        this.toField.getDocument().addDocumentListener(this);
        this.responseStatComboBox.addItemListener(this);
        this.groupDisplayTypeComboBox.addItemListener(this);
    }

    private void removeListeners() {
        this.colorByCheckBox.removeItemListener(this);
        this.colorByComboBox.removeItemListener(this);
        this.outlineCheckBox.removeItemListener(this);
        this.gradientOnCheckBox.removeItemListener(this);
        this.showLabelCheckBox.removeItemListener(this);
        this.showOtherBar.removeItemListener(this);
        this.maxBarThresholdRadio.removeItemListener(this);
        this.percentThresholdRadio.removeItemListener(this);
        this.responseThresholdRadio.removeItemListener(this);
        this.maxBarTextField.getDocument().removeDocumentListener(this);
        this.percentSpin.removeChangeListener(this);
        this.responseTextField.getDocument().removeDocumentListener(this);
        this.widthSlider.removeChangeListener(this);
        this.clusterWidthSlider.removeChangeListener(this);
        this.fromField.getDocument().removeDocumentListener(this);
        this.toField.getDocument().removeDocumentListener(this);
        this.responseStatComboBox.removeItemListener(this);
        this.groupDisplayTypeComboBox.removeItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.colorByCheckBox) {
            this.colorByComboBox.setEnabled(on);
            if (on) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)815, (Object)this.colorByComboBox.getSelectedItem());
            } else if (!this.byScheme) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)815, null);
            }
        }
        if (source == this.colorByComboBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)815, (Object)this.colorByComboBox.getSelectedItem());
        }
        if (source == this.outlineCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)803, (Object)new Boolean(on));
        }
        if (source == this.gradientOnCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)812, (Object)new Boolean(on));
        }
        if (source == this.showLabelCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)816, (Object)new Boolean(on));
        }
        if (source == this.responseStatComboBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)818, (Object)new Integer(this.responseStatComboBox.getSelectedIndex()));
        }
        if (source == this.groupDisplayTypeComboBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)820, (Object)new Integer(this.groupDisplayTypeComboBox.getSelectedIndex()));
        }
        if (source == this.showOtherBar) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)830, (Object)this.showOtherBar.isSelected());
            this.enableOtherBlock();
        }
        if (source == this.maxBarThresholdRadio && this.maxBarThresholdRadio.isSelected() && this.maxBarThresholdRadio.isEnabled()) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)831, (Object)1);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)832, (Object)this.maxBar);
            this.maxBarTextField.setEnabled(true);
            this.percentSpin.setEnabled(false);
            this.responseTextField.setEnabled(false);
        }
        if (source == this.percentThresholdRadio && this.percentThresholdRadio.isSelected() && this.percentThresholdRadio.isEnabled()) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)831, (Object)0);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)833, (Object)this.percentSpin.getValue());
            this.maxBarTextField.setEnabled(false);
            this.percentSpin.setEnabled(true);
            this.responseTextField.setEnabled(false);
        }
        if (source == this.responseThresholdRadio && this.responseThresholdRadio.isSelected() && this.responseThresholdRadio.isEnabled()) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)831, (Object)2);
        }
    }

    private void enableBarRangePanel() {
        boolean b = (Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)830);
        this.toField.setEnabled(!b);
        this.fromField.setEnabled(!b);
    }

    private void enableOtherBlock() {
        this.maxBarTextField.setEnabled(this.showOtherBar.isSelected() && this.showOtherBar.isEnabled());
        this.percentSpin.setEnabled(this.showOtherBar.isSelected() && this.showOtherBar.isEnabled());
        this.responseTextField.setEnabled(this.showOtherBar.isSelected() && this.showOtherBar.isEnabled());
        this.maxBarThresholdRadio.setEnabled(this.showOtherBar.isSelected() && this.showOtherBar.isEnabled());
        this.percentThresholdRadio.setEnabled(this.showOtherBar.isSelected() && this.showOtherBar.isEnabled());
        Object threshold = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)831);
        Object b = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)830);
        if (threshold != null && ((Boolean)b).booleanValue() && this.showOtherBar.isEnabled()) {
            Integer i = (Integer)threshold;
            switch (i) {
                case 0: {
                    if (!this.percentThresholdRadio.isSelected()) {
                        this.percentThresholdRadio.setSelected(true);
                    }
                    this.maxBarTextField.setEnabled(false);
                    this.percentSpin.setEnabled(true);
                    this.responseTextField.setEnabled(false);
                    break;
                }
                case 1: {
                    if (!this.maxBarThresholdRadio.isSelected()) {
                        this.maxBarThresholdRadio.setSelected(true);
                    }
                    this.maxBarTextField.setEnabled(true);
                    this.percentSpin.setEnabled(false);
                    this.responseTextField.setEnabled(false);
                    break;
                }
                case 2: {
                    if (!this.responseThresholdRadio.isSelected()) {
                        this.maxBarTextField.setEnabled(false);
                    }
                    this.percentSpin.setEnabled(false);
                    this.responseTextField.setEnabled(true);
                }
            }
        }
    }

    private JPanel getSpacer(int w, int h) {
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(w, h));
        return spacer;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.widthSlider) {
            int wt = this.widthSlider.getValue();
            this.sliderArgs[0] = new Double((double)wt / 100.0);
            this.widthLabel.setText(MessageFormat.format(this.widthSliderPattern, this.sliderArgs));
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)804, (Object)new Double((double)wt / 100.0));
        } else if (evt.getSource() == this.clusterWidthSlider) {
            int wt = this.clusterWidthSlider.getValue();
            this.clusterSliderArgs[0] = new Double((double)wt / 100.0);
            this.ClusterWidthLabel.setText(MessageFormat.format(this.clusterWidthSliderPattern, this.clusterSliderArgs));
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)823, (Object)new Double((double)wt / 100.0));
        } else if (evt.getSource() == this.percentSpin && this.percentThresholdRadio.isEnabled() && this.percentThresholdRadio.isSelected()) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)833, (Object)this.percentSpin.getValue());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        this.updateTextFieldValue(doc);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        if (doc == this.responseTextField.getDocument() && this.responseThresholdRadio.isEnabled() && this.responseThresholdRadio.isSelected()) {
            String text = this.responseTextField.getText();
            double resp = 0.0;
            if (text != null) {
                try {
                    resp = Double.parseDouble(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)834, (Object)resp);
        } else if (doc == this.maxBarTextField.getDocument() && this.maxBarThresholdRadio.isEnabled() && this.maxBarThresholdRadio.isSelected()) {
            String text = this.maxBarTextField.getText();
            if (text != null) {
                try {
                    this.maxBar = Integer.parseInt(text);
                }
                catch (NumberFormatException nfe) {
                    this.maxBar = (Integer)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810);
                }
            }
            if (this.maxBar >= 1) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)832, (Object)this.maxBar);
            }
        } else {
            this.updateTextFieldValue(doc);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        if (doc == this.responseTextField.getDocument() && this.responseThresholdRadio.isEnabled() && this.responseThresholdRadio.isSelected()) {
            String text = this.responseTextField.getText();
            double resp = 0.0;
            if (text != null) {
                try {
                    resp = Double.parseDouble(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)834, (Object)resp);
        } else {
            this.updateTextFieldValue(doc);
        }
    }

    private void updateTextFieldValue(Document doc) {
        if (this.ignoreEvents) {
            return;
        }
        this.updateTextFields = true;
        int n = -1;
        String s = null;
        if (doc.getLength() > 0) {
            try {
                s = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (s != null) {
                try {
                    n = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n > 0) {
                if (doc == this.fromField.getDocument()) {
                    this.from = n;
                } else {
                    this.to = n;
                }
            }
        } else if (doc == this.fromField.getDocument()) {
            this.from = 1;
        } else {
            this.to = (Integer)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810);
        }
        if (this.updateTextFields) {
            if (this.from > this.to) {
                int[] barRange = (int[])PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)809);
                this.from = barRange[0] + 1;
                this.to = barRange[1] + 1;
            }
            int maxBars = (Integer)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)810);
            this.from = Math.max(1, this.from);
            this.to = Math.min(maxBars, this.to);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)809, (Object)new int[]{this.from, this.to});
            this.updateTextFields = false;
        }
    }

    @Override
    public boolean cancelChanges() {
        boolean rc = PropertyUtils.cancelChanges((Vector)this.propListeners);
        this.setInitialValues();
        return rc;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        boolean rc = PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
        if (rc && this.propListeners.size() == 1) {
            this.layoutPanel();
            this.updatePanelUI(this);
        }
        return rc;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean applyChanges() {
        boolean rc = PropertyUtils.applyChanges((Vector)this.propListeners);
        this.setInitialValues();
        return rc;
    }
}

