/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.LinearTransformPanel;
import com.sas.graphics.silk.ui.LogTransformPanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AxisTransformPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -1074984707711660546L;
    private JList TransformsList = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private Vector propertyListeners = null;
    private MyListModel transformListModel = new MyListModel();
    private LogTransformPanel logTransformPanel = null;
    private LinearTransformPanel linearTransformPanel = null;

    public AxisTransformPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBounds(new Rectangle(0, 0, 300, 100));
        this.add((Component)this.getTransformsList(), "West");
    }

    private JList getTransformsList() {
        if (this.TransformsList == null) {
            this.TransformsList = new JList();
            this.TransformsList.setModel(this.transformListModel);
            this.TransformsList.setSelectionModel(new MyListSelectionModel(this.TransformsList));
            this.TransformsList.setPrototypeCellValue("12345679012345");
            this.TransformsList.setCellRenderer(new MyListCellRenderer());
            this.TransformsList.setForeground(Color.black);
        }
        return this.TransformsList;
    }

    void setPropertyListeners(Vector propertyListeners) {
        this.propertyListeners = propertyListeners;
        if (this.logTransformPanel != null) {
            this.logTransformPanel.setPropertyListeners(propertyListeners);
        }
    }

    void initUI() {
        Object supportedTransforms;
        if (this.propertyListeners == null) {
            return;
        }
        int trans = 1;
        Object transform = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)254);
        if (transform instanceof Number) {
            trans = ((Number)transform).intValue();
            this.updateTransformPanel(trans);
        }
        if ((supportedTransforms = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)252)) != null) {
            this.TransformsList.removeListSelectionListener(this);
            this.transformListModel.clear();
            this.transformListModel.addAll(supportedTransforms);
            Object enabledTransforms = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)253);
            int type = Extract.getSourceType((Object)enabledTransforms);
            int size = Extract.getNumberItems((Object)enabledTransforms, (int)type);
            for (int i = 0; i < size; ++i) {
                int index;
                Object o = Extract.getObject((Object)enabledTransforms, (int)i, (int)type);
                String l = null;
                if (o.toString() == "Linear") {
                    l = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisTransformDialog.AxisTransformLinear.txt", (String)o.toString());
                }
                if (o.toString() == "Log") {
                    l = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisTransformDialog.AxisTransformLog.txt", (String)o.toString());
                }
                if ((index = this.transformListModel.indexOf(l)) < 0) continue;
                this.transformListModel.setEnabled(index, true);
            }
            this.TransformsList.setSelectedIndex(trans - 1);
            this.TransformsList.addListSelectionListener(this);
        }
        if (this.logTransformPanel != null) {
            this.logTransformPanel.initUI();
        }
    }

    void updateTransformPanel(int trans) {
        if (this.linearTransformPanel != null) {
            this.remove(this.linearTransformPanel);
        }
        if (this.logTransformPanel != null) {
            this.remove(this.logTransformPanel);
        }
        if (trans == 1) {
            this.add((Component)this.getLinearTransformPanel(), "Center");
        } else {
            this.add((Component)this.getLogTransformPanel(), "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.TransformsList.getSelectedIndex();
        this.updateTransformPanel(index + 1);
        PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)254, (Object)new Integer(index + 1));
    }

    private LogTransformPanel getLogTransformPanel() {
        if (this.logTransformPanel == null) {
            this.logTransformPanel = new LogTransformPanel();
            if (this.propertyListeners != null) {
                this.logTransformPanel.setPropertyListeners(this.propertyListeners);
                this.logTransformPanel.initUI();
            }
        }
        return this.logTransformPanel;
    }

    private LinearTransformPanel getLinearTransformPanel() {
        if (this.linearTransformPanel == null) {
            this.linearTransformPanel = new LinearTransformPanel();
        }
        return this.linearTransformPanel;
    }

    class MyListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 6968812389868681004L;
        Vector values = new Vector();
        Vector enabled = new Vector();

        MyListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.values.size()) {
                return this.values.elementAt(index);
            }
            return null;
        }

        boolean isEnabled(int index) {
            if (index >= this.values.size()) {
                return false;
            }
            return (Boolean)this.enabled.elementAt(index);
        }

        void setEnabled(int index, boolean enable) {
            if (index >= this.values.size()) {
                return;
            }
            Boolean e = enable ? Boolean.TRUE : Boolean.FALSE;
            this.enabled.setElementAt(e, index);
        }

        @Override
        public int getSize() {
            return this.values.size();
        }

        void clear() {
            this.values.clear();
            this.enabled.clear();
        }

        int indexOf(Object o) {
            return this.values.indexOf(o);
        }

        void addAll(Object list) {
            int type = Extract.getSourceType((Object)list);
            int size = Extract.getNumberItems((Object)list, (int)type);
            for (int i = 0; i < size; ++i) {
                Object o = Extract.getObject((Object)list, (int)i, (int)type);
                if (o == null) continue;
                if (o.toString().equalsIgnoreCase("Linear")) {
                    this.values.add(ResourceLoader.getResourceString((Object)AxisTransformPanel.this.rb, (String)"AxisTransformDialog.AxisTransformLinear.txt", (String)"Linear"));
                } else if (o.toString().equalsIgnoreCase("Log")) {
                    this.values.add(ResourceLoader.getResourceString((Object)AxisTransformPanel.this.rb, (String)"AxisTransformDialog.AxisTransformLog.txt", (String)"Log"));
                } else {
                    this.values.add(o.toString());
                }
                this.enabled.add(Boolean.FALSE);
            }
            this.fireContentsChanged(this, 0, this.values.size());
        }

        void dispose() {
            if (this.values != null) {
                this.values.clear();
            }
            this.values = null;
            if (this.enabled != null) {
                this.enabled.clear();
            }
            this.enabled = null;
        }
    }

    class MyListSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1037563054211039785L;
        private MyListModel listModel = null;

        MyListSelectionModel(JList list) {
            this.listModel = (MyListModel)list.getModel();
            this.setSelectionMode(0);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.listModel.isEnabled(index0)) {
                super.addSelectionInterval(index0, index1);
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.listModel.isEnabled(index0)) {
                super.setSelectionInterval(index0, index1);
            }
        }
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3484412287513458116L;

        MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            this.setText(value.toString());
            MyListModel lm = (MyListModel)list.getModel();
            this.setFont(TabbedPropertiesDialog.dialogFont);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(lm.isEnabled(index));
            if (!this.isEnabled()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
            return this;
        }
    }
}

