/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.FontInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.ui.AxisOptionsDialog;
import com.sas.graphics.silk.ui.AxisTransformDialog;
import com.sas.graphics.silk.ui.RangeModelDialog;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyEvent;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AxisPanel
extends JPanel
implements ActionListener,
FontInterface,
TabPanelInterface,
KeyListener {
    private static final long serialVersionUID = 8271167902660252884L;
    protected boolean internalUpdate;
    protected boolean addCalled;
    protected int fontId;
    protected PropertyInterface curAxis;
    protected PropertyInterface[] axes;
    protected String[] axesNames;
    protected String[] axesDisplayNames;
    protected JLabel AxisChoiceLabel;
    protected JComboBox AxisChoiceCombo;
    protected JPanel LineGrpPanel;
    protected JPanel TickMarksGrpPanel;
    protected JPanel AxisTextGrpPanel;
    protected JCheckBox AxisLineCheckBox;
    protected JCheckBox ShowAxisCB;
    protected JCheckBox ReverseCB;
    protected JLabel WidthLabel;
    protected JComboBox WidthCombo;
    protected JCheckBox MajorTickCheckBox;
    protected JCheckBox GridlinesCheckBox;
    protected JCheckBox MinorTicksCheckBox;
    protected JCheckBox AxisLabelCheckBox;
    protected JTextField AxisLabelTextField;
    protected JButton AxisLabelBtn;
    protected JCheckBox AxisValueCheckBox;
    protected JButton AxisValueBtn;
    protected TitledBorder LineGrpBorder;
    protected TitledBorder TickMarksGrpBorder;
    protected TitledBorder AxisTextGrpBorder;
    protected JColorChooser colorChooser;
    protected TextDialog txtDlg;
    protected AxisTransformDialog transDialog;
    protected AxisOptionsDialog options;
    protected ResourceBundle rb = null;
    protected Vector propertyListeners = new Vector();
    private boolean setCurrentAxis = false;
    protected JButton transformOptionsButton;
    protected JButton referenceValuesButton;
    protected RangeModelDialog referenceValuesDialog;

    public AxisPanel() {
        this.init();
    }

    public AxisPanel(PropertyInterface xAxis, PropertyInterface yAxis) {
        this.init();
        this.axes = new PropertyInterface[2];
        this.axes[0] = xAxis;
        this.axes[1] = yAxis;
        this.axesNames = new String[2];
        this.axesNames[0] = "Horizontal";
        this.axesNames[1] = "Vertical";
        this.axesDisplayNames = new String[2];
        this.axesDisplayNames[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Horizontal.txt", (String)"Horizontal");
        this.axesDisplayNames[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Vertical.txt", (String)"Vertical");
        this.setCurrentAxis = true;
        this.initFromSource();
    }

    private void init() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.addCalled = false;
        this.options = null;
        this.fontId = -1;
        this.internalUpdate = false;
        this.txtDlg = null;
        this.colorChooser = null;
        this.setLayout(null);
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(275, 450));
        this.createControls();
    }

    private void getAxisList() {
        int i;
        if (this.propertyListeners.size() == 0) {
            return;
        }
        Vector allAxes = new Vector();
        Vector allNames = new Vector();
        Vector allDNames = new Vector();
        for (i = 0; i < this.propertyListeners.size(); ++i) {
            PropertyInterface pi = (PropertyInterface)this.propertyListeners.elementAt(i);
            Object a = pi.getPropertyValue(46);
            Object an = pi.getPropertyValue(44);
            Object adn = pi.getPropertyValue(45);
            int aType = Extract.getSourceType((Object)a);
            int anType = Extract.getSourceType((Object)an);
            int adnType = Extract.getSourceType((Object)adn);
            if (Extract.getNumberItems((Object)a, (int)aType) != Extract.getNumberItems((Object)an, (int)anType) || Extract.getNumberItems((Object)a, (int)aType) != Extract.getNumberItems((Object)adn, (int)adnType)) continue;
            Enumeration aEnum = Extract.elements((Object)a);
            Enumeration anEnum = Extract.elements((Object)an);
            Enumeration adnEnum = Extract.elements((Object)adn);
            while (aEnum.hasMoreElements()) {
                Object axis = aEnum.nextElement();
                if (!(axis instanceof PropertyInterface)) continue;
                allAxes.addElement(axis);
                allNames.addElement(anEnum.nextElement());
                allDNames.addElement(adnEnum.nextElement());
            }
        }
        this.axes = new PropertyInterface[allAxes.size()];
        this.axesNames = new String[allAxes.size()];
        this.axesDisplayNames = new String[allAxes.size()];
        for (i = 0; i < allAxes.size(); ++i) {
            this.axes[i] = (PropertyInterface)allAxes.elementAt(i);
            this.axesNames[i] = allNames.elementAt(i).toString();
            this.axesDisplayNames[i] = allDNames.elementAt(i).toString();
        }
    }

    protected void initFromSource() {
        Object o;
        this.AxisChoiceCombo.removeAllItems();
        if (this.axesDisplayNames != null) {
            for (int i = 0; i < this.axesDisplayNames.length; ++i) {
                this.AxisChoiceCombo.addItem(this.axesDisplayNames[i]);
            }
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)252)) == null && this.transformOptionsButton != null) {
            this.remove(this.transformOptionsButton);
        }
    }

    protected void createControls() {
        this.AxisChoiceLabel = new JLabel();
        this.AxisChoiceLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisChoiceCombo = new JComboBox();
        this.AxisChoiceCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.LineGrpPanel = new JPanel();
        this.TickMarksGrpPanel = new JPanel();
        this.AxisTextGrpPanel = new JPanel();
        this.WidthLabel = new JLabel();
        this.WidthLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.WidthCombo = new JComboBox();
        this.WidthCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.MajorTickCheckBox = new JCheckBox();
        this.MajorTickCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.MinorTicksCheckBox = new JCheckBox();
        this.MinorTicksCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.GridlinesCheckBox = new JCheckBox();
        this.GridlinesCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisValueCheckBox = new JCheckBox();
        this.AxisValueCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisValueBtn = new JButton();
        this.AxisValueBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisLabelCheckBox = new JCheckBox();
        this.AxisLabelCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisLabelTextField = new JTextField();
        this.AxisLabelTextField.setFont(TabbedPropertiesDialog.dialogFont);
        this.AxisLabelBtn = new JButton();
        this.AxisLabelBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowAxisCB = new JCheckBox();
        this.ShowAxisCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.LineGrpBorder = new TitledBorder(new EtchedBorder());
        this.LineGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.AxisLineCheckBox = new JCheckBox();
        this.AxisLineCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.TickMarksGrpBorder = new TitledBorder(new EtchedBorder());
        this.TickMarksGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.AxisTextGrpBorder = new TitledBorder(new EtchedBorder());
        this.AxisTextGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.setVisible(false);
        this.ShowAxisCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show.txt", (String)"Show"));
        this.ShowAxisCB.setActionCommand(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show.txt", (String)"Show"));
        this.add(this.ShowAxisCB);
        this.ShowAxisCB.setBounds(192, 12, 60, 24);
        this.AxisChoiceLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Axis.txt", (String)"Axis"));
        this.add(this.AxisChoiceLabel);
        this.AxisChoiceLabel.setForeground(Color.black);
        this.AxisChoiceLabel.setBounds(22, 12, 30, 24);
        this.AxisChoiceCombo.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Select_An_Axis.txt", (String)"Select An Axis"));
        this.add(this.AxisChoiceCombo);
        this.AxisChoiceCombo.setBackground(Color.white);
        this.AxisChoiceCombo.setBounds(56, 12, 130, 24);
        this.ReverseCB = new JCheckBox();
        this.ReverseCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.ReverseCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Reverse.txt", (String)"Reverse"));
        this.ReverseCB.setActionCommand(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Reverse.txt", (String)"Reverse"));
        this.add(this.ReverseCB);
        this.ReverseCB.setBounds(12, 44, 120, 24);
        this.referenceValuesButton = new JButton();
        this.referenceValuesButton.setActionCommand("referenceValues");
        this.referenceValuesButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.referenceValuesButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Reference.txt", (String)"Reference..."));
        this.referenceValuesButton.addActionListener(this);
        this.add(this.referenceValuesButton);
        this.referenceValuesButton.setBounds(140, 73, 120, 24);
        this.transformOptionsButton = new JButton();
        this.transformOptionsButton.setActionCommand("transformOptions");
        this.transformOptionsButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.transformOptionsButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Transform.txt", (String)"Transform..."));
        this.transformOptionsButton.addActionListener(this);
        this.add(this.transformOptionsButton);
        this.transformOptionsButton.setBounds(140, 44, 120, 24);
        this.LineGrpPanel.setLayout(null);
        this.add(this.LineGrpPanel);
        this.LineGrpPanel.setBounds(10, 105, 252, 76);
        this.AxisLineCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show_Line.txt", (String)"Show"));
        this.AxisLineCheckBox.setActionCommand("Line");
        this.LineGrpPanel.add(this.AxisLineCheckBox);
        this.AxisLineCheckBox.setBounds(12, 16, 125, 24);
        this.WidthLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Width.txt", (String)"Width"));
        this.LineGrpPanel.add(this.WidthLabel);
        this.WidthLabel.setForeground(Color.black);
        this.WidthLabel.setBounds(12, 40, 48, 24);
        this.LineGrpPanel.add(this.WidthCombo);
        this.WidthCombo.setBackground(Color.white);
        this.WidthCombo.setBounds(60, 40, 130, 24);
        this.TickMarksGrpPanel.setLayout(null);
        this.add(this.TickMarksGrpPanel);
        this.TickMarksGrpPanel.setBounds(10, 193, 252, 150);
        this.MajorTickCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show_Major_Ticks.txt", (String)"Show Major Ticks"));
        this.MajorTickCheckBox.setActionCommand("Major Ticks");
        this.TickMarksGrpPanel.add(this.MajorTickCheckBox);
        this.MajorTickCheckBox.setBounds(12, 16, 190, 24);
        this.MinorTicksCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show_Minor_Ticks.txt", (String)"Show Minor Ticks"));
        this.MinorTicksCheckBox.setActionCommand("Minor Ticks");
        this.TickMarksGrpPanel.add(this.MinorTicksCheckBox);
        this.MinorTicksCheckBox.setBounds(12, 40, 190, 24);
        this.GridlinesCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show_Gridlines.txt", (String)"Show Gridlines"));
        this.GridlinesCheckBox.setActionCommand("Gridlines");
        this.TickMarksGrpPanel.add(this.GridlinesCheckBox);
        this.GridlinesCheckBox.setBounds(12, 64, 180, 24);
        this.AxisValueCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Show_Values.txt", (String)"Show Values"));
        this.AxisValueCheckBox.setActionCommand("Show Values");
        this.TickMarksGrpPanel.add(this.AxisValueCheckBox);
        this.AxisValueCheckBox.setBounds(12, 88, 180, 24);
        this.AxisValueBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Value_Options....txt", (String)"Value Options..."));
        this.AxisValueBtn.setActionCommand("Value Options...");
        this.TickMarksGrpPanel.add(this.AxisValueBtn);
        this.AxisValueBtn.setBounds(55, 120, 175, 24);
        this.AxisTextGrpPanel.setLayout(null);
        this.add(this.AxisTextGrpPanel);
        this.AxisTextGrpPanel.setBounds(10, 353, 252, 77);
        this.AxisLabelCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Label.txt", (String)"Label"));
        this.AxisLabelCheckBox.setActionCommand("Label");
        this.AxisTextGrpPanel.add(this.AxisLabelCheckBox);
        this.AxisLabelCheckBox.setBounds(24, 16, 76, 24);
        this.AxisLabelTextField.setBounds(100, 16, 132, 24);
        this.AxisLabelTextField.addKeyListener(this);
        this.AxisTextGrpPanel.add(this.AxisLabelTextField);
        this.AxisLabelBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Label_Options....txt", (String)"Label Options..."));
        this.AxisLabelBtn.setActionCommand("Label Options...");
        this.AxisTextGrpPanel.add(this.AxisLabelBtn);
        this.AxisLabelBtn.setBounds(75, 45, 155, 24);
        this.LineGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Line.txt", (String)"Line"));
        this.LineGrpBorder.setTitleColor(Color.black);
        this.LineGrpPanel.setBorder(this.LineGrpBorder);
        this.TickMarksGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Tick_Marks.txt", (String)"Tick Marks"));
        this.TickMarksGrpBorder.setTitleColor(Color.black);
        this.TickMarksGrpPanel.setBorder(this.TickMarksGrpBorder);
        this.AxisTextGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Text.txt", (String)"Text"));
        this.AxisTextGrpBorder.setTitleColor(Color.black);
        this.AxisTextGrpPanel.setBorder(this.AxisTextGrpBorder);
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.1_pt..txt", (String)"1 pt"));
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.2_pt..txt", (String)"2 pt"));
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.3_pt..txt", (String)"3 pt"));
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.4_pt..txt", (String)"4 pt"));
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.5_pt..txt", (String)"5 pt"));
        this.WidthCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.6_pt..txt", (String)"6 pt"));
    }

    protected Color showColorChooserDialog(Color initialColor) {
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Choose_a_color.txt", (String)"Choose a color"), initialColor);
    }

    protected boolean getBooleanProperty(PropertyInterface prop, int id, boolean defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(PropertyInterface prop, int id, Color defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected boolean setProperty(PropertyInterface prop, int id, Object value) {
        if (prop == null) {
            return false;
        }
        PropertyEvent pe = new PropertyEvent(id, (Object)this, value);
        return prop.setPropertyValue(id, (Object)pe);
    }

    protected void selectActiveAxis() {
        if (this.AxisChoiceCombo == null || this.axes == null || this.axes.length == 0 || this.AxisChoiceCombo.getSelectedIndex() < 0) {
            return;
        }
        if (this.setCurrentAxis) {
            switch (this.AxisChoiceCombo.getSelectedIndex()) {
                case 0: {
                    this.setProperty(this.curAxis, 238, new Integer(0));
                    break;
                }
                case 1: {
                    this.setProperty(this.curAxis, 238, new Integer(1));
                }
            }
        } else {
            PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)238, (Object)new PropertyEvent(238, (Object)this, (Object)this.axesNames[this.AxisChoiceCombo.getSelectedIndex()]));
        }
        this.curAxis = this.axes[this.AxisChoiceCombo.getSelectedIndex()];
    }

    protected int getIntegerProperty(PropertyInterface prop, int id) {
        Object o = null;
        if (prop == null) {
            return -1;
        }
        o = prop.getPropertyValue(id);
        if (o == null) {
            return -1;
        }
        if (!(o instanceof Number)) {
            return -1;
        }
        return ((Number)o).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAxisSettings() {
        if (this.curAxis == null) {
            return;
        }
        AxisPanel axisPanel = this;
        synchronized (axisPanel) {
            this.internalUpdate = true;
        }
        boolean axisOn = this.getBooleanProperty(this.curAxis, 237, this.ShowAxisCB.isSelected());
        boolean isDiscrete = this.getBooleanProperty(this.curAxis, 241, false);
        this.ShowAxisCB.setSelected(axisOn);
        boolean isRefLineSupported = this.getBooleanProperty(this.curAxis, 260, true);
        this.referenceValuesButton.setEnabled(isRefLineSupported);
        boolean axisReverse = false;
        if (this.setCurrentAxis) {
            switch (this.AxisChoiceCombo.getSelectedIndex()) {
                case 0: {
                    axisReverse = this.getBooleanProperty(this.curAxis, 244, this.ReverseCB.isSelected());
                    this.ReverseCB.setEnabled(axisOn && this.curAxis.isPropertySupported(244));
                    break;
                }
                case 1: {
                    axisReverse = this.getBooleanProperty(this.curAxis, 245, this.ReverseCB.isSelected());
                    this.ReverseCB.setEnabled(axisOn && this.curAxis.isPropertySupported(245));
                }
            }
        } else {
            axisReverse = this.getBooleanProperty(this.curAxis, 246, this.ReverseCB.isSelected());
            this.ReverseCB.setEnabled(axisOn && this.curAxis.isPropertySupported(246));
        }
        this.ReverseCB.setSelected(axisReverse);
        this.AxisLineCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 200, this.AxisLineCheckBox.isSelected()));
        this.AxisLineCheckBox.setEnabled(axisOn);
        this.LineGrpPanel.setEnabled(axisOn);
        this.WidthLabel.setEnabled(axisOn);
        int i = this.getIntegerProperty(this.curAxis, 202);
        if (i > 0 && i <= this.WidthCombo.getItemCount()) {
            this.WidthCombo.setSelectedIndex(i - 1);
        }
        this.WidthCombo.setEnabled(axisOn);
        this.MajorTickCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 223, this.MajorTickCheckBox.isSelected()));
        this.MajorTickCheckBox.setEnabled(axisOn);
        this.MajorTickCheckBox.setEnabled(axisOn);
        this.GridlinesCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 229, this.GridlinesCheckBox.isSelected()));
        boolean supportsGridline = this.getBooleanProperty(this.curAxis, 251, this.MajorTickCheckBox.isSelected());
        this.GridlinesCheckBox.setEnabled(axisOn && supportsGridline);
        this.TickMarksGrpPanel.setEnabled(axisOn);
        this.AxisTextGrpPanel.setEnabled(axisOn);
        this.MinorTicksCheckBox.setEnabled(axisOn && this.MajorTickCheckBox.isSelected() && !isDiscrete && this.curAxis.isPropertySupported(226));
        this.MinorTicksCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 226, this.MinorTicksCheckBox.isSelected()));
        this.AxisValueCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 213, this.AxisValueCheckBox.isSelected()));
        this.AxisValueCheckBox.setEnabled(axisOn);
        this.AxisValueCheckBox.setEnabled(axisOn);
        this.AxisValueBtn.setEnabled(axisOn);
        this.AxisLabelCheckBox.setSelected(this.getBooleanProperty(this.curAxis, 203, this.AxisLabelCheckBox.isSelected()));
        this.AxisLabelCheckBox.setEnabled(axisOn);
        this.AxisLabelBtn.setEnabled(axisOn);
        this.AxisLabelTextField.setEnabled(axisOn && this.AxisLabelCheckBox.isSelected());
        Object obj = this.curAxis.getPropertyValue(248);
        if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            this.AxisLabelTextField.setEnabled(false);
        }
        if ((obj = this.curAxis.getPropertyValue(204)) != null) {
            this.AxisLabelTextField.setText(obj.toString());
        }
        AxisPanel axisPanel2 = this;
        synchronized (axisPanel2) {
            this.internalUpdate = false;
        }
    }

    protected AxisOptionsDialog createOptionsDialog() {
        Dialog opts = null;
        Container c = this;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            opts = new AxisOptionsDialog((Frame)c);
            break;
        }
        if (opts != null) {
            opts.setModal(true);
        }
        return opts;
    }

    @Override
    public void setVisible(boolean show) {
        if (show && !this.addCalled) {
            this.selectActiveAxis();
            this.updateAxisSettings();
            this.AxisLineCheckBox.addActionListener(this);
            this.ShowAxisCB.addActionListener(this);
            this.ReverseCB.addActionListener(this);
            this.AxisChoiceCombo.addActionListener(this);
            this.MajorTickCheckBox.addActionListener(this);
            this.MinorTicksCheckBox.addActionListener(this);
            this.GridlinesCheckBox.addActionListener(this);
            this.AxisValueCheckBox.addActionListener(this);
            this.AxisLabelCheckBox.addActionListener(this);
            this.WidthCombo.addActionListener(this);
            this.AxisLabelBtn.addActionListener(this);
            this.AxisValueBtn.addActionListener(this);
            this.addCalled = true;
        } else if (!show && this.addCalled) {
            this.AxisLineCheckBox.removeActionListener(this);
            this.ShowAxisCB.removeActionListener(this);
            this.ReverseCB.removeActionListener(this);
            this.AxisChoiceCombo.removeActionListener(this);
            this.MajorTickCheckBox.removeActionListener(this);
            this.MinorTicksCheckBox.removeActionListener(this);
            this.GridlinesCheckBox.removeActionListener(this);
            this.AxisValueCheckBox.removeActionListener(this);
            this.AxisLabelCheckBox.removeActionListener(this);
            this.WidthCombo.removeActionListener(this);
            this.AxisLabelBtn.removeActionListener(this);
            this.AxisValueBtn.removeActionListener(this);
            this.addCalled = false;
        }
        this.getAxisList();
        this.initFromSource();
        super.setVisible(show);
    }

    @Override
    public boolean applyChanges() {
        if (this.axes != null) {
            for (int i = 0; i < this.axes.length; ++i) {
                if (this.axes[i] == null) continue;
                this.axes[i].applyPropertyChanges((Object)this);
            }
        }
        this.updateAxisSettings();
        return true;
    }

    @Override
    public boolean cancelChanges() {
        if (this.axes != null) {
            for (int i = 0; i < this.axes.length; ++i) {
                if (this.axes[i] == null) continue;
                this.axes[i].cancelPropertyChanges((Object)this);
            }
        }
        this.updateAxisSettings();
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        if (!this.propertyListeners.contains(prop)) {
            this.propertyListeners.addElement(prop);
        }
        this.getAxisList();
        this.initFromSource();
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        boolean rc = this.propertyListeners.removeElement(prop);
        this.getAxisList();
        return rc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JComboBox box = null;
        JButton button = null;
        JCheckBox check = null;
        if (this.internalUpdate) return;
        if (this.curAxis == null || source == null) {
            return;
        }
        if (source instanceof JButton) {
            button = (JButton)source;
            if (button == this.AxisLabelBtn) {
                if (this.txtDlg == null && (this.txtDlg = new TextDialog(UIUtilities.getParentFrame(this), (JComponent)this)) == null) {
                    return;
                }
                PropertyInterface prop = (PropertyInterface)this.curAxis.getPropertyValue(249);
                this.txtDlg.showDialog(prop, ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Axis_label_text_options_title.txt", (String)"Axis Label Text options"));
                return;
            } else if (button == this.AxisValueBtn) {
                if (this.txtDlg == null && (this.txtDlg = new TextDialog(UIUtilities.getParentFrame(this), (JComponent)this)) == null) {
                    return;
                }
                PropertyInterface prop = (PropertyInterface)this.curAxis.getPropertyValue(250);
                this.txtDlg.showDialog(prop, ResourceLoader.getResourceString((Object)this.rb, (String)"AxisPanel.Axis_values_text_options_title.txt", (String)"Axis Values Text options"));
                return;
            } else if (button == this.transformOptionsButton) {
                if (this.transDialog == null) {
                    this.transDialog = new AxisTransformDialog(UIUtilities.getParentFrame(this), this.propertyListeners);
                }
                this.transDialog.setVisible(true);
                return;
            } else {
                Object textObj;
                if (button != this.referenceValuesButton) return;
                if (this.referenceValuesDialog == null) {
                    this.referenceValuesDialog = new RangeModelDialog(UIUtilities.getParentDialog(this));
                    UIUtilities.center(this.referenceValuesDialog);
                }
                if ((textObj = this.curAxis.getPropertyValue(250)) instanceof TextStyleInterface) {
                    this.referenceValuesDialog.setValueFormat((SASFormat)((TextStyleInterface)textObj).getFormat());
                }
                boolean rangeEdit = this.getBooleanProperty(this.curAxis, 257, true);
                this.referenceValuesDialog.setEnableRangeEdit(rangeEdit);
                Object rm = this.curAxis.getPropertyValue(256);
                if (!(rm instanceof RangeModel)) return;
                this.referenceValuesDialog.setRangeModel((RangeModel)rm);
                this.referenceValuesDialog.setVisible(true);
            }
            return;
        } else if (source instanceof JComboBox) {
            box = (JComboBox)source;
            if (box.getSelectedItem() == null) {
                return;
            }
            if (box.equals(this.AxisChoiceCombo)) {
                this.selectActiveAxis();
                this.updateAxisSettings();
                return;
            } else {
                if (!box.equals(this.WidthCombo)) return;
                this.setProperty(this.curAxis, 202, new Integer(this.WidthCombo.getSelectedIndex() + 1));
            }
            return;
        } else {
            if (!(source instanceof JCheckBox)) return;
            check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.AxisLineCheckBox)) {
                this.setProperty(this.curAxis, 200, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.ShowAxisCB)) {
                this.setProperty(this.curAxis, 237, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.ReverseCB)) {
                if (this.setCurrentAxis) {
                    switch (this.AxisChoiceCombo.getSelectedIndex()) {
                        case 0: {
                            this.setProperty(this.curAxis, 244, new Boolean(status));
                            break;
                        }
                        case 1: {
                            this.setProperty(this.curAxis, 245, new Boolean(status));
                        }
                    }
                } else {
                    this.setProperty(this.curAxis, 246, new Boolean(status));
                }
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.MajorTickCheckBox)) {
                this.setProperty(this.curAxis, 223, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.MinorTicksCheckBox)) {
                this.setProperty(this.curAxis, 226, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.GridlinesCheckBox)) {
                this.setProperty(this.curAxis, 229, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else if (check.equals(this.AxisValueCheckBox)) {
                this.setProperty(this.curAxis, 213, new Boolean(status));
                this.updateAxisSettings();
                return;
            } else {
                if (!check.equals(this.AxisLabelCheckBox) || this.curAxis == null) return;
                this.setProperty(this.curAxis, 203, new Boolean(status));
                this.updateAxisSettings();
            }
        }
    }

    @Override
    public boolean setFontObject(Font obj) {
        if (this.curAxis == null) {
            return false;
        }
        return this.setProperty(this.curAxis, this.fontId, obj);
    }

    @Override
    public Font getFontObject() {
        Object o = null;
        if (this.curAxis == null) {
            return null;
        }
        o = this.curAxis.getPropertyValue(this.fontId);
        if (o == null || !(o instanceof Font)) {
            return null;
        }
        return (Font)o;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (this.AxisLabelTextField.isEnabled()) {
            this.curAxis.setPropertyValue(204, (Object)new PropertyEvent(204, (Object)this, (Object)this.AxisLabelTextField.getText()));
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

