/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AddRangeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -349101561510679019L;
    private RangeModel rangeModel = null;
    private boolean enableRangeEdit = true;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel addPanel = null;
    private JComboBox typeCombo = null;
    private JLabel typeLabel = null;
    private JLabel valueLabel = null;
    private JLabel toLabel = null;
    private JTextField lowValueField = null;
    private JTextField highValueField = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public AddRangeDialog(Frame parent) {
        super(parent);
        this.initialize();
    }

    public AddRangeDialog(Dialog parent) {
        super(parent);
        this.initialize();
    }

    public void setRangeModel(RangeModel rm) {
        this.rangeModel = rm;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setEnableRangeEdit(boolean b) {
        this.enableRangeEdit = b;
    }

    public boolean getEnableRangeEdit() {
        return this.enableRangeEdit;
    }

    private void initialize() {
        this.setModal(true);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.AddReferenceValue.txt", (String)"Add Reference Value"));
        this.setBounds(new Rectangle(0, 0, 200, 200));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout(5, 5));
            this.jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getAddPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getAddPanel() {
        if (this.addPanel == null) {
            this.addPanel = new JPanel(new BorderLayout(5, 5));
            this.addPanel.add((Component)this.getLeftPanel(), "West");
            this.addPanel.add((Component)this.getRightPanel(), "Center");
        }
        return this.addPanel;
    }

    private JPanel getLeftPanel() {
        JPanel leftPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        leftPanel.add(this.getTypeLabel());
        leftPanel.add(this.getValueLabel());
        return leftPanel;
    }

    private JLabel getTypeLabel() {
        if (this.typeLabel == null) {
            this.typeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.Type.txt", (String)"Type:"));
            this.typeLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.typeLabel.setHorizontalAlignment(2);
            this.typeLabel.setVerticalAlignment(0);
        }
        return this.typeLabel;
    }

    private JLabel getValueLabel() {
        if (this.valueLabel == null) {
            this.valueLabel = new JLabel();
            this.valueLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.valueLabel.setHorizontalAlignment(2);
            this.valueLabel.setVerticalAlignment(0);
        }
        return this.valueLabel;
    }

    private JPanel getRightPanel() {
        JPanel rightPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        rightPanel.add(this.getTypeCombo());
        rightPanel.add(this.getLowValueField());
        rightPanel.add(this.getToLabel());
        rightPanel.add(this.getHighValueField());
        return rightPanel;
    }

    private JComboBox getTypeCombo() {
        if (this.typeCombo == null) {
            this.typeCombo = new JComboBox();
            this.typeCombo.setBackground(Color.WHITE);
            this.typeCombo.setFont(TabbedPropertiesDialog.dialogFont);
            this.typeCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.Value.txt", (String)"Value"));
            this.typeCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.Range.txt", (String)"Range"));
            this.typeCombo.addActionListener(this);
        }
        return this.typeCombo;
    }

    private JLabel getToLabel() {
        if (this.toLabel == null) {
            this.toLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.To.txt", (String)"to"));
            this.toLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.toLabel.setHorizontalAlignment(2);
            this.toLabel.setVerticalAlignment(0);
        }
        return this.toLabel;
    }

    private JTextField getLowValueField() {
        if (this.lowValueField == null) {
            this.lowValueField = new JTextField();
            this.lowValueField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.lowValueField;
    }

    private JTextField getHighValueField() {
        if (this.highValueField == null) {
            this.highValueField = new JTextField();
            this.highValueField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.highValueField;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout(5, 5));
            JPanel gridPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            gridPanel.add(this.getOkButton());
            gridPanel.add(this.getCancelButton());
            this.buttonPanel.add((Component)gridPanel, "East");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.okButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.OK.txt", (String)"OK"));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.Cancel.txt", (String)"Cancel"));
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initGUI();
        }
        super.setVisible(b);
    }

    private void initGUI() {
        this.typeCombo.setSelectedIndex(0);
        this.typeCombo.setEnabled(this.enableRangeEdit);
        this.typeLabel.setEnabled(this.enableRangeEdit);
        this.lowValueField.setText("");
    }

    private boolean addReferenceRange() {
        if (this.rangeModel == null) {
            return true;
        }
        Double low = this.parseTextField(this.lowValueField);
        Double high = this.parseTextField(this.highValueField);
        if (this.typeCombo.getSelectedIndex() == 0 && low != null) {
            this.rangeModel.add(low);
            return true;
        }
        if (low != null && high != null) {
            if (low <= high) {
                this.rangeModel.add(low, true, high, true);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.typeCombo) {
            if (this.typeCombo.getSelectedIndex() == 0) {
                this.toLabel.setVisible(false);
                this.highValueField.setVisible(false);
                this.valueLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.ValueLabel.txt", (String)"Value:"));
            } else {
                this.toLabel.setVisible(true);
                this.highValueField.setVisible(true);
                this.highValueField.setText("");
                this.valueLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.RangeLabel.txt", (String)"Range:"));
            }
        } else if (e.getSource() == this.okButton) {
            if (this.addReferenceRange()) {
                this.setVisible(false);
            } else {
                this.showErrorDialog();
                this.lowValueField.setText("");
                this.highValueField.setText("");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    private void showErrorDialog() {
        String errorTitle = ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.ErrorTitle.txt", (String)"Error");
        String errorMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"AddRangeDialog.ErrorMessage.txt", (String)"Invalid Input");
        JOptionPane.showMessageDialog(this, errorMsg, errorTitle, 0);
    }

    private Double parseTextField(JTextField textField) {
        String s = textField.getText();
        if (s == null) {
            return null;
        }
        Object n = null;
        Double d = null;
        try {
            double v = Double.parseDouble(s);
            d = new Double(v);
        }
        catch (NumberFormatException nfe) {
            d = null;
        }
        return d;
    }
}

