/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.tools;

import com.sas.graphics.silk.util.ResourceLoader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private static Debug instance = null;
    private Logger releaseLogger = null;
    private Hashtable loggers = new Hashtable();
    private Logger defaultLogger = null;

    private Debug() {
        this.loadLoggers();
    }

    private void loadLoggers() {
        Properties p = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/tools/loggers.properties");
        String defaultLog = p.getProperty("default");
        if (defaultLog == null) {
            defaultLog = "com.sas.graphics.silk";
        }
        this.defaultLogger = Logger.getLogger(defaultLog);
        int numLoggers = Integer.valueOf(p.getProperty("num_loggers", "1"));
        for (int i = 0; i < numLoggers; ++i) {
            String name = p.getProperty("logger_" + i);
            Logger l = Logger.getLogger(name);
            String level = p.getProperty("logger_" + i + ".level");
            l.setLevel(Level.parse(level));
            try {
                l.addHandler(new FileHandler(name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.loggers.put(name, l);
            if (this.defaultLogger != null) continue;
            this.defaultLogger = Logger.getLogger("com.sas.graphics.silk");
        }
    }

    public static Logger getLogger(Object caller) {
        Debug instance = Debug.getInstance();
        if (instance.releaseLogger != null) {
            return instance.releaseLogger;
        }
        String logKey = null;
        logKey = caller == null ? "default" : (caller instanceof String ? (String)caller : caller.getClass().getName());
        Object log = instance.loggers.get(logKey);
        if (log != null && log instanceof Logger) {
            return (Logger)log;
        }
        return instance.defaultLogger;
    }

    private static Debug getInstance() {
        if (instance == null) {
            instance = new Debug();
        }
        return instance;
    }
}

