/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.silk.interfaces.TransformInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;

public class Line {
    protected int group;
    protected double x1;
    protected double y1;
    protected double x2;
    protected double y2;
    protected Color color;
    protected static double[] temp = new double[3];
    protected static int[] xPoints = new int[4];
    protected static int[] yPoints = new int[4];

    public Line(double x1, double y1, double x2, double y2, Color color, int grp) {
        this.init(x1, y1, x2, y2, color, grp);
    }

    public void init(double x1, double y1, double x2, double y2, Color color, int grp) {
        this.group = grp;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
    }

    public int getGroupIndex() {
        return this.group;
    }

    public Color getColor() {
        return this.color;
    }

    public void projectEndPoint(TransformInterface transObj, boolean low, double[] out) {
        if (low) {
            transObj.project(this.x1, this.y1, 0.0, out);
        } else {
            transObj.project(this.x2, this.y2, 0.0, out);
        }
    }

    public void draw(Graphics2D g, TransformInterface transObj, boolean fillArea, Color fillColor, double baseLine) {
        this.projectEndPoint(transObj, true, temp);
        int ix1 = (int)temp[0];
        int iy1 = (int)temp[1];
        this.projectEndPoint(transObj, false, temp);
        int ix2 = (int)temp[0];
        int iy2 = (int)temp[1];
        if (fillArea && xPoints != null && yPoints != null) {
            transObj.project(this.x1, baseLine, 0.0, temp);
            int baseY = (int)temp[1];
            Paint save = g.getPaint();
            if (fillColor != null) {
                g.setColor(fillColor);
            } else {
                g.setColor(this.color);
            }
            Line.xPoints[0] = Line.xPoints[3] = ix1;
            Line.xPoints[1] = Line.xPoints[2] = ix2;
            Line.yPoints[0] = Line.yPoints[1] = baseY;
            Line.yPoints[2] = iy2;
            Line.yPoints[3] = iy1;
            g.drawPolygon(xPoints, yPoints, 4);
            g.fillPolygon(xPoints, yPoints, 4);
            if (save != null) {
                g.setPaint(save);
            }
        }
        if (this.color != null) {
            g.setColor(this.color);
        }
        g.drawLine(ix1, iy1, ix2, iy2);
    }
}

