/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.silk.scatter.Hermite;
import com.sas.graphics.silk.util.HControl;
import java.util.Vector;

public class Cardinal
extends Hermite {
    protected double tension;

    public Cardinal(int numsegsIn, double tensionIn) {
        super(numsegsIn);
        this.tension = tensionIn;
    }

    public Cardinal() {
        this(8, 0.0);
    }

    public void calculateTangentVectors(Vector mkrList, int[] indicies, int nMkrs) {
        HControl prevPt = null;
        HControl currPt = null;
        HControl nextPt = null;
        HControl firstKnot = null;
        HControl secondKnot = null;
        HControl lastKnot = null;
        HControl nextToLastKnot = null;
        double t = 0.5 * (1.0 - this.tension);
        for (int im = 0; im < nMkrs; ++im) {
            int i = indicies != null ? indicies[im] : im;
            HControl knot = this.getKnot(mkrList, i);
            if (knot == null) continue;
            if (firstKnot == null) {
                firstKnot = knot;
            } else if (secondKnot == null) {
                secondKnot = knot;
            }
            if (prevPt == null) {
                prevPt = knot;
                continue;
            }
            if (currPt == null) {
                currPt = knot;
                continue;
            }
            if (nextPt == null) {
                nextPt = knot;
            }
            currPt.Tang = nextPt.Pt.subtract(prevPt.Pt).multiply(t);
            prevPt = currPt;
            currPt = nextPt;
            nextPt = null;
        }
        lastKnot = currPt;
        nextToLastKnot = prevPt;
        if (secondKnot != null && firstKnot != null) {
            firstKnot.Tang = secondKnot.Pt.subtract(firstKnot.Pt).multiply(t);
        }
        if (lastKnot != null && nextToLastKnot != null) {
            lastKnot.Tang = lastKnot.Pt.subtract(nextToLastKnot.Pt).multiply(t);
        }
    }
}

