/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.pie;

import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Shape;
import java.util.ResourceBundle;
import java.util.Vector;

public class Slice {
    private Vector observations = null;
    private int[] obsIndexArray = null;
    private boolean[] selectionArray = null;
    private int totalObs = 0;
    private int totalSelectedObs = 0;
    private double responseValue = 0.0;
    private Object sliceName = null;
    private String formattedSliceName = null;
    private int colorIndex = -1;
    private double transparencyValue = Double.NaN;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.pie.silk_pie_NLS");
    private String truncatedDisplayName = null;
    private String sliceURL = null;
    private Color sliceColor = null;
    private Shape sliceShape = null;
    private Object groupId = null;
    private double percentage = 0.0;
    public boolean isMissingSlice = false;
    public boolean isOtherSlice = false;
    private String missingSliceDisplayName = ResourceLoader.getResourceString((Object)this.rb, (String)"Slice.Missing.txt", (String)"Missing");
    private String missingSliceDisplayName1 = ResourceLoader.getResourceString((Object)this.rb, (String)"Slice.Missing1.txt", (String)" ");
    public static String MISSING_SLICE = "__MISSING__SLICE__";
    public static String MISSING_STRING = "__MISSING__STRING__";

    public Slice(Object name, String fName) {
        this.sliceName = name;
        this.formattedSliceName = fName;
        this.reset();
    }

    public void reset() {
        this.observations = null;
        this.obsIndexArray = null;
        this.selectionArray = null;
        this.totalObs = 0;
        this.totalSelectedObs = 0;
        this.responseValue = 0.0;
        this.sliceURL = null;
    }

    public void dispose() {
        this.observations = null;
        this.obsIndexArray = null;
        this.selectionArray = null;
    }

    public void setColorIndex(DataFilterReadInterface data, Object indexVar) {
        Object o = data.getValue(indexVar, (long)this.obsIndexArray[0]);
        int index = -1;
        if (o instanceof Number) {
            index = ((Number)o).intValue();
        }
        this.colorIndex = index >= 0 ? index : -1;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void build(DataFilterReadInterface data, Object response, Object opacity, Object url) {
        if (this.observations == null) {
            return;
        }
        this.totalObs = this.observations.size();
        this.obsIndexArray = new int[this.totalObs];
        this.selectionArray = new boolean[this.totalObs];
        for (int i = 0; i < this.totalObs; ++i) {
            Number d;
            Object value;
            this.obsIndexArray[i] = (Integer)this.observations.elementAt(i);
            this.selectionArray[i] = data.isSelected((long)this.obsIndexArray[i]);
            if (this.selectionArray[i]) {
                ++this.totalSelectedObs;
            }
            if (response == null) {
                this.responseValue += 1.0;
            } else {
                value = data.getValue(response, (long)this.obsIndexArray[i]);
                if (!data.isMissing(response, value) && (d = (Number)value) != null) {
                    this.responseValue += d.doubleValue();
                }
            }
            if (opacity != null) {
                value = data.getValue(opacity, (long)this.obsIndexArray[i]);
                if (!data.isMissing(opacity, value) && (d = (Number)value) != null) {
                    this.transparencyValue = Double.isNaN(this.transparencyValue) ? d.doubleValue() : (this.transparencyValue += d.doubleValue());
                }
            } else {
                this.transparencyValue = Double.NaN;
            }
            if (url != null) {
                Object urlValue = data.getValue(url, (long)this.obsIndexArray[i]);
                if (urlValue == null || data.isMissing(url, urlValue)) continue;
                this.sliceURL = urlValue.toString();
                continue;
            }
            this.sliceURL = null;
        }
        this.observations = null;
    }

    public void toggleAll(DataFilterReadInterface data) {
        if (data instanceof AbstractDataFilter) {
            ((AbstractDataFilter)data).setSelected((Object)this.obsIndexArray, 3, null);
        } else {
            this.selectAll(data);
        }
    }

    public void selectAll(DataFilterReadInterface data) {
        data.setSelected((Object)this.obsIndexArray, true);
    }

    public boolean containsObservation(int index) {
        if (this.obsIndexArray == null) {
            return false;
        }
        for (int i = 0; i < this.obsIndexArray.length; ++i) {
            if (index != this.obsIndexArray[i]) continue;
            return true;
        }
        return false;
    }

    public void updateSelection(int ob, DataFilterReadInterface data) {
        if (this.selectionArray == null) {
            return;
        }
        if (ob < 0) {
            for (int i = 0; i < this.selectionArray.length; ++i) {
                this.selectionArray[i] = false;
            }
            this.totalSelectedObs = 0;
            return;
        }
        if (this.obsIndexArray == null) {
            return;
        }
        for (int i = 0; i < this.obsIndexArray.length; ++i) {
            if (ob != this.obsIndexArray[i]) continue;
            boolean sel = data.isSelected((long)ob);
            if (this.selectionArray[i] != sel && sel) {
                ++this.totalSelectedObs;
            } else if (this.selectionArray[i] != sel) {
                --this.totalSelectedObs;
            }
            this.selectionArray[i] = sel;
        }
    }

    public double getResponseValue() {
        return this.responseValue;
    }

    public void appendObservation(int index) {
        if (this.observations == null) {
            this.observations = new Vector();
        }
        this.observations.addElement(new Integer(index));
    }

    public void appendObservations(int[] arr) {
        if (this.observations == null) {
            this.observations = new Vector();
        }
        for (int ii = 0; ii < arr.length; ++ii) {
            this.observations.add(new Integer(arr[ii]));
        }
    }

    public Object getName() {
        if (this.isMissingSlice) {
            return MISSING_SLICE;
        }
        return this.sliceName;
    }

    public void setTruncatedDisplayName(String s) {
        this.truncatedDisplayName = s;
    }

    public String getDisplayName() {
        if (this.sliceName == null) {
            return null;
        }
        if (this.sliceName.equals(MISSING_SLICE) || this.sliceName instanceof Double && ((Double)this.sliceName).isNaN()) {
            return this.missingSliceDisplayName;
        }
        if (this.sliceName.equals(MISSING_STRING) || this.sliceName instanceof Double && ((Double)this.sliceName).isNaN()) {
            return this.missingSliceDisplayName1;
        }
        if (this.truncatedDisplayName != null) {
            return this.truncatedDisplayName;
        }
        if (this.formattedSliceName != null) {
            return this.formattedSliceName;
        }
        return this.sliceName.toString();
    }

    public String getNonTruncatedDisplayName() {
        if (this.sliceName == null) {
            return null;
        }
        if (this.sliceName.equals(MISSING_SLICE) || this.sliceName instanceof Double && ((Double)this.sliceName).isNaN()) {
            return this.missingSliceDisplayName;
        }
        if (this.sliceName.equals(MISSING_STRING) || this.sliceName instanceof Double && ((Double)this.sliceName).isNaN()) {
            return this.missingSliceDisplayName1;
        }
        if (this.formattedSliceName != null) {
            return this.formattedSliceName;
        }
        return this.sliceName.toString();
    }

    public int getObservationCount() {
        return this.totalObs;
    }

    public int[] getObservations() {
        return this.obsIndexArray;
    }

    public int getSelectionCount() {
        return this.totalSelectedObs;
    }

    public double getTransparencyValue() {
        return this.transparencyValue;
    }

    public String getSliceURL() {
        return this.sliceURL;
    }

    public Color getSliceColor() {
        return this.sliceColor;
    }

    public void setSliceColor(Color sliceColor) {
        this.sliceColor = sliceColor;
    }

    public Shape getSliceShape() {
        return this.sliceShape;
    }

    public void setSliceShape(Shape sliceShape) {
        this.sliceShape = sliceShape;
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Object groupId) {
        this.groupId = groupId;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }
}

