/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.pie;

import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.pie.PieDefaults;
import com.sas.graphics.silk.pie.Slice;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.SortKeyInterface;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class PieDataModel
implements UpdateInterface,
RoleListenerInterface {
    public static final String NO_GROUP = "NO_GROUP";
    private Vector sortedVector = null;
    UniqueValueMapper groups = new UniqueValueMapper();
    private int currentSortGroup = 1;
    private int currentSortResponse = 0;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.pie.silk_pie_NLS");
    DataFilterReadInterface dfri = null;
    RoleManager roles = null;
    boolean updateRequired = false;
    GlobalDefaults silkDefaults = null;
    PieDefaults pieDefaults = null;
    public boolean categoryByFormattedValue = false;
    private Vector allCategories = null;
    private Hashtable unformatToFormatHash = null;
    private boolean tooManyGroups = false;
    private boolean tooManyCategories = false;
    protected int MAX_GROUPS_PER_PIE = 10;
    protected int MAX_SLICES_PER_GROUP = 100;
    private String otherLabel;
    private Color otherColor;
    private int otherThresholdType;
    private boolean otherVisible;
    private double otherThresholdPct;
    private int otherThresholdMaxSlices;

    public PieDataModel(Object dataIn, RoleManager rolesIn) {
        this.dfri = FilterFactory.getDataSourceFilter((Object)dataIn);
        this.roles = rolesIn;
        this.roles.addRoleListener(this);
        this.silkDefaults = new GlobalDefaults();
        this.otherLabel = ResourceLoader.getResourceString((Object)this.rb, (String)"SliceRenderer.Other.txt", (String)"Other");
        this.otherColor = null;
        this.otherVisible = true;
        this.otherThresholdType = 0;
        this.otherThresholdPct = 0.04;
        this.otherThresholdMaxSlices = 10;
        this.pieDefaults = new PieDefaults();
        if (this.pieDefaults.maximumGroupsPerPie > 0) {
            this.MAX_GROUPS_PER_PIE = this.pieDefaults.maximumGroupsPerPie;
        }
        if (this.pieDefaults.maximumSlicesPerGroup > 0) {
            this.MAX_SLICES_PER_GROUP = this.pieDefaults.maximumSlicesPerGroup;
        }
    }

    public String getDefaultLabelSeparator() {
        return this.rb.getString("PieDataModel.labelSeparator.label.txt");
    }

    public Object getGroupVariable() {
        return this.roles.getVariable(RoleInterface.ROLE_GROUP, 0);
    }

    public Object getCategoryVariable() {
        return this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0);
    }

    public RoleManager getRoles() {
        return this.roles;
    }

    public Object getGroupVariableLabel() {
        return this.dfri.getVariableDescription(this.getGroupVariable());
    }

    public DataFilterReadInterface getDataFilter() {
        return this.dfri;
    }

    public Slice[] getSlices(Object groupValue) {
        Group g;
        if (groupValue == null) {
            groupValue = NO_GROUP;
        }
        if ((g = this.getGroup(groupValue)) == null) {
            return null;
        }
        Object[] rc = new Slice[g.slices.size()];
        g.slices.copyInto(rc);
        return rc;
    }

    public boolean setOtherLabel(String s) {
        if (s != null) {
            this.otherLabel = s;
            return true;
        }
        return false;
    }

    public String getOtherLabel() {
        return this.otherLabel;
    }

    public boolean setOtherVisible(boolean b) {
        this.otherVisible = b;
        return true;
    }

    public boolean isOtherVisible() {
        return this.otherVisible;
    }

    public boolean setOtherColor(Color c) {
        this.otherColor = c;
        return true;
    }

    public Color getOtherColor() {
        return this.otherColor;
    }

    public boolean setOtherThresholdType(int i) {
        switch (i) {
            case 0: 
            case 1: {
                this.otherThresholdType = i;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getOtherThresholdType() {
        return this.otherThresholdType;
    }

    public boolean setOtherThresholdPct(double i) {
        if (i >= 0.0 && i <= 100.0) {
            this.otherThresholdPct = i;
            return true;
        }
        return false;
    }

    public double getOtherThresholdPct() {
        return this.otherThresholdPct;
    }

    public boolean setOtherThresholdMaxSlices(int i) {
        if ((double)i > 0.0) {
            this.otherThresholdMaxSlices = i;
            return true;
        }
        return false;
    }

    public int getOtherThresholdMaxSlices() {
        return this.otherThresholdMaxSlices;
    }

    public void dispose() {
        if (this.groups == null) {
            return;
        }
        Object[] values = this.groups.getValues(this.currentSortGroup);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Group g = (Group)values[i];
                for (int j = 0; j < g.slices.size(); ++j) {
                    Slice s = (Slice)g.slices.elementAt(j);
                    s.dispose();
                }
                g.slices.removeAllElements();
            }
        }
        this.groups = null;
    }

    private Slice getSlice(Vector slices, Object category) {
        if (category == null) {
            return null;
        }
        String fName = null;
        Object sliceValue = category;
        if (category.equals(Slice.MISSING_SLICE)) {
            fName = Slice.MISSING_SLICE;
            sliceValue = new Double(Double.NaN);
        } else if (category.equals(Slice.MISSING_STRING)) {
            fName = Slice.MISSING_STRING;
            sliceValue = fName;
        } else {
            fName = (String)category;
        }
        for (int i = 0; i < slices.size(); ++i) {
            Slice slice = (Slice)slices.elementAt(i);
            if (slice.isMissingSlice && Slice.MISSING_SLICE.equals(fName)) {
                return slice;
            }
            if (slice.isMissingSlice && Slice.MISSING_STRING.equals(fName)) {
                return slice;
            }
            String sliceDisplayName = slice.getNonTruncatedDisplayName();
            if (sliceDisplayName != null && this.categoryByFormattedValue) {
                if (fName == null || sliceDisplayName.equals(fName)) {
                    // empty if block
                }
                return (Slice)slices.elementAt(i);
            }
            if (category.toString() == null || !sliceDisplayName.equals(category.toString())) continue;
            return (Slice)slices.elementAt(i);
        }
        Slice newSlice = new Slice(sliceValue, fName);
        slices.addElement(newSlice);
        if (category.equals(Slice.MISSING_SLICE) || category.equals(Slice.MISSING_STRING)) {
            newSlice.isMissingSlice = true;
        }
        return newSlice;
    }

    public Enumeration getGroups() {
        Vector<Object> v = new Vector<Object>();
        Object[] values = this.groups.getValues(this.currentSortGroup);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                v.addElement(((Group)values[i]).groupID);
            }
        }
        return v.elements();
    }

    public int getNumGroups() {
        return this.groups.getNumberValues();
    }

    private void orderSlices(Vector v, int sort) {
        if (sort == 0) {
            return;
        }
        if (sort == 1 || sort == -1) {
            Vector vv = (Vector)CollectionSorter.getValues(Slice.class, v, sort, new CompareInterface(){

                public double getNumericElement(Object entry) {
                    return ((Slice)entry).getResponseValue();
                }

                public String getStringElement(Object entry) {
                    return ((Slice)entry).getDisplayName();
                }
            });
            v.clear();
            v.addAll(vv);
            this.sortedVector.clear();
            this.sortedVector.addAll(vv);
        }
    }

    private Object[] getOrderedGlobalSlices() {
        if (this.sortedVector == null) {
            return null;
        }
        Object[] rc = new Object[this.allCategories.size()];
        this.sortedVector.copyInto(rc);
        return rc;
    }

    private void removeNegativeSlices(Vector v) {
        int i;
        Object[] slices = new Slice[v.size()];
        v.copyInto(slices);
        if (slices == null) {
            return;
        }
        int validSliceCount = 0;
        for (i = 0; i < slices.length; ++i) {
            if (((Slice)slices[i]).getResponseValue() <= 0.0) {
                slices[i] = null;
                continue;
            }
            ++validSliceCount;
        }
        v.removeAllElements();
        for (i = 0; i < slices.length; ++i) {
            if (slices[i] == null) continue;
            v.addElement(slices[i]);
        }
    }

    private boolean createOtherSlice(Group g) {
        if (!this.otherVisible) {
            return false;
        }
        String name = this.otherLabel;
        String fName = this.otherLabel;
        boolean useOtherPct = this.otherThresholdType == 0;
        double totalResp = g.getResponseSum();
        Vector v = g.slices;
        Object[] slices = new Slice[v.size()];
        v.copyInto(slices);
        if (slices == null) {
            return false;
        }
        Slice[] origSlices = new Slice[slices.length];
        System.arraycopy(slices, 0, origSlices, 0, slices.length);
        if (useOtherPct && this.otherThresholdPct == 0.0) {
            return false;
        }
        if (!useOtherPct && this.otherThresholdMaxSlices >= slices.length) {
            return false;
        }
        boolean otherAdded = false;
        int numSlicesInOther = 0;
        double otherVal = 0.0;
        double otherCompare = totalResp * this.otherThresholdPct;
        Slice otherSlice = new Slice(name, fName);
        otherSlice.isOtherSlice = true;
        if (!useOtherPct) {
            Arrays.sort(slices, new Comparator(){

                public int compare(Object a, Object b) {
                    if (Double.compare(((Slice)a).getResponseValue(), ((Slice)b).getResponseValue()) == 0) {
                        return 0;
                    }
                    return ((Slice)a).getResponseValue() < ((Slice)b).getResponseValue() ? 1 : -1;
                }
            });
            otherCompare = slices.length > this.otherThresholdMaxSlices ? ((Slice)slices[this.otherThresholdMaxSlices - 1]).getResponseValue() : 0.0;
        }
        for (int ii = 0; ii < slices.length; ++ii) {
            Object curSlice = slices[ii];
            if (!(((Slice)curSlice).getResponseValue() <= otherCompare)) continue;
            otherVal += ((Slice)curSlice).getResponseValue();
            otherSlice.appendObservations(((Slice)curSlice).getObservations());
            v.remove(curSlice);
            ++numSlicesInOther;
        }
        if (numSlicesInOther == 1) {
            g.slices = new Vector<Slice>(Arrays.asList(origSlices));
            origSlices = null;
            otherVal = 0.0;
        }
        if (otherVal > 0.0) {
            Double NUMBER_OTHER_PLACE_HOLDER = new Double(Double.MAX_VALUE);
            String STRING_OTHER_PLACE_HOLDER = "}Other}";
            Object grp = g.getKeyValue();
            otherSlice.setGroupId(grp);
            otherSlice.build(this.dfri, this.roles.getVariable(RoleInterface.ROLE_RESPONSE, 0), null, null);
            v.add(otherSlice);
            int iii = 0;
            Object[] oa = this.unformatToFormatHash.keySet().toArray();
            while (oa[iii] instanceof Double && ((Double)oa[iii]).isNaN()) {
                ++iii;
            }
            if (this.unformatToFormatHash.keySet().toArray()[iii] instanceof Number) {
                this.unformatToFormatHash.put(NUMBER_OTHER_PLACE_HOLDER, fName);
            } else {
                this.unformatToFormatHash.put("}Other}", fName);
            }
            otherAdded = true;
        }
        return otherAdded;
    }

    public Object[] getGlobalCategoryList() {
        if (this.allCategories == null) {
            return null;
        }
        Object[] rc = new Object[this.allCategories.size()];
        this.allCategories.copyInto(rc);
        return rc;
    }

    protected Object[] fetchUniqueValues(boolean useSubset) {
        Object[] uniqueValues = null;
        if (this.dfri instanceof DataFilterInfoInterface) {
            uniqueValues = ((DataFilterInfoInterface)this.dfri).getUniqueValues(this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0), useSubset);
        }
        return uniqueValues;
    }

    protected int getAllGroupsCount() {
        Object[] uniqueValues = null;
        if (this.dfri instanceof DataFilterInfoInterface) {
            uniqueValues = ((DataFilterInfoInterface)this.dfri).getUniqueValues(this.roles.getVariable(RoleInterface.ROLE_GROUP, 0), false);
        }
        if (uniqueValues == null) {
            return 0;
        }
        return uniqueValues.length;
    }

    public Hashtable getUnformatToFormatHash() {
        return this.unformatToFormatHash;
    }

    @Override
    public boolean build(Object buildData) {
        Object category = this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0);
        Object response = this.roles.getVariable(RoleInterface.ROLE_RESPONSE, 0);
        Object clrindex = this.roles.getVariable(RoleInterface.ROLE_COLOR_INDEX, 0);
        Object opacity = this.roles.getVariable(RoleInterface.ROLE_OPACITY, 0);
        Object trans = this.roles.getVariable(RoleInterface.ROLE_TRANSPARENCY, 0);
        Object url = this.roles.getVariable(RoleInterface.ROLE_URL, 0);
        Object group = this.roles.getVariable(RoleInterface.ROLE_GROUP, 0);
        Object groupIndex = this.roles.getVariable(RoleInterface.ROLE_GROUP_INDEX, 0);
        this.tooManyGroups = false;
        this.tooManyCategories = false;
        this.groups = new UniqueValueMapper();
        this.allCategories = new Vector();
        this.sortedVector = new Vector();
        this.unformatToFormatHash = new Hashtable();
        Object sortOrderGroup = this.roles.getSortOrder(RoleInterface.ROLE_GROUP);
        Object sortOrderResponse = this.roles.getSortOrder(RoleInterface.ROLE_RESPONSE);
        Roles rr = new Roles();
        if (group != null) {
            this.roles.setSupportedSortRoles(new Object[][]{{rr.getRoleObject("ROLE_GROUP")}});
        }
        if (group == null && response != null) {
            this.roles.setSupportedSortRoles(new Object[][]{{rr.getRoleObject("ROLE_RESPONSE")}});
        }
        if (group != null && response != null) {
            this.roles.setSupportedSortRoles(new Object[][]{{rr.getRoleObject("ROLE_GROUP")}, {rr.getRoleObject("ROLE_RESPONSE")}});
        }
        if (group == null && response == null) {
            this.roles.setSupportedSortRoles(null);
        }
        if (groupIndex != null) {
            sortOrderGroup = this.roles.getSortOrder(RoleInterface.ROLE_GROUP_INDEX);
        }
        if (response != null) {
            sortOrderResponse = this.roles.getSortOrder(RoleInterface.ROLE_RESPONSE);
        }
        if (sortOrderGroup == null) {
            this.currentSortGroup = 0;
        } else if (sortOrderGroup.equals(RoleInterface.ROLE_SORT_ASCENDING)) {
            this.currentSortGroup = 1;
        } else if (sortOrderGroup.equals(RoleInterface.ROLE_SORT_DATA)) {
            this.currentSortGroup = 0;
        } else if (sortOrderGroup.equals(RoleInterface.ROLE_SORT_DESCENDING)) {
            this.currentSortGroup = -1;
        }
        if (sortOrderResponse == null) {
            this.currentSortResponse = 0;
        } else if (sortOrderResponse.equals(RoleInterface.ROLE_SORT_ASCENDING)) {
            this.currentSortResponse = 1;
        } else if (sortOrderResponse.equals(RoleInterface.ROLE_SORT_DATA)) {
            this.currentSortResponse = 0;
        } else if (sortOrderResponse.equals(RoleInterface.ROLE_SORT_DESCENDING)) {
            this.currentSortResponse = -1;
        }
        if (this.dfri == null || category == null) {
            return false;
        }
        Object variableId = this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0);
        Object format = this.dfri.getFormat(variableId, null);
        String fName = null;
        for (int i = 0; i < this.dfri.getNumberObservations(category); ++i) {
            Group g;
            Slice s = null;
            if (this.silkDefaults.honorGraphed && !this.dfri.isGraphed((long)i)) continue;
            Object cat = this.dfri.getValue(category, (long)i);
            if (this.dfri.isMissing(this.dfri.getVariableIndex(category), cat)) {
                if (cat instanceof String) {
                    fName = Slice.MISSING_STRING;
                    this.unformatToFormatHash.put(new Double(Double.NaN), fName);
                } else {
                    fName = Slice.MISSING_SLICE;
                    this.unformatToFormatHash.put(new Double(Double.NaN), fName);
                }
            } else {
                fName = this.dfri.getFormattedValue(category, (long)i, format);
                this.unformatToFormatHash.put(cat, fName);
            }
            cat = fName;
            if (cat == null) continue;
            if (!this.allCategories.contains(cat)) {
                this.allCategories.addElement(cat);
            }
            Object grp = null;
            if (group != null) {
                grp = this.dfri.getValue(group, (long)i);
            }
            if (grp == null) {
                grp = NO_GROUP;
            }
            if ((g = this.getGroup(grp)) == null) {
                g = new Group();
                g.groupID = grp;
                if (groupIndex != null) {
                    g.groupIndex = this.dfri.getValue(groupIndex, (long)i);
                }
                g.slices = new Vector();
                this.groups.addValue(g);
            }
            s = this.dfri.isMissing(this.dfri.getVariableIndex(category), cat) ? (cat instanceof String ? this.getSlice(g.slices, Slice.MISSING_STRING) : this.getSlice(g.slices, Slice.MISSING_SLICE)) : this.getSlice(g.slices, cat);
            if (grp != NO_GROUP) {
                s.setGroupId(grp);
            }
            s.appendObservation(i);
        }
        Object[] values = this.groups.getValues(this.currentSortGroup);
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            Group grp = (Group)values[i];
            for (int j = 0; j < grp.slices.size(); ++j) {
                Slice s = (Slice)grp.slices.elementAt(j);
                s.build(this.dfri, response, opacity == null ? trans : opacity, url);
                if (clrindex == null) continue;
                s.setColorIndex(this.dfri, clrindex);
            }
            this.removeNegativeSlices(grp.slices);
            this.orderSlices(grp.slices, this.currentSortResponse);
            this.createOtherSlice(grp);
        }
        Object[] globalCategoryList = null;
        globalCategoryList = this.currentSortResponse == 0 ? this.fetchUniqueValues(false) : this.getOrderedGlobalSlices();
        for (int i = 0; i < values.length; ++i) {
            Group grp = (Group)values[i];
            if (grp == null || grp.slices.size() <= this.MAX_SLICES_PER_GROUP) continue;
            this.tooManyCategories = true;
            return false;
        }
        Group grp = null;
        for (int i = 0; i < values.length; ++i) {
            grp = (Group)values[i];
            int currentPosition = 0;
            block5: for (int m = 0; m < globalCategoryList.length; ++m) {
                for (int n = 0; n < grp.slices.size(); ++n) {
                    Slice s = (Slice)grp.slices.elementAt(n);
                    String name = s.getDisplayName();
                    if (globalCategoryList[m] == null || !globalCategoryList[m].toString().trim().equals(name.trim())) continue;
                    int slicePosInList = this.getSliceNamePosInList(s.getDisplayName(), grp.slices);
                    Slice curSlice = (Slice)grp.slices.get(slicePosInList);
                    grp.slices.remove(slicePosInList);
                    grp.slices.add(currentPosition, curSlice);
                    ++currentPosition;
                    continue block5;
                }
            }
        }
        if (values.length > 1) {
            String[] orderedSliceNames = this.getGroupSliceOrder(values);
            for (int i = 1; i < values.length; ++i) {
                Group g = (Group)values[i];
                int curSlicePos = 0;
                for (int j = 0; j < orderedSliceNames.length; ++j) {
                    int slicePosInList = this.getSliceNamePosInList(orderedSliceNames[j], g.slices);
                    if (slicePosInList == curSlicePos) {
                        ++curSlicePos;
                        continue;
                    }
                    if (slicePosInList < 0) continue;
                    Slice curSlice = (Slice)g.slices.get(slicePosInList);
                    g.slices.remove(slicePosInList);
                    g.slices.add(curSlicePos++, curSlice);
                }
            }
        }
        for (int i = 0; i < values.length; ++i) {
            Group g = (Group)values[i];
            for (int j = 0; j < g.slices.size(); ++j) {
                double localResponseSum = g.getResponseSum();
                ((Slice)g.slices.elementAt(j)).setPercentage(((Slice)g.slices.elementAt(j)).getResponseValue() / localResponseSum);
            }
            if (g.slices.size() <= this.MAX_SLICES_PER_GROUP) continue;
            this.tooManyCategories = true;
            return false;
        }
        this.updateRequired = false;
        if (this.groups.getNumberValues() > this.MAX_GROUPS_PER_PIE) {
            this.tooManyGroups = true;
            return false;
        }
        return true;
    }

    private int getSliceNamePosInList(String name, Vector slices) {
        for (int j = 0; j < slices.size(); ++j) {
            if (!((Slice)slices.get(j)).getDisplayName().equals(name)) continue;
            return j;
        }
        return -1;
    }

    private String[] getGroupSliceOrder(Object[] groupsArray) {
        ArrayList<String> sliceAL = new ArrayList<String>();
        for (int i = 0; i < groupsArray.length; ++i) {
            Group g = (Group)groupsArray[i];
            for (int j = 0; j < g.slices.size(); ++j) {
                String curSliceName = ((Slice)g.slices.elementAt(j)).getDisplayName();
                if (sliceAL.contains(curSliceName)) continue;
                sliceAL.add(curSliceName);
            }
        }
        if (sliceAL.contains(this.otherLabel)) {
            sliceAL.remove(this.otherLabel);
            sliceAL.add(this.otherLabel);
        }
        return sliceAL.toArray(new String[sliceAL.size()]);
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        return this.build(buildData);
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.updateRequired;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        this.updateRequired = true;
    }

    private Group getGroup(Object id) {
        if (this.groups == null) {
            return null;
        }
        Group rc = null;
        Object[] values = this.groups.getValues(this.currentSortGroup);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Group g = (Group)values[i];
                if (!g.groupID.equals(id)) continue;
                rc = g;
            }
        }
        return rc;
    }

    public boolean isTooManyGroups() {
        return this.tooManyGroups;
    }

    public boolean isTooManyCategories() {
        return this.tooManyCategories;
    }

    private class Group
    implements SortKeyInterface {
        Object groupID = null;
        Object groupIndex = null;
        Vector slices = null;

        private Group() {
        }

        public int getKeyType() {
            Object key = this.groupIndex;
            if (key == null) {
                key = this.groupID;
            }
            if (key instanceof Number) {
                return 0;
            }
            return 1;
        }

        public Object getKeyValue() {
            Object key = this.groupIndex;
            if (key == null) {
                key = this.groupID;
            }
            return key;
        }

        public double getNumericKeyValue() {
            Object key = this.getKeyValue();
            if (key instanceof Number) {
                return ((Number)key).doubleValue();
            }
            return Double.NaN;
        }

        public double getResponseSum() {
            double responseSum = 0.0;
            for (int j = 0; j < this.slices.size(); ++j) {
                responseSum += ((Slice)this.slices.elementAt(j)).getResponseValue();
            }
            return responseSum;
        }
    }
}

