/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.histogram;

import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.util.ColorParse;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;

public class HistogramWall
implements GraphBackgroundInterface,
RenderInterface {
    protected static final int SOLID_BACKGROUND = 1;
    protected static final int GRADIENT_BACKGROUND = 2;
    protected static final int IMAGE_BACKGROUND = 3;
    protected Image backImage;
    protected Color backgroundColor;
    protected GradientPaint gradientBackground;
    protected int gradientDirection;
    protected int imageFit;
    protected double imageBlend;
    protected int imageLocX;
    protected int imageLocY;
    protected int backgroundType;
    protected boolean visible;
    protected double opacity;
    protected Rectangle wallBounds;
    protected Component comp;
    protected boolean redrawRequired;
    protected boolean update;

    public HistogramWall(Component parent) {
        this.comp = parent;
        this.backImage = null;
        this.gradientBackground = null;
        this.gradientDirection = 0;
        this.backgroundType = 1;
        this.backgroundColor = new Color(225, 229, 250);
        this.visible = true;
        this.opacity = 1.0;
        this.wallBounds = null;
        this.redrawRequired = true;
        this.update = true;
    }

    public HistogramWall(Component parent, boolean update) {
        this(parent);
        this.update = update;
    }

    public void setWallBounds(Rectangle bounds) {
        this.wallBounds = bounds;
    }

    public boolean isRedrawRequired() {
        return this.redrawRequired;
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] back = new Object[]{this.backgroundType == 2 ? this.gradientBackground : (this.backgroundType == 3 ? this.backImage : this.backgroundColor)};
        return back;
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    @Override
    public boolean supportsImageBackground() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        if (img == null || fitStyle == null) {
            return false;
        }
        if (fitStyle instanceof Number) {
            int fit = ((Number)fitStyle).intValue();
            if (fit < 0 || fit > 3) {
                return false;
            }
            this.imageFit = fit;
        } else {
            if (!(fitStyle instanceof String)) return false;
            if (((String)fitStyle).equalsIgnoreCase("Stretch")) {
                this.imageFit = 0;
            } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                this.imageFit = 1;
            } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                this.imageFit = 2;
            } else {
                if (!((String)fitStyle).equalsIgnoreCase("Locate")) return false;
                this.imageFit = 3;
                this.imageLocX = x;
                this.imageLocY = y;
            }
        }
        this.imageBlend = Math.min(Math.max(blend, 0.0), 1.0);
        MediaTracker imageTracker = new MediaTracker(this.comp);
        imageTracker.addImage(img, 0);
        try {
            imageTracker.waitForAll();
        }
        catch (InterruptedException e) {
            return false;
        }
        this.backImage = img;
        this.gradientBackground = null;
        this.redrawGraphBackground(this.comp);
        this.backgroundType = 3;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        float y2;
        float x2;
        float y1;
        float x1;
        Color c2;
        Color c1;
        if ((startColor == null || endColor == null) && this.gradientBackground == null) {
            return false;
        }
        if (startColor == null) {
            c1 = this.gradientBackground.getColor1();
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = ColorParse.getColorFromString((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = this.gradientBackground.getColor2();
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = ColorParse.getColorFromString((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof Number) {
                this.gradientDirection = ((Number)orientation).intValue();
            } else {
                if (!(orientation instanceof String)) return false;
                if (((String)orientation).equalsIgnoreCase("Vertical")) {
                    this.gradientDirection = 2;
                } else if (((String)orientation).equalsIgnoreCase("Horizontal")) {
                    this.gradientDirection = 0;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    this.gradientDirection = 4;
                }
            }
        }
        int width = this.wallBounds == null ? 10 : this.wallBounds.width;
        int height = this.wallBounds == null ? 10 : this.wallBounds.height;
        switch (this.gradientDirection) {
            case 0: {
                x1 = 0.0f;
                y1 = (float)height * 0.5f;
                x2 = width;
                y2 = y1;
                break;
            }
            case 1: {
                x1 = width;
                y1 = (float)height * 0.5f;
                x2 = 0.0f;
                y2 = y1;
                break;
            }
            case 2: {
                x1 = (float)width * 0.5f;
                y1 = 0.0f;
                x2 = x1;
                y2 = height;
                break;
            }
            case 3: {
                x1 = (float)width * 0.5f;
                y1 = height;
                x2 = x1;
                y2 = 0.0f;
                break;
            }
            case 4: {
                x1 = 0.0f;
                y1 = 0.0f;
                x2 = width;
                y2 = height;
                break;
            }
            default: {
                return false;
            }
        }
        GradientPaint gpNew = null;
        Graphics2D g2 = null;
        gpNew = new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (gpNew == null) {
            return false;
        }
        this.backImage = this.comp.createImage(width, height);
        if (this.backImage != null && (g2 = (Graphics2D)this.backImage.getGraphics()) != null) {
            g2.setPaint(gpNew);
            g2.fillRect(0, 0, width, height);
            g2.dispose();
        }
        this.gradientBackground = gpNew;
        this.imageFit = 0;
        this.imageBlend = 1.0;
        this.redrawGraphBackground(this.comp);
        this.backgroundType = 2;
        return true;
    }

    @Override
    public Color getSolidBackground() {
        if (this.backgroundType == 1) {
            return this.backgroundColor;
        }
        if (this.backgroundType == 2) {
            return this.gradientBackground.getColor1();
        }
        return null;
    }

    @Override
    public boolean setSolidBackground(Object c) {
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            this.backgroundColor = (Color)c;
        } else if (c instanceof String) {
            this.backgroundColor = ColorParse.getColorFromString((String)((String)c));
            if (this.backgroundColor == null) {
                return false;
            }
        } else {
            return false;
        }
        this.backImage = null;
        this.redrawGraphBackground(this.comp);
        this.backgroundType = 1;
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        if (this.update) {
            this.redrawRequired = true;
            c.repaint();
        }
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        this.redrawGraphBackground(this.comp);
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.redrawGraphBackground(this.comp);
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        Composite c;
        Graphics2D g2;
        block13: {
            int height;
            int width;
            int yo;
            int xo;
            block12: {
                AlphaComposite alphaComp;
                if (p == null) {
                    return;
                }
                if (!this.visible) {
                    return;
                }
                g2 = (Graphics2D)p;
                xo = this.wallBounds.x;
                yo = this.wallBounds.y;
                width = this.wallBounds.width;
                height = this.wallBounds.height;
                c = g2.getComposite();
                if (this.opacity < 1.0) {
                    alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
                    g2.setComposite(alphaComp);
                }
                if (this.backImage == null) break block12;
                if (this.imageBlend < 1.0) {
                    alphaComp = AlphaComposite.getInstance(3, (float)this.imageBlend);
                    g2.setComposite(alphaComp);
                }
                switch (this.imageFit) {
                    case 0: {
                        g2.drawImage(this.backImage, xo, yo, width + xo, height + yo, 0, 0, this.backImage.getWidth(this.comp), this.backImage.getHeight(this.comp), this.comp);
                        break;
                    }
                    case 1: {
                        int img_wt = this.backImage.getWidth(this.comp);
                        int img_ht = this.backImage.getHeight(this.comp);
                        for (int x = 0; x < width; x += img_wt) {
                            int w = Math.min(width - x, img_wt);
                            for (int y = 0; y < height; y += img_ht) {
                                int h = Math.min(height - y, img_ht);
                                g2.drawImage(this.backImage, x + xo, y + yo, x + xo + w, y + yo + h, 0, 0, w, h, this.comp);
                            }
                        }
                        break block13;
                    }
                    case 2: {
                        int x = (int)Math.max(0.0, (double)(width - this.backImage.getWidth(this.comp)) * 0.5);
                        int y = (int)Math.max(0.0, (double)(height - this.backImage.getHeight(this.comp)) * 0.5);
                        int w = Math.min(width, this.backImage.getWidth(this.comp));
                        int h = Math.min(height, this.backImage.getHeight(this.comp));
                        g2.drawImage(this.backImage, x + xo, y + yo, x + xo + w, y + yo + h, 0, 0, this.backImage.getWidth(this.comp), this.backImage.getHeight(this.comp), this.comp);
                        break;
                    }
                    case 3: {
                        int x = Math.max(0, Math.min(this.imageLocX, width));
                        int y = Math.max(0, Math.min(this.imageLocY, height));
                        int w = Math.min(width - x, this.backImage.getWidth(this.comp) - x);
                        int h = Math.min(height - y, this.backImage.getHeight(this.comp) - y);
                        g2.drawImage(this.backImage, x + xo, y + yo, x + xo + w, y + yo + h, 0, 0, this.backImage.getWidth(this.comp), this.backImage.getHeight(this.comp), this.comp);
                    }
                }
                break block13;
            }
            g2.setColor(this.backgroundColor);
            g2.fillRect(xo, yo, width, height);
        }
        this.redrawRequired = false;
        g2.setComposite(c);
    }

    @Override
    public void drawHighlight(Object p) {
    }
}

