/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.histogram;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.BarComponent;
import com.sas.graphics.silk.bar.BarChart;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.histogram.ChartInterface;
import com.sas.graphics.silk.histogram.HistogramChart;
import com.sas.graphics.silk.histogram.HistogramModel;
import com.sas.graphics.silk.histogram.HistogramWall;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PrintInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.ToolTip;
import com.sas.graphics.silk.util.ToolTipDefaults;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.PropertyEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public abstract class AbstractComponent
extends JComponent
implements GraphInterface,
GraphBackgroundInterface,
RoleInterface,
UpdateInterface,
TransformInterface,
PrintInterface,
Printable,
MouseListener,
MouseMotionListener,
RedrawListener,
TextListenerInterface,
CellItemInterface,
DataRangeInterface,
PropertyInterface,
GraphPropertyInterface,
ViewportInterface,
ViewportListenerInterface,
ActionListener {
    protected static final int PREVIEW_WIDTH = 300;
    protected static final int PREVIEW_HEIGHT = 200;
    protected static final int MIN_WIDTH = 1;
    protected static final int MIN_HEIGHT = 1;
    protected static final int ERROR_DATA = 1;
    protected static final int ERROR_SPACE = 2;
    protected static final int ERROR_MEMORY = 4;
    protected static final int ERROR_TOO_MANY_BARS = 8;
    protected static final int SOLID_BACKGROUND = 1;
    protected static final int GRADIENT_BACKGROUND = 2;
    protected static final int IMAGE_BACKGROUND = 3;
    protected static final int NONE = 0;
    protected static final int MOVE = 1;
    protected static final int RESIZE_L = 2;
    protected static final int RESIZE_R = 3;
    protected static final int RESIZE_T = 4;
    protected static final int RESIZE_B = 5;
    protected static final int RESIZE_TL = 6;
    protected static final int RESIZE_TR = 7;
    protected static final int RESIZE_BL = 8;
    protected static final int RESIZE_BR = 9;
    protected static final int MIN_SIZE = 4;
    protected static final int HANDLE_SIZE = 6;
    protected static final int DIRECTION_X = 1;
    protected static final int DIRECTION_Y = 2;
    protected static final int DIRECTION_XY = 3;
    protected static final int ZOOM_MIN = 1;
    protected static final int ZOOM_MAX = 2;
    protected static final int ZOOM_BOTH = 3;
    protected int BORDER;
    protected int compWidth;
    protected int compHeight;
    protected int viewportX;
    protected int viewportY;
    protected int viewportWidth;
    protected int viewportHeight;
    protected Rectangle chartClipRect;
    protected int xMargin;
    protected int yMargin;
    protected Image backBuffer;
    protected Image backBuffer2;
    protected Image backImage;
    protected Color backgroundColor;
    protected Color wallColor;
    protected GradientPaint gradientBackground;
    protected int gradientDirection;
    protected int imageFit;
    protected double imageBlend;
    protected int imageLocX;
    protected int imageLocY;
    protected int backgroundType;
    protected Object chart;
    protected Object xAxis;
    protected Object yAxis;
    protected Object id = null;
    protected LegendObject legend;
    protected boolean legendOn;
    protected Rectangle legendBounds;
    protected HistogramWall wall;
    protected Title title;
    protected Footnote footnote;
    protected ColorInterface colorRamp;
    protected ColorSchemeInterface colorScheme;
    protected DataFilterReadInterface dataFilter;
    protected double[] chartBBox;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected double[] min;
    protected double[] max;
    protected Insets chartOuterMargin;
    protected Insets compMargin;
    protected Insets chartMargin;
    protected Insets chartInnerMargin;
    protected boolean userSetOuterMargin;
    protected Rectangle2D.Double rubberband;
    protected Color brushColor;
    protected Point startPt;
    protected boolean rectSelection;
    protected Vector redrawListener;
    protected boolean syncPreview;
    protected double zoomFactor;
    protected int error;
    protected boolean brushMode;
    protected int brushAction;
    protected Rectangle2D.Double resizeL;
    protected Rectangle2D.Double resizeR;
    protected Rectangle2D.Double resizeT;
    protected Rectangle2D.Double resizeB;
    protected Rectangle2D.Double resizeTL;
    protected Rectangle2D.Double resizeTR;
    protected Rectangle2D.Double resizeBL;
    protected Rectangle2D.Double resizeBR;
    protected boolean redrawBKBuffer;
    protected boolean mouseAction;
    protected boolean redrawPreview;
    protected Cursor openMoveCursor;
    protected Cursor closeMoveCursor;
    protected Image openMoveImage;
    protected Image closeMoveImage;
    protected boolean popupOn;
    protected JPopupMenu popup;
    protected Action tBar;
    protected int actionMode;
    protected String resource;
    protected boolean dataListening;
    protected Component toolbar;
    protected boolean userSetToolbar;
    protected Vector marginListeners;
    protected Vector rangeListeners;
    protected Vector viewportListeners;
    protected Vector roleListeners;
    protected ToolTip toolTip;
    protected boolean chartTipsOn;
    protected Point tipPoint;
    protected String tipText;
    protected TabbedPropertiesDialog propertyDialog;
    protected DataOptionsDialog dataDialog;
    protected boolean updatePanels;
    protected Vector propertyIndex;
    protected Vector propertyValue;
    protected int selectedAxis;
    protected boolean applyingChanges;
    protected boolean hScrollbarOn;
    protected boolean vScrollbarOn;
    protected AxisZoomPanHandler xHandler;
    protected AxisZoomPanHandler yHandler;
    protected boolean mouseOnXAxis;
    protected boolean mouseOnYAxis;
    protected double viewportXMin;
    protected double viewportXMax;
    protected double viewportYMin;
    protected double viewportYMax;
    protected ResourceBundle rb;
    protected ResourceBundle SILKrb;
    protected boolean backBufferOn = true;
    protected boolean sbarAreaTooSmall;
    protected int vBarRightMargin;
    protected GlobalDefaults globalDefaults;
    protected Graphics onBuffer;
    protected int rangeSliderXOffset;
    protected int rangeSliderYOffset;
    protected boolean xReverse;
    protected boolean yReverse;
    protected ToolTipDefaults tipDefaults = null;
    protected TooltipHandler tooltipHandler = null;
    protected Timer tooltipTimer = null;
    protected int[] supportedProperties = new int[]{0, 2, 9, 15, 32, 33};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(this.supportedProperties);
    protected ViewportWarningIcon warningIcon = null;
    protected static final Roles ROLES = Roles.getInstance(null);
    protected static final SILKNumber X_ROLE_NAME = ROLES.getRoleObject("ROLE_X");
    protected static final SILKNumber CATEGORY_ROLE_NAME = ROLES.getRoleObject("ROLE_CATEGORY");
    protected static final SILKNumber Y_ROLE_NAME = ROLES.getRoleObject("ROLE_Y");
    protected static final SILKNumber FREQ_ROLE_NAME = ROLES.getRoleObject("ROLE_FREQUENCY");
    protected static final SILKNumber GROUP_ROLE_NAME = ROLES.getRoleObject("ROLE_GROUP");
    protected static final SILKNumber SUBGROUP_ROLE_NAME = ROLES.getRoleObject("ROLE_SUBGROUP");
    protected static final SILKNumber STAT_ROLE_NAME = ROLES.getRoleObject("ROLE_STATISTIC");
    protected static final SILKNumber RESPONSE_ROLE_NAME = ROLES.getRoleObject("ROLE_RESPONSE");
    protected static final SILKNumber TIP_ROLE_NAME = ROLES.getRoleObject("ROLE_TIP");
    protected static final SILKNumber COLORINDEX_ROLE_NAME = ROLES.getRoleObject("ROLE_COLOR_INDEX");
    protected static final SILKNumber ERRORHIGH_ROLE_NAME = ROLES.getRoleObject("ROLE_ERROR_HIGH");
    protected static final SILKNumber ERRORLOW_ROLE_NAME = ROLES.getRoleObject("ROLE_ERROR_LOW");

    public AbstractComponent() {
        this.globalDefaults = new GlobalDefaults();
        this.xMargin = this.globalDefaults.componentXMargin;
        this.yMargin = this.globalDefaults.componentYMargin;
        this.BORDER = this.globalDefaults.componentYMargin;
        this.compWidth = 0;
        this.compHeight = 0;
        this.viewportX = this.xMargin;
        this.viewportY = this.yMargin;
        this.viewportWidth = this.compWidth - 2 * this.xMargin;
        this.viewportHeight = this.compHeight - 2 * this.yMargin;
        this.chartClipRect = new Rectangle(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.backBuffer = null;
        this.backBuffer2 = null;
        this.backImage = null;
        this.gradientBackground = null;
        this.gradientDirection = 0;
        this.backgroundType = 1;
        this.chart = null;
        this.xAxis = null;
        this.yAxis = null;
        this.legend = null;
        this.legendOn = true;
        this.legendBounds = null;
        this.wall = new HistogramWall(this);
        this.title = new Title();
        this.footnote = new Footnote();
        this.chartBBox = null;
        this.min = new double[3];
        this.max = new double[3];
        this.dataFilter = null;
        this.chartOuterMargin = new Insets(0, 0, 0, 0);
        this.compMargin = new Insets(0, 0, 0, 0);
        this.chartMargin = new Insets(0, 0, 0, 0);
        this.chartInnerMargin = null;
        this.userSetOuterMargin = false;
        this.rubberband = null;
        this.rectSelection = false;
        this.brushMode = false;
        this.brushColor = Color.black;
        this.error = 0;
        this.zoomFactor = 1.0;
        this.chartTipsOn = true;
        this.redrawListener = new Vector();
        this.syncPreview = false;
        this.redrawPreview = false;
        this.redrawBKBuffer = true;
        this.mouseAction = false;
        this.openMoveImage = ResourceLoader.getImage((Component)this, (String)"icons/MoveOpen.gif");
        this.closeMoveImage = ResourceLoader.getImage((Component)this, (String)"icons/MoveClosed.gif");
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.histogram.silk_histogram_NLS");
        this.SILKrb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.colorScheme = (ColorSchemeInterface)SILKGlobal.getInstance().getPropertyValue(0);
        if (this.colorScheme.getStyle() != null) {
            Style s = this.colorScheme.getStyle();
            RampStyleElement rampSE = s.getRampStyleElement("ThreeColorRamp");
            this.colorRamp = new ColorRamp((Object)rampSE.getAsRampStyle().getColors(), 0.0, 1.0, 0L);
        }
        this.backgroundColor = this.colorScheme.getColorSchemeItemColor(1);
        this.wallColor = this.colorScheme.getColorSchemeItemColor(15);
        this.wall.setSolidBackground(this.wallColor);
        this.title.setColor(this.colorScheme.getColorSchemeItemColor(13));
        this.footnote.setColor(this.colorScheme.getColorSchemeItemColor(13));
        this.toolTip = new ToolTip();
        this.tooltipHandler = new TooltipHandler();
        this.tipDefaults = new ToolTipDefaults();
        this.tooltipTimer = new Timer(this.tipDefaults.delay, this.tooltipHandler);
        this.tooltipTimer.start();
        this.setDoubleBuffered(false);
        this.popup = null;
        this.popupOn = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.dataListening = true;
        this.title.addTextListener(this);
        this.footnote.addTextListener(this);
        this.toolbar = null;
        this.userSetToolbar = false;
        this.actionMode = 1;
        this.marginListeners = new Vector();
        this.rangeListeners = new Vector();
        this.viewportListeners = new Vector();
        this.roleListeners = new Vector();
        this.propertyIndex = new Vector();
        this.propertyValue = new Vector();
        this.selectedAxis = 0;
        this.propertyDialog = null;
        this.dataDialog = null;
        this.updatePanels = false;
        this.applyingChanges = false;
        this.hScrollbarOn = true;
        this.vScrollbarOn = true;
        this.rangeSliderYOffset = 0;
        this.rangeSliderXOffset = 0;
        this.xReverse = false;
        this.yReverse = false;
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        SILKGlobal.register(this);
        this.warningIcon = new ViewportWarningIcon(this);
        this.setPreferredSize(new Dimension(400, 400));
    }

    protected abstract void createActionComponents();

    protected abstract void setColorsToChart();

    protected abstract void updateChartBoundingBox();

    protected abstract void adjustBoundingBox();

    protected abstract String getToolTipText(int var1, int var2);

    protected abstract boolean createChartElements(Object var1, Object var2);

    protected abstract int getRubberbandingDirection();

    protected abstract TabbedPropertiesDialog getPropertyDialog(PropertyInterface var1);

    protected abstract DataOptionsDialog getDataDialog();

    protected abstract boolean isDiscreteAxis(String var1);

    protected abstract double[] getMinimumViewportRange();

    @Override
    public void addViewportListener(Object listener) {
        if (listener instanceof ViewportListenerInterface && !this.viewportListeners.contains(listener)) {
            this.viewportListeners.addElement(listener);
        }
    }

    @Override
    public void removeViewportListener(Object listener) {
        this.viewportListeners.removeElement(listener);
    }

    @Override
    public void enablePopup(boolean on) {
        this.popupOn = on;
    }

    @Override
    public int getActionMode() {
        return this.actionMode;
    }

    @Override
    public boolean setActionMode(int mode) {
        if (mode == 5) {
            if (this.chart != null && this.error == 0) {
                ((GeometryInterface)this.chart).setBoundingBox(this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0);
                this.viewportXMin = this.dataXMin;
                this.viewportXMax = this.dataXMax;
                this.viewportYMin = this.dataYMin;
                this.viewportYMax = this.dataYMax;
                this.fireViewportEvent(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
                this.brushMode = false;
            }
        } else {
            this.actionMode = mode;
        }
        if (this.actionMode != 1) {
            if (this.brushMode) {
                this.brushMode = false;
                this.repaint();
            } else {
                this.brushMode = false;
            }
        }
        return true;
    }

    @Override
    public boolean setToolBar(Component toolBarIn) {
        if (toolBarIn != null) {
            if (this.toolbar == null && this.popup != null) {
                this.popup.insert(this.tBar, 1);
            }
            this.toolbar = toolBarIn;
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((SILKToolbar)this.toolbar).addListener(this);
            }
        } else if (this.toolbar != null) {
            if (this.toolbar.isShowing()) {
                this.toolbar.setVisible(false);
            }
            this.toolbar = null;
            if (this.popup != null) {
                this.popup.remove(1);
            }
        }
        this.userSetToolbar = true;
        return true;
    }

    @Override
    public boolean areChartTipsOn() {
        return this.chartTipsOn;
    }

    @Override
    public void setChartTipsOn(boolean on) {
        this.chartTipsOn = on;
    }

    @Override
    public TipInterface getChartTip() {
        return this.toolTip;
    }

    @Override
    public String getStyle() {
        return null;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        return false;
    }

    @Override
    public String getColorSchemeName() {
        return this.colorScheme.getSchemeName();
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return this.colorScheme;
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        if (newScheme == null) {
            return false;
        }
        if (newScheme instanceof ColorSchemeInterface) {
            this.colorScheme = (ColorSchemeInterface)newScheme;
        } else if (newScheme instanceof String) {
            this.colorScheme = new ColorScheme((String)newScheme);
        }
        this.userSetProperties.set(0);
        if (this.colorScheme.getStyle() != null) {
            Style s = this.colorScheme.getStyle();
            RampStyleElement rampSE = s.getRampStyleElement("ThreeColorRamp");
            this.colorRamp.setColors(rampSE.getAsRampStyle().getColors());
        }
        this.setSolidBackground(this.colorScheme.getColorSchemeItemColor(1));
        this.setWall(this.colorScheme.getColorSchemeItemColor(15));
        this.title.applyStyle(this.colorScheme.getStyle());
        this.footnote.applyStyle(this.colorScheme.getStyle());
        this.toolTip.applyStyle(this.colorScheme.getStyle());
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        if (this.chart != null) {
            this.setColorsToChart();
        }
        if (this.xAxis != null) {
            this.setColorsToAxis(true);
            this.xHandler.setStyle(this.colorScheme.getStyle());
        }
        if (this.yAxis != null) {
            this.setColorsToAxis(false);
            this.yHandler.setStyle(this.colorScheme.getStyle());
        }
        if (this.legend != null) {
            this.setColorsToLegend();
        }
        return true;
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.dataFilter;
    }

    @Override
    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    @Override
    public boolean setDataListening(boolean listen) {
        this.dataListening = listen;
        if (listen) {
            ((ChartInterface)this.chart).addDataListener();
        } else {
            ((ChartInterface)this.chart).removeDataListener();
        }
        return true;
    }

    @Override
    public boolean isDataListening() {
        return this.dataListening;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        return null;
    }

    @Override
    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    @Override
    public LegendInterface getLegend(Object which) {
        return this.chart != null && this.legend != null ? this.legend : null;
    }

    @Override
    public TextStyleInterface getTitle(int idx) {
        return this.title.getTitle(idx);
    }

    @Override
    public boolean setTitle(int idx, String text) {
        return this.title.setTitle(idx, text);
    }

    @Override
    public boolean setTitle(int idx, TextStyleInterface textObject) {
        return this.title.setTitle(idx, textObject);
    }

    @Override
    public TextStyleInterface getFootnote(int idx) {
        return this.footnote.getFootnote(idx);
    }

    @Override
    public boolean setFootnote(int idx, String text) {
        return this.footnote.setFootnote(idx, text);
    }

    @Override
    public boolean setFootnote(int idx, TextStyleInterface textObject) {
        return this.footnote.setFootnote(idx, textObject);
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.dataFilter == null) {
            return false;
        }
        return this.dataFilter.applyWhereClause(clause, clearPrevious);
    }

    @Override
    public Object getLegendPosition(Object which) {
        if (this.legend == null) {
            return null;
        }
        return this.legend.getLegendNumber(this.legend.getPosition());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLegendPosition(Object which, Object pos) {
        int position = -1;
        if (pos instanceof String) {
            if (((String)pos).equalsIgnoreCase("South")) {
                position = 2;
            } else if (((String)pos).equalsIgnoreCase("North")) {
                position = 1;
            } else if (((String)pos).equalsIgnoreCase("East")) {
                position = 3;
            } else if (((String)pos).equalsIgnoreCase("West")) {
                position = 4;
            } else {
                if (!((String)pos).equalsIgnoreCase("Custom")) return false;
                position = 5;
            }
        } else if (pos instanceof Number) {
            position = ((Number)pos).intValue();
            switch (position) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        int legendPosition = -1;
        if (this.legend != null) {
            legendPosition = this.legend.getPosition();
        }
        if (legendPosition == position) return true;
        legendPosition = position;
        this.legend.setPosition(legendPosition);
        this.updateMaximumLegendSize();
        this.updateComponent(true);
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    @Override
    public Rectangle getLegendBounds() {
        int x = this.legend.getStartPoint().x;
        int y = this.legend.getStartPoint().y;
        int w = this.legend.getPreferredSize().width;
        int h = this.legend.getPreferredSize().height;
        return new Rectangle(x, y, w, h);
    }

    @Override
    public boolean setLegendBounds(Rectangle rect) {
        this.legendBounds = rect;
        this.updateMaximumLegendSize();
        this.updateComponent(true);
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    @Override
    public void dispose() {
        this.chartClipRect = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.backBuffer2 != null) {
            this.backBuffer2.flush();
        }
        this.backBuffer2 = null;
        this.backImage = null;
        this.gradientBackground = null;
        if (this.chart != null) {
            ((ChartInterface)this.chart).removeDataListener();
            this.chart = null;
        }
        this.xAxis = null;
        this.yAxis = null;
        this.removeMouseListener((LegendObjectJ2D)this.legend);
        this.removeMouseMotionListener((LegendObjectJ2D)this.legend);
        this.legend = null;
        this.legendBounds = null;
        this.wall = null;
        if (this.title != null) {
            this.title.removeTextListener(this);
            this.title = null;
        }
        if (this.footnote != null) {
            this.footnote.removeTextListener(this);
            this.footnote = null;
        }
        this.chartBBox = null;
        this.dataFilter = null;
        this.chartOuterMargin = null;
        this.compMargin = null;
        this.rubberband = null;
        this.colorScheme = null;
        this.colorRamp = null;
        this.backgroundColor = null;
        this.wallColor = null;
        this.popup = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
        this.toolbar = null;
        if (this.propertyDialog != null) {
            this.propertyDialog.setVisible(false);
            this.propertyDialog.dispose();
            this.propertyDialog = null;
        }
        if (this.dataDialog != null) {
            this.dataDialog.setVisible(false);
            this.dataDialog.dispose();
            this.dataDialog = null;
        }
        if (this.tooltipTimer != null) {
            this.tooltipTimer.stop();
            if (this.tooltipHandler != null) {
                this.tooltipTimer.removeActionListener(this.tooltipHandler);
            }
        }
        this.tooltipTimer = null;
        this.tooltipHandler = null;
        SILKGlobal.unregister(this);
    }

    @Override
    public Dialog getDialog(Object id, Object listener) {
        PropertyInterface p = null;
        if (listener instanceof PropertyInterface) {
            p = (PropertyInterface)listener;
        }
        if (this.chart == null) {
            return null;
        }
        if (id.toString().equalsIgnoreCase("Properties")) {
            return this.getPropertyDialog(p);
        }
        if (id.toString().equalsIgnoreCase("Data")) {
            return this.getDataDialog();
        }
        return null;
    }

    @Override
    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    @Override
    public String getWhereClause() {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getWhereClause();
    }

    @Override
    public AnnotateInterface getAnnotate() {
        return null;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.createActionComponents();
            this.add(this.popup);
        }
        return this.popup;
    }

    @Override
    public int getSelectionBehavior() {
        return 0;
    }

    @Override
    public Object getSelectionBehaviorValue() {
        return null;
    }

    @Override
    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    @Override
    public void setUsageMode(int mode, boolean onOff) {
    }

    @Override
    public boolean getUsageMode(int mode) {
        return false;
    }

    public Object getChart(Object id) {
        return this.chart;
    }

    @Override
    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object idIn) {
        this.id = idIn;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean setEditable(boolean editable) {
        return false;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    @Override
    public boolean isActionEnabled(String action) {
        return true;
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] back = new Object[]{this.backgroundType == 2 ? this.gradientBackground : (this.backgroundType == 3 ? this.backImage : this.backgroundColor)};
        return back;
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    @Override
    public boolean supportsImageBackground() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        if (img == null || fitStyle == null) {
            return false;
        }
        if (fitStyle instanceof Number) {
            int fit = ((Number)fitStyle).intValue();
            if (fit < 0 || fit > 3) {
                return false;
            }
            this.imageFit = fit;
        } else {
            if (!(fitStyle instanceof String)) return false;
            if (((String)fitStyle).equalsIgnoreCase("Stretch")) {
                this.imageFit = 0;
            } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                this.imageFit = 1;
            } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                this.imageFit = 2;
            } else {
                if (!((String)fitStyle).equalsIgnoreCase("Locate")) return false;
                this.imageFit = 3;
                this.imageLocX = x;
                this.imageLocY = y;
            }
        }
        this.imageBlend = Math.min(Math.max(blend, 0.0), 1.0);
        MediaTracker imageTracker = new MediaTracker(this);
        imageTracker.addImage(img, 0);
        try {
            imageTracker.waitForAll();
        }
        catch (InterruptedException e) {
            return false;
        }
        this.backImage = img;
        this.gradientBackground = null;
        this.redrawGraphBackground(this);
        this.backgroundType = 3;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        float y2;
        float x2;
        float y1;
        float x1;
        Color c2;
        Color c1;
        if ((startColor == null || endColor == null) && this.gradientBackground == null) {
            return false;
        }
        if (startColor == null) {
            c1 = this.gradientBackground.getColor1();
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = ColorParse.getColorFromString((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = this.gradientBackground.getColor2();
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = ColorParse.getColorFromString((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof Number) {
                this.gradientDirection = ((Number)orientation).intValue();
            } else {
                if (!(orientation instanceof String)) return false;
                if (((String)orientation).equalsIgnoreCase("Vertical")) {
                    this.gradientDirection = 2;
                } else if (((String)orientation).equalsIgnoreCase("Horizontal")) {
                    this.gradientDirection = 0;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    this.gradientDirection = 4;
                }
            }
        }
        this.userSetProperties.set(15);
        switch (this.gradientDirection) {
            case 0: {
                x1 = 0.0f;
                y1 = (float)this.compHeight * 0.5f;
                x2 = this.compWidth;
                y2 = y1;
                break;
            }
            case 1: {
                x1 = this.compWidth;
                y1 = (float)this.compHeight * 0.5f;
                x2 = 0.0f;
                y2 = y1;
                break;
            }
            case 2: {
                x1 = (float)this.compWidth * 0.5f;
                y1 = 0.0f;
                x2 = x1;
                y2 = this.compHeight;
                break;
            }
            case 3: {
                x1 = (float)this.compWidth * 0.5f;
                y1 = this.compHeight;
                x2 = x1;
                y2 = 0.0f;
                break;
            }
            case 4: {
                x1 = 0.0f;
                y1 = 0.0f;
                x2 = this.compWidth;
                y2 = this.compHeight;
                break;
            }
            default: {
                return false;
            }
        }
        GradientPaint gpNew = null;
        Graphics2D g2 = null;
        gpNew = new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (gpNew == null) {
            return false;
        }
        this.backImage = this.createImage(this.compWidth, this.compHeight);
        if (this.backImage != null && (g2 = (Graphics2D)this.backImage.getGraphics()) != null) {
            g2.setPaint(gpNew);
            g2.fillRect(0, 0, this.compWidth, this.compHeight);
            g2.dispose();
        }
        this.gradientBackground = gpNew;
        this.imageFit = 0;
        this.imageBlend = 1.0;
        this.redrawGraphBackground(this);
        this.backgroundType = 2;
        return true;
    }

    @Override
    public Color getSolidBackground() {
        if (this.backgroundType == 1) {
            return this.backgroundColor;
        }
        if (this.backgroundType == 2) {
            return this.gradientBackground.getColor1();
        }
        return null;
    }

    @Override
    public boolean setSolidBackground(Object c) {
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            this.backgroundColor = (Color)c;
        } else if (c instanceof String) {
            this.backgroundColor = ColorParse.getColorFromString((String)((String)c));
            if (this.backgroundColor == null) {
                return false;
            }
        } else {
            return false;
        }
        this.userSetProperties.set(21);
        this.backImage = null;
        this.redrawGraphBackground(this);
        this.backgroundType = 1;
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setBackgroundColor(this.backgroundColor);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setBackgroundColor(this.backgroundColor);
        }
        return true;
    }

    public boolean setWall(Object c) {
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            this.wallColor = (Color)c;
        } else if (c instanceof String) {
            this.wallColor = ColorParse.getColorFromString((String)((String)c));
            if (this.wallColor == null) {
                return false;
            }
        } else {
            return false;
        }
        this.wall.setSolidBackground(this.wallColor);
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setWallColor(this.wallColor);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setWallColor(this.wallColor);
        }
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Insets getComponentMargin() {
        Insets margin = new Insets(0, 0, 0, 0);
        margin.top += this.getTitleHeight();
        margin.bottom += this.getFootnoteHeight();
        if (((ChartInterface)this.chart).isLegendRequired() && this.legend.isVisible()) {
            if (!this.legend.isInside()) {
                Dimension d = this.legend.getPreferredSize();
                if (d.width > 0 && d.height > 0) {
                    int legendPosition = this.legend.getPosition();
                    switch (legendPosition) {
                        case 2: 
                        case 8: 
                        case 9: {
                            margin.bottom += d.height + this.BORDER;
                            break;
                        }
                        case 1: 
                        case 6: 
                        case 7: {
                            margin.top += d.height + this.BORDER;
                            break;
                        }
                        case 3: {
                            margin.right += d.width + this.BORDER;
                            break;
                        }
                        case 4: {
                            margin.left += d.width + this.BORDER;
                        }
                    }
                }
            }
            this.legendOn = true;
        } else {
            this.legendOn = false;
        }
        return margin;
    }

    protected int getTitleHeight() {
        int h = 0;
        if (this.title != null) {
            Rectangle r = this.title.getBounds();
            h = r.height;
        }
        return h;
    }

    protected int getFootnoteHeight() {
        int h = 0;
        if (this.footnote != null) {
            Rectangle r = this.footnote.getBounds();
            h += r.height;
        }
        return h;
    }

    protected void setColorsToAxis(boolean X) {
        if (X && this.xAxis == null || !X && this.yAxis == null) {
            return;
        }
        AxisInterface axis = X ? (AxisInterface)this.xAxis : (AxisInterface)this.yAxis;
        ((Axes)axis).applyStyle(this.colorScheme.getStyle());
    }

    protected void setColorsToLegend() {
        if (this.legend == null) {
            return;
        }
        this.legend.applyStyle(this.colorScheme.getStyle());
    }

    protected void updateMaximumLegendSize() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.legend != null) {
            int w = 0;
            int h = 0;
            if (this.legendBounds != null) {
                w = this.legendBounds.width;
                h = this.legendBounds.height;
            } else {
                double fac = this instanceof BarComponent ? 1.0 : 0.7;
                int legendPosition = this.legend.getPosition();
                if (this.legend.isInside()) {
                    if (legendPosition == 2 || legendPosition == 1) {
                        w = this.chartClipRect.width - 2 * this.BORDER;
                        h = (int)(0.3 * (double)this.chartClipRect.height) - 2 * this.BORDER;
                    } else if (legendPosition == 3 || legendPosition == 4) {
                        w = (int)(0.3 * (double)this.chartClipRect.width) - 2 * this.BORDER;
                        h = this.chartClipRect.height - 2 * this.BORDER;
                    } else {
                        w = this.chartClipRect.width - 2 * this.BORDER;
                        h = this.chartClipRect.height - 2 * this.BORDER;
                    }
                } else if (legendPosition == 2 || legendPosition == 8 || legendPosition == 9 || legendPosition == 1 || legendPosition == 6 || legendPosition == 7) {
                    w = (int)((double)this.viewportWidth * fac) - 2 * this.BORDER;
                    h = (int)(0.2 * (double)this.viewportHeight);
                } else if (legendPosition == 3 || legendPosition == 4) {
                    w = (int)(0.2 * (double)this.viewportWidth);
                    h = (int)((double)this.viewportHeight * fac) - this.getTitleHeight() - this.getFootnoteHeight() - 2 * this.BORDER;
                }
            }
            this.legend.setMaximumSize(w, h);
        }
    }

    protected void updateChartOuterMargin() {
        if (this.chart == null) {
            return;
        }
        Dimension d = new Dimension(this.compWidth, this.compHeight);
        ((ChartInterface)this.chart).setChartAreaDimension(d);
        Graphics g = this.onBuffer == null ? this.getGraphics() : this.onBuffer;
        this.chartMargin = ((ChartInterface)this.chart).getOuterMargin((Graphics2D)g);
        if (this.chart instanceof BarChart) {
            this.chartInnerMargin = ((BarChart)this.chart).getInnerMargin();
        }
        this.compMargin = this.getComponentMargin();
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        this.fireMarginChangeEvent(true, true);
    }

    protected void updateChartClipArea() {
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        this.error = w < 1 || h < 1 ? (this.error |= 2) : (this.error &= 0xFFFFFFFD);
        Rectangle newRect = new Rectangle(xo, yo, w, h);
        if (this.brushMode && this.rubberband != null) {
            double wRatio = (double)newRect.width / (double)this.chartClipRect.width;
            double hRatio = (double)newRect.height / (double)this.chartClipRect.height;
            this.rubberband.x = (double)newRect.x + (this.rubberband.x - (double)this.chartClipRect.x) * wRatio;
            this.rubberband.y = (double)newRect.y + (this.rubberband.y - (double)this.chartClipRect.y) * hRatio;
            this.rubberband.width *= wRatio;
            this.rubberband.height *= hRatio;
            this.createHandleRects();
        }
        boolean imce = false;
        this.chartClipRect.setRect(newRect);
        if (imce) {
            this.fireMarginChangeEvent(true, false);
        }
    }

    public void updateComponent(boolean update) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        try {
            if (update) {
                this.updateChartOuterMargin();
            }
            this.updateChartClipArea();
            this.adjustBoundingBox();
        }
        catch (OutOfMemoryError ome) {
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.memory.txt", (String)"Java out of memory error."));
            this.error |= 4;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        super.setBounds(x, y, width, height);
        if (this.compWidth != width || this.compHeight != height) {
            this.resizeComponent(width, height);
        }
    }

    protected void resizeComponent(int width, int height) {
        this.compWidth = width;
        this.compHeight = height;
        if (this.backBufferOn) {
            if (this.backBuffer == null || width > this.backBuffer.getWidth(this) || height > this.backBuffer.getHeight(this) || (double)width < (double)this.backBuffer.getWidth(this) * 0.5 || (double)height < (double)this.backBuffer.getHeight(this) * 0.5) {
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                }
                this.backBuffer = this.createImage(width, height);
            }
            if (this.backBuffer2 == null || width > this.backBuffer2.getWidth(this) || height > this.backBuffer2.getHeight(this) || (double)width < (double)this.backBuffer2.getWidth(this) * 0.5 || (double)height < (double)this.backBuffer2.getHeight(this) * 0.5) {
                if (this.backBuffer2 != null) {
                    this.backBuffer2.flush();
                }
                this.backBuffer2 = this.createImage(width, height);
            }
        }
        this.viewportWidth = this.compWidth - 2 * this.xMargin;
        this.viewportHeight = this.compHeight - 2 * this.yMargin;
        this.title.setComponentBounds(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.footnote.setComponentBounds(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.updateSizes();
        this.redrawBKBuffer = true;
    }

    protected void updateSizes() {
        if (this.legend != null && this.legend.isInside()) {
            this.updateComponent(true);
            this.updateMaximumLegendSize();
        } else {
            this.updateMaximumLegendSize();
            this.updateComponent(true);
        }
    }

    @Override
    public void paint(Graphics g) {
        if ((this.error & 4) != 0) {
            return;
        }
        try {
            super.paint(g);
            Graphics2D g2 = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
            }
            if (this.chartTipsOn) {
                this.toolTip.paint(this, g2, this.tipPoint, this.tipText);
            }
        }
        catch (OutOfMemoryError ome) {
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.memory.txt", (String)"Java out of memory error."));
            this.error |= 4;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.onBuffer = g;
        if (this.applyingChanges) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.backBufferOn && (this.backBuffer == null || this.backBuffer2 == null)) {
            return;
        }
        if (!this.backBufferOn) {
            this.updateComponent(true);
        }
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        if ((this.error & 4) != 0) {
            return;
        }
        if ((this.error & 1) != 0 || (this.error & 8) != 0) {
            this.drawErrorMessage(g);
            return;
        }
        if (this.chart instanceof HistogramChart && !((HistogramChart)this.chart).missingBin && (((HistogramChart)this.chart).getNumberXBins() < 1 || ((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram() && ((HistogramChart)this.chart).getNumberYBins() < 1)) {
            this.drawErrorMessage(g);
            return;
        }
        if (!this.backBufferOn || this.redrawBKBuffer || this.legend != null) {
            this.drawToBackBuffer(g);
        }
        if (!this.backBufferOn) {
            if (this.brushMode && this.rubberband != null) {
                g.setColor(this.brushColor);
                ((Graphics2D)g).draw(this.rubberband);
            }
            if (this.mouseOnXAxis) {
                this.xHandler.drawZoomPanIndicator(g);
            } else if (this.mouseOnYAxis) {
                this.yHandler.drawZoomPanIndicator(g);
            }
            this.xHandler.drawViewportIndicator(g);
            this.yHandler.drawViewportIndicator(g);
            this.warningIcon.draw(g);
            return;
        }
        if (((ChartInterface)this.chart).isHighlightRequired() || this.brushMode && this.rubberband != null) {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            if (((ChartInterface)this.chart).isHighlightRequired()) {
                backGraphics2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
                ((RenderInterface)this.chart).drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.brushMode && this.rubberband != null) {
                backGraphics2.setColor(this.brushColor);
                backGraphics2.draw(this.rubberband);
            }
            if (this.xAxis != null) {
                ((Axes)this.xAxis).drawReferenceRanges(backGraphics2);
            }
            if (this.yAxis != null) {
                ((Axes)this.yAxis).drawReferenceRanges(backGraphics2);
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            backGraphics2.dispose();
        } else {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            if (this.xAxis != null) {
                ((Axes)this.xAxis).drawReferenceRanges(backGraphics2);
            }
            if (this.yAxis != null) {
                ((Axes)this.yAxis).drawReferenceRanges(backGraphics2);
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            backGraphics2.dispose();
        }
        if (this.mouseOnXAxis) {
            this.xHandler.drawZoomPanIndicator(g);
        } else if (this.mouseOnYAxis) {
            this.yHandler.drawZoomPanIndicator(g);
        }
        this.xHandler.drawViewportIndicator(g);
        this.yHandler.drawViewportIndicator(g);
        this.warningIcon.draw(g);
        this.syncPreviewPanel();
    }

    protected void syncPreviewPanel() {
    }

    protected void buildOtherElements(Object buildData) {
    }

    protected void initOtherData() {
    }

    protected boolean isTooManyBars() {
        return false;
    }

    protected boolean isUpdateScrollBars() {
        return true;
    }

    protected int getScrollBarTransform(int which) {
        return 1;
    }

    protected int getZoomPoint() {
        int dir = this.getRubberbandingDirection();
        if (dir == 3) {
            return 3;
        }
        return 2;
    }

    protected int[] get2XZoomBehaviour() {
        int dir = this.getRubberbandingDirection();
        if (dir == 3) {
            return new int[]{4, 1};
        }
        return new int[]{1, 1};
    }

    protected void drawOtherElements(Graphics g, boolean highlight) {
    }

    protected void drawErrorMessage(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.drawBackground(g2);
        String errorMessage = "";
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int ht = 0;
        int xMargin = this.globalDefaults.componentXMargin;
        int yMargin = this.globalDefaults.componentYMargin;
        g2.setColor(this.colorScheme.getColorSchemeItemColor(11));
        if ((this.error & 1) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.data.txt", (String)"Data is not assigned correctly");
        } else if ((this.error & 2) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.data.txt", (String)"Graph area is too small");
        } else if ((this.error & 8) != 0) {
            errorMessage = this instanceof BarComponent ? ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.tooManyBars.txt", (String)"Combination of Category, Subgroup and Group exceeds maximum limit.") : ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.tooManyBins.txt", (String)"Combination of X and Y bins exceeds maximum limit.");
        } else if (this.chart instanceof HistogramChart) {
            ht = fm.getHeight();
            HistogramModel hm = ((HistogramChart)this.chart).getHistogramModel();
            errorMessage = ((HistogramChart)this.chart).getNumberXBins() < 1 || ((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram() && ((HistogramChart)this.chart).getNumberYBins() < 1 ? ResourceLoader.getResourceString((Object)this.SILKrb, (String)"ScatterComponent.Chart_has_no_data.txt", (String)"Chart has no data") : ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.all.missing.data.txt", (String)"Data has all missing values");
            if (hm != null) {
                String str = (String)hm.getVariableDescription("X");
                g2.drawString(str, this.getWidth() / 2 - fm.stringWidth(str) / 2, this.getHeight() - fm.getDescent() - yMargin);
                str = hm.isBivariateHistogram() ? (String)hm.getVariableDescription("Y") : (String)hm.getVariableDescription("STAT");
                if (str == null) {
                    str = ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Frequency.txt", (String)"Frequency");
                }
                g2.drawString(str, this.getX(), this.getY() + yMargin + ht - fm.getDescent());
            }
        }
        g2.drawString(errorMessage, this.getWidth() / 2 - fm.stringWidth(errorMessage) / 2, this.getY() + ht + yMargin + (this.getHeight() - yMargin - ht - (this.getY() + ht + yMargin)) / 2 + ht / 2 - fm.getDescent());
        g2.setColor(this.colorScheme.getColorSchemeItemColor(0));
        g2.drawLine(this.getX() + xMargin, this.getY() + ht + yMargin, this.getX() + xMargin, this.getHeight() - yMargin - ht);
        g2.drawLine(this.getX() + xMargin, this.getHeight() - yMargin - ht, this.getWidth() - xMargin, this.getHeight() - yMargin - ht);
    }

    protected void drawZeroObservation(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font f = ((AxisInterface)this.xAxis).getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.No_Data.txt", (String)"No Data");
        TextLayout msgString = new TextLayout(msg, f, frc);
        Rectangle2D bounds = msgString.getBounds();
        double x = this.chartClipRect.getX() + (this.chartClipRect.getWidth() - bounds.getWidth()) * 0.5;
        double y = this.chartClipRect.getY() + this.chartClipRect.getHeight() * 0.5;
        msgString.draw(g2, (float)x, (float)y);
    }

    protected void drawToBackBuffer(Graphics g) {
        Graphics2D g2 = !this.backBufferOn ? (Graphics2D)g : (Graphics2D)this.backBuffer.getGraphics();
        g2.setClip(0, 0, this.compWidth, this.compHeight);
        this.drawBackground(g2);
        if (this.error == 0) {
            if (this.wall != null) {
                this.wall.setWallBounds(this.chartClipRect);
                this.wall.draw(g2, false);
            }
            if (this.xAxis != null) {
                ((RenderInterface)this.xAxis).draw(g2, false);
            }
            if (this.yAxis != null) {
                ((RenderInterface)this.yAxis).draw(g2, false);
            }
            if (this.chart != null) {
                g2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
                ((RenderInterface)this.chart).draw(g2, !this.backBufferOn);
                g2.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        if (this.legend != null && this.legend.isVisible() && this.legendOn) {
            Dimension d = this.legend.getPreferredSize();
            int xo = 0;
            int yo = 0;
            if (this.legend.isInside()) {
                switch (this.legend.getPosition()) {
                    case 1: {
                        xo = this.chartClipRect.x + (int)(0.5 * (double)this.chartClipRect.width) - (int)(0.5 * (double)d.width);
                        yo = this.chartClipRect.y + this.BORDER;
                        break;
                    }
                    case 6: {
                        xo = this.chartClipRect.x + this.chartClipRect.width - d.width - this.BORDER;
                        yo = this.chartClipRect.y + this.BORDER;
                        break;
                    }
                    case 7: {
                        xo = this.chartClipRect.x + this.BORDER;
                        yo = this.chartClipRect.y + this.BORDER;
                        break;
                    }
                    case 2: {
                        xo = this.chartClipRect.x + (int)(0.5 * (double)this.chartClipRect.width) - (int)(0.5 * (double)d.width);
                        yo = this.chartClipRect.y + this.chartClipRect.height - d.height - this.BORDER;
                        break;
                    }
                    case 8: {
                        xo = this.chartClipRect.x + this.chartClipRect.width - d.width - this.BORDER;
                        yo = this.chartClipRect.y + this.chartClipRect.height - d.height - this.BORDER;
                        break;
                    }
                    case 9: {
                        xo = this.chartClipRect.x + this.BORDER;
                        yo = this.chartClipRect.y + this.chartClipRect.height - d.height - this.BORDER;
                        break;
                    }
                    case 4: {
                        xo = this.chartClipRect.x + this.BORDER;
                        yo = this.chartClipRect.y + (int)(0.5 * (double)this.chartClipRect.height) - (int)(0.5 * (double)d.height);
                        break;
                    }
                    case 3: {
                        xo = this.chartClipRect.x + this.chartClipRect.width - d.width - this.BORDER;
                        yo = this.chartClipRect.y + (int)(0.5 * (double)this.chartClipRect.height) - (int)(0.5 * (double)d.height);
                    }
                }
            } else {
                int legendPosition = this.legend.getPosition();
                switch (legendPosition) {
                    case 2: {
                        xo = this.viewportX + (int)(0.5 * (double)(this.viewportWidth - d.width));
                        yo = this.viewportY + this.viewportHeight - this.compMargin.bottom + this.BORDER;
                        break;
                    }
                    case 9: {
                        xo = this.viewportX;
                        yo = this.viewportY + this.viewportHeight - this.compMargin.bottom + this.BORDER;
                        break;
                    }
                    case 8: {
                        xo = this.viewportX + this.viewportWidth - d.width;
                        yo = this.viewportY + this.viewportHeight - this.compMargin.bottom + this.BORDER;
                        break;
                    }
                    case 1: {
                        xo = this.viewportX + (int)(0.5 * (double)(this.viewportWidth - d.width));
                        yo = this.viewportY + this.getTitleHeight();
                        break;
                    }
                    case 7: {
                        xo = this.viewportX;
                        yo = this.viewportY + this.getTitleHeight();
                        break;
                    }
                    case 6: {
                        xo = this.viewportX + this.viewportWidth - d.width;
                        yo = this.viewportY + this.getTitleHeight();
                        break;
                    }
                    case 3: {
                        xo = this.viewportX + this.viewportWidth - this.compMargin.right + this.BORDER;
                        yo = this.viewportY + this.getTitleHeight() + (int)(0.5 * (double)(this.viewportHeight - this.getTitleHeight() - this.getFootnoteHeight() - d.height));
                        break;
                    }
                    case 4: {
                        xo = this.viewportX;
                        yo = this.viewportY + this.getTitleHeight() + (int)(0.5 * (double)(this.viewportHeight - this.getTitleHeight() - this.getFootnoteHeight() - d.height));
                        break;
                    }
                    case 5: {
                        if (this.legendBounds == null) break;
                        xo = this.legendBounds.x;
                        yo = this.legendBounds.y;
                    }
                }
            }
            this.legend.setStartPoint(xo, yo);
            this.legend.draw(g2, false);
        }
        this.title.draw(g2, false);
        this.footnote.draw(g2, false);
        this.drawOtherElements(g2, false);
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            this.drawZeroObservation(g2);
        }
        if (!this.backBufferOn) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        g2.dispose();
        backGraphics2.dispose();
        this.redrawBKBuffer = false;
    }

    protected void drawBackground(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.backImage != null) {
            Composite comp = g2.getComposite();
            if (this.imageBlend < 1.0) {
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.compWidth, this.compHeight);
                AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.imageBlend);
                g2.setComposite(alphaComp);
            }
            switch (this.imageFit) {
                case 0: {
                    g2.drawImage(this.backImage, 0, 0, this.compWidth, this.compHeight, 0, 0, this.backImage.getWidth(this), this.backImage.getHeight(this), this);
                    break;
                }
                case 1: {
                    int img_wt = this.backImage.getWidth(this);
                    int img_ht = this.backImage.getHeight(this);
                    for (int x = 0; x < this.compWidth; x += img_wt) {
                        int width = Math.min(this.compWidth - x, img_wt);
                        for (int y = 0; y < this.compHeight; y += img_ht) {
                            int height = Math.min(this.compHeight - y, img_ht);
                            g2.drawImage(this.backImage, x, y, x + width, y + height, 0, 0, width, height, this);
                        }
                    }
                    break;
                }
                case 2: {
                    int x = (int)Math.max(0.0, (double)(this.compWidth - this.backImage.getWidth(this)) * 0.5);
                    int y = (int)Math.max(0.0, (double)(this.compHeight - this.backImage.getHeight(this)) * 0.5);
                    int width = Math.min(this.compWidth, this.backImage.getWidth(this));
                    int height = Math.min(this.compHeight, this.backImage.getHeight(this));
                    g2.drawImage(this.backImage, x, y, x + width, y + height, 0, 0, this.backImage.getWidth(this), this.backImage.getHeight(this), this);
                    break;
                }
                case 3: {
                    int x = Math.max(0, Math.min(this.imageLocX, this.compWidth));
                    int y = Math.max(0, Math.min(this.imageLocY, this.compHeight));
                    int width = Math.min(this.compWidth - x, this.backImage.getWidth(this) - x);
                    int height = Math.min(this.compHeight - y, this.backImage.getHeight(this) - y);
                    g2.drawImage(this.backImage, x, y, x + width, y + height, 0, 0, this.backImage.getWidth(this), this.backImage.getHeight(this), this);
                }
            }
            g2.setComposite(comp);
            return;
        }
        g2.setColor(this.backgroundColor);
        g2.fillRect(0, 0, this.compWidth, this.compHeight);
    }

    protected void brushing(Point pt) {
        double chartClipX = this.chartClipRect.getX();
        double chartClipY = this.chartClipRect.getY();
        double chartClipWidth = this.chartClipRect.getWidth();
        double chartClipHeight = this.chartClipRect.getHeight();
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        switch (this.brushAction) {
            case 1: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, chartClipX + chartClipWidth - this.rubberband.width);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, chartClipY + chartClipHeight - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 6: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 9: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        this.rubberband.x = x;
        this.rubberband.y = y;
        this.rubberband.width = width;
        this.rubberband.height = height;
        boolean sel = ((ChartInterface)this.chart).setSelection(this.rubberband, false);
        this.startPt = pt;
        if (!sel) {
            this.repaint();
        }
    }

    protected void setCursorShape(int action, boolean down) {
        switch (action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (down) {
                    this.setCursor(tk.createCustomCursor(this.closeMoveImage, new Point(6, 2), "icons/MoveClosed.gif"));
                    break;
                }
                this.setCursor(tk.createCustomCursor(this.openMoveImage, new Point(6, 2), "icons/MoveOpen.gif"));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    protected int getMouseSpot(Point pt) {
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    protected void createHandleRects() {
        if (this.rubberband.width > 24.0 && this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
        } else {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
        }
    }

    protected void updateRubberbandInPreview(double[] rubber) {
    }

    protected void zoomGraph(Point pt) {
        double middle;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        int dy = (int)((double)(pt.y - this.startPt.y) * 0.5);
        int dx = (int)((double)(this.startPt.x - pt.x) * 0.5);
        if (dx != 0) {
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            if (xmax + offset - (xmin - offset) > (this.dataXMax - this.dataXMin) * this.globalDefaults.zoomLimitParm) {
                xmin -= offset;
                xmax += offset;
                if (this.getRubberbandingDirection() == 1 || this.getRubberbandingDirection() == 3) {
                    if (xmax - xmin < 1.0) {
                        return;
                    }
                    middle = 0.5 * (this.viewportXMax + this.viewportXMin);
                    xmin = Math.min(middle, Math.max(xmin, this.dataXMin));
                    xmax = Math.max(xmin, Math.min(xmax, this.dataXMax));
                } else if (this.getRubberbandingDirection() == 2) {
                    if (this.getZoomPoint() == 2) {
                        xmin = this.dataXMin;
                        xmax = Math.min(xmax, this.dataXMax);
                    } else if (this.getZoomPoint() == 1) {
                        xmin = Math.max(xmin, this.dataXMin);
                        xmax = this.dataXMax;
                    }
                }
            }
        }
        if (dy != 0) {
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            if (ymax - offset - (ymin + offset) > (this.dataYMax - this.dataYMin) * this.globalDefaults.zoomLimitParm) {
                ymin += offset;
                ymax -= offset;
                if (this.getRubberbandingDirection() == 2 || this.getRubberbandingDirection() == 3) {
                    if (ymax - ymin < 1.0) {
                        return;
                    }
                    middle = 0.5 * (this.viewportYMax + this.viewportYMin);
                    ymin = Math.min(middle, Math.max(ymin, this.dataYMin));
                    ymax = Math.max(ymin, Math.min(ymax, this.dataYMax));
                } else if (this.getZoomPoint() == 2) {
                    ymin = this.dataYMin;
                    ymax = Math.min(ymax, this.dataYMax);
                } else if (this.getZoomPoint() == 1) {
                    ymin = Math.max(ymin, this.dataYMin);
                    ymax = this.dataYMax;
                }
            }
        }
        ((GeometryInterface)this.chart).setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.viewportXMin = xmin;
        this.viewportXMax = xmax;
        this.viewportYMin = ymin;
        this.viewportYMax = ymax;
        this.startPt = pt;
    }

    protected void panGraph(Point pt) {
        double delta;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        if (this.getRubberbandingDirection() == 3 || this.getRubberbandingDirection() == 1) {
            int dx = pt.x - this.startPt.x;
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            xmin -= offset;
            xmax -= offset;
            if (xmin < this.dataXMin) {
                delta = this.dataXMin - xmin;
                xmin = this.dataXMin;
                xmax += delta;
            }
            if (xmax > this.dataXMax) {
                delta = xmax - this.dataXMax;
                xmin -= delta;
                xmax = this.dataXMax;
            }
        }
        if (this.getRubberbandingDirection() == 3 || this.getRubberbandingDirection() == 2) {
            int dy = pt.y - this.startPt.y;
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            ymin -= offset;
            ymax -= offset;
            if (ymin < this.dataYMin) {
                delta = this.dataYMin - ymin;
                ymin = this.dataYMin;
                ymax += delta;
            }
            if (ymax > this.dataYMax) {
                delta = ymax - this.dataYMax;
                ymin -= delta;
                ymax = this.dataYMax;
            }
        }
        ((GeometryInterface)this.chart).setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.viewportXMin = xmin;
        this.viewportXMax = xmax;
        this.viewportYMin = ymin;
        this.viewportYMax = ymax;
        this.startPt = pt;
    }

    protected void dragRubberband(Point pt) {
        HistogramModel hm;
        if (Math.abs(pt.x - this.startPt.x) < 5 || Math.abs(pt.y - this.startPt.y) < 5) {
            return;
        }
        if (this.chart instanceof HistogramChart && (this.actionMode == 1 || this.actionMode == 6) && (hm = ((HistogramChart)this.chart).getHistogramModel()) != null && hm.isGroup()) {
            this.rubberband = null;
            this.tipPoint = null;
            this.repaint();
            return;
        }
        this.rectSelection = true;
        if (this.rubberband == null) {
            this.rubberband = new Rectangle2D.Double();
        }
        if (this.rubberband != null) {
            int x1 = Math.min(this.startPt.x, pt.x);
            int x2 = Math.max(this.startPt.x, pt.x);
            x1 = Math.max(x1, this.chartClipRect.x);
            x2 = Math.min(x2, this.chartClipRect.x + this.chartClipRect.width);
            int y1 = Math.min(this.startPt.y, pt.y);
            int y2 = Math.max(this.startPt.y, pt.y);
            y1 = Math.max(y1, this.chartClipRect.y);
            y2 = Math.min(y2, this.chartClipRect.y + this.chartClipRect.height);
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
        }
        if (this.backBufferOn) {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            if (((ChartInterface)this.chart).isHighlightRequired()) {
                backGraphics2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
                ((RenderInterface)this.chart).drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.xAxis != null) {
                ((Axes)this.xAxis).drawReferenceRanges(backGraphics2);
            }
            if (this.yAxis != null) {
                ((Axes)this.yAxis).drawReferenceRanges(backGraphics2);
            }
            if (this.rubberband != null) {
                backGraphics2.setColor(this.brushColor);
                backGraphics2.setXORMode(Color.white);
                backGraphics2.draw(this.rubberband);
            }
            int x = this.chartClipRect.x;
            int y = this.chartClipRect.y;
            int w = this.chartClipRect.width;
            int h = this.chartClipRect.height;
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.drawImage(this.backBuffer2, x, y, x + w, y + h, x, y, x + w, y + h, this);
            backGraphics2.dispose();
            g2.dispose();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        int oldWidth = this.compWidth;
        int oldHeight = this.compHeight;
        boolean on = this.backBufferOn;
        this.backBufferOn = false;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)bounds.width / (double)bounds.height;
        double p_aspect = width / height;
        double p_width = width;
        double p_height = height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                p_width = height * s_aspect;
            } else {
                p_height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            p_height = width / s_aspect;
        } else {
            p_width = height * s_aspect;
        }
        this.resizeComponent((int)p_width, (int)p_height);
        float tx = (float)((width - p_width) * 0.5);
        float ty = (float)((height - p_height) * 0.5);
        g2.translate(tx, ty);
        g2.setClip(0, 0, (int)p_width, (int)p_height);
        this.paint(graphics);
        this.backBufferOn = on;
        this.resizeComponent(oldWidth, oldHeight);
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.tooltipTimer.restart();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.tooltipTimer.addActionListener(this.tooltipHandler);
        this.tooltipTimer.restart();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.tipText = null;
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.tooltipTimer.stop();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            return;
        }
        this.tipText = null;
        this.tooltipTimer.restart();
        this.startPt = e.getPoint();
        if (this.mouseOnXAxis) {
            this.xHandler.mousePressed(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mousePressed(e);
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.brushAction = this.getMouseSpot(this.startPt);
            this.setCursorShape(this.brushAction, true);
            if (this.brushAction == 0) {
                this.brushMode = false;
            }
        } else {
            if (!this.chartClipRect.contains(this.startPt)) {
                return;
            }
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.chart == null) {
            return;
        }
        this.tooltipTimer.restart();
        if (this.warningIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.resetViewport();
            return;
        }
        if (this.legend != null && ((LegendObjectJ2D)this.legend).isPointInLegend(e.getPoint())) {
            ((LegendObjectJ2D)this.legend).mouseReleased(e);
            return;
        }
        if (this.mouseOnXAxis) {
            this.xHandler.mouseReleased(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseReleased(e);
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (!this.popupOn) {
                return;
            }
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                this.createActionComponents();
                this.add(this.popup);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.error > 0) {
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.setCursor(new Cursor(0));
            this.createHandleRects();
            return;
        }
        this.brushMode = false;
        boolean sel = false;
        if (this.rectSelection) {
            if (this.actionMode == 2) {
                boolean viewporting = true;
                double min_viewport = 0.1;
                if (this.getRubberbandingDirection() == 1) {
                    min_viewport = 0.05 * (this.dataXMax - this.dataXMin);
                    if (this.chartBBox[3] - this.chartBBox[0] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 2) {
                    min_viewport = 0.05 * (this.dataYMax - this.dataYMin);
                    if (this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 3 && this.chartBBox[3] - this.chartBBox[0] < min_viewport && this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                    viewporting = false;
                }
                if (!viewporting) {
                    this.rectSelection = false;
                    this.repaint();
                    return;
                }
                double[] mi = new double[3];
                double[] ma = new double[3];
                double x1 = this.rubberband.x;
                double x2 = this.rubberband.x + this.rubberband.width;
                double y1 = this.rubberband.y + this.rubberband.height;
                double y2 = this.rubberband.y;
                if (this.xReverse) {
                    x1 = this.rubberband.x + this.rubberband.width;
                    x2 = this.rubberband.x;
                }
                if (this.yReverse) {
                    y2 = this.rubberband.y + this.rubberband.height;
                    y1 = this.rubberband.y;
                }
                this.unProject(x1, y1, 0.0, mi);
                this.unProject(x2, y2, 0.0, ma);
                if (this.getRubberbandingDirection() == 1) {
                    mi[0] = Math.max(mi[0], this.dataXMin);
                    ma[0] = Math.min(ma[0], this.dataXMax);
                    if (this.getZoomPoint() == 2) {
                        mi[1] = this.dataYMin;
                        ma[1] = Math.min(ma[1], this.dataYMax);
                    } else if (this.getZoomPoint() == 1) {
                        mi[1] = Math.max(mi[1], this.dataYMin);
                        ma[1] = this.dataYMax;
                    }
                } else if (this.getRubberbandingDirection() == 2) {
                    if (this.getZoomPoint() == 2) {
                        mi[0] = this.dataXMin;
                        ma[0] = Math.min(ma[0], this.dataXMax);
                    } else if (this.getZoomPoint() == 1) {
                        mi[0] = Math.max(mi[0], this.dataXMin);
                        ma[0] = this.dataXMax;
                    }
                    mi[1] = Math.max(mi[1], this.dataYMin);
                    ma[1] = Math.min(ma[1], this.dataYMax);
                } else {
                    mi[0] = Math.max(mi[0], this.dataXMin);
                    mi[1] = Math.max(mi[1], this.dataYMin);
                    ma[0] = Math.min(ma[0], this.dataXMax);
                    ma[1] = Math.min(ma[1], this.dataYMax);
                }
                ((GeometryInterface)this.chart).setBoundingBox(mi[0], mi[1], 0.0, ma[0], ma[1], 0.0);
                this.viewportXMin = mi[0];
                this.viewportXMax = ma[0];
                this.viewportYMin = mi[1];
                this.viewportYMax = ma[1];
                this.fireViewportEvent(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
                double[] rubber = new double[]{mi[0], mi[1], mi[2], ma[0], ma[1], ma[2]};
                this.updateRubberbandInPreview(rubber);
            } else if (this.actionMode == 1) {
                this.brushMode = true;
                this.mouseAction = true;
                sel = ((ChartInterface)this.chart).setSelection(this.rubberband, false);
                this.createHandleRects();
                this.mouseAction = false;
            } else if (this.actionMode == 6) {
                sel = e.isControlDown() ? ((ChartInterface)this.chart).setSelection(this.rubberband, true) : ((ChartInterface)this.chart).setSelection(this.rubberband, false);
            }
            this.rectSelection = false;
        } else if (this.actionMode == 6) {
            if (e.isControlDown()) {
                ((ChartInterface)this.chart).setSelection(e.getX(), e.getY(), true);
            } else {
                ((ChartInterface)this.chart).setSelection(e.getX(), e.getY(), false);
            }
        } else if (this.actionMode == 1) {
            ((ChartInterface)this.chart).setSelection(e.getX(), e.getY(), false);
        }
        this.tipPoint = null;
        if (!sel) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        this.startPt = e.getPoint();
        this.tipText = null;
        this.mouseOnYAxis = false;
        this.mouseOnXAxis = false;
        if (!this.warningIcon.isMouseOverIcon(e.getX(), e.getY()) && this.xHandler.isMouseInZoomPanArea(e)) {
            this.xHandler.mouseMoved(e);
            this.mouseOnXAxis = true;
            return;
        }
        if (this.yHandler.isMouseInZoomPanArea(e)) {
            this.yHandler.mouseMoved(e);
            this.mouseOnYAxis = true;
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.setCursorShape(this.getMouseSpot(this.startPt), false);
        } else {
            this.setCursor(new Cursor(0));
        }
        this.tipPoint = e.getPoint();
        this.tooltipTimer.restart();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            return;
        }
        this.tooltipTimer.restart();
        Point pt = e.getPoint();
        if (this.mouseOnXAxis) {
            this.xHandler.mouseDragged(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseDragged(e);
            return;
        }
        switch (this.actionMode) {
            case 3: {
                this.zoomGraph(pt);
                break;
            }
            case 4: {
                this.panGraph(pt);
                break;
            }
            case 2: 
            case 6: {
                this.dragRubberband(pt);
                break;
            }
            case 1: {
                if (this.brushMode) {
                    this.mouseAction = true;
                    this.brushing(pt);
                    this.mouseAction = false;
                    break;
                }
                this.dragRubberband(pt);
                break;
            }
        }
    }

    public Object getDataSource() {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        if (id == null) {
            this.dataFilter = filter;
        }
        this.brushMode = false;
        this.updatePanels = true;
        this.error &= 0xFFFFFFFB;
        return this.createChartElements(filter, id);
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public Object getAllVariables(Object role) {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getAllVariables(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (!((RoleInterface)this.chart).setRole(variableId, role)) {
            return false;
        }
        this.brushMode = false;
        this.updatePanels = true;
        this.error &= 0xFFFFFFFB;
        if (((ChartInterface)this.chart).isLegendRequired()) {
            this.updateSizes();
        }
        this.fireRoleChangeEvent(1, this.getRoleNumber(role), variableId);
        return true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (!((RoleInterface)this.chart).addRole(variableId, role)) {
            return false;
        }
        this.brushMode = false;
        this.updatePanels = true;
        this.error &= 0xFFFFFFFB;
        this.fireRoleChangeEvent(2, this.getRoleNumber(role), variableId);
        return true;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (!((RoleInterface)this.chart).removeRole(variableId, role)) {
            return false;
        }
        this.brushMode = false;
        this.updatePanels = true;
        this.error &= 0xFFFFFFFB;
        this.fireRoleChangeEvent(3, this.getRoleNumber(role), variableId);
        return true;
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.chart == null) {
            return false;
        }
        return ((RoleInterface)this.chart).isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.chart == null) {
            return false;
        }
        return ((RoleInterface)this.chart).setDiscrete(role, discrete);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getRoleValue(role, which);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getSupportedRoles(id, discrete);
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (this.chart == null) {
            return -1;
        }
        return ((RoleInterface)this.chart).getMaxAllowed(role);
    }

    @Override
    public Object getSortOrder(Object role) {
        if (this.chart == null || role == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getSortOrder(role);
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.chart == null || order == null || role == null) {
            return false;
        }
        return ((RoleInterface)this.chart).setSortOrder(role, order);
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
        if (!this.roleListeners.contains(listener)) {
            this.roleListeners.add(listener);
        }
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
        if (this.roleListeners.contains(listener)) {
            this.roleListeners.remove(this.roleListeners.indexOf(listener));
        }
    }

    @Override
    public Object getLimit(Object role) {
        if (this.chart == null || !(this.chart instanceof RoleInterface)) {
            return null;
        }
        return ((RoleInterface)this.chart).getLimit(role);
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (this.chart == null || !(this.chart instanceof RoleInterface)) {
            return false;
        }
        return ((RoleInterface)this.chart).setLimit(role, value);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.chart == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getSupportedSortableRoles();
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.chart == null || role == null) {
            return null;
        }
        return ((RoleInterface)this.chart).getSupportedSortDirections(role);
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public boolean create(Object createData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    @Override
    public boolean isRebuildRequired() {
        if (this.chart == null || this.xAxis == null || this.yAxis == null || this.wall == null) {
            return false;
        }
        return ((UpdateInterface)this.chart).isRebuildRequired() || ((UpdateInterface)this.xAxis).isRebuildRequired() || ((UpdateInterface)this.yAxis).isRebuildRequired() || this.wall.isRedrawRequired();
    }

    @Override
    public synchronized boolean build(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (!this.isRebuildRequired()) {
            return true;
        }
        try {
            this.redrawBKBuffer = true;
            if (this.getFilter() == null || this.getVariable("X") == null && this.getVariable("Category") == null) {
                this.error |= 1;
                return false;
            }
            this.error &= 0xFFFFFFFE;
            if (((ChartInterface)this.chart).isDataChanged()) {
                boolean zoomMax;
                if (((ChartInterface)this.chart).isLegendRequired() != this.legendOn) {
                    this.compMargin = this.getComponentMargin();
                }
                this.updateChartBoundingBox();
                if (this.isTooManyBars()) {
                    this.error |= 8;
                    return false;
                }
                this.error &= 0xFFFFFFF7;
                this.dataXMin = this.chartBBox[0];
                this.dataXMax = this.chartBBox[3];
                this.dataYMin = this.chartBBox[1];
                this.dataYMax = this.chartBBox[4];
                this.xHandler.setDataRange(this.dataXMin, this.dataXMax);
                this.yHandler.setDataRange(this.dataYMin, this.dataYMax);
                this.viewportXMin = this.dataXMin;
                this.viewportYMin = this.dataYMin;
                this.viewportXMax = this.dataXMax;
                this.viewportYMax = this.dataYMax;
                int zoomPt = this.getZoomPoint();
                boolean zoomMin = zoomPt == 1 || zoomPt == 3;
                boolean bl = zoomMax = zoomPt == 2 || zoomPt == 3;
                if (this.getRubberbandingDirection() == 1) {
                    this.xHandler.setZoomPanEnabled(true, true, true);
                    this.yHandler.setZoomPanEnabled(false, zoomMin, zoomMax);
                } else if (this.getRubberbandingDirection() == 2) {
                    this.yHandler.setZoomPanEnabled(true, true, true);
                    this.xHandler.setZoomPanEnabled(false, zoomMin, zoomMax);
                } else if (this.getRubberbandingDirection() == 3) {
                    this.xHandler.setZoomPanEnabled(true, true, true);
                    this.yHandler.setZoomPanEnabled(true, true, true);
                }
                double[] vr = this.getMinimumViewportRange();
                this.xHandler.setMinimumViewportRange(vr[0]);
                this.yHandler.setMinimumViewportRange(vr[1]);
                this.fireViewportEvent(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
                this.min[0] = this.dataXMin;
                this.min[1] = this.dataYMin;
                this.min[2] = 0.0;
                this.max[0] = this.dataXMax;
                this.max[1] = this.dataYMax;
                this.max[2] = 0.0;
                this.syncPreview = true;
                this.initOtherData();
                if (buildData == null) {
                    this.fireRangeChangeEvent((byte)1);
                    this.fireRangeChangeEvent((byte)2);
                }
                if (buildData == "X") {
                    this.fireRangeChangeEvent((byte)2);
                }
                this.fireMarginChangeEvent(true, true);
            }
            if (((UpdateInterface)this.chart).isRebuildRequired()) {
                ((UpdateInterface)this.chart).build(null);
            }
            if (this.xAxis != null && ((UpdateInterface)this.xAxis).isRebuildRequired()) {
                ((UpdateInterface)this.xAxis).build(null);
            }
            if (this.yAxis != null && ((UpdateInterface)this.yAxis).isRebuildRequired()) {
                ((UpdateInterface)this.yAxis).build(null);
            }
            this.buildOtherElements(null);
        }
        catch (OutOfMemoryError ome) {
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.memory.txt", (String)"Java out of memory error."));
            this.error |= 4;
            return false;
        }
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    @Override
    public double[] project(double x, double y, double z, double[] out) {
        double yMax;
        double yMin;
        double xMax;
        double xMin;
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        if (this.chart instanceof BarChart && this.chartInnerMargin != null) {
            if (((BarChart)this.chart).getChartType().equals("Horizontal")) {
                w -= this.chartInnerMargin.right + this.chartInnerMargin.left;
                xo += this.chartInnerMargin.left;
            } else {
                h -= this.chartInnerMargin.top + this.chartInnerMargin.bottom;
                yo += this.chartInnerMargin.top;
            }
        }
        if (this.xReverse) {
            xMin = this.chartBBox[3];
            xMax = this.chartBBox[0];
        } else {
            xMin = this.chartBBox[0];
            xMax = this.chartBBox[3];
        }
        if (this.yReverse) {
            yMin = this.chartBBox[4];
            yMax = this.chartBBox[1];
        } else {
            yMin = this.chartBBox[1];
            yMax = this.chartBBox[4];
        }
        ret[0] = (x - xMin) / (xMax - xMin) * (double)w + (double)xo;
        ret[1] = (double)h - (y - yMin) / (yMax - yMin) * (double)h + (double)yo;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        double yMax;
        double yMin;
        double xMax;
        double xMin;
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        if (this.chart instanceof BarChart && this.chartInnerMargin != null) {
            if (((BarChart)this.chart).getChartType().equals("Horizontal")) {
                w -= this.chartInnerMargin.right + this.chartInnerMargin.left;
                xo += this.chartInnerMargin.left;
            } else {
                h -= this.chartInnerMargin.top + this.chartInnerMargin.bottom;
                yo += this.chartInnerMargin.top;
            }
        }
        if (this.chartBBox == null) {
            return null;
        }
        if (this.xReverse) {
            xMin = this.chartBBox[3];
            xMax = this.chartBBox[0];
        } else {
            xMin = this.chartBBox[0];
            xMax = this.chartBBox[3];
        }
        if (this.yReverse) {
            yMin = this.chartBBox[4];
            yMax = this.chartBBox[1];
        } else {
            yMin = this.chartBBox[1];
            yMax = this.chartBBox[4];
        }
        ret[0] = (pixelX - (double)xo) / (double)w * (xMax - xMin) + xMin;
        ret[1] = ((double)(h + yo) - pixelY) / (double)h * (yMax - yMin) + yMin;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public void setReverse(int axis, boolean flag) {
        switch (axis) {
            case 0: {
                this.xReverse = flag;
                break;
            }
            case 1: {
                this.yReverse = flag;
            }
        }
    }

    @Override
    public boolean isReverse(int axis) {
        switch (axis) {
            case 0: {
                return this.xReverse;
            }
            case 1: {
                return this.yReverse;
            }
        }
        return false;
    }

    @Override
    public void redraw(RedrawEvent e) {
        if (e.type == 5 && !this.mouseAction) {
            this.brushMode = false;
        }
        if (e.type != 5) {
            this.redrawBKBuffer = true;
        }
        this.redrawPreview = true;
        this.repaint();
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
    }

    @Override
    public void outerMarginChanged(RedrawEvent e) {
        try {
            Graphics g = this.onBuffer == null ? this.getGraphics() : this.onBuffer;
            this.chartMargin = ((ChartInterface)this.chart).getOuterMargin((Graphics2D)g);
        }
        catch (OutOfMemoryError ome) {
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.memory.txt", (String)"Java out of memory error."));
            this.error |= 4;
            return;
        }
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        this.updateComponent(false);
        this.fireMarginChangeEvent(true, true);
        this.redrawBKBuffer = true;
        this.repaint();
    }

    @Override
    public int numPages(PageFormat pf) {
        return 1;
    }

    @Override
    public int numPagesX(PageFormat pf) {
        return 1;
    }

    @Override
    public int numPagesY(PageFormat pf) {
        return 1;
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        if (evt.isBoundsChanged) {
            this.updateComponent(true);
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public int getNumRanges(byte dim) {
        return 0;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return null;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public boolean getAxesVisible() {
        return true;
    }

    public void setRange(byte dim, int index, DataRange range) {
    }

    public Insets getOuterMargin() {
        if (this.error > 0) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.userSetOuterMargin) {
            return this.chartOuterMargin;
        }
        return this.getPreferredOuterMargin();
    }

    public Insets getInnerMargin() {
        if (this.error > 0) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.chartInnerMargin != null) {
            return this.chartInnerMargin;
        }
        return this.getPreferredInnerMargin();
    }

    public void setOuterMargin(Insets margin) {
        if (margin == null) {
            return;
        }
        Insets oldOM = this.chartOuterMargin;
        this.chartOuterMargin = margin;
        this.chartOuterMargin.top -= this.yMargin;
        this.chartOuterMargin.bottom -= this.yMargin;
        this.chartOuterMargin.left -= this.xMargin;
        this.chartOuterMargin.right -= this.xMargin;
        this.userSetOuterMargin = true;
        if (this.chartOuterMargin.equals(oldOM)) {
            return;
        }
        this.updateComponent(false);
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public void setInnerMargin(Insets margin) {
        if (this.viewportXMax - this.viewportXMin != this.dataXMax - this.dataXMin || this.viewportYMax - this.viewportYMin != this.dataYMax - this.dataYMin) {
            return;
        }
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public Insets getPreferredOuterMargin() {
        Insets margin = new Insets(0, 0, 0, 0);
        if (this.error > 0) {
            return margin;
        }
        try {
            if (this.chart != null) {
                Graphics g = this.onBuffer == null ? this.getGraphics() : this.onBuffer;
                Insets m2 = ((ChartInterface)this.chart).getOuterMargin((Graphics2D)g);
                Insets m1 = this.getComponentMargin();
                if (this.viewportWidth - (m1.left + m2.left + m1.right + m2.right) < 1) {
                    return margin;
                }
                this.compMargin = m1;
                margin.top = m1.top + m2.top;
                margin.bottom = m1.bottom + m2.bottom;
                margin.left = m1.left + m2.left;
                margin.right = m1.right + m2.right;
            }
        }
        catch (OutOfMemoryError ome) {
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"AbstractComponent.error.memory.txt", (String)"Java out of memory error."));
            this.error |= 4;
            return margin;
        }
        margin.top += this.yMargin;
        margin.bottom += this.yMargin;
        margin.left += this.xMargin;
        margin.right += this.xMargin;
        return margin;
    }

    public Insets getPreferredInnerMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void addMarginListener(MarginListener listener) {
        if (!this.marginListeners.contains(listener)) {
            this.marginListeners.addElement(listener);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (this.marginListeners.contains(listener)) {
            this.marginListeners.removeElement(listener);
        }
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        if (!this.rangeListeners.contains(listener)) {
            this.rangeListeners.add(listener);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        if (this.rangeListeners.contains(listener)) {
            this.rangeListeners.remove(this.rangeListeners.indexOf(listener));
        }
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.elementAt(i);
        }
        switch (idx) {
            case 27: {
                if (this.wall != null) {
                    return this.wall.getGraphBackground();
                }
                return null;
            }
            case 26: {
                if (this.wall != null) {
                    return new Boolean(this.wall.isVisible());
                }
            }
            case 0: {
                return this.colorScheme;
            }
            case 2: {
                return new Boolean(this.chartTipsOn);
            }
            case 10: {
                return this.getGraphBackground();
            }
            case 21: {
                return this.getSolidBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 238: {
                return new Integer(this.selectedAxis);
            }
            case 23: {
                if (this.chart != null && ((ChartInterface)this.chart).isLegendRequired()) {
                    return "Color";
                }
                return null;
            }
            case 32: {
                return new Integer(this.xMargin);
            }
            case 33: {
                return new Integer(this.yMargin);
            }
            case 34: {
                return new Boolean(this.hScrollbarOn);
            }
            case 401: {
                if (this.legend == null) {
                    return null;
                }
                Object obj = this.legend.getPropertyValue(401);
                return obj;
            }
            case 402: {
                if (this.getLegend(null) == null) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 601: {
                return this.getTitle(0);
            }
            case 602: {
                return this.getTitle(1);
            }
            case 603: {
                return this.getFootnote(0);
            }
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                if (text == null) {
                    return null;
                }
                switch (idx) {
                    case 607: 
                    case 609: 
                    case 611: {
                        return new Boolean(text.isVisible());
                    }
                    case 608: 
                    case 610: 
                    case 612: {
                        return text.getText();
                    }
                }
            }
            case 39: {
                if (this.chart != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 40: {
                if (this.chart != null && this.chart instanceof BarChart) {
                    return new Integer(((BarChart)this.chart).getXValueCount());
                }
            }
            case 42: {
                if (this.chart != null && this.chart instanceof BarChart) {
                    return new Integer(((BarChart)this.chart).getXActualValueCount());
                }
            }
            case 244: {
                return new Boolean(this.xReverse);
            }
            case 245: {
                return new Boolean(this.yReverse);
            }
        }
        if (this.legend != null && this.legend.isPropertySupported(idx)) {
            return this.legend.getPropertyValue(idx);
        }
        if (this.chart != null && ((PropertyInterface)this.chart).isPropertySupported(idx)) {
            return ((PropertyInterface)this.chart).getPropertyValue(idx);
        }
        if (this.xAxis != null && ((PropertyInterface)this.xAxis).isPropertySupported(idx)) {
            if (this.selectedAxis == 0) {
                return ((PropertyInterface)this.xAxis).getPropertyValue(idx);
            }
            return ((PropertyInterface)this.yAxis).getPropertyValue(idx);
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        if (this.isPropertySupported(idx)) {
            int i = this.propertyIndex.indexOf(new Integer(idx));
            if (i >= 0) {
                this.propertyValue.setElementAt(value, i);
            } else {
                this.propertyIndex.addElement(new Integer(idx));
                this.propertyValue.addElement(value);
            }
            if (idx == 238) {
                this.selectedAxis = !(value instanceof PropertyEvent) ? ((Integer)value).intValue() : ((Integer)((PropertyEvent)value).value).intValue();
            }
        } else {
            if (this.legend != null && this.legend.isPropertySupported(idx)) {
                return this.legend.setPropertyValue(idx, value);
            }
            if (this.chart != null && ((PropertyInterface)this.chart).isPropertySupported(idx)) {
                return ((PropertyInterface)this.chart).setPropertyValue(idx, value);
            }
            if (this.xAxis != null && ((PropertyInterface)this.xAxis).isPropertySupported(idx)) {
                if (this.selectedAxis == 0) {
                    return ((PropertyInterface)this.xAxis).setPropertyValue(idx, value);
                }
                if (this.yAxis != null) {
                    return ((PropertyInterface)this.yAxis).setPropertyValue(idx, value);
                }
            }
        }
        return true;
    }

    public int getNumberProperties() {
        return 8;
    }

    public boolean applyPropertyChanges() {
        this.applyingChanges = true;
        if (this.propertyIndex.size() <= 0) {
            boolean rc = false;
            if (this.legend != null) {
                rc |= this.legend.applyPropertyChanges();
                this.legend.getRequiredSize();
                this.updateMaximumLegendSize();
            }
            if (this.chart != null) {
                rc |= ((PropertyInterface)this.chart).applyPropertyChanges();
            }
            if (this.xAxis != null) {
                rc |= ((PropertyInterface)this.xAxis).applyPropertyChanges();
            }
            if (this.yAxis != null) {
                rc |= ((PropertyInterface)this.yAxis).applyPropertyChanges();
            }
            this.applyingChanges = false;
            this.updateComponent(true);
            this.repaint();
            return true;
        }
        Object startColor = null;
        Object endColor = null;
        block25: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.elementAt(i);
            Object value = this.propertyValue.elementAt(i);
            if (value instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            switch (idx) {
                case 26: {
                    if (this.wall == null) continue block25;
                    this.wall.setVisible((Boolean)value);
                    continue block25;
                }
                case 0: {
                    this.setColorScheme(value);
                    continue block25;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block25;
                    this.chartTipsOn = (Boolean)value;
                    this.userSetProperties.set(2);
                    continue block25;
                }
                case 21: {
                    this.setSolidBackground(value);
                    continue block25;
                }
                case 13: {
                    startColor = value;
                    continue block25;
                }
                case 14: {
                    endColor = value;
                    continue block25;
                }
                case 15: {
                    this.setGradientBackground(startColor, endColor, value);
                    continue block25;
                }
                case 23: {
                    continue block25;
                }
                case 32: {
                    this.viewportX = this.xMargin = value instanceof Number ? ((Number)value).intValue() : this.xMargin;
                    this.viewportWidth = this.compWidth - 2 * this.xMargin;
                    continue block25;
                }
                case 33: {
                    this.viewportY = this.yMargin = value instanceof Number ? ((Number)value).intValue() : this.yMargin;
                    this.viewportHeight = this.compHeight - 2 * this.yMargin;
                    continue block25;
                }
                case 34: {
                    boolean vis;
                    if (!(value instanceof Boolean)) continue block25;
                    this.hScrollbarOn = this.vScrollbarOn = (vis = ((Boolean)value).booleanValue());
                    if (this.xHandler != null) {
                        this.xHandler.setZoomPanEnabled(this.hScrollbarOn);
                    }
                    if (this.yHandler != null) {
                        this.yHandler.setZoomPanEnabled(this.hScrollbarOn);
                    }
                    this.updateComponent(true);
                    this.redrawBKBuffer = true;
                    continue block25;
                }
                case 40: {
                    if (this.chart == null || !(this.chart instanceof BarChart) || !(value instanceof Number)) continue block25;
                    ((BarChart)this.chart).setXValueCount(((Number)value).intValue());
                    continue block25;
                }
                case 401: {
                    if (!(value instanceof String) && !(value instanceof Number)) continue block25;
                    this.setLegendPosition(null, value);
                    continue block25;
                }
                case 604: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setTitle(0, (TextStyleInterface)value);
                    continue block25;
                }
                case 605: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setTitle(1, (TextStyleInterface)value);
                    continue block25;
                }
                case 606: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setFootnote(0, (TextStyleInterface)value);
                    continue block25;
                }
                case 601: 
                case 602: 
                case 603: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 611: 
                case 612: {
                    TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                    if (text == null) {
                        return false;
                    }
                    switch (idx) {
                        case 607: 
                        case 609: 
                        case 611: {
                            text.setVisible((Boolean)value);
                            break;
                        }
                        case 608: 
                        case 610: 
                        case 612: {
                            text.setText(value);
                        }
                    }
                    continue block25;
                }
                case 244: {
                    boolean zoomMaxX;
                    boolean bValueX;
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Boolean)) {
                        return false;
                    }
                    this.xReverse = bValueX = ((Boolean)value).booleanValue();
                    int zoomPtX = this.getZoomPoint();
                    boolean zoomMinX = zoomPtX == 1 || zoomPtX == 3;
                    boolean bl = zoomMaxX = zoomPtX == 2 || zoomPtX == 3;
                    if (this.getRubberbandingDirection() != 2 || this.xHandler == null) continue block25;
                    if (this.xReverse) {
                        this.xHandler.setZoomPanEnabled(false, zoomMinX, zoomMaxX);
                        continue block25;
                    }
                    this.xHandler.setZoomPanEnabled(false, zoomMinX, zoomMaxX);
                    continue block25;
                }
                case 245: {
                    boolean zoomMax;
                    boolean bValueY;
                    if (value == null) {
                        return false;
                    }
                    if (value instanceof PropertyEvent) {
                        value = ((PropertyEvent)value).value;
                    }
                    if (!(value instanceof Boolean)) {
                        return false;
                    }
                    this.yReverse = bValueY = ((Boolean)value).booleanValue();
                    int zoomPt = this.getZoomPoint();
                    boolean zoomMin = zoomPt == 1 || zoomPt == 3;
                    boolean bl = zoomMax = zoomPt == 2 || zoomPt == 3;
                    if (this.getRubberbandingDirection() != 1 || this.yHandler == null) continue block25;
                    if (this.yReverse) {
                        this.yHandler.setZoomPanEnabled(false, zoomMin, zoomMax);
                        continue block25;
                    }
                    this.yHandler.setZoomPanEnabled(false, zoomMin, zoomMax);
                    continue block25;
                }
            }
        }
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        if (this.chart != null) {
            ((PropertyInterface)this.chart).applyPropertyChanges();
        }
        if (this.xAxis != null) {
            ((PropertyInterface)this.xAxis).applyPropertyChanges();
        }
        if (this.yAxis != null) {
            ((PropertyInterface)this.yAxis).applyPropertyChanges();
        }
        this.applyingChanges = false;
        this.repaint();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
        if (this.legend != null) {
            this.legend.cancelPropertyChanges();
        }
        if (this.chart != null) {
            ((PropertyInterface)this.chart).cancelPropertyChanges();
        }
        if (this.xAxis != null) {
            ((PropertyInterface)this.xAxis).cancelPropertyChanges();
        }
        if (this.yAxis != null) {
            ((PropertyInterface)this.yAxis).cancelPropertyChanges();
        }
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.elementAt(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 0: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 238: 
            case 244: 
            case 245: 
            case 401: 
            case 402: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                return true;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.chart != null && this.chart instanceof BarChart;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = this.userSetProperties.get(id);
        if (this.chart != null) {
            rc |= ((PropertyInterface)this.chart).hasUserSetValue(id);
        }
        return rc;
    }

    @Override
    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                vport[0] = this.viewportXMin;
                vport[1] = this.viewportXMax;
                break;
            }
            case 2: {
                vport[0] = this.viewportYMin;
                vport[1] = this.viewportYMax;
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.viewportXMin = Math.max(this.dataXMin, min);
                this.viewportXMax = Math.min(this.dataXMax, max);
                break;
            }
            case 2: {
                this.viewportYMin = Math.max(this.dataYMin, min);
                this.viewportYMax = Math.min(this.dataYMax, max);
                break;
            }
            default: {
                return false;
            }
        }
        if (this.chart != null) {
            ((GeometryInterface)this.chart).setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        this.brushMode = false;
        this.fireViewportEvent(type, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        return true;
    }

    @Override
    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (!Double.isNaN(xmax)) {
            this.viewportXMin = Math.max(this.dataXMin, xmin);
        }
        if (!Double.isNaN(xmin)) {
            this.viewportXMax = Math.min(this.dataXMax, xmax);
        }
        if (!Double.isNaN(ymin)) {
            this.viewportYMin = Math.max(this.dataYMin, ymin);
        }
        if (!Double.isNaN(ymax)) {
            this.viewportYMax = Math.min(this.dataYMax, ymax);
        }
        if (this.chart != null) {
            ((GeometryInterface)this.chart).setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        this.brushMode = false;
        this.fireViewportEvent(type, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        return true;
    }

    public double getZoomFactor(int dimension) {
        return 1.0;
    }

    public boolean setZoomFactor(int dimension, double fac) {
        if (fac <= this.globalDefaults.zoomLimitParm || fac > 1.0) {
            return false;
        }
        switch (dimension) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        this.zoomFactor = fac;
        this.doDataZoom();
        this.brushMode = false;
        return true;
    }

    @Override
    public boolean resetViewport() {
        this.setActionMode(5);
        this.fireViewportEvent(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        return true;
    }

    protected void doDataZoom() {
    }

    protected void fireRangeChangeEvent(byte dimension) {
        DataRange dr = this.getDataRange(dimension);
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 4, dr, dimension, dr);
        int numListeners = this.rangeListeners.size();
        if (numListeners > 0) {
            for (int i = 0; i < numListeners; ++i) {
                ((RangeChangeListener)this.rangeListeners.get(i)).rangeChanged(rce);
            }
        }
    }

    protected void fireMarginChangeEvent(boolean inner, boolean outer) {
        int numListeners;
        if (outer) {
            this.userSetOuterMargin = false;
        }
        if ((numListeners = this.marginListeners.size()) > 0) {
            MarginChangeEvent mce = new MarginChangeEvent((Object)this);
            if (inner) {
                mce.setInnerChanged(true);
            }
            if (outer) {
                mce.setOuterChanged(true);
            }
            for (int i = 0; i < numListeners; ++i) {
                ((MarginListener)this.marginListeners.get(i)).marginChanged(mce);
            }
        }
    }

    protected void fireViewportEvent(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (this.viewportListeners.size() <= 0) {
            return;
        }
        ViewportEvent ve = new ViewportEvent(this, type, xmin, xmax, ymin, ymax, zmin, zmax);
        int numListeners = this.viewportListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(ve);
        }
    }

    protected void resetAxisEndPoints() {
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setAxisEndPoints(this.chartBBox[0], this.chartBBox[1], 0.0, this.chartBBox[3], this.chartBBox[1], 0.0);
            ((Axes)this.xAxis).setOffset(0, 0);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setAxisEndPoints(this.chartBBox[0], this.chartBBox[1], 0.0, this.chartBBox[0], this.chartBBox[4], 0.0);
            ((Axes)this.yAxis).setOffset(0, 0);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.toolbar != null && this.toolbar.isVisible()) {
            this.toolbar.setVisible(false);
        }
    }

    @Override
    public void addDrilldownListener(DrilldownListenerInterface d) {
    }

    @Override
    public void removeDrilldownListener(DrilldownListenerInterface d) {
    }

    @Override
    public boolean isBackBufferDrawEnabled() {
        return this.backBufferOn;
    }

    @Override
    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    @Override
    public void setBackBufferDrawEnabled(boolean drawback) {
        this.backBufferOn = drawback;
    }

    @Override
    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (this.mouseOnXAxis) {
            this.setViewport(1, 1, evt.xMin, evt.xMax);
        } else if (this.mouseOnYAxis) {
            this.setViewport(1, 2, evt.yMin, evt.yMax);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
            this.setActionMode(1);
        } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_SELECT")) {
            this.setActionMode(6);
        } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_VIEWPORT")) {
            this.setActionMode(2);
        } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_RESET")) {
            this.setActionMode(5);
        }
    }

    protected void fireRoleChangeEvent(int type, int role, Object newValue) {
        if (this.viewportListeners.size() <= 0) {
            return;
        }
        RoleEvent re = new RoleEvent();
        if (re == null) {
            return;
        }
        re.type = type;
        re.role = role;
        re.newValue = newValue;
        re.source = this;
        int numListeners = this.roleListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            ((RoleListenerInterface)this.roleListeners.get(i)).roleChanged(re);
        }
    }

    protected int getRoleNumber(Object role) {
        int roleNumber = -1;
        if (role == null) {
            return roleNumber;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            roleNumber = 24;
        } else if (role instanceof Number && ((Number)role).intValue() == 1 || role instanceof String && ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Category")) {
            roleNumber = 1;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            roleNumber = 6;
        } else if (role instanceof Number && ((Number)role).intValue() == 21 || role instanceof String && ((String)role).equalsIgnoreCase(SUBGROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Subgroup")) {
            roleNumber = 21;
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            roleNumber = 25;
        } else if (role instanceof Number && ((Number)role).intValue() == 17 || role instanceof String && ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Response")) {
            roleNumber = 17;
        } else if (role instanceof Number && ((Number)role).intValue() == 38 || role instanceof String && ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("STAT")) {
            roleNumber = 38;
        } else if (role instanceof Number && ((Number)role).intValue() == 22 || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Tip")) {
            roleNumber = 22;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            roleNumber = 6;
        } else if (role instanceof Number && ((Number)role).intValue() == 3 || role instanceof String && (((String)role).equalsIgnoreCase("ColorIndex") || ((String)role).equalsIgnoreCase("Color Index") || ((String)role).equalsIgnoreCase(COLORINDEX_ROLE_NAME.toString()))) {
            roleNumber = 3;
        } else if (role instanceof Number && ((Number)role).intValue() == 70 || role instanceof String && (((String)role).equalsIgnoreCase("Freq") || ((String)role).equalsIgnoreCase(FREQ_ROLE_NAME.toString()))) {
            roleNumber = 70;
        } else if (role instanceof Number && ((Number)role).intValue() == 4 || role instanceof String && ((String)role).equalsIgnoreCase(ERRORLOW_ROLE_NAME.toString()) || role instanceof String && (((String)role).equalsIgnoreCase("Error Low") || ((String)role).equalsIgnoreCase("ErrorLow"))) {
            roleNumber = 1;
        } else if (role instanceof Number && ((Number)role).intValue() == 5 || role instanceof String && ((String)role).equalsIgnoreCase(ERRORHIGH_ROLE_NAME.toString()) || role instanceof String && (((String)role).equalsIgnoreCase("Error High") || ((String)role).equalsIgnoreCase("ErrorHigh"))) {
            roleNumber = 1;
        }
        return roleNumber;
    }

    protected class TooltipHandler
    implements ActionListener {
        protected TooltipHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractComponent.this.tipPoint == null) {
                return;
            }
            String prevTipText = AbstractComponent.this.tipText;
            AbstractComponent.this.tipText = AbstractComponent.this.getToolTipText(AbstractComponent.this.tipPoint.x, AbstractComponent.this.tipPoint.y);
            AbstractComponent.this.tooltipTimer.stop();
            if (prevTipText != AbstractComponent.this.tipText) {
                AbstractComponent.this.repaint();
            }
        }
    }
}

