/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.boxplot;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.StringCompare;
import java.util.HashMap;
import java.util.Vector;

public class BoxPlotModel
implements RoleInterface,
DataFilterListenerInterface {
    public static final int ROLE_X = 0;
    public static final int ROLE_Y = 1;
    public static final int ROLE_STAT = 2;
    public static final int ROLE_GROUP = 3;
    public static final int ROLE_TIP = 4;
    public static final int NUM_ROLES = 5;
    protected DataFilterReadInterface dataIn;
    protected Object[] variables = new Object[5];
    protected HashMap discrete = new HashMap();
    protected HashMap sortOrder = new HashMap();
    protected Vector tipNames;
    protected boolean[] obsSelected;
    protected int[] obsMapping;
    protected double[] selectedValues;
    protected Object[] uniqueXValues;
    protected Object[] uniqueGroupValues;
    protected double yMin;
    protected double yMax;
    protected Object[] xValues;
    protected Object[] groupValues;
    protected String missingSymbol = ".";
    public static final Roles ROLES = Roles.getInstance(null);
    public static final String X_ROLE_NAME = ROLES.getRoleNLSName("ROLE_X");
    public static final String Y_ROLE_NAME = ROLES.getRoleNLSName("ROLE_Y");
    public static final String STAT_ROLE_NAME = ROLES.getRoleNLSName("ROLE_STATISTIC");
    public static final String GROUP_ROLE_NAME = ROLES.getRoleNLSName("ROLE_GROUP");
    public static final String TIP_ROLE_NAME = ROLES.getRoleNLSName("ROLE_TIP");
    public static final SILKNumber X_ROLE_NUMBER = ROLES.getRoleObject("ROLE_X");
    public static final SILKNumber Y_ROLE_NUMBER = ROLES.getRoleObject("ROLE_Y");
    public static final SILKNumber STAT_ROLE_NUMBER = ROLES.getRoleObject("ROLE_STATISTIC");
    public static final SILKNumber GROUP_ROLE_NUMBER = ROLES.getRoleObject("ROLE_GROUP");
    public static final SILKNumber TIP_ROLE_NUMBER = ROLES.getRoleObject("ROLE_TIP");

    public BoxPlotModel(DataFilterReadInterface data) {
        this.setDataSource(data);
    }

    public BoxPlotModel() {
        this(null);
    }

    protected boolean isZeroObservation() {
        long obs = this.dataIn.getNumberObservations(-1);
        return obs <= 0L;
    }

    protected double[] getSelectedValues() {
        return this.selectedValues;
    }

    public boolean setSelection(long i, boolean selected) {
        return true;
    }

    public boolean setSelection(int[] bins, boolean selected) {
        return true;
    }

    public boolean sendSelectionEvent() {
        this.dataIn.sendEvent((Object)new DvrDataFilterEvent(7));
        return true;
    }

    public boolean setSelectionAll(boolean selected) {
        if (!selected) {
            this.dataIn.unselectAll();
        } else {
            int rows = this.dataIn.getNumberObservations(-1);
            int[] obs = new int[rows];
            for (int i = 0; i < rows; ++i) {
                obs[i] = i;
            }
            this.dataIn.setSelected((Object)obs, selected);
        }
        return true;
    }

    public double getMinimumValue(Object variableId, long obs1, long obs2) {
        return this.getMinimumValue(variableId);
    }

    public double getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, true);
    }

    public double getMinimumValue(Object variableId, boolean userSetting) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(X_ROLE_NAME)) {
            return 0.0;
        }
        if (this.getRole(variableId).equals(GROUP_ROLE_NAME)) {
            return 0.0;
        }
        if (this.getRole(variableId).equals(Y_ROLE_NAME)) {
            if (this.variables[2] == null) {
                return Double.NaN;
            }
            if (userSetting && !Double.isNaN(this.yMin)) {
                return this.yMin;
            }
            int vids = this.dataIn.getVariableIndex(this.variables[2]);
            int vidy = this.dataIn.getVariableIndex(variableId);
            long rows = this.dataIn.getNumberObservations(vidy);
            double min = Double.MAX_VALUE;
            boolean doNotReturnNAN = false;
            for (long i = 0L; i < rows; ++i) {
                double v;
                Object s = this.dataIn.getValue(vids, i);
                if (((String)s).equalsIgnoreCase("N") || ((String)s).equalsIgnoreCase("STD") || !((v = this.dataIn.getNumericValue(vidy, i)) < min)) continue;
                min = v;
                doNotReturnNAN = true;
            }
            if (!doNotReturnNAN) {
                return Double.NaN;
            }
            return min;
        }
        return Double.NaN;
    }

    protected double getMinimumValue(int xidx, int gidx) {
        int vids = this.dataIn.getVariableIndex(this.variables[2]);
        int vidy = this.dataIn.getVariableIndex(this.variables[1]);
        int vidg = this.dataIn.getVariableIndex(this.variables[3]);
        long rows = this.dataIn.getNumberObservations(vidy);
        double min = Double.MAX_VALUE;
        Object g = null;
        boolean doNotReturnNAN = false;
        for (long i = 0L; i < rows; ++i) {
            double v;
            Object s = this.dataIn.getValue(vids, i);
            String x = this.dataIn.getFormattedValue(this.variables[0], i, null);
            if (vidg >= 0) {
                g = this.dataIn.getValue(vidg, i);
            }
            if (((String)s).equalsIgnoreCase("N") || ((String)s).equalsIgnoreCase("STD") || this.getXValueIndex(x) != xidx || g != null && this.getGroupValueIndex(g) != gidx || !((v = this.dataIn.getNumericValue(vidy, i)) < min)) continue;
            min = v;
            doNotReturnNAN = true;
        }
        if (!doNotReturnNAN) {
            return Double.NaN;
        }
        return min;
    }

    public double getMaximumValue(Object variableId, long obs1, long obs2) {
        return this.getMaximumValue(variableId);
    }

    public double getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, true);
    }

    public double getMaximumValue(Object variableId, boolean userSetting) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(X_ROLE_NAME)) {
            if (userSetting && this.xValues != null) {
                return this.xValues.length - 1;
            }
            return this.uniqueXValues.length - 1;
        }
        if (this.getRole(variableId).equals(GROUP_ROLE_NAME)) {
            if (userSetting && this.groupValues != null) {
                return this.groupValues.length - 1;
            }
            return this.uniqueGroupValues.length - 1;
        }
        if (this.getRole(variableId).equals(Y_ROLE_NAME)) {
            if (this.variables[2] == null) {
                return Double.NaN;
            }
            if (userSetting && !Double.isNaN(this.yMax)) {
                return this.yMax;
            }
            int vids = this.dataIn.getVariableIndex(this.variables[2]);
            int vidy = this.dataIn.getVariableIndex(variableId);
            long rows = this.dataIn.getNumberObservations(vidy);
            double max = -1.7976931348623157E308;
            boolean doNotReturnNAN = false;
            for (long i = 0L; i < rows; ++i) {
                double v;
                Object s = this.dataIn.getValue(vids, i);
                if (((String)s).equalsIgnoreCase("N") || ((String)s).equalsIgnoreCase("STD") || !((v = this.dataIn.getNumericValue(vidy, i)) > max)) continue;
                max = v;
                doNotReturnNAN = true;
            }
            if (!doNotReturnNAN) {
                return Double.NaN;
            }
            return max;
        }
        return Double.NaN;
    }

    protected double getMaximumValue(int xidx, int gidx) {
        int vids = this.dataIn.getVariableIndex(this.variables[2]);
        int vidy = this.dataIn.getVariableIndex(this.variables[1]);
        int vidx = this.dataIn.getVariableIndex(this.variables[0]);
        int vidg = this.dataIn.getVariableIndex(this.variables[3]);
        long rows = this.dataIn.getNumberObservations(vidy);
        double max = -1.7976931348623157E308;
        Object g = null;
        boolean doNotReturnNAN = false;
        for (long i = 0L; i < rows; ++i) {
            double v;
            Object s = this.dataIn.getValue(vids, i);
            String x = this.dataIn.getFormattedValue(this.dataIn.getVariableId(vidx), i, null);
            if (vidg >= 0) {
                g = this.dataIn.getValue(vidg, i);
            }
            if (((String)s).equalsIgnoreCase("N") || ((String)s).equalsIgnoreCase("STD") || this.getXValueIndex(x) != xidx || g != null && this.getGroupValueIndex(g) != gidx || !((v = this.dataIn.getNumericValue(vidy, i)) > max)) continue;
            max = v;
            doNotReturnNAN = true;
        }
        if (!doNotReturnNAN) {
            return Double.NaN;
        }
        return max;
    }

    public int getUniqueXValueCount() {
        return this.getUniqueXValueCount(true);
    }

    public int getUniqueXValueCount(boolean userSetting) {
        Object[] vals = this.getXValues(userSetting);
        return this.variables[0] == null ? 1 : vals.length;
    }

    public Object[] getUniqueXValues() {
        return this.getUniqueXValues(true);
    }

    public Object[] getUniqueXValues(boolean userSetting) {
        Object[] vals = this.getXValues(userSetting);
        if (this.variables[0] == null) {
            return new Object[]{"a"};
        }
        return vals;
    }

    public int getXValueIndex(Object v) {
        return this.getXValueIndex(v, true);
    }

    public int getXValueIndex(Object v, boolean userSetting) {
        if (this.variables[0] == null) {
            return 0;
        }
        int ret = -1;
        Object[] vals = this.getXValues(userSetting);
        if (this.dataIn.isNumericVariable(this.variables[0])) {
            for (int i = 0; i < vals.length; ++i) {
                if (!vals[i].equals(v)) continue;
                ret = i;
            }
        } else {
            for (int i = 0; i < vals.length; ++i) {
                if (!StringCompare.equals((String)((String)vals[i]), (String)((String)v))) continue;
                ret = i;
            }
        }
        if (this.dataIn.isMissing(this.variables[3], v)) {
            v = this.missingSymbol;
        }
        return ret;
    }

    public int getXValueColorIndex(Object v) {
        if (this.variables[0] == null) {
            return 0;
        }
        if (!(this.dataIn instanceof DataFilterInfoInterface)) {
            return this.getXValueIndex(v);
        }
        Object[] colorValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[0], false);
        for (int i = 0; i < colorValues.length; ++i) {
            if (!(v.equals(this.missingSymbol) ? this.dataIn.isMissing(this.variables[0], colorValues[i]) : v.equals(colorValues[i]))) continue;
            return i;
        }
        return -1;
    }

    public int getUniqueGroupValueCount() {
        return this.getUniqueGroupValueCount(true);
    }

    public int getUniqueGroupValueCount(boolean userSetting) {
        Object[] vals = this.getGroupValues(userSetting);
        return this.variables[3] == null || vals == null ? 1 : vals.length;
    }

    public Object[] getUniqueGroupValues() {
        return this.getUniqueGroupValues(true);
    }

    public Object[] getUniqueGroupValues(boolean userSetting) {
        Object[] vals = this.getGroupValues(userSetting);
        return this.variables[3] == null ? null : vals;
    }

    public int getGroupValueIndex(Object v) {
        return this.getGroupValueIndex(v, true);
    }

    public int getGroupValueIndex(Object v, boolean userSetting) {
        if (this.variables[3] == null) {
            return 0;
        }
        int ret = -1;
        Object[] vals = this.getGroupValues(userSetting);
        if (this.dataIn.isNumericVariable(this.variables[3])) {
            for (int i = 0; i < vals.length; ++i) {
                if (!vals[i].equals(v)) continue;
                ret = i;
            }
        } else {
            for (int i = 0; i < vals.length; ++i) {
                if (!StringCompare.equals((String)((String)vals[i]), (String)((String)v))) continue;
                ret = i;
            }
        }
        if (this.dataIn.isMissing(this.variables[3], v)) {
            v = this.missingSymbol;
        }
        return ret;
    }

    public int getGroupValueColorIndex(Object v) {
        if (this.variables[3] == null) {
            return 0;
        }
        if (!(this.dataIn instanceof DataFilterInfoInterface)) {
            return this.getGroupValueIndex(v);
        }
        Object[] colorValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[3], false);
        for (int i = 0; i < colorValues.length; ++i) {
            if (!(v.equals(this.missingSymbol) ? this.dataIn.isMissing(this.variables[3], colorValues[i]) : v.equals(colorValues[i]))) continue;
            return i;
        }
        return -1;
    }

    public void setYMinimum(double v) {
        this.yMin = v;
    }

    public void setYMaximum(double v) {
        this.yMax = v;
    }

    public void setXValues(Object[] vals) {
        this.xValues = vals;
    }

    public void setGroupValues(Object[] vals) {
        this.groupValues = vals;
    }

    public Object getVariableDescription(Object role) {
        Object varId = this.getVariable(role);
        if (varId == null) {
            return null;
        }
        Object desc = this.dataIn.getVariableDescription(varId);
        if (desc == null || ((String)desc).equals("")) {
            return varId;
        }
        return desc;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        return this.dataIn;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = null;
        }
        int n = this.dataIn.getNumberObservations(-1);
        this.obsSelected = new boolean[n];
        this.obsMapping = new int[n];
        for (int i = 0; i < n; ++i) {
            this.obsSelected[i] = false;
            this.obsMapping[i] = -1;
        }
        this.initUserSettings();
        return true;
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        int id;
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return null;
        }
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(STAT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(GROUP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 4;
        } else {
            return null;
        }
        return this.variables[id];
    }

    @Override
    public Object getRole(Object variableId) {
        SILKNumber obj;
        int id = -1;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[i]), (String)((String)variableId))) {
                id = i;
                break;
            }
            if (this.variables[i] == null || !this.variables[i].equals(variableId)) continue;
            id = i;
            break;
        }
        switch (id) {
            default: {
                obj = null;
                break;
            }
            case 0: {
                obj = X_ROLE_NUMBER;
                break;
            }
            case 1: {
                obj = Y_ROLE_NUMBER;
                break;
            }
            case 2: {
                obj = STAT_ROLE_NUMBER;
                break;
            }
            case 3: {
                obj = GROUP_ROLE_NUMBER;
                break;
            }
            case 4: {
                obj = TIP_ROLE_NUMBER;
            }
        }
        return obj;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        int id = -1;
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(STAT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(GROUP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 4;
        } else {
            return false;
        }
        if (variableId == null) {
            return false;
        }
        if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
            return false;
        }
        if (id == 1 && !this.dataIn.isNumericVariable(variableId)) {
            return false;
        }
        if (id == 2 && this.dataIn.isNumericVariable(variableId)) {
            return false;
        }
        this.variables[id] = variableId;
        if (id == 0 && this.dataIn instanceof DataFilterReadInterface) {
            this.uniqueXValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[0], true);
        }
        if (id == 3 && this.dataIn instanceof DataFilterInfoInterface) {
            this.uniqueGroupValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[3], true);
        }
        this.initUserSettings();
        return true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(STAT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(GROUP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 4;
        } else {
            return false;
        }
        if (this.variables[id] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[id]), (String)((String)variableId))) {
            this.variables[id] = null;
        } else if (this.variables[id] != null && this.variables[id].equals(variableId)) {
            this.variables[id] = null;
        } else {
            return false;
        }
        this.initUserSettings();
        return true;
    }

    @Override
    public boolean isDiscrete(Object role) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        Boolean dis = (Boolean)this.discrete.get(NLSRole);
        if (dis != null) {
            return dis;
        }
        return false;
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        this.discrete.put(NLSRole, new Boolean(discrete));
        this.initUserSettings();
        return true;
    }

    @Override
    public Object getSortOrder(Object role) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return null;
        }
        return this.sortOrder.get(NLSRole);
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        this.sortOrder.put(NLSRole, order);
        Object variableId = this.getVariable(role);
        if (NLSRole.equals(X_ROLE_NAME) && this.dataIn instanceof DataFilterInfoInterface) {
            this.uniqueXValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(variableId, true);
        }
        if (NLSRole.equals(GROUP_ROLE_NAME) && this.dataIn instanceof DataFilterInfoInterface) {
            this.uniqueGroupValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(variableId, true);
        }
        return true;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        Object id = this.getVariable(role);
        if (id == null) {
            return null;
        }
        if (which == 0) {
            return new Double(this.getMinimumValue(id, false));
        }
        if (which == 1) {
            return new Double(this.getMaximumValue(id, false));
        }
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return -1;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                if (this.variables[0] != null && this.dataIn instanceof DataFilterInfoInterface) {
                    this.uniqueXValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[0], true);
                }
                if (this.variables[3] != null && this.dataIn instanceof DataFilterInfoInterface) {
                    this.uniqueGroupValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[3], true);
                }
                this.initUserSettings();
                break;
            }
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    private Object getNLSRole(Object role) {
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        if (!(role instanceof String) && !(role instanceof Number)) {
            return null;
        }
        String NLSRole = role instanceof String && ((String)role).equalsIgnoreCase("X") || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_X) ? X_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Y") || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_Y) ? Y_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Statistic") || role instanceof String && ((String)role).equalsIgnoreCase("Stat") || role instanceof String && ((String)role).equalsIgnoreCase(STAT_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_STATISTIC) ? STAT_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Group") || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_GROUP) ? GROUP_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Tip") || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_TIP) ? TIP_ROLE_NAME : null))));
        return NLSRole;
    }

    private Object[] getXValues(boolean userSetting) {
        if ((!userSetting || this.xValues == null) && this.variables[0] != null && this.dataIn instanceof DataFilterInfoInterface) {
            this.uniqueXValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[0], true);
            return this.uniqueXValues;
        }
        return this.xValues;
    }

    private Object[] getGroupValues(boolean userSetting) {
        if ((!userSetting || this.groupValues == null) && this.variables[0] != null && this.dataIn instanceof DataFilterInfoInterface) {
            this.uniqueGroupValues = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[3], true);
            return this.uniqueGroupValues;
        }
        return this.groupValues;
    }

    private void initUserSettings() {
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
        this.xValues = null;
        this.groupValues = null;
    }
}

