/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.boxplot;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.boxplot.BoxPlotModel;
import com.sas.graphics.silk.boxplot.TukeyBox;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.interfaces.BoxPlotPropertyInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.Markers;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;

public class BoxPlotChart
implements GeometryInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
DataFilterListenerInterface,
PropertyInterface,
BoxPlotPropertyInterface {
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected boolean chartBorderOn = false;
    protected Color chartBorderColor;
    protected Color chartWallColor;
    protected Color selectionColor;
    protected DataFilterReadInterface dataIn = null;
    protected BoxPlotModel boxPlotModel = null;
    protected DataFilterReadInterface dataOut = null;
    protected TransformInterface transObj = null;
    protected LegendObject legend;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected Axes groupAxis = null;
    protected Object xVariable = null;
    protected Object yVariable = null;
    protected Object statVariable = null;
    protected Object groupVariable = null;
    protected Object tipVariable = null;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected ArrayList displayList;
    protected TukeyBox[] tBox;
    protected int numBoxes;
    protected ArrayList selectionList;
    protected double[] selectedValues;
    protected ArrayList redrawListener;
    protected ArrayList marginListener;
    protected Object marginSource;
    protected boolean dataChanged = false;
    protected boolean dataPrepared = false;
    protected double[] chartBBox = new double[6];
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle2D clipRect;
    protected Dimension chartAreaDimension;
    protected Insets innerMargin;
    protected Insets chartInnerMargin;
    protected int sizePerBox;
    protected boolean innerMarginChanged = false;
    protected boolean fixedDataRange = true;
    protected boolean redraw = true;
    protected int colorBy = 2;
    protected int axisLabelLength = 8;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected boolean extreme = false;
    protected boolean notched = false;
    protected boolean fillOn = true;
    protected Color fillColor;
    protected double boxScaleFactor = 0.4;
    protected Color outlineColor;
    protected int outlineWidth = 1;
    protected int capShape = 1;
    protected Color medianColor;
    protected int medianShape = -1;
    protected int medianWidth = 12;
    protected Color meanColor;
    protected int meanShape = 6;
    protected int meanWidth = 12;
    protected boolean markerOn = true;
    protected Color markerColor;
    protected int markerShape = 3;
    protected int markerWidth = 10;
    protected Color whiskerColor;
    protected int whiskerWidth = 1;
    protected Color capColor;
    protected int capWidth = 1;
    protected int orientation = 0;
    protected int connectBy = 0;
    protected Color lineColor;
    protected int lineWidth = 1;
    protected double markerScaleFac = 0.4;
    protected String styleBackground = "GraphDataStyleDefault";
    protected String styleMean = "BoxMean";
    protected String styleMedian = "BoxMedian";
    protected String styleOutliers = "Outlier";
    protected String styleWhiskers = "BoxWhisker";
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.boxplot.silk_boxplot_NLS");
    public static final int CONNECT_NONE = 0;
    public static final int CONNECT_MIN = 1;
    public static final int CONNECT_Q1 = 2;
    public static final int CONNECT_MEDIAN = 3;
    public static final int CONNECT_Q3 = 4;
    public static final int CONNECT_MAX = 5;
    public static final int CONNECT_MEAN = 6;
    public static final int COLOR_BY_CHART = 0;
    public static final int COLOR_BY_CATEGORY = 1;
    public static final int COLOR_BY_GROUP = 2;
    public static int[] supportedProperties = new int[]{801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 19004, 19005, 19006, 19007, 19008};
    SILKNumber[] capShapeStr;
    SILKNumber[] connectByStr;
    SILKNumber[] colorByStr;
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);
    protected Style style = null;

    public BoxPlotChart(Object dataObject) {
        this.chartBorderColor = Color.black;
        this.selectionColor = new Color(255, 197, 0);
        this.chartWallColor = new Color(225, 229, 250);
        this.displayList = new ArrayList();
        this.selectionList = new ArrayList();
        this.redrawListener = new ArrayList();
        this.innerMargin = new Insets(0, 0, 0, 0);
        this.chartInnerMargin = new Insets(0, 0, 0, 0);
        this.fillColor = new Color(100, 100, 175);
        this.outlineColor = Color.black;
        this.medianColor = Color.black;
        this.meanColor = Color.red;
        this.markerColor = Color.black;
        this.whiskerColor = Color.black;
        this.capColor = Color.black;
        this.lineColor = Color.black;
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.setDataSource(dataObject);
        this.userSetProperties.appendProperties(supportedProperties);
        this.capShapeStr = new SILKNumber[4];
        this.capShapeStr[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.CapNone.txt", (String)"None"), "None");
        this.capShapeStr[1] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.CapSerif.txt", (String)"Serif"), "Serif");
        this.capShapeStr[2] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.CapLine.txt", (String)"Line"), "Line");
        this.capShapeStr[3] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.CapBracket.txt", (String)"Bracket"), "Bracket");
        this.connectByStr = new SILKNumber[6];
        this.connectByStr[0] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectMinimum.txt", (String)"Minimum"), "Minimum");
        this.connectByStr[1] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectFirstQuartile.txt", (String)"First Quartile"), "First Quartile");
        this.connectByStr[2] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectMedain.txt", (String)"Median"), "Median");
        this.connectByStr[3] = new SILKNumber(4, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectThirdQuartile.txt", (String)"Third Quartile"), "Third Quartile");
        this.connectByStr[4] = new SILKNumber(5, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectMaximum.txt", (String)"Maximum"), "Maximum");
        this.connectByStr[5] = new SILKNumber(6, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ConnectMean.txt", (String)"Mean"), "Mean");
        this.colorByStr = new SILKNumber[3];
        this.colorByStr[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ColorByChart.txt", (String)"None"), "None");
        this.colorByStr[1] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ColorByCategory.txt", (String)"Category"), "Category");
        this.colorByStr[2] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotBoxPanel.ColorByGroup.txt", (String)"Group"), "Group");
    }

    public BoxPlotChart() {
        this(null);
    }

    public void setXAxis(Axes axis) {
        this.xAxis = axis;
    }

    public void setYAxis(Axes axis) {
        this.yAxis = axis;
    }

    public void setGroupAxis(Axes axis) {
        this.groupAxis = axis;
    }

    public void setLegend(LegendObject leg) {
        this.legend = leg;
    }

    public boolean isLegendRequired() {
        return false;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged(boolean changed) {
        if (changed) {
            this.rebuildRequired = true;
            this.dataChanged = true;
        }
    }

    private void decideVariables() {
        this.xVariable = this.getVariable(BoxPlotModel.X_ROLE_NAME);
        this.yVariable = this.getVariable(BoxPlotModel.Y_ROLE_NAME);
        this.statVariable = this.getVariable(BoxPlotModel.STAT_ROLE_NAME);
        this.groupVariable = this.getVariable(BoxPlotModel.GROUP_ROLE_NAME);
    }

    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.xAxis.setChartAreaDimension(d);
        this.yAxis.setChartAreaDimension(d);
        if (this.groupAxis != null) {
            this.groupAxis.setChartAreaDimension(d);
        }
    }

    public void setChartClipArea(Rectangle2D rect) {
        this.clipRect = rect;
        this.xAxis.setAxisLength(this.clipRect.getWidth());
        this.yAxis.setAxisLength(this.clipRect.getHeight());
        this.xAxis.setGridLineLength(this.clipRect.getHeight());
        this.yAxis.setGridLineLength(this.clipRect.getWidth());
        if (this.groupAxis != null) {
            if (this.orientation == 0) {
                this.groupAxis.setAxisLength(this.clipRect.getWidth());
            } else {
                this.groupAxis.setAxisLength(this.clipRect.getHeight());
            }
        }
        this.updateInnerMargin();
    }

    public Insets getOuterMargin(Graphics2D g) {
        Insets margin = new Insets(0, 0, 0, 0);
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return margin;
        }
        if (!this.prepareChartData()) {
            return margin;
        }
        int leftx = (int)((double)this.xAxis.getValueWidth(g, -1) * 0.5);
        int lefty = this.yAxis.getLeftWidth(g);
        int top = this.xAxis.getTopHeight(g);
        int top1 = 0;
        int top2 = this.xAxis.getRangeSliderThumbSize();
        int right_rl = this.yAxis.getReferenceLineLabelWidth(g);
        int top_rl = this.xAxis.getReferenceLineLabelHeight(g);
        int right = 0;
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null && this.orientation != 0) {
            lefty += this.groupAxis.getLeftWidth(g);
        }
        int axisLen = 0;
        int bottom = 0;
        int right_sav = right;
        for (int i = 0; i < 2; ++i) {
            int halfBar;
            right = Math.max(right, right_rl);
            axisLen = this.chartAreaDimension.width - right - Math.max(leftx, lefty);
            this.xAxis.setAxisLength(axisLen);
            bottom = this.xAxis.getBottomHeight(g);
            int r = (int)((double)this.xAxis.getTickMarkValueWidth(g, -1, true) * 0.5);
            if (this.orientation == 0) {
                halfBar = (int)(0.5 * (double)axisLen / (double)this.boxPlotModel.getUniqueXValueCount());
                r -= halfBar;
            } else {
                halfBar = (int)(0.02 * (double)axisLen);
            }
            r = Math.max(0, r);
            right = right_sav + r;
            if (r == 0) break;
        }
        if (this.xAxis.isHideValues()) {
            leftx = 0;
            right = right_sav;
        }
        right = Math.max(right, right_rl);
        right += this.yAxis.getRangeSliderThumbSize();
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null && this.orientation == 0) {
            this.groupAxis.setAxisLength(axisLen);
            bottom += this.groupAxis.getBottomHeight(g);
        }
        top = top1 + top2;
        top = Math.max(top, top_rl);
        margin.left = Math.min(Math.max(leftx, lefty), (int)((double)this.chartAreaDimension.width * 0.4));
        margin.right = Math.min((int)((double)this.chartAreaDimension.width * 0.4), right);
        margin.top = top;
        margin.bottom = bottom;
        return margin;
    }

    public int getSizePerBox() {
        return this.sizePerBox;
    }

    public void setInnerMargin(Insets im) {
        int nBox;
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) == null) {
            nBox = this.boxPlotModel.getUniqueXValueCount();
        } else {
            int group = this.boxPlotModel.getUniqueGroupValueCount();
            nBox = this.boxPlotModel.getUniqueXValueCount() * group + (group - 1);
        }
        this.sizePerBox = this.orientation == 0 ? (nBox == 1 ? Math.min(im.left, im.right) * 2 : (int)((this.clipRect.getWidth() - (double)im.left - (double)im.right) / ((double)nBox - 1.0))) : (nBox == 1 ? Math.min(im.top, im.bottom) * 2 : (int)((this.clipRect.getHeight() - (double)im.top - (double)im.bottom) / ((double)nBox - 1.0)));
        this.sizePerBox = Math.max(1, this.sizePerBox);
    }

    public Insets getInnerMargin(boolean trellis) {
        if (trellis) {
            return this.chartInnerMargin;
        }
        return this.innerMargin;
    }

    public boolean isInnerMarginChanged() {
        return this.innerMarginChanged;
    }

    protected void updateInnerMargin() {
        if (this.clipRect != null) {
            int nBox;
            if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) == null) {
                nBox = this.boxPlotModel.getUniqueXValueCount();
            } else {
                int group = this.boxPlotModel.getUniqueGroupValueCount();
                nBox = this.boxPlotModel.getUniqueXValueCount() * group + (group - 1);
            }
            if (this.orientation == 0) {
                this.sizePerBox = (int)(this.clipRect.getWidth() / (double)nBox);
                this.innerMargin.right = this.innerMargin.left = (int)(0.5 * (double)Math.max(0, this.markerWidth - this.sizePerBox));
                this.innerMargin.top = this.innerMargin.bottom = (int)((double)this.markerWidth * 0.5);
                this.chartInnerMargin.right = this.chartInnerMargin.left = (int)(0.5 * (double)Math.max(this.markerWidth, this.sizePerBox));
                this.chartInnerMargin.top = this.chartInnerMargin.bottom = (int)((double)this.markerWidth * 0.5);
            } else {
                this.sizePerBox = (int)(this.clipRect.getHeight() / (double)nBox);
                this.innerMargin.top = this.innerMargin.bottom = (int)(0.5 * (double)Math.max(0, this.markerWidth - this.sizePerBox));
                this.innerMargin.right = this.innerMargin.left = (int)((double)this.markerWidth * 0.5);
                this.chartInnerMargin.top = this.chartInnerMargin.bottom = (int)(0.5 * (double)Math.max(this.markerWidth, this.sizePerBox));
                this.chartInnerMargin.right = this.chartInnerMargin.left = (int)((double)this.markerWidth * 0.5);
            }
        } else {
            this.innerMargin.left = 0;
            this.innerMargin.right = 0;
            this.innerMargin.top = 0;
            this.innerMargin.bottom = 0;
            this.chartInnerMargin.left = 0;
            this.chartInnerMargin.right = 0;
            this.chartInnerMargin.top = 0;
            this.chartInnerMargin.bottom = 0;
        }
        this.xAxis.setOffset(this.innerMargin.left, this.innerMargin.right);
        this.yAxis.setOffset(this.innerMargin.bottom, this.innerMargin.top);
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.orientation == 0) {
            this.xAxis.setLabelOffset(this.innerMargin.right);
        }
        this.innerMarginChanged = true;
    }

    public void setMarginListener(ArrayList listener, Object source) {
        this.marginListener = listener;
        this.marginSource = source;
    }

    private void fireMarginChangeEvent(boolean inner, boolean outer) {
        int numListeners = this.marginListener.size();
        if (numListeners > 0) {
            MarginChangeEvent mce = new MarginChangeEvent(this.marginSource);
            if (inner) {
                mce.setInnerChanged(true);
            }
            if (outer) {
                mce.setOuterChanged(true);
            }
            for (int i = 0; i < numListeners; ++i) {
                ((MarginListener)this.marginListener.get(i)).marginChanged(mce);
            }
        }
    }

    public boolean isHighlightRequired() {
        return this.selectionList.size() > 0;
    }

    private boolean prepareChartData() {
        if (this.dataPrepared) {
            return true;
        }
        if (this.boxPlotModel == null) {
            return false;
        }
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataOut = (DataFilterReadInterface)this.boxPlotModel.getDataSource();
        if (this.dataOut == null) {
            return false;
        }
        this.dataOut.addDataFilterListener((Object)this);
        this.decideVariables();
        Object[] xValues = this.boxPlotModel.getUniqueXValues();
        double yMin = this.boxPlotModel.getMinimumValue(this.yVariable);
        double yMax = this.boxPlotModel.getMaximumValue(this.yVariable);
        if (xValues == null || xValues.length <= 0 || Double.isNaN(yMin) || Double.isNaN(yMax)) {
            return false;
        }
        this.xAxis.setFireEvent(false);
        this.yAxis.setFireEvent(false);
        this.xAxis.setVisible(true);
        this.yAxis.setVisible(true);
        if (this.orientation == 0) {
            this.yAxis.setDataSource(this.dataOut);
            this.xAxis.setDataSource(null);
            this.xAxis.setRole(this.xVariable, "XAxis");
            this.yAxis.setRole(this.yVariable, "YAxis");
            this.yAxis.setGridLines(Boolean.TRUE);
            this.xAxis.setGridLines(Boolean.FALSE);
            if (this.xVariable == null) {
                this.xAxis.setVisible(false);
            }
            if (this.groupVariable == null) {
                this.xAxis.setNumberOfGroups(0);
            } else {
                this.xAxis.setNumberOfGroups(this.boxPlotModel.getUniqueGroupValueCount());
            }
            this.xAxis.setTickInCenter(true, 0.5);
            this.xAxis.setAxis(new Double(0.0), new Double(xValues.length - 1), -1, -1, xValues, Boolean.TRUE, null);
            this.xAxis.setLabel(this.boxPlotModel.getVariableDescription(BoxPlotModel.X_ROLE_NAME));
            this.yAxis.setTickInCenter(false, 0.0);
            this.yAxis.setAxis(new Double(yMin), new Double(yMax), -1, -1, null, Boolean.TRUE, null);
            this.yAxis.setLabel(this.boxPlotModel.getVariableDescription(BoxPlotModel.Y_ROLE_NAME));
            this.yAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
        } else {
            this.xAxis.setDataSource(this.dataOut);
            this.yAxis.setDataSource(null);
            this.xAxis.setRole(this.yVariable, "XAxis");
            this.yAxis.setRole(this.xVariable, "YAxis");
            this.xAxis.setGridLines(Boolean.TRUE);
            this.yAxis.setGridLines(Boolean.FALSE);
            if (this.xVariable == null) {
                this.yAxis.setVisible(false);
            }
            if (this.groupVariable == null) {
                this.yAxis.setNumberOfGroups(0);
            } else {
                this.yAxis.setNumberOfGroups(this.boxPlotModel.getUniqueGroupValueCount());
            }
            this.yAxis.setTickInCenter(true, 0.5);
            this.yAxis.setAxis(new Double(0.0), new Double(xValues.length - 1), -1, -1, xValues, Boolean.TRUE, null);
            this.yAxis.setLabel(this.boxPlotModel.getVariableDescription(BoxPlotModel.X_ROLE_NAME));
            this.xAxis.setTickInCenter(false, 0.0);
            this.xAxis.setAxis(new Double(yMin), new Double(yMax), -1, -1, null, Boolean.TRUE, null);
            this.xAxis.setLabel(this.boxPlotModel.getVariableDescription(BoxPlotModel.Y_ROLE_NAME));
            this.xAxis.setDefaultLabelPosition(true);
            this.xAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
        }
        this.xAxis.setFireEvent(true);
        this.yAxis.setFireEvent(true);
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null) {
            this.groupAxis.setFireEvent(false);
            this.groupAxis.setRole(this.groupVariable, "GroupAxis");
            this.groupAxis.setDirection(this.orientation == 0);
            this.groupAxis.setGroupAxis(true);
            this.groupAxis.setGridLines(Boolean.FALSE);
            Object[] gValues = this.boxPlotModel.getUniqueGroupValues();
            if (gValues != null) {
                this.groupAxis.setNumberOfCategories(this.boxPlotModel.getUniqueXValueCount());
                this.groupAxis.setAxis(new Double(0.0), new Double(gValues.length - 1), -1, -1, gValues, Boolean.TRUE, null);
                this.groupAxis.setLabel(this.boxPlotModel.getVariableDescription(BoxPlotModel.GROUP_ROLE_NAME));
            }
            this.groupAxis.getLine().setVisible(false);
            this.groupAxis.getMajorTicks().setVisible(false);
            if (this.orientation == 0) {
                this.groupAxis.setCollisionResolution(2);
            } else {
                this.groupAxis.setCollisionResolution(5);
            }
            this.groupAxis.setFireEvent(true);
        }
        this.dataPrepared = true;
        return true;
    }

    private boolean buildBoxPlot() {
        String xObj;
        int i;
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int sIdx = this.dataOut.getVariableIndex(this.statVariable);
        int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
        Object gObj = null;
        Object tObj = null;
        int g = 0;
        int gInData = 0;
        int numXs = this.boxPlotModel.getUniqueXValueCount();
        int numXInData = this.boxPlotModel.getUniqueXValueCount(false);
        int numGInData = gIdx < 0 ? 1 : this.boxPlotModel.getUniqueGroupValueCount(false);
        this.numBoxes = numXInData * numGInData;
        this.tBox = new TukeyBox[this.numBoxes];
        for (i = 0; i < this.numBoxes; ++i) {
            this.tBox[i] = new TukeyBox(this.transObj);
            this.tBox[i].x = Double.NaN;
            this.tBox[i].y = new double[8];
            for (int j = 0; j < 8; ++j) {
                this.tBox[i].y[j] = Double.NaN;
            }
        }
        i = 0;
        while ((long)i < obs) {
            block26: {
                int xInData;
                int x;
                block25: {
                    xObj = this.dataOut.getFormattedValue(this.xVariable, (long)i, null);
                    x = this.boxPlotModel.getXValueIndex(xObj);
                    xInData = this.boxPlotModel.getXValueIndex(xObj, false);
                    if (gIdx < 0) break block25;
                    gObj = this.dataOut.getFormattedValue(this.groupVariable, (long)i, null);
                    g = this.boxPlotModel.getGroupValueIndex(gObj);
                    gInData = this.boxPlotModel.getGroupValueIndex(gObj, false);
                    if (gInData < 0) break block26;
                }
                int xo = xInData + gInData * numXInData;
                this.tBox[xo].catIdx = xInData;
                if (gIdx >= 0) {
                    this.tBox[xo].groupIdx = gInData;
                }
                this.tBox[xo].x = (double)x + 0.5 + (double)g * ((double)numXs + 1.0);
                double y = this.dataOut.getNumericValue(yIdx, (long)i);
                Object sObj = this.dataOut.getValue(sIdx, (long)i);
                if (((String)sObj).equalsIgnoreCase("MIN") || ((String)sObj).equalsIgnoreCase("LOWERWHISKER")) {
                    this.tBox[xo].y[0] = y;
                } else if (((String)sObj).equalsIgnoreCase("Q1") || ((String)sObj).equalsIgnoreCase("P25")) {
                    this.tBox[xo].y[1] = y;
                } else if (((String)sObj).equalsIgnoreCase("MEDIAN")) {
                    this.tBox[xo].y[2] = y;
                } else if (((String)sObj).equalsIgnoreCase("Q3") || ((String)sObj).equalsIgnoreCase("P75")) {
                    this.tBox[xo].y[3] = y;
                } else if (((String)sObj).equalsIgnoreCase("MAX") || ((String)sObj).equalsIgnoreCase("UPPERWHISKER")) {
                    this.tBox[xo].y[4] = y;
                } else if (((String)sObj).equalsIgnoreCase("MEAN")) {
                    this.tBox[xo].y[5] = y;
                } else if (((String)sObj).equalsIgnoreCase("N")) {
                    this.tBox[xo].y[6] = y;
                } else if (((String)sObj).equalsIgnoreCase("STD")) {
                    this.tBox[xo].y[7] = y;
                } else if (((String)sObj).equalsIgnoreCase("OUTLIER") || ((String)sObj).equalsIgnoreCase("FAROUTLIER")) {
                    Outlier o = new Outlier();
                    o.x = this.tBox[xo].x;
                    o.y = y;
                    o.no = xo;
                    o.rowIdx = i;
                    o.description = this.getDescription((Object)xObj, gObj, y, tObj);
                    this.displayList.add(o);
                }
            }
            ++i;
        }
        for (i = 0; i < this.numBoxes; ++i) {
            int xid = i % numXInData;
            int gid = i / numXInData;
            xObj = this.xVariable == null ? null : this.boxPlotModel.getUniqueXValues(false)[xid];
            gObj = this.groupVariable == null ? null : this.boxPlotModel.getUniqueGroupValues(false)[gid];
            double[] yy = this.tBox[i].y;
            String des = this.getDescription((Object)xObj, gObj, yy, tObj);
            this.tBox[i].setDescription(des);
            this.tBox[i].extremeMin = this.boxPlotModel.getMinimumValue(xid, gid);
            this.tBox[i].extremeMax = this.boxPlotModel.getMaximumValue(xid, gid);
        }
        return true;
    }

    protected String getDescription(Object x, Object g, double[] y, Object t) {
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Probe.fmt.txt", (String)"{0} : {1}"));
        String xstr = "";
        if (x != null) {
            xstr = probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.X_ROLE_NAME)), (Object)this.getValueLabel(this.xVariable, x)) + "\n";
        }
        String gstr = "";
        if (g != null) {
            gstr = probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.GROUP_ROLE_NAME)), (Object)this.getValueLabel(this.groupVariable, g)) + "\n";
        }
        String s1 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MinimumWhisker.txt", (String)"Minimum Whisker :"), (Object)this.getValueLabel(this.yVariable, new Double(y[0])));
        String s2 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.FirstQuartile.txt", (String)"First Quartile :"), (Object)this.getValueLabel(this.yVariable, new Double(y[1])));
        String s3 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Median.txt", (String)"Median :"), (Object)this.getValueLabel(this.yVariable, new Double(y[2])));
        String s4 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.ThirdQuartile.txt", (String)"Third Quartile :"), (Object)this.getValueLabel(this.yVariable, new Double(y[3])));
        String s5 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MaximumWhisker.txt", (String)"Maximum Whisker :"), (Object)this.getValueLabel(this.yVariable, new Double(y[4])));
        String s6 = probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Mean.txt", (String)"Mean :"), (Object)this.getValueLabel(this.yVariable, new Double(y[5])));
        String ystr = s1 + "\n" + s2 + "\n" + s3 + "\n" + s4 + "\n" + s5 + "\n" + s6;
        String tstr = "";
        if (t != null) {
            tstr = "\n" + probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.TIP_ROLE_NAME)), (Object)this.getValueLabel(this.tipVariable, t));
        }
        String str = xstr + gstr + ystr + tstr;
        return str;
    }

    protected String getDescription(Object x, Object g, double y, Object t) {
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Probe.fmt.txt", (String)"{0} : {1}"));
        String xstr = "";
        if (x != null) {
            xstr = probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.X_ROLE_NAME)), (Object)this.getValueLabel(this.xVariable, x)) + "\n";
        }
        String gstr = "";
        if (g != null) {
            gstr = probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.GROUP_ROLE_NAME)), (Object)this.getValueLabel(this.groupVariable, g)) + "\n";
        }
        String ystr = probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.Y_ROLE_NAME)), (Object)this.getValueLabel(this.yVariable, new Double(y))) + "\n";
        String tstr = "";
        if (t != null) {
            tstr = "\n" + probeMessage.toString((Object)((String)this.boxPlotModel.getVariableDescription(BoxPlotModel.TIP_ROLE_NAME)), (Object)this.getValueLabel(this.tipVariable, t));
        }
        String str = xstr + gstr + ystr + tstr;
        return str;
    }

    protected String getValueLabel(Object variableId, Object value) {
        Object format = this.dataOut.getFormat(variableId, null);
        String label = value instanceof String ? value.toString() : this.dataOut.getFormattedValue(variableId, value, format);
        return label.trim();
    }

    private Object[] getDiscreteRangeForIndicies(ArrayList sel) {
        Vector<Object> catList = new Vector<Object>();
        Vector<Object> grpList = new Vector<Object>();
        for (int i = 0; i < sel.size(); ++i) {
            int index = (Integer)sel.get(i);
            if (index < this.numBoxes) {
                if (this.tBox[index].groupIdx < 0) {
                    catList.addElement(this.boxPlotModel.getUniqueXValues(false)[index]);
                    continue;
                }
                if (this.tBox[index].groupIdx < 0) continue;
                catList.addElement(this.boxPlotModel.getUniqueXValues(false)[this.tBox[index].catIdx]);
                grpList.addElement(this.boxPlotModel.getUniqueGroupValues(false)[this.tBox[index].groupIdx]);
                continue;
            }
            if (this.extreme || !this.markerOn) continue;
            Outlier e = (Outlier)this.displayList.get(index -= this.numBoxes);
            int boxIdx = e.no;
            if (this.tBox[boxIdx].groupIdx < 0) {
                catList.addElement(this.boxPlotModel.getUniqueXValues(false)[boxIdx]);
                continue;
            }
            if (this.tBox[boxIdx].groupIdx < 0) continue;
            catList.addElement(this.boxPlotModel.getUniqueXValues(false)[this.tBox[boxIdx].catIdx]);
            grpList.addElement(this.boxPlotModel.getUniqueGroupValues(false)[this.tBox[boxIdx].groupIdx]);
        }
        Object[] retObjArray = new Object[2];
        retObjArray[0] = catList;
        int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
        if (gIdx >= 0) {
            retObjArray[1] = grpList;
        }
        return retObjArray;
    }

    private ContinuousRange getContinuousRangeForIndicies(ArrayList sel) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < sel.size(); ++i) {
            int index = (Integer)sel.get(i);
            if (index < this.numBoxes) {
                TukeyBox tb = this.tBox[index];
                if (!tb.extreme) {
                    min = Math.min(min, tb.y[0]);
                    max = Math.max(max, tb.y[4]);
                    continue;
                }
                min = Math.min(min, tb.extremeMin);
                max = Math.max(max, tb.extremeMax);
                continue;
            }
            if (this.extreme || !this.markerOn) continue;
            Outlier e = (Outlier)this.displayList.get(index -= this.numBoxes);
            min = Math.min(min, e.y);
            max = Math.max(max, e.y);
        }
        return new ContinuousRange(min, max);
    }

    public boolean setSelection(Rectangle2D rect, boolean extend) {
        Outlier e;
        int i;
        ArrayList<Integer> sel = new ArrayList<Integer>();
        int size = this.displayList.size();
        if (extend) {
            Integer obj;
            for (i = 0; i < this.tBox.length; ++i) {
                if (!rect.intersects(this.tBox[i].getBoundingBox()) || sel.contains(obj = new Integer(i))) continue;
                sel.add(obj);
            }
            if (!this.extreme && this.markerOn) {
                for (i = 0; i < size; ++i) {
                    e = (Outlier)this.displayList.get(i);
                    if (!this.tBox[e.no].isValid() || !rect.intersects(e.boundingBox) || sel.contains(obj = new Integer(i + this.numBoxes))) continue;
                    sel.add(obj);
                }
            }
        } else {
            for (i = 0; i < this.tBox.length; ++i) {
                if (!rect.intersects(this.tBox[i].getBoundingBox())) continue;
                sel.add(new Integer(i));
            }
            if (!this.extreme && this.markerOn) {
                for (i = 0; i < size; ++i) {
                    e = (Outlier)this.displayList.get(i);
                    if (!this.tBox[e.no].isValid() || !rect.intersects(e.boundingBox)) continue;
                    sel.add(new Integer(i + this.numBoxes));
                }
            }
        }
        boolean fire = false;
        if (this.selectionList.size() != sel.size()) {
            fire = true;
        } else {
            size = this.selectionList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (sel.get(i2).equals(this.selectionList.get(i2))) continue;
                fire = true;
                break;
            }
        }
        if (fire) {
            if (!extend) {
                this.selectionList.clear();
                this.boxPlotModel.setSelectionAll(false);
            }
            if ((size = sel.size()) > 0) {
                Object[] objArray;
                DataRange[] ranges = null;
                String[] vars = null;
                int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
                if (gIdx >= 0) {
                    ranges = new DataRange[3];
                    vars = new String[3];
                    objArray = this.getDiscreteRangeForIndicies(sel);
                    ranges[0] = new DiscreteRange(((Vector)objArray[0]).toArray());
                    ranges[1] = new DiscreteRange(((Vector)objArray[1]).toArray());
                    ranges[2] = this.getContinuousRangeForIndicies(sel);
                    vars[0] = this.xVariable.toString();
                    vars[1] = this.groupVariable.toString();
                    vars[2] = this.yVariable.toString();
                } else {
                    ranges = new DataRange[2];
                    vars = new String[2];
                    objArray = this.getDiscreteRangeForIndicies(sel);
                    ranges[0] = new DiscreteRange(((Vector)objArray[0]).toArray());
                    ranges[1] = this.getContinuousRangeForIndicies(sel);
                    vars[0] = this.xVariable.toString();
                    vars[1] = this.yVariable.toString();
                }
                for (int i3 = 0; i3 < size; ++i3) {
                    Object o = sel.get(i3);
                    this.selectionList.add(o);
                }
                this.dataIn.setSelected(vars, ranges, true);
            }
            return false;
        }
        return false;
    }

    public void setSelection(int mouseX, int mouseY, boolean extend) {
        int index = this.getSelectedIndex(mouseX, mouseY);
        DataRange[] ranges = null;
        String[] vars = null;
        int outLierdataIdx = -1;
        if (index >= 0) {
            int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
            if (gIdx >= 0) {
                ranges = new DataRange[3];
                vars = new String[3];
            } else {
                ranges = new DataRange[2];
                vars = new String[2];
            }
            if (index < this.numBoxes) {
                Object[] catObjArray = new Object[1];
                Object xVal = null;
                Object gVal = null;
                TukeyBox tb = this.tBox[index];
                if (tb.groupIdx < 0) {
                    xVal = this.boxPlotModel.getUniqueXValues(false)[index];
                } else if (tb.groupIdx >= 0) {
                    xVal = this.boxPlotModel.getUniqueXValues(false)[tb.catIdx];
                    gVal = this.boxPlotModel.getUniqueGroupValues(false)[tb.groupIdx];
                } else {
                    return;
                }
                catObjArray[0] = xVal;
                Object[] grpObjArray = new Object[1];
                ranges[0] = new DiscreteRange(catObjArray);
                if (gVal != null && gIdx >= 0) {
                    grpObjArray[0] = gVal;
                    ranges[1] = new DiscreteRange(grpObjArray);
                }
                vars[0] = this.xVariable.toString();
                int rangeIdx = 1;
                if (gIdx >= 0) {
                    vars[1] = this.groupVariable.toString();
                    rangeIdx = 2;
                }
                ranges[rangeIdx] = !tb.extreme ? new ContinuousRange(tb.y[0], tb.y[4]) : new ContinuousRange(tb.extremeMin, tb.extremeMax);
                vars[rangeIdx] = this.yVariable.toString();
            } else if (!this.extreme && this.markerOn) {
                int dIndex = index - this.numBoxes;
                Outlier o = (Outlier)this.displayList.get(dIndex);
                outLierdataIdx = o.rowIdx;
            }
        }
        if (extend) {
            boolean selected = false;
            int idx = -1;
            if (index >= 0) {
                for (int i = 0; i < this.selectionList.size(); ++i) {
                    if (index != (Integer)this.selectionList.get(i)) continue;
                    selected = true;
                    idx = i;
                    break;
                }
                if (selected) {
                    this.selectionList.remove(idx);
                } else {
                    this.selectionList.add(new Integer(index));
                }
                if (index < this.numBoxes) {
                    this.dataIn.setSelected(vars, ranges, !selected);
                } else if (!this.extreme && this.markerOn) {
                    this.dataIn.setSelected((long)outLierdataIdx, !selected);
                }
            }
        } else {
            this.selectionList.clear();
            this.boxPlotModel.setSelectionAll(false);
            if (index >= 0) {
                this.selectionList.add(new Integer(index));
                if (index < this.numBoxes) {
                    this.dataIn.setSelected(vars, ranges, true);
                } else if (!this.extreme && this.markerOn) {
                    this.dataIn.setSelected((long)outLierdataIdx, true);
                }
            }
        }
    }

    public String getToolTipText(int mouseX, int mouseY) {
        if (!this.visible) {
            return null;
        }
        String desc = null;
        int index = this.getIndexOfTukeyBox(mouseX, mouseY);
        if (index >= 0) {
            desc = this.tBox[index].getDescription();
        } else {
            index = this.getIndexOfDisplayList(mouseX, mouseY);
            if (index >= 0) {
                Outlier e = (Outlier)this.displayList.get(index);
                desc = e.description;
            }
        }
        return desc;
    }

    private int getSelectedIndex(int mouseX, int mouseY) {
        int index = -1;
        int tIndex = this.getIndexOfTukeyBox(mouseX, mouseY);
        if (tIndex >= 0) {
            index = tIndex;
        } else {
            int dIndex = this.getIndexOfDisplayList(mouseX, mouseY);
            if (dIndex >= 0) {
                index = dIndex + this.numBoxes;
            }
        }
        return index;
    }

    private int getIndexOfTukeyBox(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < this.tBox.length; ++i) {
            Rectangle2D bbox = this.tBox[i].getBoundingBox();
            if (!bbox.contains(mouseX, mouseY)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getIndexOfDisplayList(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        if (this.extreme || !this.markerOn) {
            return -1;
        }
        int size = this.displayList.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            Rectangle2D.Double bbox;
            Outlier e = (Outlier)this.displayList.get(i);
            if (!this.tBox[e.no].isValid() || !(bbox = e.boundingBox).contains(mouseX, mouseY)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        this.displayList.clear();
        this.selectionList.clear();
        this.selectedValues = this.boxPlotModel.getSelectedValues();
        boolean rc = this.buildBoxPlot();
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        double[] scr = new double[3];
        DataStyleElement dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleBackground, null).getAsDataStyle();
        this.fillColor = dse.getFillColor();
        this.outlineColor = dse.getLineColor();
        this.outlineWidth = dse.getLineThickness().getSizeValue();
        this.lineColor = this.outlineColor;
        this.lineWidth = this.outlineWidth;
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMedian, null).getAsDataStyle();
        this.medianColor = dse.getLineColor();
        this.medianWidth = dse.getLineThickness().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMean, null).getAsDataStyle();
        this.meanColor = dse.getAsMarkerStyle().getMarkerColor();
        this.meanShape = dse.getMarkerSymbol();
        this.meanWidth = dse.getMarkerSize().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleOutliers, null).getAsDataStyle();
        this.markerColor = dse.getLineColor();
        this.markerShape = dse.getMarkerSymbol();
        this.markerWidth = dse.getMarkerSize().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleWhiskers, null).getAsDataStyle();
        this.whiskerColor = dse.getLineColor();
        this.whiskerWidth = dse.getLineThickness().getSizeValue();
        this.capColor = this.whiskerColor;
        this.capWidth = this.whiskerWidth;
        Object[] groupValues = this.boxPlotModel.getUniqueGroupValues(false);
        double v1 = 0.0;
        double v2 = 1.0;
        if (this.boxPlotModel.getUniqueXValueCount(false) < 1) {
            v2 = 0.0;
        }
        int boxWidth = 0;
        boxWidth = this.orientation == 0 ? (int)(this.transObj.project(v1, 0.0, 0.0, null)[0] - this.transObj.project(v2, 0.0, 0.0, null)[0]) : (int)(this.transObj.project(0.0, v1, 0.0, null)[1] - this.transObj.project(0.0, v2, 0.0, null)[1]);
        if (groupValues != null && groupValues.length > 1) {
            boxWidth /= groupValues.length;
        }
        int uniqueXValueCount = this.boxPlotModel.getUniqueXValueCount(false);
        int uniqueGroupValueCount = this.boxPlotModel.getUniqueXValueCount(false);
        for (int i = 0; i < this.tBox.length; ++i) {
            Color col;
            int gId;
            int xIdInData = i % uniqueXValueCount;
            int gIdInData = i / uniqueGroupValueCount;
            Object xVal = this.boxPlotModel.getUniqueXValues(false)[xIdInData];
            Object groupVal = null;
            if (groupValues != null && groupValues.length > gIdInData) {
                groupVal = groupValues[gIdInData];
            }
            int xId = this.boxPlotModel.getXValueColorIndex(xVal);
            int n = gId = this.groupVariable == null ? 0 : this.boxPlotModel.getGroupValueColorIndex(groupVal);
            if (this.groupVariable == null) {
                if (this.colorBy == 1 && xVal != null) {
                    dse = SILKUtilities.getStyleElement(xVal.toString(), xId, 2, this.style, "GraphDataStyleDefault", null).getAsDataStyle();
                    col = dse.getFillColor();
                } else {
                    col = this.fillColor;
                }
            } else if (this.colorBy == 2 && groupVal != null) {
                dse = SILKUtilities.getStyleElement(groupVal.toString(), gId, 2, this.style, "GraphDataStyleDefault", null).getAsDataStyle();
                col = dse.getFillColor();
            } else if (this.colorBy == 1 && xVal != null) {
                dse = SILKUtilities.getStyleElement(xVal.toString(), xId, 2, this.style, "GraphDataStyleDefault", null).getAsDataStyle();
                col = dse.getFillColor();
            } else {
                col = this.fillColor;
            }
            TukeyBox box = this.tBox[i];
            box.extreme = this.extreme;
            box.notched = box.y[6] > 0.0 ? this.notched : false;
            box.fillOn = this.fillOn;
            if (this.fillOn) {
                box.fillColor = col;
                box.outlineColor = this.outlineColor;
            } else {
                box.fillColor = this.fillColor;
                box.outlineColor = col;
            }
            box.outlineWidth = this.outlineWidth;
            box.capShape = this.capShape;
            box.medianColor = this.medianColor;
            box.medianShape = this.medianShape;
            box.medianWidth = this.medianWidth;
            box.meanColor = this.meanColor;
            box.meanShape = this.meanShape;
            box.meanWidth = this.meanWidth;
            box.markerOn = false;
            box.markerColor = this.markerColor;
            box.markerShape = this.markerShape;
            box.markerWidth = this.markerWidth;
            box.whiskerColor = this.whiskerColor;
            box.whiskerWidth = this.whiskerWidth;
            box.capColor = this.whiskerColor;
            box.capWidth = this.whiskerWidth;
            box.orientation = this.orientation;
            box.boxWidth = this.boxScaleFactor * (double)boxWidth;
            box.draw(g);
            if (this.extreme) {
                double[] yy = new double[this.tBox[i].y.length];
                System.arraycopy(this.tBox[i].y, 0, yy, 0, this.tBox[i].y.length);
                yy[0] = Double.isNaN(this.tBox[i].extremeMin) ? this.tBox[i].y[0] : this.tBox[i].extremeMin;
                yy[4] = Double.isNaN(this.tBox[i].extremeMax) ? this.tBox[i].y[4] : this.tBox[i].extremeMax;
                String des = this.getDescription(xVal, groupVal, yy, null);
                this.tBox[i].setDescription(des);
                continue;
            }
            String des = this.getDescription(xVal, groupVal, this.tBox[i].y, null);
            this.tBox[i].setDescription(des);
        }
        if (!this.extreme && this.markerOn) {
            int size = this.displayList.size();
            for (int i = 0; i < size; ++i) {
                Outlier outlier = (Outlier)this.displayList.get(i);
                if (!this.tBox[outlier.no].isValid()) continue;
                if (this.orientation == 0) {
                    this.transObj.project(outlier.x, outlier.y, 0.0, scr);
                } else {
                    this.transObj.project(outlier.y, outlier.x, 0.0, scr);
                }
                Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)scr[0]), (int)((int)scr[1]));
                outlier.boundingBox = new Rectangle2D.Double();
                outlier.boundingBox.x = scr[0] - (double)this.markerWidth * 0.5;
                outlier.boundingBox.y = scr[1] - (double)this.markerWidth * 0.5;
                outlier.boundingBox.width = this.markerWidth;
                outlier.boundingBox.height = this.markerWidth;
            }
        }
        if (this.chartBorderOn) {
            g.setColor(this.chartBorderColor);
            this.transObj.project(this.xMin, this.yMin, 0.0, this.scr1);
            this.transObj.project(this.xMax, this.yMax, 0.0, this.scr2);
            g.drawRect((int)this.scr1[0], (int)this.scr2[1], (int)(this.scr2[0] - this.scr1[0]), (int)(this.scr1[1] - this.scr2[1]));
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        if (this.connectBy != 0) {
            this.drawConnectingLine(g);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    @Override
    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        int index = 0;
        int size = this.selectionList.size();
        for (int i = 0; i < size; ++i) {
            index = (Integer)this.selectionList.get(i);
            if (index < this.numBoxes) {
                TukeyBox box = this.tBox[index];
                box.outlineColor = this.outlineColor;
                box.outlineWidth = 4;
                box.draw(g);
                continue;
            }
            if (this.extreme || !this.markerOn) continue;
            Outlier outlier = (Outlier)this.displayList.get(index -= this.numBoxes);
            double x = outlier.boundingBox.x + 0.5 * outlier.boundingBox.width;
            double y = outlier.boundingBox.y + 0.5 * outlier.boundingBox.height;
            Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)x), (int)((int)y), (boolean)false, (int)-1, (int)3);
        }
    }

    protected void drawConnectingLine(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setColor(this.lineColor);
        g.setStroke(new BasicStroke(this.lineWidth));
        int size = this.tBox.length;
        int numXInData = this.boxPlotModel.getUniqueXValueCount(false);
        double[] scr1 = new double[3];
        double[] scr2 = new double[3];
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int prev_gid = -1;
        for (int i = 0; i < size; ++i) {
            int gid = i / numXInData;
            TukeyBox box = this.tBox[i];
            if (gid != prev_gid) {
                x1 = box.x;
                y1 = this.getYValue(box);
                if (Double.isNaN(y1)) continue;
                if (this.orientation == 0) {
                    this.transObj.project(x1, y1, 0.0, scr1);
                } else {
                    this.transObj.project(y1, x1, 0.0, scr1);
                }
            } else {
                x2 = box.x;
                y2 = this.getYValue(box);
                if (Double.isNaN(y2)) continue;
                if (this.orientation == 0) {
                    this.transObj.project(x2, y2, 0.0, scr2);
                } else {
                    this.transObj.project(y2, x2, 0.0, scr2);
                }
                g.drawLine((int)scr1[0], (int)scr1[1], (int)scr2[0], (int)scr2[1]);
                scr1[0] = scr2[0];
                scr1[1] = scr2[1];
            }
            prev_gid = gid;
        }
        g.setStroke(oldStroke);
    }

    private double getYValue(TukeyBox box) {
        if (!box.isValid()) {
            return Double.NaN;
        }
        double[] values = box.y;
        double y = Double.NaN;
        switch (this.connectBy) {
            case 1: {
                if (this.extreme) {
                    y = Double.isNaN(box.extremeMin) ? box.y[0] : box.extremeMin;
                    break;
                }
                y = box.y[0];
                break;
            }
            case 2: {
                y = values[1];
                break;
            }
            case 3: {
                if (!box.isGraphed(2)) break;
                y = values[2];
                break;
            }
            case 4: {
                y = values[3];
                break;
            }
            case 5: {
                if (this.extreme) {
                    y = Double.isNaN(box.extremeMax) ? box.y[4] : box.extremeMax;
                    break;
                }
                y = box.y[4];
                break;
            }
            case 6: {
                if (!box.isGraphed(5)) break;
                y = values[5];
            }
        }
        return y;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.boxPlotModel == null) {
            this.boxPlotModel = new BoxPlotModel();
        }
        if (this.boxPlotModel != null) {
            this.boxPlotModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return true;
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.boxPlotModel == null) {
            return null;
        }
        return this.boxPlotModel.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.boxPlotModel == null) {
            return null;
        }
        return this.boxPlotModel.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.boxPlotModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.boxPlotModel.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.boxPlotModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.boxPlotModel.addRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.boxPlotModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.boxPlotModel.removeRole(variableId, role);
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.boxPlotModel == null) {
            return false;
        }
        return this.boxPlotModel.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.boxPlotModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.boxPlotModel.setDiscrete(role, discrete);
    }

    @Override
    public Object getSortOrder(Object role) {
        if (this.boxPlotModel == null) {
            return null;
        }
        return this.boxPlotModel.getSortOrder(role);
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.boxPlotModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.boxPlotModel.setSortOrder(role, order);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.boxPlotModel == null) {
            return null;
        }
        return this.boxPlotModel.getRoleValue(role, which);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] roles = discrete ? new Object[]{BoxPlotModel.ROLES.getRoleObject("ROLE_X"), BoxPlotModel.ROLES.getRoleObject("ROLE_Y"), BoxPlotModel.ROLES.getRoleObject("ROLE_STATISTIC"), BoxPlotModel.ROLES.getRoleObject("ROLE_GROUP")} : new Object[]{BoxPlotModel.ROLES.getRoleObject("ROLE_Y")};
        return roles;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return 1;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public Object getTransformObject() {
        return this.transObj;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transObj = (TransformInterface)transIn;
        return true;
    }

    @Override
    public double[] getBoundingBox() {
        if (!this.dataChanged) {
            return this.chartBBox;
        }
        if (!this.prepareChartData()) {
            return null;
        }
        if (this.boxPlotModel.isZeroObservation()) {
            this.yMin = 0.0;
            this.xMin = 0.0;
            this.yMax = 1.0;
            this.xMax = 1.0;
            this.chartBBox[0] = this.xMin;
            this.chartBBox[1] = this.yMin;
            this.chartBBox[2] = 0.0;
            this.chartBBox[3] = this.xMax;
            this.chartBBox[4] = this.yMax;
            this.chartBBox[5] = 0.0;
            return this.chartBBox;
        }
        if (this.orientation == 0) {
            if (this.groupVariable == null) {
                this.xMin = 0.0;
                this.xMax = this.boxPlotModel.getUniqueXValueCount();
            } else {
                int groups = this.boxPlotModel.getUniqueGroupValueCount();
                this.xMin = 0.0;
                this.xMax = this.boxPlotModel.getUniqueXValueCount() * groups + (groups - 1);
            }
            double[] ends = this.yAxis.getMinMaxTickMarkValues();
            this.yMin = ends[0];
            this.yMax = ends[1];
        } else {
            if (this.groupVariable == null) {
                this.yMin = 0.0;
                this.yMax = this.boxPlotModel.getUniqueXValueCount();
            } else {
                int groups = this.boxPlotModel.getUniqueGroupValueCount();
                this.yMin = 0.0;
                this.yMax = this.boxPlotModel.getUniqueXValueCount() * groups + (groups - 1);
            }
            double[] ends = this.xAxis.getMinMaxTickMarkValues();
            this.xMin = ends[0];
            this.xMax = ends[1];
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = 0.0;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = 0.0;
        return this.chartBBox;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        if (this.orientation == 0) {
            this.xMin = xmin;
            this.xMax = xmax;
            this.yMin = ymin;
            this.yMax = ymax;
        } else {
            this.yMin = ymin;
            this.yMax = ymax;
            this.xMin = xmin;
            this.xMax = xmax;
        }
        if (!this.fixedDataRange) {
            double[] ends = new double[2];
            if (this.orientation == 0) {
                this.yAxis.adjustTickMarkValues((long)this.xMin, (long)(this.xMax + 1.0));
                ends = this.yAxis.getMinMaxTickMarkValues();
                this.yMin = ends[0];
                this.yMax = ends[1];
            } else {
                this.xAxis.adjustTickMarkValues((long)this.yMin, (long)(this.yMax + 1.0));
                ends = this.xAxis.getMinMaxTickMarkValues();
                this.xMin = ends[0];
                this.xMax = ends[1];
            }
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = zmin;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = zmax;
        RedrawEvent e = new RedrawEvent(this);
        e.newBoundingBox = this.chartBBox;
        e.type = 2;
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public Rectangle getScreenArea() {
        return null;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    private void processSelectionAll(boolean selected) {
        long rows = this.dataIn.getNumberObservations(-1);
        int i = 0;
        while ((long)i < rows) {
            this.dataIn.setSelected((long)i, selected);
            this.processSelection(i);
            ++i;
        }
    }

    private void processSelection(int rowIdx) {
        Integer obj;
        int xInData;
        int numXInData = this.boxPlotModel.getUniqueXValueCount(false);
        String xObj = this.dataOut.getFormattedValue(this.xVariable, (long)rowIdx, null);
        int xo = xInData = this.boxPlotModel.getXValueIndex(xObj, false);
        int gInData = -1;
        int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
        if (gIdx >= 0) {
            String gObj = this.dataOut.getFormattedValue(this.groupVariable, (long)rowIdx, null);
            gInData = this.boxPlotModel.getGroupValueIndex(gObj, false);
            if (gInData < 0) {
                return;
            }
            xo = xInData + gInData * numXInData;
        }
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int sIdx = this.dataOut.getVariableIndex(this.statVariable);
        Object sObj = this.dataOut.getValue(sIdx, (long)rowIdx);
        double y = this.dataOut.getNumericValue(yIdx, (long)rowIdx);
        if (((String)sObj).equalsIgnoreCase("OUTLIER") || ((String)sObj).equalsIgnoreCase("FAROUTLIER")) {
            int size = this.displayList.size();
            if (!this.extreme && this.markerOn) {
                for (int i = 0; i < size; ++i) {
                    Integer obj2;
                    Outlier e = (Outlier)this.displayList.get(i);
                    if (!this.tBox[e.no].isValid() || e.no != xo || e.y != y || this.selectionList.contains(obj2 = new Integer(i + this.numBoxes)) || !this.dataIn.isSelected((long)rowIdx)) continue;
                    this.selectionList.add(obj2);
                    break;
                }
            }
        } else if ((this.tBox[xo].y[0] == y || this.tBox[xo].y[1] == y || this.tBox[xo].y[2] == y || this.tBox[xo].y[3] == y || this.tBox[xo].y[4] == y || this.tBox[xo].y[5] == y || this.tBox[xo].y[6] == y || this.tBox[xo].y[7] == y) && !this.selectionList.contains(obj = new Integer(xo)) && this.dataIn.isSelected((long)rowIdx) && this.tBox[xo].catIdx == xInData && this.tBox[xo].groupIdx == gInData) {
            this.selectionList.add(obj);
        }
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.isAdjusting || evt.type != 3 && evt.type != 2) {
            return;
        }
        if (evt.type == 3) {
            this.boxPlotModel.dataFilterChanged(evt);
            this.rebuildRequired = true;
            this.dataChanged = true;
            this.dataPrepared = false;
            this.fireRedrawEvent(new RedrawEvent(this));
        } else if (evt.type == 2) {
            if (evt.oldValue == null) {
                boolean selected;
                if (this.dataIn.getNumberObservations(-1) <= 0) {
                    return;
                }
                boolean bl = selected = this.dataIn.isSelected(0L);
                if (!selected) {
                    this.selectionList.clear();
                }
                this.processSelectionAll(selected);
            } else {
                int[] indicies = (int[])evt.oldValue;
                for (int i = 0; i < indicies.length; ++i) {
                    this.processSelection(indicies[i]);
                }
            }
            RedrawEvent e = new RedrawEvent(this);
            e.type = 5;
            this.fireRedrawEvent(e);
        }
    }

    public boolean isExtreme() {
        return this.extreme;
    }

    public void setExtreme(boolean b) {
        this.extreme = b;
        this.userSetProperties.set(801);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean isNotched() {
        return this.notched;
    }

    public void setNotched(boolean b) {
        this.notched = b;
        this.userSetProperties.set(802);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public double getBoxScaleFactor() {
        return this.boxScaleFactor;
    }

    public void setBoxScaleFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.boxScaleFactor = fac;
        this.userSetProperties.set(805);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
        this.userSetProperties.set(803);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.fillColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.fillColor = col;
        }
        this.userSetProperties.set(804);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outlineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outlineColor = col;
        }
        this.userSetProperties.set(806);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.outlineWidth = w;
        this.userSetProperties.set(807);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getMedianColor() {
        return this.medianColor;
    }

    public void setMedianColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.medianColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.medianColor = col;
        }
        this.userSetProperties.set(809);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMedianShape() {
        return this.medianShape;
    }

    public void setMedianShape(int s) {
        this.medianShape = s;
        this.userSetProperties.set(810);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMedianSize() {
        return this.medianWidth;
    }

    public void setMedianSize(int s) {
        if (s <= 0) {
            return;
        }
        this.medianWidth = s;
        this.userSetProperties.set(811);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getMeanColor() {
        return this.meanColor;
    }

    public void setMeanColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.meanColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.meanColor = col;
        }
        this.userSetProperties.set(812);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMeanShape() {
        return this.meanShape;
    }

    public void setMeanShape(int s) {
        this.meanShape = s;
        this.userSetProperties.set(813);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMeanSize() {
        return this.meanWidth;
    }

    public void setMeanSize(int s) {
        if (s <= 0) {
            return;
        }
        this.meanWidth = s;
        this.userSetProperties.set(814);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean isMarkersOn() {
        return this.markerOn;
    }

    public void setMarkersOn(boolean b) {
        this.markerOn = b;
        this.userSetProperties.set(815);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.markerColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.markerColor = col;
        }
        this.userSetProperties.set(816);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerShape(int s) {
        this.markerShape = s;
        this.userSetProperties.set(817);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getMarkerSize() {
        return this.markerWidth;
    }

    public void setMarkerSize(int s) {
        if (s <= 0) {
            return;
        }
        this.markerWidth = s;
        this.userSetProperties.set(818);
        this.updateInnerMargin();
        this.fireMarginChangeEvent(true, false);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public double getMarkerScaleFactor() {
        return this.markerScaleFac;
    }

    public void setMarkerScaleFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.markerScaleFac = fac;
        this.updateInnerMargin();
        this.fireMarginChangeEvent(true, false);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getWhiskerColor() {
        return this.whiskerColor;
    }

    public void setWhiskerColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.whiskerColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.whiskerColor = col;
        }
        this.userSetProperties.set(819);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public void setWhiskerWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.whiskerWidth = w;
        this.userSetProperties.set(820);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getCapShape() {
        return this.capShape;
    }

    public void setCapShape(int shape) {
        this.capShape = shape;
        this.userSetProperties.set(808);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getCapColor() {
        return this.capColor;
    }

    public void setCapColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.capColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.capColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getCapWidth() {
        return this.capWidth;
    }

    public void setCapWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.capWidth = w;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        if (orient != 1 && orient != 0) {
            return;
        }
        int oldOrient = this.orientation;
        if (oldOrient != orient) {
            this.orientation = orient;
            this.userSetProperties.set(825);
            this.dataChanged = true;
            this.dataPrepared = false;
            this.rebuildRequired = true;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
    }

    public int getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(int by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        this.connectBy = by;
        this.userSetProperties.set(821);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.lineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.lineColor = col;
        }
        this.userSetProperties.set(822);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.lineWidth = w;
        this.userSetProperties.set(823);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public BoxPlotModel getBoxPlotModel() {
        return this.boxPlotModel;
    }

    public boolean isFixedDataRange() {
        return this.fixedDataRange;
    }

    public void setFixedDataRange(boolean fixed) {
        this.fixedDataRange = fixed;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getChartBorderColor() {
        return this.chartBorderColor;
    }

    public void setChartBorderColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartBorderColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartBorderColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean isChartBorderOn() {
        return this.chartBorderOn;
    }

    public void setChartBorderOn(boolean on) {
        this.chartBorderOn = on;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getChartWallColor() {
        return this.chartWallColor;
    }

    public void setChartWallColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartWallColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartWallColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public int getColorBy() {
        return this.colorBy;
    }

    public void setColorBy(int by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this.colorBy = by;
        this.userSetProperties.set(824);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.get(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.add(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.remove(this.redrawListener.indexOf(listener));
        }
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 801: {
                return new Boolean(this.extreme);
            }
            case 802: {
                return new Boolean(this.notched);
            }
            case 803: {
                return new Boolean(this.fillOn);
            }
            case 804: {
                return this.fillColor;
            }
            case 805: {
                return new Double(this.boxScaleFactor);
            }
            case 806: {
                return this.outlineColor;
            }
            case 807: {
                return new Integer(this.outlineWidth);
            }
            case 808: {
                return this.capShapeStr[this.getCapShape()];
            }
            case 809: {
                return this.medianColor;
            }
            case 810: {
                return new Integer(this.medianShape);
            }
            case 811: {
                return new Integer(this.medianWidth);
            }
            case 812: {
                return this.meanColor;
            }
            case 813: {
                return new Integer(this.meanShape);
            }
            case 814: {
                return new Integer(this.meanWidth);
            }
            case 815: {
                return new Boolean(this.markerOn);
            }
            case 816: {
                return this.markerColor;
            }
            case 817: {
                return new Integer(this.markerShape);
            }
            case 818: {
                return new Integer(this.markerWidth);
            }
            case 819: {
                return this.whiskerColor;
            }
            case 820: {
                return new Integer(this.whiskerWidth);
            }
            case 821: {
                if (this.getConnectBy() == 0) {
                    return new Integer(this.getConnectBy());
                }
                return this.connectByStr[this.getConnectBy() - 1];
            }
            case 822: {
                return this.lineColor;
            }
            case 823: {
                return new Integer(this.lineWidth);
            }
            case 824: {
                if (this.groupVariable == null && this.colorBy == 2) {
                    return new Integer(0);
                }
                return new Integer(this.colorBy);
            }
            case 826: {
                return new Boolean(this.groupVariable != null);
            }
            case 19004: {
                return this.styleBackground;
            }
            case 19005: {
                return this.styleMedian;
            }
            case 19006: {
                return this.styleMean;
            }
            case 19007: {
                return this.styleOutliers;
            }
            case 19008: {
                return this.styleWhiskers;
            }
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.set(i, value);
        } else {
            this.propertyIndex.add(new Integer(idx));
            this.propertyValue.add(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 26;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block31: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            switch (idx) {
                case 801: {
                    if (!(value instanceof Boolean)) continue block31;
                    this.extreme = (Boolean)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 802: {
                    if (!(value instanceof Boolean)) continue block31;
                    this.notched = (Boolean)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 803: {
                    if (!(value instanceof Boolean)) continue block31;
                    this.fillOn = (Boolean)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 804: {
                    if (!(value instanceof Color)) continue block31;
                    this.fillColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 805: {
                    if (!(value instanceof Double)) continue block31;
                    this.boxScaleFactor = (Double)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 806: {
                    if (!(value instanceof Color)) continue block31;
                    this.outlineColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 807: {
                    if (!(value instanceof Number)) continue block31;
                    this.outlineWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 808: {
                    Number n;
                    if (value instanceof Number) {
                        n = (Number)value;
                        this.setCapShape(n.intValue());
                    } else if (value instanceof String) {
                        for (int n2 = 0; n2 < this.capShapeStr.length; ++n2) {
                            if (!value.toString().equalsIgnoreCase(this.capShapeStr[n2].toString())) continue;
                            this.setCapShape(this.capShapeStr[n2].intValue());
                        }
                    }
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 809: {
                    if (!(value instanceof Color)) continue block31;
                    this.medianColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 810: {
                    if (!(value instanceof Number)) continue block31;
                    this.medianShape = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 811: {
                    if (!(value instanceof Number)) continue block31;
                    this.medianWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 812: {
                    if (!(value instanceof Color)) continue block31;
                    this.meanColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 813: {
                    if (!(value instanceof Number)) continue block31;
                    this.meanShape = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 814: {
                    if (!(value instanceof Number)) continue block31;
                    this.meanWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 815: {
                    if (!(value instanceof Boolean)) continue block31;
                    this.markerOn = (Boolean)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 816: {
                    if (!(value instanceof Color)) continue block31;
                    this.markerColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 817: {
                    if (!(value instanceof Number)) continue block31;
                    this.markerShape = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 818: {
                    if (!(value instanceof Number)) continue block31;
                    this.markerWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    this.updateInnerMargin();
                    this.fireMarginChangeEvent(true, false);
                    continue block31;
                }
                case 819: {
                    if (!(value instanceof Color)) continue block31;
                    this.whiskerColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 820: {
                    if (!(value instanceof Number)) continue block31;
                    this.whiskerWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 821: {
                    Number n;
                    if (value instanceof Number) {
                        n = (Number)value;
                        this.setConnectBy(n.intValue());
                    } else if (value instanceof String) {
                        for (int n3 = 0; n3 < this.connectByStr.length; ++n3) {
                            if (!value.toString().equalsIgnoreCase(this.connectByStr[n3].getEnglishName())) continue;
                            this.setConnectBy(this.connectByStr[n3].intValue());
                        }
                    }
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 822: {
                    if (!(value instanceof Color)) continue block31;
                    this.lineColor = (Color)value;
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 823: {
                    if (!(value instanceof Number)) continue block31;
                    this.lineWidth = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 824: {
                    if (!(value instanceof Number)) continue block31;
                    this.colorBy = ((Number)value).intValue();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 19004: {
                    if (value == null) continue block31;
                    this.styleBackground = value.toString();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 19005: {
                    if (value == null) continue block31;
                    this.styleMedian = value.toString();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 19006: {
                    if (value == null) continue block31;
                    this.styleMean = value.toString();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 19007: {
                    if (value == null) continue block31;
                    this.styleOutliers = value.toString();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
                case 19008: {
                    if (value == null) continue block31;
                    this.styleWhiskers = value.toString();
                    this.userSetProperties.set(idx);
                    continue block31;
                }
            }
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        this.propertyIndex.clear();
        this.propertyValue.clear();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return true;
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 19004: 
            case 19005: 
            case 19006: 
            case 19007: 
            case 19008: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        if (this.userSetProperties.hasProperty(id)) {
            return this.userSetProperties.get(id);
        }
        return true;
    }

    public void addDataListener() {
    }

    public void removeDataListener() {
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        if (this.dataIn != null) {
            this.dataIn.removeDataFilterListener((Object)this.boxPlotModel);
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (!(newStyle instanceof Style)) {
            return false;
        }
        this.style = (Style)newStyle;
        this.fireRedrawEvent(new RedrawEvent(this));
        return true;
    }

    public boolean isChartDataValid() {
        double yMin = this.boxPlotModel.getMinimumValue(this.yVariable);
        double yMax = this.boxPlotModel.getMaximumValue(this.yVariable);
        return this.boxPlotModel.getUniqueXValues().length > 0 && !Double.isNaN(yMin) && !Double.isNaN(yMax);
    }

    class Outlier {
        double x;
        double y;
        int no;
        int rowIdx;
        String description;
        Rectangle2D.Double boundingBox;

        Outlier() {
        }
    }
}

