/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class VectorElement
extends BaseElement {
    protected SILKNumber xFromRole = null;
    protected SILKNumber xToRole = null;
    protected SILKNumber yFromRole = null;
    protected SILKNumber yToRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber groupIndexRole = null;
    protected SILKNumber colorRole = null;
    protected SILKNumber dataLabelRole = null;
    protected double xOrigin = 0.0;
    protected double yOrigin = 0.0;
    protected int[] xValues = new int[3];
    protected int[] yValues = new int[3];
    protected int arrowWidth = 6;
    protected int halfArrowWidth = this.arrowWidth / 2;
    protected int arrowLength = 8;
    protected HashMap groupIndexMap = null;
    protected String currentLegend = null;
    protected boolean drawArrowheads = true;
    protected boolean includeOriginInRange = true;
    protected String rampName = "ThreeColorRamp";
    private boolean isUnitVectors = false;
    protected int arrowheadShape = 2;
    protected int arrowDirection = 0;
    public static final int[] supportedVectorProperties = new int[]{24, 25, 23, 433, 426, 434, 441, 18701, 18702, 18703, 18704, 18705, 18706};

    public VectorElement() {
        this.xFromRole = this.role.getRoleObject("ROLE_VECTOR_X_FROM");
        this.roles.newRole((Object)this.xFromRole, "Vector X From", 1);
        this.roles.setRoleType((Object)this.xFromRole, 1);
        this.xToRole = this.role.getRoleObject("ROLE_VECTOR_X_TO");
        this.roles.newRole((Object)this.xToRole, "Vector X To", 1);
        this.roles.setRoleType((Object)this.xToRole, 1);
        this.yFromRole = this.role.getRoleObject("ROLE_VECTOR_Y_FROM");
        this.roles.newRole((Object)this.yFromRole, "Vector Y From", 1);
        this.roles.setRoleType((Object)this.yFromRole, 1);
        this.yToRole = this.role.getRoleObject("ROLE_VECTOR_Y_TO");
        this.roles.newRole((Object)this.yToRole, "Vector Y To", 1);
        this.roles.setRoleType((Object)this.yToRole, 1);
        this.colorRole = this.role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, "Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1, null, 99);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.groupIndexRole = this.role.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.newRole((Object)this.groupIndexRole, "Group Index", 1);
        this.roles.setRoleType((Object)this.groupIndexRole, 1);
        this.dataLabelRole = this.role.getRoleObject("ROLE_LABEL");
        this.roles.newRole((Object)this.dataLabelRole, "Data Label", 1);
        this.roles.setRoleType((Object)this.dataLabelRole, 0);
        this.setSupportedProperties(supportedVectorProperties);
        this.userSetProperties.appendProperties(supportedVectorProperties);
        this.addChartTabInfo("com.sas.graphics.silk.ui.VectorPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"VectorElement.Vector.txt", (String)"Vector"));
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 6: {
                this.groupIndexMap = null;
                this.lce.setAction(4);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.colorRole, 0), (Object)this.colorRole);
                }
                this.lce.setAction(1);
                break;
            }
            case 7: {
                this.groupIndexMap = null;
                break;
            }
            case 2: {
                this.initColorRamp();
                if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.groupRole, 0), (Object)this.groupRole);
                }
                this.lce.setAction(4);
                this.lce.setBuildData(this.colorRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                this.lce.setAction(1);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 6: 
            case 7: {
                this.groupIndexMap = null;
                break;
            }
            case 2: {
                this.clearColorRamp();
            }
        }
    }

    protected Object getLegendTitle(String currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0));
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        return null;
    }

    protected boolean isContinuousLegend(String currentLegend) {
        if (currentLegend == null) {
            return false;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend)) {
            return false;
        }
        return this.colorRole.toString().equalsIgnoreCase(currentLegend);
    }

    protected Object getLegendEntries(String currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int groupIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupIndexRole, 0));
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend)) {
            if (groupVar == null) {
                return null;
            }
            if (allGroupValues == null || subsetGroupValues == null) {
                return null;
            }
            this.buildGroupIndexMap(groupVar, groupVarIndex, groupIndexVarIndex);
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(subsetGroupValues.length);
            for (int i = 0; i < subsetGroupValues.length; ++i) {
                Color color = this.style.getLineStyleElement("GraphDataStyleDefault").getLineColor();
                int pattern = 1;
                int groupIndex = -1;
                Object o = null;
                if (subsetGroupValues[i] != null) {
                    o = this.groupIndexMap.get(subsetGroupValues[i]);
                }
                if (o != null) {
                    groupIndex = ((Number)o).intValue();
                }
                if (groupIndex >= 0) {
                    LineStyleElement lse = null;
                    int type = groupIndex >= 0 ? 2 : 1;
                    lse = SILKUtilities.getStyleElement(subsetGroupValues[i].toString(), groupIndex, type, this.style, this.lineAttrs.getReference(), null).getAsLineStyle();
                    color = lse.getLineColor();
                    pattern = lse.getLineStyle();
                } else {
                    color = this.style.getLineStyleElement("Outlines").getLineColor();
                }
                LineAttrib ls = new LineAttrib(true, color, 1);
                ls.setPattern(pattern);
                legendEntries.add(new LegendEntry(subsetGroupValues[i], null, ls));
            }
            return legendEntries;
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend) && colorVarIndex >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    protected void buildGroupIndexMap(Object groupVar, int groupVarIndex, int groupIndexVarIndex) {
        if (this.filter == null) {
            return;
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)this.filter.getSource());
        if (this.groupIndexMap == null) {
            this.groupIndexMap = new HashMap();
        } else {
            this.groupIndexMap.clear();
        }
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        if (allGroupValues == null) {
            return;
        }
        if (groupIndexVarIndex >= 0) {
            for (int i = 0; i < dfri.getNumberObservations(-1); ++i) {
                double gi;
                String group = dfri.getFormattedValue(groupVar, (long)i, null);
                if (!this.groupIndexMap.containsKey(group) && (gi = dfri.getNumericValue(groupIndexVarIndex, (long)i)) >= 0.0) {
                    this.groupIndexMap.put(group, new Double(gi));
                }
                if (this.groupIndexMap.size() != allGroupValues.length) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < allGroupValues.length; ++i) {
                this.groupIndexMap.put(allGroupValues[i], new Integer(i));
            }
        }
    }

    protected int getGroupIndex(int obs, int groupVarIndex, int groupIndexVarIndex) {
        if (this.filter == null) {
            return -1;
        }
        if (groupVarIndex < 0) {
            return -1;
        }
        String value = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)obs, null);
        if (value == null) {
            return -1;
        }
        return this.getGroupIndex(value, groupVarIndex, groupIndexVarIndex);
    }

    protected int getGroupIndex(Object value, int groupVarIndex, int groupIndexVarIndex) {
        if (groupVarIndex < 0) {
            return -1;
        }
        if (this.groupIndexMap == null) {
            Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
            if (groupVar == null) {
                return -1;
            }
            this.buildGroupIndexMap(groupVar, groupVarIndex, groupIndexVarIndex);
        }
        if (this.groupIndexMap == null || value == null) {
            return -1;
        }
        Object o = this.groupIndexMap.get(value);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    @Override
    protected void drawChart(Graphics g) {
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xToRole, 0));
        int yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yToRole, 0));
        int xFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xFromRole, 0));
        int yFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yFromRole, 0));
        int colorIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorRole, 0));
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int groupIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupIndexRole, 0));
        int dataLabelVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.dataLabelRole, 0));
        Object dataLabelVariable = this.filter.getVariableId(dataLabelVarIndex);
        TextStyleElement se = this.getDataLabelStyle().getAsTextStyle();
        FontMetrics dataLabelFontMetrics = g.getFontMetrics(se.getFont());
        double[] projectValues = new double[3];
        if (xVarIndex < 0 || yVarIndex < 0) {
            return;
        }
        projectValues = this.transformObject.project(this.xOrigin, this.yOrigin, 0.0, projectValues);
        int x0 = (int)projectValues[0];
        int y0 = (int)projectValues[1];
        g.setColor(Color.black);
        double originX = this.xOrigin;
        double originY = this.yOrigin;
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            if (!this.filter.isGraphed((long)i)) continue;
            double xValue = this.filter.getNumericValue(xVarIndex, (long)i);
            double yValue = this.filter.getNumericValue(yVarIndex, (long)i);
            if (this.isUnitVectors) {
                ContinuousRange xr = (ContinuousRange)this.getOutputRange((byte)1);
                double range = Double.NaN;
                range = xValue >= 0.0 ? Math.abs(xr.getMax()) : Math.abs(xr.getMin());
                xValue *= range;
                ContinuousRange yr = (ContinuousRange)this.getOutputRange((byte)2);
                range = yValue >= 0.0 ? Math.abs(yr.getMax()) : Math.abs(yr.getMin());
                yValue *= range;
            }
            int groupIndex = -1;
            if (groupVarIndex >= 0) {
                groupIndex = this.getGroupIndex(i, groupVarIndex, groupIndexVarIndex);
            }
            if (groupVarIndex >= 0 && !this.includeMissingGroup && this.filter.isMissing(groupVarIndex, this.filter.getValue(groupVarIndex, (long)i))) continue;
            LineStyleElement lse = null;
            String id = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)i, null);
            if (id == null) {
                id = this.roles.getVariable((Object)this.yToRole, 0).toString();
            }
            int type = groupIndex >= 0 ? 2 : 1;
            lse = SILKUtilities.getStyleElement(id, groupIndex, type, this.style, this.lineAttrs.getReference(), null).getAsLineStyle();
            if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
            projectValues = this.transformObject.project(xValue, yValue, 0.0, projectValues);
            int x = (int)projectValues[0];
            int y = (int)projectValues[1];
            if (xFromVarIndex >= 0) {
                originX = this.filter.getNumericValue(xFromVarIndex, (long)i);
            }
            if (yFromVarIndex >= 0) {
                originY = this.filter.getNumericValue(yFromVarIndex, (long)i);
            }
            if (Double.isNaN(originX) || Double.isNaN(originY)) continue;
            if (xFromVarIndex >= 0 || yFromVarIndex >= 0) {
                projectValues = this.transformObject.project(originX, originY, 0.0, projectValues);
                x0 = (int)projectValues[0];
                y0 = (int)projectValues[1];
            }
            Color c = null;
            c = colorIndex >= 0 ? this.getMappedColor(i, colorIndex) : lse.getLineColor();
            g.setColor(c);
            int linestyle = lse.getLineStyle();
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)linestyle, (int)1));
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            x = Math.max(minValue, Math.min(maxValue, x));
            y = Math.max(minValue, Math.min(maxValue, y));
            x0 = Math.max(minValue, Math.min(maxValue, x0));
            y0 = Math.max(minValue, Math.min(maxValue, y0));
            if (this.arrowDirection == 0 || this.arrowDirection == 2) {
                this.drawVector(g, x0, y0, x, y);
            }
            if (this.arrowDirection == 1 || this.arrowDirection == 2) {
                this.drawVector(g, x, y, x0, y0);
            }
            if (dataLabelVarIndex < 0 || this.dataLabelObject == null) continue;
            this.dataLabelObject.addNode(this.getDataLabelId(), this.filter.getFormattedValue(dataLabelVariable, (long)i, null), x, y, dataLabelFontMetrics, 5);
            this.dataLabelObject.addObstacle((Shape)new Line2D.Double(x, y, x0, y0));
        }
    }

    private void drawVector(Graphics g, int x1, int y1, int x2, int y2) {
        int y;
        int x;
        int min;
        int max;
        if (x2 - x1 == 0 && y2 - y1 == 0) {
            return;
        }
        switch (this.arrowheadShape) {
            case 1: {
                max = Math.max(this.xValues[2], this.xValues[1]);
                min = Math.min(this.xValues[2], this.xValues[1]);
                x = min + (max - min) / 2;
                max = Math.max(this.yValues[2], this.yValues[1]);
                min = Math.min(this.yValues[2], this.yValues[1]);
                y = min + (max - min) / 2;
                g.drawLine(x1, y1, x, y);
                break;
            }
            default: {
                g.drawLine(x1, y1, x2, y2);
            }
        }
        if (this.drawArrowheads) {
            this.calcValues(x1, y1, x2, y2);
            switch (this.arrowheadShape) {
                case 3: {
                    g.drawLine(this.xValues[0], this.yValues[0], this.xValues[1], this.yValues[1]);
                    g.drawLine(this.xValues[0], this.yValues[0], this.xValues[2], this.yValues[2]);
                    max = Math.max(this.xValues[2], this.xValues[1]);
                    min = Math.min(this.xValues[2], this.xValues[1]);
                    x = min + (max - min) / 2;
                    max = Math.max(this.yValues[2], this.yValues[1]);
                    min = Math.min(this.yValues[2], this.yValues[1]);
                    y = min + (max - min) / 2;
                    min = Math.min(x, x2);
                    max = Math.max(x, x2);
                    int midx = min + (max - min) / 2;
                    min = Math.min(y, y2);
                    max = Math.max(y, y2);
                    int midy = min + (max - min) / 2;
                    g.drawLine(midx, midy, this.xValues[1], this.yValues[1]);
                    g.drawLine(midx, midy, this.xValues[2], this.yValues[2]);
                    break;
                }
                case 1: {
                    max = Math.max(this.xValues[2], this.xValues[1]);
                    min = Math.min(this.xValues[2], this.xValues[1]);
                    x = min + (max - min) / 2;
                    max = Math.max(this.yValues[2], this.yValues[1]);
                    min = Math.min(this.yValues[2], this.yValues[1]);
                    y = min + (max - min) / 2;
                    g.drawPolygon(this.xValues, this.yValues, 3);
                    break;
                }
                case 2: {
                    g.fillPolygon(this.xValues, this.yValues, 3);
                    break;
                }
                default: {
                    g.drawLine(this.xValues[0], this.yValues[0], this.xValues[1], this.yValues[1]);
                    g.drawLine(this.xValues[0], this.yValues[0], this.xValues[2], this.yValues[2]);
                }
            }
        }
    }

    private void calcValues(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y2 < y1) {
                this.arrowCoords(x2, y2, x2 - this.halfArrowWidth, y2 + this.arrowLength, x2 + this.halfArrowWidth, y2 + this.arrowLength);
            } else {
                this.arrowCoords(x2, y2, x2 - this.halfArrowWidth, y2 - this.arrowLength, x2 + this.halfArrowWidth, y2 - this.arrowLength);
            }
            return;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                this.arrowCoords(x2, y2, x2 - this.arrowLength, y2 - this.halfArrowWidth, x2 - this.arrowLength, y2 + this.halfArrowWidth);
            } else {
                this.arrowCoords(x2, y2, x2 + this.arrowLength, y2 - this.halfArrowWidth, x2 + this.arrowLength, y2 + this.halfArrowWidth);
            }
            return;
        }
        this.calcValuesQuad(x1, y1, x2, y2);
    }

    public void arrowCoords(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.xValues[0] = x1;
        this.yValues[0] = y1;
        this.xValues[1] = x2;
        this.yValues[1] = y2;
        this.xValues[2] = x3;
        this.yValues[2] = y3;
    }

    public void calcValuesQuad(int x1, int y1, int x2, int y2) {
        double arrowAng = Math.toDegrees(Math.atan((double)this.halfArrowWidth / (double)this.arrowLength));
        double dist = Math.sqrt(this.arrowLength * this.arrowLength + this.arrowWidth);
        double lineAng = Math.toDegrees(Math.atan((double)Math.abs(x1 - x2) / (double)Math.abs(y1 - y2)));
        if (x1 > x2) {
            if (y1 > y2) {
                lineAng = 180.0 - lineAng;
            }
        } else {
            lineAng = y1 > y2 ? 180.0 + lineAng : 360.0 - lineAng;
        }
        this.xValues[0] = x2;
        this.yValues[0] = y2;
        this.calcCoords(1, x2, y2, dist, lineAng - arrowAng);
        this.calcCoords(2, x2, y2, dist, lineAng + arrowAng);
    }

    public void calcCoords(int index, int x, int y, double dist, double dirn) {
        while (dirn < 0.0) {
            dirn = 360.0 + dirn;
        }
        while (dirn > 360.0) {
            dirn -= 360.0;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x + (int)(Math.sin(Math.toRadians(dirn)) * dist);
            this.yValues[index] = y - (int)(Math.cos(Math.toRadians(dirn)) * dist);
            return;
        }
        if (dirn <= 180.0) {
            this.xValues[index] = x + (int)(Math.cos(Math.toRadians(dirn - 90.0)) * dist);
            this.yValues[index] = y + (int)(Math.sin(Math.toRadians(dirn - 90.0)) * dist);
            return;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x - (int)(Math.sin(Math.toRadians(dirn - 180.0)) * dist);
            this.yValues[index] = y + (int)(Math.cos(Math.toRadians(dirn - 180.0)) * dist);
        } else {
            this.xValues[index] = x - (int)(Math.cos(Math.toRadians(dirn - 270.0)) * dist);
            this.yValues[index] = y - (int)(Math.sin(Math.toRadians(dirn - 270.0)) * dist);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xToRole, 0));
        int yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yToRole, 0));
        int xFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xFromRole, 0));
        int yFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yFromRole, 0));
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int groupIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupIndexRole, 0));
        double[] projectValues = new double[3];
        if (xVarIndex < 0 || yVarIndex < 0) {
            return;
        }
        projectValues = this.transformObject.project(this.xOrigin, this.yOrigin, 0.0, projectValues);
        int x0 = (int)projectValues[0];
        int y0 = (int)projectValues[1];
        double originX = this.xOrigin;
        double originY = this.yOrigin;
        Color selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
        if (selectionColor != null) {
            g.setColor(selectionColor);
        }
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            if (!this.filter.isGraphed((long)index)) continue;
            double xValue = this.filter.getNumericValue(xVarIndex, (long)index);
            double yValue = this.filter.getNumericValue(yVarIndex, (long)index);
            int groupIndex = this.getGroupIndex(index, groupVarIndex, groupIndexVarIndex);
            LineStyleElement lse = null;
            String id = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)index, null);
            if (id == null) {
                id = this.roles.getVariable((Object)this.yToRole, 0).toString();
            }
            int type = groupIndex >= 0 ? 2 : 1;
            lse = SILKUtilities.getStyleElement(id, groupIndex, type, this.style, this.lineAttrs.getReference(), null).getAsLineStyle();
            if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
            projectValues = this.transformObject.project(xValue, yValue, 0.0, projectValues);
            int x = (int)projectValues[0];
            int y = (int)projectValues[1];
            if (xFromVarIndex >= 0) {
                originX = this.filter.getNumericValue(xFromVarIndex, (long)index);
            }
            if (yFromVarIndex >= 0) {
                originY = this.filter.getNumericValue(yFromVarIndex, (long)index);
            }
            if (Double.isNaN(originX) || Double.isNaN(originY)) continue;
            if (xFromVarIndex >= 0 || yFromVarIndex >= 0) {
                projectValues = this.transformObject.project(originX, originY, 0.0, projectValues);
                x0 = (int)projectValues[0];
                y0 = (int)projectValues[1];
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lse.getLineStyle(), (int)1));
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.arrowDirection == 0 || this.arrowDirection == 2) {
                this.drawVector(g, x0, y0, x, y);
            }
            if (this.arrowDirection != 1 && this.arrowDirection != 2) continue;
            this.drawVector(g, x, y, x0, y0);
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle rect = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        rect = (Rectangle)selectRegion;
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xToRole, 0));
        int yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yToRole, 0));
        int xFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xFromRole, 0));
        int yFromVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yFromRole, 0));
        double[] projectValues = new double[3];
        if (xVarIndex < 0 || yVarIndex < 0) {
            return false;
        }
        projectValues = this.transformObject.project(this.xOrigin, this.yOrigin, 0.0, projectValues);
        int x0 = (int)projectValues[0];
        int y0 = (int)projectValues[1];
        double originX = this.xOrigin;
        double originY = this.yOrigin;
        int[] sel = new int[1];
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double xValue = this.filter.getNumericValue(xVarIndex, (long)i);
            double yValue = this.filter.getNumericValue(yVarIndex, (long)i);
            if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
            projectValues = this.transformObject.project(xValue, yValue, 0.0, projectValues);
            int x = (int)projectValues[0];
            int y = (int)projectValues[1];
            if (xFromVarIndex >= 0) {
                originX = this.filter.getNumericValue(xFromVarIndex, (long)i);
            }
            if (yFromVarIndex >= 0) {
                originY = this.filter.getNumericValue(yFromVarIndex, (long)i);
            }
            if (Double.isNaN(originX) || Double.isNaN(originY)) continue;
            if (xFromVarIndex >= 0 || yFromVarIndex >= 0) {
                projectValues = this.transformObject.project(originX, originY, 0.0, projectValues);
                x0 = (int)projectValues[0];
                y0 = (int)projectValues[1];
            }
            if (!rect.intersectsLine(x0, y0, x, y)) continue;
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                sel[0] = i;
                ((AbstractDataFilter)this.filter).setSelected((Object)sel, 3, null);
                continue;
            }
            this.filter.setSelected((long)i, true);
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        return null;
    }

    protected boolean isLegendValid(Object role) {
        Object o = null;
        o = this.getLegendEntries(role.toString());
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) {
                    rc = this.roles.getVariable((Object)this.groupRole, 0);
                    break;
                }
                if (!this.colorRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid((Object)this.groupRole)) {
                    legNames.add(this.groupRole);
                }
                if (this.isLegendValid((Object)this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
                break;
            }
            case 18701: {
                rc = new Boolean(this.drawArrowheads);
                break;
            }
            case 18702: {
                rc = new Double(this.xOrigin);
                break;
            }
            case 18703: {
                rc = new Double(this.yOrigin);
                break;
            }
            case 18704: {
                rc = new Boolean(this.includeOriginInRange);
                break;
            }
            case 18706: {
                rc = new Integer(this.getArrowDirection());
                break;
            }
            case 18705: {
                rc = new Integer(this.getArrowheadShape());
                break;
            }
            case 19057: {
                rc = new Object[]{RoleInterface.ROLE_VECTOR_X_FROM, RoleInterface.ROLE_VECTOR_X_TO};
                break;
            }
            case 19056: {
                rc = new Object[]{RoleInterface.ROLE_VECTOR_Y_FROM, RoleInterface.ROLE_VECTOR_Y_TO};
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.groupRole.toString()) && !leg.equalsIgnoreCase(this.colorRole.toString())) break;
                this.currentLegend = leg;
                return true;
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 18701: {
                if (!(value instanceof Boolean)) break;
                this.setDrawArrowHeads((Boolean)value);
                break;
            }
            case 18702: {
                if (!(value instanceof Number)) break;
                this.setXOrigin(((Number)value).doubleValue());
                break;
            }
            case 18703: {
                if (!(value instanceof Number)) break;
                this.setYOrigin(((Number)value).doubleValue());
                break;
            }
            case 18704: {
                if (!(value instanceof Boolean)) break;
                this.setOriginIncludedInRange((Boolean)value);
                break;
            }
            case 18705: {
                if (!(value instanceof Number)) break;
                this.setArrowheadShape(((Number)value).intValue());
                break;
            }
            case 18706: {
                if (!(value instanceof Number)) break;
                this.setArrowDirection(((Number)value).intValue());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public boolean isOriginIncludedInRange() {
        return this.includeOriginInRange;
    }

    public void setOriginIncludedInRange(boolean include) {
        this.includeOriginInRange = include;
        this.userSetProperties.set(18704);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(3);
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        super.setColorScheme(newScheme);
        this.initColorRamp();
        return true;
    }

    public boolean isDrawArrowHeads() {
        return this.drawArrowheads;
    }

    public void setDrawArrowHeads(boolean b) {
        this.drawArrowheads = b;
        if (!this.drawArrowheads) {
            this.userSetProperties.set(18701);
        } else {
            this.userSetProperties.clear(18701);
        }
    }

    public double getXOrigin() {
        return this.xOrigin;
    }

    public void setXOrigin(double origin) {
        this.xOrigin = origin;
        if (this.xOrigin == 0.0) {
            this.userSetProperties.clear(18702);
        } else {
            this.userSetProperties.set(18702);
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
    }

    public double getYOrigin() {
        return this.yOrigin;
    }

    public void setYOrigin(double origin) {
        this.yOrigin = origin;
        if (this.yOrigin == 0.0) {
            this.userSetProperties.clear(18703);
        } else {
            this.userSetProperties.set(18703);
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        DataRange r = super.getPreferredRange(which);
        if (!(r instanceof ContinuousRange) || !this.includeOriginInRange) {
            return r;
        }
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            ContinuousRange cr;
            Object role = rolesEnum.nextElement();
            if (role.equals(RoleInterface.ROLE_VECTOR_X_TO)) {
                if (this.roles.getVariable(RoleInterface.ROLE_VECTOR_X_FROM, 0) != null) continue;
                cr = (ContinuousRange)r;
                cr.setMin(Math.min(cr.getMin(), this.xOrigin));
                cr.setMax(Math.max(cr.getMax(), this.xOrigin));
                continue;
            }
            if (!role.equals(RoleInterface.ROLE_VECTOR_Y_TO) || this.roles.getVariable(RoleInterface.ROLE_VECTOR_Y_FROM) != null) continue;
            cr = (ContinuousRange)r;
            cr.setMin(Math.min(cr.getMin(), this.yOrigin));
            cr.setMax(Math.max(cr.getMax(), this.yOrigin));
        }
        return r;
    }

    public int getArrowheadShape() {
        return this.arrowheadShape;
    }

    public void setArrowheadShape(int arrowheadShape) {
        this.arrowheadShape = arrowheadShape;
        this.userSetProperties.set(18705);
    }

    public int getArrowDirection() {
        return this.arrowDirection;
    }

    public void setArrowDirection(int arrowDirection) {
        this.arrowDirection = arrowDirection;
        this.userSetProperties.set(18706);
    }
}

