/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.UniqueValueInterface;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.boxplot.TukeyBox;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BoxPlotPropertyInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public class VBoxElement
extends BaseElement
implements BoxPlotPropertyInterface {
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber groupRole = null;
    protected Object xVar = null;
    protected Object yVar = null;
    protected Object groupVar = null;
    protected CharacterVariableMapper xMapper = null;
    protected CharacterVariableMapper groupMapper = null;
    protected double[] projectValues = new double[3];
    protected DefaultStatistics defaultStatistics = null;
    protected Vector tuples = null;
    protected Object[] summaryVars = null;
    public static final int CONNECT_NONE = 0;
    public static final int CONNECT_MIN = 1;
    public static final int CONNECT_Q1 = 2;
    public static final int CONNECT_MEDIAN = 3;
    public static final int CONNECT_Q3 = 4;
    public static final int CONNECT_MAX = 5;
    public static final int CONNECT_MEAN = 6;
    protected boolean extreme;
    protected boolean notched;
    protected boolean fillOn;
    protected Color fillColor;
    protected double boxWidth;
    protected Color outlineColor;
    protected int outlineWidth;
    protected int capShape;
    protected Color medianColor;
    protected int medianShape;
    protected int medianWidth;
    protected Color meanColor;
    protected int meanShape;
    protected int meanWidth;
    protected boolean markerOn;
    protected Color markerColor;
    protected int markerShape;
    protected int markerWidth;
    protected Color whiskerColor;
    protected int whiskerWidth;
    protected Color capColor;
    protected int capWidth;
    protected int orientation;
    protected int connectBy;
    protected Color lineColor;
    protected int lineWidth;
    protected String styleBackground = "GraphDataStyleDefault";
    protected String styleMean = "BoxMean";
    protected String styleMedian = "BoxMedian";
    protected String styleOutliers = "Outlier";
    protected String styleWhiskers = "BoxWhisker";
    protected String styleSelection = "Selection";
    public static final int[] supportedProperties = new int[]{801, 802, 803, 804, 805, 806, 807, 825, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 19004, 19005, 19006, 19007, 19008, 19055, 19054};
    private SILKNumber[] capShapeStr;
    private SILKNumber[] connectByStr;
    private SILKNumber[] colorByStr;
    private static final int INTERNAL_GAP = 2;

    public VBoxElement() {
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.roles.setDiscrete((Object)this.xRole, true);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.setSupportedProperties(supportedProperties);
        this.userSetProperties.appendProperties(supportedProperties);
        this.extreme = false;
        this.notched = false;
        this.boxWidth = 0.6;
        this.fillOn = true;
        this.fillColor = this.style.getDataFillColors()[0];
        this.outlineColor = this.style.getDataLineColors()[0];
        this.outlineWidth = 1;
        this.capShape = 1;
        this.medianColor = this.style.getDataLineColors()[0];
        this.medianShape = -1;
        this.medianWidth = 9;
        this.meanColor = this.style.getDataLineColors()[0];
        this.meanShape = 6;
        this.meanWidth = 9;
        this.markerOn = true;
        this.markerColor = this.style.getDataLineColors()[0];
        this.markerShape = 3;
        this.markerWidth = 7;
        this.whiskerColor = this.style.getDataLineColors()[0];
        this.whiskerWidth = 1;
        this.capColor = this.style.getDataLineColors()[0];
        this.capWidth = 1;
        this.orientation = 0;
        this.connectBy = 0;
        this.lineColor = this.style.getDataLineColors()[0];
        this.lineWidth = 1;
        this.capShapeStr = new SILKNumber[4];
        this.capShapeStr[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.CapNone.txt", (String)"None"), "None");
        this.capShapeStr[1] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.CapSerif.txt", (String)"Serif"), "Serif");
        this.capShapeStr[2] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.CapLine.txt", (String)"Line"), "Line");
        this.capShapeStr[3] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.CapBracket.txt", (String)"Bracket"), "Bracket");
        this.connectByStr = new SILKNumber[6];
        this.connectByStr[0] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectMinimum.txt", (String)"Minimum"), "Minimum");
        this.connectByStr[1] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectFirstQuartile.txt", (String)"First Quartile"), "First Quartile");
        this.connectByStr[2] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectMedain.txt", (String)"Median"), "Median");
        this.connectByStr[3] = new SILKNumber(4, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectThirdQuartile.txt", (String)"Third Quartile"), "Third Quartile");
        this.connectByStr[4] = new SILKNumber(5, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectMaximum.txt", (String)"Maximum"), "Maximum");
        this.connectByStr[5] = new SILKNumber(6, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ConnectMean.txt", (String)"Mean"), "Mean");
        this.colorByStr = new SILKNumber[3];
        this.colorByStr[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ColorByChart.txt", (String)"None"), "None");
        this.colorByStr[1] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ColorByCategory.txt", (String)"Category"), "Category");
        this.colorByStr[2] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.ColorByGroup.txt", (String)"Group"), "Group");
        this.addChartTabInfo("com.sas.graphics.silk.ui.BoxPlotBoxPanel", ResourceLoader.getResourceString((Object)this.rb, (String)"BaseBoxElement.Box.txt", (String)"Box"));
        if (this.prefInnerMargin == null) {
            this.prefInnerMargin = new Insets(2, 2, 2, 2);
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        block43: {
            int i;
            double boxW;
            ArrayList<Integer> IndexList;
            HashMap<Double, Double> connectMap;
            double[] scr2;
            double[] scr1;
            block42: {
                double[] outliers;
                if (this.xVar != null && this.tuples == null) {
                    return;
                }
                if (this.yVar == null) {
                    return;
                }
                scr1 = new double[]{Double.NaN, Double.NaN, 0.0};
                scr2 = new double[3];
                connectMap = new HashMap<Double, Double>();
                IndexList = new ArrayList<Integer>();
                DataStyleElement dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleBackground, null).getAsDataStyle();
                this.fillColor = dse.getFillColor();
                this.outlineColor = dse.getLineColor();
                this.outlineWidth = dse.getLineThickness().getSizeValue();
                this.lineColor = this.outlineColor;
                this.lineWidth = this.outlineWidth;
                dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMedian, null).getAsDataStyle();
                this.medianColor = dse.getLineColor();
                this.medianWidth = dse.getLineThickness().getSizeValue();
                dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMean, null).getAsDataStyle();
                this.meanColor = dse.getAsMarkerStyle().getMarkerColor();
                this.meanShape = dse.getMarkerSymbol();
                this.meanWidth = dse.getMarkerSize().getSizeValue();
                dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleOutliers, null).getAsDataStyle();
                this.markerColor = dse.getAsMarkerStyle().getMarkerColor();
                this.markerShape = dse.getMarkerSymbol();
                this.markerWidth = dse.getMarkerSize().getSizeValue();
                dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleWhiskers, null).getAsDataStyle();
                this.whiskerColor = dse.getLineColor();
                this.whiskerWidth = dse.getLineThickness().getSizeValue();
                this.capColor = this.whiskerColor;
                double v1 = 0.0;
                double v2 = 1.0;
                boxW = 0.0;
                if (this.xMapper == null || this.xMapper.getNumberValues() <= 1) {
                    v2 = 0.0;
                }
                switch (this.orientation) {
                    case 0: {
                        boxW = (double)this.getScreenSpacing((byte)1, v1, v2) * this.boxWidth;
                        break;
                    }
                    case 1: {
                        boxW = (double)this.getScreenSpacing((byte)2, v1, v2) * this.boxWidth;
                    }
                }
                if (this.xVar != null) break block42;
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 7);
                TukeyBox box = new TukeyBox(this.transformObject);
                switch (this.orientation) {
                    case 0: {
                        box.setBoxCenter(this.getBounds().x + this.getBounds().width / 2);
                        break;
                    }
                    case 1: {
                        box.setBoxCenter(this.getBounds().y + this.getBounds().height / 2);
                    }
                }
                box.x = Double.NaN;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                box.extremeMin = extremeMin;
                box.extremeMax = extremeMax;
                if (!box.isValid()) break block43;
                box.boxWidth = boxW;
                box.extreme = this.extreme;
                box.notched = box.y[6] > 0.0 ? this.notched : false;
                box.fillOn = this.fillOn;
                if (this.fillOn) {
                    box.fillColor = this.fillColor;
                    box.outlineColor = this.outlineColor;
                } else {
                    box.fillColor = this.fillColor;
                    box.outlineColor = this.fillColor;
                }
                box.outlineWidth = this.outlineWidth;
                box.capShape = this.capShape;
                box.medianColor = this.medianColor;
                box.medianShape = this.medianShape;
                box.medianWidth = this.medianWidth;
                box.meanColor = this.meanColor;
                box.meanShape = this.meanShape;
                box.meanWidth = this.meanWidth;
                box.markerOn = false;
                box.markerColor = this.markerColor;
                box.markerShape = this.markerShape;
                box.markerWidth = this.markerWidth;
                box.whiskerColor = this.whiskerColor;
                box.whiskerWidth = this.whiskerWidth;
                box.capColor = this.whiskerColor;
                box.capWidth = this.whiskerWidth;
                box.orientation = this.orientation;
                box.draw((Graphics2D)g);
                if (this.extreme || !this.markerOn || (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, null, false)) == null) break block43;
                switch (this.orientation) {
                    case 0: {
                        int screenX = this.getBounds().x + this.getBounds().width / 2;
                        for (int o = 0; o < outliers.length; ++o) {
                            this.transformObject.project(0.0, outliers[o], 0.0, this.projectValues);
                            Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)screenX, (int)((int)this.projectValues[1]), (boolean)false, (int)0, (int)1);
                        }
                        break block43;
                    }
                    case 1: {
                        int screenY = this.getBounds().y + this.getBounds().height / 2;
                        for (int o = 0; o < outliers.length; ++o) {
                            this.transformObject.project(outliers[o], 0.0, 0.0, this.projectValues);
                            Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)this.projectValues[0]), (int)screenY, (boolean)false, (int)0, (int)1);
                        }
                        break;
                    }
                }
                break block43;
            }
            for (i = 0; i < this.tuples.size(); ++i) {
                int x = this.xMapper.getIndex(((Object[])this.tuples.get(i))[0]);
                IndexList.add(x);
            }
            Collections.sort(IndexList);
            for (i = 0; i < this.tuples.size(); ++i) {
                double y;
                double[] outliers;
                double x = this.xMapper.getIndex(((Object[])this.tuples.get(i))[0]);
                if (x < 0.0) continue;
                Object[] summaryVarValues = (Object[])this.tuples.get(i);
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 7);
                TukeyBox box = new TukeyBox(this.transformObject);
                box.x = x;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                box.extremeMin = extremeMin;
                box.extremeMax = extremeMax;
                if (!box.isValid()) continue;
                box.boxWidth = boxW;
                box.extreme = this.extreme;
                box.notched = box.y[6] > 0.0 ? this.notched : false;
                box.fillOn = this.fillOn;
                if (this.fillOn) {
                    box.fillColor = this.fillColor;
                    box.outlineColor = this.outlineColor;
                } else {
                    box.fillColor = this.fillColor;
                    box.outlineColor = this.fillColor;
                }
                box.outlineWidth = this.outlineWidth;
                box.capShape = this.capShape;
                box.medianColor = this.medianColor;
                box.medianShape = this.medianShape;
                box.medianWidth = this.medianWidth;
                box.meanColor = this.meanColor;
                box.meanShape = this.meanShape;
                box.meanWidth = this.meanWidth;
                box.markerOn = false;
                box.markerColor = this.markerColor;
                box.markerShape = this.markerShape;
                box.markerWidth = this.markerWidth;
                box.whiskerColor = this.whiskerColor;
                box.whiskerWidth = this.whiskerWidth;
                box.capColor = this.whiskerColor;
                box.capWidth = this.whiskerWidth;
                box.orientation = this.orientation;
                box.draw((Graphics2D)g);
                if (!this.extreme && this.markerOn && (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, summaryVarValues, false)) != null) {
                    for (int o = 0; o < outliers.length; ++o) {
                        switch (this.orientation) {
                            case 0: {
                                this.transformObject.project(x, outliers[o], 0.0, this.projectValues);
                                break;
                            }
                            case 1: {
                                this.transformObject.project(outliers[o], x, 0.0, this.projectValues);
                            }
                        }
                        Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)this.projectValues[0]), (int)((int)this.projectValues[1]), (boolean)false, (int)0, (int)1);
                    }
                }
                if (this.connectBy == 0) continue;
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                Color oldColor = g.getColor();
                ((Graphics2D)g).setStroke(new BasicStroke(this.lineWidth));
                g.setColor(this.lineColor);
                switch (this.connectBy) {
                    case 1: {
                        y = extremeMin;
                        break;
                    }
                    case 2: {
                        y = q1;
                        break;
                    }
                    case 3: {
                        y = median;
                        break;
                    }
                    case 4: {
                        y = q3;
                        break;
                    }
                    case 5: {
                        y = box.extremeMax;
                        break;
                    }
                    case 6: {
                        y = mean;
                        break;
                    }
                    default: {
                        y = Double.NaN;
                    }
                }
                if (Double.isNaN(y)) continue;
                connectMap.put(x, y);
            }
            if (this.connectBy != 0) {
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                Color oldColor = g.getColor();
                for (int j = 0; j < IndexList.size(); ++j) {
                    double xIndex = ((Integer)IndexList.get(j)).intValue();
                    if (!connectMap.containsKey(xIndex)) continue;
                    double y = (Double)connectMap.get(xIndex);
                    if (1 == this.orientation) {
                        double t = y;
                        y = xIndex;
                        xIndex = t;
                    }
                    if (Double.isNaN(scr1[0])) {
                        this.transformObject.project(xIndex, y, 0.0, scr1);
                    } else {
                        this.transformObject.project(xIndex, y, 0.0, scr2);
                        g.drawLine((int)scr1[0], (int)scr1[1], (int)scr2[0], (int)scr2[1]);
                        scr1[0] = scr2[0];
                        scr1[1] = scr2[1];
                    }
                    ((Graphics2D)g).setStroke(oldStroke);
                    g.setColor(oldColor);
                }
            }
        }
    }

    private void setStyle() {
        DataStyleElement dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleBackground, null).getAsDataStyle();
        this.fillColor = dse.getFillColor();
        this.outlineColor = dse.getLineColor();
        this.outlineWidth = dse.getLineThickness().getSizeValue();
        this.lineColor = this.outlineColor;
        this.lineWidth = this.outlineWidth;
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMedian, null).getAsDataStyle();
        this.medianColor = dse.getLineColor();
        this.medianWidth = dse.getLineThickness().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleMean, null).getAsDataStyle();
        this.meanColor = dse.getAsMarkerStyle().getMarkerColor();
        this.meanShape = dse.getMarkerSymbol();
        this.meanWidth = dse.getMarkerSize().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleOutliers, null).getAsDataStyle();
        this.markerColor = dse.getAsMarkerStyle().getMarkerColor();
        this.markerShape = dse.getMarkerSymbol();
        this.markerWidth = dse.getMarkerSize().getSizeValue();
        dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleWhiskers, null).getAsDataStyle();
        this.whiskerColor = dse.getLineColor();
        this.whiskerWidth = dse.getLineThickness().getSizeValue();
        this.capColor = this.whiskerColor;
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        if (this.yVar == null) {
            return;
        }
        this.setStyle();
        DataStyleElement dse = SILKUtilities.getStyleElement("", -1, 2, this.style, this.styleSelection, null).getAsDataStyle();
        int outlineWidthSelection = dse.getLineThickness().getSizeValue();
        double v1 = 0.0;
        double v2 = 1.0;
        if (this.xMapper == null || this.xMapper.getNumberValues() <= 1) {
            v2 = 0.0;
        }
        double boxW = 0.0;
        switch (this.orientation) {
            case 0: {
                boxW = (double)this.getScreenSpacing((byte)1, v1, v2) * this.boxWidth;
                break;
            }
            case 1: {
                boxW = (double)this.getScreenSpacing((byte)2, v1, v2) * this.boxWidth;
            }
        }
        int yVarIndex = this.filter.getVariableIndex(this.yVar);
        if (this.xVar == null) {
            boolean boxSelectedAndDrawn = false;
            while (this.selections.hasMoreSelections()) {
                double[] outliers;
                int index = this.selections.nextSelectedIndex();
                double yValue = this.filter.getNumericValue(yVarIndex, (long)index);
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 13);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 14);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 15);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 16);
                if (!this.extreme && this.markerOn && (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, null, false)) != null) {
                    int o;
                    block4 : switch (this.orientation) {
                        case 0: {
                            for (o = 0; o < outliers.length; ++o) {
                                if (yValue != outliers[o]) continue;
                                this.transformObject.project(0.0, outliers[o], 0.0, this.projectValues);
                                if (!(yValue < min) && !(yValue > max)) continue;
                                Markers.draw((Graphics)g, (Color)this.outlineColor, (Color)this.outlineColor, (int)this.markerShape, (int)outlineWidthSelection, (int)(this.getBounds().x + this.getBounds().width / 2), (int)((int)this.projectValues[1]), (boolean)false, (int)-1, (int)3);
                                break block4;
                            }
                            break;
                        }
                        case 1: {
                            while (o < outliers.length) {
                                if (yValue == outliers[o]) {
                                    this.transformObject.project(outliers[o], 0.0, 0.0, this.projectValues);
                                    if (yValue < min || yValue > max) {
                                        Markers.draw((Graphics)g, (Color)this.outlineColor, (Color)this.outlineColor, (int)this.markerShape, (int)outlineWidthSelection, (int)((int)this.projectValues[0]), (int)(this.getBounds().y + this.getBounds().height / 2), (boolean)false, (int)-1, (int)3);
                                        break block4;
                                    }
                                }
                                ++o;
                            }
                            break;
                        }
                    }
                    if (o != outliers.length) continue;
                }
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 3);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 7);
                TukeyBox box = new TukeyBox(this.transformObject);
                switch (this.orientation) {
                    case 0: {
                        box.setBoxCenter(this.getBounds().x + this.getBounds().width / 2);
                        break;
                    }
                    case 1: {
                        box.setBoxCenter(this.getBounds().y + this.getBounds().height / 2);
                    }
                }
                box.x = Double.NaN;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                box.extremeMin = extremeMin;
                box.extremeMax = extremeMax;
                if (!box.isValid() || boxSelectedAndDrawn || !(yValue >= q1) || !(yValue <= q3)) continue;
                box.boxWidth = boxW;
                box.extreme = this.extreme;
                box.notched = box.y[6] > 0.0 ? this.notched : false;
                box.fillOn = this.fillOn;
                box.fillColor = this.fillColor;
                box.outlineColor = this.outlineColor;
                box.outlineWidth = outlineWidthSelection;
                box.capShape = this.capShape;
                box.medianColor = this.medianColor;
                box.medianShape = this.medianShape;
                box.medianWidth = this.medianWidth;
                box.meanColor = this.meanColor;
                box.meanShape = this.meanShape;
                box.meanWidth = this.meanWidth;
                box.markerOn = false;
                box.markerColor = this.markerColor;
                box.markerShape = this.markerShape;
                box.markerWidth = this.markerWidth;
                box.whiskerColor = this.whiskerColor;
                box.whiskerWidth = this.whiskerWidth;
                box.capColor = this.whiskerColor;
                box.capWidth = this.whiskerWidth;
                box.orientation = this.orientation;
                box.draw((Graphics2D)g);
                boxSelectedAndDrawn = true;
            }
        } else {
            ArrayList<String> selectedTuples = new ArrayList<String>();
            while (this.selections.hasMoreSelections()) {
                double[] outliers;
                int index = this.selections.nextSelectedIndex();
                String tuple = this.filter.getFormattedValue(this.xVar, (long)index, null);
                String str = tuple.toString();
                double yValue = this.filter.getNumericValue(yVarIndex, (long)index);
                double x = this.xMapper.getIndex(str);
                Object[] summaryVarValues = new String[]{str};
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 13);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 14);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 15);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 16);
                if (!this.extreme && this.markerOn && (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, summaryVarValues, false)) != null) {
                    int o;
                    for (o = 0; o < outliers.length; ++o) {
                        if (yValue != outliers[o]) continue;
                        double y = outliers[o];
                        if (1 == this.orientation) {
                            double t = x;
                            x = y;
                            y = t;
                        }
                        this.transformObject.project(x, y, 0.0, this.projectValues);
                        if (!(yValue < min) && !(yValue > max)) continue;
                        Markers.draw((Graphics)g, (Color)this.outlineColor, (Color)this.outlineColor, (int)this.markerShape, (int)outlineWidthSelection, (int)((int)this.projectValues[0]), (int)((int)this.projectValues[1]), (boolean)false, (int)-1, (int)3);
                        break;
                    }
                    if (o != outliers.length) continue;
                }
                if (selectedTuples.contains(tuple)) continue;
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 3);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 7);
                TukeyBox box = new TukeyBox(this.transformObject);
                box.x = x;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                box.extremeMin = extremeMin;
                box.extremeMax = extremeMax;
                if (!box.isValid() || !(yValue >= q1) || !(yValue <= q3)) continue;
                box.boxWidth = boxW;
                box.extreme = this.extreme;
                box.notched = box.y[6] > 0.0 ? this.notched : false;
                box.fillOn = this.fillOn;
                box.fillColor = this.fillColor;
                box.outlineColor = this.outlineColor;
                box.outlineWidth = outlineWidthSelection;
                box.capShape = this.capShape;
                box.medianColor = this.medianColor;
                box.medianShape = this.medianShape;
                box.medianWidth = this.medianWidth;
                box.meanColor = this.meanColor;
                box.meanShape = this.meanShape;
                box.meanWidth = this.meanWidth;
                box.markerOn = false;
                box.markerColor = this.markerColor;
                box.markerShape = this.markerShape;
                box.markerWidth = this.markerWidth;
                box.whiskerColor = this.whiskerColor;
                box.whiskerWidth = this.whiskerWidth;
                box.capColor = this.whiskerColor;
                box.capWidth = this.whiskerWidth;
                box.orientation = this.orientation;
                box.draw((Graphics2D)g);
                selectedTuples.add(tuple);
            }
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        boolean result;
        block76: {
            TukeyBox box;
            Rectangle2D.Double boundingBox;
            Rectangle2D.Double pickRect;
            double[] bottomRight;
            double[] topLeft;
            block75: {
                result = true;
                if (this.xVar != null && this.tuples == null) {
                    return false;
                }
                Rectangle selectArea = null;
                if (!(selectRegion instanceof Rectangle)) {
                    return false;
                }
                selectArea = (Rectangle)selectRegion;
                topLeft = new double[3];
                bottomRight = new double[3];
                pickRect = new Rectangle2D.Double();
                topLeft = this.transformObject.unProject(selectArea.getMinX(), selectArea.getMinY(), 0.0, topLeft);
                bottomRight = this.transformObject.unProject(selectArea.getMaxX(), selectArea.getMaxY(), 0.0, bottomRight);
                pickRect.setFrameFromDiagonal(selectArea.x, selectArea.y, selectArea.width + selectArea.x, selectArea.height + selectArea.y);
                if (this.orientation == 1) {
                    double t = topLeft[0];
                    topLeft[0] = topLeft[1];
                    topLeft[1] = t;
                    t = bottomRight[0];
                    bottomRight[0] = bottomRight[1];
                    bottomRight[1] = t;
                }
                boundingBox = new Rectangle2D.Double();
                box = new TukeyBox(this.transformObject);
                if (this.xVar != null) break block75;
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 7);
                box.x = Double.NaN;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                if (!box.isValid()) break block76;
                double v1 = 0.0;
                double v2 = 0.0;
                double boxW = 0.0;
                double[] scr = new double[3];
                switch (this.orientation) {
                    case 0: {
                        boxW = (double)this.getScreenSpacing((byte)1, v1, v2) * this.boxWidth;
                        break;
                    }
                    case 1: {
                        boxW = (double)this.getScreenSpacing((byte)2, v1, v2) * this.boxWidth;
                    }
                }
                switch (this.orientation) {
                    case 0: {
                        this.transformObject.project(0.0, box.y[1], 0.0, scr);
                        q1 = scr[1];
                        this.transformObject.project(0.0, box.y[3], 0.0, scr);
                        q3 = scr[1];
                        break;
                    }
                    case 1: {
                        this.transformObject.project(box.y[1], 0.0, 0.0, scr);
                        q1 = scr[0];
                        this.transformObject.project(box.y[3], 0.0, 0.0, scr);
                        q3 = scr[0];
                    }
                }
                double x = 0.0;
                switch (this.orientation) {
                    case 0: {
                        x = this.getBounds().x + this.getBounds().width / 2;
                        break;
                    }
                    case 1: {
                        x = this.getBounds().y + this.getBounds().height / 2;
                    }
                }
                double minX = x - boxW * 0.5;
                double maxX = x + boxW * 0.5;
                double temp = Math.min(minX, maxX);
                double temp2 = Math.max(minX, maxX);
                minX = temp;
                maxX = temp2;
                temp = Math.min(q1, q3);
                q1 = temp2 = Math.max(q1, q3);
                q3 = temp;
                if (this.orientation == 0) {
                    boundingBox.x = minX;
                    boundingBox.y = q3;
                    boundingBox.width = maxX - minX;
                    boundingBox.height = q1 - q3;
                } else if (this.orientation == 1) {
                    boundingBox.y = minX;
                    boundingBox.x = q3;
                    boundingBox.height = maxX - minX;
                    boundingBox.width = q1 - q3;
                }
                double[] outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, null, false);
                boolean outliersAlreadySelected = false;
                if (this.extreme) {
                    min = Double.isNaN(extremeMin) ? box.y[0] : extremeMin;
                    double d = max = Double.isNaN(extremeMax) ? box.y[4] : extremeMax;
                }
                if (boundingBox.intersects(pickRect) || boundingBox.contains(pickRect)) {
                    DataRange[] ranges = new DataRange[1];
                    double yMin = min;
                    double yMax = max;
                    if (!this.extreme && this.markerOn && outliers != null) {
                        block32: for (int o = 0; o < outliers.length; ++o) {
                            switch (this.orientation) {
                                case 0: {
                                    this.transformObject.project(0.0, outliers[o], 0.0, scr);
                                    if (!pickRect.contains(x, scr[1])) continue block32;
                                    yMin = Math.min(bottomRight[1], yMin);
                                    yMax = Math.max(topLeft[1], yMax);
                                    outliersAlreadySelected = true;
                                    continue block32;
                                }
                                case 1: {
                                    this.transformObject.project(outliers[o], 0.0, 0.0, scr);
                                    if (!pickRect.contains(scr[0], x)) continue block32;
                                    yMin = Math.min(bottomRight[1], yMin);
                                    yMax = Math.max(topLeft[1], yMax);
                                    outliersAlreadySelected = true;
                                }
                            }
                        }
                    }
                    ranges[0] = new ContinuousRange(yMin, yMax);
                    String[] vars = new String[]{this.yVar.toString()};
                    if (this.filter != null) {
                        if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                            ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                        } else {
                            this.filter.setSelected(vars, ranges, select);
                        }
                    }
                    return true;
                }
                if (outliersAlreadySelected) {
                    outliersAlreadySelected = false;
                    return true;
                }
                if (this.extreme || !this.markerOn) {
                    return true;
                }
                if (outliers == null) {
                    return true;
                }
                block33: for (int o = 0; o < outliers.length; ++o) {
                    switch (this.orientation) {
                        case 0: {
                            this.transformObject.project(0.0, outliers[o], 0.0, scr);
                            if (!pickRect.contains(x, scr[1])) continue block33;
                            DataRange[] ranges = new DataRange[]{new ContinuousRange(bottomRight[1], topLeft[1])};
                            String[] vars = new String[]{this.yVar.toString()};
                            if (this.filter != null) {
                                if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                                    ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                                } else {
                                    this.filter.setSelected(vars, ranges, select);
                                }
                            }
                            return true;
                        }
                        case 1: {
                            this.transformObject.project(outliers[o], 0.0, 0.0, scr);
                            if (!pickRect.contains(scr[0], x)) continue block33;
                            DataRange[] ranges = new DataRange[]{new ContinuousRange(Math.min(bottomRight[1], topLeft[1]), Math.max(bottomRight[1], topLeft[1]))};
                            String[] vars = new String[]{this.yVar.toString()};
                            if (this.filter != null) {
                                if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                                    ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                                } else {
                                    this.filter.setSelected(vars, ranges, select);
                                }
                            }
                            return true;
                        }
                    }
                }
                break block76;
            }
            for (int i = 0; i < this.tuples.size(); ++i) {
                double x = this.xMapper.getIndex(((Object[])this.tuples.get(i))[0]);
                Object[] summaryVarValues = (Object[])this.tuples.get(i);
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 7);
                box.x = x;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                if (!box.isValid()) continue;
                double[] scr = new double[3];
                double v1 = 0.0;
                double v2 = 1.0;
                double boxW = 0.0;
                if (this.xMapper == null || this.xMapper.getNumberValues() <= 1) {
                    v2 = 0.0;
                }
                switch (this.orientation) {
                    case 0: {
                        boxW = (double)this.getScreenSpacing((byte)1, v1, v2) * this.boxWidth;
                        break;
                    }
                    case 1: {
                        boxW = (double)this.getScreenSpacing((byte)2, v1, v2) * this.boxWidth;
                    }
                }
                if (this.orientation == 0) {
                    this.transformObject.project(x, 0.0, 0.0, scr);
                    x = scr[0];
                    this.transformObject.project(0.0, box.y[1], 0.0, scr);
                    q1 = scr[1];
                    this.transformObject.project(0.0, box.y[3], 0.0, scr);
                    q3 = scr[1];
                } else if (this.orientation == 1) {
                    this.transformObject.project(0.0, x, 0.0, scr);
                    x = scr[1];
                    this.transformObject.project(box.y[1], 0.0, 0.0, scr);
                    q1 = scr[0];
                    this.transformObject.project(box.y[3], 0.0, 0.0, scr);
                    q3 = scr[0];
                }
                double minX = x - boxW * 0.5;
                double maxX = x + boxW * 0.5;
                double temp = Math.min(minX, maxX);
                double temp2 = Math.max(minX, maxX);
                minX = temp;
                maxX = temp2;
                temp = Math.min(q1, q3);
                q1 = temp2 = Math.max(q1, q3);
                q3 = temp;
                if (this.orientation == 0) {
                    boundingBox.x = minX;
                    boundingBox.y = q3;
                    boundingBox.width = maxX - minX;
                    boundingBox.height = q1 - q3;
                } else if (this.orientation == 1) {
                    boundingBox.y = minX;
                    boundingBox.x = q3;
                    boundingBox.height = maxX - minX;
                    boundingBox.width = q1 - q3;
                }
                double[] outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, summaryVarValues, false);
                boolean outliersAlreadySelected = false;
                if (this.extreme) {
                    min = Double.isNaN(extremeMin) ? box.y[0] : extremeMin;
                    double d = max = Double.isNaN(extremeMax) ? box.y[4] : extremeMax;
                }
                if (boundingBox.intersects(pickRect) || boundingBox.contains(pickRect)) {
                    DataRange[] ranges = new DataRange[2];
                    ranges[0] = new DiscreteRange((Object[])this.tuples.get(i));
                    double yMin = min;
                    double yMax = max;
                    if (!this.extreme && this.markerOn && outliers != null) {
                        for (int o = 0; o < outliers.length; ++o) {
                            boolean containsPoint = false;
                            switch (this.orientation) {
                                case 0: {
                                    this.transformObject.project(x, outliers[o], 0.0, scr);
                                    containsPoint = pickRect.contains(scr[0], scr[1]);
                                    break;
                                }
                                case 1: {
                                    this.transformObject.project(outliers[o], x, 0.0, scr);
                                    containsPoint = pickRect.contains(scr[0], scr[1]);
                                }
                            }
                            if (!containsPoint) continue;
                            yMin = Math.min(bottomRight[1], yMin);
                            yMax = Math.max(topLeft[1], yMax);
                            outliersAlreadySelected = true;
                            break;
                        }
                    }
                    ranges[1] = new ContinuousRange(yMin, yMax);
                    String[] vars = new String[]{this.xVar.toString(), this.yVar.toString()};
                    if (this.filter != null) {
                        if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                            ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                        } else {
                            this.filter.setSelected(vars, ranges, select);
                        }
                    }
                    result = true;
                    continue;
                }
                if (outliersAlreadySelected) {
                    outliersAlreadySelected = false;
                    continue;
                }
                if (this.extreme || !this.markerOn || outliers == null) continue;
                for (int o = 0; o < outliers.length; ++o) {
                    boolean containsPoint = false;
                    switch (this.orientation) {
                        case 0: {
                            this.transformObject.project(x, outliers[o], 0.0, scr);
                            containsPoint = pickRect.contains(x, scr[1]);
                            break;
                        }
                        case 1: {
                            this.transformObject.project(outliers[o], x, 0.0, scr);
                            containsPoint = pickRect.contains(scr[0], x);
                        }
                    }
                    if (!containsPoint) continue;
                    DataRange[] ranges = new DataRange[]{new DiscreteRange((Object[])this.tuples.get(i)), new ContinuousRange(Math.min(bottomRight[1], topLeft[1]), Math.max(bottomRight[1], topLeft[1]))};
                    String[] vars = new String[]{this.xVar.toString(), this.yVar.toString()};
                    if (this.filter != null) {
                        if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                            ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                        } else {
                            this.filter.setSelected(vars, ranges, select);
                        }
                    }
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        byte classificationDim = 1;
        switch (this.orientation) {
            case 0: {
                classificationDim = 1;
                break;
            }
            case 1: {
                classificationDim = 2;
            }
        }
        if (dim == classificationDim && range instanceof DiscreteRange) {
            DiscreteRange dr = (DiscreteRange)range;
            Vector values = dr.getValues();
            int size = values.size();
            this.xMapper.removeAllValues();
            for (int catIndex = 0; catIndex < size; ++catIndex) {
                this.xMapper.addValue(values.elementAt(catIndex));
            }
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.xVar = this.roles.getVariable((Object)this.xRole, 0);
                if (this.filter == null) break;
                if (this.xMapper == null) {
                    this.xMapper = new CharacterVariableMapper(this.filter, this.xVar);
                    break;
                }
                this.xMapper.setVariable(this.xVar);
                break;
            }
            case 25: {
                this.yVar = this.roles.getVariable((Object)this.yRole, 0);
                break;
            }
            case 6: {
                this.groupVar = this.roles.getVariable((Object)this.groupRole, 0);
                if (this.filter == null) break;
                if (this.groupMapper == null) {
                    this.groupMapper = new CharacterVariableMapper(this.filter, this.groupVar);
                    break;
                }
                this.groupMapper.setVariable(this.groupVar);
            }
        }
        this.computeBoxData();
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 25: {
                this.yVar = null;
                break;
            }
            case 24: {
                this.xVar = null;
                if (this.xMapper != null) {
                    this.xMapper.dispose();
                }
                this.xMapper = null;
            }
        }
        this.tuples = null;
        this.computeBoxData();
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        block38: {
            Object format;
            TukeyBox box;
            Rectangle2D.Double boundingBox;
            Rectangle2D.Double pickRect;
            double[] pv;
            block37: {
                double[] outliers;
                if (this.xVar != null && this.tuples == null) {
                    return null;
                }
                if (this.yVar == null) {
                    return null;
                }
                pv = new double[3];
                pv = this.transformObject.unProject(screenX, screenY, 0.0, pv);
                double[] pv1 = new double[3];
                pv1 = this.transformObject.unProject((int)((double)screenX - (double)this.markerWidth * 0.5), (int)((double)screenY - (double)this.markerWidth * 0.5), 0.0, pv1);
                double[] pv2 = new double[3];
                pv2 = this.transformObject.unProject((int)((double)screenX + (double)this.markerWidth * 0.5), (int)((double)screenY + (double)this.markerWidth * 0.5), 0.0, pv2);
                pickRect = new Rectangle2D.Double(pv1[0], pv2[1], pv2[0] - pv1[0], pv1[1] - pv2[1]);
                if (this.orientation == 1) {
                    double t = pv[0];
                    pv[0] = pv[1];
                    pv[1] = t;
                    t = pv1[0];
                    pv1[0] = pv1[1];
                    pv1[1] = t;
                    t = pv2[0];
                    pv2[0] = pv2[1];
                    pv2[1] = t;
                }
                boundingBox = new Rectangle2D.Double();
                box = new TukeyBox(this.transformObject);
                format = this.filter.getFormat(this.yVar, SASFormat.class);
                if (this.xVar != null) break block37;
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, null, 7);
                box.x = Double.NaN;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                if (!box.isValid()) break block38;
                double v1 = 0.0;
                double v2 = 1.0;
                double boxW = 0.0;
                if (this.xMapper == null || this.xMapper.getNumberValues() <= 1) {
                    v2 = 0.0;
                }
                switch (this.orientation) {
                    case 0: {
                        boxW = (double)this.getScreenSpacing((byte)1, v1, v2) * this.boxWidth;
                        boundingBox.x = (double)(this.getBounds().x + this.getBounds().width / 2) - boxW / 2.0;
                        boundingBox.y = q1;
                        boundingBox.width = boxW;
                        boundingBox.height = q3 - q1;
                        break;
                    }
                    case 1: {
                        boxW = (double)this.getScreenSpacing((byte)2, v1, v2) * this.boxWidth;
                        boundingBox.x = q1;
                        boundingBox.y = (double)(this.getBounds().y + this.getBounds().height / 2) - boxW / 2.0;
                        boundingBox.width = q3 - q1;
                        boundingBox.height = boxW;
                    }
                }
                boolean containsPoint = false;
                switch (this.orientation) {
                    case 0: {
                        containsPoint = boundingBox.contains(screenX, pv[1]);
                        break;
                    }
                    case 1: {
                        containsPoint = boundingBox.contains(pv[1], screenY);
                    }
                }
                if (containsPoint) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MinimumWhisker.txt", (String)"Minimum Whisker"));
                    sb.append(" \t= \t ");
                    if (this.extreme) {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(extremeMin), format));
                    } else {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(min), format));
                    }
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.FirstQuartile.txt", (String)"First Quartile"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(q1), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Median.txt", (String)"Median"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(median), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.ThirdQuartile.txt", (String)"Third Quartile"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(q3), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MaximumWhisker.txt", (String)"Maximum Whisker"));
                    sb.append(" \t= \t ");
                    if (this.extreme) {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(extremeMax), format));
                    } else {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(max), format));
                    }
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Mean.txt", (String)"Mean"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(mean), format));
                    return sb.toString();
                }
                if (this.extreme || !this.markerOn || (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, null, false)) == null) break block38;
                switch (this.orientation) {
                    case 0: {
                        pickRect.x = (double)(this.getBounds().x + this.getBounds().width / 2) - (double)this.markerWidth * 0.5;
                        pickRect.width = this.markerWidth;
                        break;
                    }
                    case 1: {
                        pickRect.y = (double)(this.getBounds().y + this.getBounds().height / 2) - (double)this.markerWidth * 0.5;
                        pickRect.height = this.markerWidth;
                    }
                }
                for (int o = 0; o < outliers.length; ++o) {
                    containsPoint = false;
                    switch (this.orientation) {
                        case 0: {
                            containsPoint = pickRect.contains(screenX, outliers[o]);
                            break;
                        }
                        case 1: {
                            containsPoint = pickRect.contains(outliers[o], screenY);
                        }
                    }
                    if (!containsPoint) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.filter.getVariableDescription(this.yVar));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(outliers[o]), format));
                    return sb.toString();
                }
                break block38;
            }
            for (int i = 0; i < this.tuples.size(); ++i) {
                double[] outliers;
                double x = this.xMapper.getIndex(((Object[])this.tuples.get(i))[0]);
                Object[] summaryVarValues = (Object[])this.tuples.get(i);
                double min = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 13);
                double q1 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 15);
                double median = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 3);
                double q3 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 16);
                double max = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 14);
                double mean = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 2);
                double n = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 12);
                double std = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 5);
                double extremeMin = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 6);
                double extremeMax = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.yVar, summaryVarValues, 7);
                box.x = x;
                box.y = new double[]{min, q1, median, q3, max, mean, n, std};
                if (!box.isValid()) continue;
                boundingBox.x = x - 0.5 * this.boxWidth;
                boundingBox.y = q1;
                boundingBox.width = this.boxWidth;
                boundingBox.height = q3 - q1;
                if (boundingBox.contains(pv[0], pv[1])) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.filter.getVariableDescription(this.xVar));
                    sb.append(" \t= \t ");
                    sb.append(((Object[])this.tuples.get(i))[0]);
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MinimumWhisker.txt", (String)"Minimum Whisker"));
                    sb.append(" \t= \t ");
                    if (this.extreme) {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(extremeMin), format));
                    } else {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(min), format));
                    }
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.FirstQuartile.txt", (String)"First Quartile"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(q1), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Median.txt", (String)"Median"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(median), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.ThirdQuartile.txt", (String)"Third Quartile"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(q3), format));
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.MaximumWhisker.txt", (String)"Maximum Whisker"));
                    sb.append(" \t= \t ");
                    if (this.extreme) {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(extremeMax), format));
                    } else {
                        sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(max), format));
                    }
                    sb.append("\n");
                    sb.append(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotChart.Mean.txt", (String)"Mean"));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(mean), format));
                    return sb.toString();
                }
                if (this.extreme || !this.markerOn || (outliers = this.defaultStatistics.getSummaryOutliers(this.summaryVars, this.yVar, summaryVarValues, false)) == null) continue;
                for (int o = 0; o < outliers.length; ++o) {
                    boolean containsPoint = false;
                    switch (this.orientation) {
                        case 0: {
                            containsPoint = pickRect.contains(x, outliers[0]);
                            break;
                        }
                        case 1: {
                            containsPoint = pickRect.contains(outliers[0], x);
                        }
                    }
                    if (!containsPoint) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.filter.getVariableDescription(this.xVar));
                    sb.append(" \t= \t ");
                    sb.append(((Object[])this.tuples.get(i))[0]);
                    sb.append("\n");
                    sb.append(this.filter.getVariableDescription(this.yVar));
                    sb.append(" \t= \t ");
                    sb.append(this.filter.getFormattedValue(this.yVar, (Object)new Double(outliers[o]), format));
                    return sb.toString();
                }
            }
        }
        return null;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            default: {
                rc = super.getPropertyValue(id);
                break;
            }
            case 19054: {
                if (this.getOrientation() == 0) {
                    Object var = this.roles.getVariable(RoleInterface.ROLE_Y, 0);
                    if (var == null || this.filter == null) break;
                    rc = this.filter.getFormat(var, SASFormat.class);
                    break;
                }
                Object var = this.roles.getVariable(RoleInterface.ROLE_X, 0);
                if (var == null || this.filter == null) break;
                rc = this.filter.getFormat(var, SASFormat.class);
                break;
            }
            case 19055: {
                if (this.getOrientation() == 1) {
                    Object var = this.roles.getVariable(RoleInterface.ROLE_Y, 0);
                    if (var == null || this.filter == null) break;
                    rc = this.filter.getFormat(var, SASFormat.class);
                    break;
                }
                Object var = this.roles.getVariable(RoleInterface.ROLE_X, 0);
                if (var == null || this.filter == null) break;
                rc = this.filter.getFormat(var, SASFormat.class);
                break;
            }
            case 19053: {
                if (this.filter == null) {
                    return null;
                }
                switch (this.orientation) {
                    case 0: {
                        rc = this.xVar == null ? null : this.filter.getVariableDescription(this.xVar);
                        break;
                    }
                    case 1: {
                        rc = this.filter.getVariableDescription(this.yVar);
                    }
                }
                break;
            }
            case 19052: {
                if (this.filter == null) {
                    return null;
                }
                switch (this.orientation) {
                    case 0: {
                        rc = this.filter.getVariableDescription(this.yVar);
                        break;
                    }
                    case 1: {
                        rc = this.xVar == null ? null : this.filter.getVariableDescription(this.xVar);
                    }
                }
                break;
            }
            case 801: {
                return new Boolean(this.isExtreme());
            }
            case 802: {
                return new Boolean(this.isNotched());
            }
            case 803: {
                return new Boolean(this.isFillOn());
            }
            case 804: {
                return this.getFillColor();
            }
            case 806: {
                return this.getOutlineColor();
            }
            case 807: {
                return new Integer(this.getOutlineWidth());
            }
            case 808: {
                return this.capShapeStr[this.getCapShape()];
            }
            case 809: {
                return this.getMedianColor();
            }
            case 810: {
                return new Integer(this.getMeanShape());
            }
            case 811: {
                return new Integer(this.getMedianSize());
            }
            case 812: {
                return this.getMeanColor();
            }
            case 813: {
                return new Integer(this.getMeanShape());
            }
            case 814: {
                return new Integer(this.getMeanSize());
            }
            case 815: {
                return new Boolean(this.isMarkersOn());
            }
            case 816: {
                return this.getMarkerColor();
            }
            case 817: {
                return new Integer(this.getMarkerShape());
            }
            case 818: {
                return new Integer(this.getMarkerSize());
            }
            case 819: {
                return this.getWhiskerColor();
            }
            case 820: {
                return new Integer(this.getWhiskerWidth());
            }
            case 821: {
                if (this.getConnectBy() == 0) {
                    return new Integer(this.getConnectBy());
                }
                return this.connectByStr[this.getConnectBy() - 1];
            }
            case 822: {
                return this.getLineColor();
            }
            case 823: {
                return new Integer(this.getLineWidth());
            }
            case 805: {
                return new Double(this.getBoxWidth());
            }
            case 824: {
                return new Integer(1);
            }
            case 826: {
                return new Boolean(this.groupVar != null);
            }
            case 825: {
                return new Integer(this.getOrientation());
            }
            case 19004: {
                return this.styleBackground;
            }
            case 19005: {
                return this.styleMedian;
            }
            case 19006: {
                return this.styleMean;
            }
            case 19007: {
                return this.styleOutliers;
            }
            case 19008: {
                return this.styleWhiskers;
            }
            case 19078: {
                if (this.roles.getVariable((Object)this.yRole, 0) != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                if (this.roles.getVariable((Object)this.yRole, 0) == null) {
                    v.addElement(new Integer(3));
                }
                if (v.size() <= 0) break;
                int[] errIds = new int[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    errIds[i] = ((Number)v.elementAt(i)).intValue();
                }
                return errIds;
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 801: {
                if (!(value instanceof Boolean)) break;
                Boolean b = (Boolean)value;
                this.setExtreme(b);
                break;
            }
            case 802: {
                if (!(value instanceof Boolean)) break;
                Boolean b = (Boolean)value;
                this.setNotched(b);
                break;
            }
            case 803: {
                if (!(value instanceof Boolean)) break;
                Boolean b = (Boolean)value;
                this.setFillOn(b);
                break;
            }
            case 804: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setFillColor(c);
                break;
            }
            case 806: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setOutlineColor(c);
                break;
            }
            case 807: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setOutlineWidth(i.intValue());
                break;
            }
            case 808: {
                if (value instanceof Number) {
                    Number i = (Number)value;
                    this.setCapShape(i.intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                for (int i = 0; i < this.capShapeStr.length; ++i) {
                    if (!this.capShapeStr[i].equals(value)) continue;
                    this.setCapShape(this.capShapeStr[i].intValue());
                }
                break;
            }
            case 809: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setMedianColor(c);
                break;
            }
            case 810: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMeanShape(i.intValue());
                break;
            }
            case 811: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMedianSize(i.intValue());
                break;
            }
            case 812: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setMeanColor(c);
                break;
            }
            case 813: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMeanShape(i.intValue());
                break;
            }
            case 814: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMeanSize(i.intValue());
                break;
            }
            case 815: {
                if (!(value instanceof Boolean)) break;
                Boolean b = (Boolean)value;
                this.setMarkersOn(b);
                break;
            }
            case 816: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setMarkerColor(c);
                break;
            }
            case 817: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMarkerShape(i.intValue());
                break;
            }
            case 818: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setMarkerSize(i.intValue());
                break;
            }
            case 819: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setWhiskerColor(c);
                break;
            }
            case 820: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setWhiskerWidth(i.intValue());
                break;
            }
            case 821: {
                if (value instanceof Number) {
                    Number i = (Number)value;
                    this.setConnectBy(i.intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                for (int i = 0; i < this.connectByStr.length; ++i) {
                    if (!this.connectByStr[i].equals(value)) continue;
                    this.setConnectBy(this.connectByStr[i].intValue());
                }
                break;
            }
            case 822: {
                if (!(value instanceof Color)) break;
                Color c = (Color)value;
                this.setLineColor(c);
                break;
            }
            case 823: {
                if (!(value instanceof Number)) break;
                Number i = (Number)value;
                this.setLineWidth(i.intValue());
                break;
            }
            case 805: {
                if (!(value instanceof Double)) break;
                Double d = (Double)value;
                this.setBoxWidth(d);
                break;
            }
            case 824: {
                break;
            }
            case 826: {
                break;
            }
            case 825: {
                if (value instanceof Number) {
                    Number i = (Number)value;
                    this.setOrientation(i.intValue());
                }
                this.lce.setAction(3);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 19004: {
                if (value == null) break;
                this.styleBackground = value.toString();
                this.userSetProperties.set(19004);
                break;
            }
            case 19005: {
                if (value == null) break;
                this.styleMedian = value.toString();
                this.userSetProperties.set(19005);
                break;
            }
            case 19006: {
                if (value == null) break;
                this.styleMean = value.toString();
                this.userSetProperties.set(19006);
                break;
            }
            case 19007: {
                if (value == null) break;
                this.styleOutliers = value.toString();
                this.userSetProperties.set(19007);
                break;
            }
            case 19008: {
                if (value == null) break;
                this.styleWhiskers = value.toString();
                this.userSetProperties.set(19008);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (this.orientation == 0) {
            return super.getPreferredRange(which);
        }
        if (this.filter == null) {
            return null;
        }
        OrdinalRange rc = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            if (this.xRole.equals(role)) {
                role = this.yRole;
            } else if (this.yRole.equals(role)) {
                role = this.xRole;
            }
            Object vars = this.roles.getAllVariables(role);
            DataFilterReadInterface dfri = this.filters.getDataFilter(this.roles.getDataID(role));
            if (dfri == null) {
                dfri = this.filter;
            }
            Enumeration e = Extract.elements((Object)vars);
            while (e.hasMoreElements()) {
                Object var = e.nextElement();
                int varIndex = dfri.getVariableIndex(var);
                if (dfri.isNumericVariable(var) && !this.roles.isDiscrete(role)) {
                    double min = Double.MAX_VALUE;
                    double max = Double.MIN_VALUE;
                    if (dfri instanceof DataFilterInfoInterface) {
                        min = ((Number)((DataFilterInfoInterface)dfri).getMinimumValue(var)).doubleValue();
                        max = ((Number)((DataFilterInfoInterface)dfri).getMaximumValue(var)).doubleValue();
                    } else {
                        for (int i = 0; i < dfri.getNumberObservations(-1); ++i) {
                            double val = dfri.getNumericValue(varIndex, (long)i);
                            if (Double.isNaN(val)) continue;
                            min = Math.min(min, val);
                            max = Math.max(max, val);
                        }
                    }
                    if (rc == null) {
                        rc = new ContinuousRange(min, max);
                    } else if (!(rc instanceof ContinuousRange)) continue;
                    ContinuousRange cr = (ContinuousRange)rc;
                    if (!Double.isNaN(min)) {
                        if (Double.isNaN(cr.getMin())) {
                            cr.setMin(min);
                        } else {
                            cr.setMin(Math.min(cr.getMin(), min));
                        }
                    }
                    if (Double.isNaN(max)) continue;
                    if (Double.isNaN(cr.getMax())) {
                        cr.setMax(max);
                        continue;
                    }
                    cr.setMax(Math.max(cr.getMax(), max));
                    continue;
                }
                if (dfri.isNumericVariable(var) && this.roles.isDiscrete(role)) {
                    RangeInfoModel rangeInfoModel = (RangeInfoModel)dfri.getAdapter(RangeInfoModel.class);
                    if (rangeInfoModel != null) {
                        rc = rangeInfoModel.getOrdinalRange(var, this.isMissingDiscreteIncluded());
                        continue;
                    }
                    LinkedHashMap<String, Object> unformatted = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < dfri.getNumberObservations(-1); ++i) {
                        String f;
                        Object d = dfri.getValue(varIndex, (long)i);
                        if (!this.isMissingDiscreteIncluded() && dfri.isMissing(varIndex, d) || unformatted.containsKey(f = dfri.getFormattedValue(var, (long)i, null))) continue;
                        unformatted.put(f, d);
                    }
                    Object[] fvalues = unformatted.values().toArray();
                    Object[] uvalues = unformatted.keySet().toArray();
                    OrdinalRange or = new OrdinalRange(uvalues, fvalues);
                    rc = RangeMerger.mergeRange((DataRange)rc, (DataRange)or);
                    continue;
                }
                DiscreteRange dr = null;
                Object[] list = null;
                if (dfri.getAdapter(UniqueValueInterface.class) != null) {
                    UniqueValueInterface uvi = (UniqueValueInterface)dfri.getAdapter(UniqueValueInterface.class);
                    list = uvi.getUniqueValues(var, true, Integer.MAX_VALUE, this.isMissingDiscreteIncluded());
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (int i = 0; i < dfri.getNumberObservations(-1); ++i) {
                        String value = dfri.getFormattedValue(var, (long)i, null);
                        if (map.containsKey(value)) continue;
                        map.put(value, value);
                    }
                    list = map.keySet().toArray();
                }
                Object o = this.roles.getSortOrder(role);
                if (o instanceof Number) {
                    list = this.sortList(list, ((Number)o).intValue());
                }
                dr = new DiscreteRange(list);
                if (o instanceof Number) {
                    dr.setSort(((Number)o).intValue());
                }
                rc = RangeMerger.mergeRange((DataRange)rc, (DataRange)dr);
            }
        }
        return rc;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.orientation == 0 && this.xDataRange != null && this.xDataRange instanceof DiscreteRange && this.dataRegion != null) {
            int INTERNAL_MARGIN = 2;
            int halfBoxWidth = (int)((double)this.dataRegion.width / (double)((DiscreteRange)this.xDataRange).getValuesSize() * 0.5);
            int sideMargin = Math.max(this.markerWidth / 2, halfBoxWidth) + INTERNAL_MARGIN;
            this.prefInnerMargin.top = this.prefInnerMargin.bottom = this.markerWidth / 2 + INTERNAL_MARGIN;
            if (sideMargin != this.prefInnerMargin.left) {
                this.prefInnerMargin.left = this.prefInnerMargin.right = sideMargin;
                this.fireLayerListenerChanged(3);
            }
        } else if (this.orientation == 1 && this.yDataRange != null && this.yDataRange instanceof DiscreteRange && this.dataRegion != null) {
            int INTERNAL_MARGIN = 2;
            int halfBoxHeight = (int)((double)this.dataRegion.height / (double)((DiscreteRange)this.yDataRange).getValuesSize() * 0.5);
            int topMargin = Math.max(this.markerWidth / 2, halfBoxHeight) + INTERNAL_MARGIN;
            this.prefInnerMargin.left = this.prefInnerMargin.right = this.markerWidth / 2 + INTERNAL_MARGIN;
            if (topMargin != this.prefInnerMargin.top) {
                this.prefInnerMargin.top = this.prefInnerMargin.bottom = topMargin;
                this.fireLayerListenerChanged(3);
            }
        }
    }

    private void computeBoxData() {
        if (this.filter == null || this.yVar == null) {
            return;
        }
        if (this.defaultStatistics == null) {
            this.defaultStatistics = new DefaultStatistics((Object)this.filter, 2);
        } else {
            this.defaultStatistics.clearAllStatistics();
        }
        this.summaryVars = this.xVar != null ? (this.groupVar != null ? new Object[]{this.xVar, this.groupVar} : new Object[]{this.xVar}) : null;
        this.tuples = this.defaultStatistics.getSummaryVarsTuples(this.summaryVars, this.yVar);
    }

    public boolean isExtreme() {
        return this.extreme;
    }

    public void setExtreme(boolean b) {
        this.extreme = b;
        this.userSetProperties.set(801);
        this.fireLayerListenerChanged(1);
    }

    public boolean isNotched() {
        return this.notched;
    }

    public void setNotched(boolean b) {
        this.notched = b;
        this.userSetProperties.set(802);
        this.fireLayerListenerChanged(1);
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
        this.userSetProperties.set(803);
        this.fireLayerListenerChanged(1);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.fillColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.fillColor = col;
        }
        this.userSetProperties.set(804);
        this.fireLayerListenerChanged(1);
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outlineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outlineColor = col;
        }
        this.userSetProperties.set(806);
        this.fireLayerListenerChanged(1);
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.outlineWidth = w;
        this.userSetProperties.set(807);
        this.fireLayerListenerChanged(1);
    }

    public Color getMedianColor() {
        return this.medianColor;
    }

    public void setMedianColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.medianColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.medianColor = col;
        }
        this.userSetProperties.set(809);
        this.fireLayerListenerChanged(1);
    }

    public int getMedianShape() {
        return this.medianShape;
    }

    public void setMedianShape(int s) {
        this.medianShape = s;
        this.userSetProperties.set(810);
        this.fireLayerListenerChanged(1);
    }

    public int getMedianSize() {
        return this.medianWidth;
    }

    public void setMedianSize(int s) {
        if (s <= 0) {
            return;
        }
        this.medianWidth = s;
        this.userSetProperties.set(811);
        this.fireLayerListenerChanged(1);
    }

    public Color getMeanColor() {
        return this.meanColor;
    }

    public void setMeanColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.meanColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.meanColor = col;
        }
        this.userSetProperties.set(812);
        this.fireLayerListenerChanged(1);
    }

    public int getMeanShape() {
        return this.meanShape;
    }

    public void setMeanShape(int s) {
        this.meanShape = s;
        this.userSetProperties.set(813);
        this.fireLayerListenerChanged(1);
    }

    public int getMeanSize() {
        return this.meanWidth;
    }

    public void setMeanSize(int s) {
        if (s <= 0) {
            return;
        }
        this.meanWidth = s;
        this.userSetProperties.set(814);
        this.fireLayerListenerChanged(1);
    }

    public boolean isMarkersOn() {
        return this.markerOn;
    }

    public void setMarkersOn(boolean b) {
        this.markerOn = b;
        this.userSetProperties.set(815);
        this.fireLayerListenerChanged(1);
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.markerColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.markerColor = col;
        }
        this.userSetProperties.set(816);
        this.fireLayerListenerChanged(1);
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerShape(int s) {
        this.markerShape = s;
        this.userSetProperties.set(817);
        this.fireLayerListenerChanged(1);
    }

    public int getMarkerSize() {
        return this.markerWidth;
    }

    public void setMarkerSize(int s) {
        if (s <= 0) {
            return;
        }
        this.markerWidth = s;
        this.userSetProperties.set(818);
        this.fireLayerListenerChanged(1);
    }

    public Color getWhiskerColor() {
        return this.whiskerColor;
    }

    public void setWhiskerColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.whiskerColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.whiskerColor = col;
        }
        this.userSetProperties.set(819);
        this.fireLayerListenerChanged(1);
    }

    public int getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public void setWhiskerWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.whiskerWidth = w;
        this.userSetProperties.set(820);
        this.fireLayerListenerChanged(1);
    }

    public int getCapShape() {
        return this.capShape;
    }

    public void setCapShape(int shape) {
        this.capShape = shape;
        this.userSetProperties.set(808);
        this.fireLayerListenerChanged(1);
    }

    public Color getCapColor() {
        return this.capColor;
    }

    public void setCapColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.capColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.capColor = col;
        }
        this.fireLayerListenerChanged(1);
    }

    public int getCapWidth() {
        return this.capWidth;
    }

    public void setCapWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.capWidth = w;
        this.fireLayerListenerChanged(1);
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void setOrientation(int orient) {
        if (orient != 1 && orient != 0) {
            return;
        }
        int oldOrient = this.orientation;
        if (oldOrient != orient) {
            this.orientation = orient;
            this.userSetProperties.set(825);
            this.fireLayerListenerChanged(3);
        }
    }

    public int getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(int by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        this.connectBy = by;
        this.userSetProperties.set(821);
        this.fireLayerListenerChanged(1);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.lineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.lineColor = col;
        }
        this.userSetProperties.set(822);
        this.fireLayerListenerChanged(1);
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.lineWidth = w;
        this.userSetProperties.set(823);
        this.fireLayerListenerChanged(1);
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double bw) {
        if (bw <= 0.0 || bw > 1.0) {
            return;
        }
        this.boxWidth = bw;
        this.userSetProperties.set(805);
        this.fireLayerListenerChanged(1);
    }

    @Override
    public int getXAxisMapping() {
        if (this.orientation == 0 && this.roles.getVariable((Object)this.xRole, 0) == null) {
            return -1;
        }
        return super.getXAxisMapping();
    }

    @Override
    public int getYAxisMapping() {
        if (this.orientation == 1 && this.roles.getVariable((Object)this.xRole, 0) == null) {
            return -1;
        }
        return super.getYAxisMapping();
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                this.computeBoxData();
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public void dispose() {
        if (this.xMapper != null) {
            this.xMapper.dispose();
            this.xMapper = null;
        }
        if (this.groupMapper != null) {
            this.groupMapper.dispose();
            this.groupMapper = null;
        }
        super.dispose();
    }
}

