/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.data.MovingWindowDataFilter;
import com.sas.graphics.silk.base.ScatterElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.ui.NeedlePanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class NeedleElement
extends ScatterElement {
    protected double baseLineValue = Double.NaN;
    protected LineAttrib baseLineAttrib;
    protected int needleWidth = 1;
    protected TabPanelInterface needlePanel = null;
    public static final int[] supportedNeedleProperties = new int[]{24, 25, 23, 433, 427, 434, 441, 2036, 2075, 18901, 18902, 9502, 9503, 9504, 9501};
    protected NeedlePanel panel = null;

    public NeedleElement() {
        this.setSupportedProperties(supportedNeedleProperties);
        this.userSetProperties.appendProperties(supportedNeedleProperties);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.roles.setMaxAllowed((Object)this.yRole, 1);
        this.roles.setMaxAllowed((Object)this.tipRole, 1);
        this.baseLineAttrib = new LineAttrib();
        this.baseLineAttrib.setVisible(SILKGlobal.isFlagSet(4));
        this.baseLineAttrib.setCurrentValueAsDefault(9501);
        this.baseLineAttrib.setWidth(SILKGlobal.isFlagSet(4) ? 1 : 3);
        this.baseLineAttrib.setCurrentValueAsDefault(9503);
        this.baseLineAttrib.setPattern(1);
        this.baseLineAttrib.setCurrentValueAsDefault(9504);
        this.removeChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel");
        this.addChartTabInfo("com.sas.graphics.silk.ui.NeedlePanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"NeedleElement.Needle.txt", (String)"Needle"));
        this.addChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseJoinElement.Markers.txt", (String)"Markers"));
    }

    @Override
    protected void drawChart(Graphics g) {
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0 || this.xOutputRange == null || this.yOutputRange == null) {
            return;
        }
        int[] yVarIndex = new int[this.yVars.size()];
        boolean validYVar = false;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            validYVar = true;
        }
        if (!validYVar) {
            return;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int colorVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorRole, 0));
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex) && !this.isDiscrete((Object)this.xRole);
        boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        if (this.xOutputRange instanceof ContinuousRange) {
            xMin = ((ContinuousRange)this.xOutputRange).getMin();
            xMax = ((ContinuousRange)this.xOutputRange).getMax();
        } else {
            xMax = ((DiscreteRange)this.xOutputRange).getValuesSize() - 1;
        }
        if (this.yOutputRange instanceof ContinuousRange) {
            yMin = ((ContinuousRange)this.yOutputRange).getMin();
        }
        double xBaseValue = xMin;
        double yBaseValue = yMin;
        if (!Double.isNaN(this.baseLineValue)) {
            yBaseValue = this.baseLineValue;
        }
        this.projectValues = this.transformObject.project(xBaseValue, yBaseValue, 0.0, this.projectValues);
        double yBaseLine = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
        Color baseLineColor = this.baseLineAttrib.getColor();
        int needleLinePattern = this.style.getDataStyleElement(this.lineAttrs.getReference()).getLineStyle();
        Color color = this.style.getDataStyleElement(this.lineAttrs.getReference()).getLineColor();
        int nobs = this.filter.getNumberObservations(-1);
        int numInvalid = 0;
        if (!(xIsNum && yIsNum || !(this.filter instanceof MovingWindowDataFilter))) {
            ((MovingWindowDataFilter)this.filter).lockMovingWindow();
            if (!xIsNum) {
                this.xCharMapper.setVariable(this.xCharMapper.getVariable());
            }
            if (!yIsNum) {
                this.yCharMapper.setVariable(this.yCharMapper.getVariable());
            }
        }
        for (int i = 0; i < nobs; ++i) {
            if (!this.filter.isGraphed((long)i)) continue;
            double xValue = Double.NaN;
            xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)i) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)i, null));
            if (xValue < 0.0) {
                ++numInvalid;
            }
            int groupIndex = -1;
            if (groupVarIndex >= 0) {
                groupIndex = this.getGroupIndex(i);
            }
            for (int j = 0; j < yVarIndex.length; ++j) {
                double yValue = Double.NaN;
                yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[j], (long)i) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(0), (long)i, null));
                String yId = this.yVars.get(j).toString();
                DataStyleElement dse = SILKUtilities.getStyleElement(yId, j, 1, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                if (groupIndex >= 0) {
                    String groupValue = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)i, null);
                    dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                    color = dse.getLineColor();
                } else if (colorVarIndex >= 0 && (color = this.getMappedColor(i, colorVarIndex)) != null) {
                    color = this.getAutoOutlineColor(color);
                }
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                int y1 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                int y2 = (int)yBaseLine;
                int x1 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                g.setColor(color);
                if (!(g instanceof Graphics2D)) continue;
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(SASLinePatterns.getStroke((int)needleLinePattern, (int)this.needleWidth));
                g2.drawLine(x1, y1, x1, y2);
                g2.setStroke(oldStroke);
            }
        }
        if (!(xIsNum && yIsNum || !(this.filter instanceof MovingWindowDataFilter))) {
            ((MovingWindowDataFilter)this.filter).releaseMovingWindowLock();
        }
        if (g instanceof Graphics2D && this.baseLineAttrib.isVisible()) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(SASLinePatterns.getStroke((int)this.baseLineAttrib.getPattern(), (int)this.baseLineAttrib.getWidth()));
            this.projectValues = this.transformObject.project(xMin, yMin, 0.0, this.projectValues);
            int x1 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
            this.projectValues = this.transformObject.project(xMax, yMin, 0.0, this.projectValues);
            int x2 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
            g.setColor(baseLineColor);
            g2.drawLine(x1, (int)yBaseLine, x2, (int)yBaseLine);
            g2.setStroke(oldStroke);
        }
        if (this.showMarkers) {
            super.drawChart(g);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        int[] yVarIndex = new int[this.yVars.size()];
        boolean validYVar = false;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            validYVar = true;
        }
        if (!validYVar) {
            return;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int colorVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorRole, 0));
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex) && !this.isDiscrete((Object)this.xRole);
        boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        double xMin = 0.0;
        double yMin = 0.0;
        if (this.xOutputRange instanceof ContinuousRange) {
            xMin = ((ContinuousRange)this.xOutputRange).getMin();
        }
        if (this.yOutputRange instanceof ContinuousRange) {
            yMin = ((ContinuousRange)this.yOutputRange).getMin();
        }
        double xBaseValue = xMin;
        double yBaseValue = yMin;
        if (!Double.isNaN(this.baseLineValue)) {
            yBaseValue = this.baseLineValue;
        }
        this.projectValues = this.transformObject.project(xBaseValue, yBaseValue, 0.0, this.projectValues);
        double yBaseLine = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
        Color[] lineColors = this.style.getDataLineColors();
        int needleLinePattern = this.style.getDataStyleElement(this.lineAttrs.getReference()).getLineStyle();
        Color color = this.style.getDataStyleElement("Selection").getLineColor();
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            if (!this.filter.isGraphed((long)index)) continue;
            double xValue = Double.NaN;
            xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)index) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)index, null));
            int groupIndex = -1;
            if (groupVarIndex >= 0) {
                groupIndex = this.getGroupIndex(index);
            }
            for (int j = 0; j < yVarIndex.length; ++j) {
                double yValue = Double.NaN;
                yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[j], (long)index) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(0), (long)index, null));
                if (groupIndex >= 0) {
                    if (lineColors != null) {
                        color = lineColors[groupIndex % lineColors.length];
                    }
                } else if (colorVarIndex >= 0 && (color = this.getMappedColor(index, colorVarIndex)) != null) {
                    color = this.getAutoOutlineColor(color);
                }
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                int y1 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                int y2 = (int)yBaseLine;
                int x1 = (int)Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                g.setColor(color);
                if (!(g instanceof Graphics2D)) continue;
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(SASLinePatterns.getStroke((int)needleLinePattern, (int)this.needleWidth));
                g2.drawLine(x1, y1, x1, y2);
                g2.setStroke(oldStroke);
            }
        }
        this.selections.reset();
        super.drawSelected(g);
    }

    @Override
    protected LineAttrib getLineStyle(Object yVar, Object group) {
        if (yVar == null) {
            return null;
        }
        LineAttrib rc = null;
        int numGroups = -1;
        Object[] groupValues = this.fetchUniqueValues(this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)), false);
        boolean statGraphCompat = SILKGlobal.isFlagSet(4);
        if (groupValues != null) {
            numGroups = groupValues.length;
        }
        if (numGroups > 0 && group != null) {
            int groupIndex = this.getGroupIndex(group);
            DataStyleElement dse = SILKUtilities.getStyleElement(group.toString(), groupIndex, 2, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
            Color c = null;
            c = groupIndex < 0 ? this.style.getLineStyleElement("Outlines").getLineColor() : dse.getLineColor();
            int linePattern = statGraphCompat || this.yVars.size() > 1 ? dse.getLineStyle() : 1;
            int lineWidth = dse.getLineThickness().getSizeValue();
            rc = new LineAttrib(true, c, lineWidth, linePattern);
        } else {
            int index = -1;
            if (this.yVars.size() > 1) {
                for (int i = 0; i < this.yVars.size(); ++i) {
                    if (!yVar.equals(this.yVars.elementAt(i))) continue;
                    index = i;
                }
            }
            DataStyleElement dse = SILKUtilities.getStyleElement(yVar.toString(), index, 1, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
            int lineWidth = dse.getLineThickness().getSizeValue();
            rc = new LineAttrib(true, dse.getLineColor(), lineWidth, statGraphCompat ? dse.getLineStyle() : 1);
        }
        return rc;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.role) {
            case 25: {
                this.baseLineValue = Double.NaN;
                this.baseLineAttrib.setVisible(SILKGlobal.isFlagSet(4));
                this.roles.setMaxAllowed((Object)this.yRole, 1);
            }
        }
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc && this.baseLineAttrib != null) {
            if (!this.baseLineAttrib.hasUserSetValue(9502)) {
                this.baseLineAttrib.setColor(this.style.getLineStyleElement("AxisLines").getLineColor());
                this.baseLineAttrib.setCurrentValueAsDefault(9502);
            }
            if (!this.baseLineAttrib.hasUserSetValue(9504)) {
                this.baseLineAttrib.setPattern(this.style.getLineStyleElement("AxisLines").getLineStyle());
                this.baseLineAttrib.setCurrentValueAsDefault(9504);
            }
        }
        if (this.style.getSchemeName().equalsIgnoreCase("SILKDefault") && !this.hasUserSetValue(2015)) {
            this.setMarkerShape(new Integer(0));
            this.userSetProperties.clear(2015);
            this.setMarkerFilled(false);
            this.userSetProperties.clear(2017);
        }
        return rc;
    }

    @Override
    public void dispose() {
        if (this.needlePanel != null) {
            this.needlePanel.removePropertyListener(this);
        }
        this.needlePanel = null;
        super.dispose();
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 2075: {
                rc = Boolean.TRUE;
                break;
            }
            case 2036: {
                rc = new Boolean(this.showMarkers);
                break;
            }
            case 9501: 
            case 9502: 
            case 9503: 
            case 9504: {
                rc = this.baseLineAttrib.getPropertyValue(id);
                break;
            }
            case 18902: {
                double d = this.getBaseLine();
                if (Double.isNaN(d) && this.yOutputRange instanceof ContinuousRange) {
                    d = ((ContinuousRange)this.yOutputRange).getMin();
                }
                rc = new Double(d);
                break;
            }
            case 18901: {
                rc = new Double(this.needleWidth);
                break;
            }
            case 19089: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 9501: 
            case 9502: 
            case 9503: 
            case 9504: {
                return this.baseLineAttrib.hasUserSetValue(id);
            }
        }
        return super.hasUserSetValue(id);
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 2036: {
                if (!(value instanceof Boolean)) break;
                this.setMarkersOn((Boolean)value);
                break;
            }
            case 18902: {
                if (value instanceof Number) {
                    this.setBaseLine(((Number)value).doubleValue());
                    break;
                }
                if (!(value instanceof String)) break;
                double d = this.baseLineValue;
                try {
                    d = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.setBaseLine(d);
                break;
            }
            case 18901: {
                if (!(value instanceof Number)) break;
                this.needleWidth = ((Number)value).intValue();
                this.userSetProperties.set(18901);
                break;
            }
            case 9502: {
                this.baseLineAttrib.setColor(value);
                break;
            }
            case 9503: {
                if (!(value instanceof Number)) break;
                this.baseLineAttrib.setWidth(((Number)value).intValue());
                break;
            }
            case 9504: {
                if (!(value instanceof Number)) break;
                this.baseLineAttrib.setPattern(((Number)value).intValue());
                break;
            }
            case 9501: {
                if (!(value instanceof Boolean)) break;
                this.baseLineAttrib.setVisible((Boolean)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setMarkersOn(boolean on) {
        this.showMarkers = on;
        this.userSetProperties.set(2036);
        this.fireLayerListenerChanged(1);
    }

    public boolean areMarkersOn() {
        return this.showMarkers;
    }

    public boolean setBaseLine(double baseLineValue) {
        if (Double.isNaN(baseLineValue)) {
            return false;
        }
        this.baseLineValue = baseLineValue;
        this.userSetProperties.set(18902);
        return true;
    }

    public double getBaseLine() {
        return this.baseLineValue;
    }
}

