/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.util.TransformObject;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class MarginElement
extends BaseElement {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_SOLID = 1;
    public static final int BORDER_DASHED = 2;
    private int alignment = 1;
    private int border = 1;
    private Vector charts = new Vector();
    private int marginSpace = 50;
    private int GAP = 6;
    private int marginChartSpace = this.marginSpace - 2 * this.GAP;
    private Rectangle chartBounds = new Rectangle();
    private TransformObject to = new TransformObject();

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        byte myDim = this.computeDimension();
        if (myDim == dim) {
            switch (dim) {
                case 1: {
                    this.to.setXRange(range);
                    this.to.setYRange((DataRange)new ContinuousRange(-1.0, 1.0));
                    break;
                }
                case 2: {
                    this.to.setXRange((DataRange)new ContinuousRange(-1.0, 1.0));
                    this.to.setYRange(range);
                }
            }
        }
    }

    protected int getChartAxisMapping(byte dim) {
        int axisMapping = 0;
        if (this.charts.size() > 0) {
            BaseElement be = (BaseElement)this.charts.elementAt(0);
            axisMapping = 2 == dim ? be.getYAxisMapping() : be.getXAxisMapping();
        }
        return axisMapping;
    }

    protected byte computeDimension() {
        byte rc = 1;
        switch (this.alignment) {
            case 1: 
            case 3: {
                rc = 1;
                break;
            }
            case 2: 
            case 4: {
                rc = 2;
            }
        }
        return rc;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (p instanceof Graphics2D && this.border != 0) {
            Graphics2D g = (Graphics2D)p;
            Stroke oldStroke = g.getStroke();
            BasicStroke newStroke = null;
            switch (this.border) {
                case 2: {
                    newStroke = SASLinePatterns.getStroke((int)2, (int)1);
                    break;
                }
                default: {
                    newStroke = SASLinePatterns.getStroke((int)0, (int)1);
                }
            }
            g.setStroke(newStroke);
            g.setColor(this.style.getLineStyleElement("AxisLines").getLineColor());
            switch (this.alignment) {
                case 1: {
                    g.drawLine(this.bounds.x, this.chartBounds.y + this.chartBounds.height, this.bounds.x + this.bounds.width, this.chartBounds.y + this.chartBounds.height);
                    break;
                }
                case 3: {
                    g.drawLine(this.bounds.x, this.chartBounds.y, this.bounds.x + this.bounds.width, this.chartBounds.y);
                    break;
                }
                case 2: {
                    g.drawLine(this.chartBounds.x + this.chartBounds.width, this.bounds.y, this.chartBounds.x + this.chartBounds.width, this.bounds.y + this.bounds.height);
                    break;
                }
                case 4: {
                    g.drawLine(this.chartBounds.x, this.bounds.y, this.chartBounds.x, this.bounds.y + this.bounds.height);
                }
            }
            g.setStroke(oldStroke);
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).draw(p, callHighlightDraw);
        }
    }

    @Override
    protected void drawChart(Graphics g) {
    }

    @Override
    protected void drawSelected(Graphics g) {
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    protected void layoutChart() {
        super.layoutChart();
        Insets margin = new Insets(this.prefInnerMargin.top, this.prefInnerMargin.left, this.prefInnerMargin.bottom, this.prefInnerMargin.right);
        switch (this.alignment) {
            case 1: {
                margin.top = this.marginSpace;
                break;
            }
            case 3: {
                margin.bottom = this.marginSpace;
                break;
            }
            case 2: {
                margin.left = this.marginSpace;
                break;
            }
            case 4: {
                margin.right = this.marginSpace;
            }
        }
        if (margin.left != this.prefInnerMargin.left || margin.right != this.prefInnerMargin.right || margin.top != this.prefInnerMargin.top || margin.bottom != this.prefInnerMargin.bottom) {
            this.prefInnerMargin.top = margin.top;
            this.prefInnerMargin.right = margin.right;
            this.prefInnerMargin.bottom = margin.bottom;
            this.prefInnerMargin.left = margin.left;
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        switch (this.alignment) {
            case 1: {
                this.chartBounds.x = r.x + this.innerMargin.left;
                this.chartBounds.width = r.width - (this.innerMargin.left + this.innerMargin.right);
                this.chartBounds.y = r.y + this.GAP;
                this.chartBounds.height = this.marginChartSpace;
                break;
            }
            case 3: {
                this.chartBounds.x = r.x + this.innerMargin.left;
                this.chartBounds.width = r.width - (this.innerMargin.left + this.innerMargin.right);
                this.chartBounds.y = r.y + r.height - this.marginSpace + this.GAP;
                this.chartBounds.height = this.marginChartSpace;
                break;
            }
            case 2: {
                this.chartBounds.x = r.x + this.GAP;
                this.chartBounds.width = this.marginChartSpace;
                this.chartBounds.y = r.y + this.innerMargin.top;
                this.chartBounds.height = r.height - (this.innerMargin.top + this.innerMargin.bottom);
                break;
            }
            case 4: {
                this.chartBounds.x = r.x + r.width - this.marginSpace + this.GAP;
                this.chartBounds.width = this.marginChartSpace;
                this.chartBounds.y = r.y + this.innerMargin.top;
                this.chartBounds.height = r.height - (this.innerMargin.top + this.innerMargin.bottom);
            }
        }
        this.to.setScreenBounds(this.chartBounds.x, this.chartBounds.y, this.chartBounds.width, this.chartBounds.height);
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setBounds(this.chartBounds);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void addChart(BaseElement element) {
        if (element != null && !this.charts.contains(element)) {
            this.charts.addElement(element);
            element.setTransformObject(this.to);
        }
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }
}

