/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.GTKDataFilterGraphedVariable;
import com.sas.graphics.data.GTKDataFilterSelectionVariable;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.render.map.MapObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class MapElement
extends BaseElement
implements IOBSInterface {
    public static final String MAP_DATA_ID = "Map";
    public static final String RESPONSE_DATA_ID = "Response";
    protected SILKNumber spatialRole = null;
    protected SILKNumber mapIDRole = null;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber segmentRole = null;
    protected SILKNumber tipRole = null;
    protected SILKNumber responseIDRole = null;
    protected SILKNumber colorRole = null;
    protected GTKStringDataFilterVariable spatialVariable;
    protected GTKNumericDataFilterVariable xVariable;
    protected GTKNumericDataFilterVariable yVariable;
    protected GTKNumericDataFilterVariable segmentVariable;
    protected GTKNumericDataFilterVariable mapIDVariable;
    protected GTKStringDataFilterVariable mapStringIDVariable;
    protected GTKNumericDataFilterVariable responseIDVariable;
    protected GTKStringDataFilterVariable responseStringIDVariable;
    protected GTKNumericDataFilterVariable colorVariable;
    protected GTKDataFilterSelectionVariable selectionVariable;
    protected GTKDataFilterGraphedVariable graphedVariable;
    protected MapObject map;
    protected boolean fillOn = true;
    protected SILKNumber currentLegend = null;

    public MapElement() {
        this.filters.setDefaultDataId(MAP_DATA_ID);
        this.spatialRole = this.role.getRoleObject("ROLE_SPATIAL");
        this.roles.newRole((Object)this.spatialRole, "SPATIAL", 1, MAP_DATA_ID);
        this.roles.setRoleType((Object)this.spatialRole, 0);
        this.mapIDRole = this.role.getRoleObject("ROLE_MAP_ID");
        this.roles.newRole((Object)this.mapIDRole, "MAP_ID", 1, MAP_DATA_ID);
        this.roles.setRoleType((Object)this.mapIDRole, 0);
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1, MAP_DATA_ID);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1, MAP_DATA_ID);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.segmentRole = this.role.getRoleObject("ROLE_SEGMENT");
        this.roles.newRole((Object)this.segmentRole, "Segment", 1, MAP_DATA_ID);
        this.roles.setRoleType((Object)this.segmentRole, 1);
        this.responseIDRole = this.role.getRoleObject("ROLE_MAP_RESPONSE_ID");
        this.roles.newRole((Object)this.responseIDRole, "MAP_RESPONSE_ID", 1, RESPONSE_DATA_ID);
        this.roles.setRoleType((Object)this.responseIDRole, 0);
        this.colorRole = this.role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, "COLOR", 1, RESPONSE_DATA_ID);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.tipRole = this.role.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.tipRole, "TIP", 100, RESPONSE_DATA_ID);
        this.roles.setRoleType((Object)this.tipRole, 0);
        this.spatialVariable = new GTKStringDataFilterVariable();
        this.xVariable = new GTKNumericDataFilterVariable();
        this.yVariable = new GTKNumericDataFilterVariable();
        this.segmentVariable = new GTKNumericDataFilterVariable();
        this.mapIDVariable = new GTKNumericDataFilterVariable();
        this.mapStringIDVariable = new GTKStringDataFilterVariable();
        this.responseIDVariable = new GTKNumericDataFilterVariable();
        this.responseStringIDVariable = new GTKStringDataFilterVariable();
        this.colorVariable = new GTKNumericDataFilterVariable();
        this.selectionVariable = new GTKDataFilterSelectionVariable();
        this.graphedVariable = new GTKDataFilterGraphedVariable();
        this.map = new MapObject();
        this.map.setChannel(new Channel((Component)new Container(), 2));
        this.rampName = "ThreeColorRamp";
        this.applyStyleElement();
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.tipRole.equals(role)) {
            DataFilterReadInterface filter = this.filters.getDataFilter(RESPONSE_DATA_ID);
            if (variableId instanceof String) {
                Object[] variables = ParserUtils.parseStringArray((String)((String)variableId).replace("(", "").replace(")", ""), (String)",");
                return this.addRoleVars(filter, (Object)this.tipRole, variables);
            }
            if (variableId instanceof Object[]) {
                return this.addRoleVars(filter, (Object)this.tipRole, (Object[])variableId);
            }
        }
        return super.setRole(variableId, role);
    }

    private boolean addRoleVars(DataFilterReadInterface filter, Object role, Object[] vars) {
        if (vars == null || filter == null) {
            return false;
        }
        int type = Extract.getSourceType((Object)vars);
        int numVars = Extract.getNumberItems((Object)vars, (int)type);
        if (numVars == 0) {
            return false;
        }
        boolean rc = false;
        Enumeration e = Extract.elements((Object)vars);
        while (e.hasMoreElements()) {
            int varId;
            Object vid = e.nextElement();
            if (vid instanceof String) {
                vid = ((String)vid).trim();
            }
            if ((varId = filter.getVariableIndex(vid)) < 0 || varId > filter.getNumberVariables()) continue;
            this.addRole(vid, role);
            rc = true;
        }
        return rc;
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 20: {
                Object var;
                DataFilterReadInterface filter = this.filters.getDataFilter(MAP_DATA_ID);
                if (filter == null || filter.isNumericVariable(var = this.roles.getVariable((Object)this.spatialRole, 0))) break;
                this.spatialVariable.connectFrom(filter, var);
                this.map.setWkbVariable((StringVariable)this.spatialVariable);
                break;
            }
            case 24: {
                DataFilterReadInterface filter = this.filters.getDataFilter(MAP_DATA_ID);
                if (filter == null) break;
                this.xVariable.connectFrom(filter, this.roles.getVariable((Object)this.xRole, 0));
                this.map.setXVariable((NumericVariable)this.xVariable);
                break;
            }
            case 25: {
                DataFilterReadInterface filter = this.filters.getDataFilter(MAP_DATA_ID);
                if (filter == null) break;
                this.yVariable.connectFrom(filter, this.roles.getVariable((Object)this.yRole, 0));
                this.map.setYVariable((NumericVariable)this.yVariable);
                break;
            }
            case 59: {
                DataFilterReadInterface filter = this.filters.getDataFilter(MAP_DATA_ID);
                if (filter == null) break;
                this.segmentVariable.connectFrom(filter, this.roles.getVariable((Object)this.segmentRole, 0));
                this.map.setSegmentVariable((NumericVariable)this.segmentVariable);
                break;
            }
            case 9: {
                DataFilterReadInterface filter = this.filters.getDataFilter(MAP_DATA_ID);
                if (filter == null) break;
                Object var = this.roles.getVariable((Object)this.mapIDRole, 0);
                if (filter.isNumericVariable(var)) {
                    this.mapIDVariable.connectFrom(filter, var);
                    this.map.setMapIDVariable((NumericVariable)this.mapIDVariable);
                    this.mapStringIDVariable.disconnect();
                    this.map.setMapStringIDVariable(null);
                    break;
                }
                this.mapStringIDVariable.connectFrom(filter, var);
                this.map.setMapStringIDVariable((StringVariable)this.mapStringIDVariable);
                this.mapIDVariable.disconnect();
                this.map.setMapIDVariable(null);
                break;
            }
            case 10: {
                DataFilterReadInterface filter = this.filters.getDataFilter(RESPONSE_DATA_ID);
                if (filter == null) break;
                Object var = this.roles.getVariable((Object)this.responseIDRole, 0);
                if (filter.isNumericVariable(var)) {
                    this.responseIDVariable.connectFrom(filter, var);
                    this.map.setResponseIDVariable((NumericVariable)this.responseIDVariable);
                    this.responseStringIDVariable.disconnect();
                    this.map.setResponseStringIDVariable(null);
                    break;
                }
                this.responseStringIDVariable.connectFrom(filter, var);
                this.map.setResponseStringIDVariable((StringVariable)this.responseStringIDVariable);
                this.responseIDVariable.disconnect();
                this.map.setResponseIDVariable(null);
                break;
            }
            case 2: {
                DataFilterReadInterface filter = this.filters.getDataFilter(RESPONSE_DATA_ID);
                if (filter != null) {
                    this.colorVariable.connectFrom(filter, this.roles.getVariable((Object)this.colorRole, 0));
                    this.map.setColorVariable((NumericVariable)this.colorVariable);
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
                    this.applyStyleElement();
                }
                this.lce.setAction(4);
                this.lce.setBuildData(this.colorRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                this.lce.setAction(1);
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 20: {
                this.spatialVariable.disconnect();
                this.map.setWkbVariable(null);
                break;
            }
            case 24: {
                this.xVariable.disconnect();
                this.map.setXVariable(null);
                break;
            }
            case 25: {
                this.yVariable.disconnect();
                this.map.setYVariable(null);
                break;
            }
            case 59: {
                this.segmentVariable.disconnect();
                this.map.setSegmentVariable(null);
                break;
            }
            case 9: {
                this.mapIDVariable.disconnect();
                this.map.setMapIDVariable(null);
                this.map.setMapStringIDVariable(null);
                break;
            }
            case 10: {
                this.responseIDVariable.disconnect();
                this.map.setResponseIDVariable(null);
                this.map.setResponseStringIDVariable(null);
                break;
            }
            case 2: {
                this.colorVariable.disconnect();
                this.map.setColorVariable(null);
                this.clearColorRamp();
            }
        }
    }

    protected void setViewport() {
        Channel ch = this.map.getChannel();
        if (ch != null && !this.bounds.isEmpty()) {
            ch.glViewport(this.bounds.x + this.innerMargin.left, this.bounds.y + this.innerMargin.top, this.bounds.width - this.innerMargin.left - this.innerMargin.right, this.bounds.height - this.innerMargin.top - this.innerMargin.bottom);
        }
    }

    protected void setProjection() {
        Channel ch = this.map.getChannel();
        if (ch != null) {
            DataRange xrange = this.getOutputRange((byte)1);
            DataRange yrange = this.getOutputRange((byte)2);
            if (xrange == null || yrange == null || !(xrange instanceof ContinuousRange) || !(yrange instanceof ContinuousRange)) {
                return;
            }
            ch.glOrtho(((ContinuousRange)xrange).getMin(), ((ContinuousRange)xrange).getMax(), ((ContinuousRange)yrange).getMin(), ((ContinuousRange)yrange).getMax(), -1.0, 1.0);
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        this.map.getChannel().setSingleBufferGraphics(g);
        this.map.setCroppedTransparency(this.getCroppedTransparency());
        this.map.draw();
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        this.map.getChannel().setSingleBufferGraphics(g);
        this.map.drawSelections();
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        Vector obs = this.map.getSelectResults(selectArea);
        DataFilterReadInterface responseData = this.filters.getDataFilter(RESPONSE_DATA_ID);
        if (responseData == null) {
            return false;
        }
        if (responseData instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
            ((AbstractDataFilter)responseData).setSelected((Object)obs, 3, (IOBSInterface)this);
        } else {
            responseData.setSelected((Object)obs, select, (IOBSInterface)this);
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Rectangle selectArea = new Rectangle(screenX, screenY, 1, 1);
        Vector obs = this.map.getSelectResults(selectArea);
        if (obs != null && obs.size() > 0) {
            return this.getTipText((int)this.getObservationIndex(obs.elementAt(0)));
        }
        return null;
    }

    protected String getTipText(int obs) {
        Object tipVars;
        Object colorVar;
        if (obs < 0 || obs > this.filter.getNumberObservations(-1)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Object responseIDVar = this.roles.getVariable((Object)this.responseIDRole, 0);
        if (responseIDVar != null) {
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(responseIDVar));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(responseIDVar, obs));
        }
        if ((colorVar = this.roles.getVariable((Object)this.colorRole, 0)) != null) {
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(colorVar));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(colorVar, obs));
        }
        if ((tipVars = this.roles.getAllVariables((Object)this.tipRole)) != null) {
            int type = Extract.getSourceType((Object)tipVars);
            int n = Extract.getNumberItems((Object)tipVars, (int)type);
            for (int i = 0; i < n; ++i) {
                Object tipVar = Extract.getObject((Object)tipVars, (int)i, (int)type);
                String fv = this.getFormattedValue(tipVar, obs);
                if (tipVar == null || fv == null) continue;
                sb.append("\n");
                sb.append(this.filter.getVariableDescription(tipVar));
                sb.append(" \t=\t ");
                sb.append((Object)fv);
            }
        }
        return sb.toString();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.setViewport();
        this.setProjection();
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        if (id == null) {
            id = MAP_DATA_ID;
        }
        if (id == RESPONSE_DATA_ID) {
            this.filters.setDefaultDataId(RESPONSE_DATA_ID);
        }
        boolean rc = super.setDataSource(source, id);
        DataFilterReadInterface respData = this.filters.getDataFilter(RESPONSE_DATA_ID);
        DataFilterReadInterface mapData = this.filters.getDataFilter(MAP_DATA_ID);
        if (respData != null) {
            this.selectionVariable.connectFrom(respData);
            this.map.setSelectionVariable((NumericVariable)this.selectionVariable);
            this.graphedVariable.connectFrom(respData);
            this.map.setGraphedVariable((NumericVariable)this.graphedVariable);
        } else if (mapData != null) {
            this.selectionVariable.connectFrom(mapData);
            this.map.setSelectionVariable((NumericVariable)this.selectionVariable);
        } else {
            this.map.setSelectionVariable(null);
            this.map.setGraphedVariable(null);
        }
        return rc;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc) {
            this.applyStyleElement();
        }
        return rc;
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        DataFilterReadInterface filter = this.filters.getDataFilter(RESPONSE_DATA_ID);
        if (filter == null) {
            return null;
        }
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = filter.getVariableIndex(colorVar);
        if (this.colorRole != null && (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) && colorVarIndex >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    protected boolean isLegendValid(SILKNumber role) {
        if (role == null) {
            return false;
        }
        Object o = null;
        o = this.getLegendEntries(role);
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        return null;
    }

    public long getObservationIndex(Object o) {
        if (o == null) {
            return -1L;
        }
        return ((SelectResult)o).getValueIndex();
    }

    public void applyStyleElement() {
        if (this.map == null || this.style == null) {
            return;
        }
        this.initColorRamp();
        double[] breakValues = new double[Double.isNaN(this.colorMapper.getNeutralValue()) ? 2 : 3];
        int count = 0;
        breakValues[count++] = this.colorMapper.getMinValue();
        if (!Double.isNaN(this.colorMapper.getNeutralValue())) {
            breakValues[count++] = this.colorMapper.getNeutralValue();
        }
        breakValues[count++] = this.colorMapper.getMaxValue();
        Color[] rampClrs = new Color[this.colorMapper.getNeutralColor() == null ? 2 : 3];
        count = 0;
        rampClrs[count++] = this.colorMapper.getMinColor();
        if (this.colorMapper.getNeutralColor() != null) {
            rampClrs[count++] = this.colorMapper.getNeutralColor();
        }
        rampClrs[count++] = this.colorMapper.getMaxColor();
        this.map.setRampColors(rampClrs);
        this.map.setRampValues(breakValues);
        this.map.setFillColor(this.style.getFillStyleElement(this.fillAttrs.getReference()).getFillColor());
        this.map.setEdgeColor(this.style.getLineStyleElement("Outlines").getLineColor());
        if (this.fillOn) {
            if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                this.map.setEmptyColor(this.style.getFillStyleElement("Missing").getFillColor());
            } else {
                this.map.setEmptyColor(this.style.getFillStyleElement("GraphDataStyleDefault").getFillColor());
            }
        } else {
            this.map.setEmptyColor(null);
        }
        this.map.setEmptyEdgeColor(this.map.getEdgeColor());
        this.map.setSelectionColor(this.style.getFillStyleElement("Selection").getFillColor());
    }

    @Override
    public Object getPropertyValue(int id) {
        Object[] rc = null;
        switch (id) {
            case 19064: 
            case 19065: 
            case 19068: 
            case 19069: {
                rc = Boolean.FALSE;
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                    break;
                }
                if (!this.colorRole.equals((Object)this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid(this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = this.colorRole.equals((Object)this.currentLegend);
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                SILKNumber leg;
                if (!(value instanceof SILKNumber) || !(leg = (SILKNumber)((Object)value)).equals((Object)this.colorRole)) break;
                this.currentLegend = leg;
                return true;
            }
        }
        return rc;
    }

    public void setFillOn(boolean fill) {
        this.fillOn = fill;
        if (fill) {
            if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                this.map.setEmptyColor(this.style.getFillStyleElement("Missing").getFillColor());
            } else {
                this.map.setEmptyColor(this.style.getFillStyleElement("GraphDataStyleDefault").getFillColor());
            }
        } else {
            this.map.setEmptyColor(null);
        }
    }

    public boolean isFillOn() {
        return this.fillOn;
    }
}

