/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.base.AbstractHistogramElement;
import com.sas.graphics.silk.base.HistogramParmElement;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.FillPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.util.LinkedHashMap;
import java.util.Vector;

public class HistogramParmGroupedElement
extends HistogramParmElement {
    protected SILKNumber groupRole = null;
    protected LinkedHashMap groupIndexMap = null;
    protected int groupDisplayStyle = 2;
    protected AbstractHistogramElement.Bin[] missingXBins = null;
    protected Vector selectedMissingBins = new Vector();
    protected boolean allTips = true;
    protected static final int[] supportedGroupHistProps = new int[]{823};

    public HistogramParmGroupedElement() {
        this.tipTextWorker.setMultiTip(this.allTips);
        this.roles.deleteRole((Object)this.yRole);
        this.removeBuildRole(this.yRole);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.addBuildRole(this.groupRole);
        this.setSupportedProperties(supportedGroupHistProps);
        this.userSetProperties.appendProperties(supportedGroupHistProps);
    }

    @Override
    public boolean build(Object buildData) {
        boolean rc = super.build(buildData);
        if (rc) {
            this.currentLegend = this.getLegendName();
            this.fireLayerListenerChanged(6);
        }
        return rc;
    }

    @Override
    protected boolean buildBiVariateBins() {
        return this.buildUniVariateBins();
    }

    @Override
    protected boolean buildUniVariateBins() {
        int i;
        if (this.filter == null || this.filter.getNumberObservations(-1) < 1) {
            return false;
        }
        if (!(this.filter instanceof DataFilterInfoInterface)) {
            return false;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        if (xVar == null || responseVar == null || groupVar == null) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        int responseVarIndex = this.filter.getVariableIndex(responseVar);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        if (xVarIndex < 0 || responseVarIndex < 0 || groupVarIndex < 0) {
            return false;
        }
        Object[] allGroups = this.fetchUniqueValues(groupVarIndex, false);
        Object[] groupValues = this.fetchUniqueValues(groupVarIndex, true);
        if (groupValues == null || groupValues.length < 1) {
            return false;
        }
        SortContext xSortContext = SortContextFactory.getSortContext((Object)this.filter, (String)xVar.toString(), (int)1);
        double[] temp = new double[3];
        this.xBins = this.createBins(xVar, this.xValues, this.xBins, this.xBinIndices, this.xBinNames, xSortContext, temp);
        this.xBinStart = temp[0];
        this.xBinEnd = temp[1];
        this.xBinWidth = temp[2];
        this.numberOfBins_X = this.xBins.size();
        this.buildGroupIndexMap(allGroups);
        this.xBins = this.buildGroupedBins(this.xBins, groupVar, groupValues);
        if (this.xBins == null) {
            return false;
        }
        this.univariateBinValues = new double[this.xBins.size()];
        this.univariateBinIndex = new int[this.xBins.size()];
        this.missingValues = 0.0;
        this.missingIndex = -1;
        this.missingXBinValues = new double[allGroups.length];
        this.missingXValuesIndex = new int[allGroups.length];
        this.missingXBins = new AbstractHistogramElement.Bin[allGroups.length];
        for (i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double d1 = this.filter.getNumericValue(xVarIndex, (long)i);
            double binValue = this.filter.getNumericValue(responseVarIndex, (long)i);
            String group = this.filter.getFormattedValue(groupVar, (long)i, null);
            int gIndex = this.getGroupIndex(group);
            if (Double.isNaN(d1)) {
                if (gIndex >= 0 && !Double.isNaN(gIndex)) {
                    this.missingXBinValues[gIndex] = binValue;
                    this.missingXValuesIndex[gIndex] = i;
                    AbstractHistogramElement.Bin b = new AbstractHistogramElement.Bin();
                    b.setMax(Double.NaN);
                    b.setMin(Double.NaN);
                    b.setGroup(group.toString());
                    b.setGroupIndex(gIndex);
                    this.missingXBins[gIndex] = b;
                }
                this.missingIndex = i;
                continue;
            }
            int xBin = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, d1, group);
            AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)this.xBins.get(new Integer(xBin));
            if (b == null) continue;
            b.setCount(binValue);
            this.univariateBinValues[xBin] = binValue;
            this.univariateBinIndex[xBin] = i;
        }
        for (i = 0; i < this.missingXBinValues.length; ++i) {
            this.missingValues = Math.max(this.missingValues, this.missingXBinValues[i]);
        }
        return true;
    }

    protected int getBinIndex(LinkedHashMap bins, double binStart, double binEnd, double value, Object group) {
        if (Double.isNaN(value) || group == null) {
            return -3;
        }
        if (bins == null) {
            return -1;
        }
        if (value < binStart) {
            return -1;
        }
        for (int i = 0; i < bins.size(); ++i) {
            AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
            if (!b.contains(value, this.xBoundary) || !group.equals(b.getGroup())) continue;
            return i;
        }
        if (value <= binEnd) {
            return bins.size() - 1;
        }
        return -2;
    }

    protected LinkedHashMap buildGroupedBins(LinkedHashMap bins, Object groupVar, Object[] groupValues) {
        int i;
        if (bins == null || bins.size() == 0 || groupValues == null || groupValues.length < 0) {
            return null;
        }
        int nBins = bins.size();
        for (i = 0; i < nBins; ++i) {
            AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
            b.setGroup(groupValues[0].toString());
            b.setGroupIndex(this.getGroupIndex(groupValues[0]));
        }
        for (i = 1; i < groupValues.length; ++i) {
            Object group = groupValues[i];
            for (int j = 0; j < nBins; ++j) {
                Integer xBinId = new Integer(j);
                AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(xBinId);
                int binIndex = i * nBins + j;
                AbstractHistogramElement.Bin gBin = new AbstractHistogramElement.Bin();
                gBin.setMin(b.getMin());
                gBin.setMax(b.getMax());
                gBin.setGroup(group.toString());
                gBin.setGroupIndex(this.getGroupIndex(group));
                gBin.setIndex(binIndex);
                bins.put(new Integer(binIndex), gBin);
            }
        }
        return bins;
    }

    protected void buildGroupIndexMap(Object[] groupValues) {
        if (this.groupIndexMap == null) {
            this.groupIndexMap = new LinkedHashMap();
        } else {
            this.groupIndexMap.clear();
        }
        if (groupValues == null || groupValues.length < 1) {
            return;
        }
        for (int i = 0; i < groupValues.length; ++i) {
            if (groupValues[i] == null || groupValues[i].toString().trim().length() == 0) {
                this.groupIndexMap.put(groupValues[i], new Integer(-i));
                continue;
            }
            this.groupIndexMap.put(groupValues[i], new Integer(i));
        }
    }

    protected int getGroupIndex(Object group) {
        if (this.groupIndexMap == null || this.groupIndexMap.size() == 0 || group == null) {
            return -1;
        }
        if (!this.groupIndexMap.containsKey(group)) {
            return -1;
        }
        return (Integer)this.groupIndexMap.get(group);
    }

    @Override
    protected void checkHistogramType() {
        this.bivariate = false;
    }

    @Override
    protected LinkedHashMap buildBinSelectionCountMap(SelectionIterator selections) {
        LinkedHashMap<Integer, Double> binSelectionCount = new LinkedHashMap<Integer, Double>();
        if (selections == null || !selections.hasMoreSelections() || this.univariateBinValues == null) {
            return binSelectionCount;
        }
        Integer missingBinId = new Integer(-3);
        if (this.selectedMissingBins != null) {
            this.selectedMissingBins.clear();
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        while (selections.hasMoreSelections()) {
            int index = selections.nextSelectedIndex();
            double value = this.filter.getNumericValue(xVarIndex, (long)index);
            String group = this.filter.getFormattedValue(groupVar, (long)index, null);
            int binIndex = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, value, group);
            Integer binId = new Integer(binIndex);
            double binValue = 0.0;
            if (missingBinId.equals(binId)) {
                if (this.missingXBinValues != null) {
                    int gIndex = this.getGroupIndex(group);
                    if (gIndex >= 0) {
                        binValue = this.missingXBinValues[gIndex];
                    }
                    this.selectedMissingBins.add(group);
                }
            } else {
                binValue = this.univariateBinValues[binIndex];
            }
            binSelectionCount.put(binId, new Double(binValue));
        }
        return binSelectionCount;
    }

    @Override
    protected String getAdditionalTipText(AbstractHistogramElement.Bin xBin, AbstractHistogramElement.Bin yBin, double value) {
        if (xBin == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object desc = this.filter.getVariableDescription(groupVar);
        sb.append(desc);
        sb.append(" \t=\t");
        sb.append(xBin.getGroup());
        sb.append("\n");
        sb.append(super.getAdditionalTipText(xBin, yBin, value));
        return sb.toString();
    }

    @Override
    protected SILKNumber getLegendName() {
        if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
            return this.groupRole;
        }
        return null;
    }

    @Override
    protected Object[] getLegendDisplayNames() {
        if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
            return new Object[]{this.groupRole};
        }
        return null;
    }

    @Override
    protected Object getLegendTitleText() {
        return this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0));
    }

    @Override
    protected Vector getLegendEntries() {
        if (this.currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        if (groupVar == null || groupVarIndex < 0 || subsetGroupValues == null || subsetGroupValues.length < 1) {
            return null;
        }
        this.buildGroupIndexMap(this.fetchUniqueValues(groupVarIndex, false));
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(subsetGroupValues.length);
        for (int i = 0; i < subsetGroupValues.length; ++i) {
            Color color = this.style.getDataStyleElement(this.fillAttrs.getReference()).getFillColor();
            Color lineColor = this.style.getLineStyleElement("Outlines").getLineColor();
            int groupIndex = this.getGroupIndex(subsetGroupValues[i]);
            if (groupIndex >= 0) {
                String groupValue = subsetGroupValues[i].toString();
                DataStyleElement dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                color = this.style.getMarkerStyleElement("Missing").getAsDataStyle().getFillColor();
            }
            MarkerAttrib ms = new MarkerAttrib(true, color);
            ms.setShape(new Integer(19));
            ms.setFilled(true);
            ms.setOutline(new Boolean(this.areOutlinesOn()));
            ms.setOutline(lineColor);
            legendEntries.add(new LegendEntry(subsetGroupValues[i], ms, null));
        }
        return legendEntries;
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 823: {
                if (value instanceof Number) {
                    this.setGroupDisplayStyle(((Number)value).intValue());
                    break;
                }
                if (value == null) break;
                this.setGroupDisplayStyle(value.toString());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 834: {
                rc = Boolean.FALSE;
                break;
            }
            case 833: {
                rc = Boolean.FALSE;
                break;
            }
            case 823: {
                rc = new Integer(this.groupDisplayStyle);
                break;
            }
            case 53: {
                rc = null;
                break;
            }
            case 434: {
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 441: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    protected Rectangle getMissingBinScreenRectangle(double missingValue, Rectangle r, double[] pt1, double[] pt2) {
        AbstractHistogramElement.Bin firstXBin;
        if (r == null) {
            r = new Rectangle();
        }
        if (this.xDataRange == null) {
            return r;
        }
        if (this.isValidCount(missingValue) && (firstXBin = (AbstractHistogramElement.Bin)this.xBins.get(new Integer(0))) != null) {
            pt1 = this.transformObject.project(firstXBin.getMin(), missingValue, 0.0, pt1);
            pt2 = this.transformObject.project(((ContinuousRange)this.xDataRange).getMin(), 0.0, 0.0, pt2);
            r.x = this.isSingleValue((ContinuousRange)this.xDataRange) ? (this.transformObject.isReverse(0) ? this.bounds.x + this.bounds.width - 10 - this.MISSING_BIN_WIDTH : this.bounds.x + 10) : (this.transformObject.isReverse(0) ? (int)pt2[0] + 10 : (int)pt2[0] - this.MISSING_BIN_WIDTH - 10);
            r.y = this.transformObject.isReverse(1) ? (int)pt2[1] : (int)pt1[1];
            r.width = this.MISSING_BIN_WIDTH;
            r.height = (int)Math.abs(pt2[1] - (double)((int)pt1[1]));
        }
        return r;
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            this.selectedMissingBins.clear();
        }
        super.drawSelected(g);
        if (this.selectedMissingBins == null || this.selectedMissingBins.size() == 0) {
            return;
        }
        Rectangle r = new Rectangle();
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        TexturePaint tp = null;
        FillPattern fillPattern = new FillPattern();
        tp = fillPattern.getHatch45(selectionColor);
        Paint prevPaint = null;
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            prevPaint = g2.getPaint();
        }
        for (int i = 0; i < this.selectedMissingBins.size(); ++i) {
            Object group = this.selectedMissingBins.get(i);
            int gIndex = this.getGroupIndex(group);
            if (gIndex >= 0 && this.isValidCount(this.missingXBinValues[gIndex])) {
                r = this.getMissingBinScreenRectangle(this.missingXBinValues[gIndex], r, pt1, pt2);
            }
            if (g2 == null) {
                g.setColor(selectionColor);
            } else {
                g2.setPaint(tp);
            }
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(selectionColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        if (g2 != null) {
            g2.setPaint(prevPaint);
        }
    }

    @Override
    protected Object doTheWorkForMissingBins(AbstractHistogramElement.Worker worker) {
        if (!this.missingBinOn) {
            return null;
        }
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        Rectangle r = new Rectangle();
        if (this.missingXBinValues != null) {
            for (int i = 0; i < this.missingXBinValues.length; ++i) {
                if (!this.isValidCount(this.missingXBinValues[i])) continue;
                r = this.getMissingBinScreenRectangle(this.missingXBinValues[i], r, pt1, pt2);
                worker.doWorkInLoop(r, this.missingXBinValues[i], this.missingXBins[i], null);
                if (!worker.isWorkDone()) continue;
                return worker.getResult();
            }
            worker.doWorkAtLoopEnd();
            if (worker.isWorkDone()) {
                return worker.getResult();
            }
        }
        return null;
    }

    protected boolean isGroupDrawnFilled(int gIndex) {
        switch (this.groupDisplayStyle) {
            default: {
                return gIndex == 0;
            }
            case 1: {
                return true;
            }
            case 2: 
        }
        return false;
    }

    @Override
    protected void drawBin(Graphics g, Color fillColor, Color fillColor2, Color lineColor, Stroke lineStroke, Rectangle r, double value, AbstractHistogramElement.Bin xBin, AbstractHistogramElement.Bin yBin) {
        Paint oldPaint = null;
        Graphics2D g2 = null;
        Stroke s = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        boolean drawFilledRect = true;
        if (xBin != null) {
            drawFilledRect = this.isGroupDrawnFilled(xBin.getGroupIndex());
            DataStyleElement dse = null;
            dse = xBin.getGroup() == null || xBin.getGroup().trim().length() > 0 ? SILKUtilities.getStyleElement(xBin.getGroup(), xBin.getGroupIndex(), 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle() : this.style.getDataStyleElement("Missing");
            fillColor = dse.getFillColor();
            fillColor2 = ColorUtilities.brighter(fillColor, 0.2);
        }
        if (!this.gradientOn || g2 == null) {
            g.setColor(fillColor);
            oldPaint = null;
        } else {
            oldPaint = g2.getPaint();
            g2.setPaint(new GradientPaint(r.x, r.y, fillColor2, r.x + r.width, r.y + r.height, fillColor));
        }
        if (drawFilledRect) {
            g.fillRect(r.x, r.y, r.width, r.height);
            if (oldPaint != null) {
                g2.setPaint(oldPaint);
            }
        }
        if (this.areOutlinesOn() || !drawFilledRect) {
            g.setColor(lineColor);
            if (!drawFilledRect) {
                g.setColor(fillColor);
                if (g2 != null) {
                    s = g2.getStroke();
                    g2.setStroke(new BasicStroke(2.0f));
                }
            } else if (g2 != null && lineStroke != null) {
                s = g2.getStroke();
                g2.setStroke(lineStroke);
            }
            g.drawRect(r.x, r.y, r.width, r.height);
            if (g2 != null && s != null) {
                g2.setStroke(s);
            }
        }
    }

    public int getGroupDisplayStyle() {
        return this.groupDisplayStyle;
    }

    public void setGroupDisplayStyle(int groupDisplayStyle) {
        this.groupDisplayStyle = groupDisplayStyle;
        this.userSetProperties.set(823);
    }

    protected void setGroupDisplayStyle(String groupDisplayStyle) {
        if (groupDisplayStyle == null) {
            return;
        }
        int gds = this.groupDisplayStyle;
        if ("FillFirstOutlineRest".equalsIgnoreCase(groupDisplayStyle)) {
            gds = 0;
        } else if ("FillAll".equalsIgnoreCase(groupDisplayStyle)) {
            gds = 1;
        } else if ("OutlineAll".equalsIgnoreCase(groupDisplayStyle)) {
            gds = 2;
        } else {
            return;
        }
        this.setGroupDisplayStyle(gds);
    }
}

