/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.base.AbstractHistogramElement;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.text.SASFormat;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;

public class HistogramParmElement
extends AbstractHistogramElement {
    protected GlobalDefaults globalDefaults = new GlobalDefaults();
    protected SILKNumber responseRole = null;
    protected SILKNumber tipRole = null;
    protected static final int[] supportedHistProps = new int[]{803, 807, 819, 836, 824, 810, 811, 826, 827, 828, 829, 830, 831, 834, 833, 24, 25, 23, 433, 426, 434, 441};
    protected int xValues = 0;
    protected int yValues = 0;
    protected int[][] bivariateBinIndex = null;
    protected int[] univariateBinIndex = null;
    protected int missingIndex = -1;
    protected int[] missingXValuesIndex = null;
    protected int[] missingYValuesIndex = null;
    protected LinkedHashMap xBinIndices = new LinkedHashMap();
    protected LinkedHashMap yBinIndices = new LinkedHashMap();
    protected int MAX_NUM_X_BINS;
    protected int MAX_NUM_Y_BINS;

    public HistogramParmElement() {
        this.MAX_NUM_X_BINS = this.globalDefaults.maxHistogramParmBins;
        this.MAX_NUM_Y_BINS = this.globalDefaults.maxHistogramParmBins;
        this.rampName = "ThreeColorRamp";
        this.numberOfBins_X = 0;
        this.numberOfBins_Y = 0;
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.addBuildRole(this.xRole);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.addBuildRole(this.yRole);
        this.responseRole = this.role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 1);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.addBuildRole(this.responseRole);
        this.tipRole = this.role.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.tipRole, "Tip", 100);
        this.roles.setRoleType((Object)this.tipRole, 0);
        this.setSupportedProperties(supportedHistProps);
        this.userSetProperties.appendProperties(supportedHistProps);
        this.addChartTabInfo("com.sas.graphics.silk.ui.HistElementPanel", ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"HistogramParmElement.HistogramParm.txt", (String)"HistogramParm"));
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
    }

    @Override
    protected boolean verifyBinExtents(double binStart, double binEnd, ContinuousRange dataRange, double[] binNames) {
        if (dataRange == null) {
            return true;
        }
        return super.verifyBinExtents(binStart, binEnd, dataRange, binNames);
    }

    @Override
    protected boolean hasRangeChanged(byte dim) {
        if (1 == dim || this.bivariate && 2 == dim) {
            return false;
        }
        return super.hasRangeChanged(dim);
    }

    @Override
    protected boolean buildBiVariateBins() {
        if (this.filter == null || this.filter.getNumberObservations(-1) < 1) {
            return false;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
        if (xVar == null || yVar == null || responseVar == null) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        int yVarIndex = this.filter.getVariableIndex(yVar);
        int responseVarIndex = this.filter.getVariableIndex(responseVar);
        if (xVarIndex < 0 || yVarIndex < 0 || responseVarIndex < 0) {
            return false;
        }
        if (this.filter.getNumberObservations(xVarIndex) > this.MAX_NUM_X_BINS || this.filter.getNumberObservations(yVarIndex) > this.MAX_NUM_Y_BINS) {
            return false;
        }
        SortContext xSortContext = SortContextFactory.getSortContext((Object)this.filter, (String)xVar.toString(), (int)1);
        SortContext ySortContext = SortContextFactory.getSortContext((Object)this.filter, (String)yVar.toString(), (int)1);
        double[] temp = new double[3];
        this.xBins = this.createBins(xVar, this.xValues, this.xBins, this.xBinIndices, this.xBinNames, xSortContext, temp);
        this.xBinStart = temp[0];
        this.xBinEnd = temp[1];
        this.xBinWidth = temp[2];
        this.numberOfBins_X = this.xBins.size();
        this.yBins = this.createBins(yVar, this.yValues, this.yBins, this.yBinIndices, this.yBinNames, ySortContext, temp);
        this.yBinStart = temp[0];
        this.yBinEnd = temp[1];
        this.yBinWidth = temp[2];
        this.numberOfBins_Y = this.yBins.size();
        this.missingValues = 0.0;
        this.missingIndex = -1;
        this.missingXBinValues = new double[this.numberOfBins_Y];
        this.missingXValuesIndex = new int[this.numberOfBins_Y];
        this.missingYBinValues = new double[this.numberOfBins_X];
        this.missingYValuesIndex = new int[this.numberOfBins_X];
        this.bivariateBinValues = new double[this.numberOfBins_X][this.numberOfBins_Y];
        this.bivariateBinIndex = new int[this.numberOfBins_X][this.numberOfBins_Y];
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double xValue = this.filter.getNumericValue(xVarIndex, (long)i);
            int xBin = this.getBinIndex(this.xBins, this.xBinIndices, this.xBinNames, this.xBinStart, this.xBinEnd, xValue, i);
            double yValue = this.filter.getNumericValue(yVarIndex, (long)i);
            int yBin = this.getBinIndex(this.yBins, this.yBinIndices, this.yBinNames, this.yBinStart, this.yBinEnd, yValue, i);
            double binValue = this.filter.getNumericValue(responseVarIndex, (long)i);
            if (-3 == xBin || -3 == yBin) {
                if (-3 == xBin && -3 == yBin) {
                    this.missingValues = binValue;
                    this.missingIndex = i;
                    continue;
                }
                if (-3 == xBin && yBin >= 0) {
                    this.missingXBinValues[yBin] = binValue;
                    this.missingXValuesIndex[yBin] = i;
                    continue;
                }
                if (-3 != yBin || xBin < 0) continue;
                this.missingYBinValues[xBin] = binValue;
                this.missingYValuesIndex[xBin] = i;
                continue;
            }
            if (xBin < 0 || yBin < 0) continue;
            this.bivariateBinValues[xBin][yBin] = binValue;
            this.bivariateBinIndex[xBin][yBin] = i;
        }
        return true;
    }

    @Override
    protected boolean buildUniVariateBins() {
        if (this.filter == null || this.filter.getNumberObservations(-1) < 1) {
            return false;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        if (xVarIndex < 0) {
            return false;
        }
        Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
        int responseVarIndex = this.filter.getVariableIndex(responseVar);
        if (responseVar == null || responseVarIndex < 0) {
            return false;
        }
        if (this.filter.getNumberObservations(xVarIndex) > this.MAX_NUM_X_BINS) {
            return false;
        }
        SortContext xSortContext = SortContextFactory.getSortContext((Object)this.filter, (String)xVar.toString(), (int)1);
        double[] temp = new double[3];
        this.xBins = this.createBins(xVar, this.xValues, this.xBins, this.xBinIndices, this.xBinNames, xSortContext, temp);
        this.xBinStart = temp[0];
        this.xBinEnd = temp[1];
        this.xBinWidth = temp[2];
        this.numberOfBins_X = this.xBins.size();
        this.univariateBinValues = new double[this.numberOfBins_X];
        this.univariateBinIndex = new int[this.numberOfBins_X];
        this.missingValues = 0.0;
        this.missingIndex = -1;
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double d1 = this.filter.getNumericValue(xVarIndex, (long)i);
            double binValue = this.filter.getNumericValue(responseVarIndex, (long)i);
            if (Double.isNaN(d1)) {
                this.missingValues = binValue;
                this.missingIndex = i;
                continue;
            }
            int xBin = this.getBinIndex(this.xBins, this.xBinIndices, this.xBinNames, this.xBinStart, this.xBinEnd, d1, i);
            AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)this.xBins.get(new Integer(xBin));
            if (b == null) continue;
            b.setCount(binValue);
            this.univariateBinValues[xBin] = binValue;
            this.univariateBinIndex[xBin] = i;
        }
        return true;
    }

    protected LinkedHashMap createBins(Object var, int valuesType, LinkedHashMap bins, LinkedHashMap binIndices, double[] binNames, SortContext sortContext, double[] metaData) {
        if (var == null || this.filter == null) {
            return null;
        }
        int varIndex = this.filter.getVariableIndex(var);
        if (varIndex < 0) {
            return null;
        }
        if (bins == null) {
            bins = new LinkedHashMap<Integer, AbstractHistogramElement.Bin>();
        } else {
            bins.clear();
        }
        binIndices.clear();
        if (binNames != null) {
            metaData[0] = binNames[0];
            metaData[1] = binNames[binNames.length - 1];
            metaData[2] = Double.NaN;
        } else {
            metaData = this.getBinMeta(var, valuesType, sortContext, metaData);
            switch (valuesType) {
                default: {
                    metaData[0] = metaData[0] - metaData[2] / 2.0;
                    metaData[1] = metaData[1] + metaData[2] / 2.0;
                    break;
                }
                case 1: {
                    metaData[1] = metaData[1] + metaData[2];
                    break;
                }
                case 2: {
                    metaData[0] = metaData[0] - metaData[2];
                }
            }
        }
        if (binNames != null) {
            for (int i = 0; i < binNames.length - 1; ++i) {
                AbstractHistogramElement.Bin b = new AbstractHistogramElement.Bin();
                b.setIndex(i);
                b.setCount(0.0);
                b.setMin(binNames[i]);
                b.setMax(binNames[i + 1]);
                bins.put(new Integer(i), b);
            }
        } else {
            int binIndex = 0;
            for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                double d1 = this.filter.getNumericValue(varIndex, (long)i, sortContext);
                if (Double.isNaN(d1)) continue;
                AbstractHistogramElement.Bin b = new AbstractHistogramElement.Bin();
                b.setIndex(binIndex);
                b.setCount(0.0);
                switch (valuesType) {
                    default: {
                        b.setMin(d1 - metaData[2] / 2.0);
                        b.setMax(d1 + metaData[2] / 2.0);
                        break;
                    }
                    case 1: {
                        b.setMin(d1);
                        b.setMax(d1 + metaData[2]);
                        break;
                    }
                    case 2: {
                        b.setMin(d1 - metaData[2]);
                        b.setMax(d1);
                    }
                }
                bins.put(new Integer(binIndex), b);
                int si = sortContext.getSortedIndex(i, this.filter);
                binIndices.put(new Integer(si), new Integer(binIndex));
                ++binIndex;
            }
        }
        return bins;
    }

    protected double[] getBinMeta(Object var, int valuesType, SortContext sortContext, double[] binMeta) {
        if (this.filter == null || this.infoFilter == null || var == null) {
            return null;
        }
        int varIndex = this.filter.getVariableIndex(var);
        if (varIndex < 0) {
            return null;
        }
        double min = 0.0;
        double max = 0.0;
        double binWidth = Double.POSITIVE_INFINITY;
        Object o = this.infoFilter.getMinimumValue(var, true);
        if (o instanceof Number) {
            min = ((Number)o).doubleValue();
        }
        if ((o = this.infoFilter.getMaximumValue(var, true)) instanceof Number) {
            max = ((Number)o).doubleValue();
        }
        double err = (max - min) / 100000.0;
        for (int i = 0; i < this.filter.getNumberObservations(-1) - 1; ++i) {
            double d1 = this.filter.getNumericValue(varIndex, (long)i, sortContext);
            double d2 = this.filter.getNumericValue(varIndex, (long)(i + 1), sortContext);
            if (Double.isNaN(d1) || Double.isNaN(d2) || !(d2 - d1 > err)) continue;
            binWidth = Math.min(binWidth, Math.abs(d2 - d1));
        }
        if (Double.POSITIVE_INFINITY == binWidth) {
            binWidth = 2.0;
        }
        binMeta[0] = min;
        binMeta[1] = max;
        binMeta[2] = binWidth;
        return binMeta;
    }

    protected int getBinIndex(LinkedHashMap bins, LinkedHashMap binIndices, double[] binNames, double binStart, double binEnd, double value, int obsIndex) {
        Object o;
        if (binNames != null) {
            if (Double.isNaN(value)) {
                return -3;
            }
            if (bins == null) {
                return -1;
            }
            if (value < binStart) {
                return -1;
            }
            for (int i = 0; i < bins.size(); ++i) {
                AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
                if (!b.contains(value, this.xBoundary)) continue;
                return i;
            }
            if (value <= binEnd) {
                return bins.size() - 1;
            }
            return -2;
        }
        if (binIndices != null && (o = binIndices.get(new Integer(obsIndex))) instanceof Number) {
            return ((Number)o).intValue();
        }
        return -3;
    }

    @Override
    protected LinkedHashMap buildBinSelectionCountMap(SelectionIterator selections) {
        LinkedHashMap<Integer, Serializable> binSelectionCount;
        block5: {
            Integer missingBinId;
            block4: {
                binSelectionCount = new LinkedHashMap<Integer, Serializable>();
                if (selections == null || !selections.hasMoreSelections()) {
                    return binSelectionCount;
                }
                missingBinId = new Integer(-3);
                if (!this.bivariate || this.bivariateBinValues == null) break block4;
                int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
                int yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
                while (selections.hasMoreSelections()) {
                    int index = selections.nextSelectedIndex();
                    double xValue = this.filter.getNumericValue(xVarIndex, (long)index);
                    int xBinIndex = this.getBinIndex(this.xBins, this.xBinIndices, this.xBinNames, this.xBinStart, this.xBinEnd, xValue, index);
                    Integer xBinId = new Integer(xBinIndex);
                    double yValue = this.filter.getNumericValue(yVarIndex, (long)index);
                    int yBinIndex = this.getBinIndex(this.yBins, this.yBinIndices, this.yBinNames, this.yBinStart, this.yBinEnd, yValue, index);
                    Integer yBinId = new Integer(yBinIndex);
                    if (!binSelectionCount.containsKey(xBinId)) {
                        binSelectionCount.put(xBinId, new LinkedHashMap());
                    }
                    double binValue = 0.0;
                    binValue = missingBinId.equals(xBinId) && missingBinId.equals(yBinId) ? this.missingValues : (missingBinId.equals(xBinId) && !missingBinId.equals(yBinId) ? this.missingXBinValues[yBinIndex] : (!missingBinId.equals(xBinId) && missingBinId.equals(yBinId) ? this.missingYBinValues[xBinIndex] : this.bivariateBinValues[xBinIndex][yBinIndex]));
                    LinkedHashMap bsc2 = (LinkedHashMap)binSelectionCount.get(xBinId);
                    bsc2.put(yBinId, new Double(binValue));
                }
                break block5;
            }
            if (this.univariateBinValues == null) break block5;
            int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
            while (selections.hasMoreSelections()) {
                int index = selections.nextSelectedIndex();
                double xValue = this.filter.getNumericValue(xVarIndex, (long)index);
                int xBinIndex = this.getBinIndex(this.xBins, this.xBinIndices, this.xBinNames, this.xBinStart, this.xBinEnd, xValue, index);
                Integer binId = new Integer(xBinIndex);
                double binValue = 0.0;
                binValue = missingBinId.equals(binId) ? this.missingValues : this.univariateBinValues[xBinIndex];
                binSelectionCount.put(binId, new Double(binValue));
            }
        }
        return binSelectionCount;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        DataRange range = null;
        while (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
            if (role == null) continue;
            if (!this.bivariate && role != null && RoleInterface.ROLE_RESPONSE.equals(role)) {
                if (this.univariateBinValues == null) continue;
                double min = 0.0;
                double max = 0.0;
                for (int i = 0; i < this.univariateBinValues.length; ++i) {
                    if (Double.isNaN(this.univariateBinValues[i])) continue;
                    max = Math.max(this.univariateBinValues[i], max);
                }
                if (this.missingBinOn && !Double.isNaN(this.missingValues)) {
                    max = Math.max(this.missingValues, max);
                }
                range = RangeMerger.mergeRange(range, (DataRange)new ContinuousRange(min, max));
                continue;
            }
            if (this.bivariate && role != null && RoleInterface.ROLE_Y.equals(role)) {
                if (Double.isNaN(this.yBinStart) || Double.isNaN(this.yBinEnd)) continue;
                range = RangeMerger.mergeRange(range, (DataRange)new ContinuousRange(this.yBinStart, this.yBinEnd));
                continue;
            }
            if (role == null || !RoleInterface.ROLE_X.equals(role) || Double.isNaN(this.xBinStart) || Double.isNaN(this.xBinEnd)) continue;
            range = RangeMerger.mergeRange(range, (DataRange)new ContinuousRange(this.xBinStart, this.xBinEnd));
        }
        if (range != null) {
            return range;
        }
        return super.getPreferredRange(which);
    }

    @Override
    protected String getStatTipValue(double value) {
        StringBuffer sb = new StringBuffer();
        Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
        Object desc = this.filter.getVariableDescription(responseVar);
        sb.append(desc);
        sb.append(" \t=\t");
        sb.append(this.getFormattedValue(responseVar, new Double(value)));
        sb.append("\n");
        return sb.toString();
    }

    protected int getObsIndex(AbstractHistogramElement.Bin xBin, AbstractHistogramElement.Bin yBin) {
        int obsIndex = -1;
        obsIndex = this.bivariate ? (xBin != null && yBin != null ? this.bivariateBinIndex[xBin.getIndex()][yBin.getIndex()] : (xBin == null && yBin != null ? this.missingXValuesIndex[yBin.getIndex()] : (xBin != null && yBin == null ? this.missingYValuesIndex[xBin.getIndex()] : this.missingIndex))) : (xBin != null && !Double.isNaN(xBin.getMin()) && !Double.isNaN(xBin.getMax()) ? this.univariateBinIndex[xBin.getIndex()] : this.missingIndex);
        return obsIndex;
    }

    @Override
    protected String getAdditionalTipText(AbstractHistogramElement.Bin xBin, AbstractHistogramElement.Bin yBin, double value) {
        StringBuffer sb = new StringBuffer();
        int obsIndex = this.getObsIndex(xBin, yBin);
        Object[] tipVars = (Object[])this.roles.getAllVariables((Object)this.tipRole);
        if (tipVars != null && tipVars.length > 0 && obsIndex >= 0) {
            for (int i = 0; i < tipVars.length; ++i) {
                Object desc = this.filter.getVariableDescription(tipVars[i]);
                if (desc == null) continue;
                sb.append(desc);
                sb.append(" \t=\t");
                sb.append(this.getFormattedValue(tipVars[i], obsIndex));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 830: {
                if (value instanceof Number) {
                    this.setXValuesType(((Number)value).intValue());
                    break;
                }
                if (value == null) break;
                this.setValuesType((byte)1, value.toString());
                break;
            }
            case 831: {
                if (value instanceof Number) {
                    this.setYValuesType(((Number)value).intValue());
                    break;
                }
                if (value == null) break;
                this.setValuesType((byte)2, value.toString());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 829: {
                rc = Boolean.TRUE;
                break;
            }
            case 828: {
                rc = Boolean.FALSE;
                break;
            }
            case 830: {
                rc = new Integer(this.xValues);
                break;
            }
            case 831: {
                rc = new Integer(this.yValues);
                break;
            }
            case 810: {
                rc = this.xBinNames != null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 811: {
                rc = this.yBinNames != null || this.roles.getVariable((Object)this.yRole, 0) == null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19052: {
                if (this.bivariate) {
                    rc = super.getPropertyValue(id);
                    break;
                }
                if (this.filter == null) break;
                rc = this.filter.getVariableDescription(this.roles.getVariable((Object)this.responseRole, 0));
                break;
            }
            case 19056: {
                Object[] objectArray;
                if (this.bivariate) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = RoleInterface.ROLE_Y;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = RoleInterface.ROLE_RESPONSE;
                }
                rc = objectArray;
                break;
            }
            case 19054: {
                Object var = this.roles.getVariable((Object)this.responseRole, 0);
                if (var == null || this.filter == null) break;
                rc = this.filter.getFormat(var, SASFormat.class);
                break;
            }
            case 19078: {
                if (this.roles.getVariable((Object)this.xRole, 0) != null && this.roles.getVariable((Object)this.responseRole, 0) != null && this.filter != null && this.filter.getNumberObservations(this.roles.getVariable((Object)this.xRole, 0)) <= this.MAX_NUM_X_BINS) {
                    rc = Boolean.TRUE;
                    break;
                }
                rc = Boolean.FALSE;
                break;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                if (xVar == null) {
                    v.addElement(new Integer(2));
                }
                if (this.roles.getVariable((Object)this.responseRole, 0) == null) {
                    v.addElement(new Integer(5));
                }
                if (this.filter != null && xVar != null && this.filter.getNumberObservations(xVar) > this.MAX_NUM_X_BINS) {
                    v.addElement(new Integer(7));
                }
                if (this.bivariate && this.filter != null && this.filter.getNumberObservations(this.roles.getVariable((Object)this.yRole, 0)) > this.MAX_NUM_Y_BINS) {
                    v.addElement(new Integer(8));
                }
                if (v.size() <= 0) break;
                int[] errIds = new int[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    errIds[i] = ((Number)v.elementAt(i)).intValue();
                }
                rc = errIds;
                break;
            }
            default: {
                return super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected SILKNumber getLegendName() {
        if (this.filter == null) {
            return null;
        }
        Object var = this.roles.getVariable((Object)this.responseRole, 0);
        Object desc = this.filter.getVariableDescription(var);
        if (desc == null) {
            return null;
        }
        return new SILKNumber(0, desc.toString(), desc.toString());
    }

    @Override
    protected String getLegendDisplayName() {
        return this.getLegendName().toString();
    }

    @Override
    protected double computePercentage(double val) {
        return val;
    }

    @Override
    protected void setRole(RoleEvent e) {
    }

    @Override
    protected void removeRole(RoleEvent e) {
    }

    public int getXValuesType() {
        return this.xValues;
    }

    public void setXValuesType(int values) {
        switch (values) {
            case 0: 
            case 2: {
                this.xBoundary = 1;
                break;
            }
            case 1: {
                this.xBoundary = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.xValues = values;
        this.userSetProperties.set(830);
        this.resetChart();
        this.build(Boolean.TRUE);
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
    }

    protected void setValuesType(byte dim, String values) {
        if (values == null) {
            return;
        }
        int vals = this.xValues;
        if ("Midpoints".equalsIgnoreCase(values)) {
            vals = 0;
        } else if ("Leftpoints".equalsIgnoreCase(values)) {
            vals = 1;
        } else if ("Rightpoints".equalsIgnoreCase(values)) {
            vals = 2;
        } else {
            return;
        }
        if (dim == 1) {
            this.setXValuesType(vals);
        } else if (dim == 2) {
            this.setYValuesType(vals);
        }
    }

    public int getYValuesType() {
        return this.yValues;
    }

    public void setYValuesType(int values) {
        switch (values) {
            case 0: 
            case 2: {
                this.yBoundary = 1;
                break;
            }
            case 1: {
                this.yBoundary = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.yValues = values;
        this.userSetProperties.set(831);
        if (this.bivariate) {
            this.resetChart();
            this.build(Boolean.TRUE);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
    }

    @Override
    public void setXBinNames(double[] binNames) {
        if (this.validateBinNames(binNames)) {
            this.resetChart();
        }
        super.setXBinNames(binNames);
    }

    @Override
    protected Object[] getTicks(LinkedHashMap bins, int nBins, double binStart, double binEnd, double binWidth, double[] binNames, ContinuousRange range) {
        if (bins == null || bins.size() < 1 || binStart == binEnd) {
            return null;
        }
        if (binNames != null) {
            return super.getTicks(bins, nBins, binStart, binEnd, binWidth, binNames, range);
        }
        Object[] ticks = null;
        if (this.endLabelsOn) {
            int i;
            Vector<Double> v = new Vector<Double>();
            double err = (binEnd - binStart) / 100000.0;
            double last = Double.POSITIVE_INFINITY;
            for (i = 0; i < nBins; ++i) {
                AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
                if (Math.abs(b.getMin() - last) > err) {
                    v.addElement(new Double(b.getMin()));
                }
                v.addElement(new Double(b.getMax()));
                last = b.getMax();
            }
            if (range != null && range.getMin() < binStart) {
                for (double d = binStart - binWidth; d >= range.getMin(); d -= binWidth) {
                    v.insertElementAt(new Double(d), 0);
                }
            }
            if (range != null && range.getMax() > binEnd) {
                for (double d = binEnd + binWidth; d <= range.getMax(); d += binWidth) {
                    v.addElement(new Double(d));
                }
            }
            ticks = new Object[v.size()];
            for (i = 0; i < v.size(); ++i) {
                ticks[i] = v.elementAt(i);
            }
        } else {
            double firstMid = Double.POSITIVE_INFINITY;
            double lastMid = Double.NEGATIVE_INFINITY;
            Vector<Double> v = new Vector<Double>();
            for (int i = 0; i < nBins; ++i) {
                AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
                double mid = (b.getMin() + b.getMax()) / 2.0;
                v.addElement(new Double(mid));
                firstMid = Math.min(firstMid, mid);
                lastMid = Math.max(lastMid, mid);
            }
            if (range != null && range.getMin() < firstMid) {
                for (double d = firstMid - binWidth; d >= range.getMin(); d -= binWidth) {
                    v.insertElementAt(new Double(d), 0);
                }
            }
            if (range != null && range.getMax() > lastMid) {
                for (double d = lastMid + binWidth; d <= range.getMax(); d += binWidth) {
                    v.addElement(new Double(d));
                }
            }
            ticks = new Object[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                ticks[i] = v.elementAt(i);
            }
        }
        return ticks;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (this.xRole.equals(role) && value instanceof Number) {
            this.MAX_NUM_X_BINS = ((Number)value).intValue();
        }
        if (this.yRole.equals(role) && value instanceof Number) {
            this.MAX_NUM_Y_BINS = ((Number)value).intValue();
        }
        return super.setLimit(role, value);
    }
}

